/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/xfm_slc.v#1 $
*/

APPS.MultiWindowApp Xform_Slice<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=300.,NEy=55.>  {
      demo_text = "This example shows the use of the xform_to_plane macro. The xform_to_plane macro sets the transformation on a field to be inverse transformation of a plane.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D<NEx=121.,NEy=220.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,<-.<-.<-.slice_plane.out_obj_slice};
            Xform {
               mat = {
                  0.0684347,-0.0144789,0.051108,0.,0.0115695,0.0854128,0.00870569,
0.,-0.0518442,-5.17192e-05,0.0694058,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-4.,-4.};
            };
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 150;
                        defaultY = 350;
                        defaultWidth = 406;
                        defaultHeight = 406;
                     };
                  };
               };
            };
         };
      };
      Scene_Selector {
         input_views => {Scene.View.View, <-.Scene#1.View.View};
      };
      Scene_Editor {
         View_Editor {
            GDview_edit {
               renderer = 1;
            };
         };
         Light_Editor {
            GDlinfo_edit {
               sel_light => Scene.Lights.Lights[0];
            };
            GDlight_edit {
               type = 0;
            };
         };
      };
      GDM.Uscene3D Scene#1 {
         Top {
            child_objs<NEportLevels={4,1}> => {
               <-.<-.<-.xform_to_plane.out_obj};
            Xform {
               mat = {
                  0.101541,0.,0.,0.,0.,0.101541,0.,0.,0.,0.,0.101541,0.,
0.,0.,0.,1.
               };
               xlate = {1.8947,-3.34064,-0.119875};
            };
         };
         Lights {
            Lights = {
               {
                  type=3
               },,,};
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 250;
                        defaultY = 0;
                        defaultWidth = 406;
                        defaultHeight = 406;
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_Field Read_Field<NEx=77.,NEy=33.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };
   MODS.slice_plane slice_plane<NEx=209.,NEy=110.> {
      in_field => <-.Read_Field.field;
      plane {
         xform {
            xlate = {0.,0.,31.5};
            mat = {
               -0.85509,0.383153,0.349307,0.,0.391304,0.918901,-0.0500429,0.,
-0.340152,0.0938939,-0.935672,0.,0.,0.,0.,1.
            };
         };
      };
   };
   MODS.bounds bounds<NEx=44.,NEy=121.> {
      in_field => <-.Read_Field.field;
   };
   MODS.xform_to_plane xform_to_plane<NEx=286.,NEy=187.> {
      in_field => <-.slice_plane.out_fld;
      in_plane => <-.slice_plane.out_plane;
   };
};
