/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_macro.v#1 $
*/

// currently can't be buffered with edit_lic property
flibrary+global+sort DV_MACROS <edit_lic="DV",
				indexed=1,
				compile_subs=0> {

/*****************************************************************************/
/*									     */
/* Data Visualization Macros						     */
/*									     */
/*****************************************************************************/

group+Port DV_Param_read_img2vol {
    string+Port2 filename_head;
    string+Port2 filename_tail;
    int+Port2    min_length;
    int+Port2    format;
    int+Port2    start;
    int+Port2    end;
    int+Port2    out_format;
};

group+Port DV_Param_axis {
	float+nres+Port2  start<animate=1>;
	float+nres+Port2  end<animate=1>;
	float+nres+Port2  limits[2]=>{start,end};
	float+nres+Port2  ref<animate=1>;
	float+nres+Port2  step<animate=1>;
	float+nres+Port2  tick_y_below<animate=1>;
	float+nres+Port2  tick_y_above<animate=1>;
	float+nres+Port2  tick_z_below<animate=1>;
	float+nres+Port2  tick_z_above<animate=1>;
	int+Port2   minor_ticks<animate=1>;
	float+Port2 minor_scale<animate=1>;
	int+Port2   ndig<animate=1>;
	float+nres+Port2 y_anno<animate=1>;
	float+nres+Port2 z_anno<animate=1>;
	string+Port2     axis_name<animate=1>;
	string+Port2     axis_labels<animate=1>[];
};

group+Port DV_Param_downsize {
	float+Port2 factor0<animate=1>;
	float+Port2 factor1<animate=1>;
	float+Port2 factor2<animate=1>;
	float+Port2 factor[3] => {factor0, factor1, factor2};
};

group+Port DV_Param_crop {
	int+Port2 min<animate=1>[];
	int+Port2 max<animate=1>[];
};

group+Port DV_Param_extr_comp {
	int+Port2 component<animate=1>;
};

group+Port DV_Param_set_null {
	int+Port2 component<animate=1>;
	int+Port2 unset<animate=1>;
	float+Port2 null_value<animate=1>;
};

group+Port DV_Param_cell_to_node {
	int+Port2 comps<animate=1>[];
	int+Port2 order<animate=1>;
};

group+Port DV_Param_mirror {
	int+Port2 x_axis<animate=1>;
	int+Port2 y_axis<animate=1>;
	int+Port2 z_axis<animate=1>;
};

group+Port DV_Param_scale {
	float+Port2 scale_x<animate=1>;
	float+Port2 scale_y<animate=1>;
	float+Port2 scale_z<animate=1>;
};

group+Port DV_Param_comb_comp {
	int+Port2 comp1<animate=1>[];
	int+Port2 comp2<animate=1>[];
};

group+Port DV_Param_surf_plot {
	int+Port2 component<animate=1>;
	int+Port2 nspace<animate=1>;
	float+Port2 scale<animate=1>;
	float+Port2 offset<animate=1>;
};

group+Port DV_Param_surf_ribbons {
	int+Port2 ribbon_dir<animate=1>;
	int+Port2 height_comp<animate=1>;
	int+Port2 map_comp<animate=1>;
	float+Port2 scale<animate=1>;
	float+Port2 offset<animate=1>;
};

group+Port DV_Param_texture_mesh {
	int+Port2   uv_switch<animate=1>;
	int+Port2   u_flip<animate=1>;
	int+Port2   v_flip<animate=1>;
	float+Port2 u_scale<animate=1>;
	float+Port2 v_scale<animate=1>;
	float+Port2 u_shift<animate=1>;
	float+Port2 v_shift<animate=1>;
};

group+Port DV_Param_offset {
	int+Port2 component<animate=1>;
	float+Port2 scale<animate=1>;
};

group+Port DV_Param_ortho_slice {
	int+Port2 axis<animate=1>;
	int+Port2 plane<animate=1>;
};

group+Port DV_Param_integr {
	int+Port2 component<animate=1>;
	int+Port2 dim<animate=1>;
};

group+Port DV_Param_glyph {
	int+IPort2 glyph_comp<animate=1>;
	int+IPort2 map_comp<animate=1>;
	int+IPort2 scale_comp<animate=1>;
	int+IPort2 vector<animate=1>;
	float+IPort2 scale<animate=1>;
	int+IPort2 scale_x<animate=1>;
	int+IPort2 scale_y<animate=1>;
	int+IPort2 scale_z<animate=1>;
	int+IPort2 normalize<animate=1>;
};

DV_Param_glyph DV_Param_city {
	float+IPort2 x_scale<animate=1>;
	float+IPort2 y_scale<animate=1>;
};

group+Port DV_Param_geo_glyph {
	float+IPort2 scale<animate=1>;
	float+IPort2 color_r<animate=1>;
	float+IPort2 color_g<animate=1>;
	float+IPort2 color_b<animate=1>;
	int+IPort2   normalize<animate=1>;
};

group+Port DV_Param_interp {
	int+IPort2 components<animate=1>[];
};

group+Port DV_Param_contour {
	int+Port2 contour_comp<animate=1>;
	int+Port2 ncontours<animate=1>;
	float+Port2 level_min<animate=1>;
	float+Port2 level_max<animate=1>;
	int+Port2 map_comp<animate=1>[];
	int+Port2 color<animate=1>;
	int+Port2 contour_lines<animate=1>;
};

group DV_Param_iso_vol {
	int+Port2  iso_component<animate=1>;
	float+Port2 iso_level<animate=1>;
	int+Port2   map_component<animate=1>[];
	int+Port2   above<animate=1>;
	int+Port2   cell_data<animate=1>[];
};

group+Port DV_Param_plane_crop {
	int+IPort2 in_out<animate=1>;
	int+IPort2 and_or<animate=1>;
};

group+Port DV_Param_crop_box {
	int+IPort2 inside<animate=1>;
	int+IPort2 xform_together<animate=1>;
};

group+Port DV_Param_stream {
	int+IPort2 component<animate=1>;
	int+IPort2 order<animate=1>;
	int+IPort2 forw_back<animate=1>;
	int+IPort2 nseg<animate=1>;
	int+IPort2 max_seg<animate=1>;
	float+IPort2 min_vel<animate=1>;
	int+IPort2 color<animate=1>;
	int+IPort2 ribbons<animate=1>;
	float+IPort2 rib_width<animate=1>;
	float+IPort2 rib_angle<animate=1>;
};

group+Port DV_Param_exc_brick {
	int+IPort2 x<animate=1>;
	int+IPort2 y<animate=1>;
	int+IPort2 z<animate=1>;
	int+IPort2 flip_x<animate=1>;
	int+IPort2 flip_y<animate=1>;
	int+IPort2 flip_z<animate=1>;
	int+IPort2 draw_sides<animate=1>;
};

group DV_Param_iso {
	int+Port2  iso_component<animate=1>;
	float+nres+Port2  iso_level<animate=1>;
	int+Port2   map_component<animate=1>[];
	int+Port2   cell_data<animate=1>[];
	int+Port2 color<animate=1>;
};

group DV_Param_isonest<NEportLevels={0,1}> {
	float min<animate=1>;          // lower range boundary
	float max<animate=1>;          // upper range boundary
	int num_levels<animate=1>;     // number of isosurfaces
	int num_component<animate=1>;  // which data component to use
	float transparency<animate=1>; // base transparency level
	int   trans_ramp<animate=1>;   // transparency - all the same or ramped
	float ramp_delta<animate=1>;   // width of range to vary transparency
};

group DV_Param_slice {
	int+Port2  component<animate=1>[];
	float+Port2  dist<animate=1>;
	int+Port2   cell_data<animate=1>[];
};

group DV_Param_slice_ortho {
    // Orthoslice parameters
    int+Port2 axis<animate=1>;
    // Construct an array, one slot for each plane?
    float+Port2 plane<animate=1>;
    // Slice parameters
    int+Port2  component<animate=1>[];
    int+Port2  cell_data<animate=1>[];
};

group DV_Param_cut {
	int+Port2  component<animate=1>[];
	float+Port2  dist<animate=1>;
	int+Port2   above<animate=1>;
	int+Port2   cell_data<animate=1>[];
};

group DV_Param_extract_scalar {
	int+Port2   vector<animate=1>;
	int+Port2   component<animate=1>;
};

group DV_Param_combine_vect {
	int+Port2 veclen<animate=1>;
	int+Port2 components<animate=1>[];
	int+Port2 sub_components<animate=1>[];
};

group DV_Param_thresh {
	int+Port2 check_vector<animate=1>;
	int+Port2 check_comp<animate=1>;
	int+Port2 thresh_vector<animate=1>;
	int+Port2 below<animate=1>;
	int+Port2 above<animate=1>;
	float+Port2  min_value<animate=1>;
	float+Port2  max_value<animate=1>;
	float+Port2  null_value<animate=1>;
};

group DV_Param_clamp {
	int+Port2 vector<animate=1>;
	int+Port2 component<animate=1>;
	int+Port2 below<animate=1>;
	int+Port2 above<animate=1>;
	int+Port2 reset_minmax<animate=1>;
	float+Port2  min_value<animate=1>;
	float+Port2  max_value<animate=1>;
};

group DV_Param_scat_2_unif {
	int+Port2 component<animate=1>;
	int+Port2 interp_order<animate=1>;
	int+Port2 rndim<animate=1>;
	int+Port2 dim1<animate=1>;
	int+Port2 dim2<animate=1>;
	int+Port2 dim3<animate=1>;
	int+nres dim_arr[3] => {dim1, dim2, dim3};
	int+nres rdims[rndim] => dim_arr[0:rndim-1];
	float+nres+Port2 min_xyz[rndim];
	float+nres+Port2 max_xyz[rndim];
	int+Port2 search_dist1<animate=1>;
	int+Port2 search_dist2<animate=1>;
	int+Port2 search_dist3<animate=1>;
	int search_arr[3] => {search_dist1, search_dist2, search_dist3};
	int+nres search_cube[rndim] => search_arr[0:rndim-1];
	float+nres+Port2 null_value<animate=1>;
};

group DV_Param_probe {
	int+Port2 component<animate=1>;
	float+Port2 scale<animate=1>;
	int+Port2 normalize<animate=1>;
};

group DV_Param_probe_o {
	int+nres+Port2 veclen;
	float+nres+Port2 value[veclen];
};

group DV_Param_iso_probe {
	int+Port2  iso_component<animate=1>;
	int+Port2   map_component<animate=1>;
	float+Port2 scale<animate=1>;
	int+Port2 normalize<animate=1>;
};

group DV_Param_advect {
	int+IPort2 component<animate=1>;
	int+IPort2 order<animate=1>;
	int+IPort2 forw_back<animate=1>;
	int+IPort2 nseg<animate=1>;
	int+IPort2 max_seg<animate=1>;
	float+IPort2 min_vel<animate=1>;
	int+IPort2 run<animate=1>;
	int+Port2 reset<animate=1>;
	int+IPort2 cycle<animate=1>;
	float+IPort2 start<animate=1>;
	float+IPort2 end<animate=1>;
	float+IPort2 incr<animate=1>;
	float+OPort2 count<animate=1>;
	double+OPort2 release_interval;
	int+IPort2 vector<animate=1>;
	float+IPort2 scale<animate=1>;
	float+IPort2 normalize<animate=1>;
};

group+Port DV_Param_bounds {
	int+IPort2 hull<animate=1>;
	int+IPort2 edges<animate=1>;
	int+IPort2 faces<animate=1>;
	int+IPort2 imin<animate=1>;
	int+IPort2 imax<animate=1>;
	int+IPort2 jmin<animate=1>;
	int+IPort2 jmax<animate=1>;
	int+IPort2 kmin<animate=1>;
	int+IPort2 kmax<animate=1>;
	int+IPort2 data<animate=1>;
	int+IPort2 component<animate=1>;
};

group+Port DV_Param_least_sq {
	int+Port2 component<animate=1>;
	int+Port2 order<animate=1>;
};

group+Port DV_Param_cyl_plot {
	int+IPort2	component<animate=1>;
	int+IPort2	vertical<animate=1>;
	int+IPort2	scale_height<animate=1>;
	int+IPort2	scale_radius<animate=1>;
	int+IPort2	color_sides<animate=1>;
	float+IPort2	radius<animate=1>;
	float+IPort2	scale<animate=1>;
	float+IPort2	angle<animate=1>;
	int+IPort2	nseg<animate=1>;
	float+IPort2    default_rgb<animate=1>[3];
};

group+Port DV_Param_separate_cells {
	int+IPort2	shrink<animate=1>;
	float+IPort2	scale<animate=1>;
};

group+Port DV_Param_extrude_cells {
	int+IPort2	height_comp<animate=1>;
	float+IPort2    scale<animate=1>;
	int+IPort2	shrink<animate=1>;
	float+IPort2	scale_factor<animate=1>;
	int+IPort2	draw_sides<animate=1>;
	int+IPort2	color_sides<animate=1>;
	int+IPort2	flip_sides_normals<animate=1>;
};

group+Port DV_Param_texture_sphere {
	int+IPort2	sphere_dims<animate=1>[];
	float+IPort2    longitude<animate=1>[2];
	float+IPort2    latitude<animate=1>[2];
	float+IPort2	radius<animate=1>;
};

group+Port DV_Param_minmax {
	int+IPort2	comp<animate=1>;
	double+Iparam   min<animate=1>;
	double+Iparam   max<animate=1>;
};

macro Iso {
	ilink in_fld<NEy=66,NEx=121>;
	DV_Param_iso+IPort2 &param<NEy=22,NEx=176>;

	DViso DViso<NEy=198,NEx=99> {
		in => in_fld;
		&level => param.iso_level;
		cell_data => param.cell_data;
		&component => param.iso_component;
	};

	DVnmap DVnmap<NEy=198,NEx=319> {
		in => in_fld;
		nparam => DViso.nparam;
		map_comp => param.map_component;
		iso_comp => param.iso_component;
		iso_val => param.iso_level;
	};

	DVcomb_mesh_and_data DVcomb_mesh_and_data<NEy=297,NEx=176> {
		in_mesh => DViso.out;
		in_nd => DVnmap.out;
	};

	olink out_fld<NEy=363,NEx=275> => DVcomb_mesh_and_data.out;
};

macro IsoSurfTrace {
	Mesh_Struct+Node_Data+IPort2 &in_fld<NEy=66,NEx=121>;
	ilink in_probe;
	DV_Param_iso+IPort2 &param<NEy=22,NEx=176>;

	DVextract_comp DVextract_comp<NEy=143,NEx=176> {
		in => in_fld;
		&component => param.iso_component;
	};

	DVisotrace  DVisotrace {
		in => DVextract_comp.out;
		probe => in_probe;
		&level => param.iso_level;
	};

	DVnmap DVnmap<NEy=198,NEx=319> {
		in => in_fld;
		nparam => DVisotrace.nparam;
		map_comp => param.map_component;
		iso_comp => param.iso_component;
		iso_val => param.iso_level;
	};

	DVcomb_mesh_and_data DVcomb_mesh_and_data<NEy=297,NEx=176> {
		in_mesh => DVisotrace.out;
		in_nd => DVnmap.out;
	};

	olink out_fld<NEy=363,NEx=275> => DVcomb_mesh_and_data.out;
};

macro Slice {
	ilink in_fld<NEy=77,NEx=44>;
	ilink in_pln<NEy=44,NEx=110>;
	DV_Param_slice+IPort2 &param<NEy=22,NEx=407>;

	DVplane_dist DVplane_dist {
		in => in_fld;
		plane => in_pln;
	};
	DVcomb_mesh_and_data DVcomb_mesh_and_data {
		in_mesh => in_fld;
		in_nd => DVplane_dist.out;
	};
	DViso DViso<NEy=341,NEx=297> {
		in => DVcomb_mesh_and_data.out;
		level => DVplane_dist.dist+param.dist;
	};
	DVnmap DVnmap {
		in => in_fld;
		nparam => DViso.nparam;
		map_comp => param.component;
	};
	DVcomb_mesh_and_data DVcomb_mesh_and_data_1 {
		in_mesh => DViso.out;
		in_nd => DVnmap.out;
	};

	olink out_fld<NEy=396,NEx=396> => DVcomb_mesh_and_data_1.out;
};

macro Cut {
	ilink in_fld<NEy=77,NEx=44>;
	ilink in_pln<NEy=44,NEx=110>;
	DV_Param_cut+IPort2 &param<NEy=22,NEx=407>;

	int+nres has_node_data => (is_valid(in_fld.nnode_data) && in_fld.nnode_data > 0);

	DVplane_dist DVplane_dist<NEy=154,NEx=99> {
		in => in_fld;
		plane => in_pln;
	};
	DVcomb_comp DVcomb_comp<NEy=275,NEx=176> {
		comp1+nres=> switch(<-.has_node_data, init_array(in_fld.nnode_data, 0, in_fld.nnode_data-1));
		comp2={0};
		nd1 => switch(<-.has_node_data, in_fld);
		nd2 => switch(<-.has_node_data, DVplane_dist.out);
	};
	DVcomb_mesh_and_data DVcomb_mesh_and_data {
		in_mesh => in_fld;
		in_nd => switch(<-.has_node_data+1, <-.DVplane_dist.out, <-.DVcomb_comp.out);
	};
	DVcut DVcut<NEy=341,NEx=297> {
		in => DVcomb_mesh_and_data.out;
		cut_comp+nres => switch(<-.has_node_data+1, 0, in_fld.nnode_data);
		map_comp+nres => switch(<-.has_node_data, param.component);
		level => DVplane_dist.dist+param.dist;
		&above => param.above;
		cell_data => param.cell_data;
	};
	olink out_fld<NEy=396,NEx=396> => DVcut.out;
};

macro ExtractScalar {
	ilink in_fld<NEy=88,NEx=55>;
	DV_Param_extract_scalar+IPort2 &param<NEy=66,NEx=198>;

	DVextract_comp DVextract_comp<NEy=154,NEx=110> {
		in => in_fld;
		component => param.vector;
	};

	DVextr_scalar DVextr_scalar<NEy=209,NEx=209> {
		in => DVextract_comp.out;
		&component => param.component;
	};

	DVcomb_mesh_and_data DVcomb_mesh_and_data<NEy=264,NEx=55> {
		in_mesh => in_fld;
		in_nd => DVextr_scalar.out;
	};

	olink out_fld<NEy=330,NEx=176> => DVcomb_mesh_and_data.out;
};

macro CombineVect {
	ilink in_fld<NEy=132,NEx=66>;
	DV_Param_combine_vect+IPort2 &param<NEy=55,NEx=198>;

	DVextr_vector DVextr_vector<NEy=132,NEx=198> {
		in => in_fld;
		&veclen => param.veclen;
		components => param.components[0:param.veclen-1];
		sub_components => param.sub_components[0:param.veclen-1];
	};

	DVcomb_mesh_and_data DVcomb_mesh_and_data<NEy=220,NEx=88> {
		in_mesh => in_fld;
		in_nd => DVextr_vector.out;
	};
	olink out_fld<NEy=297,NEx=187> => DVcomb_mesh_and_data.out;
};

macro Threshold {
	ilink in_fld<NEy=99,NEx=88>;
	DV_Param_thresh+IPort2 &param<NEy=33,NEx=209>;

	DVthreshold DVthreshold<NEy=132,NEx=209> {
		in => in_fld;
		&check_vector => param.check_vector;
		&check_comp => param.check_comp;
		&thresh_vector => param.thresh_vector;
		&below => param.below;
		&above => param.above;
		&min_value => param.min_value; 
		&max_value => param.max_value;
		&null_value => param.null_value;
	};

	DVcomb_mesh_and_data DVcomb_mesh_and_data<NEy=209,NEx=121> {
		in_mesh => in_fld;
		in_nd => DVthreshold.out;
	};
	olink out_fld<NEy=275,NEx=209> => DVcomb_mesh_and_data.out;
};


macro Clamp {
	ilink in_fld<NEy=88,NEx=55>;
	DV_Param_clamp+IPort2 &param<NEy=33,NEx=165>;

	DVextract_comp DVextract_comp<NEy=121,NEx=187> {
		in => in_fld;
		component => param.vector;
	};
	DVclamp  DVclamp<NEy=176,NEx=187> {
		in => DVextract_comp.out;
		&component => param.component;
		&below => param.below;
		&above => param.above;
		&reset_minmax => param.reset_minmax;
		&min_value => param.min_value;
		&max_value => param.max_value;
	};
	DVcomb_mesh_and_data DVcomb_mesh_and_data<NEy=253,NEx=110> {
		in_mesh => in_fld;
		in_nd => DVclamp.out;
	};
	olink out_fld<NEy=319,NEx=209> => DVcomb_mesh_and_data.out;
};

macro Filter_1d {
	ilink in_fld;
	ilink kernels;
	DV_Param_extr_comp+IPort2 &param;

	DVextract_comp DVextract_comp {
		in => in_fld;
		component => param.component;
	};
	DVfilter_1d  DVfilter_1d {
		in => DVextract_comp.out;
		kernels => <-.kernels;
	};
	DVcomb_mesh_and_data DVcomb_mesh_and_data {
		in_mesh => in_fld;
		in_nd => DVfilter_1d.out;
	};
	olink out_fld => DVcomb_mesh_and_data.out;
};

macro Least_Squares {
	ilink in_fld;
	DV_Param_least_sq+IPort2 &param;

	DVextract_comp DVextract_comp {
		in => in_fld;
		component => param.component;
	};
	DVleast_squares DVleast_squares {
		in => DVextract_comp.out;
		order => param.order;
	};

	olink out_fld => DVleast_squares.out;
	olink out_coeff => DVleast_squares.coeff;
};

macro Scat2Unif {
	ilink in_fld<NEy=66,NEx=55>;
	DV_Param_scat_2_unif+IPort2 &param<NEy=44,NEx=253>;

	DVextract_comp DVextract_comp<NEy=154,NEx=110> {
		in => in_fld;
		component => param.component;
	};
	DVscat_to_unif  DVscat_to_unif<NEy=242,NEx=264> {
		in => DVextract_comp.out;
		&rndim => param.rndim;
		rdims+nres => param.rdims;
		&interp_order => param.interp_order;
		min_xyz+nres => param.min_xyz;
		max_xyz+nres => param.max_xyz;
		search_cube+nres => param.search_cube;
		null_value => param.null_value;
	};
	olink out_fld<NEy=330,NEx=363> => DVscat_to_unif.out;
};

macro Probe {
	ilink in_fld;
	ilink pick;
	ilink in_probe;
	DV_Param_probe+IPort2 &param;
	DV_Param_probe_o+OPort2 oparam {
		&veclen => DVinterp_data.out.node_data[0].veclen;
		&value => DVinterp_data.out.node_data[0].values[0];
	};

	DVextract_comp DVextract_comp {
		in => in_fld;
		component => param.component;
	};
	DVprobe DVprobe {
		picked_fld+nres => pick.input;
		probe_fld => DVglyph.out;
		picked_xyz+nres => pick.pick_info.pick_data[0].point;
		picked_xform+nres => pick.xform;
	};

	Mesh fprobe {
		nnodes = 1;
		nspace = 3;
		coordinates {
			values => DVprobe.out_xyz;
		};
		&xform => DVprobe.probe_xform;
	};

	DVinterp_data DVinterp_data {
		in => DVextract_comp.out;
		probe => fprobe;
		comps[1] => {0};
	};
	DVglyph DVglyph {
		in => DVinterp_data.out;
		glyph => in_probe;
		glyph_comp = 0;
		map_comp = 0;
		scale_comp = 0;
		vector = 0;
		scale => param.scale;
		normalize => param.normalize;
		scale_x = 1;
		scale_y = 1;
		scale_z = 1;
		out {
			&xform+nonotify => fprobe.xform;
		};
	};

	olink out_fld => DVglyph.out;
	olink out_probe => DVinterp_data.out;
};

macro ProbeCell {
	ilink in_fld;
	ilink pick;
	ilink in_probe;
	DV_Param_probe+IPort2 &param;
	DV_Param_probe_o+OPort2 oparam {
		&veclen => DVinterp_cell_data.out.node_data[0].veclen;
		&value => DVinterp_cell_data.out.node_data[0].values[0];
	};

	DVextr_cell_comp DVextr_cell_comp {
		in => in_fld;
		comp => param.component;
	};
	DVprobe DVprobe {
		picked_fld+nres => pick.input;
		probe_fld => DVglyph.out;
		picked_xyz+nres => pick.pick_info.pick_data[0].point;
		picked_xform+nres => pick.xform;
	};

	Mesh fprobe {
		nnodes = 1;
		nspace = 3;
		coordinates {
			values => DVprobe.out_xyz;
		};
		&xform => DVprobe.probe_xform;
	};

	DVinterp_cell_data DVinterp_cell_data {
		in => DVextr_cell_comp.out;
		probe => fprobe;
		component = 0;
	};
	DVglyph DVglyph {
		in => DVinterp_cell_data.out;
		glyph => in_probe;
		glyph_comp = 0;
		map_comp = 0;
		scale_comp = 0;
		vector = 0;
		scale => param.scale;
		normalize => param.normalize;
		scale_x = 1;
		scale_y = 1;
		scale_z = 1;
		out {
			&xform+nonotify => fprobe.xform;
		};
	};

	olink out_fld => DVglyph.out;
	olink out_probe => DVinterp_cell_data.out;
};

macro IsoProbe {
	ilink in_fld;
	ilink pick;
	ilink in_probe;

	DV_Param_iso_probe+IPort2 &param;
	DV_Param_probe_o+OPort2 oparam {
		&veclen => DVinterp_data.out.node_data[0].veclen;
		&value => DVinterp_data.out.node_data[0].values[0];
	};

	DVextract_comp DVextract_comp {
		in => in_fld;
		component => param.iso_component;
	};
	DVprobe DVprobe {
		picked_fld+nres => pick.input;
		probe_fld => DVglyph.out;
		picked_xyz+nres => pick.pick_info.pick_data[0].point;
		picked_xform+nres => pick.xform;
	};

	Mesh fprobe {
		nnodes = 1;
		nspace = 3;
		coordinates {
			values => DVprobe.out_xyz;
		};
		&xform => DVprobe.probe_xform;
	};

	DVinterp_data DVinterp_data {
		in => DVextract_comp.out;
		probe => fprobe;
		comps[1] => {0};
	};

	DVglyph DVglyph {
		in => DVinterp_data.out;
		glyph => in_probe;
		glyph_comp = 0;
		map_comp = 0;
		scale_comp = 0;
		vector = 0;
		scale => param.scale;
		normalize => param.normalize;
		scale_x = 1;
		scale_y = 1;
		scale_z = 1;
		out {
			&xform+nonotify => fprobe.xform;
		};
	};

	DViso DViso<NEy=198,NEx=99> {
		in => DVextract_comp.out;
		level => oparam.value[0];
	};
	
	DVnmap DVnmap<NEy=198,NEx=319> {
		in => in_fld;
		nparam => DViso.nparam;
		int map_comp[1]=> {param.map_component};
		iso_comp => param.iso_component;
		iso_val => oparam.value[0];
	};

	DVcomb_mesh_and_data DVcomb_mesh_and_data<NEy=297,NEx=176> {
		in_mesh => DViso.out;
		in_nd => DVnmap.out;
	};

	olink out_fld => DVcomb_mesh_and_data.out;
	olink out_fld1 => DVglyph.out;
};

macro Advect {
	ilink in_fld;
	ilink in_prb;
	ilink in_glp;
	DV_Param_advect+IPort2 &param;

	DVstream DVstream {
		in => in_fld;
		probe => in_prb;
		&stream_comp => param.component;
		&order => param.order;
		&forw_back => param.forw_back;
		&nseg => param.nseg;
		&max_seg => param.max_seg;
		&min_vel => param.min_vel;
		ribbons = 0;
		rib_width = 0;
		rib_angle = 0;
	};
	GMOD.loop loop {
		&run => param.run;
		&reset => param.reset;
		&cycle => param.cycle;
		&start_val => param.start;
		&end_val => param.end;
		&incr => param.incr;
		&count => param.count;
	};
	DVadvect DVadvect {
		in => DVstream.out;
		&time => param.count;
		&direction => param.forw_back;
		&start_time => param.start;
		&release_interval => param.release_interval;
	};
	DVglyph DVglyph {
		in => DVadvect.out;
		glyph => in_glp;
		vector => param.vector;
		glyph_comp = 0;
		map_comp = 0;
		scale_comp = 0;
		&scale => param.scale;
		&normalize => param.normalize;
		scale_x = 1;
		scale_y = 1;
		scale_z = 1;
	};

	olink out_fld => DVglyph.out;
	olink out_fld1 => DVstream.out;
};

macro AdvectMultiBlock {
	ilink in_fld;
	ilink in_prb;
	ilink in_glp;
	DV_Param_advect+IPort2 &param;

	DVstream_multi_block DVstream {
		in => in_fld;
		probe => in_prb;
		&stream_comp => param.component;
		&order => param.order;
		&forw_back => param.forw_back;
		&nseg => param.nseg;
		&max_seg => param.max_seg;
		&min_vel => param.min_vel;
		ribbons = 0;
		rib_width = 0;
		rib_angle = 0;
	};
	GMOD.loop loop {
		&run => param.run;
		&reset => param.reset;
		&cycle => param.cycle;
		&start_val => param.start;
		&end_val => param.end;
		&incr => param.incr;
		&count => param.count;
	};
	DVadvect DVadvect {
		in => DVstream.out;
		&time => param.count;
		&direction => param.forw_back;
		&start_time => param.start;
		&release_interval => param.release_interval;
	};
	DVglyph DVglyph {
		in => DVadvect.out;
		glyph => in_glp;
		vector => param.vector;
		glyph_comp = 0;
		map_comp = 0;
		scale_comp = 0;
		&scale => param.scale;
		&normalize => param.normalize;
		scale_x = 1;
		scale_y = 1;
		scale_z = 1;
	};

	olink out_fld => DVglyph.out;
	olink out_fld1 => DVstream.out;
};

macro CutTxt3D {
	ilink in_fld0<NEy=77,NEx=44>;
	ilink in_pln0<NEy=44,NEx=110>;
	DV_Param_cut+IPort2 &param0<NEy=22,NEx=407>;

	Mesh_Unif+Space3+Dim3+Node_Data box {
		&xform+nres => in_fld0.xform;
		dims => {2,2,2};
		&points+nres => in_fld0.points;
		nnode_data = 1;
		!node_data[0] {
			id = 670;
			veclen = 3;
			float values[nvals][veclen] = {{0,0,0},{1,0,0},{0,1,0},{1,1,0},
							{0,0,1},{1,0,1},{0,1,1},{1,1,1}};
			null_flag = 0;
			labels = "uvw";
		};
	};
	Cut Cut {
		in_fld => box;
		in_pln => in_pln0;
		param => param0;
	};
	DVext_face DVext_face {
		in => Cut.out_fld;
	};
	olink out_fld => DVext_face.out;
};

macro SliceTxt3D {
	ilink in_fld0<NEy=77,NEx=44>;
	ilink in_pln0<NEy=44,NEx=110>;

	DV_Param_slice+Port SliceParam<NEy=22,NEx=407> {
		component = {0};
		dist = 0;
	};

	Mesh_Unif+Space3+Dim3+Node_Data box {
		&xform+nres => in_fld0.xform;
		dims => {2,2,2};
		&points+nres => in_fld0.points;
		nnode_data = 1;
		!node_data[0] {
			id = 670;
			veclen = 3;
			float values[nvals][veclen] = {{0,0,0},{1,0,0},{0,1,0},{1,1,0},
							{0,0,1},{1,0,1},{0,1,1},{1,1,1}};
			null_flag = 0;
			labels = "uvw";
		};
	};

	Slice Slice {
		in_fld => box;
		in_pln => in_pln0;
		param => SliceParam;
	};
	olink out_fld => Slice.out_fld;
};

macro SliceTxt2D {
	ilink in_fld<NEy=77,NEx=44>;
	ilink in_pln<NEy=44,NEx=110>;

	Mesh_Unif+Space2+Dim2+Node_Data plane0 {
		dims => {2,2};
		&xform+nres => DVslice_unif.out.xform;
		&points+nres => DVslice_unif.out.points;
		nnode_data = 1;
		!node_data[0] {
			id = 670;
			veclen = 2;
			float values[nvals][veclen] = {{0,0},{1,0},{0,1},{1,1}};
			null_flag = 0;
			labels = "uv";
		};
	};

	DVslice_unif  DVslice_unif {
		in => in_fld;
		plane => in_pln;
		dist = 0;
		map_comp[1]=> {0};
	};
	olink out_fld => plane0;
	olink out_fld1 => DVslice_unif.out;
};

macro InterpTxt3D {
	ilink in_fld<NEy=77,NEx=44>;
	ilink in_prb<NEy=44,NEx=110>;

	float+nres dx => in_fld.points[1][0]-in_fld.points[0][0];
	float+nres dy => in_fld.points[1][1]-in_fld.points[0][1];
	float+nres dz => in_fld.points[1][2]-in_fld.points[0][2];

	Mesh_Unif+Space3+Dim3+Node_Data box {
		dims => {2,2,2};
		&xform+nres => in_fld.xform;
		float+nres   points[npoints][nspace] => {in_fld.points[0][0]-100*dx,
						   in_fld.points[0][1]-100*dy,
						   in_fld.points[0][2]-100*dz,
						   in_fld.points[1][0]+100*dx,
						   in_fld.points[1][1]+100*dy,
						   in_fld.points[1][2]+100*dz};
		nnode_data = 1;
		!node_data[0] {
			id = 670;
			veclen = 3;
			float values[nvals][veclen] = {{-100,-100,-100},{101,-100,-100},{-100,101,-100},
							{101,101,-100},
						       {-100,-100,101},{101,-100,101},{-100,101,101},
							{101,101,101}};
			null_flag = 0;
			labels = "uvw";
		};
	};

	DVinterp_data  DVinterpolate_data {
		in => box;
		probe => in_prb;
		comps[1] => {0};
	};
	DVext_face DVext_face {
		in => DVinterpolate_data.out;
	};
	olink out_fld => DVext_face.out;
};

macro ContourTexture {
	ilink in_fld;

	DV_Param_contour+IPort2 &param;

	float levels[param.ncontours+1] => init_array(param.ncontours+1, param.level_min, param.level_max);
	float min_level[param.ncontours] => levels[0:param.ncontours-1];
	float max_level[param.ncontours] => levels[1:param.ncontours];

	DV.DVcontour DVcontour[param.ncontours] {
		in => in_fld;
		&contour_comp => param.contour_comp;
		map_comp => param.map_comp;
		level_min => <-.min_level[index_of(DVcontour)];
		level_max => <-.max_level[index_of(DVcontour)];
	};

	DV_Param_texture_mesh TextureMeshParam<export_all=2> {
		uv_switch = 0;
		u_flip = 0;
		v_flip = 0;
		u_scale = 1.0;
		v_scale = 1.0;
		u_shift = 0.0;
		v_shift = 0.0;
	};

	DV.DVmesh_uv DVmesh_uv[param.ncontours] {
		DV_Param_texture_mesh+IPort2 &param => TextureMeshParam;
		in => DVcontour[index_of(DVmesh_uv)].out;
		&uv_switch => param.uv_switch;
		&u_flip => param.u_flip;
		&v_flip => param.v_flip;
		&u_scale => param.u_scale;
		&v_scale => param.v_scale;
		&u_shift => param.u_shift;
		&v_shift => param.v_shift;
	};

	omlink out_flds => DVmesh_uv.out;
};

macro External_Edges {
	ilink in_field;

	float+IPort2 edge_angle;

	macro ext_edges_struct {
		ilink in_field_struct => DVfld_match.links.link0;
		DV_Param_bounds BoundsParam {
			 hull=1;
			 edges=0;
			 faces=0;
			 imin=0;
			 imax=0;
			 jmin=0;
			 jmax=0;
			 kmin=0;
			 kmax=0;
			 data=1;
			 component=0;
		};

		DVbounds  DVbounds {
			DV_Param_bounds+IPort2 &param => BoundsParam;
			in => in_field_struct;
			hull => param.hull;
			edges => param.edges;
			faces => param.faces;
			imin => param.imin;
			imax => param.imax;
			jmin => param.jmin;
			jmax => param.jmax;
			kmin => param.kmin;
			kmax => param.kmax;
			data => param.data;
			component => param.component;
		};
		olink out_fld => DVbounds.out;
	};

	macro ext_edges_unstruct {
		ilink in_field_unstruct => DVfld_match.links.link1;
		DVext_edge DVext_edge {
			angle => (<-.<-.edge_angle)*3.14/180.0;
			in => in_field_unstruct;
		};

		olink out_fld => DVext_edge.out;
	};

	DVfld_match DVfld_match {
		in => <-.in_field;
	};

	DVswitch DVswitch {
		in => {ext_edges_struct.out_fld, ext_edges_unstruct.out_fld};
		index => DVfld_match.index;
	};

	olink out_fld => DVswitch.out;
};

macro External_Faces {
	ilink in_field;

	macro ext_faces_struct {
		ilink in_field_struct => DVfld_match.links.link0;
		DV_Param_bounds BoundsParam {
			 hull=1;
			 edges=0;
			 faces=1;
			 imin=1;
			 imax=1;
			 jmin=1;
			 jmax=1;
			 kmin=1;
			 kmax=1;
			 data=1;
			 component=0;
		};

		DVbounds  DVbounds {
			DV_Param_bounds+IPort2 &param => BoundsParam;
			// Make sure it updates when the node data changes.
			Mesh_Struct+Node_Data_Opt+Iparam &in {
				xform+nonotify;
			} => in_field_struct;
			hull => param.hull;
			edges => param.edges;
			faces => param.faces;
			imin => param.imin;
			imax => param.imax;
			jmin => param.jmin;
			jmax => param.jmax;
			kmin => param.kmin;
			kmax => param.kmax;
			data => param.data;
			component => param.component;
			// Repeat to make sure it gets new notifies
			method+notify_val+notify_inst upd_bounds<status=1> = "DVbounds_update";
		};

		olink out_fld => DVbounds.out;
	};
	macro ext_faces_unstruct {
		ilink in_field_unstruct => DVfld_match.links.link1;
		DVext_face DVext_face {
			in => in_field_unstruct;
		};

		olink out_fld => DVext_face.out;
	};

	DVfld_match DVfld_match {
		in => <-.in_field;
	};

	DVswitch DVswitch {
		in => {ext_faces_struct.out_fld, ext_faces_unstruct.out_fld};
		index => DVfld_match.index;
	};

	olink out_fld => DVswitch.out;
};

macro Explode_Fields {
	mlink+IPort2 in_fields;
	DV_Param_scale+IPort2 &param<NEy=22,NEx=176>;

	DVcompute_extent compute_extents[array_size(in_fields)] {
		in+nres => in_fields[index_of(compute_extents)];
	};

	DVexplode_xform DVexplode_xform {
		in => compute_extents.out;
		x_factor => param.scale_x;
		y_factor => param.scale_y;
		z_factor => param.scale_z;
	};
	mlink+OPort2 out_fld => DVexplode_xform.out_flds;
};

group+Port DV_Param_roi_to_surf {
	int+IPort2	roi_orient;
	int+IPort2	start_angle;
	int+IPort2	flip_normals;
	int+IPort2	cap_surface;
};

macro Roi_to_surf {
	Mesh_Array+IPort2 &mesh_array;
	DV_Param_roi_to_surf+IPort2 &param;

	long &dims[]=>mesh_array.MeshIn.dims;
	float coord[dims[0]][dims[1]][dims[2]][3] => mesh_array.MeshIn.coordinates.values;
	float+nres coord_z[dims[2]] => coord[0:dims[2]-1][0][0][2];
	float+nres coord_y[dims[1]] => coord[0][0:dims[1]-1][0][1];
	float+nres coord_x[dims[0]] => coord[0][0][0:dims[0]-1][0];

	DVroi_to_surf DVroi_to_surf {
		in => mesh_array.MeshArr;
		start_angle => param.start_angle;
		flip_normals => param.flip_normals;
		cap_surface => param.cap_surface;
		z_coord => switch(param.roi_orient+1,coord_z,coord_y,coord_x);
	};
	olink out_fld => DVroi_to_surf.out;
};

group+Port DV_Param_rotate {
	int+IPort2      nmeshes;
	int+IPort2      axis;
	float+IPort2    center[3];
	float+IPort2    start_angle;
	float+IPort2    end_angle;
	float+IPort2    center_x;
	float+IPort2    center_y;
	float+IPort2    center_z;
};

macro Replicate_Field {
	ilink in_fld;
	DV_Param_rotate+IPort2 &param;

	float DR = acos(-1.)/180;

	float angles[param.nmeshes] => init_array(param.nmeshes,
				       DR*param.start_angle, DR*param.end_angle); 

	DVrotate_mesh DVrotate_mesh[param.nmeshes] {
		in => <-.in_fld;
		axis => <-.param.axis;
		center => <-.param.center;
		angle => <-.angles[index_of(DVrotate_mesh)];
	};
	mlink+OPort2 out => DVrotate_mesh.out;
};

#ifdef GIS_KIT
macro Texture_Sphere {
	DV_Param_texture_sphere+IPort2 &param;

	Mesh_Unif mesh_unif {
		dims => <-.param.sphere_dims;
		ndim = 2;
		points => {
			{<-.param.longitude[0], <-.param.latitude[0],0},
			{<-.param.longitude[1], <-.param.latitude[1],0}};
		nspace = 3;
	};

	GIS.GISProjection GISProjection {
		inLLA => <-.mesh_unif.coordinates;
		GlobalRadius => <-.param.radius;
	};
 
	DVcompute_uv DVcompute_uv {
		in => <-.mesh_unif;
	};

	Mesh_Struct mesh {
		dims => <-.mesh_unif.dims;
		ndim => <-.mesh_unif.ndim;
		nspace => <-.mesh_unif.nspace;
		&coordinates => <-.GISProjection.outXYZ;
	};

	DVcomb_mesh_and_data DVcomb_mesh_and_data {
		in_mesh => <-.mesh;
		in_nd => <-.DVcompute_uv.out;
	};
	olink out_fld => DVcomb_mesh_and_data.out;
};
#endif /* GIS_KIT */

group node_minmax_arr {
	group+IPort2 &in_field[] {
		Data_Array+opt node_data[];
	};
	int+IPort2 component;
	group min_max[array_size(in_field)] {
		float min=>in_field[index_of(min_max)].node_data[component].min;
		float max=>in_field[index_of(min_max)].node_data[component].max;
	};
	float+OPort2 min => cache(min_array(min_max.min)); 
	float+OPort2 max => cache(max_array(min_max.max)); 
};

};

