/*
			Copyright (c) 2001 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_ogl.v#1 $
*/

flibrary DV_OGL <
    disabled => Templates.CONFIG.gd_gl_disabled,
    needs_use_lic="GD", needs_edit_lic="DV"
    >
{

library+buffered Modules <
    build_dir="modules/ogl",
    build_cmd="$(MAKE)",
    use_src_file=0,
    link_files="-ldv_ogl",
    libdeps="LIBGL"
    >
{

// Polyline cell set Mesh for Illuminated Lines
Mesh Mesh_Polyline<NEvisible=0> {
    Polyline cell_set[.ncell_sets];
};

//
// Custom Render Method for Polyline cell set to implement
// Illuminated Lines .
//
// note: "virtual" attribute removed so it will stick hard and fast
//
// This method will run every time the viewer window does a refresh,
//  mouse-move, or redraw.
//
Polyline iline_cellset<NEportLevels={0,1},
                       hdr_code="void Illuminated_Polylines_Render(void *, OMobj_id, void *, void *);"
                      > {
    iline_Param  &param;
    float+nosave &tangent[][];
    byte+nosave  &TexMap[param.width][param.height][4];
    float+nosave &effect_data[];

    data_method+nosave render = "Illuminated_Polylines_Render";
};

//
// Module to setup the Texture Map for shading
// This module only runs if a parameter changes
// or a new input mesh arrives
//
module iline_calc_texmap {
    iline_Param &param<NEportLevels={2,0}>;
    byte+nosave TexMap<NEportLevels={0,2}>[param.width][param.height][4];

    omethod+notify_inst+req update(
        .param+read+req+notify,
        .TexMap+read+write ) = "iline_calc_texmap";
};

// Module to calculate tangent vectors for Polylines
// Runs when coordinates change, placing result in tangents
module iline_calc_tangents {
    float &coords<NEportLevels={2,0}>[][];
    long &conn<NEportLevels={2,0}>[];
    float+nosave tangents<NEportLevels={0,2}>[][];

    omethod+notify_inst+req update(
        .coords+read+req+notify,
        .conn+read+req,
        .tangents+read+write ) = "iline_calc_tangents";
};

// Module to create the Animation Effect data
// Runs when UI effect parameters change
module iline_create_effect_data {
    iline_Param &param<NEportLevels={2,0}>;
    float+nosave effect_data<NEportLevels={0,2}>
        [param.AnimationEffect.effectLength+param.AnimationEffect.effectSpacing];

    omethod+notify_inst+req update(
        .param.AnimationEffect+req+notify,
        .param.IlluminationModel.Trans+req+notify,
        .param.HaloModel.lineWidth+req+notify,
        .effect_data+read+write ) = "iline_create_effect_data";
};

}; // Modules;

library+buffered Params<compile_subs=0> {

group ilineIlluminationModel<NEvisible=0, NEnumColors=1, NEcolor0=0x00ff00> {
    double Ka<animate=1>; // ambient 0->1
    double Kd<animate=1>; // diffuse 0->1
    double Ks<animate=1>; // specular 0->1
    double n<animate=1>;  // shininess 1->100
    double p<animate=1>;  // phong modifier 1.2->8
    double Trans<animate=1>;  // Transparency 0->1
    double Blend<animate=1>;  // Color Blending 0->1
};

group ilineHaloModel<NEvisible=0, NEnumColors=1, NEcolor0=0x00ff00> {
    int haloWidth<animate=1>;
    int lineWidth<animate=1>;
    int doDepthMask;
    int doAntialiasHalo;
    int doSmoothShade;
};

group ilineAnimationEffect<NEvisible=0, NEnumColors=1, NEcolor0=0x00ff00> {
    int animationOn;
    int StairDash;                // 0 - stair  1 - dash
    int StairType;                // 0 - down  1 - up  2 - up&down
    int effectLength<animate=1>;
    int effectSpacing<animate=1>;
    int TranspWidth;              // 0 - transparency  1 - width
    int InverseEffect;            // 0 - normal  1 - inverse
    int effectStep;
};

group iline_Param<NEvisible=1, NEportLevels={0,1},
        NEnumColors=4,
        NEcolor0=0x0000ff,
        NEcolor1=0x00ff00,
        NEcolor2=0xff0000,
        NEcolor3=0xaabbcc> {
    int width;
    int height;
    int illuminationOn;

    ilineIlluminationModel IlluminationModel;
    ilineHaloModel         HaloModel;
    ilineAnimationEffect   AnimationEffect;
};

}; // Params

library+buffered Macros<compile_subs=0> {

//
// Ilines mesh mapper
//
// Add a GDobject - Data Object, with modes set for no cache
// no normals, to enable direct rendering of the lines with
// minimal overhead.
//
// This is formed as a mesh mapper that allows connection to
// primitive arrays to build up a renderable field with special behavior.
//
macro illuminated_lines_mesh_mapper {
    float+IPort2 &coord[][];
    float+IPort2 &tangent[][];
    long+IPort2   &connect[];
    byte+IPort2  &tex_map[][][];
    float+IPort2 &effect_data[];
    Mesh_Polyline+IPort2 &mesh_in;

    iline_Param &param<NEportLevels={2,1}>;

    GMOD.loop &loop<NEportLevels={2,1}>;

    int coord_dims[] => array_dims(coord);

    int error => is_valid(coord_dims) && (array_size(coord_dims)!=2 || coord_dims[0]==1);

    GMOD.print_error print_error {
        error => <-.error;
        error_source = "illuminated_line_mesh";
        error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace] and nspace can't be 1";
        on_inst = 1;
    };

    Mesh+Node_Data+OPort out {
        iline_Param &param<NEportLevels={2,1}> => <-.param;

        byte+IPort2 &tex_map[][][] => <-.tex_map;
        float+IPort2 &tangent[][] => <-.tangent;
        float+IPort2 &effect_data[] => <-.effect_data;
        Mesh_Polyline &mesh_in => <-.mesh_in;

        nnodes => switch(!error,<-.coord_dims[1]);
        nspace => switch(!error,<-.coord_dims[0]);
        coordinates.values => switch(!error,<-.<-.coord);
        ncell_sets = 1;

        // Special cell set with a custom render method
        iline_cellset cell_set[ncell_sets] {
            npolys => switch(!error,array_size(<-.<-.connect)/2);
            poly_connect_list => switch(!error,<-.<-.connect);
            param => <-.param;
            TexMap => <-.tex_map;
            tangent => <-.tangent;
            effect_data => <-.effect_data;
        };
        nnode_data => switch(is_valid(mesh_in.node_data[0])+1,0,1);
        node_data = {
            {
                nvals => switch(is_valid(mesh_in.node_data[0])+1,
                    0,mesh_in.node_data[0].nvals),
                veclen => switch(is_valid(mesh_in.node_data[0])+1,
                    0,mesh_in.node_data[0].veclen),
                id => switch(is_valid(mesh_in.node_data[0])+1,
                    0,mesh_in.node_data[0].id),
                values => switch(is_valid(mesh_in.node_data[0])+1,
                    0,mesh_in.node_data[0].values),
                labels => switch(is_valid(mesh_in.node_data[0])+1,
                    0,mesh_in.node_data[0].labels),
                units => switch(is_valid(mesh_in.node_data[0])+1,
                    0,mesh_in.node_data[0].units)
            }
        };
        &xform+nowrite => mesh_in.xform;
    };

    DataObject DataObject {
        in => <-.out;
        Obj {
            name => name_of(<-.<-.<-.<-);
        };

        iline_Param &param<NEportLevels={2,0}> => <-.param;

        GMOD.loop &loop<NEportLevels={2,0}> => <-.loop;

        Props {
            line_width => <-.<-.param.HaloModel.lineWidth;
            line_aa => <-.<-.param.HaloModel.doAntialiasHalo;
            inherit = 0;
        };

        GMOD.copy_on_change copy_on_change {
            trigger =>
                <-.param.illuminationOn |
                <-.param.width | <-.param.height |
                <-.param.HaloModel.haloWidth |
                <-.param.HaloModel.lineWidth |
                <-.param.HaloModel.doDepthMask |
                <-.param.HaloModel.doAntialiasHalo |
                <-.param.HaloModel.doSmoothShade |
                <-.param.IlluminationModel.Ka |
                <-.param.IlluminationModel.Kd |
                <-.param.IlluminationModel.Ks |
                <-.param.IlluminationModel.n  |
                <-.param.IlluminationModel.p  |
                <-.param.IlluminationModel.Trans |
                <-.param.IlluminationModel.Blend |
                (<-.param.AnimationEffect.animationOn &&
                    (<-.param.AnimationEffect.StairDash |
                     <-.param.AnimationEffect.StairType |
                     <-.param.AnimationEffect.effectLength |
                     <-.param.AnimationEffect.effectSpacing |
                     <-.param.AnimationEffect.TranspWidth |
                     <-.param.AnimationEffect.InverseEffect |
                     <-.loop.count
                    ) |
                array_size(<-.<-.tangent) |
                array_size(<-.<-.tex_map) |
                array_size(<-.<-.effect_data)
                );

            input = 0;
            output => <-.Modes.outline;
            on_inst = 0;
        };
    };
    olink obj => DataObject.obj;

}; // end of iline mesh mapper

//
// Ilines User Interface
//

macro illuminated_lines_UI<NEvisible=0> {

    iline_Param &param<NEportLevels={2,1}>;
    GMOD.loop &loop<NEportLevels={2,0}>;

#define SPY 2

    UImod_panel UIpanel {
        parent<NEportLevels={4,0}>;
        message = "Select Illuminated Lines control panel.";
        title => name_of(<-.<-.<-);
        height = 1100;
    };

    UIlabel shade_label {
        parent => <-.UIpanel;
        y = 0;
        width => <-.UIpanel.width;
        label => "Illuminated Lines Shading Model";
        color {
            backgroundColor = "blue";
            foregroundColor = "white";
        };
    };

    UItoggle illumination_on_toggle {
        y => ((<-.shade_label.y + <-.shade_label.height) + SPY);
        x = 0;
        width => <-.UIpanel.width;
        parent => <-.UIpanel;
        label => "Enable Illumination Rendering";
        alignment => "center";
        set<NEportLevels={2,0}> => param.illuminationOn;
    };

    UIslider Ka_slider {
        parent => <-.UIpanel;
        y => ((<-.illumination_on_toggle.y + <-.illumination_on_toggle.height)
            + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 0.0;
        max = 1.0;
        value<NEportLevels={2,0}> => param.IlluminationModel.Ka;
        title => "Ambient";
    };
    VUIslider_typein Ka_slider_typein {
        slider => <-.Ka_slider;
    };

    UIslider Kd_slider {
        parent => <-.UIpanel;
        y => ((<-.Ka_slider.y + <-.Ka_slider.height) + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 0.0;
        max = 1.0;
        value<NEportLevels={2,0}> => param.IlluminationModel.Kd;
        title => "Diffuse";
    };
    VUIslider_typein Kd_slider_typein {
        slider => <-.Kd_slider;
    };

    UIslider Ks_slider {
        parent => <-.UIpanel;
        y => ((<-.Kd_slider.y + <-.Kd_slider.height) + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 0.0;
        max = 1.0;
        value<NEportLevels={2,0}> => param.IlluminationModel.Ks;
        title => "Specular";
    };
    VUIslider_typein Ks_slider_typein {
        slider => <-.Ks_slider;
    };

    UIslider n_slider {
        parent => <-.UIpanel;
        y => ((<-.Ks_slider.y + <-.Ks_slider.height) + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 1.0;
        max = 100.0;
        value<NEportLevels={2,0}> => param.IlluminationModel.n;
        title => "Phong Shininess";
    };
    VUIslider_typein n_slider_typein {
        slider => <-.n_slider;
    };

    UIslider p_slider {
        parent => <-.UIpanel;
        y => ((<-.n_slider.y + <-.n_slider.height) + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 1.2;
        max = 8.0;
        value<NEportLevels={2,0}> => param.IlluminationModel.p;
        title => "Phong Modifier";
    };
    VUIslider_typein p_slider_typein {
        slider => <-.p_slider;
    };


    UIslider lw_slider {
        parent => <-.UIpanel;
        width => (<-.UIpanel.width );
        y => ((<-.p_slider.y + <-.p_slider.height) + SPY);
        min = 1.0;
        max = 8.0;
        mode = 1;
        value<NEportLevels={2,0}> => param.HaloModel.lineWidth;
        title => "Line Width";
    };

    UIslider trans_slider {
        parent => <-.UIpanel;
        y => ((<-.lw_slider.y + <-.lw_slider.height) + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 0.0;
        max = 1.0;
        value<NEportLevels={2,0}> => param.IlluminationModel.Trans;
        title => "Line Opacity";
    };
    VUIslider_typein trans_slider_typein {
        slider => <-.trans_slider;
    };

    UIslider blend_slider {
        parent => <-.UIpanel;
        y => ((<-.trans_slider.y + <-.trans_slider.height) + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 0.0;
        max = 1.0;
        value<NEportLevels={2,0}> => param.IlluminationModel.Blend;
        title => "Color Blend";
    };
    VUIslider_typein blend_slider_typein {
        slider => <-.blend_slider;
    };

    // toggle modes

    UItoggle depth_toggle {
        y => ((<-.blend_slider.y + <-.blend_slider.height) + SPY);
        x = 0;
        width => (<-.UIpanel.width/2) - 5;
        parent => <-.UIpanel;
        label => "Depth Mask";
        set<NEportLevels={2,0}> => param.HaloModel.doDepthMask;
    };

    UItoggle aa_toggle {
        y => <-.depth_toggle.y;
        x => (<-.UIpanel.width/2) + 5;
        width => (<-.UIpanel.width/2) - 5;
        parent => <-.UIpanel;
        label => "Antialias";
        set<NEportLevels={2,0}> => param.HaloModel.doAntialiasHalo;
    };

    UItoggle smooth_shade_toggle {
        y => ((<-.depth_toggle.y + <-.depth_toggle.height) + SPY);
        x = 0;
        width => (<-.UIpanel.width/2) - 5;
        parent => <-.UIpanel;
        label => "Smooth Shading";
        set<NEportLevels={2,0}> => param.HaloModel.doSmoothShade;
    };

    UIlabel Halo_label {
        parent => <-.UIpanel;
        y => ((<-.smooth_shade_toggle.y + <-.smooth_shade_toggle.height) + SPY*2);
        width => <-.UIpanel.width;
        label => "Halo Parameters";
        color {
            backgroundColor = "blue";
            foregroundColor = "white";
        };
    };

    UIslider halow_slider {
        parent => <-.UIpanel;
        y => ((<-.Halo_label.y + <-.Halo_label.height) + SPY);
        width => (<-.UIpanel.width);
        min = 0.0;
        max = 10.0;
        mode = 1;
        value<NEportLevels={2,0}> => param.HaloModel.haloWidth;
        title => "Halo Width";
    };

    UIlabel AnimationEffect_label {
        parent => <-.UIpanel;
        y => ((<-.halow_slider.y + <-.halow_slider.height) + SPY*2);
        width => <-.UIpanel.width;
        label => "Animation Effects";
        color {
            backgroundColor = "blue";
            foregroundColor = "white";
        };
    };

    UItoggle animationEffect_toggle {
        y => ((<-.AnimationEffect_label.y + <-.AnimationEffect_label.height) +
            SPY);
        x = 0;
        width => <-.UIpanel.width;
        parent => <-.UIpanel;
        label => "Enable Animation Effect";
        alignment => "center";
        set<NEportLevels={2,0}> => param.AnimationEffect.animationOn;
    };

    UIoption stair_option {
        label => "stair";
    };
    UIoption dash_option {
        label => "dash";
    };
    UIradioBox stair_dash_radioBox {
        parent => <-.UIpanel;
        y => ((<-.animationEffect_toggle.y + <-.animationEffect_toggle.height) +
            7 + SPY);
        x => 0;
        cmdList => {<-.stair_option, <-.dash_option};
        width => (<-.UIpanel.width/2) - 5;
        parent => <-.UIpanel;
        selectedItem<NEportLevels={2,0}> => param.AnimationEffect.StairDash;
    };

    UIoption stair_down_option {
        label => "down";
    };
    UIoption stair_up_option {
        label => "up";
    };
    UIoption stair_up_down_option {
        label => "up & down";
    };
    UIoptionMenu stair_option_menu {
        parent => <-.UIpanel;
        y => <-.stair_dash_radioBox.y;
        x => (<-.UIpanel.width/2) + 5;
        label = "";
        cmdList =>
            {<-.stair_down_option, <-.stair_up_option, <-.stair_up_down_option};
        width => (<-.UIpanel.width/2) - 5;
        parent => <-.UIpanel;
        selectedItem<NEportLevels={2,0}> => param.AnimationEffect.StairType;
        active => !(<-.stair_dash_radioBox.selectedItem);
    };

    UIslider effect_length_slider {
        parent => <-.UIpanel;
        y => ((<-.stair_dash_radioBox.y + <-.stair_dash_radioBox.height) + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 1.0;
        max = 50.0;
        mode = 1;
        value<NEportLevels={2,0}> => param.AnimationEffect.effectLength;
        title => "Length";
    };
    VUIslider_typein effect_lenght_slider_typein {
        slider => <-.effect_length_slider;
        min<rdonly=1> => 1.0;
    };

    UIslider effect_spacing_slider {
        parent => <-.UIpanel;
        y => ((<-.effect_length_slider.y + <-.effect_length_slider.height) + SPY);
        width => ((<-.UIpanel.width * 11) / 12);
        min = 0.0;
        max = 100.0;
        mode = 1;
        value<NEportLevels={2,0}> => param.AnimationEffect.effectSpacing;
        title => "Spacing";
    };
    VUIslider_typein effect_spacing_slider_typein {
        slider => <-.effect_spacing_slider;
        min<rdonly=1> => 0.0;
    };

    UIoption transparency_option {
        label => "modulate transparency";
    };
    UIoption width_option {
        label => "modulate width";
    };
    UIradioBox transp_width_radioBox {
        parent => <-.UIpanel;
        y => ((<-.effect_spacing_slider.y + <-.effect_spacing_slider.height) +
            SPY);
        x => 0;
        cmdList => {<-.transparency_option, <-.width_option};
        width => <-.UIpanel.width;
        parent => <-.UIpanel;
        //orientation => "horizontal";
        //itemWidth => <-.UIpanel.width/2;
        selectedItem<NEportLevels={2,0}> => param.AnimationEffect.TranspWidth;
    };

    UItoggle inverseEffect_toggle {
        y => ((<-.transp_width_radioBox.y + <-.transp_width_radioBox.height) +
            SPY);
        x = 0;
        width => <-.UIpanel.width;
        parent => <-.UIpanel;
        label => "Inverse Effect";
        alignment => "center";
        set<NEportLevels={2,0}> => param.AnimationEffect.InverseEffect;
    };

    UIlabel AnimationRun_label {
        parent => <-.UIpanel;
        y => ((<-.inverseEffect_toggle.y + <-.inverseEffect_toggle.height) + SPY*2);
        width => <-.UIpanel.width;
        label => "Animation Run";
        color {
            backgroundColor = "blue";
            foregroundColor = "white";
        };
    };

    UItoggle run_toggle {
        y => ((<-.AnimationRun_label.y + <-.AnimationRun_label.height) + 5 + SPY);
        x = 0;
        width => (<-.UIpanel.width/2) - 5;
        parent => <-.UIpanel;
        label => "Run";
        set<NEportLevels={2,0}> => loop.run;
    };
    UItoggle cycle_toggle {
        y => <-.run_toggle.y;
        x => (<-.UIpanel.width/2) + 5;
        width => (<-.UIpanel.width/2) - 5;
        parent => <-.UIpanel;
        label => "Cycle";
        set<NEportLevels={2,0}> => loop.cycle;
    };
    UItoggle reset_toggle {
        y => ((<-.run_toggle.y + run_toggle.height) + SPY);
        x => 0;
        width => <-.UIpanel.width;
        parent => <-.UIpanel;
        label => "Reset Time";
        set<NEportLevels={2,0}> => loop.reset;
    };

}; // end of user interface


//
// Ilines high level user macro
//

macro illuminated_lines {

    ilink in_mesh<export_all=1>;

    Mesh_Polyline &mesh_polyline<export=1> => .in_mesh;

    iline_Param ilineParam<NEportLevels={2,1}> {
        width = 64;
        height = 64;
        illuminationOn = 1;
        HaloModel {
            haloWidth = 0;
            lineWidth = 1;
            doDepthMask = 0;
            doAntialiasHalo = 0;
            doSmoothShade = 0;
        };
        IlluminationModel {
            Ka = 0.1;
            Kd = 0.2;
            Ks = 0.8;
            n = 20.;
            p = 3.;
            Trans = 1.0;
            Blend = 0.25;
        };
        AnimationEffect {
            animationOn = 0; // off
            StairDash = 0; // stair
            StairType = 0; // down
            effectLength = 1;
            effectSpacing = 1;
            TranspWidth = 0; // transparency
            InverseEffect = 0; // normal
            effectStep = 0; // beggining
        };
    };

    illuminated_lines_UI IlluminatedLinesUI {
        param => <-.ilineParam;
        loop  => <-.loop;
    };

    iline_calc_texmap set_texmap {
        param => <-.ilineParam;
    };

    long &conn<NEportLevels=1>[] => mesh_polyline.cell_set[0].poly_connect_list;

    iline_calc_tangents calc_tangents {
        conn   => <-.conn;
        coords => <-.mesh_polyline.coordinates.values;
    };

    iline_create_effect_data effect_data {
        param => <-.ilineParam;
    };

    illuminated_lines_mesh_mapper mesh_mapper {
        coord   => <-.mesh_polyline.coordinates.values;
        tangent => <-.calc_tangents.tangents;
        connect => <-.conn;
        param   => <-.ilineParam;
        tex_map => <-.set_texmap.TexMap;
        mesh_in => <-.mesh_polyline;
        effect_data => <-.effect_data.effect_data;
        loop    => <-.loop;
        obj<NEportLevels={1,2}>;
    };

    GMOD.loop loop<NEportLevels={0,1}> {
        start_val => 0.;
        end_val => (<-.ilineParam.AnimationEffect.effectLength +
                    <-.ilineParam.AnimationEffect.effectSpacing) - 1;
        count => <-.ilineParam.AnimationEffect.effectStep;
        incr  => 1.;
        cycle => 1;
    };

    olink obj => mesh_mapper.obj;

}; // end of iline high-level macro

};  // Macros

}; // DV_OGL
