/*
			Copyright (c) 2000 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/fast_arr.v#1 $
*/


flibrary FAST_ARR <
    needs_use_lic="GD", needs_edit_lic="DV",
    link_files="-lmods"
    >
{

library+sort+buffered FA_Modules {

////
//// Utility Modules
////

module DVmerge_ARR {
    group+IPort2 &in1[];
    group+IPort2 &in2[];

    group+OPort2+nonotify+nosave &out[];

    omethod+notify_val+notify_inst merge_update<status=1> =
        "DV_ARRmerge_update";
};

module DVfld_match_ARR {
    Mesh+Iparam &in[] {
        xform+nonotify; /* this will not cause a field type change */
    };
    int+Oparam   index=0;
    group+write+nonotify links {
        mlink+OPort3 link0;
        mlink+OPort3 link1;
        mlink+OPort3 link2;
        mlink+OPort3 link3;
    };
    omethod+notify_val+notify_inst match_update<status=1> =
        "DV_ARRfld_match_update";
};

//
// Combines cell sets and node data for unstructured fields.
//
module DVcombine_sets_ARR {
    //Mesh+Node_Data+IPort2 &in[];
    // Should set things up with +opt switches to make
    // sure it responds to changes in Node_Data or Cell_Data
    Mesh+IPort2 &in[]; // Node_Data (or Cell_Data) is not required

    Mesh+Node_Data+Cell_Data+OPort2+nosave out;

    omethod+notify_val+notify_inst combine_sets_update<status=1> =
        "DV_ARRcombine_sets_update";
};

////
////  Reader Modules
////

////
//// Data Visualization Modules
////

module DVbounds_ARR {
    Mesh_Struct+Iparam &in[] {
        ndim+req;
        dims+req;
        xform+nonotify;
    };

    int+Iparam  hull;
    int+Iparam  edges;
    int+Iparam  faces;
    int+Iparam  imin;
    int+Iparam  imax;
    int+Iparam  jmin;
    int+Iparam  jmax;
    int+Iparam  kmin;
    int+Iparam  kmax;
    int+Iparam  data;
    int+notify+IPort2  component;

    Mesh+Node_Data+Oparam+nosave out[] {
        // Done in the update function.
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst upd_bounds<status=1> =
        "DV_ARRbounds_update";
};

module DVcomb_mesh_and_data_ARR {
    Mesh+IPort2 &in_mesh[];

    Node_Data+nres+IPort2 &in_nd[];

    DVmerge_ARR merge_arr {
        in1 => in_nd;
        in2 => in_mesh;
    };

    Mesh+Node_Data+OPort2 &out[] => merge_arr.out;
};

module DVcontour_ARR { /* cuts off a portion of a field between two contours */
    Mesh+Node_Data+Iparam &in[] { /* input field (to be sliced) */
        xform+nonotify;
        nnodes+req;
    };

    int+Iparam    contour_comp;
    int+read+notify+opt+IPort2 map_comp[];
    float+Iparam  level_min;
    float+Iparam  level_max;

    Mesh+Node_Data+Oparam+nosave out[] { /* output field */
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst contour_update<status=1> =
        "DV_ARRcontour_update";
};

module DVcrop_struct_ARR {
    Mesh_Struct+Node_Data+Iparam &in[] {
        xform+nonotify;
        nnodes+req;
    };

    int+Iparam min[];
    int+Iparam max[];

    Mesh_Struct+Node_Data+Oparam+nosave out[] {
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst upd_crop<status=1> =
        "DV_ARRcrop_update";
};

module DVcrop_unif_ARR {
    Mesh_Unif+Node_Data+Iparam &in[] {
        xform+nonotify;
        nnodes+req;
    };

    int+Iparam min[];
    int+Iparam max[];

    Mesh_Unif+Node_Data+Oparam+nosave out[] {
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst upd_crop<status=1> =
        "DV_ARRcrop_unif_update";
};

module DVcrop_rect_ARR {
    Mesh_Rect+Node_Data+Iparam &in[] {
        xform+nonotify;
        nnodes+req;
    };

    int+Iparam min[];
    int+Iparam max[];

    Mesh_Rect+Node_Data+Oparam+nosave out[] {
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst upd_crop<status=1> =
        "DV_ARRcrop_rect_update";
};

macro DVcrop_ARR {
    Mesh_Struct+Node_Data+Iparam &in[] {
        nnodes+req;
    };

    int+Iparam min[];
    int+Iparam max[];

    DVcrop_struct_ARR crop_struct {
        in => <-.fld_match.links.link2;
        &min => <-.min;
        &max => <-.max;
    };

    DVcrop_unif_ARR crop_unif {
        in => <-.fld_match.links.link0;
        &min => <-.min;
        &max => <-.max;
    };

    DVcrop_rect_ARR crop_rect {
        in => <-.fld_match.links.link1;
        &min => <-.min;
        &max => <-.max;
    };

    DVfld_match_ARR fld_match {
        Mesh_Struct+IPort2 &in[] => <-.in;
    };

    Mesh_Struct+Node_Data+Oparam &out[] =>
        switch( fld_match.index+1,
                crop_unif.out, crop_rect.out, crop_struct.out );

};

module DVdownsize_struct_ARR {
    Mesh_Struct+Node_Data+Iparam &in[] {
        xform+nonotify;
        nnodes+req;
    };

    float+Iparam factor[in[0].ndim];

    Mesh_Struct+Node_Data+Oparam+nosave out[] {
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst upd_downsize<status=1> =
        "DV_ARRdownsize_update";
};

module DVdownsize_unif_ARR {
    Mesh_Unif+Node_Data+Iparam &in[] {
        xform+nonotify;
        nnodes+req;
    };

    float+Iparam factor[in[0].ndim];

    Mesh_Unif+Node_Data+Oparam+nosave out[] {
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst upd_downsize<status=1> =
        "DV_ARRdownsize_unif_update";
};

module DVdownsize_rect_ARR {
    Mesh_Rect+Node_Data+Iparam &in[] {
        xform+nonotify;
        nnodes+req;
    };

    float+Iparam factor[in[0].ndim];

    Mesh_Rect+Node_Data+Oparam+nosave out[] {
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst upd_downsize<status=1> =
        "DV_ARRdownsize_rect_update";
};

macro DVdownsize_ARR {
    Mesh_Struct+Node_Data+Iparam &in[] {
        nnodes+req;
    };

    float+Iparam factor[in[0].ndim];

    DVdownsize_unif_ARR downsize_unif {
        in => <-.fld_match.links.link0;
        &factor => <-.factor;
    };

    DVdownsize_rect_ARR downsize_rect {
        in => <-.fld_match.links.link1;
        &factor => <-.factor;
    };

    DVdownsize_struct_ARR downsize_struct {
        in => <-.fld_match.links.link2;
        &factor => <-.factor;
    };

    DVfld_match_ARR fld_match {
        Mesh_Struct+IPort2 &in[] => <-.in;
    };

    Mesh_Struct+Node_Data+Oparam &out[] =>
        switch( fld_match.index+1,
                downsize_unif.out, downsize_rect.out, downsize_struct.out );
};

module DVedges_ARR { /* extract all edges from a field */
    Mesh+read+IPort2 &in[] { /* input field */
        xform+nonotify;
    };

    Cells+Oparam out_cells[] {
        *cell_set[];
        ncell_sets => array_size(cell_set);
    };

    Cells+write+nonotify out_sets[];

    DVmerge_ARR merge_arr {
        in1 => out_cells;
        in2 => in;
    };

    Mesh+OPort2+nonotify &out[] => merge_arr.out;

    omethod+notify_val+notify_inst edges_update<status=1> =
        "DV_ARRedges_update";
};

module DVextract_comp_ARR {
    Mesh+Node_Data+IPort2 &in[];

    int+IPort2 component = 0;

    Node_Data+nosave out_nd[] {
        &node_data+nres;
    };

    DVmerge_ARR merge_arr {
        in1 => out_nd;
        in2 => in;
    };

    Mesh+Node_Data+OPort2 &out[] => merge_arr.out;

    omethod+notify_val+notify_inst upd_extract_comp<status=1> =
        "DV_ARRextract_comp_update";
};

module DVextract_mesh_ARR {
    Mesh+IPort2 &in[];

    Node_Data out_nd[array_size(in)] {
        nnodes => <-.in[index_of(out_nd)].nnodes;
        nnode_data = 0;
    };

    DVmerge_ARR merge_arr {
        in1 => out_nd;
        in2 => in;
    };

    Mesh+Node_Data+OPort2 &out[] => merge_arr.out;
};

module DVextr_scalar_ARR { /* extract scalar data from a field */
    Node_Data+Iparam  &in[] { /* input field */
        nnodes+req;
    };
    int+Iparam    component; /* which component to extract */

    Node_Data+Oparam+nosave  out[]; /* output field */

    omethod+notify_val+notify_inst upd_extr_scalar<status=1> =
        "DV_ARRextr_scalar_update";
};

module DVextr_vector_ARR {	/* extract a vector component from a field */
    Node_Data+Iparam &in[] {		/* input field */
        nnodes+req;
    };

    int+Iparam    veclen;		/* length of vector to be extracted */
    int+Iparam    components[veclen];
    int+Iparam    sub_components[veclen];

    Node_Data+Oparam+nosave out[];	/* output field */

    omethod+notify_val+notify_inst upd_extr_vector<status=1> =
        "DV_ARRextr_vector_update";
};

module DVglyph_ARR { /* produces scaled, colored glyphs at nodal locations */
    Mesh+Node_Data_Opt+Iparam &in[] { /* input field */
        nnodes+req;
        nspace+req;
        coordinates+req;
        coordinates.values+req;
    };

    Mesh+Iparam &glyph;		/* glyph geometry */
    int+Iparam vector;		/* toggle to transform glyph by vector data */
    int+Iparam glyph_comp;	/* glyph data component */
    int+Iparam map_comp;	/* color glyph by data */
    int+Iparam scale_comp;	/* scale glyph by data */
    float+Iparam scale;		/* scale factor applied to glyph */
    int+Iparam scale_x;		/* do scale in x */
    int+Iparam scale_y;		/* do scale in y */
    int+Iparam scale_z;		/* do scale in z */
    int+Iparam normalize;	/* toggle to normalize glyphs */

    Mesh+Node_Data+Oparam+nosave out[] { /* output field */
        xform+nowrite;
    };

    omethod+notify_val+notify_inst glyph_mod_update<status=1> =
        "DV_ARRglyph_update";
};

module DVisoline_ARR { /* creates lines of constant value */
    Mesh+Node_Data+Iparam  &in[] { /* input field */
        xform+nonotify;
        nnodes+req;
    };

    int+Iparam    component;
    float+Iparam  level[];	/* isoline level */
    int+Iparam    color;	/* toggle for colored lines */

    Mesh+Node_Data+Oparam+nosave  out[] { /* output field */
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst isoline_update<status=1> =
        "DV_ARRisoline_update";
};

module DViso_nmap_ARR {
    Mesh+Node_Data+Iparam  &in[] {
        xform+nonotify;
        nnodes+req;
        nspace+req;  /* in case we have just data */
    };

    // iso parameters
    float+Iparam  level;
    int+read+notify+opt+IPort2   cell_data[]; // ???
    int+read+notify+opt+IPort2   component;

    // nmap parameters
    int+read+notify+opt+IPort2 iso_comp;
    float+read+notify+opt+IPort2 iso_val;
    int+Iparam map_comp[];

    Mesh+Node_Data+Oparam+nosave out[] {
        &xform+nowrite;
    };

    // This becomes an internal temporary
    // With the current implementation, we only need one.
    NParam_Data+nonotify+nosave nparam<NEvisible=0>;

    omethod+notify_val+notify_inst iso_nmap_update<status=1> =
        "DV_ARRiso_nmap_update";
};

module DVnmap_ARR {
    Node_Data+Iparam &in[] {
        nnodes+req;
    };

    NParam_Data+Iparam &nparam[] {
        nnodes+req;
    };

    int+read+notify+opt+IPort2 iso_comp;
    float+read+notify+opt+IPort2 iso_val;
    int+Iparam map_comp[];

    Node_Data+Oparam+nosave out[];

    omethod+notify_val+notify_inst nmap_update<status=1> =
        "DV_ARRnmap_update";
};

module DVnode_minmax_ARR {
    group+IPort2 &in_field[] {
        Data_Array+opt node_data[];
    };
    int+IPort2 component;

    float+OPort2 min;
    float+OPort2 max;

    omethod+notify_val+notify_inst node_minmax_update<status=1> =
        "DV_ARRnode_minmax_update";
};

module DVorthoslice_struct_ARR {
    Mesh_Struct+Node_Data+Iparam &in[] {
        nnodes+req;
        nnode_data+opt;
        node_data+opt;
    };

    int+Iparam axis;
    int+Iparam plane;

    Mesh_Struct+Node_Data+Oparam+nosave out[];

    omethod+notify_val+notify_inst upd_orthoslice<status=1> =
        "DV_ARRorthoslice_update";
};

module DVorthoslice_unif_ARR {
    Mesh_Unif+Node_Data+Iparam &in[] {
        nnodes+req;
        nnode_data+opt;
        node_data+opt;
    };

    int+Iparam axis;
    int+Iparam plane;
    Mesh_Unif+Node_Data+Oparam+nosave out[];

    omethod+notify_val+notify_inst upd_orthoslice<status=1> =
        "DV_ARRorthoslice_update";
};

module DVorthoslice_rect_ARR {
    Mesh_Rect+Node_Data+Iparam &in[] {
        nnodes+req;
        nnode_data+opt;
        node_data+opt;
    };

    int+Iparam axis;
    int+Iparam plane;
    Mesh_Rect+Node_Data+Oparam+nosave out[];

    omethod+notify_val+notify_inst upd_orthoslice<status=1> =
        "DV_ARRorthoslice_update";
};

macro DVorthoslice_ARR {
    Mesh_Struct+Node_Data+Iparam &in[] {
        nnodes+req;
    };

    int+Iparam axis;
    int+Iparam plane;

    DVorthoslice_unif_ARR orthoslice_unif {
        in => <-.fld_match.links.link0;
        &axis => <-.axis;
        &plane => <-.plane;
    };

    DVorthoslice_rect_ARR orthoslice_rect {
        in => <-.fld_match.links.link1;
        &axis => <-.axis;
        &plane => <-.plane;
    };

    DVorthoslice_struct_ARR orthoslice_struct {
        in => <-.fld_match.links.link2;
        &axis => <-.axis;
        &plane => <-.plane;
    };

    DVfld_match_ARR fld_match {
        Mesh_Struct+IPort2 &in[] => <-.in;
    };

    Mesh_Rect+Node_Data+Oparam &out[] =>
        switch( fld_match.index+1,
                orthoslice_unif.out, orthoslice_rect.out, orthoslice_struct.out );
};

module DVset_minmax_ARR {
    Node_Data+Iparam &in[] {
        nnodes+req;
        nnode_data+req;
    };

    int+Iparam comp;
    double+Iparam min;
    double+Iparam max;

    Node_Data+write+nonotify+nosave out_nd[];

    DVmerge_ARR merge_arr {
        in1 => out_nd;
        in2 => in;
    };

    Node_Data+OPort2+nonotify &out[] => merge_arr.out;
    Node_Data+OPort2+nonotify &out[] => out_nd;

    omethod+notify_val+notify_inst set_minmax_update<status=1> =
        "DV_ARRset_minmax_update";
};

module DVplane_dist_ARR { /* compute distance to a plane */
    Mesh+Iparam  &in[] {
        nnodes+req;
    };

    Plane_Grid+Xform+Iparam  &plane {
        points+req;
    };

    Node_Data+Scalar+Float+Oparam+nosave  out[];
    float+Oparam     dist;

    omethod+notify_val+notify_inst plane_dist_update<status=1> =
        "DV_ARRplane_distance_update";
};

module DVslice_unif_ARR { /* slice a uniform data set */
    Mesh_Unif+Dim3+Node_Data+Iparam  &in[] {	/* uniform input field */
        nnodes+req;
        nnode_data+opt;
        node_data+opt;
    };

    Plane_Grid+Xform+Iparam  &plane {	/* slice plane */
        points+req;
    };

    float+notify+IPort2  dist;			/* plane distance */
    int+read+notify+opt+IPort2    map_comp[];

    Mesh_Unif+Dim2+Node_Data+Oparam  out[];	/* output field */

    omethod+notify_val+notify_inst slice_update<status=1> =
        "DV_ARRslice_update";
};

module DVslice_rect_ARR { /* slice a rectilinear field */
    Mesh_Rect+Dim3+Node_Data+Iparam  &in[] {	/* rectilinear input field */
        nnodes+req;
        nnode_data+opt;
        node_data+opt;
    };

    Plane_Grid+Xform+Iparam  &plane {	/* slice plane */
        points+req;
    };

    float+notify+IPort2  dist;		/* plane distance */
    int+read+notify+opt+IPort2    map_comp[];

    Mesh_Rect+Dim2+Node_Data+Oparam out[];	/* output field */

    omethod+notify_val+notify_inst slice_update<status=1> =
        "DV_ARRslice_update";
};

macro DVslice_gen_ARR {
    Mesh+IPort2  &in[];	/*  input field */

    Plane_Grid+Xform+IPort2  &plane;	/* slice plane */

    float+IPort2  dist;		/* plane distance */
    int+IPort2    map_comp[];
    int+IPort2    cell_data[];

    // Internal temporary
    NParam_Data+nonotify+nosave nparam<NEvisible=0>;
    // Internal temporary
    Node_Data+Scalar+Float+nonotify+nosave plane_out<NEvisible=0>;

    Mesh+Node_Data+OPort2+nosave out[] {
        &xform+nowrite;
    };

    omethod+notify_val+notify_inst slice_gen_update<status=1> =
        "DV_ARRslice_gen_update";
};

macro DVslice_ARR {
    Mesh+Iparam &in[] {	/*  input field */
        nnodes+req;
    };
    Plane_Grid+Xform+Iparam &plane {	/* slice plane */
        points+req;
    };
    float+notify+IPort2 dist;		/* plane distance */
    int+read+notify+opt+IPort2 map_comp[];
    int+read+notify+opt+IPort2 cell_data[];

    DVslice_gen_ARR slice_gen {
        in => <-.fld_match.links.link2;
        plane => <-.plane;
        &dist => <-.dist;
        &map_comp => <-.map_comp;
        &cell_data => <-.cell_data;
    };

    DVslice_unif_ARR slice_unif {
        in => <-.fld_match.links.link0;
        plane => <-.plane;
        &dist => <-.dist;
        &map_comp => <-.map_comp;
    };

    DVslice_rect_ARR slice_rect {
        in => <-.fld_match.links.link1;
        plane => <-.plane;
        &dist => <-.dist;
        &map_comp => <-.map_comp;
    };

    DVfld_match_ARR fld_match {
        in => <-.in;
    };

    DVswitch DVswitch {
        in => {slice_unif.out, slice_rect.out, slice_gen.out};
        index => fld_match.index;
    };

    olink out => DVswitch.out;
};

module DVsolid_contour_ARR {
    Mesh+Node_Data+Iparam &in[] {
        xform+nonotify;
        nnodes+req;
    };

    int+Iparam    contour_comp;
    float+Iparam  level[];

    int+Iparam+opt contour_lines;
    int+Iparam+opt color_lines;

    Mesh+Cell_Data+Oparam out[] {
        //&xform+nowrite => in[index_of(out)].xform;
        &xform+nowrite;
    };

    group+write+nonotify lines[] {
        int ncell_sets;
        Line+Cell_Data_Set cell_set[ncell_sets];
    };

    DVmerge_ARR merge_arr {
        in1 => lines;
        in2 => <-.out;
    };

    Mesh+OPort2 &out_line[] => merge_arr.out;

    omethod+notify_val+notify_inst solid_contour_update<status=1> =
        "DV_ARRsolid_contour_update";
};

module DVthreshold_ARR { /* sets NULL data for all values below and/or
			    above min/max threshold level(s) */
    Node_Data+Iparam  &in[] {	/* input field */
        nnodes+req;
    };
    int+Iparam    check_vector;
    int+Iparam    check_comp;
    int+Iparam    thresh_vector;
    int+Iparam    below;	/* toggle to turn on lower thresholding */
    int+Iparam    above;	/* toggle to turn on upper thresholding */
    float+Iparam  min_value;	/* lower threshold value */
    float+Iparam  max_value;	/* upper threshold value */
    float+Iparam  null_value;	/* value to set when data is out of range */

    Node_Data+Oparam  out[];	/* output field */

    omethod+notify_val+notify_inst upd_threshold<status=1> =
        "DV_ARRthreshold_update";
};

}; // FA_Modules

/////////////////////////////////////////////////////////////////////////////

library+sort+buffered FA_Macros<compile_subs=0> {

macro CombineVect_ARR {
    imlink in_fld;
    DV_Param_combine_vect+IPort2 &param;

    DVextr_vector_ARR DVextr_vector {
        in => in_fld;
        &veclen => param.veclen;
        components => param.components[0:param.veclen-1];
        sub_components => param.sub_components[0:param.veclen-1];
    };

    DVcomb_mesh_and_data_ARR DVcomb_mesh_and_data {
        in_mesh => in_fld;
        in_nd => DVextr_vector.out;
    };
    omlink out_fld => DVcomb_mesh_and_data.out;
};

macro ExtractScalar_ARR {
    imlink in_fld;
    DV_Param_extract_scalar+IPort2 &param;

    // DVextract_comp merges in its mesh, which certainly
    // isn't necessary here.
    DVextract_comp_ARR DVextract_comp {
        in => in_fld;
        component => param.vector;
    };

    // DVextr_scalar does not merge its mesh.
    DVextr_scalar_ARR DVextr_scalar {
        in => DVextract_comp.out;  // or out_nd
        &component => param.component;
    };

    DVcomb_mesh_and_data_ARR DVcomb_mesh_and_data {
        in_mesh => in_fld;
        in_nd => DVextr_scalar.out;
    };

    omlink out_fld => DVcomb_mesh_and_data.out;
};

macro Iso_ARR {
    imlink in_fld;
    DV_Param_iso+IPort2 &param;

    DViso_nmap_ARR DViso_nmap {
        // isosurface parameters
        in => in_fld;
        level => param.iso_level;
        &cell_data => param.cell_data;
        component => param.iso_component;
        // nmap parameters
        &map_comp => param.map_component;
        iso_comp => param.iso_component;
        iso_val => param.iso_level;
    };

    omlink out_fld => DViso_nmap.out;
};

macro Threshold_ARR {
    imlink in_fld;
    DV_Param_thresh+IPort2 &param;

    DVthreshold_ARR DVthreshold {
        in => in_fld;
        check_vector => param.check_vector;
        check_comp => param.check_comp;
        thresh_vector => param.thresh_vector;
        below => param.below;
        above => param.above;
        min_value => param.min_value;
        max_value => param.max_value;
        null_value => param.null_value;
    };

    DVcomb_mesh_and_data_ARR DVcomb_mesh_and_data {
        in_mesh => in_fld;
        in_nd => DVthreshold.out;
    };

    omlink out_fld => DVcomb_mesh_and_data.out;
};

}; // FA_Macros


library+sort+buffered FA_Filters<compile_subs=0> {

macro combine_sets_ARR {
    // Ever notice that the inputs are usually a "field", while
    // the outputs are usually a "fld"?.
    imlink in_fields;

    DVcombine_sets_ARR DVcombine_sets {
        in => <-.in_fields;
    };

    DataObjectNoTexture obj {
        in => DVcombine_sets.out;
        Obj {
            name => name_of(<-.<-.<-);
            xform_mode = GD_XFORM_MODE_PARENT;
        };
    };

    olink out_fld => DVcombine_sets.out;  // This really is a single field
    olink out_obj => obj.obj;
};

MODS_ARR.combine_vect_ARR combine_vect_ARR {
    CombineVect_ARR CombineVect {
        in_fld => in_field;
        param => CombineVectParam;
    };

};

MODS_ARR.crop_ARR crop_ARR {
    DVcrop_ARR DVcrop {
        DV_Param_crop+IPort2 &param => CropParam;
        in => in_field;
        min => param.min;
        max => param.max;
    };
};

MODS_ARR.downsize_ARR downsize_ARR {
    DVdownsize_ARR DVdownsize {
        DV_Param_downsize+IPort2 &param => DownsizeParam;
        in => in_field;
        factor => param.factor[0:in[0].ndim-1];
    };
};

MODS_ARR.extract_component_ARR extract_component_ARR {

    DVextract_comp_ARR DVextract_comp {
        DV_Param_extr_comp+IPort2 &param => ExtrCompParam;
        in => in_field;
        &component => param.component;
    };
};

macro extract_mesh_ARR { // or extract_mesh_arr
    imlink in_field<export_all=1>;

    DVextract_mesh_ARR DVextract_mesh {
        in => in_field;
    };

    DataObjects objs {
        in_fields => DVextract_mesh.out;
        dos.Obj.xform_mode = 1;
        dos {
            Obj {
                name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
            };
        };
    };
    GroupObject obj {
        Top.name => name_of(<-.<-.<-);
        child_objs => objs.dos.obj;
    };

    omlink out_fld<export_all=2> => DVextract_mesh.out;
    olink out_obj => obj.obj;
};

MODS_ARR.extract_scalar_ARR extract_scalar_ARR {
    ExtractScalar_ARR ExtractScalar {
        in_fld => in_field;
        param  => ExtractScalarParam;
    };
};

MODS_ARR.set_minmax_ARR set_minmax_ARR {
    DVset_minmax_ARR DVset_minmax {
        DV_Param_minmax+IPort2 &param => SetMinmaxParam;
        in => in_field;
        comp => param.comp;
        min => param.min;
        max => param.max;
    };

    DVcomb_mesh_and_data_ARR DVcomb_mesh_and_data {
        in_mesh => in_field;
        in_nd => DVset_minmax.out;
        //in_mesh => ;
        //in_nd => ;
    };

    // Remove DVcomb_mesh_and_data
    //objs.in_fields => DVset_minmax.out;
    //objs.in_fields => ;
    //out_fld => DVset_minmax.out;
};

MODS_ARR.threshold_ARR threshold_ARR {
    Threshold_ARR Threshold {
        in_fld => in_field;
        param  => ThreshParam;
    };
};

}; // FA_Filters


library+sort+buffered FA_Mappers<compile_subs=0> {

MODS_ARR.bounds_ARR bounds_ARR {
    DVbounds_ARR DVbounds {
        DV_Param_bounds+IPort2 &param => BoundsParam;
        in => in_field;
        hull => param.hull;
        edges => param.edges;
        faces => param.faces;
        imin => param.imin;
        imax => param.imax;
        jmin => param.jmin;
        jmax => param.jmax;
        kmin => param.kmin;
        kmax => param.kmax;
        data => param.data;
        component => param.component;
    };
};

MODS_ARR.contour_ARR contour_ARR {
    DVcontour_ARR DVcontour {
        DV_Param_contour+IPort2 &param => ContourParam;
        in => in_field;
        &contour_comp => param.contour_comp;
        map_comp => param.map_comp;
        &level_min => param.level_min;
        &level_max => param.level_max;
    };

    DVnode_minmax_ARR min_max {
        in_field => <-.in_field;
        component => <-.ContourParam.contour_comp;
    };
};

MODS_ARR.edges_ARR edges_ARR {
    DVedges_ARR DVedges {
        in => <-.in_field;
    };
};

MODS_ARR.glyph_ARR glyph_ARR {
    DVglyph_ARR DVglyph {
        DV_Param_glyph+IPort2 &param => GlyphParam;
        in => in_field;
        glyph => in_glyph;
        glyph_comp => param.glyph_comp;
        map_comp => param.map_comp;
        scale_comp => param.scale_comp;
        vector => param.vector;
        scale => param.scale;
        scale_x => param.scale_x;
        scale_y => param.scale_y;
        scale_z => param.scale_z;
        normalize => param.normalize;
    };
};

MODS_ARR.isoline_ARR isoline_ARR {
    DVisoline_ARR DVisoline {
        DV_Param_contour+IPort2 &param => IsoParam;
        in => in_field;
        &component => param.contour_comp;
        &level => init_array(param.ncontours, param.level_min,param.level_max);
        &color => param.color;
    };

   DVnode_minmax_ARR min_max {
        in_field => <-.in_field;
        component => <-.IsoParam.contour_comp;
    };
};

MODS_ARR.isosurface_ARR isosurface_ARR {
    Iso_ARR Iso {
        in_fld => in_field;
        param => IsoParam;
        DViso {
            cell_data => switch(has_cell_data, param.cell_data);
        };
    };

    DVnode_minmax_ARR min_max {
        in_field => <-.in_field;
        component => <-.IsoParam.iso_component;
    };
};

MODS_ARR.orthoslice_ARR orthoslice_ARR {
    DVorthoslice_ARR DVorthoslice {
        DV_Param_ortho_slice+IPort2 &param => OrthoSliceParam;
        in => in_field;
        &axis => param.axis;
        &plane => param.plane;
    };
};

MODS_ARR.slice_plane_ARR slice_plane_ARR {
    DVslice_ARR DVslice {
        DV_Param_slice+IPort2 &param => SliceParam;
        in => in_field;
        plane => <-.plane;
        dist => param.dist;
        map_comp => param.component;
        cell_data => switch(<-.has_cell_data, param.cell_data);
    };

};

MODS_ARR.solid_contour_ARR solid_contour_ARR {
    DVsolid_contour_ARR DVsolid_contour {
        DV_Param_contour+IPort2 &param => ContourParam;
        in => in_field;
        contour_comp => param.contour_comp;
        &level => init_array(param.ncontours+1,param.level_min,param.level_max);
        contour_lines => param.contour_lines;
        color_lines => param.color;
    };

    DVnode_minmax_ARR min_max {
        in_field => <-.in_field;
        component => <-.ContourParam.contour_comp;
    };
};

}; // FA_Mappers

}; // FAST_ARR
