/*
			Copyright (c) 1993 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/file.v#1 $
*/
flibrary+global+sort FILE <
   build_dir="gmod",
   link_files="-lgmod",
   c_hdr_files="avs/gmod.h",
   out_hdr_file="uci_file.h",
   out_src_file="uci_file.c",
   hdr_code="void FILEinit (void);",
   pre_init_code="   FILEinit();"
> {

$declare_type Tfile_obj ival_func
$declare_type Tfile_find_expr lval_func
$declare_type Tfile_skip_lines lval_func
$declare_type Tfile_skip_words lval_func

module+OPort file <struct_name    = "FileStruct",
	   struct_bitmask = "FileBitmask"> {
   string+Iparam	name;
   ptr+write+nonotify   fptr;
   int+Oparam		status;
   int+write+nonotify   cur_offset;
   cmethod+notify_val+notify_inst file_update<weight=0> = "FileUpdate";
   cmethod+notify_del	file_del              = "FileDel";
};

Tfile_obj+Port file_obj {
	file+IPort2 *file;
	int+IPort2  *offset;/* byte begining */
	int+IPort2  *type; /* int, float, etc. */
	int+IPort2  *columns[];
	enum+IPort2 *ascii_binary {
		 choices = {"ascii", "binary", "xdr"};
	};
	int+IPort2+opt *stride;
};

file_obj file_obj_bin {
	ascii_binary = 1;
};

file_obj file_scalar_ascii {
	ascii_binary = 0;
};

file_obj file_array_ascii {
	ascii_binary = 0;
};

Tfile_find_expr+Port  file_find_expr{
	file+IPort2 *file;
	int+IPort2  *offset;/* byte begining */
	string+IPort2  *pattern;
};

Tfile_skip_lines+Port  file_skip_lines{
	file+IPort2 *file;
	int+IPort2  *offset;/* byte begining */
	int+IPort2  *nlines;
};

Tfile_skip_words+Port  file_skip_words{
	file+IPort2 *file;
	int+IPort2  *offset;/* byte begining */
	int+IPort2  *nwords;
};

//
// A library of modules for compatability with older versions
// they are here since this library is global and the GMOD library
// used to be global.
//
// Since this library is not a user library, references to these objects
// will be fixed when they are saved.
library Compat<NEvisible=0,user_library=0> {
   GMOD.parse_v parse_v_relative;
   GMOD.parse_v parse_v_relative_no_inst {
      on_inst = 0;
   };
   GMOD.load_v_script load_scr_relative;
   GMOD.loop loop;
   GMOD.timer timer;
   FILE.file_obj_bin    Tfile_obj_bin;
   FILE.file_scalar_ascii    Tfile_scalar_ascii;
   FILE.file_array_ascii     Tfile_array_ascii;
};

};
