/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd.v#1 $
*/

flibrary+global GD <
   //
   // indicates the class of virtual data needed by this component.
   // view_available is needed because we need to force a dependency
   // on the GD renderers (e.g GDSW)
   //
   need_virtual	= "render view_available pick_points output_init", 
   build_dir	= "gd",
   build_cmd	= "$(MAKE)",
   hdr_code	= "void GDinit (int *argc, char **argv);",
   init_code	= "   GDinit(argc, argv);",
   edit_lic	= "GD",
   libdeps	= "PAL WTOOL",
   need_objs	= "CONFIG",
   link_files	= "-lgd -lmutil $(WINLIBS)"
> {

$include ../include/avs/gd_def.h
$include ../include/$MACHINE/gd_ren.h

library+global+sort Templates<locked=1> {

   /**************************************/
   /* Templates associated with GDminmax */
   /**************************************/

   group GDminmax {
      group+read+IPort2 &input<NEnumColors=4,NEcolor0=0xff> {
	 data_method render;
      };
      double+OPort2+write+nonotify min_value;
      double+OPort2+write+nonotify max_value;
      method+notify_inst+notify_val upd_func = "GDminmax_update";
   };
   group VolRenderMinMax {
      group+read+IPort2 &input<NEnumColors=4,NEcolor0=0xff> {
	 data_method render;
      };
      double+OPort2+write+nonotify min_value;
      double+OPort2+write+nonotify max_value;
      method+notify_inst+notify_val upd_func = "GDvol_minmax_update";
   };
   group GDminmaxArr {
      group+read+IPort2 &input<NEnumColors=4,NEcolor0=0xff>[] {
	 data_method render;
      };
      double+OPort2+write+nonotify min_value;
      double+OPort2+write+nonotify max_value;
      method+notify_inst+notify_val upd_func = "GDminmaxArr_update";
   };

   /***************************************/
   /* Templates associated with GDtexture */
   /* Put texture here for now since it   */
   /* refers to a field		          */
   /***************************************/

   /* This template is used when getting the sequence
      number of the input field data when doing texture
      mapping.
   */
   Cells+Data GDdata_seq_templ {
      int nnodes;
      int nspace;
      Data_Array coordinates;
   };

   group+OPort GDtexture_templ {
      Node_Data+Byte+IPort2 &data;
      Node_Data+IPort2      &colormap;
      enum+read tile {
	 choices = {"Clamp", "Wrap", "Boundary"};
      };
      enum alpha {
	 choices = {"Replace", "Modulate", "Decal"};
      };
      enum filter {
	 choices = {"Point", "Bilinear", "Trilinear"};
      };
      enum type {
	 choices = {"Single Level", "Mip-Map"};
      };
      int                   stage;
      ptr+nonotify          local_ptr<NEvisible=0>;
   };

   // This object needs the GDdata_seq_templ dynamically...
   GDtexture_templ GDtexture<need_objs="GDdata_seq_templ",
			     cxx_name="GDXtexture"> {
      local_ptr+write;
      method+notify_inst+notify_val upd_func = "GDtexture_update";
      method+notify_deinst del_func = "GDtexture_delete";
   };

   /**************************************/
   /* Templates associated with GDobject */
   /**************************************/

   group GDobj_data_notify_templ {
      group+read+IPort2 &input<NEnumColors=4,NEcolor0=0xff> {
	 data_method render;
      };
      method+notify_inst+notify_val data_func = "GDobject_data";
   };

   group GDobj_notify_templ {
      DatamapTempl+IPort2+read    &dmap<export_all=1>;
      GDxform_templ+IPort2+read   &xform;
      GDxform_templ+IPort2+read   &alt_xform;
      GDxform_templ+IPort2+read   &txtr_xform;
      GDprops_templ+IPort2+read   &props;
      GDmodes_templ+IPort2+read   &modes;
      GDtexture_templ+IPort2+read &texture;
      int nobjs;
      group+IPort2+read *objects<NEcolor0=0xff0000>[] {
	 GDxform_templ &xform;
	 GDprops_templ &props;
	 GDmodes_templ &modes;
	 GDpick_info_templ &pick_info;
	 ptr local_ptr;
      };
      int use_altobj;
      group+IPort2+read &altobj<NEcolor0=0xff0000> {
	 GDxform_templ &xform;
	 GDprops_templ &props;
	 GDmodes_templ &modes;
	 GDpick_info_templ &pick_info;
      };
      prim+read+nonotify ptr_depends[] => objects.local_ptr;
      int+read visible;
      enum+read space {
	 choices = {"Match Camera", "Force 2D"};
      };
      int+read cached;
      int+read cache_size;
      enum+read xform_mode {
	 choices = {"Normal", "Parent", "Alternate", "Locked"};
      };
      enum+read surf_conv {
	 choices = {"Simple", "Optimal", "None"};
      };
      int+read chunk;
      int+read surf_chunk;
      int+read line_chunk;
      int+read surf_subdiv;
      int+read active;
      enum+read type {
	 choices = {"Static", "Dynamic"};
      };
      enum+read dith_tech {
	 choices = {"Cube", "Ramp"};
      };
      enum+read interp_type {
	 choices = {"Point", "Bilinear", "Bicubic", "Flat", "Smooth", "Point/Image", "Bilinear/Image", "Bicubic/Image"};
      };
      int+read tmap_method;
      int+read tri_subdiv_type;
      int+read tri_subdiv_aval;
      int+read tri_subdiv_fval;
      float missing_val;
      float missing_rgb[3];
      float window[6];
      string name<cxx_name="GDXname">;
      string+read WWW_url;
      string+read WWW_label;
      ptr+nonotify+write local_ptr<NEvisible=0>;
      method+notify_inst+notify_val upd_func = "GDobject_update";
      method+notify_deinst del_func = "GDobject_delete";
   };

   GDobj_data_notify_templ+GDobj_notify_templ+Port GDobject_templ<NEcolor0=0xff0000> {
      GDpick_info_templ+IPort2 &pick_info;
      int pickable;
      // Cache for the 2d cells that are generated by taking the
      // external faces of 3d cells.
      Cells+Cell_Data+nosave cell_set_2d {
	 ncell_sets=0;
	 cell_set {
	    int cell_set_3d;
	    int cells_3d[ncells];
         };
      };
   };
   GDobject_templ GDobject<cxx_name="GDXobject"> {
      nobjs => array_size(objects);
   };

   /* Template used to request notifications for a pick
      on an object. We only want to be notified when the
      input object has changed or if the pick_info has 
      been written. We need to be really restrictive
      on the template so we don't get activated when the
      field data that we refer to changes. Just ask for
      a notify when we are actually picked (ie. npicked).
      Note that we will also get activated when the are
      unpicked - but pick process deals with this by seeing
      that the object is not selected.
   */
   group GDpick_obj_notify_templ {
      group pick_info {
	 int npicked;
      };
   };

   /**************************************/
   /* Templates associated with GDcamera */
   /**************************************/

   /* Defintion of a camera object. Very similar an AVS camera.
      A camera is associated with a view. A camera may be shared
      among views if desired.
   */
   group GDcamera_notify_templ {
      int+read update;
      enum type {
	 choices = {"3D", "2D"};
      };
      enum mode {
	 choices = {"Manual", "Automatic"};
      };
      enum auto_norm {
	 choices = {"None", "Data Change", "Object Attach", "Data and Object"};
      };
      float norm_scale;
      int norm_invisible;
      enum extents {
	 choices = {"Compute", "Window"};
      };
      enum mapping {
	 choices = {"World", "Pixel"};
      };
      int image_pass;
      int pickable;
      /* array of objects to render */
      int nobjs;
      GDobject_templ+IPort2+read *objects[];
      prim+read ptr_depends[] => objects.local_ptr;
      /* viewport specification */
      float xmin;
      float ymin;
      float xmax;
      float ymax;
      /* camera orientation */
      float from[3];
      float up[3];
      float at[3];
      float scale;
      GDxform_templ+IPort2 &xform;
      /* camera projection */
      int perspec;
      int hither;
      float front;
      float back;
      float fov;
      float wsize;
      /* depth cue information */
      int depth_cue<animate=1>;
      float depth_front<animate=1>;
      float depth_back<animate=1>;
      float depth_scale<animate=1>;
      float jitter_scale<animate=1>;
      int+write dep<NEvisible=0>;
      method+notify_val upd_func = "GDcamera_update";
      method+notify_deinst del_func = "GDcamera_delete";
   };

   GDcamera_notify_templ+OPort GDcamera_templ;

   GDcamera_templ GDcamera<NEsmallPixmapName="camera.bmx",
			   cxx_name="GDXcamera"> {
      nobjs => array_size(objects);
      ptr+nonotify+write local_ptr<NEvisible=0>;
   };


   /********************************************/
   /* Templates associated with GDview_buffers */
   /********************************************/

   /* This group defines the framebuffer and zbuffer information
      that can be output/into from/to a view.
   */

   group+OPort GDview_buffers {
      enum fb_type {
	 choices = {"None", "ARGB", "RGBA", "ABGR"};
      };
      Mesh_Unif+Dim2+Space2+Node_Data+Vector4+nosave framebuffer;
      enum zb_type {
	 choices = {"None", "Short", "Float 1 Near", "Float 0 Near", "Int"};
      };
      Mesh_Unif+Dim2+Space2+Node_Data+Scalar+nosave zbuffer;
   };

   /**************************************/
   /* Templates associated with GDoutput */
   /**************************************/

   /* Basic template for groups derived from the
      output class.
   */
   group+OPort GDoutput_templ {
      int type;		/* used to specify unique virtual functions */
   };

   /* Group that controls the field output
      from a viewer. Only enabled causes a
      notifcation. The output field should not !!
   */
   GDoutput_templ GDfield_output_templ {
      int+read flip;
      int clear;
      GDview_buffers+OPort2+write buffers {
	 framebuffer+nonotify;
	 zbuffer+nonotify;
      };
      ptr+nonotify+write local_ptr<NEvisible=0>;
      method+notify_inst init = "GDfield_output_create";
      method+notify_deinst delete() = "GDfield_output_delete";
      method+notify_val update = "GDfield_output_update";
   };
   GDfield_output_templ GDfield_output {
      /* This is here to maintain compatibility with V2.0 */
      Mesh_Unif+Dim2+Space2+Node_Data+Vector4+OPort2 &output => buffers.framebuffer;
   };

   /* Group that controls the file output
      from a viewer. Only enabled causes a
      notifcation. The filename should not !!
   */
   GDoutput_templ GDfile_output_templ {
      int+read flip;
      string+IPort filename;
      ptr+nonotify+write local_ptr<NEvisible=0>;
      method+notify_inst init = "GDfile_output_create";
      method+notify_deinst delete() = "GDfile_output_delete";
      method+notify_val update = "GDfile_output_update";
   };
   GDfile_output_templ GDfile_output;

#ifdef PRT_RENDERER
   /* Group that controls the printer output
      from a viewer.
   */
#ifdef MSDOS
   /* Printing on PC does not have a dependency on the AG kit. */
   GDoutput_templ GDprt_output_templ<disabled => Templates.CONFIG.gd_prt_disabled> {
#else
   GDoutput_templ GDprt_output_templ<disabled=> 
	(Templates.CONFIG.gd_prt_disabled | Templates.CONFIG.ag_kit_disabled)> {
#endif
      string+read file<NEportLevels={0,2}>;
      int format<NEportLevels={0,2}>;		// 0=PS, 1=ColPS, 2=PS2,
						// 3=CGMbin, 4=CGMclt, 5=CGMchar
#ifdef MSDOS
      int color<NEportLevels={0,2}>;		// 0=monochrome(only PS lev1) 1=color
#endif
      int backgroundType<NEportLevels={0,2}>;	// 0=white, 1=black, 2=keep 
      int orientation<NEportLevels={0,2}>;	// 0=landscape 1=portrait
      int size<NEportLevels={0,2}>;		// 0=User(EPS) 1=A 2=B 3=A4 4=A3 5=A0
      float widthMM<NEportLevels={0,2}>;
      float heightMM<NEportLevels={0,2}>;
      int resolution<NEportLevels={0,2}>;	// number of pixels for 3D image
      float fromRatio;				// aspect ratio of the view to make print from
      int fromWidth;				// width of visible view
      int fromHeight;				// height of visible view
      float sizeX<NEportLevels={0,2}>;		// actual size used by printer
      float sizeY<NEportLevels={0,2}>;          // actual size used by printer
#ifdef MSDOS
      ptr+IPort2 devMode;
      ptr+IPort2 devNames;
#endif
      ptr+nonotify+write local_ptr<NEvisible=0>;
      method+notify_inst init = "GDprt_output_create";
      method+notify_deinst delete() = "GDprt_output_delete";
      method+notify_val update = "GDprt_output_update";
   };
   GDprt_output_templ GDprt_output;
#endif

#ifdef VRML_RENDERER
   GDoutput_templ GDvrml_output_templ <
      disabled => Templates.CONFIG.gd_vrml_disabled
   > {

      type <NEvisible=0>;

      string+IPort         file;
      enum                 protocol {
                              choices = {       "VRML1",      "VRML2" };
			      values  = { GD_WWW_VRML1, GD_WWW_VRML2  };
                           };
      int                  floatPrec { min = 1; max = 8; };
      int                  xformPrec { min = 1; max = 8; };
      int                  colorPrec { min = 1; max = 8; };
      boolean              indent;
      boolean              suppressNormals;

      int                  width  { min = 1; };
      int                  height { min = 1; };

      ptr+nonotify+write   local_ptr <NEvisible=0>;

      method+notify_inst   init   = "GDvrml_output_create";
      method+notify_deinst delete = "GDvrml_output_delete";
      method+notify_val    update = "GDvrml_output_update";
   };

   GDvrml_output_templ GDvrml_output;
#endif

#ifdef VPS_RENDERER
   GDoutput_templ GDvps_output_templ <
      disabled => Templates.CONFIG.gd_vps_disabled
   > {

      type <NEvisible=0>;

      string+IPort         file;
      enum                 format {
                              choices = { "Color", "Greyscale" };
                           };
      enum                 backMode {
                              choices = { "White", "Black", "Keep" }; };
      enum                 size {
                              choices = { "EPS", "A", "B", "A4", "A3", "A0" };
                           };
      float                widthMM   { min = 1; };
      float                heightMM  { min = 1; };
      float                marginMM  { min = 1.0; };

      int                  floatPrec { min = 1; max = 8; };
      int                  xformPrec { min = 1; max = 8; };
      int                  colorPrec { min = 1; max = 8; };

      float                alphaThreshold {min = 0.0; max = 1.0; };

      enum                 colorSub  {
                              choices = { "None", "Pre", "Post" };
                           };
      float                colorTol  { min = 0.01; max = 1.0; };

      // Depth Sort Algorithm for determining visibility ordering.
      // Default - Use simple (but fast) sort by minimum z coordinate.
      // NNS     - Use Newell, Newell, and Sancha algorithm.
      enum                 depthSort {
                              choices = { "Default", "NNS" };
                           };
      // zSub and zTol are deprecated, use depthSort instead.
      enum                 zSub {
                              choices = { "None", "Pre" };
                           };
      float                zTol { min = 1E-5; max = 1.0; };

      enum                 gammaMode  {
                              choices = { "None", "Pre", "Post" };
                           };
      float                gamma { min = 0.01; };

      enum                 orientation {
                              choices = { "Landscape", "Portrait" };
                           };

      boolean              indent;

      ptr+nonotify+write   local_ptr <NEvisible=0>;

      method+notify_inst   init   = "GDvps_output_create";
      method+notify_deinst delete = "GDvps_output_delete";
      method+notify_val    update = "GDvps_output_update";
   };

   GDvps_output_templ GDvps_output;
#endif

   /************************************/
   /* Templates associated with GDview */
   /************************************/

   //
   // this object defines the classes of virtual data that this object
   // needs by referencing these types, we'll end up picking up the
   // definitions of any objects that define virtual "view_available"
   // etc. through binary V and the compile operation. 
   //

   // IAC/MPU: added "MPU" to choice list

   group GDview_render_templ {
      enum renderer {
	 choices = { "Software", "OpenGL", "XGL", "PEX",
                     "XIL", "MPU", "Print", "VRML", "VPS" };
      };
      func+virtual view_available;
      func+virtual state_create;
      func+virtual prim_3d_points;
      func+virtual geom_init;
   };

   //
   // This template is used by modules that want to know when the
   // view changes and need a dependency on the view's update methods
   //
   group GDview_ref_templ<NEcolor0=0xff00ff> {
      enum+nonotify renderer; // make sure we connect to a valid view
      int trigger;
      ptr local_ptr;
   };

   GDview_render_templ GDview_notify_templ {
      int+read update;
      int+nonotify list_update;
      int refresh;
      enum mode {
	 choices = {"Manual", "Automatic"};
      };
      enum buffer {
	 choices = {"Single", "Double (MBX)", "Double (Pixmap)"};
      };
      int accel;
      int clear;
      int+nonotify timer;
      int pcache;
      enum aspect {
	 choices = {"Biggest", "Smallest"};
      };
      float back_col<animate=1>[3];
      int stereo;
      int stereo_enable;
      int video;
      float stereo_balance;
      float stereo_offset;
      int video_off;

      GDlight_info_templ+IPort2+read &light_info;
      /* array of cameras to render */
      int ncams;
      GDcamera_templ+IPort2+read+nonotify &cameras[];
      GDview_buffers+IPort2+read &buffers;
      GDoutput_templ+IPort2+read &output {
	 GDview_buffers+opt+noread+write &buffers {
	    framebuffer+nonotify;
	    zbuffer+nonotify;
	 };
      };

      /* volume render blend mode */
      enum blend_mode {
	 choices = {"Alpha", "Saturate"};
      };

      /* true scale parameters */
      int ts_enable;
      int ts_uniform;
      float ts_scale;
      float ts_yscale;
      float ts_xorig;
      float ts_yorig;

      int+write+nonotify trigger;
      ptr+nonotify+write local_ptr<NEvisible=0>;
      method+notify_inst init_func() = "GDview_init";
      method+notify_val upd_func<status=1> = "GDview_update";
      method+notify_deinst del_func = "GDview_delete";
   };

   /* We don't want the view's update virtpal function
      to be notified when update is changed. That will
      be handled by the PALvirtif_update function.
   */
   group PALvirt_notify_templ {
      int vclass;
      int vid;
      int share;
      float gamma;
      int cube_size;
   };

   group GDview_virtpal_templ {
      PALvirt_notify_templ+IPort2+read &virtpal;
      method+notify_val pal_func = "GDview_update_virtpal";
   };

   group GDview_pick_templ {
      GDpick_ctrl_templ+IPort2+read &pick_ctrl;
      method+notify_val pick_func = "GDview_pick";
   };

   group GDview_win_templ {
      UIwinHandle+IPort2+read &handle {
	 // if we don't have a valid widget in the handle, use the display
	 // instead to get the display pointer
	 ptr+opt display;
      };
      method+notify_val win_func<immediate=1> = "GDview_event";
   };

   GDview_notify_templ+GDview_win_templ+GDview_virtpal_templ+GDview_pick_templ+OPort GDview_templ<NEcolor0=0xff00ff> {
      int output_enabled;
      int config_flags;
      int full_view_width;
      int full_view_height;

      /* picked camera and object */
      GDcamera_templ+OPort2+nosave+write &picked_camera;
      GDobject_templ+OPort2+nosave+write &picked_obj;
      int cur_light;
      int selected;
      /* Timer Information: frames rendered, time in seconds and
	 frames per second.
      */
      int frames;
      float seconds;
      float fps;
   };

   GDview_templ GDview<NEsmallPixmapName="binocs.bmx",
	       // this property is necessary to allow us to separate components
	       // during the compile operation.  This object is referenced
	       // programmatically in the code of this object
		       need_objs="PALvirt_notify_templ",
		       cxx_name="GDXview"> {
      ncams => array_size(cameras);
   };

   /*******************************************/
   /* Templates associated with GDview editor */
   /*******************************************/

   /* Define this template to use below to make sure
      the view editor gets run when stuff in the view
      changes - but ONLY stuff that effects the UI.
      By using this template we make sure that the
      editor doesn't run whenever the view updates.
   */
   group GDview_edit_ui_update_templ {
      enum renderer {
	 choices = {"Software", "OpenGL", "XGL", "PEX", "XIL", "MPU", "Print", "VRML", "VPS"};
      };
      int refresh;
      enum mode {
	 choices = {"Manual", "Automatic"};
      };
      enum buffer {
	 choices = {"Single", "Double (MBX)", "Double (Pixmap)"};
      };
      int accel;
      int clear;
      int timer;
      int pcache;
      enum aspect {
	 choices = {"Biggest", "Smallest"};
      };
      float back_col[3];
      int stereo;
      int stereo_enable;
      int video;
      float stereo_balance;
      float stereo_offset;
      int video_off;

      /* volume render blend mode */
      enum blend_mode {
	 choices = {"Alpha", "Saturate"};
      };

      /* true scale parameters */
      int ts_enable;
      int ts_uniform;
      float ts_scale;
      float ts_yscale;
      float ts_xorig;
      float ts_yorig;

      GDoutput_templ+IPort2+read &output {
	 GDview_buffers+opt+noread+write &buffers {
	    framebuffer+nonotify;
	    zbuffer+nonotify;
	 };
      };
   };

   /* We don't want the view's update virtpal function */
   /* This group is used by the view editor in order
      to determine if in the current activation we 
      need to update the view we are attached to.
   */
   group GDview_edit_notify_templ {
      enum renderer {
	 choices = {"Software", "OpenGL", "XGL", "PEX", "XIL", "MPU", "Print", "VRML", "VPS"};
      };
      int accel;
      enum buffer {
	 choices = {"Single", "Double (MBX)", "Double (Pixmap)"};
      };
      int timer;
      enum mode {
	 choices = {"Manual", "Automatic"};
      };
      int pcache;
      int refresh;
      float red;
      float green;
      float blue;
      int output_enabled;
      enum aspect {
	 choices = {"Biggest", "Smallest"};
      };
      int stereo;
      int stereo_enable;
      int video;
      float stereo_balance;
      float stereo_offset;
      int video_off;

      /* volume render blend mode */
      enum blend_mode {
	 choices = {"Alpha", "Saturate"};
      };

      int ts_enable;
      int ts_uniform;
      float ts_scale;
      float ts_yscale;
      float ts_xorig;
      float ts_yorig;
   };

   GDview_edit_notify_templ GDview_edit_templ {
      int+IPort2 shell_vis;
      int reset;
      GDview_edit_ui_update_templ+IPort2+read &view;
      omethod+notify_inst+notify_val upd_func = "GDview_edit_update";
   };

   /*******************************************/
   /* Templates associated with GDview editor */
   /*******************************************/
   /* groups for a view selector module based on
      a general switched module that selects the
      most recent from a list. A pick makes the
      view most recent.
   */

   group GDview_entry {
      GDview_templ &view;
      UIrenderView &renderView;
      int active => view.pick_ctrl.event;
   };

   group GDview_sel_notify_templ {
      GDview_templ+IPort2+read *views[];
      imlink+IPort2 rvs;
      GDview_entry entries[array_size(views)] {
	 view => views[index_of(entries)];
	 renderView => rvs[index_of(entries)];
      };
      method+notify_val update = "select_entry";
   };

   GDview_sel_notify_templ GDview_sel_templ {
      int nentries => array_size(views);
      GDview_entry &selected {
         view+OPort3;
         renderView+OPort3;
      };
   };

   /*********************************************/
   /* Templates associated with GDcamera editor */
   /*********************************************/

   /* This group is used by the camera editor in order
      to determine if in the current activation we 
      need to update the camera we are attached to.
   */
   group GDcamera_edit_notify_templ {
      float from_x;
      float from_y;
      float from_z;
      float up_x;
      float up_y;
      float up_z;
      float at_x;
      float at_y;
      float at_z;
      float scale;
      float wsize;
      float fov;
      float front;
      float back;
      int perspec;
      int hither;
      int depth_cue;
      float depth_front;
      float depth_back;
      float depth_scale;
      enum type {
	 choices = {"3D", "2D"};
      };
      enum auto_norm {
	 choices = {"None", "Data Change", "Object Attach", "Data and Object"};
      };
      float norm_scale;
      int norm_invisible;
      int image_pass;
      int pickable;
      enum extents {
	 choices = {"Compute", "Window"};
      };
      enum mapping {
	 choices = {"World", "Pixel"};
      };
      float jitter_scale;
   };

   GDcamera_edit_notify_templ GDcamera_edit_templ {
      int+IPort2 shell_vis;
      int reset;
      GDcamera_templ+IPort2 &camera {
	 int+read dep;
      };
      omethod+notify_inst+notify_val upd_func = "GDcamera_edit_update";
   };

   /*************************************************/
   /* Templates associated with GDlight info editor */
   /*************************************************/

   /* This group is used by the light info editor in order
      to determine if in the current activation we 
      need to update the light info we are attached to.
   */
   group GDlinfo_edit_notify_templ {
      int show;
      int amb_onoff;
      float amb_red;
      float amb_green;
      float amb_blue;
      int cur_light;
   };

   GDlinfo_edit_notify_templ GDlinfo_edit_templ {
      int+IPort2 shell_vis;
      int reset;
      GDlight_info_templ+IPort2+read &light_info;
      GDlight_templ &sel_light;
      omethod+notify_inst+notify_val upd_func = "GDlinfo_edit_update";
   };

   /********************************************/
   /* Templates associated with GDlight editor */
   /********************************************/

   /* This group is used by the lights editor in order
      to determine if in the current activation we 
      need to update the light we are attached to.
   */
   group GDlight_edit_notify_templ {
      int state;
      enum type {
	 choices = {"Directional", "Point", "Spot", "BiDirectional"};
      };
      float red;
      float green;
      float blue;
      float att1;
      float att2;
      float concen;
      float angle;
   };

   GDlight_edit_notify_templ GDlight_edit_templ {
      int+IPort2 shell_vis;
      int reset;
      GDlight_templ+IPort2+read &light {
	 xform+nonotify; // don't care when xform changes
      };
      omethod+notify_inst+notify_val upd_func = "GDlight_edit_update";
   };

   /*********************************************/
   /* Templates associated with object selector */
   /*********************************************/
   /* Template that tells use when:
	o the list of cameras and objects in the view has changed (list_update)
	o the picked object has changed
   */
   group GDobj_sel_view_templ<NEcolor0=0xff00ff> {
      int list_update;
      GDobject_templ *picked_obj;
   };

   group GDobj_sel_notify_templ {
      GDobj_sel_view_templ+IPort2+read &view;
      int all_cameras;
      int+OPort2 &sdims;
      string+OPort2+write curobj_name;
      method+notify_inst+notify_val upd_func = "GDobj_sel_update";
      method+notify_deinst del_func = "GDobj_sel_delete";
   };
   GDobj_sel_notify_templ GDobj_sel_templ {
      string+OPort2 strings[sdims];
      GDobject_templ+OPort2+nonotify &cur_obj;
   };


   /*********************************************/
   /* Templates associated with GDobject editor */
   /*********************************************/

   /* This group is used by the object editor in order
      to determine if in the current activation we 
      need to update the object we are attached to.
   */
   group GDobj_edit_notify_templ {
      int visible;
      int pickable;
      string www_url;
      string www_label;
      int cached;
      int cache_size;
      enum surf_conv {
	 choices = {"Simple", "Optimal", "None"};
      };
      int chunk;
      int surf_chunk;
      int line_chunk;
      int surf_subdiv;
      enum type {
	 choices = {"Static", "Dynamic"};
      };
      enum dith_tech {
	 choices = {"Cube", "Ramp"};
      };
      enum interp_type {
	 choices = {"Point", "Bilinear", "Bicubic", "Flat", "Smooth", "Point/Image", "Bilinear/Image", "Bicubic/Image"};
      };
      int tmap_method;
      int tri_subdiv_type;
      int tri_subdiv_aval;
      int tri_subdiv_fval;
      float missing_val;
      float missing_red;
      float missing_green;
      float missing_blue;
      enum xform_mode {
	 choices = {"Normal", "Parent", "Alternate", "Locked"};
      };
      int reset;
      int normalize;
      int center;
      int use_altobj;
      enum space {
	 choices = {"Match Camera", "Force 2D"};
      };
   };

   GDobj_edit_notify_templ GDobj_edit_templ {
      int+IPort2 shell_vis;
      GDcamera_templ+IPort2+read *camera;
      GDobject_templ+IPort2+read *object;
      omethod+notify_inst+notify_val upd_func = "GDobj_edit_update";
   };

   /********************************************/
   /* Templates associated with GDmodes editor */
   /********************************************/

   /* This group is used by the modes editor in order
      to determine if in the current activation we 
      need to update the modes we are attached to.
   */
   group GDmodes_edit_notify_templ {
      enum points {
	 choices = {"Inherit", "None", "Pixel", "Line Directed", "Arrow Directed", 
		    "Cone Directed", "Cross Tangent"};
      };
      enum lines {
	 choices = {"Inherit", "None", "Regular", "Tube", "Arrow", "Ribbon"};
      };
      enum surf {
	 choices = {"Inherit", "None", "No Lighting", "Flat", "Gouraud", "Background"};
      };
      enum volume {
	 choices = {"Inherit", "None", "BTF Texture", "Ray Tracer"};
      };
      enum bounds {
	 choices = {"Inherit", "None", "Bounds"};
      };
      enum normals {
	 choices = {"Inherit", "None", "Vertex"};
      };
      int colors;
      enum outline {
         choices = {"On", "Off"};
      };
   };

   GDmodes_edit_notify_templ GDmodes_edit_templ {
      int+IPort2 shell_vis;
      int reset;
      GDmodes_templ+IPort2+read &modes;
      omethod+notify_inst+notify_val upd_func = "GDmodes_edit_update";
   };

   /********************************************/
   /* Templates associated with GDprops editor */
   /********************************************/

   /* This group is used by the props editor in order
      to determine if in the current activation we 
      need to update the props we are attached to.
   */
   group GDprops_edit_notify_templ {
      float red;
      float green;
      float blue;
      float hi1_red;
      float hi1_green;
      float hi1_blue;
      float hi2_red;
      float hi2_green;
      float hi2_blue;
      float spec_red;
      float spec_green;
      float spec_blue;
      float ambient;
      float diffuse;
      float specular;
      float spec_exp;
      float trans;
      float metal;
      enum draw_mode {
	 choices = {"Copy", "XOR"};
      };
      int line_width;
      enum line_style {
	 choices = {"Solid", "Dashed", "Dotted", "DashDot"};
      };
      int line_aa;
      float dir_pt_size;
      int subdiv;
      int jitter;
      enum cull {
	 choices = {"Normal", "Back", "Front", "Flip Normals"};
      };
      enum voxel_interp {
	 choices = {"Point", "Trilinear"};
      };
      enum ray_algo {
	 choices = {"Direct Composite", "Average", "Maximum", "Distance to Max", "SFP"};
      };
      enum ray_norm {
	 choices = {"Global", "View", "Ray"};
      };
      int fat_ray;
      float sfp_absorb;
      float sfp_emit;
      int inherit;
   };

   GDprops_edit_notify_templ GDprops_edit_templ {
      int+IPort2 shell_vis;
      int reset;
      GDprops_templ+IPort2+read &props;
      omethod+notify_inst+notify_val upd_func = "GDprops_edit_update";
   };

   /**********************************************/
   /* Templates associated with GDtexture editor */
   /**********************************************/

   /* This group is used by the texture editor in order
      to determine if in the current activation we 
      need to update the texture we are attached to.
   */
   group GDtexture_edit_notify_templ {
      int+IPort2 shell_vis;
      enum tile {
	 choices = {"Clamp", "Wrap", "Boundary"};
      };
      enum alpha {
	 choices = {"Replace", "Modulate", "Decal"};
      };
      enum filter {
	 choices = {"Point", "Bilinear", "Trilinear"};
      };
      enum type {
	 choices = {"Single Level", "Mip-Map"};
      };
      int stage;
   };

   GDtexture_edit_notify_templ GDtexture_edit_templ {
      int+IPort2 shell_vis;
      int reset;
      GDtexture_templ+IPort2+read &texture;
      omethod+notify_inst+notify_val upd_func = "GDtexture_edit_update";
   };

   /********************************************/
   /* Templates associated with GDxform editor */
   /********************************************/

   group GDxform_edit_notify_templ {
      float x_rot;
      float y_rot;
      float z_rot;
      float x_trans;
      float y_trans;
      float z_trans;
      float x_cent;
      float y_cent;
      float z_cent;
      float scale;
   };

   GDxform_edit_notify_templ GDxform_edit_templ {
      int+IPort2 shell_vis;
      int absolute;
      int reset;
      float abs_x_rot;
      float abs_y_rot;
      float abs_z_rot;
      float abs_x_trans;
      float abs_y_trans;
      float abs_z_trans;
      float abs_x_cent;
      float abs_y_cent;
      float abs_z_cent;
      float abs_scale;
      GDxform_templ+IPort2+read &xform;
      omethod+notify_inst+notify_val upd_func = "GDxform_edit_update";
   };

   /********************************************/
   /* Templates associated with GDtrack editor */
   /********************************************/

   /* The track editor is connected to a user interface interactor. It
      receives an event and x, y position as input and produces a
      transformation object as output. The mode allows the selection of
      either rotation, scale or translation based on the input x,y
      values. The event signals either start, run or stop.
   */

   group GDtrack_edit_notify_templ {
      int event;
      int x;
      int y;
      int time;
      int reset, normalize, center;
      GDview_ref_templ+read+nonotify &view;
      method+notify_inst+notify_val upd_func = "GDtrack_edit_update";
      method+notify_deinst del_func() = "GDtrack_edit_delete";
   };

   GDtrack_edit_notify_templ GDtrack_edit_templ {
      int mode;
      enum rot_mode {
	 choices = {"Arbitrary", "XY", "Z"};
      } = 0;
      enum scale_mode {
	 choices = {"Uniform", "Non-Uniform"};
      } = 0;
      enum xlate_mode {
	 choices = {"Arbitrary", "X", "Y", "XY"};
      } = 0;
      enum trans_mode {
	 choices = {"Object", "Camera", "Light"};
      };
      enum space {
	 choices = {"Global", "Local"};
      } = 0;
      int cur_light = 0;
      func+virtual track_func;
      GDcamera_templ *camera;
      GDobject_templ *obj;
   };

   /************************************/
   /* Templates for interactive tools. */
   /************************************/

   /* Group that defines the buffers created by the
      roi 2d modules. It contains places for lines,
      boxes and freehand regions to be kept.
   */
   group GDroi2d_buffer {
      int npoints;
      short pointbuf[npoints*2];
      int nlines;
      short linebuf[nlines*4];
      int nbox;
      short boxbuf[nbox*4];
      int nfree;
      int fbuf_size;
      short freebuf[fbuf_size];
   };

   group GDroi2d_cont_notify_templ {
      int+IPort2 state;
      int+IPort2 clear<export=3>;
      int+IPort2 done<export=3>;
      int+IPort2 redraw;
      GDview_ref_templ+IPort2+read+nonotify &view_in;
      method+notify_inst init_func = "GDroi2d_cont_create";
      method+notify_deinst del_func() = "GDroi2d_cont_delete";
      method+notify_val upd_func = "GDroi2d_cont_update";
   };
   GDroi2d_cont_notify_templ GDroi2d_cont_templ {
      int+IPort2 x;
      int+IPort2 y;
      enum draw_mode<export=3> {
	 choices = {"Copy", "XOR"};
      };
      enum mode<export=3> {
	 choices = {"Clear", "Append"};
      };
      enum option<export=3> {
	 choices = {"Point", "Line", "Box", "Polyline", "Polygon"};
      };
      enum immed<export=3> {
	 choices = {"Confirm", "On Button Up"};
      };
      float red<export=3>;
      float green<export=3>;
      float blue<export=3>;
      GDroi2d_buffer+OPort2 out_buf;
      ptr+nonotify local_ptr<NEvisible=0>;
   };

   group GDroi2d_click_notify_templ {
      int+IPort2 add;
      int+IPort2 erase;
      int+IPort2 close;
      int+IPort2 clear<export=3>;
      int+IPort2 done<export=3>;
      int+IPort2 redraw;
      GDview_ref_templ+IPort2+read+nonotify &view_in;
      method+notify_inst init_func = "GDroi2d_click_create";
      method+notify_deinst del_func() = "GDroi2d_click_delete";
      method+notify_val upd_func = "GDroi2d_click_update";
   };
   GDroi2d_click_notify_templ GDroi2d_click_templ {
      int+IPort2 x;
      int+IPort2 y;
      enum mode<export=3> {
	 choices = {"Clear", "Append"};
      };
      enum option<export=3> {
	 choices = {"Point", "Line", "Box", "Polyline", "Polygon"};
      };
      enum immed<export=3> {
	 choices = {"Confirm", "On Button Up"};
      };
      float red<export=3>;
      float green<export=3>;
      float blue<export=3>;
      GDroi2d_buffer+OPort2 out_buf;
      ptr+nonotify local_ptr<NEvisible=0>;
   };

   group GDmap2d_ss_notify_templ {
      GDroi2d_buffer+IPort2 &in_buf;
      int clear<export=3>;
      GDview_ref_templ+IPort2+read+nonotify &view_in;
      method+notify_val upd_func = "GDmap2d_ss_update";
   };
   GDmap2d_ss_notify_templ GDmap2d_ss_templ {
      GDcamera_templ+IPort2 &cam_in;
      GDobject_templ+IPort2 &obj_in;
      enum mode<export=3> {
	 choices = {"Clear", "Append"};
      };
      string name<export=3>;
      int color<export=3>;	/* 0=no cell data, 1=cell data colors */
      float red<export=3>;
      float green<export=3>;
      float blue<export=3>;
      Mesh+OPort2 out_mesh {
	 &xform => obj_in.xform;
      };
   };

   group GDdraw2d_cursor_notify_templ {
      int+IPort2 state;
      GDview_ref_templ+IPort2+read+nonotify &view_in;
      method+notify_inst init_func = "GDdraw2d_cursor_create";
      method+notify_deinst del_func() = "GDdraw2d_cursor_delete";
      method+notify_val upd_func = "GDdraw2d_cursor_update";
   };
   GDdraw2d_cursor_notify_templ GDdraw2d_cursor_templ {
      int+IPort2 x;
      int+IPort2 y;
      int immed<export=3>;
      enum mode<export=3> {
	 choices = {"Clear", "Append"};
      };
      int size<export=3>;
      int thickness<export=3>;
      float red<export=3>;
      float green<export=3>;
      float blue<export=3>;
      GDcamera_templ+IPort2 &cam_in;
      GDobject_templ+IPort2 &obj_in;
      Mesh+OPort2 out_mesh;
      ptr+nonotify local_ptr<NEvisible=0>;
   };

   group GDedit_mesh_notify_templ {
      int+IPort2 state;
      int+IPort2 done<export=3>;
      int+IPort2 add;
      int+IPort2 remove;
      GDobject_templ+IPort2 *picked_obj;
      GDview_ref_templ+IPort2+read+nonotify &view_in;
      method+notify_inst init_func  = "GDedit_mesh_create";
      method+notify_deinst del_func() = "GDedit_mesh_delete";
      method+notify_val upd_func = "GDedit_mesh_update";
   };
   GDedit_mesh_notify_templ GDedit_mesh_templ {
      int+IPort2 x;
      int+IPort2 y;
      enum mode<export=3> {
	 choices = {"Point", "Primitive", "Cell"};
      };
      enum draw_mode<export=3> {
	 choices = {"Copy", "XOR"};
      };
      enum immed<export=3> {
	 choices = {"Confirm", "On Button Up"};
      };
      float red<export=3>;
      float green<export=3>;
      float blue<export=3>;
      GDcamera_templ+IPort2 &cam_in;
      ptr+nonotify local_ptr<NEvisible=0>;
   };

   group GDvector2raster_notify_templ {
      Mesh+Iparam &input;
      int inside<export=3>;
      string name<export=3>;
      Field_Unif+Dim2+Space2+Oparam output;
      method+notify_val upd_func = "GDvector2raster_update";
   };
   GDvector2raster_notify_templ GDvector2raster_templ {
      GDobject_templ+IPort2 &obj_in;
   };

   /******************************************/
   /* Templates for pick processing modules. */
   /******************************************/

   /* This module is meant to connect up to 
      any object in the hierarchy and fire
      only when the object is picked. It will
      query the pick information and write some
      of it out to other elements in the group.
      These element can be tied to UI widgets
      for easy display or serve to fire off
      other modules that respond to the pick.
   */

   group GDpick_process_notify_templ {
      GDpick_obj_notify_templ+IPort2 &obj_in<NEcolor0=0xff0000>;
      method+notify_val upd_func = "GDpick_process_update";
   };

   GDpick_process_notify_templ GDpick_process_templ {
      int use_pick_data;
      group &field_id {
	 int+opt nspace;
	 int+opt nnode_data;
	 Data_Array+opt node_data[nnode_data];
      };
      float &coord_id[];
      group &node_data_array_id[];
      int+OPort2 vert_index;
      Cell_Set &cell_set_id;
      int &conn_id[];
      int conn_index;
      group &cell_data_array_id[];
      int cell_index;
      /* picked point for ease of use. */
      float+OPort2+nres point[1][field_id.nspace] => coord_id[vert_index];
      /* node data values array and picked value for ease of use. */
      int nnode_data = 0;
      prim+OPort2+nres values_array[] => field_id.node_data[nnode_data].values;
      prim+OPort2+nres value[] => values_array[vert_index];
   };

};	/* end of library Templates */

// cannot buffer these guys since they have virtual data
library+global+sort Functions<compile_subs=0,indexed=0> {

   /* These are the functions that perform rotation, scaling and
      translation. The end user can override these functions or add
      new ones based on different mode values.
   */
   GDtrack_edit_templ PDRrotate {
      mode = 0;
      func+virtual track_func = "GDtrack_rotate";
   };
   GDtrack_edit_templ PDRscale {
      mode = 1;
      func+virtual track_func = "GDtrack_scale";
   };
   GDtrack_edit_templ PDRtranslate {
      mode = 2;
      func+virtual track_func = "GDtrack_xlate";
   };

   GDtrack_edit_templ PDRzlate {
      mode = 3;
      func+virtual track_func = "GDtrack_zlate";
   };
   GDtrack_edit_templ PDRzlate {
     mode = 3;
     func+virtual track_func = "GDtrack_zlate";
   };

   /* These are the virtual functions for the various types
      of output from the viewer. The type is used to specify
      unique functions.
   */
   group OutputFieldFuncs {
      int type = GD_OUTPUT_FIELD;
      func+virtual output_init = "GDoutput_init";
      func+virtual output_flush = "GDoutput_flush";
      func+virtual output_write = "GDfield_output_write";
      func+virtual output_done = "GDoutput_done";
   };

   group OutputFileFuncs {
      int type = GD_OUTPUT_FILE;
      func+virtual output_init = "GDoutput_init";
      func+virtual output_flush = "GDoutput_flush";
      func+virtual output_write = "GDfile_output_write";
      func+virtual output_done = "GDoutput_done";
   };

#ifdef PRT_RENDERER
#ifdef MSDOS
   /* Printing on PC does not have a dependency on the AG kit. */
   group OutputPrintFuncs<disabled => Templates.CONFIG.gd_prt_disabled> {
#else
   group OutputPrintFuncs<disabled=> (Templates.CONFIG.gd_prt_disabled |
				     Templates.CONFIG.ag_kit_disabled)> {
#endif
      int type = GD_OUTPUT_PRT;
      func+virtual output_init = "GDprt_output_init";
      func+virtual output_done = "GDprt_output_done";
   };
#endif

};	/* end of library Functions*/

/* An object has references to input data that is to be rendered,
   a transformation that controls the orientation of the object,
   properties that affect the color, material, transparency, etc
   of an object and modes which affect how the object is displayed
   eg. point, lines, flat shaded, gouraud shaded etc. Eventually,
   an object will also have information about texture mapping,
   interactors, picking, etc.

   The render method associated with the input data allows
   matching of the data and a render function. This provides
   a way to add new data type and override existing render 
   functions. The render functions defined to date are in
   the file render.v.
*/
GDobject DefaultObject {
   visible         = 1;
   space	   = 0;
   pickable        = 1;
   cached          = 1;
#ifdef WORDLENGTH_64
   cache_size	   = 32;
#else
   cache_size	   = 24;
#endif
   xform_mode      = GD_XFORM_MODE_NORMAL;
   surf_conv       = GD_SURF_CONV_OPTIMAL;
   chunk           = 1;
   surf_chunk      = 1000;
   line_chunk      = 10000;
   surf_subdiv	   = 1;
   type            = GD_OBJ_STATIC;
   dith_tech       = GD_TECH_DITHER;
   interp_type     = GD_FILTER_POINT;
   tmap_method     = 0;
   tri_subdiv_type = 1;
   tri_subdiv_aval = 16;
   tri_subdiv_fval = 4;
   missing_val     = 0;
   missing_rgb     = {0, 0, 0};
   window          = {-1, 1, -1, 1, -1, 1};
   use_altobj      = 0;
};

GDminmax DefaultMinMax {
   min_value = 0.0;
   max_value = 255.0;
};
GDminmaxArr DefaultMinMaxArr {
   min_value = 0.0;
   max_value = 255.0;
};

GDtexture DefaultTexture {
   tile   = GD_TILE_CLAMP;
   alpha  = GD_ALPHA_REPLACE;
   filter = GD_FILTER_POINT;
   type   = GD_TYPE_UNFILTERED;
   stage  = GD_STAGE_POSTSPECULAR;
};

GDcamera DefaultCamera {
   mode        = GD_CAMERA_AUTO_UPDATE;
   pickable    = 1;
   auto_norm   = GD_CAMERA_AUTO_NORM_NONE;
   norm_scale  = GD_DEFAULT_NORM_SCALE;
   norm_invisible = GD_DEFAULT_NORM_INVISIBLE;
   extents     = GD_CAMERA_COMPUTE_EXTENT;
   mapping     = GD_CAMERA_MAP_WORLD;
   xmin        = 0.0;			/* viewport spec. */
   ymin        = 0.0;
   xmax        = 1.0;
   ymax        = 1.0;
   from        = {0.0, 0.0, 12.0};
   up          = {0.0, 1.0, 0.0};
   at          = {0.0, 0.0, 0.0};
   scale       = 1.0;
   perspec     = 0;
   hither      = 0;
   front       = GD_DEFAULT_FRONT_PAR;  /* perspec == 0 */
   back        = GD_DEFAULT_BACK;
   fov         = GD_DEFAULT_VIEW_ANGLE;
   wsize       = GD_DEFAULT_WSIZE;
   depth_cue   = 0;
   depth_front = GD_DEFAULT_DEPTH_FRONT;
   depth_back  = GD_DEFAULT_DEPTH_BACK;
   depth_scale = GD_DEFAULT_DEPTH_SCALE;
   jitter_scale = 1.0;
};

DefaultCamera DefaultCamera3D {
   type        = GD_CAMERA_3D;
   image_pass  = 0;
};

DefaultCamera DefaultCamera2D {
   type        = GD_CAMERA_2D;
   image_pass  = 1;
};

GDfield_output DefaultFieldOutput {
   type = GD_OUTPUT_FIELD;
   flip = 0;
   buffers {
     fb_type = GD_FB_ARGB;
     zb_type = GD_ZB_FLOAT_1NEAR;
   };
};

GDfile_output DefaultFileOutput {
   type = GD_OUTPUT_FILE;
   flip = 0;
   filename = "/tmp/express.x";
};

#ifdef PRT_RENDERER
GDprt_output DefaultPrtOutput {
   type = GD_OUTPUT_PRT;
   file = "/tmp/express.ps";
   format = 2; // Default is now PostScript Level 2
   backgroundType = 0;
   orientation = 0;
   size = 1;
   widthMM = 160;
   heightMM = 120;
   resolution = 500;
#ifdef MSDOS
   color = 0;
   devMode = 0;
   devNames = 0;
#endif
};
#endif

#ifdef VRML_RENDERER
GDvrml_output DefaultVrmlOutput {
   type      = GD_OUTPUT_VRML;
   file      = "/tmp/express.wrl";
   protocol  = GD_WWW_VRML1;
   floatPrec = 4;
   xformPrec = 4;
   colorPrec = 2;
   indent    = 1;
   width     = 500;
   height    = 500;
};
#endif

#ifdef VPS_RENDERER
GDvps_output DefaultVpsOutput {
   type        = GD_OUTPUT_VPS;
   file        = "/tmp/express.ps";
   format      = "Color";
   backMode    = "White";
   orientation = "Landscape";
   size        = "EPS";
   widthMM     = 160;
   heightMM    = 120;
   marginMM    = 5.0;

   alphaThreshold = 0.0;

   floatPrec   = 4;
   xformPrec   = 4;
   colorPrec   = 2;
   colorSub    = "None";
   colorTol    = 0.1;
   depthSort   = "Default";
   gammaMode   = "Pre";
   gamma       = 1.8;
   indent      = 0;
};
#endif

GDview DefaultView {
   renderer = GD_SWX_RENDERER;
   accel    = GD_VIEW_NOT_ACCEL;
   mode     = GD_VIEW_AUTO_UPDATE;
#ifdef MSDOS
   buffer   = GD_VIEW_DB_MBX;		/* just means double buffer */
#else
   buffer   = GD_VIEW_DB_PIXMAP;
#endif
   clear    = 1;
   timer    = 0;
   pcache   = 0;
   aspect   = GD_VIEW_ASPECT_SMALLEST;
   back_col = {0.0, 0.0, 0.0};
   stereo          = 0;
   stereo_enable   = 0;
   video           = 0;
   stereo_balance = GD_DEFAULT_STEREO_BALANCE;
   stereo_offset    = GD_DEFAULT_STEREO_OFFSET;
   video_off       = 0;
   full_view_width  = 1280;
   full_view_height = 1024;
   output_enabled = 0;
   config_flags = 0;
   blend_mode   = GD_DEFAULT_BLEND_MODE;
   ts_enable   = 0;
   ts_uniform  = 1;
   ts_scale    = 25000.0;
   ts_yscale   = 25000.0;
   ts_xorig    = 0.0;
   ts_yorig    = 0.0;
};

GDpick_process_templ GDpick_process;

group Read_USCounties {
   string+Iparam  filename;
   int+Iparam state_no;
   Mesh+Cell_Data_Poly+OPort2+nonotify out_mesh;
   method+notify_val+notify_inst upd_func = "Read_USCounties";
};

#ifdef NOT_USED
group Read_Polys {
   string filename;
   int npolys;
   Mesh+Cell_Data_Poly+OPort2+nonotify out_mesh;
   method+notify_val upd_func = "Read_Poly";
};
#endif

group Display_Image {
   Mesh_Unif+Dim2+Space2+Node_Data+Iparam &in<NEportLevels={3,0}>;

   int shell_width = 100;
   int view_width = 100;
   int max_width = 1024;

   int shell_height = 100;
   int view_height = 100;
   int max_height = 1024;

   float image_scale = 1.0;
   float cur_scale<NEvisible=0> = 1.0;

   method+notify_val display_image<status=1> = "GDdisplay_image";
};

library+global+sort Editors {

   GDview_edit_templ GDview_edit;

   GDview_sel_templ GDview_sel;

   GDcamera_edit_templ GDcamera_edit;
   GDlight_edit_templ GDlight_edit;
   GDlinfo_edit_templ GDlinfo_edit;

   GDobj_sel_templ GDobj_sel<cxx_name="GDXobj_sel"> {
      ptr+nonotify local_ptr<NEvisible=0>;
      sdims = 0;
      curobj_name = "";
      int+write obj_list_changed = 0;
   };

   GDobj_edit_templ GDobj_edit;
   GDmodes_edit_templ GDmodes_edit;
   GDprops_edit_templ GDprops_edit;
   GDtexture_edit_templ GDtexture_edit;
   GDxform_edit_templ GDxform_edit;

   GDtrack_edit_templ GDtrack_edit<cxx_name="GDXtrack_edit"> {
      mode = 0;
      view<NEportLevels={0x2,0x1}>;
      camera<NEportLevels={0x2,0x1}>;
      obj<NEportLevels={0x2,0x1}>;
      event<NEportLevels={0x2,0x0}>;
      x<NEportLevels={0x2,0x0}>;
      y<NEportLevels={0x2,0x0}>;
      ptr+nonotify local_ptr<NEvisible=0>;
   };

   module GDview_selector {
      // this causes us to run when the view is selected
      group+IPort2 &input_views<NEcolor0=0xff00ff>[] {
	 int+read+write+notify selected;
      };
      // This will cause us to run when views are added/deleted
      group+read+notify *view_notifier[] => input_views;

      link+write+OPort2 curr_view;
      omethod+notify_inst update = "GDview_selector_update";
   };
   module GDview_creator {
      group *current_view;
      enum scene_mode {
	 choices = {"new_scene", "share_scene",
		    "contains_scene", "contained_by_scene"};
      } = 0;
      enum camera_mode {
	 choices = {"3D", "2D", "Both"};
      } = 0;
      int do_create;
      int do_destroy;
      int destroy_active = 0;
      omethod+req create(do_create+notify+read+req,
		 scene_mode+read,camera_mode+read)="GDview_creator_create";
      omethod+req destroy(do_destroy+notify+read+req)="GDview_creator_destroy";
      omethod+req view_update(current_view+notify+read,
			     destroy_active+write)="GDview_creator_view_update";
   };

};	/* end of library Editors */

library+global+sort Interactivity {

   GDroi2d_cont_templ GDroi2d_cont<export=2> {
     draw_mode = 0;	/* copy */
     mode = 1;		/* append */
     option = 3;	/* polygon */
     red = 1.0;		/* default color = red */
     green = 0.0;
     blue = 0.0;
   };

   GDroi2d_click_templ GDroi2d_click<export=2> {
     mode = 1;		/* append */
     option = 3;	/* polygon */
     red = 1.0;		/* default color = red */
     green = 0.0;
     blue = 0.0;
   };

   GDmap2d_ss_templ GDmap2d_ss<export=2> {
     mode = 0;		/* don't append */
     color = 0;		/* don't use map color */
     red = 1.0;		/* default map color = white */
     green = 1.0;
     blue = 1.0;
   };

   GDdraw2d_cursor_templ GDdraw2d_cursor {
     immed = 1;
     mode = 0;
     size = 10;
     thickness = 0;
     red = 1.0;
     green = 1.0;
     blue = 1.0;
   };

   GDedit_mesh_templ GDedit_mesh {
     mode = 1;		/* edit prim. */
     immed = 1;		/* update on button up */
     draw_mode = 0;	/* draw in copy mode */
     red = 1.0;		/* default hilite color = red */
     green = 0.0;
     blue = 0.0;
   };

   GDvector2raster_templ GDvector2raster {
     inside = 1;
   };

};	/* end of library Interactivity */

library+global+sort Examples {

   /* V for method that uses GD state and primitive
      routines to draw directly on top of a GD view.
   */
   group DrawCursor<locked=1> {
      GDview_ref_templ+IPort2+nonotify &view_in;
      int+IPort2+nonotify x;
      int+IPort2+nonotify y;
      int+IPort2 state;
      method+notify_val update = "DrawCursor";
   };

   macro TestCursor {
      GDview_ref_templ+IPort2+nonotify &view;
      ilink rv;

      UItwoPoint UItwoPoint {
         view+IPort2 => rv;
#ifndef MSDOS
         startEvent = "<Btn3Down>";
         runEvent = "<Btn3Motion>";
         stopEvent = "<Btn3Up>";
#else
         startEvent = "<BtnRDown>";
         runEvent = "<BtnRMotion>";
         stopEvent = "<BtnRUp>";
#endif
      };
      DrawCursor DrawCursor {
         view_in => view;
         x => UItwoPoint.x;
         y => UItwoPoint.y;
         state => UItwoPoint.state;
      };
   };

   /* V for GD_Doodle routine. 
      Doodle will run whenever state changes.
   */
   group Doodle<locked=1> {
      GDview_ref_templ+IPort2+nonotify &view_in;
      int+IPort2+nonotify x;
      int+IPort2+nonotify y;
      int+IPort2 state;
      int+nonotify draw_mode;	/* 0 = copy, 1 = xor */
      int+nonotify mode;	/* 0 = clear, 1 = append */
      int+nonotify option;	/* 0 = line, 1 = box, 2 = freehand */
      method+notify_val update = "Doodle";
   };

   macro SuperDoodle {
      GDview_ref_templ+IPort2+nonotify &view;
      ilink rv;

      UItwoPoint UItwoPoint {
         view+IPort2 => rv;
#ifndef MSDOS
         startEvent = "<Btn3Down>";
         runEvent = "<Btn3Motion>";
         stopEvent = "<Btn3Up>";
#else
         startEvent = "<BtnRDown>";
         runEvent = "<BtnRMotion>";
         stopEvent = "<BtnRUp>";
#endif
      };
      Doodle Doodle {
         view_in => view;
         x => UItwoPoint.x;
         y => UItwoPoint.y;
         state => UItwoPoint.state;
         draw_mode = 0;
         mode = 0;
         option = 0;
      };
   };
};	/* end of library Examples */

/***********************************************************************/
/* Graphics display objects                                            */
/***********************************************************************/

/* Unset the locked property that is on the GD library for these
   macros so the user can edit them.
*/

macro AltObject<locked=0> {
   group &alt_in<NEportLevels={2,1},NEnumColors=4,NEcolor0=0xff,NEy=132,NEx=55> {
      GDxform_templ &xform;
      method render;
   };

   DefaultProps+OPort Props<NEy=198,NEx=297>;
   DefaultModes+OPort AltModes<NEy=165,NEx=341> {
      mode = { GD_NO_POINTS, GD_NO_LINES, GD_NO_SURF, 
	       GD_NO_VOLUME, GD_BOUNDS };
   };
   DefaultObject+OPort Obj<NEy=385,NEx=110> {
      input => alt_in;
      props => Props;
      modes => AltModes;
   };
   olink obj<NEy=385,NEx=341> => Obj;
};

macro GroupObject<locked=0> {
   imlink child_objs<NEy=99,NEx=209>;

   DefaultLinear Datamap<NEy=132,NEx=11,export_all=1> {
      dataMin = 0;
      dataMax = 255.0;
   };
   DefaultProps+OPort Props<NEy=143,NEx=308,export_all=1> {
      inherit = 0;
   };
   DefaultModes+OPort Modes<NEy=110,NEx=363,export_all=1>;
   DefaultXform+OPort Xform<NEy=176,NEx=253,export_all=1>;
   DefaultPickInfo+OPort PickInfo<NEy=77,NEx=429,export_all=1>;
   AltObject AltObject<instanced=0>;
   DefaultObject+OPort Top<NEy=352,NEx=77,export_all=1> {
      objects<export=0> => child_objs;
      altobj<export=0> => AltObject.obj;
      dmap<export=0> => Datamap;
      props<export=0> => Props;
      modes<export=0> => Modes;
      xform<export=0> => Xform;
      pick_info<export=0> => PickInfo;
      name<export=2> => name_of(<-.<-);
   };
   GMOD.instancer instancer {
      Group => AltObject;
      Value => Top.use_altobj;
   };
   olink obj<NEy=352,NEx=297> => Top;
};

macro DataObject<locked=0> {
   group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=0xff,NEy=132,NEx=55> {
      GDxform_templ &xform;
      method render;
   };
   Node_Data+Byte &texture_in<NEportLevels={2,1},NEy=44,NEx=231>;
   Node_Data &texture_col_in<NEportLevels={2,1},NEy=11,NEx=286>;
   imlink child_objs<NEy=77,NEx=132>;

   DefaultMinMax MinMax<NEx=11,NEy=187,export_all=1> {
      input => in;
   };
   DefaultLinear Datamap<NEy=231,NEx=11,export_all=1> {
      dataMin => MinMax.min_value;
      dataMax => MinMax.max_value;
   };
   DefaultProps+OPort Props<NEy=198,NEx=297,export_all=1>;
   DefaultModes+OPort Modes<NEy=165,NEx=341,export_all=1>;
   DefaultTexture+OPort Texture<NEy=132,NEx=396,export_all=1> {
      data => texture_in;
      colormap => texture_col_in;
   };
   DefaultPickInfo+OPort PickInfo<NEy=99,NEx=473,export_all=1>;
   AltObject AltObject<export_all=1,instanced=0> {
      alt_in => in;
   };
   DefaultObject+OPort Obj<NEy=385,NEx=110,export_all=2> {
      input => in;
      objects => child_objs;
      altobj => AltObject.obj;
      dmap => Datamap;
      props => Props;
      modes => Modes;
      xform => in.xform;
      texture => Texture;
      pick_info => PickInfo;
      name => name_of(<-.<-);
   };
   GMOD.instancer instancer {
      Group => AltObject;
      Value => Obj.use_altobj;
   };
   olink obj<NEy=385,NEx=341> => Obj;
};

macro DataObjectNoTexture<locked=0> {
   group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=0xff,NEy=132,NEx=55> {
      GDxform_templ &xform;
      method render;
   };
   imlink child_objs<NEy=77,NEx=132>;

   DefaultMinMax MinMax<NEx=11,NEy=187,export_all=1> {
      input => in;
   };
   DefaultLinear Datamap<NEy=231,NEx=11,export_all=1> {
      dataMin => MinMax.min_value;
      dataMax => MinMax.max_value;
   };
   DefaultProps+OPort Props<NEy=198,NEx=297,export_all=1>;
   DefaultModes+OPort Modes<NEy=165,NEx=341,export_all=1>;
   DefaultPickInfo+OPort PickInfo<NEy=99,NEx=473,export_all=1>;
   AltObject AltObject<export_all=1,instanced=0> {
      alt_in => in;
   };
   DefaultObject+OPort Obj<NEy=385,NEx=110,export_all=2> {
      input => in;
      objects => child_objs;
      altobj => AltObject.obj;
      dmap => Datamap;
      props => Props;
      modes => Modes;
      xform => in.xform;
      pick_info => PickInfo;
      name => name_of(<-.<-);
   };
   GMOD.instancer instancer {
      Group => AltObject;
      Value => Obj.use_altobj;
   };
   olink obj<NEy=385,NEx=341> => Obj;
};

macro DataObjectLite<locked=0> {
   group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=0xff,NEy=132,NEx=55> {
      GDxform_templ &xform;
      method render;
   };
   imlink child_objs<NEy=77,NEx=132>;

   DefaultProps+OPort Props<NEy=198,NEx=297,export_all=1>;
   DefaultModes+OPort Modes<NEy=165,NEx=341,export_all=1>;
   DefaultPickInfo+OPort PickInfo<NEy=99,NEx=473,export_all=1>;
   DefaultObject+OPort Obj<NEy=385,NEx=110,export_all=2> {
      input => in;
      objects => child_objs;
      props => Props;
      modes => Modes;
      xform => in.xform;
      pick_info => PickInfo;
      name => name_of(<-.<-);
   };
   olink obj<NEy=385,NEx=341> => Obj;
};

macro DataObjects<locked=0> {
   imlink in_fields;
   DataObject dos[array_size(in_fields)] {
      in+nres => in_fields[index_of(dos)];
      obj<NEportLevels={0,3}>;
   };
};

macro DataObjectArr<locked=0> {
   group+IPort2 &in_fields[] {
      GDxform_templ &xform;
      method render;
   };
   Node_Data+Byte &texture_in<NEportLevels={2,1},NEy=44,NEx=231>;
   Node_Data &texture_col_in<NEportLevels={2,1},NEy=11,NEx=286>;
   imlink child_objs<NEy=77,NEx=132>;

   DefaultMinMaxArr MinMax<NEx=11,NEy=187,export_all=1> {
      input => in_fields;
   };
   DefaultLinear Datamap<NEy=231,NEx=11,export_all=1> {
      dataMin => MinMax.min_value;
      dataMax => MinMax.max_value;
   };
   DefaultProps+OPort Props<NEy=198,NEx=297,export_all=1>;
   DefaultModes+OPort Modes<NEy=165,NEx=341,export_all=1>;
   DefaultTexture+OPort Texture<NEy=132,NEx=396,export_all=1> {
      data => texture_in;
      colormap => texture_col_in;
   };
   DefaultPickInfo+OPort PickInfo<NEy=99,NEx=473,export_all=1>;
   AltObject AltObject<export_all=1,instanced=0>[array_size(in_fields)] {
      alt_in => in_fields[index_of(AltObject)];
   };
   GMOD.instancer instancer {
      Group => AltObject;
      Value+nres => sum(dos.use_altobj);
   };
   DefaultObject+OPort dos[array_size(in_fields)] {
      input => <-.in_fields[index_of(dos)];
      objects => child_objs;
      altobj => AltObject[index_of(dos)].obj;
      dmap => Datamap;
      props => Props;
      modes => Modes;
      xform => <-.in_fields.xform[index_of(dos)];
      texture => Texture;
      pick_info => PickInfo;
      name => name_of(<-.<-);
   };
   omlink obj<NEy=385,NEx=341> => dos;
};

macro DataObjectNoTextureArr<locked=0> {
   group+IPort2 &in_fields[] {
      GDxform_templ &xform;
      method render;
   };
   imlink child_objs<NEy=77,NEx=132>;

   DefaultMinMaxArr MinMax<NEx=11,NEy=187,export_all=1> {
      input => in_fields;
   };
   DefaultLinear Datamap<NEy=231,NEx=11,export_all=1> {
      dataMin => MinMax.min_value;
      dataMax => MinMax.max_value;
   };
   DefaultProps+OPort Props<NEy=198,NEx=297,export_all=1>;
   DefaultModes+OPort Modes<NEy=165,NEx=341,export_all=1>;
   DefaultPickInfo+OPort PickInfo<NEy=99,NEx=473,export_all=1>;
   AltObject AltObject<export_all=1,instanced=0>[array_size(in_fields)] {
      alt_in => in_fields[index_of(AltObject)];
   };
   GMOD.instancer instancer {
      Group => AltObject;
      Value+nres => sum(dos.use_altobj);
   };
   DefaultObject+OPort dos[array_size(in_fields)] {
      input => <-.in_fields[index_of(dos)];
      objects => child_objs;
      altobj => AltObject[index_of(dos)].obj;
      dmap => Datamap;
      props => Props;
      modes => Modes;
      xform => <-.in_fields.xform[index_of(dos)];
      pick_info => PickInfo;
      name => name_of(<-.<-);
   };
   omlink obj<NEy=385,NEx=341> => dos;
};
macro DataObjectLightArr<locked=0> {
   group+IPort2 &in_fields[] {
      GDxform_templ &xform;
      method render;
   };
   imlink child_objs<NEy=77,NEx=132>;

   DefaultProps+OPort Props<NEy=198,NEx=297,export_all=1>;
   DefaultModes+OPort Modes<NEy=165,NEx=341,export_all=1>;
   DefaultPickInfo+OPort PickInfo<NEy=99,NEx=473,export_all=1>;
   DefaultObject+OPort dos[array_size(in_fields)] {
      input => <-.in_fields[index_of(dos)];
      objects => child_objs;
      props => Props;
      modes => Modes;
      xform => <-.in_fields.xform[index_of(dos)];
      pick_info => PickInfo;
      name => name_of(<-.<-);
   };
   omlink obj<NEy=385,NEx=341> => dos;
};

#ifdef LIGHT_REP_IN_V
macro DirLightGlyph<locked=0> {
      Line set1 {
	 ncells = 5;
	 node_connect_list = {0,1, 1,2, 1,3, 1,4, 1,5};
      };
      Mesh glyph1 {
	 int nnodes = 6;
	 int nspace = 3;
	 coordinates {
	    float values[nvals][veclen] = {
	       {0,0,5}, {0,0,1},
	       {0.1, 0, 1.1}, {-0.1, 0, 1.1}, {0, 0.1, 1.1}, {0, -0.1, 1.1}
	    };
	 };
	 int ncell_sets = 1;
	 cell_set[ncell_sets] => {set1};
      };
      DataObject obj {
	 in => glyph1;
	 Obj {
	    name => name_of(<-.<-.<-);
	    xform {
	      center = {0, 0, 1};
	    };
	 };
      };

      olink out_fld => glyph1;
      olink out_obj => obj.obj;
};
#endif


};
