/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDaccel1.v#1 $
*/

APPS.SingleWindowApp AccelGraph<NEdisplayMode="maximized",
                                NEhelpTopic="gdex_AccelGraph"> {

MODS.Readers.Loop Loop<NEx=231.,NEy=99.> {
   end = 800.;
   incr = 10.;
};
macro TestData<NEx=308.,NEy=176.,NExOffset=0.> {
   int start<NEportLevels={2,0}> => <-.Loop.count;
   int size = 800;
   int asize => (size - start);
   int bsize => (size - (size - start));
   int a[(size - start)] => init_array(asize,start,(size - 1));
   int b[(size - (size - start))] => init_array(bsize,0,(bsize - 1));
   int c<NEportLevels={0,2}>[size] => combine_array(a,b);
};
macro DynamicGraphMacro<NEx=308.,NEy=253.> {
   Axes.AGXAxis AGXAxis<NEx=561.,NEy=44.,NEwidth=187.,NEheight=231.> {
      majorTickColor => <-.AGXTicklines.majorTickColor;
      majorTickLineStyle => <-.AGXTicklines.majorTickLineStyle;
      majorTickWidth => <-.AGXTicklines.majorTickWidth;
      minorTickColor => <-.AGXTicklines.minorTickColor;
      minorTickCount => <-.AGXTicklines.minorTickCount;
      minorTickLineStyle => <-.AGXTicklines.minorTickLineStyle;
      minorTickWidth => <-.AGXTicklines.minorTickWidth;
   };
   Axes.AGYAxis AGYAxis<NEx=561.,NEy=110.> {
      majorTickColor => <-.AGYTicklines.majorTickColor;
      majorTickLineStyle => <-.AGYTicklines.majorTickLineStyle;
      majorTickWidth => <-.AGYTicklines.majorTickWidth;
      minorTickColor => <-.AGYTicklines.minorTickColor;
      minorTickCount => <-.AGYTicklines.minorTickCount;
      minorTickLineStyle => <-.AGYTicklines.minorTickLineStyle;
      minorTickWidth => <-.AGYTicklines.minorTickWidth;
   };
   Axes.AGYTicklines AGYTicklines<NEx=561.,NEy=143.> {
      minorTickCount = 4;
   };
   Axes.AGXTicklines AGXTicklines<NEx=561.,NEy=77.> {
      minorTickCount = 2;
   };
   Graphing.AGGraphWorld AGGraphWorld<NEx=528.,NEy=264.> {
      children => {<-.AGXAxis,
         <-.AGXTicklines,<-.AGYAxis,<-.AGYTicklines};
      limitsX = {0.,800.};
      limitsY = {0.,800.};
   };
   AGText graphTitle<NEx=341.,NEy=231.> {
      geometry = {0.,5.5};
      font = "Helvetica";
      text = {
         "Dynamic Graph Demo"};
      verticalJustification = "bottom";
      height = 10.;
   };
   Graphing.AGGraphViewportObj AGGraphViewportObj#1<NEx=429.,NEy=363.> {
      graphViewport<NEx=11.,NEy=55.,NEwidth=242.,NEheight=275.> {
         children => {<-.<-.graphTitle,
            <-.<-.AGGraphWorld};
      };
      macro dataObject {
         AGGeometryPrimitive &in<NEportLevels={2,1},NEnumColors=2,NEcolor1=255,NEy=55,NEx=55> => <-.graphViewport;
         DefaultDatamap Datamap<NEy=132,NEx=77> {
            dataMin => <-.DefaultMinMax.min_value;
            dataMax => <-.DefaultMinMax.max_value;
         };
         GD.DefaultMinMax DefaultMinMax<NEx=231,NEy=55> {
            Node_Data+read &input<NEportLevels={3,0},NEnumColors=4,NEcolor0=255> {
               data_method render;
            };
         };
         DefaultProps Props<NEy=143,NEx=308> {
            inherit = 0;
         };
         DefaultObject StaticObj<NEx=77.,NEy=352.,NEportLevels={0,1}> {
            input => <-.in;
            dmap => <-.Datamap;
            xform => <-.Xform;
            props => <-.Props;
            modes => <-.Modes;
            pick_info => <-.PickInfo;
            string name => name_of(<-.<-.<-);
         };
         olink obj<NEy=352,NEx=297,NEportLevels={1,4}> => .StaticObj;
         DefaultModes Modes<NEy=110,NEx=363>;
         DefaultXform Xform<NEy=176,NEx=253>;
         DefaultPickInfo PickInfo<NEy=77,NEx=429>;
      };
   };
   Graphing.AGGraphViewportObj AGGraphViewportObj<NEx=220.,NEy=363.,NExOffset=0.,NEyOffset=0.,NEscalingFactor=1.> {
      macro dataObject<NExOffset=0.,NEyOffset=0.,NEscalingFactor=1.> {
         AGGeometryPrimitive &in<NEportLevels={2,1},NEnumColors=2,NEcolor1=255,NEy=55,NEx=55> => <-.graphViewport;
         DefaultDatamap Datamap<NEy=132,NEx=77> {
            dataMin => <-.DefaultMinMax.min_value;
            dataMax => <-.DefaultMinMax.max_value;
         };
         GD.DefaultMinMax DefaultMinMax<NEx=231,NEy=55> {
            Node_Data+read &input<NEportLevels={3,0},NEnumColors=4,NEcolor0=255> {
               data_method render;
            };
         };
         DefaultProps Props<NEy=143,NEx=308> {
            inherit = 0;
         };
         DefaultObject DynamicObj<NEportLevels={0,1},NEy=352.,NEx=77.> {
            input => <-.in;
            dmap => <-.Datamap;
            xform => <-.Xform;
            props => <-.Props;
            modes => <-.Modes;
            type = 1;
            pick_info => <-.PickInfo;
            string name => name_of(<-.<-.<-);
         };
         olink obj<NEy=352,NEx=297,NEportLevels={1,4}> => .DynamicObj;
         DefaultModes Modes<NEy=110,NEx=363>;
         DefaultXform Xform<NEy=176,NEx=253>;
         DefaultPickInfo PickInfo<NEy=77,NEx=429>;
      };
      graphViewport<NEx=11.,NEy=55.,NEwidth=264.,NEheight=242.> {
         children => {
            <-.<-.AGGraphWorld#1};
         fillColor = "transparent";
      };
   };
   Graphing.AGGraphWorld AGGraphWorld#1<NEx=143.,NEy=253.> {
      children => {<-.AGGraph};
      limitsX = {0.,800.};
      limitsY = {0.,800.};
   };
   Graphing.AGGraph AGGraph<NEx=143.,NEy=121.,NEwidth=242.,NEheight=275.> {
      valuesY<NEportLevels={3,0}> => <-.<-.TestData.c;
      lineWidth = 0.1;
   };
};
GDM.Uviewer2D Uviewer2D<NEx=319.,NEy=341.> {
   Scene {
      Top {
         child_objs => {DynamicGraphMacro.AGGraphViewportObj#1.dataObject.obj,
            DynamicGraphMacro.AGGraphViewportObj.dataObject.obj};
      };
      Camera {
	 Camera {
	    auto_norm = 0;
         };
      };
      View {
         VirtPal {
            vclass = 3;
         };
         View {
            accel = 1;
         };
      };
   };
};

};
