/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDbuff1.v#1 $
*/

APPS.MultiWindowApp Buffer2Dto3D<NEdisplayMode="maximized",
                                 NEhelpTopic="gdex_Buffer2Dto3D"> {

MODS.Read_Field Read_Field<NEx=407.,NEy=11.> {
   read_field_ui {
      file_browser {
         filename = "$XP_PATH<0>/data/field/wind.fld";
      };
   };
};
MODS.orthoslice orthoslice<NEx=297.,NEy=66.> {
   in_field => <-.Read_Field.field;
   OrthoSliceParam {
      axis = 2;
      plane => 13;
   };
};
AGContourObj AGContourObj<NEx=187.,NEy=165.> {
   dataObject<NEx=176,NEy=407> {
      Xform {
         mat = {
            0.640823,0.,0.,0.,
	    0.,0.640823,0.,0.,
	    0.,0.,0.640823,0.,
	    0.,0.,0.,1.
         };
         xlate = {-2.16,1.94,0.};
      };
   };
   inField<NEx=198,NEy=33> => <-.orthoslice.out_fld;
   contour<NEx=374,NEy=121,NEwidth=253,NEheight=253> {
      isoLineLabelColor = "black";
      majorIsoLineColor = "black";
      maxClass = 50.;
      minClass = -20.;
      minorIsoLineColor = "black";
      numClasses = 15;
   };
   combineContourWorldInput {
      input2 => {<-.<-.AGXAxis,
         <-.<-.AGYAxis};
   };
};
AGXAxis AGXAxis<NEx=22.,NEy=99.> {
   text = "X Position";
};
AGYAxis AGYAxis<NEx=22.,NEy=143.> {
   text = "Y Position";
};
AGContourLegendObj AGContourLegendObj<NEx=220.,NEy=220.> {
   dataObject {
      Xform {
         xlate = {2.92,-0.239999,0.};
      };
   };
   contourLegend<NEx=220,NEy=55,NEwidth=209,NEheight=231> {
      labelHeight = 2.;
      title = "Temperature";
      titleHeight = 2.5;
      contour => <-.<-.AGContourObj.contour;
   };
};
AGTextObj AGTextObj<NEx=11.,NEy=220.> {
   dataObject {
      Xform {
         xlate = {-2.08,0.14,0.};
      };
   };
   text<NEx=11,NEy=55> {
      geometry = {0.,4.};
      text = {
         "Heat Distribution"};
      height = 4.;
   };
};
MODS.downsize downsize<NEx=462.,NEy=165.> {
   in_field => <-.Read_Field.field;
   DownsizeParam {
      factor0 = 4.;
      factor1 = 4.;
      factor2 = 3.;
   };
};
MODS.bounds bounds<NEx=462.,NEy=220.> {
   in_field => <-.downsize.out_fld;
   BoundsParam {
      edges = 1;
      imin = 1;
      jmin = 1;
      kmin = 1;
      data = 1;
   };
};
MODS.isosurface isosurface<NEx=616.,NEy=165.> {
   in_field => <-.Read_Field.field;
   IsoParam {
      iso_level => 20.58;
   };
   obj {
      Props {
         trans = 0.5099999905;
         inherit = 0;
         material = {0.301,0.702,0.,95.56};
      };
   };
};
GDM.Uviewer2D Uviewer2D<NEx=330.,NEy=429.> {
   Scene {
      Top {
         child_objs => {
            AGContourObj.dataObject.obj,AGContourLegendObj.dataObject.obj,
            AGTextObj.dataObject.obj
         };
      };
      Camera {
	 Camera {
	    auto_norm = 0;
         };
      };
      View {
         View {
            output_enabled = 1;
            back_col = {0.21,0.21,0.21};
         };
	 FieldOutput {
	    buffers<NEportLevels={0,4}>;
	 };
      };
   };
   GDM.Uscene3D Scene#1 {
      Top {
         child_objs<NEportLevels={4,1}> => {
            orthoslice.out_obj,bounds.out_obj,isosurface.out_obj
         };
         Xform {
            mat = {
               0.0736038,-0.0451781,0.0815881,0.,
	       -0.007731,0.100623,0.062693,0.,
	       -0.0929404,-0.0441488,0.0593985,0.,
	       0.,0.,0.,1.
            };
            xlate = {-4.62,-6.74,-6.45833};
            center = {12.,12.,15.5};
	    ocenter = {12.,12.,15.5};
	    dcenter = {5.,5.,6.45833};
         };
      };
      Lights {
         !Lights[0] {
            type = 3;
         };
      };
      Camera {
	 Camera {
	    auto_norm = 0;
         };
      };
      View {
	 View {
	    buffers<NEportLevels={4,0}> => <-.<-.<-.Scene.View.FieldOutput.buffers;
         };
      };
   };
   Scene_Selector {
      input_views => {Scene.View.View,
         <-.Scene#1.View.View};
   };
};

};
