/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDint11.v#1 $
*/

APPS.SingleWindowApp ImageStats<NEdisplayMode="maximized",
                                NEhelpTopic="gdex_ImageStats"> {

MODS.Read_Image Read_Image<NEx=176.,NEy=33.> {
   read_image_ui {
      file_browser {
         filename = "$XP_PATH<0>/data/image/avs_old.x";
      };
   };
};
MODS.extract_scalar extract_scalar<NEx=198.,NEy=88.> {
   in_field => <-.Read_Image.field;
   ExtractScalarParam {
      component = 1;
   };
};
GDM.Uviewer2D Uviewer2D<NEx=110.,NEy=220.> {
   Scene {
      Top {
         child_objs => {extract_scalar.out_obj,ContinuousSketch.cont_sketch.DataObject.obj};
      };
   };
};
GDM.Interactivity.ContinuousSketch ContinuousSketch<NEx=198.,NEy=308.> {
   view_in => Uviewer2D.Scene_Selector.curr_view;
   obj_in => extract_scalar.out_obj;
   cont_sketch {
      GDroi2d_cont {
         option = 4;
         immed = 1;
      };
   };
};
macro StatROI<NEx=418.,NEy=451.,NExOffset=0.,NEyOffset=0.,NEscalingFactor=1.> {
   float+nres min_value<NEy=253.,NEx=264.,NEdisplayMode="NEclosed"> => .ip_extrema.min;
   float+nres max_value<NEy=220.,NEx=264.,NEdisplayMode="NEclosed"> => .ip_extrema.max;
   float+nres mean_value<NEx=264.,NEy=286.,NEdisplayMode="NEclosed"> => ((.min_value + (.max_value - .min_value)) / 2);
   float+nres std_dev<NEy=220.,NEx=77.,NEwidth=242.,NEheight=66.> => sqrt(.ip_variance.var);
   float+nres ave_value<NEy=253.,NEx=77.,NEwidth=220.,NEheight=77.> => .ip_variance.mean;
   float+nres total_value<NEy=286.,NEx=77.,NEwidth=253.,NEheight=77.> => (.ave_value * .ip_variance.npix);
   IPfldToImage IPfldToImage<NEx=33,NEy=33> {
      In<NEportLevels={3,0}> => <-.<-.extract_scalar.out_fld;
   };
   IPfldToROI IPfldToROI<NEx=275,NEy=33> {
      In<NEportLevels={3,0}> => <-.<-.Vector2Raster.vec2rast.GDvector2raster.output;
   };
   ip_variance ip_variance<NEx=22,NEy=165,NEdisplayMode="NEclosed"> {
      src => <-.IPfldToImage.Image;
      npix<NEdisplayMode="NEclosed">;
      mean<NEdisplayMode="NEclosed">;
      var<NEdisplayMode="NEclosed">;
      roi => <-.IPfldToROI.ROI.Roi;
   };
   ip_extrema ip_extrema<NEx=209.,NEy=165.,NEdisplayMode="NEclosed"> {
      src => <-.IPfldToImage.Image;
      roi => <-.IPfldToROI.ROI.Roi;
   };
   UImod_panel UImod_panel<NEx=528.,NEy=66.> {
      title => "Statistics";
      option {
         set = 1;
      };
   };
   UIlabel UIlabel {
      parent => <-.UImod_panel;
      label => "Std Dev";
      y = 120;
      alignment = 0;
   };
   UIlabel UIlabel#1<NEx=462.,NEy=297.> {
      parent => <-.UImod_panel;
      label => "Average";
      y = 96;
      alignment<NEdisplayMode="open"> = 0;
   };
   UIlabel UIlabel#2<NEx=462.,NEy=253.> {
      parent => <-.UImod_panel;
      label => "Total";
      y = 72;
      alignment<NEdisplayMode="open"> = 0;
   };
   UIlabel UIlabel#3 {
      parent => <-.UImod_panel;
      label => "Maximum";
      y = 48;
      alignment = 0;
   };
   UIlabel UIlabel#4 {
      parent => <-.UImod_panel;
      label => "Minimum";
      y = 24;
      alignment<NEdisplayMode="open"> = 0;
   };
   UIlabel UIlabel#5<NEx=462.,NEy=121.> {
      parent => <-.UImod_panel;
      label => "Mean";
      y = 0;
      alignment<NEdisplayMode="open"> = 0;
   };
   UIlabel UIlabel#6 {
      parent => <-.UImod_panel;
      label => <-.mean_value;
      y = 0;
      x = 100;
   };
   UIlabel UIlabel#7 {
      parent => <-.UImod_panel;
      label => <-.min_value;
      y = 24;
      x = 100;
   };
   UIlabel UIlabel#8 {
      parent => <-.UImod_panel;
      label => <-.max_value;
      x<NEdisplayMode="open"> = 100;
      y<NEdisplayMode="open"> = 48;
   };
   UIlabel UIlabel#9 {
      parent => <-.UImod_panel;
      label => <-.total_value;
      y = 72;
      x = 100;
   };
   UIlabel UIlabel#10 {
      parent => <-.UImod_panel;
      label => <-.ave_value;
      y = 96;
      x = 100;
   };
   UIlabel UIlabel#11 {
      parent => <-.UImod_panel;
      label => <-.std_dev;
      y<NEdisplayMode="open"> = 120;
      x<NEdisplayMode="open"> = 100;
   };
};
GDM.Interactivity.Vector2Raster Vector2Raster<NEx=275.,NEy=385.> {
   in_field => ContinuousSketch.cont_sketch.GDmap2d_ss.out_mesh;
   obj_in => extract_scalar.out_obj;
};

};
