/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDinter5.v#1 $
*/

APPS.MultiWindowApp RegionCrop3D<NEdisplayMode="maximized",
                                 NEhelpTopic="gdex_RegionCrop3D"> {

MODS.Readers.Read_Field Read_Field<NEx=539,NEy=22> {
   read_field_ui {
      file_browser {
	 filename = "$XP_PATH<0>/data/field/helens2.fld";
      };
   };
};
macro region_crop<NEx=594,NEy=143,NEwidth=253,NEheight=187> {
   DV.DVcrop DVcrop<NEx=110,NEy=110> {
      in<NEportLevels={3,0}> => <-.<-.Read_Field.field;
      min<NEx=11,NEy=55,NEwidth=495,NEheight=110> => {
         <-.Mesh.coordinates.min_vec[0],<-.Mesh.coordinates.min_vec[1]};
      max<NEx=11,NEy=99,NEwidth=495,NEheight=121> => {
         <-.Mesh.coordinates.max_vec[0],<-.Mesh.coordinates.max_vec[1]};
      out<NEportLevels={1,3}>;
   };
   Field_Types.Mesh &Mesh<NEx=154,NEy=22,NEportLevels={2,0}> => <-.ContinuousSketch.cont_sketch.GDmap2d_ss.out_mesh;
};
MODS.Filters.downsize downsize<NEx=594,NEy=187> {
   in_field => <-.region_crop.DVcrop.out;
   DownsizeParam {
      factor0 = 2;
      factor1 = 2;
      factor2 = 2;
   };
};
MODS.Mappers.surf_plot surf_plot<NEx=594,NEy=231> {
   in_field => <-.downsize.out_fld;
   SurfPlotParam<NEx=11,NEy=55> {
      scale<NEdisplayMode="NEeditingValue"> = 0.1;
   };
};
GDM.Interactivity.ContinuousSketch ContinuousSketch<NEx=418,NEy=132> {
   view_in => Uviewer2D.Scene_Selector.curr_view;
   obj_in => Read_Field.out_obj;
   cont_sketch { 
      GDroi2d_cont {
         immed = 1;
         option = 2;
         draw_mode = 1;
         green = 1;
         blue = 1;
      };
   };
};
GDM.Interactivity.EditMesh EditMesh<NEx=418,NEy=198> {
   view_in => Uviewer2D.Scene_Selector.curr_view;
   edit_mesh {
      GDedit_mesh {
         mode = 2;
      };
   };
};

GDM.Uviewer2D Uviewer2D<NEx=495.,NEy=341.> {
   Scene {
      Top {
         child_objs => {
            <-.<-.<-.Read_Field.out_obj,
            <-.<-.<-.ContinuousSketch.cont_sketch.DataObject.obj};
      };
   };
   GDM.Uscene3D Scene#1 {
      Top {
         child_objs<NEportLevels={4,1}> => {
            <-.<-.<-.surf_plot.out_obj};
      };
   };
   Scene_Selector {
      input_views => {Scene.View.View,
         <-.Scene#1.View.View};
   };
};

};

