/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDinter6.v#1 $
*/

APPS.MultiWindowApp RegionCrop2D<NEdisplayMode="maximized",
                                 NEhelpTopic="gdex_RegionCrop2D"> {

MODS.Readers.Read_Field Read_Field<NEx=550,NEy=33> {
   read_field_ui {
      file_browser {
	 filename = "$XP_PATH<0>/data/field/helens1.fld";
      };
   };
   DataObject<NExOffset=0,NEyOffset=0,NEscalingFactor=1> {
      Obj {
         pickable<NEdisplayMode="NEeditingValue"> = 0;
      };
   };
};
macro region_crop<NEx=594,NEy=186> {
   DV.DVcrop DVcrop<NEx=110,NEy=110> {
      in<NEportLevels={3,0}> => <-.<-.Read_Field.field;
      min<NEx=11,NEy=55,NEwidth=495,NEheight=110> => {
         <-.Mesh.coordinates.min_vec[0],<-.Mesh.coordinates.min_vec[1]};
      max<NEx=11,NEy=99,NEwidth=495,NEheight=121> => {
         <-.Mesh.coordinates.max_vec[0],<-.Mesh.coordinates.max_vec[1]};
      out<NEportLevels={1,3}>;
   };
   FLD.Mesh &Mesh<NEx=154,NEy=22,NEportLevels={2,0}> => <-.ContinuousSketch.cont_sketch.GDmap2d_ss.out_mesh;
   GD.DataObject DataObject<NEx=253,NEy=187> {
      in => <-.DVcrop.out;
      obj<NEportLevels={1,3}>;
   };
};
MODS.reset_xform reset_xform<NEx=594.,NEy=240.> {
   in_field => <-.region_crop.DVcrop.out;
};
GDM.Interactivity.ContinuousSketch ContinuousSketch<NEx=407,NEy=132> {
   view_in => Uviewer2D.Scene_Selector.curr_view;
   obj_in => Read_Field.out_obj;
   cont_sketch {
      GDroi2d_cont {
         immed<NEdisplayMode="NEeditingValue"> = 1;
         draw_mode<NEdisplayMode="NEeditingValue"> = 1;
         option<NEdisplayMode="NEeditingValue"> = 2;
      };
   };
};
GDM.Interactivity.EditMesh EditMesh<NEx=407,NEy=209> {
   view_in => Uviewer2D.Scene_Selector.curr_view;
   edit_mesh {
      GDedit_mesh {
         mode<NEdisplayMode="NEeditingValue"> = 2;
      };
   };
};
GDM.Uviewer2D Uviewer2D<NEx=495.,NEy=341.> {
   Scene {
      Top {
         child_objs => {
            <-.<-.<-.Read_Field.out_obj,
            <-.<-.<-.ContinuousSketch.cont_sketch.DataObject.obj
	 };
      };
   };
   GDM.Uscene2D Scene#1 {
      Top {
         child_objs<NEportLevels={4,1}> => {
            <-.<-.<-.reset_xform.out_obj};
      };
   };
   Scene_Selector {
      input_views => {Scene.View.View,
         <-.Scene#1.View.View};
   };
};

};

