/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDtut_10.v#1 $
*/

APPS.MultiWindowApp TwoView<NEdisplayMode="maximized",
                            NEhelpTopic="gdex_TwoView"> {

   MODS.Read_Geom Read_Geom<NEx=286.,NEy=66.> {
      read_geom_ui {
         filename = "$XP_PATH<0>/data/geom/math.geo";
      };
   };
   MODS.Read_Geom Read_Geom#1<NEx=517.,NEy=66.> {
      read_geom_ui {
         filename = "$XP_PATH<0>/data/geom/teapot.geo";
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=341.,NEy=187.> {
      Scene {
         Top {
            child_objs => {Read_Geom.geom};
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel<NEportLevels={0,6}> {
                        defaultWidth = 905;
                        defaultHeight = 529;
                     };
                  };
               };
               ViewFrame {
		  y = 0;
                  width => (<-.ViewPanel.UI.panel.width / 2);
               };
            };
         };
      };
      Scene_Selector {
         input_views => {Scene.View.View,<-.Uscene3D.View.View};
      };
      Scene_Editor {
         Light_Editor {
            GDlinfo_edit {
               sel_light => Scene.Lights.Lights[0];
            };
         };
      };
      GDM.Uscene3D Uscene3D<NEx=539.,NEy=143.> {
         Top {
            child_objs<NEportLevels={4,1}> => {Read_Geom#1.geom};
         };
         View<NEx=352.,NEy=429.> {
            macro ViewUI<export=1,export_subs=1> {
               UIframe ViewFrame<export=1,export_all=1> {
                  x => (link.width / 2);
		  y = 0;
                  width => (link.width / 2);
                  height => link.height;
#ifndef MSDOS
                  color {
                     backgroundColor => switch(View.selected,"red");
                  };
#endif
                  parent => <-.link;
                  shadowType = "shadow_etched_in";
                  shadowThickness = 3;
               };
               UIrenderView ViewWindow<export=1,export_all=1> {
                  width => (<-.ViewFrame.width <+> -6);
                  height => (<-.ViewFrame.height <+> -6);
                  parent => <-.ViewFrame;
               };
               UImouseEvents ViewEvents<export=1,export_all=1> {
                  view => ViewWindow;
               };
               UItwoPoint PickInteractor<export=1,export_all=1> {
                  view => ViewWindow;
                  startEvent = "Control<Btn1Down>";
                  runEvent = "Control<Btn1Motion>";
                  stopEvent = "Control<Btn1Up>";
               };
               GMOD.parse_v ViewSelect<export_subs=-1,NEx=440.,NEy=55.> {
                  v_commands = "View.selected = 1;";
                  trigger => (ViewEvents.buttonType | ViewPanel.UI.panel.visible);
                  sync = 1;
                  active => ;
                  relative => <-;
                  parse_v_relative<weight=0>;
               };
               link link<NEportLevels={4,1},NEx=143.,NEy=33.> => <-.<-.<-.Scene.View.ViewUI.ViewPanel.UI.panel;
            };
	    View {
	       View {
		  video_off => ;
		  render_view => ViewUI.ViewWindow;
	       };
	    };
         };
      };
   };
};
