/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gd_examp/GDtut_7.v#1 $
*/

APPS.SingleWindowApp CustomEdit<NEdisplayMode="maximized",
                                NEhelpTopic="gdex_CustomEdit"> {

   MODS.Read_Geom Read_Geom<NEx=308.,NEy=99.> {
      read_geom_ui {
         filename = "$XP_PATH<0>/data/geom/teapot.geo";
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=308.,NEy=198.> {
      Scene {
         Top {
            child_objs => {Read_Geom.geom};
         };
         View {
            ViewUI {
               ViewPanel<NEportLevels={0,0}> {
                  UI {
                     panel<NEportLevels={0,6}>;
                  };
               };
               ViewFrame {
		  y = 0;
                  height => (<-.ViewPanel.UI.panel.height <+> -100);
               };
            };
         };
      };
      Scene_Editor {
         macro MyXformEditor<NEx=616.,NEy=143.> {
            UIpanel UIpanel<NEx=88.,NEy=121.> {
               parent<NEdisplayMode="open"> => <-.link;
               y = 415;
               width => link.clientWidth;
               height = 75;
            };
            GDxform_edit GDxform_edit<NEx=462,NEy=121> {
               shell_vis = 1;
               xform => <-.GDobject_templ.xform;
               x_rot<NEportLevels={0,2}>;
               y_rot<NEportLevels={0,2}>;
               z_rot<NEportLevels={0,2}>;
               absolute = 1;
            };
            GDobject_templ &GDobject_templ<NEx=352,NEy=22,NEportLevels={2,1}> {
               xform<NEportLevels={2,2}>;
            } => <-.in_view.picked_obj;
            UIslider Xrot<NEx=187,NEy=242> {
               parent => <-.UIpanel;
               value => <-.GDxform_edit.x_rot;
               title => "X rot";
               y = 10;
               x = 10;
               width = 150;
               min = -180.;
               max = 180.;
            };
            UIslider Yrot<NEx=297,NEy=297> {
               parent => <-.UIpanel;
               value => <-.GDxform_edit.y_rot;
               title => "Y rot";
               y = 10;
               x = 170;
               width = 150;
               min = -180.;
               max = 180.;
            };
            UIslider Zrot<NEx=407,NEy=341> {
               parent => <-.UIpanel;
               value => <-.GDxform_edit.z_rot;
               title => "Z rot";
               x = 330;
               y = 10;
               width = 150;
               min = -180.;
               max = 180.;
            };
            link link<NEportLevels={3,1},NEx=88.,NEy=55.> => <-.<-.Scene.View.ViewUI.ViewPanel.UI.panel;
         };
      };
   };
};
