/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gdm.v#1 $
*/

$include ../include/avs/gd_def.h

#ifndef MSDOS
#define VUICOLOR_EDITOR_HEIGHT 295
#else
#define VUICOLOR_EDITOR_HEIGHT 275
#endif
#define VUICOLOR_EDITOR_DIAL_HEIGHT 128
#define VUIRANGE_SLIDERFRAME_HEIGHT 144
#define VUIDIAL_FIELD_HEIGHT 26

flibrary GDM<needs_edit_lic="GD",compile_subs=0,dictionary="au.dct"> {
   library Macro_Items {
      GDview_templ &Mview_link<NEportLevels={1,1}> {
	 picked_camera<NEportLevels={0,2}>;
	 light_info<NEportLevels={0,2}>;
      };

      /*
       * These objects are here to provide uneditable versions that
       * users can instance, save and restore.
       */
      DefaultObject DefaultObject;
      GroupObject GroupObject;
      DataObject  DataObject;
      DataObjectNoTexture DataObjectNoTexture;
      DataObjectLite DataObjectLite;
      DefaultTexture DefaultTexture;
      GDobject_templ GDobject_templ;
      GDxform_edit GDxform_edit;
      GDmap2d_ss GDmap2d_ss;
      GDpick_process GDpick_process;
      GDtrack_edit GDtrack_edit;

      macro Mlights<export_subs=1,export=1> {
	 int nlights<export=2> = 4;
	 DefaultXform LightXform<export_all=1>[nlights] {
            mat = {
               0.707107,0.5,0.5,0.,0.,
               0.707107,-0.707107,0.,
              -0.707107,0.5, 0.5,0.,
               0.,0.,0.,1.
            };
         };
	 DefaultLight Lights<export_all=1>[nlights] {
	    xform => LightXform[index_of(Lights)];
	 } = {{state=1},{},{},{}};
	 DefaultLightInfo LightInfo<export_all=1,NEportLevels={0,2}> {
	    lights => Lights;
	 };
      };

      macro Mcamera<export_subs=1,export=1> {
	 DefaultXform CameraXform<export_all=1>;
	 DefaultCamera3D Camera<export_all=1,NEportLevels={0,2}> {
	    auto_norm = 3;
	    objects<NEportLevels={3,0}>;
	    xform => <-.CameraXform;
	 };
      };

      macro Mview<export_subs=1,export=1> {
	 DefaultPickCtrl PickCtrl<export_all=1> {
	    on_start = 1;
	 };
	 BestVirtPal VirtPal<export_all=1>;
	 DefaultFieldOutput FieldOutput<export_all=1> {
	    local_ptr<NEvisible=0>;
	    init<NEvisible=0>;
	    delete<NEvisible=0>;
	    update<NEvisible=0>;
	 };

	 DefaultView View<NEportLevels={0,2},export_all=1> {
	    virtpal => <-.VirtPal;
	    pick_ctrl => <-.PickCtrl;
	    output => <-.FieldOutput;
	    light_info<NEportLevels={3,0}>;
	    cameras<NEportLevels={3,0}>;
	    cur_light = 0;
            // one-way connection to the default renderer
	    renderer => Templates.CONFIG.gd_default_renderer + 0;
	    picked_obj<NEportLevels={0,3}>;
	 };
      };

      //
      // This is the base viewer macro.  It contains a single view, a single
      // camera and a set of lights.
      //
      macro Mscene3D<export_subs=1,export=1> {
	 GDM.GroupObject Top<export_subs=1,export=1> {
	    child_objs<NEportLevels={3,1}>;
	    obj<export=0>;
	 };

	 Mlights Lights;

	 Mcamera Camera {
	    Camera {
	       objects => {<-.<-.Top.obj};
	    };
	 };

	 Mview View {
	    View<NEportLevels={0,3}> {
	       light_info => <-.<-.Lights.LightInfo;
	       cameras => {<-.<-.Camera.Camera};
	       picked_obj<NEportLevels={0,4}>;
	       handle<NEportLevels={4,0}>;
	    };
	 };
      };
      Mscene3D Mscene2D {
	 Camera.Camera.type = GD_CAMERA_2D;
	 View.View.renderer = GD_SWX_RENDERER;
      };
      Mscene3D Mscene {
	 GDM.GroupObject Top2D<export_subs=1,export=1> {
	    child_objs<NEportLevels={3,1}>;
	    obj<export=0>;
	 };
	 Mcamera Camera2D {
	    Camera {
	       objects => { <-.<-.Top2D.obj};
	       type = GD_CAMERA_2D;
	    };
	 };
	 View.View {
	    cameras => {<-.<-.Camera.Camera, <-.<-.Camera2D.Camera};
	    renderer = GD_SWX_RENDERER;
	 };
      };
   };
   library Macro_Editors {
      macro Mlights_editor {
	 Mview_link &in_view<NEportLevels={2,1}>;
	 GDlinfo_edit+OPort GDlinfo_edit<export_all=2,export=2> {
	    cur_light => in_view.cur_light;
	    shell_vis = 1;
	    light_info<NEportLevels={2,0}> => <-.in_view.light_info;
	    sel_light<NEportLevels={0,2}>;
	 };
	 GDlight_edit+OPort GDlight_edit<export_all=2,export=2> {
	    shell_vis = 1;
	    light => <-.GDlinfo_edit.sel_light;
	 };
      };
      macro Mcamera_editor {
	 Mview_link &in_view<NEportLevels={2,1}>;
	 GDcamera_edit GDcamera_edit<NEportLevels={0,1},
				     export_all=2,export=2> {
	    shell_vis<export=0> = 1;
	    camera<NEportLevels={2,0},export=0> => <-.in_view.picked_camera;
	    perspec = 0;
	 };
      };
      macro Mtrack_editor {
	 Mview_link &in_view<NEportLevels={2,1}>;
	 GDobject_templ &cur_obj<NEportLevels={2,1}>;
	 GDtrack_edit GDtrack_edit<export=2,export_all=2> {
	    view => <-.in_view;
	    camera => <-.in_view.picked_camera;
	    obj => <-.cur_obj;
	    cur_light => <-.in_view.cur_light;
	 };
      };
      macro Mobject_editor {
	 Mview_link &in_view<NEportLevels={2,1},export=0>;
	 GDobject_templ &cur_obj<NEportLevels={2,1},export=0> {
	    modes<NEportLevels={0,2}>;
	    props<NEportLevels={0,2}>;
	    texture<NEportLevels={0,2}>;
	 };
	 GDobj_edit GDobj_edit<export=2,export_all=2> {
	    shell_vis = 1;
	    camera<NEportLevels={2,0}> => <-.in_view.picked_camera;
	    object+IPort2 => <-.cur_obj;
	 };
	 GDmodes_edit+OPort GDmodes_edit<export=2,export_all=2> {
	    int edit_alt_modes = 0;
	    shell_vis = 1;
	    modes+IPort2 => switch(edit_alt_modes+1,<-.cur_obj.modes,
				   <-.cur_obj.altobj.modes);
	 };
	 GDprops_edit+OPort GDprops_edit<export=2,export_all=2> {
	    int edit_alt_props = 0;
	    shell_vis = 1;
	    props+IPort2 => switch(edit_alt_props+1,<-.cur_obj.props,
				   <-.cur_obj.altobj.props);
	 };
	 GDtexture_edit GDtexture_edit<export=2,export_all=2> {
	    shell_vis = 1;
	    texture+IPort2 => <-.cur_obj.texture;
	 };
      };
      macro Mview_editor {
	 Mview_link &in_view<NEportLevels={2,1}>;
	 GDview_edit+OPort GDview_edit<export=2,export_all=2> {
	    shell_vis = 1;
	    view<NEportLevels={2,0}> => <-.in_view;
	 };
	 GDobj_sel GDobj_sel<export=2,export_all=2> {
	    view<NEportLevels={2,0},export=0> => <-.in_view;
	    cur_obj<NEportLevels={0,3},export=4>;
	    local_ptr<export=0>;
	 };
      };
      //
      // This object implements the editing functionality for a viewer
      // it takes a single input port which is the view to edit.
      //
      macro Mscene_editor<export=1> {
	 Mview_link &in_view<NEportLevels={2,1}>;
	 Mview_editor View_Editor<export=2,export_subs=1> {
	    in_view<export=0> => <-.in_view;
	    GDobj_sel.cur_obj<NEportLevels={0,4}>;
	 };
	 Mtrack_editor Track_Editor<export=2,export_subs=1> {
	    in_view<export=0> => <-.in_view;
	    cur_obj<export=0> => <-.View_Editor.GDobj_sel.cur_obj;
	 };
	 Mlights_editor Light_Editor<export=2,export_subs=1> {
	    in_view<export=0> => <-.in_view;
	 };
	 Mcamera_editor Camera_Editor<export=2,export_subs=1> {
	    in_view<export=0> => <-.in_view;
	 };
	 Mobject_editor Object_Editor<export=2,export_subs=1> {
	    in_view => <-.in_view;
	    cur_obj => <-.View_Editor.GDobj_sel.cur_obj;
	 };
      };
      macro Mviewer<export_subs=1> {
	 GDM.Mscene Scene {
	    Top.child_objs<NEportLevels={4,1},NEcolor0=0xff0000>;
	    Top2D.child_objs<NEportLevels={4,1},NEcolor0xff0000>;
	 };
	 GDview_selector Scene_Selector<export_subs=1,export=1> {
	    input_views => {Scene.View.View};
	    curr_view<NEportLevels={0,3}>;
	 };
	 Mscene_editor Scene_Editor {
	    in_view => Scene_Selector.curr_view;
	    View_Editor.GDobj_sel.cur_obj<NEportLevels={0,5}>;
	 };
      };
   };
   library UI_Items {
      Mview_link Uview_link {
	 // Get rid of input ports we don't want to see
	 virtpal<NEportLevels=0>;
	 handle<NEportLevels=0>;
	 pick_ctrl<NEportLevels=0>;
	 cameras<NEportLevels=0>;
	 buffers<NEportLevels=0>;
	 light_info<NEportLevels=0>;

	 output<NEportLevels={0,2}>;

	 UIrenderView+OPort2 &render_view {
	    /*
	     * Prevent errors on the match here
	     */
	    x = ;
	    width = ;
	    height = ;
	 };
	 UItwoPoint &two_point;
	 UImouseEvents &mouse_events;
      };
      /*
       * Create a family of macros that provide interactors but do not
       * have a complete ViewUI interface with panels etc... this allows
       * you to build a view/scene with your own UI parent
       */
      Mview Iview {
	 macro ViewUI<export=1,export_subs=1> {
	    UIrenderView ViewWindow<export=1,export_all=1> {
	       x = 0;
	       y = 0;
	       parent<NEportLevels={4,0}>;
	      // connect directly to width/height so that this is a two-way conn
	       width => parent.clientWidth;
	       height => parent.clientHeight;
	       color.backgroundColor = "black";
	    };

	    // full screen view option (stereo)
	    GMOD.instancer instancer {
	       Value => View.video;
	       Group => FullViewWindow;
	    };
	    macro FullViewWindow<instanced=0> {
	       UIshell FullShell {
		  x = 0;
		  y = 0;
		  width => <-.<-.<-.View.full_view_width;
		  height => <-.<-.<-.View.full_view_height;
		  showStatusBar = 0;
	       };
	       UIpanel FullPanel {
		  parent => FullShell;
		  x => parent.x;
		  y => parent.y;
		  width => parent.width;
		  height => parent.height;
	       };
	       UIrenderView FullWindow<export=1,export_all=1> {
		  parent => FullPanel;
		  x => parent.x;
		  y => parent.height / 2;
		  width => parent.width;
		  height => parent.height / 2;
	       };
	    };

	    UImouseEvents ViewEvents<export=1,export_all=1> {
	       view => RendView;
	    };

	    /* interactor for picking */
	    UItwoPoint PickInteractor<export=1,export_all=1> {
	       view => RendView;
#ifndef MSDOS
	       startEvent = "Control<Btn1Down>";
	       runEvent = "Control<Btn1Motion>";
	       stopEvent = "Control<Btn1Up>";
#else
	       startEvent = "Control<BtnLDown>";
	       runEvent = "Control<BtnLMotion>";
	       stopEvent = "Control<BtnLUp>";
#endif
	    };

	    /* video OFF control for SGI full screen stereo */
	    UIonePoint VideoOffControl<export=1,export_all=1> {
	       view => RendView;
#ifndef MSDOS
	       runEvent = "Shift<Btn1Down>";
#else
	       runEvent = "Shift<BtnLMotion>";
#endif
	    };

	    GMOD.parse_v ViewSelect<export_subs=-1> {
	       on_inst =0;
	       /*
		* Whenever the button is pressed, we select this view.
		*/
	       trigger => ViewEvents.buttonType;
	       v_commands = "View.selected = 1;";
	       /*
		* Don't select views that are not
		* visible
		*/
	       active = 1;
	       // 
	       // execute all downstream objects when this module runs
	       // synchronously
	       //
	       sync = 1;
	       relative => <-;
	       // run before we run other methods 
	       // so that we select the view first...
	       parse_v_relative<weight=0>;
	    };

	    link RendView<NEportLevels=1> =>
		switch(View.video + 1,
			ViewWindow, FullViewWindow.FullWindow);
	 };
	 PickCtrl {
	    x => ViewUI.PickInteractor.x;
	    y => ViewUI.PickInteractor.y;
	    event => ViewUI.PickInteractor.state;
	 };
	 View {
	    UIrenderView &render_view<NEportLevels={2,0}> {
	       // null these out to prevent matching problems
	       width = ; height = ; x = ;
	    } => <-.ViewUI.RendView;
            UItwoPoint &two_point => <-.ViewUI.PickInteractor;
	    UImouseEvents &mouse_events => <-.ViewUI.ViewEvents;
	    handle => render_view.handle;
	    video_off => ViewUI.VideoOffControl.state;
	 };
      };
      Mscene3D Iscene3D {
	 View+Iview {
	    ViewUI {
	       ViewWindow {
		  parent<NEportLevels={5,0}>;
	       };
	    };
	    View<NEportLevels={0,3}> {
	       buffers<NEportLevels={4,0}>;
	       FieldOutput {
		  buffers<NEportLevels={0,4}>;
	       };
	    };
	 };
      };
      Iscene3D Iscene2D {
	 Camera.Camera.type = GD_CAMERA_2D;
	 View.View.renderer = GD_SWX_RENDERER;
      };
      Iscene3D+Mscene Iscene {
	 View.View.renderer = GD_SWX_RENDERER;
      };
      Iview Uview {
	 ViewUI {
	    AU.AUpanel ViewPanel<export=1,export_subs=1,NEvisible=1> {
	       UI<NEvisible=1> {
		  panel {
		     // need to account for difference in width/height
		     // and clientWidth/clientHeight
		     int+nres dw => parent.clientWidth - parent.width;
		     int+nres dh => parent.clientHeight - parent.height;
		     // connect directly to width/height so this is 2-way
		     width => parent.width <+> dw;
		     height => parent.height <+> dh;
		     hconn_widget {
			offer = "widget (graphics)";
			accept = ;
		     };
		     /* XXX need to fix UI ability to switch visible panels */
		     visible = 1;
		     title => option.label;
		     UIshell.title => name_of(<-.<-.<-.<-.<-.<-.<-,1);
		  };
		  option {
		     // use name of view object
		     label => name_of(<-.<-.<-.<-.<-,1);
		     hconn_list {
			offer = "list (graphics)";
		     };
		  };
	       };
	    };
	    UIframe ViewFrame<export=1,export_all=1,NEvisible=1> {
	       /* Set this explicitly or else instance order determines y */
	       x = 0;
	       y = 0;
	       parent => <-.ViewPanel.UI.panel;
	       width => parent.width;
	       height => parent.height;
	       shadowType = "shadow_etched_in";
#ifndef MSDOS
   // On the PC, this causes background to flash when it changes.  We
   // could create a copy of View.selected that only gets events when
   // the values actually changes to reduce this problem.  Fixing the UI
   // would be the best solution!
	       // If selected red, otherwise unset
	       shadowThickness = 3;
	       color.backgroundColor => switch(View.selected,"red");
#else
	       shadowThickness = 0;
#endif
	    };
	    ViewWindow <NEvisible=1> {
	       parent<NEportLevels={2,0}> => <-.ViewFrame;
	       // need to account for difference in width/height
	       // and clientWidth/clientHeight
	       int+nres dw => parent.clientWidth - parent.width;
	       int+nres dh => parent.clientHeight - parent.height;
	       // connect directly to width/height so this is 2-way
	       width => parent.width <+> dw;
	       height => parent.height <+> dh;
	       color.backgroundColor = "black";
	    };
	    ViewSelect <NEvisible=1> {
	       /*
		* Select the view either when it is made visible or when
		* the user clicks in it.
		*/
	       trigger => ViewEvents.buttonType | ViewPanel.UI.panel.visible;

	       /*
		* Only allow the selection when the object is NOW visible
		*/
	       active => ViewPanel.UI.panel.visible;
	    };
	 };
      };
      Mscene3D Uscene3D {
	 View+Uview {
	    ViewUI.ViewPanel.UI.option.label => name_of(<-.<-.<-.<-.<-.<-,1);
	    View<NEportLevels={0,3}> {
	       buffers<NEportLevels={4,0}>;
	       FieldOutput {
		  buffers<NEportLevels={0,4}>;
	       };
	    };
	 };
      };
      Uscene3D Uscene2D {
	 Camera.Camera.type = GD_CAMERA_2D;
	 View.View.renderer = GD_SWX_RENDERER;
      };
      Uscene3D+Mscene Uscene {
	 View.View.renderer = GD_SWX_RENDERER;
      };
   };
   flibrary+global Camera_Editors<indexed=1> {
      AU.AUpanel_inst Ulens_editor {
	 UI.option.hconn_list.order = 4;
	 UI.option.active => !in_view.ts_enable;
	 GDcamera_edit &GDcamera_edit<NEportLevels={2,0}>;
	 IUI {
	    VUIToggle Perspective {
	       y      = 0;
	       width  => panel.width;
	       parent => panel;
	       label  = "Perspective On";
	       set	=> GDcamera_edit.perspec;
	    };
	    VUIField Scale {
	       y	=> <-.Perspective.y + <-.Perspective.height;
	       width  => panel.width;
	       parent => panel;
	       label  = "Global Scale";
	       value	=> GDcamera_edit.scale;
	       active => !GDcamera_edit.perspec;
	    };
	    VUIField WindowSize {
	       y	=> <-.Scale.y + <-.Scale.height;
	       width  => panel.width;
	       parent => panel;
	       label  = "Viewport Size";
	       value	=> GDcamera_edit.wsize;
	    };
	    VUISlider VUISlider {
	       y	=> WindowSize.y + WindowSize.height;
	       width  => panel.width;
	       parent => panel;
	       min    = 1;
	       max    = 180;
	       decimalPoints = 0;
	       title  = "Field of View";
	       value	=> GDcamera_edit.fov;
	       active => GDcamera_edit.perspec;
	    };
	 };
      };

      AU.AUpanel_inst Utripod_editor {
	 GDcamera_edit &GDcamera_edit<NEportLevels={2,0}>;
	 UI.option.hconn_list.order = 3;
	 UI.option.active => !in_view.ts_enable;
	 IUI {
	    int Width => panel.clientWidth/5;

	    VUILabel From {
	       parent    => panel;
	       y         => X.y + X.height + 2;
	       width     => <-.Width;
	       height    => FromX.height;
	       label     =  "From";
	       alignment =  2;
	    };
	    From Up {
	       y         => From.y + From.height + 2;
	       label     =  "Up";
	    };
	    From At {
	       y         => Up.y + Up.height + 2;
	       label     =  "At";
	    };

	    UIlabel X {
	       parent    => <-.panel;
	       x         => <-.Width;
	       y         =  10;
	       width     => <-.Width;
	       height    =  20;
	       alignment =  1;
	       label  = "X";
	    };
	    X Y {
	       x      => 2 * <-.Width;
	       height => X.height;
	       label  = "Y";
	    };
	    X Z {
	       x      => 3 * <-.Width;
	       height => X.height;
	       label  = "Z";
	    };

	    Controls.UIfield FromX {
	       parent => panel;
	       x      => <-.X.x;
	       y      => <-.From.y;
	       width  => <-.Width;
	       height = 34;
	       value	=> GDcamera_edit.from_x;
	    };
	    FromX FromY {
	       x      => <-.Y.x;
	       value	=> GDcamera_edit.from_y;
	    };
	    FromX FromZ {
	       x      => <-.Z.x;
	       value	=> GDcamera_edit.from_z;
	    };

	    Controls.UIfield UpX {
	       parent => panel;
	       x      => <-.X.x;
	       y      => <-.Up.y;
	       width  => <-.Width;
	       height = 34;
	       value	=> GDcamera_edit.up_x;
	    };
	    UpX UpY {
	       x      => <-.Y.x;
	       value	=> GDcamera_edit.up_y;
	    };
	    UpX UpZ {
	       x      => <-.Z.x;
	       value	=> GDcamera_edit.up_z;
	    };

	    Controls.UIfield AtX {
	       parent => panel;
	       x      => <-.X.x;
	       y      => <-.At.y;
	       width  => <-.Width;
	       height = 34;
	       value	=> GDcamera_edit.at_x;
	    };
	    AtX AtY {
	       x      => <-.Y.x;
	       value	=> GDcamera_edit.at_y;
	    };
	    AtX AtZ {
	       x      => <-.Z.x;
	       value	=> GDcamera_edit.at_z;
	    };
	 };
      };

      AU.AUpanel_inst Uclipping_editor {
	 UI.option.hconn_list.order = 4;
	 UI.option.active => !in_view.ts_enable;
	 GDcamera_edit &GDcamera_edit<NEportLevels={2,0}>;
	 IUI {
	    VUIToggle ClipOn {
	       y      = 0;
	       width  => panel.width;
	       parent => panel;
	       label  = "Clipping Planes On";
	       set	=> GDcamera_edit.hither;
	    };
	    VUIRange Planes {
               SliderFrame.height = VUIRANGE_SLIDERFRAME_HEIGHT;
	       parent    => panel;
	       y         => ClipOn.y + ClipOn.height;
	       width     => panel.width;
	       value1    => GDcamera_edit.front;
	       value2    => GDcamera_edit.back;
	       min       => switch(ClipOn.set+1,
//				GDcamera_edit.front,
				GD_DEFAULT_FRONT_PAR,
				switch(GDcamera_edit.perspec+1, 0.0, 1.0));
	       max       => switch(ClipOn.set+1,
//				GDcamera_edit.back,
				GD_DEFAULT_BACK, 20.0);
	       active    => ClipOn.set;
	       title     =  "Clip Plane Positions";
	       constrain =  1;
	       immediate =  0;
	       label1    =  "Front";
	       label2    =  "Back";
	    };
	 };
      };

      AU.AUpanel_inst Udepth_cue_editor {
	 UI.option.hconn_list.order = 5;
	 GDcamera_edit &GDcamera_edit<NEportLevels={2,0}>;
	 IUI {
	    VUIToggle DepthCueOn {
	       y      = 0;
	       width  => panel.width;
	       parent => panel;
	       label  = "Depth Cueing On";
	       set	=> GDcamera_edit.depth_cue;
	    };
	    VUISlider Front {
	       y	=> DepthCueOn.y + DepthCueOn.height;
	       width  => panel.width;
	       parent => panel;
	       title  = "Front Depth Cue";
	       value	=> GDcamera_edit.depth_front;
	       min    = 0;
	       max    = 20;
	       active => DepthCueOn.set;
	    };
	    VUISlider Back {
	       y	=> <-.Front.y + <-.Front.height;
	       width  => panel.width;
	       parent => panel;
	       title  = "Back Depth Cue";
	       value	=> GDcamera_edit.depth_back;
	       min    = 0;
	       max    = 20;
	       active => DepthCueOn.set;
	    };
	    VUISlider Scale {
	       y	=> <-.Back.y + <-.Back.height;
	       width  => panel.width;
	       parent => panel;
	       title  = "Depth Cue Scale";
	       value	=> GDcamera_edit.depth_scale;
	       min    = 0;
	       max    = 1;
	       active => DepthCueOn.set;
	    };
	 };
      };

      AU.AUpanel_inst Uoptions_editor {
	 UI.option.hconn_list.order = 1;
	 GDcamera_edit &GDcamera_edit<NEportLevels={2,0}>;
	 IUI {
	    VUIOptionMenuLabel CameraType {
	       parent       => panel;
	       width        => panel.clientWidth;
	       options      => { "3D Camera", "2D Camera" };
	       label        =  "Camera Type";
	       // relies on GD_CAMERA_3D to be 0, GD_CAMERA_2D to be 1
	       selectedItem => GDcamera_edit.type;
	    };

	    VUIToggle Pickable {
	       x      = 0;
	       y      => CameraType.y + CameraType.height;
	       width 	=> (panel.width/2);
	       parent => <-.panel;
	       label  = "Pickable";
	       set	=> GDcamera_edit.pickable;
	    };

	    VUIToggle ImagePass {
	       x      => panel.clientWidth / 2;
	       y	=> Pickable.y;
	       width 	=> (panel.width/2);
	       parent => <-.panel;
	       label  = "Image Pass";
	       set	=> GDcamera_edit.image_pass;
	    };

	    VUIOptionMenuLabel Extents {
	       parent	=> <-.panel;
	       y	=> Pickable.y + Pickable.height;
	       width	=> panel.width;
	       options	=> { "Compute", "Window" };
	       label	= "Extents";
	       selectedItem => GDcamera_edit.extents;
	    };

	    VUIOptionMenuLabel Mapping {
	       parent => <-.panel;
	       y	 => <-.Extents.y + <-.Extents.height;
	       width 	 => panel.width;
	       options => { "World", "Pixel" };
	       label   = "Mapping";
	       selectedItem	=> GDcamera_edit.mapping;
	    };
	    VUIOptionMenuLabel Normalize {
	       parent => <-.panel;
	       y       => Mapping.y + Mapping.height;
	       width 	 => <-.panel.width;
	       options => { "None",          "Data Change", 
			    "Object Attach", "Data and Object" };
	       label   = "Auto Normalize";
	       selectedItem	=> GDcamera_edit.auto_norm;
	    };
	    VUIField NormScale {
	       parent => panel;
	       y 	=> Normalize.y + Normalize.height;
	       width  => panel.width;
	       label  = "Normalize Scale";
	       value	=> GDcamera_edit.norm_scale;
	    };
	    VUIToggle NormInvisible {
	       parent => panel;
	       y	=> NormScale.y + NormScale.height;
	       width 	=> panel.width;
	       label  = "Normalize Invisible Objects";
	       set	=> GDcamera_edit.norm_invisible;
	    };
	    VUIField JitterScale {
	       parent => panel;
	       y 	=> NormInvisible.y + NormInvisible.height;
	       width  => panel.width;
	       label  = "Jitter Scale";
	       value	=> GDcamera_edit.jitter_scale;
	    };
	    UIbutton Reset {
	       parent => <-.panel;
	       y 	=> JitterScale.y + JitterScale.height;
	       label 	= "Reset";
	       do	=> GDcamera_edit.reset;
	       width  => panel.width;
	    };
	 };
      };
   };
   flibrary+global Light_Editors<indexed=1> {
      AU.AUpanel_inst Ulight_type {
	 UI.option.hconn_list.order = 1;
	 GDlight_edit &GDlight_edit<NEportLevels={2,0}>;
	 GDlinfo_edit &GDlinfo_edit<NEportLevels={2,0}>;
	 IUI {
	    group light_labels[GDlinfo_edit.light_info.nlights] {
	       string label => "Light " + index_of(light_labels);
	    };
	    UIframe AllFrame {
	       parent	=> panel;
	       width	=> panel.clientWidth;
	       height	=> Show.y + Show.height + 6;
	    };
	    UIbutton Reset_All {
	       y = 0;
	       parent   => AllFrame;
	       width	=> AllFrame.clientWidth;
	       do	=> GDlinfo_edit.reset;
	    };
	    VUIToggle Show {
	       parent   => AllFrame;
	       width	=> AllFrame.clientWidth;
	       y	=> Reset_All.y + Reset_All.height;
	       label	= "Show Lights";
	       set	=> GDlinfo_edit.show;
	    };

	    VUIOptionMenuLabel CurrentLight {
	       parent => <-.panel;
	       options => light_labels.label;
	       y	=> AllFrame.y + AllFrame.height;
	       width	=> panel.clientWidth;
	       label 	= "Current";
	       selectedItem => GDlinfo_edit.cur_light;
	    };
	    VUIOptionMenuLabel LightType {
	       parent => <-.panel;
	       options = {"Directional", "Point", "Spot", "Bi Directional"};
	       width	=> panel.clientWidth;
	       y	=> CurrentLight.y + CurrentLight.height;
	       label 	= "Type";
	       // IAC/MPU: added flags for MPU renderer to active lists
	       //   MPU renderer is the end value in list
	       OPcmdList = {,
			{active => switch(in_view.renderer+1, 0,1,1,1,0,1)},
			{active => switch(in_view.renderer+1, 0,1,1,1,0,1)},};
	       selectedItem => GDlight_edit.type;
	    };
	    VUIToggle OnOff {
	       y	=> <-.LightType.y + <-.LightType.height;
	       width => panel.clientWidth;
	       parent => <-.panel;
	       label  = "Light On";
	       set	=> GDlight_edit.state;
	    };

	    GMOD.parse_v Reset0 {
	       trigger => Reset_Current.do;
	       /* Can't use GD defines in runtime */
	       v_commands =
		"GDlight_edit.state  = (GDlinfo_edit.cur_light == 0);
//		 GDlight_edit.type   = GD_DEFAULT_LIGHT_TYPE;
//		 GDlight_edit.red    = GD_DEFAULT_RED;
//		 GDlight_edit.green  = GD_DEFAULT_GREEN;
//		 GDlight_edit.blue   = GD_DEFAULT_BLUE;
//		 GDlight_edit.att1   = GD_DEFAULT_ATTEN;
//		 GDlight_edit.att2   = GD_DEFAULT_ATTEN;
//		 GDlight_edit.concen = GD_DEFAULT_CONCEN;
//		 GDlight_edit.angle  = GD_DEFAULT_ANGLE;

// can't use defines in runtime parse_v (see 6412, 7811)
		 GDlight_edit.type   = 0;
		 GDlight_edit.red    = 1.0;
		 GDlight_edit.green  = 1.0;
		 GDlight_edit.blue   = 1.0;
		 GDlight_edit.att1   = 1.0;
		 GDlight_edit.att2   = 1.0;
		 GDlight_edit.concen = 1.0;
		 GDlight_edit.angle  = 45.0;
		";
	       on_inst = 0;
	       relative => <-;
	    };
	    UIbutton Reset_Current {
	       y	=> <-.OnOff.y + <-.OnOff.height;
	       width => panel.clientWidth;
	       parent => <-.panel;
	    };

	    UIframe ColorFrame {
		y => <-.Reset_Current.y + <-.Reset_Current.height;
		parent => panel;
		width => panel.clientWidth;
		height  = VUICOLOR_EDITOR_HEIGHT;
	    };
	    VUIColorEditor VUIColorEditor {
               Dials{
                  HDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  SDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  VDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
               };
	       parent 	=> ColorFrame;
		y = 0;
	       width 	=> ColorFrame.clientWidth;
	       red	=> GDlight_edit.red;
	       green	=> GDlight_edit.green;
	       blue	=> GDlight_edit.blue;
	       label = "Current Light Color Editor";
	    };
	 };
      };
      AU.AUpanel_inst Ulight_attr {
	 UI.option.hconn_list.order = 2;
	 GDlight_edit &GDlight_edit<NEportLevels={2,0}>;
	 IUI {
	    VUISlider Attenuation1 {
	       y      = 0;
	       width => <-.panel.width;
	       parent => <-.panel;
	       min    = 0;
	       max    = 10;
	       title  = "Attenuation 1";
	       value	=> GDlight_edit.att1;
	       active  => GDlight_edit.light.type == 2;
	    };
	    VUISlider Attenuation2 {
	       y	=> <-.Attenuation1.y + <-.Attenuation1.height;
	       width => <-.panel.width;
	       parent => <-.panel;
	       min    = 0;
	       max    = 10;
	       title  = "Attenuation 2";
	       value	=> GDlight_edit.att2;
	       active  => GDlight_edit.light.type == 2;
	    };
	    VUISlider Concentration {
	       y	=> <-.Attenuation2.y + <-.Attenuation2.height;
	       width => <-.panel.width;
	       parent => <-.panel;
	       min    = 0;
	       max    = 50;
	       title  = "Concentration";
	       value	=> GDlight_edit.concen;
	       active  => GDlight_edit.light.type == 2;
	    };
	    VUISlider SpreadAngle {
	       y	=> <-.Concentration.y + <-.Concentration.height;
	       width => <-.panel.width;
	       parent => <-.panel;
	       min    = 0;
	       max    = 180;
	       decimalPoints = 0;
	       title  = "Spread Angle";
	       value	=> GDlight_edit.angle;
	       active  => GDlight_edit.light.type == 2;
	    };
	 };
      };
      AU.AUpanel_inst Ulight_ambient {
	 UI.option.hconn_list.order = 3;
	 GDlinfo_edit &GDlinfo_edit<NEportLevels={2,0}>;
	 IUI {
	    VUIToggle AmbientOn {
	       parent => <-.panel;
	       label  = "Light On";
	       y      = 0;
	       width => <-.panel.width;
	       set	=> GDlinfo_edit.amb_onoff;
	    };

	    UIframe ColorFrame {
		y      => AmbientOn.y + AmbientOn.height;
		parent => panel;
		width => panel.clientWidth;
		height  = VUICOLOR_EDITOR_HEIGHT;
	    };
	    VUIColorEditor VUIColorEditor {
               Dials{
                  HDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  SDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  VDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
               };
	       parent 	=> ColorFrame;
		y = 0;
	       width 	=> ColorFrame.clientWidth;
	       red	=> GDlinfo_edit.amb_red;
	       green	=> GDlinfo_edit.amb_green;
	       blue	=> GDlinfo_edit.amb_blue;
	       label = "Ambient Light Color Editor";
	    };
	 };
      };
   };

   flibrary+global Object_Editors<indexed=1> {
      AU.AUpanel_inst Uobject_general {
	 UI.option.hconn_list.order = 5;
	 GDobj_edit &GDobj_edit<NEportLevels={2,0}>;
	 GDprops_edit &GDprops_edit<NEportLevels={2,0}>;
	 GDmodes_edit &GDmodes_edit<NEportLevels={2,0}>;
	 GDobject_templ+IPort2 &cur_obj;

	 IUI {
	    VUIToggle Visible {
	       parent		=> panel;
	       x		= 0;
	       width 		=> panel.clientWidth / 2;
	       set 	 	=> GDobj_edit.visible;
	       label 		= "Visible";
	    };
	    VUIOptionMenuLabel Pickable {
	       parent         => panel;
	       x              => panel.clientWidth/2;
	       y              => <-.Visible.y;
           options        => { "None", "All", "Surfaces", "Lines", "Points" };
	       width          => panel.clientWidth/2;
	       selectedItem   => GDobj_edit.pickable;
	       label          = "Pickable";
	    };
	    VUIToggle Cached {
	       parent         => panel;
	       x	      = 0;
	       y              => <-.Pickable.y + <-.Pickable.height;
	       width          => panel.clientWidth / 2;
	       set            => GDobj_edit.cached;
	       label          = "Cached";
	    };
	    VUIToggle Dynamic {
	       parent         => panel;
	       x	      => panel.clientWidth / 2;
	       y              => <-.Cached.y;
	       width          => panel.clientWidth / 2;
	       set            => GDobj_edit.type;
	       label          = "Dynamic";
	    };
            VUIField CacheSize {
               parent	      => panel;
	       x              = 0;
               y              => Cached.y + Cached.height;
               width          => panel.clientWidth;
               label          = "Cache Size (MB)";
               value          => GDobj_edit.cache_size;
               min            = 1;
               max            = 1024;
               mode           = 1;
            };
	    UIframe AltFrame {
	       parent	      => panel;
	       x	      = 0;
	       y	      => CacheSize.y + CacheSize.height;
	       width	      => panel.clientWidth;
	       height	      => AltSpace.y + AltSpace.height + 4;
	    };
	    UIlabel AltTitle {
	       parent	      => AltFrame;
	       y	      = 5;
	       width	      => AltFrame.clientWidth;
	       label	      = "Alternate Object";
	       alignment      = 1;
	    };
	    VUIToggle AltUse {
	       parent         => AltFrame;
	       y	      => AltTitle.y + AltTitle.height;
	       width	      => AltFrame.clientWidth / 2;
	       set            => GDobj_edit.use_altobj;
	       label          = "Enable";
	    };
	    VUIToggle AltVis {
	       parent         => AltFrame;
	       x	      => AltFrame.clientWidth / 2;
	       y	      => AltUse.y;
	       width	      => AltFrame.clientWidth / 2;
	       set+nres       => cur_obj.altobj.visible;
	       label          = "Visible";
	       active	      => GDobj_edit.use_altobj;
	    };
	    VUIOptionMenuLabel AltSpace {
	       parent         => AltFrame;
	       options	      = {"Match Camera", "Force 2D"};
	       y	      => AltVis.y + AltVis.height;
	       width	      => AltFrame.clientWidth;
	       selectedItem+nres => cur_obj.altobj.space;
	       label	      = "Render Space";
	       active	      => GDobj_edit.use_altobj;
	    };
	    VUIOptionMenuLabel TransformMode {
	       parent => panel;
	       options = {"Normal", "Parent", "Alternate", "Locked"};
	       y => AltFrame.y + AltFrame.height + 6;
	       width => panel.clientWidth;
	       selectedItem => GDobj_edit.xform_mode;
	       label = "Transform Mode";
	    };
            VUIText WWWurl {
               parent => panel;
               y => TransformMode.y + TransformMode.height + 6;
               width => panel.clientWidth;
               label = "WWW url";
               text => cur_obj.WWW_url;
            };
            VUIText WWWlabel {
               parent => panel;
               y => WWWurl.y + WWWurl.height + 6;
               width => panel.clientWidth;
               label = "WWW label";
               text => cur_obj.WWW_label;
            };
	 };
      };
      AU.AUpanel_inst Uobject_field_conv {
	 UI.option.hconn_list.order = 2;
	 GDobj_edit &GDobj_edit<NEportLevels={2,0}>;
	 IUI {
	    AU.AUoptionMenuStack Type {
		UI.option.hconn_list.offer = "";
		IUI {
		    panel {
			hconn_widget.offer = "";
			visible = 1;
			parent => <-.<-.<-.panel;
			y = 0;
			height => parent.clientHeight;
		    };
		    AU.AUpanel_inst LineSurface {
			UI.option.label = "Line/Surface";
			UI.option.hconn_list.order = 1;
			IUI {
			    VUIOptionMenuLabel ConversionType {
				parent => panel;
				width => panel.clientWidth;
				options = {"Simple", "Optimal", "None"};
				selectedItem => GDobj_edit.surf_conv;
				label = "Conversion Type";
			    };
			    VUIToggle Chunking {
				parent => panel;
				width => panel.clientWidth;
				y => ConversionType.y + ConversionType.height;
				label = "Chunking";
				set => GDobj_edit.chunk;
			    };
			    VUIField SurfaceChunk {
				parent => panel;
				width => panel.clientWidth;
				y => Chunking.y + Chunking.height;
				label = "Surface Chunk";
				value => GDobj_edit.surf_chunk;
				active => GDobj_edit.chunk;
			    };
			    VUIField LineChunk {
				parent => panel;
				width => panel.clientWidth;
				y => SurfaceChunk.y + SurfaceChunk.height;
				label = "Line Chunk";
				value => GDobj_edit.line_chunk;
				active => GDobj_edit.chunk;
			    };
			    VUIField SurfSubdiv {
				parent => panel;
				width => panel.clientWidth;
				y => LineChunk.y + LineChunk.height;
				label = "Surface Subdivision";
				value => GDobj_edit.surf_subdiv;
				min = 1;
				max = 5;
				mode = 1;
                            };
			};
		    };
		    AU.AUpanel_inst Image {
			UI.option.hconn_list.order = 2;
			IUI {
			    VUIOptionMenuLabel Technique {
				parent => panel;
				width => panel.clientWidth;
				options = {"Cube", "Ramp"};
				label = "Dither Technique";
				selectedItem => GDobj_edit.dith_tech;
			    };

			    VUIOptionMenuLabel Interp {
				parent => panel;
				width => panel.clientWidth;
				y => Technique.y + Technique.height;
				options = {"Point", "Bilinear", "Bicubic", "Flat", "Smooth", "Point/Image", "Bilinear/Image", "Bicubic/Image"};
				label = "Interpolation";
				// IAC/MPU: added flags for MPU renderer to active lists
				//   MPU renderer is the end value in list
				OPcmdList = {,,
			{active => switch(in_view.renderer+1, 0,0,0,0,1,0)},,,
			{active => switch(in_view.renderer+1, 0,0,0,0,1,0)}};
				selectedItem => GDobj_edit.interp_type;
			    };

			    VUISlider MissingScalar {
				parent => panel;
				width => panel.clientWidth;
				y => Interp.y + Interp.height;
				min = 0;
				max = 255;
				title = "Missing Scalar Value";
				value => GDobj_edit.missing_val;
			    };

			    UIframe ColorFrame {
				y => MissingScalar.y + MissingScalar.height;
				parent => panel;
				width => panel.clientWidth;
				height  = VUICOLOR_EDITOR_HEIGHT;
			    };
			    VUIColorEditor VUIColorEditor {
               Dials{
                  HDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  SDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  VDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
               };
				parent 	=> ColorFrame;
				y = 0;
				width 	=> ColorFrame.clientWidth;
				red	=> GDobj_edit.missing_red;
				green	=> GDobj_edit.missing_green;
				blue	=> GDobj_edit.missing_blue;
				label = "Missing Value Color Editor";
				Title.y => <-.y+10;
				Morph.y => <-.y+10;
			    };
			};
		    };
		    AU.AUpanel_inst Texture {
			UI.option.hconn_list.order = 3;
			IUI {
			    VUIOptionMenuLabel TmapType {
				parent => panel;
				width => panel.clientWidth;
				options	= {"Normal", "VLTM"};
				OPcmdList = {,
				  {active =>
				  in_view.config_flags & GD_VIEW_CONFIG_VLTM}};
				label = "Method";
				selectedItem => GDobj_edit.tmap_method;
			    };
			    VUIOptionMenuLabel TmapSubdiv {
				parent => panel;
				width => panel.clientWidth;
				y => TmapType.y + TmapType.height;
				options = {"Adaptive", "Fixed"};
				label = "Triangle Subdivision";
				active => GDobj_edit.tmap_method;
				selectedItem => GDobj_edit.tri_subdiv_type;
			    };
			    VUIField TmapAval {
				parent => panel;
				width => panel.clientWidth;
				y => TmapSubdiv.y + TmapSubdiv.height;
				label = "Adaptive Value";
				min = 1;
				max = 100;
				decimalPoints = 0;
				active => GDobj_edit.tmap_method &&
						GDobj_edit.tri_subdiv_type == 0;
				value => GDobj_edit.tri_subdiv_aval;
			    };
			    VUIField TmapFval {
				parent => panel;
				width => panel.clientWidth;
				y => TmapAval.y + TmapAval.height;
				label = "Fixed Value";
				min = 1;
				max = 1000;
				decimalPoints = 0;
				active => GDobj_edit.tmap_method &&
						GDobj_edit.tri_subdiv_type == 1;
				value => GDobj_edit.tri_subdiv_fval;
			    };
			};
		    };
		};
	    };
	 };
      };
      AU.AUpanel_inst Uobject_modes {
	 UI.option.hconn_list.order = 3;
	 GDmodes_edit &GDmodes_edit<NEportLevels={2,0}> {
	    int+opt edit_alt_modes;
	 };
	 IUI {
	    VUIOptionMenuLabel EditAltModes {
	       parent   => panel;
	       options = {"Object", "Alternate"};
	       selectedItem => GDmodes_edit.edit_alt_modes;
	       width => panel.clientWidth;
	       label = "Edit";
	    };

	    VUIOptionMenuLabel Point {
	       parent   => panel;
	       options = {"Inherit", "None", "Pixel", "Line Directed",
			 "Arrow Directed", "Cone Directed", "Cross Tangent"};
	       // IAC/MPU: added flags for MPU renderer to active lists
	       //   MPU renderer is the end value in list
	       OPcmdList	= {,,,,
			{active => switch(in_view.renderer+1, 0,1,0,0,0,1)},
			{active => switch(in_view.renderer+1, 0,1,0,0,0,1)},
			{active => switch(in_view.renderer+1, 0,1,0,0,0,1)}};
	       y => EditAltModes.y + EditAltModes.height + 8;
	       width => panel.clientWidth;
	       selectedItem => GDmodes_edit.points;
	       label = "Point Rendering";
	    };
	    VUIOptionMenuLabel Line {
	       parent   => panel;
	       options = {"Inherit", "None", "Regular",
			  "Tube", "Arrow", "Ribbon"};
	       // IAC/MPU: added flags for MPU renderer to active lists
	       //   MPU renderer is the end value in list
	       OPcmdList	= {,,,
			{active => switch(in_view.renderer+1, 0,1,0,0,0,1)},
			{active => switch(in_view.renderer+1, 0,1,0,0,0,1)},
			{active => switch(in_view.renderer+1, 0,1,0,0,0,1)}};
	       y => Point.y + Point.height;
	       width => panel.clientWidth;
	       selectedItem => GDmodes_edit.lines;
	       label = "Line Rendering";
	    };
	    VUIOptionMenuLabel Surface {
	       parent   => panel;
	       options = {"Inherit", "None", "No Lighting", "Flat Shading",
			  "Gouraud Shading", "Background"};
	       y => Line.y + Line.height;
	       width => panel.clientWidth;
	       selectedItem => GDmodes_edit.surf;
	       label = "Surface Rendering";
	    };
	    VUIOptionMenuLabel Volume {
	       parent => panel;
	       width => panel.clientWidth;
	       y => Surface.y + Surface.height;
	       options		= {"Inherit", "None",
				   "BTF texture", "Ray tracer"};
	       // IAC/MPU: added flags for MPU renderer to active lists
	       //   MPU renderer is the end value in list
	       OPcmdList	= {,,
			{active => switch(in_view.renderer+1, 0,1,0,0,0,1)},
#ifdef VX_KIT
			{active => switch(in_view.renderer+1, 1,0,0,0,0,0)}
#else
			{active => switch(in_view.renderer+1, 0,0,0,0,0,0)}
#endif
		};
	       selectedItem	=> GDmodes_edit.volume;
	       label = "Volume Rendering";
	    };
	    VUIOptionMenuLabel Bounds {
	       parent   => panel;
	       options = {"Inherit", "None", "Bounds"};
	       width => panel.clientWidth;
	       y 	=> Volume.y + Volume.height;
	       selectedItem => GDmodes_edit.bounds;
	       label = "Bounds Rendering";
	    };
	    VUIOptionMenuLabel Normals {
	       parent   => panel;
	       options = {"Inherit", "None", "Vertex"};
	       y => Bounds.y + Bounds.height;
	       width => panel.clientWidth;
	       selectedItem => GDmodes_edit.normals;
	       label = "Normals Generation";
	    };
	    VUIToggle OutlineMode {
	       parent   => panel;
	       y 	=> Normals.y + Normals.height;
	       width	=> panel.clientWidth;
	       set	=> !GDmodes_edit.outline;
	       label 	= "Outline";
	    };
	 };
      };
      AU.AUpanel_inst Uobject_props {
	 UI.option.hconn_list.order = 4;
	 GDprops_edit &GDprops_edit<NEportLevels={2,0}> {
	    int+opt edit_alt_props;
	 };

	 IUI {
	    UIoption ObjectOptions[2] = {{label="Object"},
					 {label="Alternate"}};
	    UIoptionMenu EditAltProps {
	       parent   => panel;
	       cmdList => ObjectOptions;
	       selectedItem => GDprops_edit.edit_alt_props;
	       width    => panel.clientWidth / 3;
	       optionLabel = 0;
	    };
	    VUIToggle InheritProps {
	       parent   => panel;
	       label 	= "Inherit";
	       set	=> GDprops_edit.inherit;
	       x	=> panel.clientWidth / 3;
	       y 	=> EditAltProps.y;
	       width	=> panel.clientWidth / 3;
	    };
	    UIbutton ResetProps {
	       parent   => panel;
	       label 	= "Reset";
	       &do	=> GDprops_edit.reset;
	       x	=> panel.clientWidth * 2 / 3;
	       y 	=> InheritProps.y;
	       width	=> panel.clientWidth / 3;
	       height	=> InheritProps.height;
	    };

	    AU.AUoptionMenuStack Type {
		UI.option.hconn_list.offer = "";
		IUI {
		    panel {
			hconn_widget.offer = "";
			visible = 1;
			parent => <-.<-.<-.panel;
			y => ResetProps.y + ResetProps.height + 4;
			height => parent.clientHeight - ResetProps.y;
		    };
		    AU.AUpanel_inst General {
			IUI {
			    UIframe ColorFrame {
				y = 0;
				parent => panel;
				width => panel.clientWidth;
				height  = VUICOLOR_EDITOR_HEIGHT;
			    };

			    float switch_red[] => {GDprops_edit.red, 
						   GDprops_edit.hi1_red,
						   GDprops_edit.hi2_red};
			    float switch_green[] => {GDprops_edit.green, 
						     GDprops_edit.hi1_green,
						     GDprops_edit.hi2_green};
			    float switch_blue[] => {GDprops_edit.blue, 
						    GDprops_edit.hi1_blue,
						    GDprops_edit.hi2_blue};
			    UIoption ColorOptions[3] = {{label="Primary Color"},
						{label="Secondary Color"},
						{label="Tertiary Color"}};
			    UIoptionMenu ColorSelector {
				parent => ColorFrame;
				optionLabel = 1;
				x => (ColorFrame.clientWidth - width) / 2;
				y = 0;
				cmdList => ColorOptions;
				selectedItem = 0;
				label = "Object";
			    };
			    VUIColorEditor ColorEditor {
               Dials{
                  HDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  SDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  VDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
               };
				parent	=> ColorFrame;
				width  => ColorFrame.clientWidth;
				red    => switch_red[ColorSelector.selectedItem];
				green  => switch_green[ColorSelector.selectedItem];
				blue   => switch_blue[ColorSelector.selectedItem];
				label = "Color Editor";
				Title.visible = 0;
			    };
			    VUISlider Jitter_Level {
				parent => panel;
				y => ColorFrame.y + ColorFrame.height;
				width => panel.clientWidth;
				min = -5;
				max = 5;
				decimalPoints = 0;
				title = "Jitter Level";
				value => GDprops_edit.jitter;
			    };
			};
		    };
		    AU.AUpanel_inst PointLine {
			UI.option.label = "Point/Line";
			UI.option.hconn_list.order = 1;
			IUI {
			    VUIOptionMenuLabel LineStyle {
				parent => panel;
				width => panel.clientWidth;
				options = {"Solid", "Dashed", "Dotted",
						 "Dashed-Dotted"};
				label = "Line Style";
				selectedItem => GDprops_edit.line_style;
			    };
			    VUIOptionMenuLabel DrawingMode {
				parent => panel;
				options = {"Copy", "Xor"};
				width => panel.clientWidth;
				label = "Drawing Mode";
				y => LineStyle.y + LineStyle.height;
				selectedItem => GDprops_edit.draw_mode;
			    };
			    VUISlider LineThickness {
				parent => panel;
				y => DrawingMode.y + DrawingMode.height;
				width => panel.clientWidth;
				min = 0;
				max = 25;
				mode = 1;
				title = "Line Thickness";
				value => GDprops_edit.line_width;
			    };
			    VUISlider GlyphSize {
				parent => panel;
				y => LineThickness.y + LineThickness.height;
				width => panel.clientWidth;
				min = 0;
				max = 10;
				title = "Glyph Size";
				value => GDprops_edit.dir_pt_size;
			    };
			    VUISlider Subdivision {
				parent => panel;
				y => GlyphSize.y + GlyphSize.height;
				width => panel.clientWidth;
				min = 0;
				max = 20;
				mode = 1;
				title = "Subdivision";
				value => GDprops_edit.subdiv;
			    };
			    VUIToggle SmoothLines {
				parent => panel;
				y => Subdivision.y + Subdivision.height;
				width => panel.clientWidth;
				label  = "Smooth lines";
				set    => GDprops_edit.line_aa;
			    };
			};
		    };
		    AU.AUpanel_inst Surface {
			UI.option.hconn_list.order = 2;
			IUI {
			    VUISlider Ambient {
				parent => panel;
				width => panel.clientWidth;
				min 	= 0;
				max 	= 1;
				title 	= "Ambient";
				value 	=> GDprops_edit.ambient;
			    };
			    VUISlider Diffuse {
				y => Ambient.y + Ambient.height;
				parent => panel;
				width => panel.clientWidth;
				min 	= 0;
				max 	= 1;
				title 	= "Diffuse";
				value 	=> GDprops_edit.diffuse;
			    };
			    VUISlider Specular {
				y => Diffuse.y + Diffuse.height;
				parent => panel;
				width => panel.clientWidth;
				min 	= 0;
				max 	= 1;
				title 	= "Specular";
				value 	=> GDprops_edit.specular;
			    };
			    VUISlider SpecExp {
				y => Specular.y + Specular.height;
				parent => panel;
				width => panel.clientWidth;
				min 	= 1;
				max 	= 50;
				title 	= "Gloss";
				value 	=> GDprops_edit.spec_exp;
			    };
			    VUISlider Transp {
				y => SpecExp.y + SpecExp.height;
				parent => panel;
				width => panel.clientWidth;
				min 	= 0;
				max 	= 1;
				title 	= "Opacity";
				value 	=> GDprops_edit.trans;
			    };
			    VUISlider Metal {
				y  => Transp.y + Transp.height;
				parent => panel;
				width => panel.clientWidth;
				min 	= 0;
				max 	= 1;
				title 	= "Metal";
				value 	=> GDprops_edit.metal;
			    };
			    VUIOptionMenuLabel CullMode {
				y => Metal.y + Metal.height + 6;
				parent => panel;
				width => panel.clientWidth;
				options = {"None", "Back", "Front",
						"Flip Normals"};
				label = "Culling Mode";
				selectedItem => GDprops_edit.cull;
			    };
			};
		    };
		    AU.AUpanel_inst Volume {
			UI.option.hconn_list.order = 3;
			IUI {
			    VUIOptionMenuLabel Interpolation {
				parent => panel;
				width => panel.clientWidth;
				options = {"Point", "Trilinear"};
				label = "Interpolation";
				selectedItem => GDprops_edit.voxel_interp;
			    };
			    VUIOptionMenuLabel Algorithm {
				y => Interpolation.y + Interpolation.height;
				parent => panel;
				width => panel.clientWidth;
				label = "Ray Algorithm";
				options = {"Direct Composite", "Average Value",
					"Maximum Value", "Distance to Max",
					"SFP" };
				selectedItem => GDprops_edit.ray_algo;
			    };
			    VUIOptionMenuLabel Norm {
				y => Algorithm.y + Algorithm.height;
				parent => panel;
				width => panel.clientWidth;
				options	= {"Global", "View", "Ray"};
				// Only available if Distance to Max is selected
				active => Algorithm.selectedItem == 3;
				label = "Distance Normalize";
				selectedItem => GDprops_edit.ray_norm;
			    };
			    VUIToggle FatRay {
				y => <-.Norm.y + <-.Norm.height;
				parent => panel;
				width => panel.clientWidth;
				label = "Fat Ray";
				set => GDprops_edit.fat_ray;
			    };
			    VUISlider SFPAbsorb {
				y  => FatRay.y + FatRay.height;
				parent => panel;
				width => panel.clientWidth;
				min 	= 0;
				max 	= 1;
				title 	= "SFP Absorption";
				value 	=> GDprops_edit.sfp_absorb;
				active => Algorithm.selectedItem == 4;
			    };
			    VUISlider SFPEmit {
				y  => SFPAbsorb.y + SFPAbsorb.height;
				parent => panel;
				width => panel.clientWidth;
				min 	= 0;
				max 	= 1;
				title 	= "SFP Emission";
				value 	=> GDprops_edit.sfp_emit;
				active => Algorithm.selectedItem == 4;
			    };
			};
		    };
		};
	    };
	 };
      };
      AU.AUpanel_inst Uobject_texture {
	 UI.option.hconn_list.order = 5;
	 GDtexture_edit &GDtexture_edit<NEportLevels={2,0}>;
	 int texture_active => is_valid(GDtexture_edit.texture);
	 UI.option.active => texture_active;
	 IUI {
	    VUIOptionMenuLabel Interpolation<NEx=88,NEy=165> {
	       parent => panel;
	       width => panel.width;
	       options => { "Point", "Bilinear", "Trilinear" };
	       selectedItem => GDtexture_edit.filter;
	       label = "Interpolation";
	       active => texture_active;
	    };
	    VUIOptionMenuLabel Tile<NEx=148,NEy=165> {
	       parent => panel;
	       y => <-.Interpolation.y + <-.Interpolation.height;
	       width => panel.width;
	       options => { "Clamp", "Wrap", "Boundary" };
	       selectedItem => GDtexture_edit.tile;
	       label = "Tile";
	       active => texture_active;
	    };
	    VUIOptionMenuLabel Alpha<NEx=208,NEy=165> {
	       parent       => panel;
	       y            => <-.Tile.y + <-.Tile.height;
	       width        => panel.width;
	       options      => { "Replace", "Modulate", "Decal" };
	       selectedItem => GDtexture_edit.alpha;
	       label        = "Blending";
	       active => texture_active;
	    };
	    VUIOptionMenuLabel Type<NEx=268,NEy=165> {
	       parent       => panel;
	       y            => <-.Alpha.y + <-.Alpha.height;
	       width        => panel.width;
	       height       => <-.Alpha.height;
	       options      => { "Single Level", "Mip-map" };
	       selectedItem =>GDtexture_edit.type;
	       label        = "Type";
	       active => texture_active;
	    };
	 };
      };
   };

   flibrary+global View_Editors<indexed=1> {
      AU.AUpanel_inst Uview_general {
	 UI.option.hconn_list.order = 1;
	 GDview_edit &GDview_edit<NEportLevels={2,0}>;
	 IUI {
	    VUIOptionMenuLabel Renderer {
	       width 	=> panel.clientWidth;
	       parent 	=> panel;
	       // IAC/MPU: added "MPU" to renderer options menu
	       options = {"Software", "OpenGL", "XGL", "PEX", "XIL", "MPU" };
	       label 		= "Renderer";
	       selectedItem 	=> GDview_edit.renderer;
	       OPcmdList = {, {active => Templates.CONFIG.gd_gl_active},
			      {active => Templates.CONFIG.gd_xgl_active},
			      {active => Templates.CONFIG.gd_pex_active},
			      {active => switch(Templates.CONFIG.gd_xil_active+1, 0, in_view.picked_camera.type == 1)},
			      {active => Templates.CONFIG.gd_mpu_active}
		           };
	    };
	    UIbutton Refresh {
	       parent   => panel;
	       y 	=> Renderer.y + Renderer.height;
	       width	=> panel.clientWidth;
	       label 	= "Refresh";
	       &do	=> GDview_edit.refresh;
	    };
	    VUIField Width {
	       parent 		=> panel;
	       y 		=> Refresh.y + Refresh.height;
	       width 		=> panel.clientWidth;
	       label 		= "Width";
	       decimalPoints	= 0;
	       value+nres	=> in_view.render_view.width;
	    };
	    VUIField Height {
	       parent 		=> panel;
	       y		=> Width.y + Width.height;
	       width 		=> panel.clientWidth;
	       label 		= "Height";
	       decimalPoints	= 0;
	       value+nres	=> in_view.render_view.height;
	    };

	    UIframe ColorFrame {
		parent	=> panel;
		y	=> Height.y + Height.height;
		width	=> panel.clientWidth;
		height  = VUICOLOR_EDITOR_HEIGHT;
	    };
	    VUIColorEditor Color {
               Dials{
                  HDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  SDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
                  VDial.Dial.height = VUICOLOR_EDITOR_DIAL_HEIGHT;
               };
		parent	=> ColorFrame;
		width  => ColorFrame.clientWidth;
	       red 	=> GDview_edit.red;
	       green 	=> GDview_edit.green;
	       blue 	=> GDview_edit.blue;
	       label	= "Background Color Editor";
	    };

	    UIframe TimerFrame {
		parent => panel;
		y      => ColorFrame.y + ColorFrame.height;
		width  => panel.clientWidth;
		height => TimerOut.y + TimerOut.height + 6;
	    };
	    UItoggle Timer {
	       parent	=> TimerFrame;
	       set 	=> GDview_edit.timer;
	       label 	= "Timer";
	    };
	    UIlabel TimerOut {
	       parent	=> TimerFrame;
	       x        => Timer.width + 2;
	       y 	=> Timer.y + (Timer.height - TimerOut.height)/2;
	       width 	=> TimerFrame.clientWidth - Timer.width - 4;
	       label	=> switch(is_valid(in_view.frames) + 1,
				    "  ",
				str_format("%3.2f",in_view.fps) + " FPS" +
				" (" + str_format("%d",in_view.frames) + " / " +
				" " + str_format("%3.2f",in_view.seconds) + ")");
	    };
	 };
      };
      AU.AUpanel_inst Uview_options {
	 UI.option.hconn_list.order = 2;
	 GDview_edit &GDview_edit<NEportLevels={2,0}>;
	 IUI {
	    VUIOptionMenuLabel DoubleBuffer {
	       parent		=> panel;
	       options		= {"Single", "Double (MBX)", "Double (Pixmap)"};
#ifdef MSDOS
	       OPcmdList = {{active = 1}, {active = 0}, {active = 1}};
#else
	       OPcmdList = {{active = 1}, {active = 1}, {active = 1}};
#endif
	       selectedItem 	=> GDview_edit.buffer;
	       label 		= "Buffer Mode";
	       width		=> panel.clientWidth;
	    };
	    VUIOptionMenuLabel Aspect {
	       parent		=> panel;
	       options		= {"Biggest", "Smallest"};
	       selectedItem 	=> GDview_edit.aspect;
	       y 		=> DoubleBuffer.y + DoubleBuffer.height;
	       label 		= "Aspect";
	       width		=> panel.clientWidth;
	    };
	    VUIToggle Update {
	       parent 		=> panel;
	       set 		=> GDview_edit.mode;
	       y 		=> Aspect.y + Aspect.height;
	       label 		= "Update Automatically";
	       width 		=> panel.clientWidth;
	    };
	    VUIToggle Accelerate {
	       parent         => panel;
	       set            => GDview_edit.accel;
	       y              => Update.y + Update.height;
	       label          = "Accelerate";
	       width          => panel.clientWidth;
	    };
	    VUIOptionMenuLabel BlendMode {
	       parent		=> panel;
	       options		= {"Alpha", "Saturate"};
	       selectedItem 	=> GDview_edit.blend_mode;
	       y 		=> Accelerate.y + Accelerate.height;
	       label 		= "Blend Mode";
	       width		=> panel.clientWidth;
	    };
	    VUIToggle Pcache {
	       parent		=> panel;
	       y		=> BlendMode.y + BlendMode.height;
	       label		= "Pcache";
	       width		=> panel.clientWidth;
	       // IAC/MPU: added flags for MPU renderer to active lists
	       //   MPU renderer is the end value in list
	       active		=> switch(GDview_edit.renderer+1, 0,0,1,0,0,0);
	       set		=> GDview_edit.pcache;
	    };
	 };
      };
      AU.AUpanel_inst Uview_output {
	 UI.option.hconn_list.order = 3;
	 GDview_edit &GDview_edit<NEportLevels={2,0}>;
	 IUI {
	    VUIToggle OutEnabled {
	       parent		=> panel;
	       set            => GDview_edit.output_enabled;
	       label          = "Enable";
	       width          => panel.clientWidth / 2;
	    };
	    VUIToggle OutFlip {
	       parent		=> panel;
	       // This is only defined in field_outputs
	       // but the template has only an output
	       set+nres       => GDview_edit.view.output.flip;
	       x	      => panel.clientWidth / 2;
	       y	      => <-.OutEnabled.y;
	       label          = "Flip";
	       width          => panel.clientWidth / 2;
	       active	      => GDview_edit.output_enabled;
	    };
	    VUIOptionMenuLabel OutFBType {
	       parent		=> panel;
	       options		= {"None", "ARGB", "RGBA", "ABGR"};
	       selectedItem 	=> GDview_edit.view.output.buffers.fb_type;
	       // IAC/MPU: added flags for MPU renderer to active lists
	       //   MPU renderer is the end value in list
	       OPcmdList	= {,,
			{active => switch(GDview_edit.renderer+1, 0,1,0,0,0,1)},
			{active => switch(GDview_edit.renderer+1, 0,0,1,0,0,0)}};
	       label 		= "Frame Buffer Type";
	       y		=> <-.OutFlip.y + <-.OutFlip.height;
	       width          => panel.clientWidth;
	       active	      => GDview_edit.output_enabled;
	    };
	    VUIOptionMenuLabel OutZBType {
	       parent		=> panel;
	       options		= {"None", "Short", "Float 1 Near", "Float 0 Near", "Int"};
	       selectedItem 	=> GDview_edit.view.output.buffers.zb_type;
	       // IAC/MPU: added flags for MPU renderer to active lists
	       //   MPU renderer is the end value in list
	       OPcmdList	= {,
			{active => switch(GDview_edit.renderer+1, 1,0,0,0,0,0)},
			{active => switch(GDview_edit.renderer+1, 1,1,1,0,0,1)},
			{active => switch(GDview_edit.renderer+1, 0,1,0,0,0,1)},
			{active => switch(GDview_edit.renderer+1, 0,0,1,0,0,0)}};
	       label 		= "Z Buffer Type";
	       y		=> <-.OutFBType.y + <-.OutFBType.height;
	       width          => panel.clientWidth;
	       active	      => GDview_edit.output_enabled;
	    };
	    UIbutton OutClear {
	       parent	      => panel;
	       y	      => <-.OutZBType.y + <-.OutZBType.height;
	       label	      = "Clear";
	       // template only has GDoutput but this is in GDfield_output.
	       do+nres	      => GDview_edit.view.output.clear;
	       width          => panel.clientWidth;
	       active	      => GDview_edit.output_enabled;
	    };
	 };
      };

      AU.AUpanel_inst Uview_create {
	 UI.option.label = "Scene";
	 UI.option.hconn_list.order = 4;
	 GDview_creator GDview_creator {
	    current_view<NEportLevels={3,1}>;
	 };
	 IUI {
	    UIframe Create_Frame {
	       parent => panel;
	       x = 0;
	       y = 0;
	       width => panel.clientWidth;
	       height => Create.y + Create.height + 10;
	    };
	    VUIOptionMenuLabel Camera_Mode {
	       y = 5;
	       width 	=> Create_Frame.clientWidth;
	       parent 	=> Create_Frame;
	       options = {"3D", "2D", "Both"};
	       label 		= "New Camera Type";
	       selectedItem 	=> GDview_creator.camera_mode;
	    };
	    VUIOptionMenuLabel Scene_Mode {
	       width 	=> Create_Frame.clientWidth;
	       parent 	=> Create_Frame;
	       options = {"New objects", "Same objects"};
	       label 		= "Object Mode";
	       y  	=> Camera_Mode.y + Camera_Mode.height;
	       selectedItem 	=> GDview_creator.scene_mode;
	    };
	    UIbutton Create {
	       parent   => Create_Frame;
	       &do	=> GDview_creator.do_create;
	       y 	=> <-.Scene_Mode.y + <-.Scene_Mode.height;
	       width	=> Create_Frame.clientWidth;
	    };
	    UIframe Destroy_Frame {
	       parent => panel;
	       x = 0;
	       y => Create_Frame.y + Create_Frame.height;
	       width => panel.clientWidth;
	       height => Destroy.y + Destroy.height + 10;
	    };
	    UIbutton Destroy {
	       y = 5;
	       parent => Destroy_Frame;
	       width => Destroy_Frame.clientWidth;
	       do => GDview_creator.do_destroy;
	       active => GDview_creator.destroy_active;
	    };
	 };
      };

      AU.AUpanel_inst Ustereo_editor {
	 GDview_edit &GDview_edit<NEportLevels={2,0}>;
	 UI.option.hconn_list.order = 5;
	 IUI {
	    VUIToggle Stereo_Enable {
#ifndef MSDOS
           active = 0;
#endif
	       parent   => panel;
	       width	=> panel.clientWidth;
	       label	= "Stereo Enabled";
	       x	    = 0;
	       y        = 0;
	       set	=> GDview_edit.stereo_enable;
	    };
	    VUIToggle Stereo {
	       parent   => panel;
	       width	=> panel.clientWidth/2;
	       label	= "Stereo On";
	       x	= 0;
	       y        => Stereo_Enable.y + Stereo_Enable.height;
	       set	=> GDview_edit.stereo;
	    };
	    VUIToggle Video {
	       parent   => panel;
	       width	=> panel.clientWidth/2;
	       label	= "Full Screen On";
	       x	=> panel.clientWidth/2;
	       y        => Stereo.y;
	       set	=> GDview_edit.video;
	       active	=> GDview_edit.stereo &&
			   (in_view.config_flags & GD_VIEW_CONFIG_VIDEO_LIVE);
	    };
	    UIlabel VideoOffHint {
	       parent   => panel;
	       width	=> panel.clientWidth;
	       x	=> panel.clientWidth/2;
	       y 	=> Stereo.y + Stereo.height;
	       label    = "  OFF: Shift+MB1";
	       alignment = 0;
	       active	=> Video.active;
	    };
	    VUISlider Balance {
	       parent   => panel;
	       width	=> panel.clientWidth;
	       y 	=> VideoOffHint.y + VideoOffHint.height;
	       min      = -2.0;
	       max      =  2.0;
	       decimalPoints = 2;
	       title	= "Balance";
	       value	=> GDview_edit.stereo_balance;
	       active	=> GDview_edit.stereo;
	    };
	    VUISlider Offset {
	       parent   => panel;
	       width	=> panel.clientWidth;
	       y 	=> Balance.y + Balance.height;
	       min      = -4.0;
	       max      =  4.0;
	       decimalPoints = 2;
	       title	= "Separation Offset";
	       value	=> GDview_edit.stereo_offset;
//             IAC: Make stereo distance available all the time for MPU
//	       active	=> GDview_edit.stereo;
	       active	=> 1;
	    };
	 };
     };
   };

   flibrary+global Dmap_Editors<indexed=1> {
      AU.AUpanel_inst Udmap_editor {
	UI.option.label = "Datamap";
	UI.option.message = "AU_EDIT_DMP_MSG";
	UI.option.hconn_list.order = 6;
        GDobject_templ+IPort2 &cur_obj;
	DatamapTempl &dmap => cur_obj.dmap;
	int          immediate = 0;
	int	     curRange = 0;
	int          curCP = 0;
	int          selectedDmap;

	DatamapEdit dmap_edit {
	    dmap_in => <-.dmap;
	    dmapLibrary => Templates.DATAMAPS;
	    curDmapName => selectedDmap;
	    controlPointModel = 0;
	    controlPointData => IUI.Options.readCmap.cmap;
	    addRange    => IUI.AddRange.do;
	    deleteRange => IUI.DeleteRange.do;
	    curRange+nres => <-.curRange;
	};
	DataRange &curRangePtr => dmap.ranges[curRange];
	DatamapValue &curCPptr => dmap.ranges[curRange].controlPoints[curCP];

	IUI {
	    VUIDmapPanel DmapEcho {
		parent      => panel;
		//width       => panel.clientWidth;
		//height+nres => 1.5 * UIdata.UIfonts[0].lineHeight;
                x = 1;
                y = 2;
		height = 24;
                width => .parent.clientWidth - ( 2 * .x );
		dmap+nres   => <-.<-.dmap;
		DmapObject.dith_tech => cur_obj.dith_tech;
//		showCursor1 = 1;
//		cursorPos1 => curRangePtr.UIMinValue;
//		showCursor2 = 1;
//		cursorPos2 => curRangePtr.UIMaxValue;
	    };
            int DmapEchoBottom => (2 * DmapEcho.y) + DmapEcho.height + 2;
	    UIlabel MinLabel {
		parent => panel;
		y => DmapEchoBottom + 4;
		width  => panel.clientWidth / 12;
		label  =  "Min";
	    };
	    UIfield MinField {
		parent => panel;
		x => MinLabel.width;
		y => DmapEchoBottom;
		width  => panel.clientWidth / 4;
		outputOnly = 1;
		value  => <-.<-.dmap.dataMin;
		format = "scientific";
	    };
	    UIlabel MaxLabel {
		parent => panel;
		x => panel.clientWidth * 2 / 3;
		y => MinLabel.y;
		width  => panel.clientWidth / 12;
		label  =  "Max";
	    };
	    UIfield MaxField {
		parent => panel;
		x => MaxLabel.x + MaxLabel.width;
		y => DmapEchoBottom;
		width  => panel.clientWidth / 4;
		outputOnly = 1;
		value  => <-.<-.dmap.dataMax;
		format = "scientific";
	    };

	    UIoption ModelOptions[2] = {{label="    HSV    "},
					{label="    RGB    "}};
	    UIoptionMenu ModelMenu {
		parent  => panel;
		x => panel.clientWidth / 3;
		y => DmapEchoBottom;
		width   => panel.clientWidth / 3;
		cmdList => ModelOptions;
		optionLabel = 0;
		selectedItem+nres => <-.<-.dmap.currentColorModel;
	    };
	    VUIToggle Immediate {
		parent => panel;
		y => ModelMenu.y + ModelMenu.height;
		width   => panel.clientWidth / 3;
		set    => <-.<-.immediate;
		label  =  "Immediate";
	    };
	    UIbutton AddRange {
		parent => panel;
		x => panel.clientWidth / 3;
		y => Immediate.y;
		width   => panel.clientWidth / 3;
		height  => Immediate.height;
		label = "Add Range";
		active+nres => (<-.<-.curRange == (<-.<-.dmap.numRanges - 1)) &&
				<-.<-.dmap.editable;
	    };
	    UIbutton DeleteRange {
		parent => panel;
		x => panel.clientWidth * 2 / 3;
		y => Immediate.y;
		width   => panel.clientWidth / 3;
		height  => Immediate.height;
		label = "Delete Range";
		active+nres => (<-.<-.dmap.numRanges > 1) &&
				<-.<-.dmap.editable;
	    };
	    VUISlider CurrentRange {
		parent  => panel;
		y       => DeleteRange.y + DeleteRange.height;
		width   => panel.clientWidth;
		min     =  0;
		max+nres=> <-.<-.dmap.numRanges - 1;
		title   =  "Current Range";
		immediate => <-.<-.immediate;
		mode    =  1;
		value   => <-.<-.curRange;
	    };
	    VUISlider CurrentCP {
		parent  => panel;
		y       => CurrentRange.y + CurrentRange.height;
		width   => panel.clientWidth;
		min     =  0;
		max+nres=> <-.<-.curRangePtr.numControlPoints - 1;
		title   =  "Current Control Point";
		immediate => <-.<-.immediate;
		mode    =  1;
		value   => <-.<-.curCP;
	    };
	    AU.AUoptionMenuStack Options {
                UI.option.hconn_list.offer = "";
		DatamapTempl &dmap => <-.<-.dmap;
		int Immediate => <-.<-.immediate;
		int curCP     => <-.<-.curCP;
		DataRange &curRangePtr => <-.<-.curRangePtr;
		DatamapValue &curCPptr => <-.<-.curCPptr;
		string cmapName;
		macro readCmap {
		    file map_file {
			name+nres => cmapName;
		    };
		    int off => file_skip_lines(map_file,0,1);
		    float cmap[256][4] =>
				file_array_ascii(map_file, off, 4, {1,1,1,1});
		};
		/* int selectedDmap => <-.<-.selectedDmap; */
		DatamapEdit &dmap_edit => <-.<-.dmap_edit;

                IUI {
                    panel {
                        hconn_widget.offer = "";
                        visible = 1;
                        parent => <-.<-.<-.panel;
                        y => CurrentCP.y + CurrentCP.height + 4;
                        height => parent.clientHeight - .y;
                    };
                    AU.AUpanel_inst Edit_Color {
			UI.option.hconn_list.order = 1;
                        IUI {
			    VUIOptionMenuLabel ColorRB {
				parent        => panel;
				width         => panel.clientWidth;
				options       => { "Linear", "Constant" };
				selectedItem  => curRangePtr.selectColorRange;
				label         =  "Color Range Mapping";
			    };
			    VUISlider v2Slider {
				parent    => panel;
				y         => ColorRB.y + ColorRB.height;
				width     => panel.clientWidth;
				immediate => Immediate;
				title     => switch(ColorRB.selectedItem+1,
				switch(curCP+1,
				  str_format("%s Min", dmap.colorModel.v2Label),
				  str_format("%s Max", dmap.colorModel.v2Label)),
					dmap.colorModel.v2Label);
				value+nres => curCPptr.v2;
			    };
			    v2Slider v3Slider {
				y         => v2Slider.y + v2Slider.height;
				title     => switch(ColorRB.selectedItem+1,
				switch(curCP+1,
				  str_format("%s Min", dmap.colorModel.v3Label),
				  str_format("%s Max", dmap.colorModel.v3Label)),
					dmap.colorModel.v3Label);
				value+nres => curCPptr.v3;
			    };
			    v2Slider v4Slider {
				y         => v3Slider.y + v3Slider.height;
				title     => switch(ColorRB.selectedItem+1,
				switch(curCP+1,
				  str_format("%s Min", dmap.colorModel.v4Label),
				  str_format("%s Max", dmap.colorModel.v4Label)),
					dmap.colorModel.v4Label);
				value+nres => curCPptr.v4;
			    };
			};
		    };
                    AU.AUpanel_inst Edit_Alpha {
			UI.option.hconn_list.order = 2;
                        IUI {
			    VUIOptionMenuLabel AlphaRB {
				parent        => panel;
				width         => panel.clientWidth;
				options       => { "Linear", "Constant" };
				selectedItem  =>
					curRangePtr.selectAlphaRange;
				label         =  "Alpha Range Mapping";
			    };
			    VUISlider v1Slider {
				parent    => panel;
				y         => AlphaRB.y + AlphaRB.height;
				width     => panel.clientWidth;
				immediate => Immediate;
				title     => switch(AlphaRB.selectedItem+1,
				switch(curCP+1,
				  str_format("%s Min", dmap.colorModel.v1Label),
				  str_format("%s Max", dmap.colorModel.v1Label)),
					dmap.colorModel.v1Label);
				value+nres => curCPptr.v1;
			    };
			};
		    };
                    AU.AUpanel_inst Edit_Range_Data {
			UI.option.label = "Edit Range/Data";
			UI.option.hconn_list.order = 3;
                        IUI {
			    UIlabel EditLabel {
				parent => panel;
				x = 4;
				y = 5;
				width  => panel.clientWidth / 6;
				label  =  "Edit";
			    };
			    UIoption EditOptions[2] = {{label="Range"},
						       {label="Data"}};
			    UIoptionMenu EditMenu {
				parent  => panel;
				x => EditLabel.x + EditLabel.width + 4;
				y = 0;
				width   => panel.clientWidth / 3;
				cmdList => EditOptions;
				selectedItem = 0;
				optionLabel = 0;
			    };
			    VUIToggle SubToggle {
				parent    => panel;
				x	  => panel.clientWidth / 2;
				width     => panel.clientWidth / 2;
				set+nres  => curRangePtr.selectValues;
				label     =  "Sub-range Values";
				active    => (EditMenu.selectedItem == 0);
			    };
			    VUISlider RangeSize {
				parent    => panel;
				y         => SubToggle.y + SubToggle.height+10;
				width     => panel.clientWidth;
				min       =  2;
				max       =  65536;
				title     =  "Range Size";
				immediate => Immediate;
				mode      =  1;
				value+nres => curRangePtr.size;
				active     => curRangePtr.sizeActive;
			    };
//			    VUIRange RangeValues {
			    VUIRangeTypein RangeValues {
		                SliderFrame.height =
					VUIRANGE_SLIDERFRAME_HEIGHT;
				parent    => panel;
				y         => RangeSize.y + RangeSize.height;
				width     => panel.clientWidth;
				title     =  "Sub-range";
				label1	  =  "Range Min";
				label2	  =  "Range Max";
				min+nres  => curRangePtr.DataMinValue;
				max+nres  => curRangePtr.DataMaxValue;
				value1+nres => curRangePtr.UIMinValue;
				value2+nres => curRangePtr.UIMaxValue;
				active    => SubToggle.set;
				visible    => EditMenu.selectedItem == 0;
				immediate => Immediate;
				constrain = 1;
//				format = "scientific";
				format = 2;
			    };
//			    VUIRange DataValues {
			    VUIRangeTypein DataValues {
		                SliderFrame.height =
					VUIRANGE_SLIDERFRAME_HEIGHT;
				parent    => panel;
				y         => RangeSize.y + RangeSize.height;
				width     => panel.clientWidth;
				title     =  "Data Value";
				label1	  =  "Data Min";
				label2	  =  "Data Max";
				min+nres  => dmap.dataMin;
				max+nres  => dmap.dataMax;
				value1+nres => curRangePtr.DataMinValue;
				value2+nres => curRangePtr.DataMaxValue;
				active1   => ((curRange != 0) && (curRangePtr.minActive));
				active2   => ((curRange != (dmap.numRanges - 1)) && (curRangePtr.maxActive));
				visible   => EditMenu.selectedItem == 1;
				immediate => Immediate;
				constrain = 1;
//				format = "scientific";
				format = 2;
			    };
			};
		    };
                    AU.AUpanel_inst InputOutput {
			UI.option.label = "Input";
			UI.option.hconn_list.order = 4;
                        IUI {
			    VUIOptionMenuLabel FileOP {
				parent  => panel;
				width   => panel.clientWidth;
				options => {"Read Datamap", "Read AVS5 Colormap"};
				label     =  "Action";
				OPcmdList =  {,,{active = 0}};
				selectedItem = 0;
			    };
			    UIlabel Name {
				parent => panel;
				y => FileOP.y + FileOP.height;
				width         => panel.clientWidth;
				alignment = 0;
				label => switch(FileOP.selectedItem+1,
				"Datamap Name", "File Name", "File Name");
			    };
			    UItext Text {
				parent => panel;
				y => Name.y + Name.height + 5;
				width => panel.clientWidth - Visible.width;
				text => switch(FileOP.selectedItem+1,
					dmap_edit.dmapNames[selectedDmap],
					cmapName, cmapName);
				showLastPosition = 1;
			    };
			    UIbutton Visible {
				parent => panel;
				x => panel.clientWidth - .width;
				y => Text.y;
				width = 75;
				height => Text.height;
				label = "Browse...";
			    };
			    UIselectionDialog Dmap_browser {
				GMOD.copy_on_change copy_on_change {
				    trigger => switch(FileOP.selectedItem+1,
						1,0,0) && <-.<-.Visible.do;
				    input => switch(FileOP.selectedItem+1,
						1,0,0) && <-.<-.Visible.do;
				    output => <-.visible;
				};
				title = "Read Datamap Name";
				strings => dmap_edit.dmapNames;
				selectedItem => selectedDmap;
			    };
			    UIfileSB Cmap_browser {
				GMOD.copy_on_change copy_on_change {
				    trigger => switch(FileOP.selectedItem+1,
						0,1,1) && <-.<-.Visible.do;
				    input => switch(FileOP.selectedItem+1,
						0,1,1) && <-.<-.Visible.do;
				    output => <-.visible;
				};
				title => switch(FileOP.selectedItem+1,
					"Read Datamap", "Read AVS5 Colormap");
				searchPattern => switch(FileOP.selectedItem+1,
					"$XP_PATH<0>/data/datamap/*",
					"/usr/avs/data/colormap/*.cmap", "");
				filename => cmapName;
			    };
			};
		    };
		};
	    };
	 };
      };
   };

#ifdef AG_KIT
   flibrary+global Graph_Editors<indexed=1> {
      AU.AUpanel_inst Ugraph_properties {
	 AGGraph+IPort2 &edit_graphs[];
	 int current_graph_index;
	 AGGraph &current_graph => edit_graphs[current_graph_index];
	 AGGraphWorld &current_world;
	 UI.option.hconn_list.order = 7;

	 IUI {
	    VUISlider CurrentGraph {
	       parent => panel;
	       value  => <-.<-.current_graph_index;
	       title  =  "Current Graph";
	       width  => panel.clientWidth;
	       min    =  0;
	       max    => max_array({array_size(edit_graphs) - 1,0});
	       mode   =  1;
	       // for some reason when min==max the slider misbehaves
	       active => max > min;
	    };
	    VUISlider DrawPriority {
	       parent => panel;
	       y      => <-.CurrentGraph.y + <-.CurrentGraph.height;
	       value  => current_graph.priority;
	       title  = "Drawing Priority";
	       width  => panel.clientWidth;
	       min    = 0;
	       max    = 10;
	       decimalPoints = 0;
	    };

	    GMOD.parent_value parent_value {
	       child_value => current_graph.graphType;
	       parent_value = "curve";
	    };
	    VUIList GraphType {
	       parent => panel;
	       x = 0;
	       y => DrawPriority.y + DrawPriority.height;
	       width => panel.clientWidth;
	       height = 140;
	       label = "Graph Type";
	       selectedText => parent_value.child_value;
	       strings => { "curve", "bars", "barlines", "scatter", "area", 
		 "staircase", "stairarea"};
	    };

	    VUIText Color {
	       x = 0;
	       y => <-.GraphType.y + <-.GraphType.height;
	       text => current_graph.color;
	       label = "Color +";
	       width => panel.clientWidth;
	       parent => panel;
	    };
	    VUIText NegativeColor {
	       x = 0;
	       y => <-.Color.y + <-.Color.height;
	       text => current_graph.negativeColor;
	       label = "Color -";
	       width => panel.clientWidth;
	       parent => panel;
	       //area and stairarea (enums in ag.v) don't do this...
	       active => (current_graph.graphType != 2) &&
			 (current_graph.graphType != 7);
	    };
	    VUIField ReferenceValue {
	       x = 0;
	       y => <-.NegativeColor.y + <-.NegativeColor.height;
	       width => panel.clientWidth;
	       parent => panel;
	       label = "Baseline";
	       value => current_graph.referenceValue;
	    };
	    VUIText LegendText {
	       x = 0;
	       y => <-.ReferenceValue.y + <-.ReferenceValue.height;
	       text => current_graph.legendText;
	       label = "Legend";
	       width => panel.clientWidth;
	       parent => panel;
	    };
	    VUIToggle UniformScaling {
	       x      = 0;
	       y => LegendText.y + LegendText.height;
	       width => panel.clientWidth/2;
	       parent => panel;
	       label  = "Uniform Scale";
	       set    => current_world.uniformScaling;
	    };
	    VUIToggle NiceLimits {
	       x      => panel.clientWidth/2;
	       y      => UniformScaling.y;
	       width => panel.clientWidth/2;
	       parent => panel;
	       label  = "Nice Limits";
	       set    => current_world.niceLimits;
	    };
	 };
      };
      AU.AUpanel_inst Ugraph_style {
	 AGGraph &current_graph;

	 IUI {
// this should really be named:
//	    VUIList LineStyle {
// but for compatibility with 3.0 we're stuck with it mis-named "GraphType"
	    VUIList GraphType {
	       parent<NEportLevels={2,0}> => panel;
	       x = 0;
	       y = 0;
	       width => panel.clientWidth;
	       height = 120;
	       label = "Line Style";
	       selectedText => current_graph.lineStyle;
	       strings<NEportLevels={3,0}> => {
		  "solid", "dashed", "dotted", "dasheddotted"
	       };
	    };

	    VUISliderSigned LineWidth {
	       parent => panel;
//	       y => LineStyle.y + LineStyle.height;
	       y => GraphType.y + GraphType.height;
	       width => panel.clientWidth;
	       value => current_graph.lineWidth;
	       title = "Line Width";
	       min = 0.0;
	       max = 5.0;
	    };
	    VUISliderSigned BarWidth {
	       parent => panel;
	       y => <-.LineWidth.y + <-.LineWidth.height;
	       width => panel.clientWidth;
	       value => current_graph.barWidth;
	       title = "Bar Width";
	       min = 0.0;
	       max = 1.0;
	    };
	    VUISliderSigned BarFrameWidth {
	       parent => panel;
	       y => <-.BarWidth.y + <-.BarWidth.height;
	       width => panel.clientWidth;
	       value => current_graph.barFrameWidth;
	       title = "Bar Frame Width";
	       min = 0.0;
	       max = 2.0;
	    };
	    VUISlider BarOffset {
	       parent => panel;
	       y => <-.BarFrameWidth.y + <-.BarFrameWidth.height;
	       width => panel.clientWidth;
	       value => current_graph.barOffset;
	       title = "Bar Offset";
	       min = 0.0;
	       max = 1.0;
	    };
	    VUISlider ShiftPosition {
	       parent => panel;
	       y => <-.BarOffset.y + <-.BarOffset.height;
	       width => panel.clientWidth;
	       value => current_graph.shiftPosition;
	       title = "Shift Position";
	       min = 0.0;
	       max = 1.0;
	    };
	 };
      };
      AU.AUpanel_inst Ugraph_title {
	 AGText &current_text;

	 IUI {
	    VUIToggle ShowTitle {
	       parent  => panel;
	       x       = 0;
	       y       = 0;
	       width => panel.clientWidth;
	       label   = "Show Title";
	       set     => current_text.visibility;
	    };
	    VUIText TitleText {
	       parent => panel;
	       x = 0;
	       y => <-.ShowTitle.y + <-.ShowTitle.height;
	       width => panel.clientWidth;
	       text => current_text.text[0];
	       label = "Title";
	       active => ShowTitle.set;
	    };
	    VUIText FillColor {
	       parent => panel;
	       x = 0;
	       y => <-.TitleText.y + <-.TitleText.height;
	       width => panel.clientWidth;
	       text => current_text.fillColor;
	       label = "Fill Color";
	       active => ShowTitle.set;
	    };
	    VUISliderSigned TitleHeight {
	       y => FillColor.y + FillColor.height;
	       width => panel.clientWidth;
	       parent => panel;
	       value => current_text.height;
	       title = "Title Height";
	       min = 1.0;
	       max = 15;
	       active => ShowTitle.set;
	    };
	    VUISliderSigned FrameWidth {
	       y => TitleHeight.y + TitleHeight.height;
	       width => panel.clientWidth;
	       parent => panel;
	       value => current_text.frameWidth;
	       title = "Frame Width";
	       min = 0;
	       max = 1.0;
	       active => ShowTitle.set;
	    };

	    VUIList FontSelector {
	       parent<NEportLevels={2,0}> => panel;
	       x = 0;
	       y => FrameWidth.y + FrameWidth.height;
	       width => panel.clientWidth;
	       height = 120;
	       label = "Title Font";
	       selectedText => current_text.font;
	       strings<NEportLevels={3,0}> => {
		  "courier", "helvetica", "helvetica-bold", "roman-complex",
		  "roman-duplex", "roman-italic", "roman-simplex",
		  "script-complex", "script-simplex", "times-bold",
		  "times-italic", "times-roman", "vector-simplex",
		  "cartographics", "gothic-english", "gothic-german", 
		  "gothic-italian"
	       };
	       active => ShowTitle.set;
	    };
	 };
      };
      AU.AUpanel_inst Ugraph_x_axis {
	 AGXAxis &current_axis;
	 AGGraphWorld &current_world;

	 IUI {
	    VUIToggle Visible {
	       x      = 0;
	       y      = 0;
	       width => panel.clientWidth;
	       parent => panel;
	       label  = "Show X Axis";
	       set    => current_axis.visibility;
	    };
	    VUIText Text {
	       x = 0;
	       y => <-.Visible.y + <-.Visible.height;
	       width => panel.clientWidth;
	       parent => panel;
	       label = "Text";
	       text => current_axis.text;
	       active => Visible.set;
	    };
	    VUIField Min {
	       x = 0;
	       y => <-.Text.y + <-.Text.height;
	       width => panel.clientWidth;
	       label = "Min";
	       parent => panel;
	       value => current_world.limitsX[0];
	       active => Visible.set;
	    };
	    VUIField Max {
	       x = 0;
	       y => <-.Min.y + <-.Min.height;
	       width => panel.clientWidth;
	       parent => panel;
	       label = "Max";
	       value => current_world.limitsX[1];
	       active => Visible.set;
	    };
	    VUIField Step {
	       x = 0;
	       y => <-.Max.y + <-.Max.height;
	       width => panel.clientWidth;
	       parent => panel;
	       label = "Step";
	       value => current_world.majorStepX;
	       active => Visible.set;
	    };
	    VUISliderSigned LabelHeight {
	       y => <-.Step.y + <-.Step.height;
	       width => panel.clientWidth;
	       parent => panel;
	       value => current_axis.labelHeight;
	       title = "Label Height";
	       min = 0.0;
	       max = 5;
	       active => Visible.set;
	    };
	    VUISliderSigned TextHeight {
	       y => <-.LabelHeight.y + <-.LabelHeight.height;
	       width => panel.clientWidth;
	       parent => panel;
	       value => current_axis.textHeight;
	       title = "Text Height";
	       min = 0.0;
	       max = 10;
	       active => Visible.set;
	    };

	    VUIList ScaleSelector {
	       parent<NEportLevels={2,0}> => panel;
	       x = 0;
	       y => TextHeight.y + TextHeight.height;
	       width => panel.clientWidth;
	       height+nres => ((UIdata.UIfonts[0].lineHeight * 5) + 10);
	       label = "Axis Scale";
	       selectedText => current_world.scaleTypeX;
	       strings<NEportLevels={3,0}> => {
		"linear", "log10", "power"};
	       active => Visible.set;
	    };
	 };
      };
      Ugraph_x_axis Ugraph_y_axis {
	 AGYAxis &current_axis;
	 IUI {
	    Visible {
	       label = "Show Y Axis";
	    };
	    Min {
	       value => current_world.limitsY[0];
	    };
	    Max {
	       value => current_world.limitsY[1];
	    };
	    Step {
	       value => current_world.majorStepY;
	    };
	    ScaleSelector {
	       selectedText => current_world.scaleTypeY;
	    };
	 };
      };
      AU.AUpanel_inst Ugraph_x_ticklines {
	 AGXTicklines &current_tick;

	 IUI {
	    VUIToggle Visible {
	       parent => panel;
	       width => panel.clientWidth;
	       set => current_tick.visibility;
	       label = "Show Ticklines";
	    };
	    VUISlider DrawPriority {
	       parent => panel;
	       y => <-.Visible.y + <-.Visible.height;
	       width => panel.clientWidth;
	       value => current_tick.priority;
	       title = "Drawing Priority";
	       min = 0;
	       max = 10;
	       mode = 1;
	       active => Visible.set;
	    };
            AU.AUoptionMenuStack Type {
                UI.option.hconn_list.offer = "";
                IUI {
                    panel {
                        hconn_widget.offer = "";
                        visible = 1;
                        parent => <-.<-.<-.panel;
                        y => DrawPriority.y + DrawPriority.height + 4;
                        height => parent.clientHeight - DrawPriority.y;
                    };
                    AU.AUpanel_inst Major {
			UI.option.hconn_list.order = 1;
                        IUI {
                            VUIText MajorColor {
                                parent => panel;
                                width => panel.clientWidth;
                                label = "Color";
                                text => current_tick.majorTickColor;
                                active => Visible.set;
                            };
                            VUISliderSigned MajorWidth {
                                y => MajorColor.y + MajorColor.height;
                                width => panel.clientWidth;
                                parent => panel;
                                title = "Width";
                                value => current_tick.majorTickWidth;
                                min = 0;
                                max = 2.0;
                                active => Visible.set;
                            };
                            VUIList MajorStyle {
                                parent => panel;
                                y => <-.MajorWidth.y + <-.MajorWidth.height;
                                width => panel.clientWidth;
                                label = "Style";
                                selectedText => current_tick.majorTickLineStyle;
                                strings<NEportLevels={3,0}> =>
                                  {"solid", "dashed", "dotted", "dasheddotted"};
                                active => Visible.set;
                            };
                        };
                    };
                    AU.AUpanel_inst Minor {
			UI.option.hconn_list.order = 2;
                        IUI {
                            VUISlider MinorCount {
                                parent => panel;
                                width => panel.clientWidth;
                                value => current_tick.minorTickCount;
                                title = "Tick Count";
                                min = 0.0;
                                max = 10.0;
                                mode = 1;
                                active => Visible.set;
                            };
                            VUIText MinorColor {
                                text => current_tick.minorTickColor;
                                label = "Color";
                                width => panel.clientWidth;
                                parent => panel;
                                x = 0;
                                y => MinorCount.y + MinorCount.height;
                                active => Visible.set;
                            };
                            VUISliderSigned MinorWidth {
                                parent => panel;
                                y => MinorColor.y + MinorColor.height;
                                width => panel.clientWidth;
                                value => current_tick.minorTickWidth;
                                title = "Width";
                                min = 0.0;
                                max = 2.0;
                                active => Visible.set;
                            };
                            VUIList MinorStyle {
                                parent => panel;
                                y => <-.MinorWidth.y + <-.MinorWidth.height;
                                width => panel.clientWidth;
                                label = "Style";
                                selectedText => current_tick.minorTickLineStyle;
                                strings<NEportLevels={3,0}> =>
                                  {"solid", "dashed", "dotted", "dasheddotted"};
                                active => Visible.set;
                            };
                        };
                    };
                };
            };
	 };
      };
      Ugraph_x_ticklines Ugraph_y_ticklines {
	 AGYTicklines &current_tick;
      };
      AU.AUpanel_inst Ugraph_legend {
	 AGAnyLegend &current_legend;

	 IUI {
	    VUIToggle Visible {
	       x      = 0;
	       y      = 0;
	       width => panel.clientWidth;
	       parent => panel;
	       label  = "Show Legend";
	       set    => current_legend.visibility;
	    };
	    VUIText TitleText {
	       x 	= 0;
	       y 	=> <-.Visible.y + <-.Visible.height;
	       width => panel.clientWidth;
	       parent => panel;
	       text 	=> current_legend.title;
	       label 	= "Title";
	       active => Visible.set;
	    };
	    VUISliderSigned TitleHeight {
	       y 	=> TitleText.y + TitleText.height;
	       width  => panel.clientWidth;
	       parent => panel;
	       title 	= "Title Height";
	       value 	=> current_legend.titleHeight;
	       min 	= 1;
	       max 	= 10;
	       active => Visible.set;
	    };
	    VUISliderSigned LabelHeight {
	       parent => panel;
	       value 	=> current_legend.labelHeight;
	       title 	= "Label Height";
	       y 	=> TitleHeight.y + TitleHeight.height;
	       width  => panel.clientWidth;
	       min 	= 0;
	       max 	= 10;
	       active => Visible.set;
	    };
	    VUIField Columns {
	       x 	= 0;
	       y 	=> <-.LabelHeight.y + <-.LabelHeight.height;
	       width => panel.clientWidth;
	       label 	= "Columns";
	       parent => panel;
	       value 	=> current_legend.numColumns;
	       // Contour legends don't have this one
	       active => Visible.set && is_valid(current_legend.numColumns);
	    };
	    VUIField XOrigin {
	       x 	= 0;
	       y 	=> <-.Columns.y + <-.Columns.height;
	       width => panel.clientWidth;
	       label 	= "X Origin";
	       parent => panel;
	       value 	=> current_legend.geometry[0];
	       active => Visible.set;
	    };
	    VUIField YOrigin {
	       x 	= 0;
	       y 	=> <-.XOrigin.y + <-.XOrigin.height;
	       width => panel.clientWidth;
	       label 	= "Y Origin";
	       parent => panel;
	       value 	=> current_legend.geometry[1];
	       active => Visible.set;
	    };
	 };
      };
      AU.AUpanel_inst Ugraph_contour {
	 AGContour+IPort2 &current_contour;

	 IUI {
	    VUIList ContourType {
	       parent => panel;
	       x = 0;
	       y = 0;
	       width => panel.clientWidth;
	       height = 100;
	       label = "Contour Type";
	       selectedText => current_contour.contourType;
	       strings => { "filledcontours", "isolines", 
			    "datamappedisolines"};
	    };
	    VUIField NumClasses {
	       parent => panel;
	       x = 0;
	       y => ContourType.y + ContourType.height;
	       label = "Num Classes";
	       value => current_contour.numClasses;
	       mode = 1;
	       active => !is_valid(current_contour.classValues);
	    };
	    VUIToggle DataMinMax {
	       parent => panel;
	       x = 0;
	       y => NumClasses.y + NumClasses.height;
	       width => parent.clientWidth;
	       label = "Use data min/max";
	       active => NumClasses.active;
	    };
	    GMOD.inherit_value DoInvalidMin {
	       value => current_contour.minClass;
	       set => DataMinMax.set;
	       default_value = 0.0;
	    };
	    GMOD.inherit_value DoInvalidMax {
	       value => current_contour.maxClass;
	       set => DataMinMax.set;
	       default_value = 100;
	    };
	    VUIField MinClass {
	       parent => panel;
	       x = 0;
	       y => DataMinMax.y + DataMinMax.height;
	       label = "Class Minimum";
	       width => parent.clientWidth;
	       value => current_contour.minClass;
//	       active => is_valid(current_contour.minClass) && 
//			 NumClasses.active;
	       active => NumClasses.active;
	    };
	    VUIField MaxClass {
	       parent => panel;
	       x = 0;
	       width => parent.clientWidth;
	       y => MinClass.y + MinClass.height;
	       label = "Class Maximum";
	       value => current_contour.maxClass;
//	       active => is_valid(current_contour.maxClass) &&
//			 NumClasses.active;
	       active => NumClasses.active;
	    };

#ifndef KNIGHT
///////////////////////////////////////////////////////////////////////////////
// Modifications to Ugraph_contour macro to extend UI functionality.
// Agip/Krig3 project
//
// Author: D.Knight AVS (UK) Ltd
// Last updated: 15th August 2000
//
// Note: the widgets IsoLineLabelFrequency and IsoLabelColor were moved from
// above into the AUpanels below, for reasons of space and logical grouping.
///////////////////////////////////////////////////////////////////////////////
        AU.AUoptionMenuStack Isoline {
			UI.option.hconn_list.offer = "";
				IUI {
					panel {
						hconn_widget.offer = "";
						visible = 1;
						parent => <-.<-.<-.panel;
						y => MaxClass.y + MaxClass.height + 4;
						height => parent.clientHeight - y;
					};

					AU.AUpanel_inst Style {
						UI.option.hconn_list.order = 1;
						IUI {

							VUISlider MajorIsoFrequency {
							   parent => panel;
							   width  => panel.clientWidth;
							   y 	= 0;
							   value 	=> current_contour.majorIsoLineFrequency;
							   title 	= "Isoline Frequency";
							   min 	= 1;
							   max 	= 10;
							   decimalPoints = 0;
							};
							// isoLineLabelDistance
							VUIField IsoLineLabelDistance {
							   parent => panel;
							   x = 0;
							   y => MajorIsoFrequency.height + MajorIsoFrequency.y;
							   width => parent.clientWidth;
							   label = "Label Distance";
							   value => current_contour.isoLineLabelDistance;
							};

							// isoLineLabelAngleInterval
							VUIField IsoLineLabelAngleInterval {
							   parent => panel;
							   x = 0;
							   width => parent.clientWidth;
							   y => IsoLineLabelDistance.y + IsoLineLabelDistance.height;
							   label = "Label Angle Interval";
							  // value => current_contour.isoLineLabelAngleInterval;
							   UIfield {
								width => (((<-.width - <-.UIlabel.width) - 12) / 2);
								value => current_contour.isoLineLabelAngleInterval[0];
							   };
							   UIfield field1 {
								 x => (((<-.UIlabel.x + <-.UIlabel.width) + UIfield.width) + 2);
								 width => <-.UIfield.width;
								 y => <-.UIfield.y;
								value => current_contour.isoLineLabelAngleInterval[1];
								 parent => <-.UIframe;
								 height => UIfield.height;
							   };
							};


						};
					};
					AU.AUpanel_inst Labels {
						UI.option.hconn_list.order = 2;
						IUI {

							VUIText IsoLabelColor {
							   parent => panel;
							   width => panel.clientWidth;
							   x = 0;
							   y = 0;
							   text => current_contour.isoLineLabelColor;
							   label = "Label Color";
							};

							// isoLineLabelHeight
							VUIField IsoLineLabelHeight {
							   parent => panel;
							   x = 0;
							   width => parent.clientWidth;
							   y => IsoLabelColor.y + IsoLabelColor.height;
							   label = "Label Height";
							   value => current_contour.isoLineLabelHeight;
							};

							// isoLineLabelDecimals
							VUIField IsoLineLabelDecimals {
							   parent => panel;
							   x = 0;
							   width => parent.clientWidth;
							   y => IsoLineLabelHeight.y + IsoLineLabelHeight.height;
							   label = "Label Decimals";
							   value => current_contour.isoLineLabelDecimals;
							   mode = 1;
							};

							// isoLineLabelFont
							VUIOptionMenuLabel IsoLineLabelFont {
							   parent<NEportLevels={2,0}> => panel;
							   x = 0;
							   y => IsoLineLabelDecimals.y + IsoLineLabelDecimals.height;
							   label = "Label Font";
							   GMOD.copy_on_change copy_on_change {
								trigger => selectedItem;
								input => options[selectedItem];
								output => current_contour.isoLineLabelFont;
							   };
							   options<NEportLevels={3,0}> => {
							  "courier", "helvetica", "helvetica-bold", "roman-complex",
							  "roman-duplex", "roman-italic", "roman-simplex",
							  "script-complex", "script-simplex", "times-bold",
							  "times-italic", "times-roman", "vector-simplex",
							  "cartographics", "gothic-english", "gothic-german", 
							  "gothic-italian"
							   };
							   width => parent.clientWidth;
							};

						};
					};
					AU.AUpanel_inst Major {
						UI.option.hconn_list.order = 3;
						IUI {

							// majorIsoLineColor
							VUIText MajorIsoColor {
							   parent => panel;
							   width => panel.clientWidth;
							   x = 0;
							   y = 0;
							   text => current_contour.majorIsoLineColor;
							   label = "Line Color";
							};


							// majorIsoLineWidth
							VUIField MajorIsoLineWidth {
							   parent => panel;
							   x = 0;
							   width => parent.clientWidth;
							   y => MajorIsoColor.y + MajorIsoColor.height;
							   label = "Line Width";
							   value => current_contour.majorIsoLineWidth;
							};

							// majorIsoLineReference
							VUIField MajorIsoLineReference {
							   parent => panel;
							   x = 0;
							   width => parent.clientWidth;
							   y => MajorIsoLineWidth.y + MajorIsoLineWidth.height;
							   label = "Line Reference";
							   value => current_contour.majorIsoLineReference;
							};

							// majorIsoLineStyle
							AGLineStyle AGLineStyle;
							VUIOptionMenuLabel MajorIsoLineStyle {
							   parent<NEportLevels={2,0}> => panel;
							   x = 0;
							   y => MajorIsoLineReference.y + MajorIsoLineReference.height;
							   width => panel.clientWidth;
							   label = "Line Style";
							   GMOD.copy_on_change copy_on_change {
								trigger => selectedItem;
								input => options[selectedItem];
								output => current_contour.majorIsoLineStyle;
							   };
							   options<NEportLevels={3,0}> => AGLineStyle.choices;
							   width => parent.clientWidth;
							};

						};
					};
					AU.AUpanel_inst Minor {
						UI.option.hconn_list.order = 4;
						IUI {

							// minorIsoLineColor
							VUIText MinorIsoColor {
							   parent => panel;
							   width => panel.clientWidth;
							   x = 0;
							   y = 0;
							   text => current_contour.minorIsoLineColor;
							   label = "Line Color";
							};


							// minorIsoLineWidth
							VUIField MinorIsoLineWidth {
							   parent => panel;
							   x = 0;
							   width => parent.clientWidth;
							   y => MinorIsoColor.y + MinorIsoColor.height;
							   label = "Line Width";
							   value => current_contour.minorIsoLineWidth;
							};

							// minorIsoLineStyle
							AGLineStyle AGLineStyle;
							VUIOptionMenuLabel MinorIsoLineStyle {
							   parent<NEportLevels={2,0}> => panel;
							   x = 0;
							   y => MinorIsoLineWidth.y + MinorIsoLineWidth.height;
							   width => panel.clientWidth;
							   label = "Line Style";
							   GMOD.copy_on_change copy_on_change {
								trigger => selectedItem;
								input => options[selectedItem];
								output => current_contour.minorIsoLineStyle;
							   };
								options <NEportLevels={3,0}> =>AGLineStyle.choices;
							};
						};
					};
				};
			};
///////////////////////////////////////////////////////////////////////////////
// End of D. Knight modifications
///////////////////////////////////////////////////////////////////////////////
#else
	    VUIText IsoLabelColor {
	       parent => panel;
	       width => panel.clientWidth;
	       x = 0;
	       y => MaxClass.y + MaxClass.height;
	       text => current_contour.isoLineLabelColor;
	       label = "Iso Label Color";
	    };
	    VUISlider MajorIsoFrequency {
	       parent => panel;
	       width  => panel.clientWidth;
	       y 	=> IsoLabelColor.y + IsoLabelColor.height;
	       value 	=> current_contour.majorIsoLineFrequency;
	       title 	= "Iso Label Frequency";
	       min 	= 1;
	       max 	= 10;
	       decimalPoints = 0;
	    };
#endif
	 };
      };
      AU.AUpanel_inst Ugraph_viewport {
	 AGGraphViewport+IPort2 &current_viewport;
//	 AGViewport+IPort2 &current_viewport;

	 IUI {
	    VUIText BackgroundColor {
	       parent => panel;
	       width  => panel.clientWidth;
	       x = 0;
	       y = 0;
	       text => current_viewport.fillColor;
	       label = "Color";
	    };

	    VUIRange GeomWidth {
                SliderFrame.height = VUIRANGE_SLIDERFRAME_HEIGHT;
		parent	=> panel;
		width	=> panel.clientWidth;
		y	= BackgroundColor.y + BackgroundColor.height;
		value1	=> current_viewport.geometry[0];
		value2	=> current_viewport.geometry[2];
		min	= -10;
		max	= 10;
		title	= "Width";
		constrain =  1;
		immediate =  0;
		label1	= "Lower";
		label2	= "Upper";
	    };
	    VUIRange GeomHeight {
                SliderFrame.height = VUIRANGE_SLIDERFRAME_HEIGHT;
		parent	=> panel;
		width	=> panel.clientWidth;
		y	=> GeomWidth.y + GeomWidth.height;
		value1	=> current_viewport.geometry[1];
		value2	=> current_viewport.geometry[3];
		min	= -10;
		max	= 10;
		title	= "Height";
		constrain =  1;
		immediate =  0;
		label1	= "Lower";
		label2	= "Upper";
	    };
	 };
      };
   };
#endif
   flibrary+global UI_Editors<indexed=1> {
      AU.AUoptionMenuStack+Mcamera_editor Ucamera_editor {
	 UI.option {
	    label = "&Camera";
	    message = "AU_EDIT_CAM_MSG";
	    hconn_list.order = 4;
	 };
	 IUI.optionList.label = "Camera";
	 Uview_link &in_view<NEportLevels={2,1}>;

	 IUI {
	    Uoptions_editor General {
	       &GDcamera_edit => <-.<-.GDcamera_edit;
	    };
	    Ulens_editor Lens {
	       GDcamera_edit => <-.<-.GDcamera_edit;
	    };
	    Utripod_editor Tripod {
	       GDcamera_edit => <-.<-.GDcamera_edit;
	    };
	    Uclipping_editor Clipping_Planes {
	       GDcamera_edit => <-.<-.GDcamera_edit;
	    };
	    Udepth_cue_editor Depth_Cueing {
	       GDcamera_edit => <-.<-.GDcamera_edit;
	    };
	 };

	 GMOD.parse_v AutoNormSwitcher {
	    trigger => AutoNormalize.set;
	    /* Can't use GD defines in runtime */
	    v_commands = "GDcamera_edit.auto_norm =>
				switch(AutoNormalize.set+1, 3, 0);";
	    on_inst = 0;
	    relative => <-;
	 };
	 AU.AUoptionTool AutoNormalize {
	    tool_order = 14;
	    pixmap.filename => switch((GDcamera_edit.auto_norm==0)+1,
				      "$XP_PATH<0>/v/vizxp/icons/cnorm1.x",
				      "$XP_PATH<0>/v/vizxp/icons/cnorm0.x");
	    message = "AU_TIP_ANRM_MSG";
	 };

	 AU.AUoptionTool Perspective {
	    tool_order = 15;
	    tool_space = 1;
	    set => GDcamera_edit.perspec;
	    pixmap.filename => switch(set+1,
				      "$XP_PATH<0>/v/vizxp/icons/nopersp.x",
				      "$XP_PATH<0>/v/vizxp/icons/persp.x");
	    message = "AU_TIP_PROJ_MSG";
	 };
      };
      AU.AUoptionMenuStack+Mlights_editor Ulight_editor {
	 UI {
	    option {
	       label = "&Light";
	       message = "AU_EDIT_LGT_MSG";
	       hconn_list.order = 3;
	    };
	 };

	 IUI {
	    optionList.label = "Light";
	    Ulight_type General {
	       &GDlight_edit => <-.<-.GDlight_edit;
	       &GDlinfo_edit => <-.<-.GDlinfo_edit;
	    };
	    Ulight_attr Attributes {
	       &GDlight_edit => <-.<-.GDlight_edit;
	    };
	    Ulight_ambient Ambient {
	       &GDlinfo_edit => <-.<-.GDlinfo_edit;
	    };
	 };

	 GMOD.parse_v LightTypeSwitcher {
	    trigger => LightType.set;
	    /* Can't use GD defines in runtime */
	    v_commands = "GDlight_edit.type =>
				switch(LightType.set+1, 0, 3);";
	    on_inst = 0;
	    relative => <-;
	 };
	 AU.AUoptionTool LightType {
	    tool_order = 16;
	    tool_space = 1;
	    pixmap.filename => switch(set+1,
				      "$XP_PATH<0>/v/vizxp/icons/dlight0.x",
				      "$XP_PATH<0>/v/vizxp/icons/dlight1.x");
	    message = "AU_TIP_LTYP_MSG";
	 };
      };
      AU.AUoptionMenuStack+Mobject_editor Uobject_editor {
	 UI.option {
	    label = "&Object";
	    message = "AU_EDIT_OBJ_MSG";
	    hconn_list.order = 5;
	 };
	 IUI.optionList.label = "Object";

	 IUI {
	    Uobject_general General {
	       GDobj_edit => <-.<-.GDobj_edit;
	       GDprops_edit => <-.<-.GDprops_edit;
	       GDmodes_edit => <-.<-.GDmodes_edit;
	       cur_obj => <-.<-.cur_obj;
	       UI.option.hconn_list.order = 1;
	    };
	    Uobject_field_conv Field_Conversion {
	       GDobj_edit => <-.<-.GDobj_edit;
	       UI.option.hconn_list.order = 2;
	    };
	    Uobject_modes Modes {
	       GDmodes_edit => <-.<-.GDmodes_edit;
	       UI.option.hconn_list.order = 3;
	    };
	    Uobject_props Properties {
	       GDprops_edit => <-.<-.GDprops_edit;
	       UI.option.hconn_list.order = 4;
	    };
            Uobject_texture Texture {
	       GDtexture_edit => <-.<-.GDtexture_edit;
	       UI.option.hconn_list.order = 5;
	    };
	 };

	 AU.AUoptionTool AlternateObj {
	    tool_order = 12;
	    set => GDobj_edit.use_altobj;
	    pixmap.filename => switch(set+1,
				      "$XP_PATH<0>/v/vizxp/icons/bbox0.x",
				      "$XP_PATH<0>/v/vizxp/icons/bbox1.x");
	    message = "AU_TIP_ALTO_MSG";
	 };

	 GMOD.parse_v JitterSwitcher {
	    trigger => Jitter.set;
	    v_commands = "GDprops_edit.jitter => switch(Jitter.set+1, 0, 2);";
	    on_inst = 0;
	    relative => <-;
	 };
	 AU.AUoptionTool Jitter {
	    tool_order = 13;
	    tool_space = 1;
	    pixmap.filename => switch(set+1,
				      "$XP_PATH<0>/v/vizxp/icons/jitter0.x",
				      "$XP_PATH<0>/v/vizxp/icons/jitter1.x");
	    message = "AU_TIP_JITR_MSG";
	 };
      };
      AU.AUoptionMenuStack+Mtrack_editor Utrack_editor {
	 UI.option {
	    label = "&Transform";
	    message = "AU_EDIT_XFM_MSG";
	    hconn_list.order = 2;
	 };
	 IUI.optionList.label = "Transform";

	 Uview_link &in_view<NEportLevels={2,1}>;
	 macro TransformSelect {
	    AU.AUoptionTool Transform_Object {
	       tool_order = 1;
	       pixmap.filename => switch(set+1,
	       "$XP_PATH<0>/v/vizxp/icons/tgeomo.x",
				         "$XP_PATH<0>/v/vizxp/icons/tgeom.x");
	       hconn_list.offer = "";
	       message = "AU_EDIT_XFO_MSG";
	    };
	    AU.AUoptionTool Transform_Camera {
	       tool_order = 2;
	       pixmap.filename => switch(set+1,"$XP_PATH<0>/v/vizxp/icons/tcamerao.x",
				    "$XP_PATH<0>/v/vizxp/icons/tcamera.x");
	       hconn_list.offer = "";
	       message = "AU_EDIT_XCM_MSG";
	    };
	    AU.AUoptionTool Transform_Light {
	       tool_order = 3;
	       pixmap.filename => switch(set+1,"$XP_PATH<0>/v/vizxp/icons/tlighto.x",
				    "$XP_PATH<0>/v/vizxp/icons/tlight.x");
	       hconn_list.offer = "";
	       message = "AU_EDIT_XLT_MSG";
	    };
	    AU.AUoptionToolList TransformSelect<export_subs=1> {
	       cmdList => {Transform_Object, Transform_Camera, Transform_Light};
	    };
	 };
	 macro TrackSelect {
	    string transform => 
	       switch(TransformSelect.TransformSelect.selectedItem+1, 
		      "object","camera","light");
	    AU.AUoptionTool Rotate {
	       tool_order = 4;
	       pixmap.filename => switch(set+1,"$XP_PATH<0>/v/vizxp/icons/rotateo.x",
				    "$XP_PATH<0>/v/vizxp/icons/rotate.x");
	       message = "AU_EDIT_ROT_MSG";
	       hconn_list.offer = "";
	    };
	    AU.AUoptionTool Scale {
	       tool_order = 5;
	       pixmap.filename => switch(set+1,"$XP_PATH<0>/v/vizxp/icons/scaleo.x",
				    "$XP_PATH<0>/v/vizxp/icons/scale.x");
	       message = "AU_EDIT_SCL_MSG";
	       hconn_list.offer = "";
	    };
	    AU.AUoptionTool Translate {
	       tool_order = 6;
	       pixmap.filename => switch(set+1,"$XP_PATH<0>/v/vizxp/icons/transxyo.x",
				    "$XP_PATH<0>/v/vizxp/icons/transxy.x");
	       message = "AU_EDIT_XYT_MSG";
	       hconn_list.offer = "";

	       // makes the default mode translate for 2d cameras
	       set => (in_view.picked_camera.type == 1);
	    };
	    AU.AUoptionTool Z_Translate {
	       tool_order = 7;
	       pixmap.filename => switch(set+1,"$XP_PATH<0>/v/vizxp/icons/transzo.x",
				    "$XP_PATH<0>/v/vizxp/icons/transz.x");
	       message = "AU_EDIT_ZT_MSG";
	       hconn_list.offer = "";
	    };
	    AU.AUoptionToolList TrackSelect<export_subs=1> {
	       cmdList => {Rotate, Scale, Translate, Z_Translate};
	    };
	 };
	 macro RNC {
	    AU.AUcmdTool Reset<export=2,export_subs=1> {
	       tool_order = 8;
	       pixmap.filename = "$XP_PATH<0>/v/vizxp/icons/reset.x";
	       message = "AU_EDIT_RST_MSG";
	    };
	    AU.AUcmdTool Normalize<export=2,export_subs=1> {
	       tool_order = 9;
	       pixmap.filename = "$XP_PATH<0>/v/vizxp/icons/normal.x";
	       message = "AU_EDIT_NRM_MSG";
	    };
	    AU.AUcmdTool Center<export=2,export_subs=1> {
	       tool_order = 10;
	       pixmap.filename = "$XP_PATH<0>/v/vizxp/icons/center.x";
	       message = "AU_EDIT_CTR_MSG";
	    };
	    AU.AUcmdTool RNC<export=2,export_subs=1> {
	       label = "Reset/Normalize/Center";
	       tool_order = 11;
	       tool_space = 1;
	       pixmap.filename = "$XP_PATH<0>/v/vizxp/icons/rnc.x";
	       message = "AU_EDIT_RNC_MSG";
	    };
	 };
	 UImouseEvents &TrackInter => in_view.mouse_events;
	 int track_mode => TrackSelect.TrackSelect.selectedItem;
	 int mode_table[4][3] => {
				/* button1 */  /* button 2 */ /* button 3*/
  	   /* no modifier */  {  track_mode,  	    0,    	  -1},
	    /* shift      */  {    -1, 		    1, 		  -1},
	    /* ctrl       */  {    -1,              2,    	  -1},
	    /* alt       */   {    -1,             -1,    	  -1}};
	 GDtrack_edit {
	    x => TrackInter.x;
	    y => TrackInter.y;
	    event => TrackInter.state;
	    time => TrackInter.time;
	    mode => mode_table[TrackInter.modType][TrackInter.buttonType];
	    trans_mode => TransformSelect.TransformSelect.selectedItem;
	    reset => RNC.Reset.do;
	    normalize => RNC.Normalize.do;
	    center => RNC.Center.do;
	 };
	 GMOD.parse_v Do_RNC {
	    trigger => RNC.RNC.do;
	    v_commands = 
	       "GDtrack_edit { reset = 1; normalize = 1; center = 1; }; ";
	    on_inst = 0;
	    relative => <-;
	 };
	 GDxform_edit GDxform_edit<export_all=2,export=2> {
	    shell_vis => IUI.panel.visible;
	    xform => switch(GDtrack_edit.trans_mode+1,
			    cur_obj.xform, in_view.picked_camera.xform,
			    in_view.light_info.lights[in_view.cur_light].xform);

	    // to avoid NULLs when uninit'd (5954)
	    x_rot   = 0.0; y_rot   = 0.0; z_rot   = 0.0;
	    x_trans = 0.0; y_trans = 0.0; z_trans = 0.0;
	    x_cent  = 0.0; y_cent  = 0.0; z_cent  = 0.0;
	    scale = 1.0;
	 };
	 /* Start of DataViewer code here */
	 IUI {
	    AU.AUpanel_inst Interactor_Behavior {
	       UI.option.hconn_list.order = 1;
	       IUI {
		  VUIToggle GlobalSpace {
		     width => panel.clientWidth;
		     parent => panel;
		     label = "Local Space";
		     set => GDtrack_edit.space;
		  };
		  VUIToggle NonUniformScale {
		     width => panel.clientWidth;
		     parent => panel;
		     label = "Non-Uniform Scaling";
		     y => GlobalSpace.y + GlobalSpace.height;
		     set => GDtrack_edit.scale_mode;
		  };

		  VUIOptionMenuLabel RotateMode {
		     parent => panel;
		     options = {"Arbitrary", "XY", "Z"};
		     x = 0;
		     y => NonUniformScale.y + NonUniformScale.height;
		     width => panel.clientWidth;
		     selectedItem => GDtrack_edit.rot_mode;
		     label = "Rotate Mode";
		  };

		  VUIOptionMenuLabel XYTranslateMode {
		     parent => panel;
		     options = {"Arbitrary", "X", "Y", "XY"};
		     x = 0;
		     y => <-.RotateMode.y + <-.RotateMode.height;
		     width => panel.clientWidth;
		     selectedItem => GDtrack_edit.xlate_mode;
		     label = "XY Translate Mode";
		  };
	       };
	    };
	    AU.AUpanel_inst Transform {
	       UI.option.hconn_list.order = 2;
	       IUI {
		  GMOD.parse_v_relative_no_inst ParseFront {
		     v_commands = "GDxform_edit.xform.xlate = {0,0,0};GDxform_edit.xform.mat = {1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};GDtrack_edit.normalize=1;GDtrack_edit.center=1;";
		     trigger    => <-.Front.do;
		     relative   => <-;
		  };
		  GMOD.parse_v_relative_no_inst ParseTop {
		     v_commands = "GDxform_edit.xform.xlate = {0,0,0};GDxform_edit.xform.mat = {1,0,0,0, 0,0,1,0, 0,-1,0,0, 0,0,0,1};GDtrack_edit.normalize=1;GDtrack_edit.center=1;";
		     trigger    => <-.Top.do;
		     relative   => <-;
		  };
		  GMOD.parse_v_relative_no_inst ParseSide {
		     v_commands = "GDxform_edit.xform.xlate = {0,0,0};GDxform_edit.xform.mat = {0,0,-1,0, 0,1,0,0, 1,0,0,0, 0,0,0,1};GDtrack_edit.normalize=1;GDtrack_edit.center=1;";
		     trigger    => <-.Side.do;
		     relative   => <-;
		  };
		  UIbutton Front {
		     parent => panel;
		     x      = 0;
		     y      = 0;
		     width  => panel.clientWidth / 3;
		     label  = "Front";
		  };
		  UIbutton Top {
		     parent => panel;
		     x      => panel.clientWidth / 3;
		     y      => Front.y;
		     width  => panel.clientWidth / 3;
		     label  = "Top";
		  };
		  UIbutton Side {
		     parent => panel;
		     x      => panel.clientWidth *2 / 3;
		     y      => Front.y;
		     width  => panel.clientWidth / 3;
		     label  = "Side";
		  };
		  VUIToggle Absolute {
		     parent => panel;
		     y      => Side.y+Side.height;
		     width  => panel.clientWidth / 2;
		     label  = "Absolute";
		     set    => GDxform_edit.absolute;
		  };
		  UIbutton Reset {
		     parent => panel;
		     width  => panel.clientWidth / 2;
		     height => Absolute.height;
		     x => panel.clientWidth / 2;
		     y => Absolute.y;
		     width => panel.clientWidth / 2;
		     do => GDxform_edit.reset;
		  };

		  VUIDial Xrotate {
		     parent => panel;
		     x      => 0*( panel.clientWidth / 3 );
		     y      => Absolute.y+Absolute.height + 6;
		     width  => panel.clientWidth / 3;
		     height => .width+80;
		     title  = "X Angle";
		     min    = -180.0;
		     max    =  180.0;
		     value  => GDxform_edit.x_rot;
#ifdef MSDOS
		     Dial.height => <-.height - VUIDIAL_FIELD_HEIGHT - 4;
		     Field.height => VUIDIAL_FIELD_HEIGHT;
#endif
		  };
		  VUIDial Yrotate {
		     parent => panel;
		     x      => 1*( panel.clientWidth / 3 );
		     y      => Xrotate.y;
		     width  => panel.clientWidth / 3;
		     height => Xrotate.height;
		     title  = "Y Angle";
		     min    = -180.0;
		     max    =  180.0;
		     value  => GDxform_edit.y_rot;
#ifdef MSDOS
		     Dial.height => <-.height - VUIDIAL_FIELD_HEIGHT - 4;
		     Field.height => VUIDIAL_FIELD_HEIGHT;
#endif
		  };
		  VUIDial Zrotate {
		     parent => panel;
		     x      => 2*( panel.clientWidth / 3 );
		     y      => Xrotate.y;
		     width  => panel.clientWidth / 3;
		     height => Xrotate.height;
		     title  = "Z Angle";
		     min    = -180.0;
		     max    =  180.0;
		     value  => GDxform_edit.z_rot;
#ifdef MSDOS
		     Dial.height => <-.height - VUIDIAL_FIELD_HEIGHT - 4;
		     Field.height => VUIDIAL_FIELD_HEIGHT;
#endif
		  };

		  UIframe XYZFrame {
		     parent => panel;
		     y      => Zrotate.y + Zrotate.height + 4;
		     width  => panel.clientWidth;
		     height => ZAbsCenter.y + ZAbsCenter.height + 10;
		  };

		  UIlabel Xheader {
		     parent => XYZFrame;
		     x      => XYZFrame.clientWidth / 5;
		     y      = 0;
		     width  => XYZFrame.clientWidth / 3;
		     label = "X";
		  };
		  UIlabel Yheader {
		     parent => XYZFrame;
		     x      => Xheader.x + XYZFrame.clientWidth / 4;
		     y      => Xheader.y;
		     width  => XYZFrame.clientWidth / 3;
		     label = "Y";
		  };
		  UIlabel Zheader {
		     parent => XYZFrame;
		     x      => Yheader.x + XYZFrame.clientWidth / 4;
		     y      => Yheader.y;
		     width  => XYZFrame.clientWidth / 3;
		     label = "Z";
		  };

		  UIlabel TransLabel {
		     parent => XYZFrame;
		     x      = 3;
		     y      => Xheader.y + Xheader.height;
		     width  => XYZFrame.clientWidth / 4;
		     label  = "Translate";
		  };
		  UIfield Xtrans {
		     parent => XYZFrame;
		     x      => XYZFrame.clientWidth / 4;
		     y      => TransLabel.y - 2;
		     width  => XYZFrame.clientWidth / 4;
		     value  => GDxform_edit.x_trans;
		  };
		  UIfield Ytrans {
		     parent => XYZFrame;
		     x      => Xtrans.x + Xtrans.width;
		     y      => Xtrans.y;
		     width  => Xtrans.width;
		     value  => GDxform_edit.y_trans;
		  };
		  UIfield Ztrans {
		     parent => XYZFrame;
		     x      => Ytrans.x + Ytrans.width;
		     y      => Ytrans.y;
		     width  => Ytrans.width;
		     value  => GDxform_edit.z_trans;
		  };

		  UIlabel CenterLabel {
		     parent => XYZFrame;
		     x      = 3;
		     y      => Ztrans.y + Ztrans.height + 4;
		     width  => XYZFrame.clientWidth / 4;
		     label  = "Center";
		  };
		  UIfield XCenter {
		     parent => XYZFrame;
		     x      => XYZFrame.clientWidth / 4;
		     y      => CenterLabel.y - 2;
		     width  => XYZFrame.clientWidth / 4;
		     value  => GDxform_edit.x_cent;
		  };
		  UIfield YCenter {
		     parent => XYZFrame;
		     x      => XCenter.x + XCenter.width;
		     y      => XCenter.y;
		     width  => XCenter.width;
		     value  => GDxform_edit.y_cent;
		  };
		  UIfield ZCenter {
		     parent => XYZFrame;
		     x      => YCenter.x + YCenter.width;
		     y      => YCenter.y;
		     width  => YCenter.width;
		     value  => GDxform_edit.z_cent;
		  };

		  UIframe AbsFrame {
		     parent => XYZFrame;
		     y      => ZCenter.y + ZCenter.height + 4;
		     width  => XYZFrame.clientWidth;
		     height => ZAbsCenter.y + ZAbsCenter.height - 4;
		  };

		  UIlabel AbsLabel {
		     parent => XYZFrame;
		     x      = 3;
		     y      => ZCenter.y + ZCenter.height + 6;
		     width  => AbsFrame.clientWidth;
		     label  = "Absolute Values";
		  };

		  UIlabel AbsRotLabel {
		     parent => XYZFrame;
		     x      = 3;
		     y      => AbsLabel.y + AbsLabel.height + 4;
		     width  => AbsFrame.clientWidth / 4;
		     label  = "Rotate";
		  };
		  UIlabel XAbsRot {
		     parent => XYZFrame;
		     x      => AbsFrame.clientWidth / 4;
		     y      => AbsRotLabel.y - 2;
		     width  => AbsFrame.clientWidth / 4;
		     label  => str_format("%f", GDxform_edit.abs_x_rot);
		  };
		  UIlabel YAbsRot {
		     parent => XYZFrame;
		     x      => XAbsRot.x + XAbsRot.width;
		     y      => XAbsRot.y;
		     width  => XAbsRot.width;
		     label  => str_format("%f", GDxform_edit.abs_y_rot);
		  };
		  UIlabel ZAbsRot {
		     parent => XYZFrame;
		     x      => YAbsRot.x + YAbsRot.width;
		     y      => YAbsRot.y;
		     width  => YAbsRot.width;
		     label  => str_format("%f", GDxform_edit.abs_z_rot);
		  };

		  UIlabel AbsTransLabel {
		     parent => XYZFrame;
		     x      = 3;
		     y      => ZAbsRot.y + ZAbsRot.height;
		     width  => AbsFrame.clientWidth / 4;
		     label  = "Translate";
		  };
		  UIlabel XAbsTrans {
		     parent => XYZFrame;
		     x      => AbsFrame.clientWidth / 4;
		     y      => AbsTransLabel.y - 2;
		     width  => AbsFrame.clientWidth / 4;
		     label  => str_format("%f", GDxform_edit.abs_x_trans);
		  };
		  UIlabel YAbsTrans {
		     parent => XYZFrame;
		     x      => XAbsTrans.x + XAbsTrans.width;
		     y      => XAbsTrans.y;
		     width  => XAbsTrans.width;
		     label  => str_format("%f", GDxform_edit.abs_y_trans);
		  };
		  UIlabel ZAbsTrans {
		     parent => XYZFrame;
		     x      => YAbsTrans.x + YAbsTrans.width;
		     y      => YAbsTrans.y;
		     width  => YAbsTrans.width;
		     label  => str_format("%f", GDxform_edit.abs_z_trans);
		  };

		  UIlabel AbsCenterLabel {
		     parent => XYZFrame;
		     x      = 3;
		     y      => ZAbsTrans.y + ZAbsTrans.height;
		     width  => AbsFrame.clientWidth / 4;
		     label  = "Center";
		  };
		  UIlabel XAbsCenter {
		     parent => XYZFrame;
		     x      => AbsFrame.clientWidth / 4;
		     y      => AbsCenterLabel.y - 2;
		     width  => AbsFrame.clientWidth / 4;
		     label  => str_format("%f", GDxform_edit.abs_x_cent);
		  };
		  UIlabel YAbsCenter {
		     parent => XYZFrame;
		     x      => XAbsCenter.x + XAbsCenter.width;
		     y      => XAbsCenter.y;
		     width  => XAbsCenter.width;
		     label  => str_format("%f", GDxform_edit.abs_y_cent);
		  };
		  UIlabel ZAbsCenter {
		     parent => XYZFrame;
		     x      => YAbsCenter.x + YAbsCenter.width;
		     y      => YAbsCenter.y;
		     width  => YAbsCenter.width;
		     label  => str_format("%f", GDxform_edit.abs_z_cent);
		  };

		  UIframe ScaleFrame {
		     parent => panel;
		     y      => XYZFrame.y + XYZFrame.height + 4;
		     width  => panel.clientWidth;
		     height => AbsScale.y + AbsScale.height + 10;
		  };
		  UIlabel ScaleLabel {
		     parent => ScaleFrame;
		     x      = 3;
		     width  => ScaleFrame.clientWidth / 6;
		     label  = "Scale";
		  };
		  UIfield Scale {
		     parent => ScaleFrame;
		     x      => ScaleFrame.clientWidth / 3;
		     y      => ScaleLabel.y - 2;
		     width  => ScaleFrame.clientWidth / 3;
		     value  => GDxform_edit.scale;
		  };
		  UIlabel AbsScale {
		     parent => ScaleFrame;
		     x      => Scale.x + ScaleFrame.clientWidth / 3;
		     y      => ScaleLabel.y;
		     width  => ScaleFrame.clientWidth / 3;
		     label  => str_format("%f", GDxform_edit.abs_scale);
		  };
	       };
	    };
	 };
      };
      AU.AUoptionMenuStack+Mview_editor Uview_editor {
	 Uview_link &in_view<NEportLevels={2,1}>;
	 UI.option {
	    label = "&View";
	    message = "AU_EDIT_VU_MSG";
	    hconn_list.order = 1;
	 };
	 IUI.optionList.label = "View";

	 GMOD.parse_v HwSwSwitcher {
	    trigger => HW_SW.set;
            // one-way connection to the default renderer
	    v_commands = "GDview_edit.renderer =
			switch(HW_SW.set+1,
				Templates.CONFIG.gd_default_renderer + 0, 0);";
	    on_inst = 0;
	    relative => <-;
	 };
	 AU.AUoptionTool HW_SW {
	    tool_order = 17;
	    pixmap.filename => switch((GDview_edit.renderer==0)+1,
				      "$XP_PATH<0>/v/vizxp/icons/hw.x",
				      "$XP_PATH<0>/v/vizxp/icons/sw.x");
	    message = "AU_TIP_RNDR_MSG";
	 };

	 // This panel installs itself in the "info" panel (if any)
	 AU.AUpanel InfoPanel {
	    UI {
	       panel.visible = 1;
	       panel.hconn_widget {
		  offer = "widget (info)";
		  accept = "";
		  default_func = ;
	       };
	       option.hconn_list.offer = "";
	    };
	    UIframe CurCameraFrame {
	       parent => UI.panel;
	       y = 0;
	       x = 0;
	       width = 30;
	       height => UI.panel.clientHeight;
	       shadowType = 2;
	    };
	    UIlabel CurCameraLabel {
	       parent => CurCameraFrame;
	       x = 0; y = 0;
	       width => CurCameraFrame.clientWidth;
	       height => CurCameraFrame.clientHeight;
	       string labels[2] = {"3D", "2D"};
	       label => labels[in_view.picked_camera.type];
	       alignment = 1;
	    };
	    UIframe CurObjFrame {
	       parent => UI.panel;
	       x => CurCameraFrame.width + 5;
	       y = 0;
	       width => UI.panel.clientWidth - CurCameraFrame.width - 5;
	       height => UI.panel.clientHeight;
	       shadowType = 2;
	    };
	    UIlabel CurObjLabel {
	       parent => CurObjFrame;
	       x = 0; y = 0;
	       width => CurObjFrame.clientWidth - RaiseCurObj.width - 7;
	       height => CurObjFrame.clientHeight;
	       label => GDobj_sel.curobj_name;
	       alignment = 0;
	    };
	    UIbutton RaiseCurObj {
	       label = "Select Object...";
	       parent => CurObjFrame;
	       x => CurObjFrame.width - width - 7;
	       y = 2;
	       height => CurObjFrame.clientHeight - 4;
	       width = 120;
	    };
	    UIselectionBox curobj_sel {
	       title = "Object Selector";
	       visible+IPort2 => RaiseCurObj.do;
	       strings+IPort2 => GDobj_sel.strings;
	       &text+IPort2 => GDobj_sel.curobj_name;
	    };
	 };
	 IUI {
	    Uview_general General<export=2> {
	       GDview_edit => <-.<-.GDview_edit;
	    };
	    Uview_options Options<export=2> {
	       GDview_edit => <-.<-.GDview_edit;
	    };
	    Uview_output Output<export=2> {
	       GDview_edit => <-.<-.GDview_edit;
	    };
	    Uview_create Create<export=2> {
	       GDview_creator {
		  current_view => <-.<-.<-.in_view;
	       };
	    };
	    Ustereo_editor Stereo {
	       GDview_edit => <-.<-.GDview_edit;
	    };
	 };
      };

#ifdef AG_KIT
      AU.AUoptionMenuStack Ugraph_editor {
	 GDobject_templ+IPort2 &cur_obj;
	 UI.option {
	    label = "&Graph";
	    message = "AU_EDIT_GRF_MSG";
	    hconn_list.order = 7;
	 };
	 IUI.optionList.label = "Graph";
	 int list_changed;

	 AGEditorShell AGEditorShell {
	    cur_obj => <-.cur_obj;
	    //
	    // Connect up to the currently selected object and filter
	    // the list of things to be edited from there on down...
	    //
	    cur_ag_obj => cur_obj.pick_info.pick_data[0].field_id;
//	    cur_ag_obj => cur_obj.input;
	    trigger => IUI.panel.visible | list_changed;
	 };

	 UI.option.active => AGEditorShell.ag_active;

	 IUI {
	    Ugraph_title Title<export=2> {
	       current_text => AGEditorShell.texts[0];
	       UI.option.active => is_valid(current_text);
	       UI.option.hconn_list.order = 1;
	    };
	    Ugraph_properties Properties<export=2> {
	       edit_graphs => <-.<-.AGEditorShell.graphs;
	       current_graph_index = 0;
	       current_world => AGEditorShell.worlds[0];
	       UI.option.active => is_valid(current_graph);
	       UI.option.hconn_list.order = 2;
	    };
	    Ugraph_style Style<export=2> {
	       current_graph => Properties.current_graph;
	       UI.option.active => is_valid(current_graph);
	       UI.option.hconn_list.order = 3;
	    };
	    Ugraph_x_axis X_Axis<export=2> {
	       current_axis => AGEditorShell.xaxes[0];
	       current_world => AGEditorShell.worlds[0];
	       UI.option.active => is_valid(current_axis);
	       UI.option.hconn_list.order = 4;
	    };
	    Ugraph_y_axis Y_Axis<export=2> {
	       current_axis => AGEditorShell.yaxes[0];
	       current_world => AGEditorShell.worlds[0];
	       UI.option.active => is_valid(current_axis);
	       UI.option.hconn_list.order = 5;
	    };
	    Ugraph_x_ticklines X_Ticklines {
	       current_tick => AGEditorShell.xticks[0];
	       UI.option.active => is_valid(current_tick);
	       UI.option.hconn_list.order = 6;
	    };
	    Ugraph_y_ticklines Y_Ticklines {
	       current_tick => AGEditorShell.yticks[0];
	       UI.option.active => is_valid(current_tick);
	       UI.option.hconn_list.order = 7;
	    };
	    Ugraph_legend Legend {
	       current_legend => AGEditorShell.legends[0];
	       UI.option.active => is_valid(current_legend);
	       UI.option.hconn_list.order = 8;
	    };
	    Ugraph_contour Contour {
	       current_contour => AGEditorShell.contours[0];
	       UI.option.active => is_valid(current_contour);
	       UI.option.hconn_list.order = 9;
	    };
	    Ugraph_viewport Viewport {
	       current_viewport => AGEditorShell.graph_views[0];
//	       current_viewport => AGEditorShell.views[0];
	       UI.option.active => is_valid(current_viewport);
	       UI.option.hconn_list.order = 10;
	    };
	 };
      };
#endif
#ifdef PRT_RENDERER
      AU.AUpanel_inst Uprint_editor {
	 UI.instancer.active = 1; // always de-instance when made invisible
	 Uview_link &in_view<NEportLevels={2,1}>;
	 UI.option {
	    label = "&Print";
	    active => 1 - Templates.CONFIG.gd_prt_disabled;
	    message = "AU_EDIT_PRT_MSG";
	    hconn_list.order = 8;
	 };
	 IUI {
	    float fromWidth => in_view.render_view.width;
	    float fromHeight => in_view.render_view.height;
#ifdef MSDOS
	    UIprintDialog printDialog<NEx=220,NEy=11>{
		visible => SetupButton.do;
		colors => <-.Output.color;
		orientation => <-.Output.orientation;
		size => <-.Output.size;
	    };
#endif
	    UIrenderView HCRenderView<NEx=198,NEy=121> {
	       parent => in_view.render_view.parent;
	       x = 0;
	       y = 0;
#ifdef MSDOS
	       width<NEportLevels={2,0}> = 500;
	       height<NEportLevels={2,0}> = 500;
#else
	       width<NEportLevels={2,0}> = 10;
	       height<NEportLevels={2,0}> = 10;
#endif
	       visible = 0;
	    };
	    DefaultPrtOutput Output<NEx=33,NEy=462,NEwidth=176,NEheight=220> {
	       fromRatio => (<-.fromWidth / <-.fromHeight);
	       fromWidth => <-.fromWidth;
	       fromHeight => <-.fromHeight;
#ifdef MSDOS
	       devMode => <-.printDialog.devMode;
	       devNames => <-.printDialog.devNames;
#endif
	    };
	    BestVirtPal VirtPal<NEx=33,NEy=121> {
	       vclass => in_view.virtpal.vclass;
	       vid => in_view.virtpal.vid;
	       cube_size => in_view.virtpal.cube_size;
	    };

	    group backgroundColors<NEx=33,NEy=242>[3] {
		float color[3];
	    } = {{color={1,1,1}},
		 {color={0,0,0}},
		 {color=>in_view.back_col}};
	    DefaultView View<NEy=198,NEx=33> {
	       renderer = GD_PRT_RENDERER;
#ifdef MSDOS
	       refresh<NEportLevels={2,2}> => <-.PrintButton.do;
#else
	       refresh<NEportLevels={2,2}> => <-.Create_File.do;
#endif
	       back_col =>  backgroundColors[Background.selectedItem].color;
               blend_mode => in_view.blend_mode;
	       mode = 0;
	       light_info => in_view.light_info;
	       handle => <-.HCRenderView.handle;
	       virtpal => <-.VirtPal;
	       output => <-.Output;
	       output_enabled = 1;
	       cameras => in_view.cameras;
	       buffers => in_view.buffers;
	       buffer = 0;
	       ts_enable => in_view.ts_enable;
	       ts_uniform => in_view.ts_uniform;
	       ts_scale => in_view.ts_scale;
	       ts_yscale => in_view.ts_yscale;
	       ts_xorig => in_view.ts_xorig;
	       ts_yorig => in_view.ts_yorig;
	    };
#ifdef MSDOS
	    UIframeShadowOut ResFrame<NEx=539,NEy=44,NEportLevels={0,1}> {
	      parent => panel;
	      y		=> <-.Title.y + <-.Title.height + 4;
	      width	=> panel.width;
	      height	=> ResYField.y + ResYField.height + 8;
	    };
	    UIlabel ResXLabel<NEx=539,NEy=74>{
	      parent	=> ResFrame;
	      label	= "X Resolution:";
	      y		= 0;
	    };
	    UIfield ResXField<NEx=539,NEy=104> {
	      parent	=> ResFrame;
	      y		=> ResXLabel.y + ResXLabel.height;
	      decimalPoints = 0;
	      value	=> <-.HCRenderView.width;
	    };
	    UIlabel ResYLabel<NEx=539,NEy=134> {
	      parent	=> ResFrame;
	      label	= "Y Resolution:";
	      y		=> ResXField.y + ResXField.height;
	    };
	    UIfield ResYField<NEx=539,NEy=164> {
	      parent	=> ResFrame;
	      y		=> ResYLabel.y + ResYLabel.height;
	      decimalPoints = 0;
	      value	=> <-.HCRenderView.height;
	    };
	    UIbutton SetupButton<NEx=539,NEy=194> {
	      parent	=> panel;
	      label	=> "Print Setup";
	      y 		=> ResFrame.y + ResFrame.height + 8;
	      width	=> ResFrame.width;
	    };
	    VUIOptionMenuLabel Background {
	       parent => panel;
	       options = {"White", "Black", "Keep"};
	       x = 0;
	       y => SetupButton.y + SetupButton.height + 8;
	       width => panel.clientWidth;
	       label = "Background";
	       selectedItem => <-.Output.backgroundType;
	    };

	    UIbutton PrintButton<NEx=539,NEy=194> {
	      parent	=> panel;
	      label	=> "Print";
	      y         => Background.y + Background.height + 12;
	      width	=> ResFrame.width;
	    };
#else
	    UIlabel Title<NEx=385,NEy=11> {
	       y = 0;
	       width => panel.clientWidth;
	       parent => panel;
	       label = "Print Editor";
	       alignment = 1;
	    };
	    VUIOptionMenuLabel Format {
	       parent => panel;
	       options = {"Postscript", "Color Postscript", "Postscript Level 2",
			  "CGM Binary", "CGM Clear Text", "CGM Character"};
	       x = 0;
	       y => Title.y + Title.height + 5;
	       width => panel.clientWidth;
	       label = "Format";
	       selectedItem => <-.Output.format;
	    };
	    VUIOptionMenuLabel Orientation {
	       parent => panel;
	       options = {"Landscape", "Portrait"};
	       x = 0;
	       y => Format.y + Format.height;
	       width => panel.clientWidth;
	       label = "Orientation";
	       selectedItem => <-.Output.orientation;
	    };
	    VUIOptionMenuLabel Background {
	       parent => panel;
	       options = {"White", "Black", "Keep"};
	       x = 0;
	       y => Orientation.y + Orientation.height;
	       width => panel.clientWidth;
	       label = "Background";
	       selectedItem => <-.Output.backgroundType;
	    };
	    VUIOptionMenuLabel SizeMenu {
	       parent => panel;
	       x = 0;
	       options = {"User (EPS)", "A (Letter)", "B", "A4", "A3", "A0"};
	       y => Background.y + Background.height;
	       width => panel.clientWidth;
	       label = "Size";
	       selectedItem => <-.Output.size;
	    };
	    UIlabel WidthMM<NEx=385,NEy=429> {
	       y => ((<-.SizeMenu.y + <-.SizeMenu.height) + 5);
	       width = 80;
	       height => <-.WidthValue.height;
	       active<NEportLevels={2,0}> => SizeMenu.selectedItem == 0;
	       parent => panel;
	    };
	    UIfield WidthValue<NEx=539,NEy=429> {
	       y => <-.WidthMM.y;
	       width => (panel.clientWidth - 84);
	       active<NEportLevels={2,0}> => WidthMM.active;
	       parent => panel;
	       min = 10;
	       value => <-.Output.widthMM;
	       x => (WidthMM.x + WidthMM.width);
	    };
	    UIlabel HeightMM<NEx=385,NEy=473> {
	       y => ((<-.WidthMM.y + <-.WidthMM.height) + 5);
	       width = 80;
	       height => <-.WidthValue.height;
	       active<NEportLevels={2,0}> => WidthMM.active;
	       parent => panel;
	    };
	    UIfield HeightValue<NEx=539,NEy=473> {
	       y => <-.HeightMM.y;
	       width => (panel.clientWidth - 84);
	       active<NEportLevels={2,0}> => WidthMM.active;
	       parent => panel;
	       min = 10;
	       value => <-.Output.heightMM;
	       x => (HeightMM.x + HeightMM.width);
	    };
	    UIslider ResolutionSlider<NEx=385,NEy=517> {
	       y => (HeightMM.y + HeightMM.height);
	       width => panel.clientWidth;
	       parent => panel;
	       min = 100;
	       max = 2000;
	       value<NEportLevels={2,2}> => <-.Output.resolution;
	       decimalPoints = 1;
	       title = "3D Horizontal Resolution";
	    };
	    UIlabel File<NEx=385,NEy=572> {
	       y => ((<-.ResolutionSlider.y + <-.ResolutionSlider.height) + 5);
	       width = 32;
	       height => <-.FileText.height;
	       parent => panel;
	    };
	    UItext FileText<NEx=539,NEy=572> {
	       y => <-.File.y;
	       width => (((panel.clientWidth-36)-<-.OpenFileDialog.width) - 4);
	       parent => panel;
	       text<NEportLevels={2,0}> => <-.Output.file;
	       x => (File.x + File.width);
	       updateMode = 2;
	    };
	    UIbutton OpenFileDialog<NEx=693,NEy=572> {
	       x => (panel.clientWidth - .width);
	       width = 32;
	       y => <-.File.y;
	       height => <-.FileText.height;
	       parent => panel;
	       label = "...";
	    };
	    StandardDialogs.UIfileDialog UIfileDialog<NEx=693,NEy=616> {
	       visible => <-.OpenFileDialog.do;
	       title = "Print Output File Dialog";
	       filename<NEportLevels={2,2}> => <-.Output.file;
	    };
	    UIbutton Create_File<NEx=385,NEy=616> {
	       y => ((<-.File.y + <-.File.height) + 5);
	       width => panel.clientWidth;
	       parent => panel;
	       label = "Create Print File";
	    };
#endif
	 };
      };
#endif

/* true scale editor start */

#ifdef PRT_RENDERER
    module ObjectExtent {
        DefaultObject &obj<NEportLevels={2,1}>;
        float extent[6];
        method update(obj+read+req+notify, extent+write) = "GDprt_get_extents";
    };
    AU.AUoptionMenuStack Uts_print_editor {
        UI.instancer.active = 1; // always de-instance when made invisible
        Mview_link &in_view<NEportLevels={2,1}>;
        UI.option {
            label = "&True Scale Print";
            active => 1 - Templates.CONFIG.gd_prt_disabled;
            message = "AU_EDIT_PRT_MSG";
            hconn_list.order = 8;
        };
        IUI {
            optionList.label = "True Scale Printing";
            float fromWidth  => in_render_view.width;
            float fromHeight => in_render_view.height;
#ifdef MSDOS
            UIprintDialog printDialog<NEx=220,NEy=11>{
                visible => PrintUI.IUI.SetupButton.do;
                colors => <-.Output.color;
                orientation => <-.Output.orientation;
                size => <-.Output.size;
            };
#endif
            UIrenderView &in_render_view<NEportLevels={3,1}>;
            UIrenderView HCRenderView<NEx=198,NEy=121> {
                parent => in_render_view.parent;
                x = 0;
                y = 0;
#ifdef MSDOS
                width<NEportLevels={2,0}> = 500;
                height<NEportLevels={2,0}> => width * <-.Output.sizeY / <-.Output.sizeX; //500;
#else
                width<NEportLevels={2,0}> = 10;
                height<NEportLevels={2,0}> = 10;
#endif
                visible = 0;
            };
            DefaultPrtOutput Output<NEx=33,NEy=462,NEwidth=176,NEheight=220> {
                fromRatio => (<-.fromWidth / <-.fromHeight);
                fromWidth => <-.fromWidth;
                fromHeight => <-.fromHeight;
                fromRatio = 1.0;
#ifdef MSDOS
                devMode => <-.printDialog.devMode;
                devNames => <-.printDialog.devNames;
#endif
            };
            BestVirtPal VirtPal<NEx=33,NEy=121> {
                vclass => <-.<-.in_view.virtpal.vclass;
                vid => <-.<-.in_view.virtpal.vid;
                cube_size => <-.<-.in_view.virtpal.cube_size;
            };
            DefaultXform cam_xform;
            group backgroundColors<NEx=33,NEy=242>[3] {
                float color[3];
            } = {{color={1,1,1}},
                 {color={0,0,0}},
                 {color=>in_view.back_col}};
            GDcamera &InCam => <-.in_view.cameras[0];
            GroupObject InObjects {
                child_objs => InCam.objects[0].objects;
            };
            ObjectExtent obj_extents {
                obj => InObjects.obj;
            };
            float ext_width => obj_extents.extent[1] - obj_extents.extent[0];
            float ext_height => obj_extents.extent[3] - obj_extents.extent[2];
            float sugg_ts_xorig => obj_center_x - (scr_center_x * View.ts_scale);
            float sugg_ts_yorig => obj_center_y - (scr_center_y * yscale);
            float sugg_ts_scale_a => 1.1 * 10.0*ext_width   / IUI.Output.sizeX;
            float sugg_ts_yscale_a => 1.1 * 10.0*ext_height / IUI.Output.sizeY;
            float max_sugg_scale => max_array({sugg_ts_scale_a, sugg_ts_yscale_a});
            float sugg_ts_scale => switch(View.ts_uniform + 1, sugg_ts_scale_a,
                                           max_sugg_scale);
            float sugg_ts_yscale => switch(View.ts_uniform + 1, sugg_ts_yscale_a,
                                           max_sugg_scale);
            float obj_center_x => (obj_extents.extent[0] + obj_extents.extent[1]) / 2.0;
            float obj_center_y => (obj_extents.extent[2] + obj_extents.extent[3]) / 2.0;
            float scr_center_x => IUI.Output.sizeX / (2.0 * 10.0);
            float scr_center_y => IUI.Output.sizeY / (2.0 * 10.0);
            float yscale => switch(View.ts_uniform + 1, View.ts_yscale, View.ts_scale);
            GDcamera Camera {
               update => InCam.update;
                type => InCam.type;
                mode => InCam.mode;
                auto_norm = 0;
                norm_scale => InCam.norm_scale;
                extents => InCam.extents;
                mapping => InCam.mapping;
                image_pass => InCam.image_pass;
                pickable => InCam.pickable; /* 0? */
                objects => InObjects.obj;
                ptr_depends => InCam.ptr_depends;
                xmin => InCam.xmin;
                ymin => InCam.ymin;
                xmax => InCam.xmax;
                ymax => InCam.ymax;
                from => InCam.from;
                up => InCam.up;
                at => InCam.at;
                scale => InCam.scale;
                /* connecting xform makes some kind of a loop and
                updates continually, so don't do xform => InCam.xform; */
                xform => cam_xform;
                perspec => InCam.perspec;
                hither => InCam.hither;
                front => InCam.front;
                back => InCam.back;
                fov => InCam.fov;
                wsize => InCam.wsize;
                depth_cue => InCam.depth_cue;
                depth_front => InCam.depth_front;
                depth_back => InCam.depth_back;
                depth_scale => InCam.depth_scale;
                jitter_scale => InCam.jitter_scale;
            };
            DefaultView View<NEy=198,NEx=33> {
                renderer = GD_PRT_RENDERER;
#ifdef MSDOS
                refresh<NEportLevels={2,2}> => <-.PrintUI.IUI.PrintButton.do;
#else
                refresh<NEportLevels={2,2}> => <-.PrintUI.IUI.Create_File.do;
#endif
                back_col => backgroundColors[<-.PrintUI.IUI.Background.selectedItem].color;
                blend_mode => in_view.blend_mode;
                mode = 0;
                light_info => in_view.light_info;
                handle => <-.HCRenderView.handle;
                virtpal => <-.VirtPal;
                output => <-.Output;
                output_enabled = 1;
                cameras => <-.Camera;
                buffers => in_view.buffers;
                buffer = 0;
                ts_enable = 1;
                ts_uniform = 1;
                ts_scale = 25000.0;
                ts_yscale = 25000.0;
                ts_xorig = 0.0;
                ts_yorig = 0.0;
                };
            AU.AUpanel_inst PrintUI {
                UI.option.hconn_list.order = 2;
                IUI {
#ifdef MSDOS
                    UIbutton SetupButton<NEx=539,NEy=194> {
                        parent	=> panel;
                        label	=> "Print Setup";
                        y 		=> Title.y + Title.height + 8;
                        width	=> panel.width;
                    };
                    VUIOptionMenuLabel Background {
                        parent => panel;
                        options = {"White", "Black", "Keep"};
                        x = 0;
                        y => SetupButton.y + SetupButton.height + 8;
                        width => panel.clientWidth;
                        label = "Background";
                        selectedItem => <-.<-.<-.Output.backgroundType;
                    };

                    UIbutton PrintButton<NEx=539,NEy=194> {
                        parent	=> panel;
                        label	=> "Print";
                        y       => Background.y + Background.height + 12;
                        width	=> panel.width;
                    };
#else
                    UIlabel Title<NEx=385,NEy=11> {
                        y = 0;
                        width => panel.clientWidth;
                        parent => panel;
                        label = "Print Editor";
                        alignment = 1;
                    };
                    VUIOptionMenuLabel Format {
                        parent => panel;
                        options = {"Postscript", "Color Postscript", "Postscript Level 2",
                                   "CGM Binary", "CGM Clear Text", "CGM Character"};
                        x = 0;
                        y => Title.y + Title.height + 5;
                        width => panel.clientWidth;
                        label = "Format";
                        selectedItem => <-.<-.<-.Output.format;
                        };
                        VUIOptionMenuLabel Orientation {
                        parent => panel;
                        options = {"Landscape", "Portrait"};
                        x = 0;
                        y => Format.y + Format.height;
                        width => panel.clientWidth;
                        label = "Orientation";
                        selectedItem => <-.<-.<-.Output.orientation;
                    };
                    VUIOptionMenuLabel Background {
                        parent => panel;
                        options = {"White", "Black", "Keep"};
                        x = 0;
                        y => Orientation.y + Orientation.height;
                        width => panel.clientWidth;
                        label = "Background";
                        selectedItem => <-.<-.<-.Output.backgroundType;
                    };
                    VUIOptionMenuLabel SizeMenu {
                        parent => panel;
                        x = 0;
                        options = {"User (EPS)", "A (Letter)", "B", "A4", "A3", "A0"};
                        y => Background.y + Background.height;
                        width => panel.clientWidth;
                        label = "Size";
                        selectedItem => <-.<-.<-.Output.size;
                    };
                    UIlabel WidthMM<NEx=385,NEy=429> {
                        y => ((<-.SizeMenu.y + <-.SizeMenu.height) + 5);
                        width = 80;
                        height => <-.WidthValue.height;
                        active<NEportLevels={2,0}> => SizeMenu.selectedItem == 0;
                        parent => panel;
                    };
                    UIfield WidthValue<NEx=539,NEy=429> {
                        y => <-.WidthMM.y;
                        width => (panel.clientWidth - 84);
                        active<NEportLevels={2,0}> => WidthMM.active;
                        parent => panel;
                        min = 10;
                        value => <-.<-.<-.Output.widthMM;
                        x => (WidthMM.x + WidthMM.width);
                    };
                    UIlabel HeightMM<NEx=385,NEy=473> {
                        y => ((<-.WidthMM.y + <-.WidthMM.height) + 5);
                        width = 80;
                        height => <-.WidthValue.height;
                        active<NEportLevels={2,0}> => WidthMM.active;
                        parent => panel;
                    };
                    UIfield HeightValue<NEx=539,NEy=473> {
                        y => <-.HeightMM.y;
                        width => (panel.clientWidth - 84);
                        active<NEportLevels={2,0}> => WidthMM.active;
                        parent => panel;
                        min = 10;
                        value => <-.<-.<-.Output.heightMM;
                        x => (HeightMM.x + HeightMM.width);
                    };
                    UIslider ResolutionSlider<NEx=385,NEy=517> {
                        y => (HeightMM.y + HeightMM.height);
                        width => panel.clientWidth;
                        parent => panel;
                        min = 100;
                        max = 2000;
                        value<NEportLevels={2,2}> => <-.<-.<-.Output.resolution;
                        decimalPoints = 1;
                        title = "3D Horizontal Resolution";
                    };
                    UIlabel File<NEx=385,NEy=572> {
                        y => ((<-.ResolutionSlider.y + <-.ResolutionSlider.height) + 5);
                        width = 32;
                        height => <-.FileText.height;
                        parent => panel;
                    };
                    UItext FileText<NEx=539,NEy=572> {
                        y => <-.File.y;
                        width => (((panel.clientWidth-36)-<-.OpenFileDialog.width) - 4);
                        parent => panel;
                        text<NEportLevels={2,0}> => <-.<-.<-.Output.file;
                        x => (File.x + File.width);
                        updateMode = 2;
                    };
                    UIbutton OpenFileDialog<NEx=693,NEy=572> {
                        x => (panel.clientWidth - .width);
                        width = 32;
                        y => <-.File.y;
                        height => <-.FileText.height;
                        parent => panel;
                        label = "...";
                    };
                    StandardDialogs.UIfileDialog UIfileDialog<NEx=693,NEy=616> {
                        visible => <-.OpenFileDialog.do;
                        title = "Print Output File Dialog";
                        filename<NEportLevels={2,2}> => <-.<-.<-.Output.file;
                    };
                    UIbutton Create_File<NEx=385,NEy=616> {
                        y => ((<-.File.y + <-.File.height) + 5);
                        width => panel.clientWidth;
                        parent => panel;
                        label = "Create Print File";
                    };
#endif
                };
            };
            AU.AUpanel_inst TrueScaleUI {
                UI.option.hconn_list.order = 1;
                IUI {

                    VUIToggle TS_UniformTog {
                        parent => panel;
                        y	=> 0;
                        width	=> panel.width;
                        label	= "Uniform Scaling";
                        set      => View.ts_uniform;
                        active	=> View.ts_enable;
                    };
                    VUIField TS_Scale {
                        parent	=> panel;
                        y       => TS_UniformTog.y + TS_UniformTog.height;
                        width	=> panel.width;
                        label	= "Map Scale   (units/cm)";
                        value    => View.ts_scale;
                        min	= 0.01;
                        max	= 10000000;
                        active	 => View.ts_enable;
                    };
                    VUIField TS_YScale {
                        parent	=> panel;
                        y	=> TS_Scale.y + TS_Scale.height;
                        width	=> panel.width;
                        label	= "Y Map Scale (units/cm)";
                        value    => View.ts_yscale;
                        min	= 0.01;
                        max	= 10000000;
                        active	 => View.ts_enable && !View.ts_uniform;
                    };
                    VUIField TS_XOrig {
                        parent	=> panel;
                        y	=> TS_YScale.y + TS_YScale.height;
                        width	=> panel.width;
                        label	= "X Origin";
                        value    => View.ts_xorig;
                        min	= -10000000;
                        max	= 10000000;
                        active	 => View.ts_enable;
                        };
                        VUIField TS_YOrig {
                        parent	=> panel;
                        y	=> TS_XOrig.y + TS_XOrig.height;
                        width	=> panel.width;
                        label	= "Y Origin";
                        value    => View.ts_yorig;
                        min	= -10000000;
                        max	= 10000000;
                        active	=> View.ts_enable;
                    };
                    UIbutton TS_Normalize {
                        y	=> TS_YOrig.y + TS_YOrig.height;
                        width => panel.clientWidth;
                        parent => panel;
                        label = "Scale Data to Fit";
                    };
                    UIbutton TS_Center {
                        y	=> TS_Normalize.y + TS_Normalize.height;
                        width => panel.clientWidth;
                        parent => panel;
                        label = "Center Data";
                    };
                    VUIToggle TS_PreviewTog {
                        parent => panel;
                        y	=> TS_Center.y + TS_Center.height;
                        width	=> panel.width;
                        label	= "Show Preview";
                        set      = 0;
                        active	=> View.ts_enable;
                    };
                    VUIToggle TS_PreviewBackgroundTog {
                        parent => panel;
                        y	=> TS_PreviewTog.y + TS_PreviewTog.height;
                        width	=> panel.width;
                        label	= "Preview match page background";
                        set      = 1;
                        active	=> View.ts_enable;
                    };
                    UIshell PreviewShell {
                        visible => <-.TS_PreviewTog.set;
                        title = "True Scale Preview";
                        showStatusBar = 0;
                    };

                    GMOD.parse_v NormalScale {
                        on_inst = 0;
                        relative => <-;
                        v_commands = "$push -usr\n View.ts_scale = sugg_ts_scale;  View.ts_yscale = sugg_ts_yscale;  View.ts_xorig = sugg_ts_xorig;  View.ts_yorig = sugg_ts_yorig; $pop\n";
                        trigger => TS_Normalize.do;
                    };

                    GMOD.parse_v TSCenter {
                        on_inst = 0;
                        relative => <-;
                        v_commands = "$push -usr\n View.ts_xorig = sugg_ts_xorig;  View.ts_yorig = sugg_ts_yorig;$pop\n";
                        trigger => TS_Center.do;
                    };

                    macro page_preview {
                        Mview_link view<NEportLevels={2,0}> => <-.<-.<-.View;
                        // in the preview, coordinates should be in centimeters
                        float rect_x<NEportLevels={1,2}> => ((.xmm / 10.));
                        float rect_y<NEportLevels={1,2}> => ((.ymm / 10.));
                        float rect_coords<NEportLevels=1>[5][2] => {
                            .x_orig,.y_orig,(x_orig + .rect_x),.y_orig,(x_orig + .rect_x),
                            (y_orig + .rect_y),.x_orig,(y_orig + .rect_y),.x_orig,.y_orig
                        };
                        int rect_connect<NEportLevels=1>[2] => {0,4};
                        FLD_MAP.polyline_mesh polyline_mesh {
                            coord => <-.rect_coords;
                            connect => <-.rect_connect;
                            obj<NEportLevels={1,3}>;
                            DataObject {
                                Props {
                                    draw_mode = "XOR";
                                };
                            };
                        };
                        float in_ts_scale<NEportLevels={1,2}> => view.ts_scale;
                        float in_ts_yscale<NEportLevels={1,2}> =>
                            switch(view.ts_uniform + 1, view.ts_yscale, view.ts_scale);
                        float x_orig<NEportLevels={1,2}> => view.ts_xorig / in_ts_scale;
                        float y_orig<NEportLevels={1,2}> => view.ts_yorig / in_ts_yscale;
                        // orientation already handled in GDoutput
                        float xmm<NEportLevels=1> => view.output.sizeX;
                        float ymm<NEportLevels=1> => view.output.sizeY;
                    };
                    GroupObject InObjects {
                        child_objs => <-.<-.<-.InCam.objects[0].objects;
                        float ts_scale<NEportLevels={2,1}> => <-.page_preview.in_ts_scale;
                        float ts_yscale<NEportLevels={2,1}> => <-.page_preview.in_ts_yscale;
                        Xform {
                            mat => {
                                1.0/ts_scale,0.,0.,0.,0.,1.0/ts_yscale,0.,0.,0.,0.,1.,0.,0.,0.,0.,1.
                            };
                        };
                    };

                    GDM.Iscene2D PreviewScene2D {
                        View {
                            ViewUI.ViewWindow.parent => PreviewShell;
                            View {
                                float black_col[3] = {0, 0, 0};
                                back_col => switch(<-.<-.<-.TS_PreviewBackgroundTog.set+1,
                                                   black_col, <-.<-.<-.<-.<-.View.back_col);
                                //back_col => <-.<-.<-.<-.<-.View.back_col;
                            };
                        };
                        Top {
                            child_objs => {<-.<-.InObjects.obj, <-.<-.page_preview.polyline_mesh.obj};
                        };
                        Camera {
                            Camera {
                                norm_scale = 0.95;
                            };
                        };
                    };

                };
            };
        };
    };

    macro UtsPrintEditor {
        Uview_link &view<NEportLevels={2,1}>;
        Uts_print_editor Uts_print_editor {
            in_view => view;
            IUI.in_render_view => view.render_view;
        };
    };
#endif

/* true scale editor end */

      GDM.Mscene_editor Uscene_editor {
	 in_view+Uview_link<NEportLevels={2,1}>;

	 Camera_Editor+Ucamera_editor;
	 Light_Editor+Ulight_editor;
	 View_Editor+Uview_editor {
	    GDobj_sel.cur_obj<NEportLevels={0,4}>;
	 };
	 Track_Editor+Utrack_editor;
	 Object_Editor+Uobject_editor;
         Udmap_editor Datamap_Editor {
            cur_obj => <-.View_Editor.GDobj_sel.cur_obj;
	 };
#ifdef AG_KIT
	 Ugraph_editor Graph_Editor {
	    cur_obj => <-.View_Editor.GDobj_sel.cur_obj;
	    list_changed => <-.View_Editor.GDobj_sel.obj_list_changed;
	 };
#endif
#ifdef PRT_RENDERER
	 Uprint_editor Print_Editor {
	    in_view => <-.in_view;
	 };
#endif
      };
   };
   flibrary+global+buffered Interactivity {
      macro ContinuousSketch {
	 GDview_templ &view_in<NEportLevels={2,1}>;
	 GDobject_templ &obj_in<NEportLevels={2,1}>;
         VIEW.UI_Interactivity.ContinuousSketch cont_sketch {
	    rv+nres => <-.view_in.render_view;
	    view => <-.view_in;
	    GDmap2d_ss {
	       obj_in+nres => <-.<-.obj_in;
	       out_mesh<NEportLevels={0,4}>;
            };
	    DataObject {
	       Obj {
		  name => name_of(<-.<-.<-.<-);
	       };
	       obj<NEportLevels={0,4}>;
            };
	 };
      };
      macro ClickSketch {
	 GDview_templ &view_in<NEportLevels={2,1}>;
	 GDobject_templ &obj_in<NEportLevels={2,1}>;
         VIEW.UI_Interactivity.ClickSketch click_sketch {
	    rv+nres => <-.view_in.render_view;
	    view => <-.view_in;
	    GDmap2d_ss {
	       obj_in+nres => <-.<-.obj_in;
	       out_mesh<NEportLevels={0,4}>;
            };
	    DataObject {
	       Obj {
		  name => name_of(<-.<-.<-.<-);
	       };
	       obj<NEportLevels={0,4}>;
            };
	 };
      };
      macro DrawCursor2D {
	 GDview_templ &view_in<NEportLevels={2,1}>;
	 GDobject_templ &obj_in<NEportLevels={2,1}>;
         VIEW.UI_Interactivity.DrawCursor2D draw_cursor {
	    rv+nres => <-.view_in.render_view;
	    view => <-.view_in;
	    GDdraw2d_cursor {
	       obj_in => <-.<-.obj_in;
	       out_mesh<NEportLevels={0,4}>;
            };
	 };
      };
      macro DrawLine2D {
	 GDview_templ &view_in<NEportLevels={2,1}>;
	 GDobject_templ &obj_in<NEportLevels={2,1}>;
         VIEW.UI_Interactivity.DrawLine2D draw_line {
	    rv+nres => <-.view_in.render_view;
	    view => <-.view_in;
	    GDmap2d_ss {
	       obj_in => <-.<-.obj_in;
	       out_mesh<NEportLevels={0,4}>;
            };
	 };
      };
      macro EditMesh {
	 GDview_templ &view_in<NEportLevels={2,1}>;
         VIEW.UI_Interactivity.EditMesh edit_mesh {
	    UItwoPoint+nres => <-.view_in.two_point;
	    view => <-.view_in;
	 };
      };
      macro Vector2Raster {
	 ilink in_field;
	 GDobject_templ &obj_in<NEportLevels={2,1}>;
         VIEW.UI_Interactivity.Vector2Raster vec2rast  {
	    in_field => <-.in_field;
	    object => <-.obj_in;
	    GDvector2raster {
	       output<NEportLevels={0,4}>;
            };
	    DataObject {
	       Obj {
		  name => name_of(<-.<-.<-.<-);
	       };
	       obj<NEportLevels={0,4}>;
            };
	 };
      };
   };
   flibrary+global Viewers<indexed=1> {
      macro Uviewer3D<export_subs=1> {
	 GDM.Uscene3D Scene {
	    Top.child_objs<NEportLevels={4,1},NEcolor0=0xff0000>;
	    View.View.picked_obj<NEportLevels={0,5}>;
	 };
	 GDview_selector Scene_Selector<export_subs=1,export=1> {
	    input_views => {Scene.View.View};
	    curr_view<NEportLevels={0,3}>;
	 };
	 Uscene_editor Scene_Editor {
	    in_view => Scene_Selector.curr_view;
	    View_Editor.GDobj_sel.cur_obj<NEportLevels={0,5}>;
	 };
      };
      Uviewer3D Uviewer2D {
	 Scene.View.View.renderer = GD_SWX_RENDERER;
	 Scene.Camera.Camera.type = GD_CAMERA_2D;
      };
      Uviewer3D Uviewer {
	 Scene+Uscene {
            // one-way connection to the default renderer
	    View.View.renderer => Templates.CONFIG.gd_default_renderer + 0;
	    Top.child_objs<NEportLevels={4,1},NEcolor0=0xff0000>;
	    Top2D.child_objs<NEportLevels={4,1},NEcolor0=0xff0000>;
	 };
      };

#ifdef VPS_RENDERER
      OutputVPS OutputVPS;
#endif

#ifdef VRML_RENDERER
      OutputVRML OutputVRML;
#endif

      macro OutputField {
	 GDview_templ &view_in<NEportLevels={2,1}>;
         VIEW.Viewers.OutputField output_field {
	    UImod_panel {
	       title => name_of(<-.<-.<-);
	    };
	    render_view+nres => <-.view_in.render_view;
	    view_in => <-.view_in;
	    Output {
	       output<NEportLevels={0,4}>;
	    };
	    DataObject {
	       Obj {
		  name => name_of(<-.<-.<-.<-);
	       };
	       obj<NEportLevels={0,4}>;
            };
	 };
      };
      macro OutputFile {
	 GDview_templ &view_in<NEportLevels={2,1}>;
         VIEW.Viewers.OutputFile output_file {
	    UImod_panel {
	       title => name_of(<-.<-.<-);
	    };
	    render_view+nres => <-.view_in.render_view;
	    view_in => <-.view_in;
	 };
      };

      DisplayImage DisplayImage;
      HLM.OutputImage OutputImage;
   };
};
