/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/geoms.v#1 $
*/
flibrary+buffered+sort GEOMS<compile_subs=0,needs_edit_lic="DV"> {

$include ../include/avs/gd_def.h

macro Axis2D {
	ilink in_field;
	group+IPort2 &axis_labels {
		string x_labels[];
		string y_labels[];
	};

	DV_Param_axis x_axis_param<export_all=2> {
		start=>in_field.coordinates.min_vec[0]+0;
		end=>in_field.coordinates.max_vec[0]+0;
		ref => in_field.coordinates.min_vec[0]+0;
		step=>(in_field.coordinates.max_vec[0]-
			in_field.coordinates.min_vec[0])/5;
		tick_y_below =>y_axis_param.ref-y_axis_param.limits[0];
		tick_y_above =>y_axis_param.limits[1]-y_axis_param.ref;
		tick_z_below =0;
		tick_z_above =0;
		minor_ticks = 1;
		minor_scale = 1;
		ndig = 1;
		float+nres+Port2 off_anno => step/5;
		y_anno => (-1)*off_anno;
		z_anno =0;
		axis_name+IPort3="X";
		axis_labels+nres=> <-.axis_labels.x_labels;
	};

	DV_Param_axis y_axis_param<export_all=2> {
		start=>in_field.coordinates.min_vec[1]+0;
		end=>in_field.coordinates.max_vec[1]+0;
		ref => in_field.coordinates.min_vec[1]+0;
		step=>(in_field.coordinates.max_vec[1]-
			in_field.coordinates.min_vec[1])/5;
		tick_y_below =>x_axis_param.limits[1]-x_axis_param.ref;
		tick_y_above =>x_axis_param.ref-x_axis_param.limits[0];
		tick_z_below =0;
		tick_z_above =0;
		minor_ticks = 1;
		minor_scale = 1;
		ndig = 1;
		float+nres+Port2 off_anno => step/5;
		y_anno => off_anno;
		z_anno =0;
		axis_name+IPort3 = "Y";
		axis_labels+nres=> <-.axis_labels.y_labels;
	};

	DefaultXform+nonotify x_xform {
		xlate=>{0,<-.y_axis_param.ref,0};
	};
	DefaultXform+nonotify  y_xform {
		xlate=>{<-.x_axis_param.ref,0,0};
		mat => {{0,1,0,0},
       			{-1,0,0,0},
      			{0,0,1,0},
               	 	{0,0,0,1}};
	};
	DVconcat_xform DVconcat_xform_x {
		xform_in2+nres => <-.in_field.xform;
		xform_in1+nres => <-.x_xform;
	};
	DVconcat_xform  DVconcat_xform_y {
		xform_in2+nres => <-.in_field.xform;
		xform_in1+nres => <-.y_xform;
	};
	DVaxis axis_x {
		in => <-.in_field;
		limits[2]=> <-.x_axis_param.limits;
		reference=> <-.x_axis_param.ref;
		tick_step=> <-.x_axis_param.step;
		tick_y_below=> <-.x_axis_param.tick_y_below;
		tick_y_above=> <-.x_axis_param.tick_y_above;
		tick_z_below=> <-.x_axis_param.tick_z_below;
		tick_z_above=> <-.x_axis_param.tick_z_above;
		minor_ticks=> <-.x_axis_param.minor_ticks;
		minor_scale=> <-.x_axis_param.minor_scale;
		ndig => <-.x_axis_param.ndig;
		y_anno => <-.x_axis_param.y_anno;
		z_anno => <-.x_axis_param.z_anno;
		axis_name => <-.x_axis_param.axis_name;
		axis_labels => <-.x_axis_param.axis_labels;

		out {
			&xform+nowrite => <-.<-.DVconcat_xform_x.xform_out;
		};
	};

	DVaxis axis_y {
		in => <-.in_field;
		limits[2]=> <-.y_axis_param.limits;
		reference=> <-.y_axis_param.ref;
		tick_step=> <-.y_axis_param.step;
		tick_y_below=> <-.y_axis_param.tick_y_below;
		tick_y_above=> <-.y_axis_param.tick_y_above;
		tick_z_below=> <-.y_axis_param.tick_z_below;
		tick_z_above=> <-.y_axis_param.tick_z_above;
		minor_ticks=> <-.y_axis_param.minor_ticks;
		minor_scale=> <-.y_axis_param.minor_scale;
		ndig => <-.y_axis_param.ndig;
		y_anno => <-.y_axis_param.y_anno;
		z_anno => <-.y_axis_param.z_anno;
		axis_name => <-.y_axis_param.axis_name;
		axis_labels => <-.y_axis_param.axis_labels;

		out {
			&xform+nowrite => <-.<-.DVconcat_xform_y.xform_out;
		};
	};
 	GMOD.instancer instancer {
		Value => UIpanel.visible;
		active = 2; // don't de-instance when visible = 0
		Group => Axis2DUI;
	};
	UImod_panel UIpanel {
		parent<NEportLevels={3,0}>;
		title => name_of(<-.<-);
		message = "Select Axis2D control panel.";
	};

	macro  Axis2DUI<instanced=0> {
		ilink in_fld => in_field;
		DV_Param_axis+IPort2 &x_param => <-.x_axis_param;
		DV_Param_axis+IPort2 &y_param => <-.y_axis_param;

		ilink UIpanel => <-.UIpanel;

		UIlabel x_label {
        		parent => <-.UIpanel;
        		label = "X axis name";
			alignment = 2;
        		x	=  0;
        		y	= 0;
			width	=  80;
    		};
		UItext x_name {
	    		parent => <-.UIpanel;
	    		&text+IPort2 => x_axis_param.axis_name;
	    		y		=  0;
			x 		= <-.x_label.width+4;
	    		width	=> <-.UIpanel.width-84;
		};
		UIfieldTypein x_start_typein {
        		UIparent => <-.UIpanel;
			flabel = "X start";
			fval+IPort2 => x_axis_param.start;
			y	=> <-.x_name.y + <-.x_name.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein x_end_typein {
        		UIparent => <-.UIpanel;
			flabel = "X end";
			fval+IPort2 => x_axis_param.end;
			y	=> <-.x_start_typein.y + <-.x_start_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein x_origin_typein {
        		UIparent => <-.UIpanel;
			flabel = "X origin";
			fval+IPort2 => x_axis_param.ref;
			y	=> <-.x_end_typein.y + <-.x_end_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein x_step_typein {
        		UIparent => <-.UIpanel;
			flabel = "X step";
			fval+IPort2 => x_axis_param.step;
			y	=> <-.x_origin_typein.y + <-.x_origin_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein x_offset_typein {
        		UIparent => <-.UIpanel;
			flabel = "X labels offset";
			fval+IPort2 => x_axis_param.off_anno;
			y	=> <-.x_step_typein.y + <-.x_step_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider x_dig_slider {
        		parent => <-.UIpanel;
		        title = "X ndigits";
			max = 12;
			value+IPort2 => x_axis_param.ndig;
			mode = 1;
			y	=> <-.x_offset_typein.y + <-.x_offset_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider x_minor_slider {
        		parent => <-.UIpanel;
		        title = "X minor ticks";
			max = 12;
			value+IPort2 => x_axis_param.minor_ticks;
			mode = 1;
			y	=> <-.x_dig_slider.y + <-.x_dig_slider.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIlabel y_label {
        		parent => <-.UIpanel;
        		label = "Y axis name";
			alignment = 2;
        		x	=  0;
			y	=> <-.x_minor_slider.y + <-.x_minor_slider.height+4;
			width	=  80;
    		};
		UItext y_name {
	    		parent => <-.UIpanel;
	    		&text+IPort2 => y_axis_param.axis_name;
	    		y	=> <-.x_minor_slider.y + <-.x_minor_slider.height+4;
			x 	= <-.y_label.width+4;
	    		width	=> <-.UIpanel.width-84;
		};
		UIfieldTypein y_start_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y start";
			fval+IPort2 => y_axis_param.start;
			y	=> <-.y_name.y + <-.y_name.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein y_end_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y end";
			fval+IPort2 => y_axis_param.end;
			y	=> <-.y_start_typein.y + <-.y_start_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein y_origin_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y origin";
			fval+IPort2 => y_axis_param.ref;
			y	=> <-.y_end_typein.y + <-.y_end_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein y_step_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y step";
			fval+IPort2 => y_axis_param.step;
			y	=> <-.y_origin_typein.y + <-.y_origin_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein y_offset_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y labels offset";
			fval+IPort2 => y_axis_param.off_anno;
			y	=> <-.y_step_typein.y + <-.y_step_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider y_dig_slider {
        		parent => <-.UIpanel;
		        title = "Y ndigits";
			max = 12;
			value+IPort2 => y_axis_param.ndig;
			mode = 1;
			y	=> <-.y_offset_typein.y + <-.y_offset_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider y_minor_slider {
        		parent => <-.UIpanel;
		        title = "Y minor ticks";
			max = 12;
			value+IPort2 => y_axis_param.minor_ticks;
			mode = 1;
			y	=> <-.y_dig_slider.y + <-.y_dig_slider.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIradioBoxLabel   UIradioBoxLabel_mode1 {
		        parent => <-.UIpanel;
			labels+IPort2 => {"solid", "dashed", "dotted", "dashdot"};
			&selectedItem+IPort2 => <-.<-.major_line_mode;
			visible => <-.UIpanel.visible;
			title = "Major Line Mode";
			y	=> <-.y_minor_slider.y + <-.y_minor_slider.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIradioBoxLabel   UIradioBoxLabel_mode2 {
		        parent => <-.UIpanel;
			labels+IPort2 => {"solid", "dashed", "dotted", "dashdot"};
			&selectedItem+IPort2 => <-.<-.minor_line_mode;
			visible => <-.UIpanel.visible;
			title = "Minor Line Mode";
			y	=> <-.UIradioBoxLabel_mode1.y + <-.UIradioBoxLabel_mode1.height+4;
	    		width	=> <-.UIpanel.width;
		};
/**
		UItextTypein UItextTypein_font {
			UIparent => <-.UIpanel;
			slabel = "Font";
			stext=> <-.<-.font;
	    		panel.y		=> <-.<-.UIradioBoxLabel_mode2.y + <-.<-.UIradioBoxLabel_mode2.height+4;
	    		panel.width	=> <-.<-.UIpanel.width;
		};
**/
	};

	int+Port major_line_mode<export=2>=0;
	int+Port minor_line_mode<export=2>=2;
	string+Port font<export=2>;


	DataObjectLite obj_x {
        	in => axis_x.out;
		Props.line_style => <-.<-.major_line_mode;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " x axis";
		};
	};
	DataObjectLite obj_y {
        	in => axis_y.out;
		Props.line_style => <-.<-.major_line_mode;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " y axis";
		};
	};
	DataObjectLite obj_x_minor {
        	in => axis_x.out_minor;
		Props.line_style => <-.<-.minor_line_mode;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " x minor grid";
		};
	};
	DataObjectLite obj_y_minor {
        	in => axis_y.out_minor;
		Props.line_style => <-.<-.minor_line_mode;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " y minor grid";
		};
	};
	DataObjectLite obj_x_anno {
        	in => axis_x.out_anno;
		Props.font => <-.<-.font;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " x labels";
		};
	};
	DataObjectLite obj_y_anno {
        	in => axis_y.out_anno;
		Props.font => <-.<-.font;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+" y labels";
		};
	};
	DataObjectLite obj_x_name {
        	in => axis_x.out_name;
		Props.font => <-.<-.font;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " x name";
		};
	};
	DataObjectLite obj_y_name {
        	in => axis_y.out_name;
		Props.font => <-.<-.font;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+" y name";
		};
	};
	GroupObject obj {
        	child_objs => {obj_x.obj, obj_y.obj,
				obj_x_minor.obj, obj_y_minor.obj, 
				obj_x_anno.obj, obj_y_anno.obj,
				obj_x_name.obj, obj_y_name.obj};
		Top {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+" Top";
		};
	};

	olink out_obj => obj.obj;
}; // Axis2D


macro Axis3D {
	ilink in_field;
	group+IPort2 &axis_labels {
		string x_labels[];
		string y_labels[];
		string z_labels[];
	};

	DV_Param_axis x_axis_param<export_all=2> {
		start=>in_field.coordinates.min_vec[0]+0;
		end=>in_field.coordinates.max_vec[0]+0;
		ref => in_field.coordinates.min_vec[0]+0;
		step=>(in_field.coordinates.max_vec[0]-
			in_field.coordinates.min_vec[0])/5;
		tick_y_below =>y_axis_param.ref-y_axis_param.limits[0];
		tick_y_above =>y_axis_param.limits[1]-y_axis_param.ref;
		tick_z_below =>z_axis_param.ref-z_axis_param.limits[0];
		tick_z_above =>z_axis_param.limits[1]-z_axis_param.ref;
		minor_ticks = 1;
		minor_scale = 1;
		ndig = 1;
		float+nres+Port2 off_anno => step/5;
		y_anno => (-1)*off_anno;
		z_anno => (-1)*off_anno;
		axis_name+IPort3="X";
                axis_labels+nres=> <-.axis_labels.x_labels;
	};

	DV_Param_axis y_axis_param<export_all=2> {
		start=>in_field.coordinates.min_vec[1]+0;
		end=>in_field.coordinates.max_vec[1]+0;
		ref => in_field.coordinates.min_vec[1]+0;
		step=>(in_field.coordinates.max_vec[1]-
			in_field.coordinates.min_vec[1])/5;
		tick_y_below =>x_axis_param.limits[1]-x_axis_param.ref;
		tick_y_above =>x_axis_param.ref-x_axis_param.limits[0];
		tick_z_below =>z_axis_param.ref-z_axis_param.limits[0];
		tick_z_above =>z_axis_param.limits[1]-z_axis_param.ref;
		minor_ticks = 1;
		minor_scale = 1;
		ndig = 1;
		float+nres+Port2 off_anno => step/5;
		y_anno => off_anno;
		z_anno => (-1)*off_anno;
		axis_name+IPort3="Y";
                axis_labels+nres=> <-.axis_labels.y_labels;
	};

	DV_Param_axis z_axis_param<export_all=2> {
		start=>in_field.coordinates.min_vec[2]+0;
		end=>in_field.coordinates.max_vec[2]+0;
		ref => in_field.coordinates.min_vec[2]+0;
		step=>(in_field.coordinates.max_vec[2]-
			in_field.coordinates.min_vec[2])/5;
		tick_y_below =>y_axis_param.ref-y_axis_param.limits[0];
		tick_y_above =>y_axis_param.limits[1]-y_axis_param.ref;
		tick_z_below =>x_axis_param.limits[1]-x_axis_param.ref;
		tick_z_above =>x_axis_param.ref-x_axis_param.limits[0];
		minor_ticks = 1;
		minor_scale = 1;
		ndig = 1;
		float+nres+Port2 off_anno => step/5;
		y_anno => (-1)*off_anno;
		z_anno => off_anno;
		axis_name+IPort3="Z";
                axis_labels+nres=> <-.axis_labels.z_labels;
	};

	DefaultXform+nonotify x_xform {
		xlate=>{0,<-.y_axis_param.ref,
			  <-.z_axis_param.ref};
	};
	DefaultXform+nonotify y_xform {
		xlate=>{<-.x_axis_param.ref,0,
			<-.z_axis_param.ref};
		mat => {{0,1,0,0},
       			{-1,0,0,0},
       			{0,0,1,0},
               	 	{0,0,0,1}};
	};
	DefaultXform+nonotify z_xform {
		xlate=>{<-.x_axis_param.ref,
			<-.y_axis_param.ref, 0};
			mat => {{0,0,1,0},
       	         		 {0,1,0,0},
                	   	 {-1,0,0,0},
       	           		 {0,0,0,1}};
	};

	DVconcat_xform DVconcat_xform_x {
		xform_in2+nres => <-.in_field.xform;
		xform_in1+nres => <-.x_xform;
	};

	DVconcat_xform DVconcat_xform_y {
		xform_in2+nres => <-.in_field.xform;
		xform_in1+nres => <-.y_xform;
	};

	DVconcat_xform DVconcat_xform_z {
		xform_in2+nres => <-.in_field.xform;
		xform_in1+nres => <-.z_xform;
	};

	DVaxis axis_x {
		in {
			nspace =3;
		}=> <-.in_field;
		limits[2]=> <-.x_axis_param.limits;
		reference=> <-.x_axis_param.ref;
		tick_step=> <-.x_axis_param.step;
		tick_y_below=> <-.x_axis_param.tick_y_below;
		tick_y_above=> <-.x_axis_param.tick_y_above;
		tick_z_below=> <-.x_axis_param.tick_z_below;
		tick_z_above=> <-.x_axis_param.tick_z_above;
		minor_ticks=> <-.x_axis_param.minor_ticks;
		minor_scale=> <-.x_axis_param.minor_scale;
		ndig => <-.x_axis_param.ndig;
		y_anno => <-.x_axis_param.y_anno;
		z_anno => <-.x_axis_param.z_anno;
		axis_name => <-.x_axis_param.axis_name;
                axis_labels => <-.x_axis_param.axis_labels;
		out {
			&xform => <-.<-.DVconcat_xform_x.xform_out;
		};
	};

	DVaxis axis_y {
		in {
			nspace =3;
		}=> <-.in_field;
		limits[2]=> <-.y_axis_param.limits;
		reference=> <-.y_axis_param.ref;
		tick_step=> <-.y_axis_param.step;
		tick_y_below=> <-.y_axis_param.tick_y_below;
		tick_y_above=> <-.y_axis_param.tick_y_above;
		tick_z_below=> <-.y_axis_param.tick_z_below;
		tick_z_above=> <-.y_axis_param.tick_z_above;
		minor_ticks=> <-.y_axis_param.minor_ticks;
		minor_scale=> <-.y_axis_param.minor_scale;
		ndig => <-.y_axis_param.ndig;
		y_anno => <-.y_axis_param.y_anno;
		z_anno => <-.y_axis_param.z_anno;
		axis_name => <-.y_axis_param.axis_name;
                axis_labels => <-.y_axis_param.axis_labels;
		out {
			&xform => <-.<-.DVconcat_xform_y.xform_out;
		};
	};

	DVaxis axis_z {
		in {
			nspace =3;
		}=> <-.in_field;
		limits[2]=> <-.z_axis_param.limits;
		reference=> <-.z_axis_param.ref;
		tick_step=> <-.z_axis_param.step;
		tick_y_below=> <-.z_axis_param.tick_y_below;
		tick_y_above=> <-.z_axis_param.tick_y_above;
		tick_z_below=> <-.z_axis_param.tick_z_below;
		tick_z_above=> <-.z_axis_param.tick_z_above;
		minor_ticks=> <-.z_axis_param.minor_ticks;
		minor_scale=> <-.z_axis_param.minor_scale;
		ndig => <-.z_axis_param.ndig;
		y_anno => <-.z_axis_param.y_anno;
		z_anno => <-.z_axis_param.z_anno;
		axis_name => <-.z_axis_param.axis_name;
                axis_labels => <-.z_axis_param.axis_labels;
		out {
			&xform => <-.<-.DVconcat_xform_z.xform_out;
		};
	};

 	GMOD.instancer instancer {
		Value => UIpanel.visible;
		active = 2; // don't de-instance when visible = 0
		Group => Axis3DUI;
	};
	UImod_panel UIpanel {
		parent<NEportLevels={3,0}>;
		title => name_of(<-.<-);
		message = "Select Axis3D control panel.";
	};

	macro  Axis3DUI<instanced=0> {
		ilink in_fld => in_field;
		DV_Param_axis+IPort2 &x_param => <-.x_axis_param;
		DV_Param_axis+IPort2 &y_param => <-.y_axis_param;
		DV_Param_axis+IPort2 &z_param => <-.z_axis_param;

		ilink UIpanel => <-.UIpanel;

                UIlabel x_label {
                        parent => <-.UIpanel;
                        label = "X axis name";
                        alignment = 2;
                        x       =  0;
                        y       = 0;
                        width   =  80;
                };
                UItext x_name {
                        parent => <-.UIpanel;
                        &text+IPort2 => x_axis_param.axis_name;
                        y               =  0;
                        x               = <-.x_label.width+4;
                        width   => <-.UIpanel.width-84;
                };
		UIfieldTypein x_start_typein {
        		UIparent => <-.UIpanel;
			flabel = "X start";
			fval+IPort2 => x_axis_param.start;
			y	=> <-.x_name.y + <-.x_name.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein x_end_typein {
        		UIparent => <-.UIpanel;
			flabel = "X end";
			fval+IPort2 => x_axis_param.end;
			y	=> <-.x_start_typein.y + <-.x_start_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein x_origin_typein {
        		UIparent => <-.UIpanel;
			flabel = "X origin";
			fval+IPort2 => x_axis_param.ref;
			y	=> <-.x_end_typein.y + <-.x_end_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein x_step_typein {
        		UIparent => <-.UIpanel;
			flabel = "X step";
			fval+IPort2 => x_axis_param.step;
			y	=> <-.x_origin_typein.y + <-.x_origin_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein x_offset_typein {
        		UIparent => <-.UIpanel;
			flabel = "X labels offset";
			fval+IPort2 => x_axis_param.off_anno;
			y	=> <-.x_step_typein.y + <-.x_step_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider x_dig_slider {
        		parent => <-.UIpanel;
		        title = "X ndigits";
			max = 12;
			value+IPort2 => x_axis_param.ndig;
			mode = 1;
			y	=> <-.x_offset_typein.y + <-.x_offset_typein.height+5;
	    		width	=> <-.UIpanel.width;
		};
		UIslider x_minor_slider {
        		parent => <-.UIpanel;
		        title = "X minor ticks";
			max = 12;
			value+IPort2 => x_axis_param.minor_ticks;
			mode = 1;
			y	=> <-.x_dig_slider.y + <-.x_dig_slider.height+4;
	    		width	=> <-.UIpanel.width;
		};
                UIlabel y_label {
                        parent => <-.UIpanel;
                        label = "Y axis name";
                        alignment = 2;
                        x       =  0;
                        y       => <-.x_minor_slider.y + <-.x_minor_slider.height+4;
                        width   =  80;
                };
                UItext y_name {
                        parent => <-.UIpanel;
                        &text+IPort2 => y_axis_param.axis_name;
                        y       => <-.x_minor_slider.y + <-.x_minor_slider.height+4;
                        x       = <-.y_label.width+4;
                        width   => <-.UIpanel.width-84;
                };

		UIfieldTypein y_start_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y start";
			fval+IPort2 => y_axis_param.start;
			y	=> <-.y_name.y + <-.y_name.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein y_end_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y end";
			fval+IPort2 => y_axis_param.end;
			y	=> <-.y_start_typein.y + <-.y_start_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein y_origin_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y origin";
			fval+IPort2 => y_axis_param.ref;
			y	=> <-.y_end_typein.y + <-.y_end_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein y_step_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y step";
			fval+IPort2 => y_axis_param.step;
			y	=> <-.y_origin_typein.y + <-.y_origin_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein y_offset_typein {
        		UIparent => <-.UIpanel;
			flabel = "Y labels offset";
			fval+IPort2 => y_axis_param.off_anno;
			y	=> <-.y_step_typein.y + <-.y_step_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider y_dig_slider {
        		parent => <-.UIpanel;
		        title = "Y ndigits";
			max = 12;
			value+IPort2 => y_axis_param.ndig;
			mode = 1;
			y	=> <-.y_offset_typein.y + <-.y_dig_slider.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider y_minor_slider {
        		parent => <-.UIpanel;
		        title = "Y minor ticks";
			max = 12;
			value+IPort2 => y_axis_param.minor_ticks;
			mode = 1;
			y	=> <-.y_dig_slider.y + <-.y_dig_slider.height+4;
	    		width	=> <-.UIpanel.width;
		};
                UIlabel z_label {
                        parent => <-.UIpanel;
                        label = "Z axis name";
                        alignment = 2;
                        x       =  0;
                        y       => <-.y_minor_slider.y + <-.y_minor_slider.height+4;
                        width   =  80;
                };
                UItext z_name {
                        parent => <-.UIpanel;
                        &text+IPort2 => z_axis_param.axis_name;
                        y       => <-.y_minor_slider.y + <-.y_minor_slider.height+4;
                        x       = <-.z_label.width+4;
                        width   => <-.UIpanel.width-84;
                };

		UIfieldTypein z_start_typein {
        		UIparent => <-.UIpanel;
			flabel = "Z start";
			fval+IPort2 => z_axis_param.start;
			y	=> <-.z_name.y + <-.z_name.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein z_end_typein {
        		UIparent => <-.UIpanel;
			flabel = "Z end";
			fval+IPort2 => z_axis_param.end;
			y	=> <-.z_start_typein.y + <-.z_start_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein z_origin_typein {
        		UIparent => <-.UIpanel;
			flabel = "Z origin";
			fval+IPort2 => z_axis_param.ref;
			y	=> <-.z_end_typein.y + <-.z_end_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein z_step_typein {
        		UIparent => <-.UIpanel;
			flabel = "Z step";
			fval+IPort2 => z_axis_param.step;
			y	=> <-.z_origin_typein.y + <-.z_origin_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIfieldTypein z_offset_typein {
        		UIparent => <-.UIpanel;
			flabel = "Z labels offset";
			fval+IPort2 => z_axis_param.off_anno;
			y	=> <-.z_step_typein.y + <-.z_step_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider z_dig_slider {
        		parent => <-.UIpanel;
		        title = "Z ndigits";
			max = 12;
			value+IPort2 => z_axis_param.ndig;
			mode = 1;
			y	=> <-.z_offset_typein.y + <-.z_offset_typein.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIslider z_minor_slider {
        		parent => <-.UIpanel;
		        title = "Z minor ticks";
			max = 12;
			value+IPort2 => z_axis_param.minor_ticks;
			mode = 1;
			y	=> <-.z_dig_slider.y + <-.z_dig_slider.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIradioBoxLabel   UIradioBoxLabel_mode1{
		        parent => <-.UIpanel;
			labels+IPort2 => {"solid", "dashed", "dotted", "dashdot"};
			&selectedItem+IPort2 => <-.<-.major_line_mode;
			visible => <-.UIpanel.visible;
			title = "Major Line Mode";
			y	=> <-.z_minor_slider.y + <-.z_minor_slider.height+4;
	    		width	=> <-.UIpanel.width;
		};
		UIradioBoxLabel   UIradioBoxLabel_mode2 {
		        parent => <-.UIpanel;
			labels+IPort2 => {"solid", "dashed", "dotted", "dashdot"};
			&selectedItem+IPort2 => <-.<-.minor_line_mode;
			visible => <-.UIpanel.visible;
			title = "Minor Line Mode";
			y	=> <-.UIradioBoxLabel_mode1.y + <-.UIradioBoxLabel_mode1.height+4;
	    		width	=> <-.UIpanel.width;
		};
/**
		UItextTypein UItextTypein_font {
			UIparent => <-.UIpanel;
			slabel = "Font";
			stext=> <-.<-.font;
	    		panel.y		=> <-.<-.UIradioBoxLabel_mode2.y + <-.<-.UIradioBoxLabel_mode2.height+4;
	    		panel.width	=> <-.<-.UIpanel.width;
		};
**/
	};

	int+Port major_line_mode<export=2>=0;
	int+Port minor_line_mode<export=2>=2;
	string+Port font<export=2>;

	DataObjectLite obj_x {
        	in => axis_x.out;
		Props {
			line_style => <-.<-.major_line_mode;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " x axis";
		};
	};
	DataObjectLite obj_y {
        	in => axis_y.out;
		Props {
			line_style => <-.<-.major_line_mode;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " y axis";
		};
	};
	DataObjectLite obj_z {
        	in => axis_z.out;
		Props {
			line_style => <-.<-.major_line_mode;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " z axis";
		};
	};
	DataObjectLite obj_x_minor {
        	in => axis_x.out_minor;
		Props {
			line_style => <-.<-.minor_line_mode;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " x minor grid";
		};
	};
	DataObjectLite obj_y_minor {
        	in => axis_y.out_minor;
		Props {
			line_style => <-.<-.minor_line_mode;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " y minor grid";
		};
	};
	DataObjectLite obj_z_minor {
        	in => axis_z.out_minor;
		Props {
			line_style => <-.<-.minor_line_mode;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " z minor grid";
		};
	};
	DataObjectLite obj_x_anno {
        	in => axis_x.out_anno;
		Props {
			font => <-.<-.font;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " x labels";
		};
	};
	DataObjectLite obj_y_anno {
        	in => axis_y.out_anno;
		Props {
			font => <-.<-.font;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " y labels";
		};
	};
	DataObjectLite obj_z_anno {
        	in => axis_z.out_anno;
		Props {
			font => <-.<-.font;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " z labels";
		};
	};
	DataObjectLite obj_x_name {
        	in => axis_x.out_name;
		Props {
			font => <-.<-.font;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+ " x name";
		};
	};
	DataObjectLite obj_y_name {
        	in => axis_y.out_name;
		Props {
			font => <-.<-.font;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+" y name";
		};
	};
	DataObjectLite obj_z_name {
        	in => axis_z.out_name;
		Props {
			font => <-.<-.font;
			inherit = 0;
		};
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+" z name";
		};
	};
	GroupObject obj {
        	child_objs => {obj_x.obj, obj_y.obj,  obj_z.obj,
				obj_x_minor.obj, obj_y_minor.obj,  obj_z_minor.obj, 
				obj_x_anno.obj, obj_y_anno.obj, obj_z_anno.obj,
				obj_x_name.obj, obj_y_name.obj, obj_z_name.obj};
		Top {
			xform_mode = GD_XFORM_MODE_PARENT;
			name => name_of(<-.<-.<-)+"_top";
		};
		Props {
		        jitter = 1;
		};

	};

	olink out_obj => obj.obj;
}; // Axis3D


macro Axis_Glyph2D<module_stack_menu=1> {
	Line  set1 {
	      ncells = 8;
	      node_connect_list = {0,1,1,2,1,3,0,4,4,5,4,6,7,8,7,9};
	};
	Mesh  axis {
   		int nnodes = 10;
	   	int nspace = 2;
   		coordinates {
      		float values[nvals][veclen] = {
         		{0,0},{1,0},{0.7,0.15},{0.7,-0.15},{0,1.05},{-0.15,0.75},{0.15,0.75},
			{0,0.85},{-0.15,0.55},{0.15,0.55}
      			};
   		};
  		int ncell_sets = 1;
   		cell_set[ncell_sets] => {set1};
	};
	UImod_panel panel {
		parent<NEportLevels={3,0}>;
		title => name_of(<-.<-);
		message = "Select axis control panel.";
		rowColumnBehavior = 1;
	};
	UItoggle xform_toggle {
	    parent => <-.panel;
	    label = "Transformation Editor";
	    y		=  0;
	    width	=> <-.panel.width;
	};
	XformEditor probe_edit {
		obj_in => <-.axis;
		vis => xform_toggle.set;
	};
	DataObjectLite obj {
        	in => axis;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => axis;
	olink out_obj => obj.obj;
}; // Axis_Glyph2D


macro Axis_Glyph3D<module_stack_menu=1> {
	Line  set1 {
	      ncells = 15;
	      node_connect_list = {0,1,1,2,1,3,0,4,4,5,4,6,7,8,7,9,
				   0,10,10,11,10,12,13,14,13,15,16,17,16,18};
	};
	Mesh  axis {
   		int nnodes = 19;
	   	int nspace = 3;
   		coordinates {
      		float values[nvals][veclen] = {
         		{0,0,0},{1,0,0},{0.7,0.15,0},{0.7,-0.15,0},{0,1.05,0},
			{-0.15,0.75,0},{0.15,0.75,0},
			{0,0.85,0},{-0.15,0.55,0},{0.15,0.55,0},
			{0,0,1.1},{-0.15,0,0.8},{0.15,0,0.8},{0,0,0.9},
			{-0.15,0,0.6},{0.15,0,0.6}, {0,0,0.7},{-0.15,0,0.4},{0.15,0,0.4}
      			};
   		};
  		int ncell_sets = 1;
   		cell_set[ncell_sets] => {set1};
	};
	UImod_panel panel {
		parent<NEportLevels={3,0}>;
		title => name_of(<-.<-);
		message = "Select axis control panel.";
	};
	UItoggle xform_toggle {
	    parent => <-.panel;
	    label = "Transformation Editor";
	    y		=  0;
	    width	=> <-.panel.width;
	};
	XformEditor probe_edit {
		obj_in => <-.axis;
		vis => xform_toggle.set;
	};
	DataObjectLite obj {
        	in => axis;
	};

	olink out_fld => axis;
	olink out_obj => obj.obj;
}; // Axis_Glyph3D


// Like a simple version of MODS.bounds, but it works
// on any 2D field.
macro BoundingBox2D {

    // Its better for the DV wizard if the input parameter has the
    // exact same name as the input to MODS.bounds.
    group+IPort2 &in_field {
        int nspace = 2;
        group coordinates {
            prim min_vec[2];
            prim max_vec[2];
        };
        group+opt xform;
    };

    Plane_Mesh+OPort plane {
        dims = { 2, 2 };
        points => {
            <-.in_field.coordinates.min_vec[0], <-.in_field.coordinates.min_vec[1],
            <-.in_field.coordinates.max_vec[0], <-.in_field.coordinates.max_vec[1] };
        &xform+nres => <-.in.xform;
    };

    DataObjectLite obj {
        in => <-.plane;
        Obj.name => name_of(<-.<-.<-);
        Modes {
            // Render the box as a wireframe
            mode = {0, GD_LINES, GD_NO_SURF, 0, 0};
        };
    };

    olink out_fld<export_all=2> => plane;
    olink out_obj => obj.obj;
}; // BoundingBox2D


// Like a simple version of MODS.bounds, but it works
// on any 3D field.
macro BoundingBox3D {

    // Its better for the DV wizard if the input parameter has the
    // exact same name as the input to MODS.bounds.
    group+IPort2 &in_field {
        int nspace = 3;
        group coordinates {
            prim min_vec[3];
            prim max_vec[3];
        };
        group+opt xform;
    };

    Box_Mesh+OPort box {
        dims = { 2, 2, 2 };
        points => {
            <-.in_field.coordinates.min_vec[0], <-.in_field.coordinates.min_vec[1], <-.in_field.coordinates.min_vec[2],
            <-.in_field.coordinates.max_vec[0], <-.in_field.coordinates.max_vec[1], <-.in_field.coordinates.max_vec[2] };
        &xform+nres => <-.in_field.xform;
    };

    DataObjectLite obj {
        in => <-.box;
        Obj.name => name_of(<-.<-.<-);
        Modes {
            // Render the box as a wireframe
            mode = {0, GD_LINES, GD_NO_SURF, 0, 0};
        };
    };

    olink out_fld<export_all=2> => box;
    olink out_obj => obj.obj;
}; // BoundingBox3D


macro TextString {
   Text text<export_all=2> {
      xform<NEportLevels={0,2}>;
      align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
      align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
      drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
      bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
      underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
      background<NEportLevels={2,0}> => <-.TextUI.Background.set;
      lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
      radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
      do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
      offset<NEportLevels={2,0}> => {<-.TextUI.OffsetXValue.fval,
				     <-.TextUI.OffsetYValue.fval,
				     <-.TextUI.OffsetZValue.fval};
      str<NEportLevels={2,0}> => <-.TextUI.String.text;
      nspace = 2;
      position[nspace] = {-0.5,0.5};
      StrokeTextAttribs {
	 font_type => <-.<-.TextUI.StrokeFontType.selectedItem;
	 plane => <-.<-.TextUI.StrokePlane.selectedItem;
	 orient => <-.<-.TextUI.StrokeOrient.selectedItem;
	 angle => <-.<-.TextUI.StrokeAngle.value;
	 path => <-.<-.TextUI.StrokePath.selectedItem;
	 space_mode => <-.<-.TextUI.StrokeSpaceMode.selectedItem;
	 spacing => <-.<-.TextUI.StrokeSpacing.value;
	 height => <-.<-.TextUI.StrokeHeight.value;
	 expansion => <-.<-.TextUI.StrokeExpansion.value;
      };
   };
   GD.DefaultObject DefaultObject<NEportLevels={1,2}> {
      input => <-.text;
      xform => <-.text.xform;
      props => <-.DefaultProps;
      pick_info => <-.DefaultPickInfo;
      name => name_of(<-.<-);
   };
   GDIF.DefaultProps DefaultProps {
      font<NEportLevels={2,0}> => <-.TextUI.Font.text;
      inherit = 0;
   };
   GDpick_info DefaultPickInfo;

   GMOD.instancer instancer {
      Value => UImod_panel.visible;
      active = 2; // don't de-instance when visible = 0
      Group => TextUI;
   };
   UI.UImod_panel UImod_panel {
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
      message = "Select control panel.";
   };

   macro TextUI<instanced=0> {
      int active_array[2] = {1,0};
      Controls.UIlabel UIlabel {
         parent => UImod_panel;
         label = "String";
         alignment = 0;
         y =  5;
         width = 45;
      };
      UItext String {
         parent => UImod_panel;
         text<NEportLevels={0,3}> = "Hello World";
         x =  50;
         y =  0;
         width	=> UImod_panel.width - 50;
         height = 60;
         multiLine = 1;
         updateMode = 3;
      };
      Controls.UIlabel UIlabel#1 {
         parent => UImod_panel;
         label = "Font";
         alignment = 0;
         y => <-.String.y + <-.String.height + 10;
         width	=  45;
      };
      UItext Font {
         parent => UImod_panel;
         text<NEportLevels={0,3}> = "-adobe-times-bold-r-*-*-20-*-*-*-*-*-*-*";
         x =  50;
         y => <-.String.y + <-.String.height + 5;
         width => UImod_panel.width - 50;
         active => <-.active_array[<-.StrokeText.set];
      };
      Panels.UIframe UIframe {
         parent => UImod_panel;
         y => <-.Font.y + <-.Font.height + 10;
         width	=> UImod_panel.width;
         height	=> <-.OffsetZValue.y + <-.OffsetZValue.height + 6;
      };
      Commands.UIoption UIoption {
         label = "Left";
         set = 1;
      };
      Commands.UIoption UIoption#1 {
         label = "Center";
      };
      Commands.UIoption UIoption#2 {
         label = "Right";
      };
      UIoptionMenu AlignHorizMenu {
         parent => <-.UIframe;
         cmdList => {<-.UIoption, <-.UIoption#1,<-.UIoption#2};
         label = "Align Horizontal";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y =  2;
         width	=> <-.UIframe.clientWidth - 8;
      };
      Commands.UIoption UIoption#3 {
         label = "Base";
         set = 1;
      };
      Commands.UIoption UIoption#4 {
         label = "Bottom";
      };
      Commands.UIoption UIoption#5 {
         label = "Center";
      };
      Commands.UIoption UIoption#6 {
         label = "Top";
      };
      UIoptionMenu AlignVertMenu {
         parent => <-.UIframe;
         cmdList => {<-.UIoption#3,
            <-.UIoption#4,<-.UIoption#5,<-.UIoption#6};
         label = "Align Vertical";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.AlignHorizMenu.y + <-.AlignHorizMenu.height + 4;
         width	=> <-.UIframe.clientWidth - 8;
      };
      UItoggle DropShadow {
         parent => <-.UIframe;
         label = "Drop Shadow";
         alignment = 0;
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.AlignVertMenu.y + <-.AlignVertMenu.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Bounds {
         parent => <-.UIframe;
         label = "Bounds";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.DropShadow.y + <-.DropShadow.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Underline {
         parent => <-.UIframe;
         label = "Underline";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Bounds.y + <-.Bounds.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Background {
         parent => <-.UIframe;
         label = "Background";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Underline.y + <-.Underline.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Leadline {
         parent => <-.UIframe;
         label = "Leadline";
         set<NEportLevels={0,3}>;
         x = 4;
         y => <-.Background.y + <-.Background.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Radial {
         parent => <-.UIframe;
         label = "Radial";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Leadline.y + <-.Leadline.height + 5;
         width  => <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Offset {
         parent => <-.UIframe;
         label = "Offset";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Radial.y + <-.Radial.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      float x_offset = 0.05;
      float y_offset = 0.05;
      float z_offset = 0.0;
      UIfieldTypein OffsetXValue {
         UIparent => <-.UIframe;
         flabel = "X Offset";
         fval => <-.x_offset;
         fmin = -5;
         fmax = 5;
         y => <-.Offset.y + <-.Offset.height + 4;
         width = 180;
         height => field.height + 6;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };
      UIfieldTypein OffsetYValue {
         UIparent => <-.UIframe;
         flabel = "Y Offset";
         fval => <-.y_offset;
         fmin = -5;
         fmax = 5;
         width = 180;
         height => field.height + 6;
         y => <-.OffsetXValue.y + <-.OffsetXValue.height + 1;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };
      UIfieldTypein OffsetZValue {
         UIparent => <-.UIframe;
         flabel = "Z Offset";
         fval => <-.z_offset;
         fmin = -5;
         fmax = 5;
         width = 180;
         height => field.height + 6;
         y => <-.OffsetYValue.y + <-.OffsetYValue.height + 1;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };

      /* UI widgets associated with the stroke text attributes. */
      UItoggle StrokeText {
         parent => UImod_panel;
         label = "StrokeText";
         y => <-.UIframe.y + <-.UIframe.height + 5;
         width	=> UImod_panel.clientWidth - 50;
	 set => <-.<-.text.stroke;
      };
      Panels.UIframe StrokeFrame {
         parent => UImod_panel;
         y => <-.StrokeText.y + <-.StrokeText.height + 10;
         width	=> UImod_panel.clientWidth;
         height	=> <-.StrokeExpansion.y + <-.StrokeExpansion.height + 6;
         visible   => <-.StrokeText.set;
      };
      UIoptionMenu StrokeFontType {
         parent => <-.StrokeFrame;
         cmdList => {<-.Font1, <-.Font2, <-.Font3, <-.Font4, 
	   <-.Font5, <-.Font6, <-.Font7, <-.Font8, <-.Font9, <-.Font10};
         label = "Font Type";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y =  0;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption Font1 {
         label = "Roman Simplex";
         set = 1;
      };
      Commands.UIoption Font2 {
         label = "Roman Duplex";
      };
      Commands.UIoption Font3 {
         label = "Roman Triplex";
      };
      Commands.UIoption Font4 {
         label = "Roman Complex";
      };
      Commands.UIoption Font5 {
         label = "Script Simplex";
      };
      Commands.UIoption Font6 {
         label = "Script Complex";
      };
      Commands.UIoption Font7 {
         label = "Italics Triplex";
      };
      Commands.UIoption Font8 {
         label = "Italics Duplex";
      };
      Commands.UIoption Font9 {
         label = "Greek Simplex";
      };
      Commands.UIoption Font10 {
         label = "Greek Complex";
      };
      UIoptionMenu StrokePlane {
         parent => <-.StrokeFrame;
         cmdList => {<-.XYplane, <-.XZplane, <-.YZplane};
         label = "Plane";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokeFontType.y + <-.StrokeFontType.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption XYplane {
         label = "XY";
         set = 1;
      };
      Commands.UIoption XZplane {
         label = "XZ";
      };
      Commands.UIoption YZplane {
         label = "YZ";
      };
      UIoptionMenu StrokeOrient {
         parent => <-.StrokeFrame;
         cmdList => {<-.LRorient, <-.UPorient, <-.RLorient, <-.DOWNorient, <-.ARBorient};
         label = "Orientation";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokePlane.y + <-.StrokePlane.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption LRorient {
         label = "Left-to-Right";
         set = 1;
      };
      Commands.UIoption UPorient {
         label = "Up";
      };
      Commands.UIoption RLorient {
         label = "Right-to-Left";
      };
      Commands.UIoption DOWNorient {
         label = "Down";
      };
      Commands.UIoption ARBorient {
         label = "Arbitrary";
      };
      UIslider StrokeAngle {
         parent => <-.StrokeFrame;
         title = "Angle";
         x = 4;
         y => <-.StrokeOrient.y + <-.StrokeOrient.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = -180.0;
         max = 180.0;
         value = 0.0;
         active => switch((StrokeOrient.selectedItem == 4) + 1, 0, 1);
      };
      UIoptionMenu StrokePath {
         parent => <-.StrokeFrame;
         cmdList => {<-.LRpath, <-.UPpath, <-.RLpath, <-.DOWNpath};
         label = "Path";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokeAngle.y + <-.StrokeAngle.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption LRpath {
         label = "Left-to-Right";
         set = 1;
      };
      Commands.UIoption UPpath{
         label = "Up";
      };
      Commands.UIoption RLpath{
         label = "Right-to-Left";
      };
      Commands.UIoption DOWNpath{
         label = "Down";
      };
      UIoptionMenu StrokeSpaceMode {
         parent => <-.StrokeFrame;
         cmdList => {<-.FixedSpace, <-.PropSpace};
         label = "Spacing Mode";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 1;
         x =  4;
         y => <-.StrokePath.y + <-.StrokePath.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption FixedSpace {
         label = "Fixed";
      };
      Commands.UIoption PropSpace {
         label = "Proportional";
         set = 1;
      };
      UIslider StrokeSpacing {
         parent => <-.StrokeFrame;
         title = "Spacing";
         x = 4;
         y => <-.StrokeSpaceMode.y + <-.StrokeSpaceMode.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.0;
         max = 3.0;
         value = 0.0;
      };
      UIslider StrokeHeight {
         parent => <-.StrokeFrame;
         title = "Height";
         x = 4;
         y => <-.StrokeSpacing.y + <-.StrokeSpacing.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.01;
         max = 10.0;
         value = 1.0;
      };
      UIslider StrokeExpansion {
         parent => <-.StrokeFrame;
         title = "Expansion";
         x = 4;
         y => <-.StrokeHeight.y + <-.StrokeHeight.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.25;
         max = 3.0;
         value = 1.0;
      };
   };
}; // TextString


macro TextString3D {
   Text text<export_all=2> {
      xform<NEportLevels={0,2}>;
      align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
      align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
      drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
      bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
      underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
      background<NEportLevels={2,0}> => <-.TextUI.Background.set;
      lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
      radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
      do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
      offset<NEportLevels={2,0}> => {<-.TextUI.OffsetXValue.fval,
				     <-.TextUI.OffsetYValue.fval,
				     <-.TextUI.OffsetZValue.fval};
      xform_mode;
      str<NEportLevels={2,0}> => <-.TextUI.String.text;
      nspace = 3 ;
      position = {-0.5,0.5,0.5};
      StrokeTextAttribs {
	 font_type => <-.<-.TextUI.StrokeFontType.selectedItem;
	 plane => <-.<-.TextUI.StrokePlane.selectedItem;
	 orient => <-.<-.TextUI.StrokeOrient.selectedItem;
	 angle => <-.<-.TextUI.StrokeAngle.value;
	 path => <-.<-.TextUI.StrokePath.selectedItem;
	 space_mode => <-.<-.TextUI.StrokeSpaceMode.selectedItem;
	 spacing => <-.<-.TextUI.StrokeSpacing.value;
	 height => <-.<-.TextUI.StrokeHeight.value;
	 expansion => <-.<-.TextUI.StrokeExpansion.value;
      };
   };
   GD.DefaultObject DefaultObject<NEportLevels={1,2}> {
      input => <-.text;
      xform => <-.text.xform;
      props => <-.DefaultProps;
      pick_info => <-.DefaultPickInfo;
      name => name_of(<-.<-);
   };
   GDIF.DefaultProps DefaultProps {
      font<NEportLevels={2,0}> => <-.TextUI.Font.text;
      inherit = 0;
   };
   GDpick_info DefaultPickInfo;

   GMOD.instancer instancer {
      Value => UImod_panel.visible;
      active = 2; // don't de-instance when visible = 0
      Group => TextUI;
   };
   UI.UImod_panel UImod_panel {
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
      message = "Select control panel.";
   };
   macro TextUI<instanced=0> {
      int active_array[2] = {1,0};
      Controls.UIlabel UIlabel {
         parent => UImod_panel;
         label = "String";
         alignment = 0;
         y =  5;
         width = 45;
      };
      UItext String {
         parent => UImod_panel;
         text<NEportLevels={0,3}> = "Hello World";
         x =  50;
         y =  0;
         width	=> UImod_panel.width - 50;
         height = 60;
         multiLine = 1;
         updateMode = 3;
      };
      Controls.UIlabel UIlabel#1 {
         parent => UImod_panel;
         label = "Font";
         alignment = 0;
         y => <-.String.y + <-.String.height + 10;
         width	=  45;
      };
      UItext Font {
         parent => UImod_panel;
         text<NEportLevels={0,3}> = "-adobe-times-bold-r-*-*-20-*-*-*-*-*-*-*";
         x =  50;
         y => <-.String.y + <-.String.height + 5;
         width => UImod_panel.width - 50;
         active => <-.active_array[<-.StrokeText.set];
      };
      Panels.UIframe UIframe {
         parent => UImod_panel;
         y => <-.Font.y + <-.Font.height + 10;
         width	=> UImod_panel.width;
         height	=> <-.OffsetZValue.y + <-.OffsetZValue.height + 6;
      };
      Commands.UIoption UIoption {
         label = "Left";
         set = 1;
      };
      Commands.UIoption UIoption#1 {
         label = "Center";
      };
      Commands.UIoption UIoption#2 {
         label = "Right";
      };
      UIoptionMenu AlignHorizMenu {
         parent => <-.UIframe;
         cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2};
         label = "Align Horizontal";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y =  2;
         width	=> <-.UIframe.clientWidth - 8;
      };
      Commands.UIoption UIoption#3 {
         label = "Base";
         set = 1;
      };
      Commands.UIoption UIoption#4 {
         label = "Bottom";
      };
      Commands.UIoption UIoption#5 {
         label = "Center";
      };
      Commands.UIoption UIoption#6 {
         label = "Top";
      };
      UIoptionMenu AlignVertMenu {
         parent => <-.UIframe;
         cmdList => {<-.UIoption#3,
            <-.UIoption#4,<-.UIoption#5,<-.UIoption#6};
         label = "Align Vertical";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.AlignHorizMenu.y + <-.AlignHorizMenu.height + 4;
         width	=> <-.UIframe.clientWidth - 8;
      };
      UItoggle DropShadow {
         parent => <-.UIframe;
         label = "Drop Shadow";
         alignment = 0;
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.AlignVertMenu.y + <-.AlignVertMenu.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Bounds {
         parent => <-.UIframe;
         label = "Bounds";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.DropShadow.y + <-.DropShadow.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Underline {
         parent => <-.UIframe;
         label = "Underline";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Bounds.y + <-.Bounds.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Background {
         parent => <-.UIframe;
         label = "Background";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Underline.y + <-.Underline.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Leadline {
         parent => <-.UIframe;
         label = "Leadline";
         set<NEportLevels={0,3}>;
         x = 4;
         y => <-.Background.y + <-.Background.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Radial {
         parent => <-.UIframe;
         label = "Radial";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Leadline.y + <-.Leadline.height + 5;
         width  => <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Offset {
         parent => <-.UIframe;
         label = "Offset";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Radial.y + <-.Radial.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      float x_offset = 0.05;
      float y_offset = 0.05;
      float z_offset = 0.0;
      UIfieldTypein OffsetXValue {
         UIparent => <-.UIframe;
         flabel = "X Offset";
         fval => <-.x_offset;
         fmin = -5;
         fmax = 5;
         y => <-.Offset.y + <-.Offset.height + 4;
         width = 180;
         height => field.height + 6;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };
      UIfieldTypein OffsetYValue {
         UIparent => <-.UIframe;
         flabel = "Y Offset";
         fval => <-.y_offset;
         fmin = -5;
         fmax = 5;
         width = 180;
         height => field.height + 6;
         y => <-.OffsetXValue.y + <-.OffsetXValue.height + 1;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };
      UIfieldTypein OffsetZValue {
         UIparent => <-.UIframe;
         flabel = "Z Offset";
         fval => <-.z_offset;
         fmin = -5;
         fmax = 5;
         width = 180;
         height => field.height + 6;
         y => <-.OffsetYValue.y + <-.OffsetYValue.height + 1;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };

      /* UI widgets associated with the stroke text attributes. */
      UItoggle StrokeText {
         parent => UImod_panel;
         label = "StrokeText";
         y => <-.UIframe.y + <-.UIframe.height + 5;
         width	=> UImod_panel.clientWidth - 50;
	 set => <-.<-.text.stroke;
      };
      Panels.UIframe StrokeFrame {
         parent => UImod_panel;
         y => <-.StrokeText.y + <-.StrokeText.height + 10;
         width	=> UImod_panel.clientWidth;
         height	=> <-.StrokeExpansion.y + <-.StrokeExpansion.height + 6;
         visible   => <-.StrokeText.set;
      };
      UIoptionMenu StrokeFontType {
         parent => <-.StrokeFrame;
         cmdList => {<-.Font1, <-.Font2, <-.Font3, <-.Font4, 
	   <-.Font5, <-.Font6, <-.Font7, <-.Font8, <-.Font9, <-.Font10};
         label = "Font Type";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y =  0;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption Font1 {
         label = "Roman Simplex";
         set = 1;
      };
      Commands.UIoption Font2 {
         label = "Roman Duplex";
      };
      Commands.UIoption Font3 {
         label = "Roman Triplex";
      };
      Commands.UIoption Font4 {
         label = "Roman Complex";
      };
      Commands.UIoption Font5 {
         label = "Script Simplex";
      };
      Commands.UIoption Font6 {
         label = "Script Complex";
      };
      Commands.UIoption Font7 {
         label = "Italics Triplex";
      };
      Commands.UIoption Font8 {
         label = "Italics Duplex";
      };
      Commands.UIoption Font9 {
         label = "Greek Simplex";
      };
      Commands.UIoption Font10 {
         label = "Greek Complex";
      };
      UIoptionMenu StrokePlane {
         parent => <-.StrokeFrame;
         cmdList => {<-.XYplane, <-.XZplane, <-.YZplane};
         label = "Plane";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokeFontType.y + <-.StrokeFontType.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption XYplane {
         label = "XY";
         set = 1;
      };
      Commands.UIoption XZplane {
         label = "XZ";
      };
      Commands.UIoption YZplane {
         label = "YZ";
      };
      UIoptionMenu StrokeOrient {
         parent => <-.StrokeFrame;
         cmdList => {<-.LRorient, <-.UPorient, <-.RLorient, <-.DOWNorient, <-.ARBorient};
         label = "Orientation";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokePlane.y + <-.StrokePlane.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption LRorient {
         label = "Left-to-Right";
         set = 1;
      };
      Commands.UIoption UPorient {
         label = "Up";
      };
      Commands.UIoption RLorient {
         label = "Right-to-Left";
      };
      Commands.UIoption DOWNorient {
         label = "Down";
      };
      Commands.UIoption ARBorient {
         label = "Arbitrary";
      };
      UIslider StrokeAngle {
         parent => <-.StrokeFrame;
         title = "Angle";
         x = 4;
         y => <-.StrokeOrient.y + <-.StrokeOrient.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = -180.0;
         max = 180.0;
         value = 0.0;
         active => switch((StrokeOrient.selectedItem == 4) + 1, 0, 1);
      };
      UIoptionMenu StrokePath {
         parent => <-.StrokeFrame;
         cmdList => {<-.LRpath, <-.UPpath, <-.RLpath, <-.DOWNpath};
         label = "Path";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokeAngle.y + <-.StrokeAngle.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption LRpath {
         label = "Left-to-Right";
         set = 1;
      };
      Commands.UIoption UPpath {
         label = "Up";
      };
      Commands.UIoption RLpath{
         label = "Right-to-Left";
      };
      Commands.UIoption DOWNpath {
         label = "Down";
      };
      UIoptionMenu StrokeSpaceMode {
         parent => <-.StrokeFrame;
         cmdList => {<-.FixedSpace, <-.PropSpace};
         label = "Spacing Mode";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 1;
         x =  4;
         y => <-.StrokePath.y + <-.StrokePath.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption FixedSpace {
         label = "Fixed";
      };
      Commands.UIoption PropSpace {
         label = "Proportional";
         set = 1;
      };
      UIslider StrokeSpacing {
         parent => <-.StrokeFrame;
         title = "Spacing";
         x = 4;
         y => <-.StrokeSpaceMode.y + <-.StrokeSpaceMode.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.0;
         max = 3.0;
         value = 0.0;
      };
      UIslider StrokeHeight {
         parent => <-.StrokeFrame;
         title = "Height";
         x = 4;
         y => <-.StrokeSpacing.y + <-.StrokeSpacing.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.01;
         max = 10.0;
         value = 1.0;
      };
      UIslider StrokeExpansion {
         parent => <-.StrokeFrame;
         title = "Expansion";
         x = 4;
         y => <-.StrokeHeight.y + <-.StrokeHeight.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.25;
         max = 3.0;
         value = 1.0;
      };
   };
}; // TextString3D


macro TextTitle {
   Text text<export_all=2> {
      xform<NEportLevels={0,2}>;
      align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
      align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
      drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
      bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
      underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
      background<NEportLevels={2,0}> => <-.TextUI.Background.set;
      lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
      radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
      do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
      offset<NEportLevels={2,0}> => {<-.TextUI.OffsetXValue.fval,
				     <-.TextUI.OffsetYValue.fval,
				     <-.TextUI.OffsetZValue.fval};
      str<NEportLevels={2,0}> => <-.TextUI.String.text;
      nspace = 3 ;
      position = {0.0,0.7,0.99};
      StrokeTextAttribs {
	 font_type => <-.<-.TextUI.StrokeFontType.selectedItem;
	 plane => <-.<-.TextUI.StrokePlane.selectedItem;
	 orient => <-.<-.TextUI.StrokeOrient.selectedItem;
	 angle => <-.<-.TextUI.StrokeAngle.value;
	 path => <-.<-.TextUI.StrokePath.selectedItem;
	 space_mode => <-.<-.TextUI.StrokeSpaceMode.selectedItem;
	 spacing => <-.<-.TextUI.StrokeSpacing.value;
	 height => <-.<-.TextUI.StrokeHeight.value;
	 expansion => <-.<-.TextUI.StrokeExpansion.value;
      };
   };
   GD.DefaultObject DefaultObject<NEportLevels={1,2}> {
      input => <-.text;
      xform => <-.text.xform;
      xform_mode = GD_XFORM_MODE_LOCKED;
      props => <-.DefaultProps;
      pick_info => <-.DefaultPickInfo;
      name => name_of(<-.<-);
   };
   GDIF.DefaultProps DefaultProps {
      font<NEportLevels={2,0}> => <-.TextUI.Font.text;
      inherit = 0;
   };
   GDpick_info DefaultPickInfo;
   GMOD.instancer instancer {
      Value => UImod_panel.visible;
      active = 2; // don't de-instance when visible = 0
      Group => TextUI;
   };
   UI.UImod_panel UImod_panel {
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
      message = "Select control panel.";
   };
   macro TextUI<instanced=0> {
      int active_array[2] = {1,0};
      Controls.UIlabel UIlabel {
         parent => UImod_panel;
         label = "String";
         alignment = 0;
         y =  5;
         width = 45;
      };
      UItext String {
         parent => UImod_panel;
         text<NEportLevels={0,3}> = "Text Title";
         x =  50;
         y =  0;
         width	=> UImod_panel.width - 50;
         height = 60;
         multiLine = 1;
         updateMode = 3;
      };
      Controls.UIlabel UIlabel#1 {
         parent => UImod_panel;
         label = "Font";
         alignment = 0;
         y => <-.String.y + <-.String.height + 10;
         width	=  45;
      };
      UItext Font {
         parent => UImod_panel;
         text<NEportLevels={0,3}> = "-adobe-times-bold-r-*-*-40-*-*-*-*-*-*-*";
         x =  50;
         y => <-.String.y + <-.String.height + 5;
         width => UImod_panel.width - 50;
         active => <-.active_array[<-.StrokeText.set];
      };
      Panels.UIframe UIframe {
         parent => UImod_panel;
         y => <-.Font.y + <-.Font.height + 10;
         width	=> UImod_panel.width;
         height	=> <-.OffsetZValue.y + <-.OffsetZValue.height + 6;
      };
      Commands.UIoption UIoption {
         label = "Left";
         set = 1;
      };
      Commands.UIoption UIoption#1 {
         label = "Center";
      };
      Commands.UIoption UIoption#2 {
         label = "Right";
      };
      UIoptionMenu AlignHorizMenu {
         parent => <-.UIframe;
         cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2};
         label = "Align Horizontal";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 1;
         x =  4;
         y =  2;
         width	=> <-.UIframe.clientWidth - 8;
      };
      Commands.UIoption UIoption#3 {
         label = "Base";
         set = 1;
      };
      Commands.UIoption UIoption#4 {
         label = "Bottom";
      };
      Commands.UIoption UIoption#5 {
         label = "Center";
      };
      Commands.UIoption UIoption#6 {
         label = "Top";
      };
      UIoptionMenu AlignVertMenu {
         parent => <-.UIframe;
         cmdList => {<-.UIoption#3,
            <-.UIoption#4,<-.UIoption#5,<-.UIoption#6};
         label = "Align Vertical";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.AlignHorizMenu.y + <-.AlignHorizMenu.height + 4;
         width	=> <-.UIframe.clientWidth - 8;
      };
      UItoggle DropShadow {
         parent => <-.UIframe;
         label = "Drop Shadow";
         alignment = 0;
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.AlignVertMenu.y + <-.AlignVertMenu.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Bounds {
         parent => <-.UIframe;
         label = "Bounds";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.DropShadow.y + <-.DropShadow.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Underline {
         parent => <-.UIframe;
         label = "Underline";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Bounds.y + <-.Bounds.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Background {
         parent => <-.UIframe;
         label = "Background";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Underline.y + <-.Underline.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Leadline {
         parent => <-.UIframe;
         label = "Leadline";
         set<NEportLevels={0,3}>;
         x = 4;
         y => <-.Background.y + <-.Background.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Radial {
         parent => <-.UIframe;
         label = "Radial";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Leadline.y + <-.Leadline.height + 5;
         width  => <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      UItoggle Offset {
         parent => <-.UIframe;
         label = "Offset";
         set<NEportLevels={0,3}>;
         x =  4;
         y => <-.Radial.y + <-.Radial.height + 5;
         width	=> <-.UIframe.clientWidth - 8;
         active => <-.active_array[<-.StrokeText.set];
      };
      float x_offset = 0.05;
      float y_offset = 0.05;
      float z_offset = 0.0;
      UIfieldTypein OffsetXValue {
         UIparent => <-.UIframe;
         flabel = "X Offset";
         fval => <-.x_offset;
         fmin = -5;
         fmax = 5;
         y => <-.Offset.y + <-.Offset.height + 4;
         width = 180;
         height => field.height + 6;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };
      UIfieldTypein OffsetYValue {
         UIparent => <-.UIframe;
         flabel = "Y Offset";
         fval => <-.y_offset;
         fmin = -5;
         fmax = 5;
         width = 180;
         height => field.height + 6;
         y => <-.OffsetXValue.y + <-.OffsetXValue.height + 1;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };
      UIfieldTypein OffsetZValue {
         UIparent => <-.UIframe;
         flabel = "Z Offset";
         fval => <-.z_offset;
         fmin = -5;
         fmax = 5;
         width = 180;
         height => field.height + 6;
         y => <-.OffsetYValue.y + <-.OffsetYValue.height + 1;
         label.alignment = 1;
         label.active => <-.<-.active_array[<-.<-.StrokeText.set];
         field.active => <-.<-.active_array[<-.<-.StrokeText.set];
      };

      /* UI widgets associated with the stroke text attributes. */
      UItoggle StrokeText {
         parent => UImod_panel;
         label = "StrokeText";
         y => <-.UIframe.y + <-.UIframe.height + 5;
         width	=> UImod_panel.clientWidth - 50;
	 set => <-.<-.text.stroke;
      };
      Panels.UIframe StrokeFrame {
         parent => UImod_panel;
         y => <-.StrokeText.y + <-.StrokeText.height + 10;
         width	=> UImod_panel.clientWidth;
         height	=> <-.StrokeExpansion.y + <-.StrokeExpansion.height + 6;
         visible   => <-.StrokeText.set;
      };
      UIoptionMenu StrokeFontType {
         parent => <-.StrokeFrame;
         cmdList => {<-.Font1, <-.Font2, <-.Font3, <-.Font4, 
	   <-.Font5, <-.Font6, <-.Font7, <-.Font8, <-.Font9, <-.Font10};
         label = "Font Type";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y =  0;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption Font1 {
         label = "Roman Simplex";
         set = 1;
      };
      Commands.UIoption Font2 {
         label = "Roman Duplex";
      };
      Commands.UIoption Font3 {
         label = "Roman Triplex";
      };
      Commands.UIoption Font4 {
         label = "Roman Complex";
      };
      Commands.UIoption Font5 {
         label = "Script Simplex";
      };
      Commands.UIoption Font6 {
         label = "Script Complex";
      };
      Commands.UIoption Font7 {
         label = "Italics Triplex";
      };
      Commands.UIoption Font8 {
         label = "Italics Duplex";
      };
      Commands.UIoption Font9 {
         label = "Greek Simplex";
      };
      Commands.UIoption Font10 {
         label = "Greek Complex";
      };
      UIoptionMenu StrokePlane {
         parent => <-.StrokeFrame;
         cmdList => {<-.XYplane, <-.XZplane, <-.YZplane};
         label = "Plane";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokeFontType.y + <-.StrokeFontType.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption XYplane {
         label = "XY";
         set = 1;
      };
      Commands.UIoption XZplane {
         label = "XZ";
      };
      Commands.UIoption YZplane {
         label = "YZ";
      };
      UIoptionMenu StrokeOrient {
         parent => <-.StrokeFrame;
         cmdList => {<-.LRorient, <-.UPorient, <-.RLorient, <-.DOWNorient, <-.ARBorient};
         label = "Orientation";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokePlane.y + <-.StrokePlane.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption LRorient {
         label = "Left-to-Right";
         set = 1;
      };
      Commands.UIoption UPorient {
         label = "Up";
      };
      Commands.UIoption RLorient {
         label = "Right-to-Left";
      };
      Commands.UIoption DOWNorient {
         label = "Down";
      };
      Commands.UIoption ARBorient {
         label = "Arbitrary";
      };
      UIslider StrokeAngle {
         parent => <-.StrokeFrame;
         title = "Angle";
         x = 4;
         y => <-.StrokeOrient.y + <-.StrokeOrient.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = -180.0;
         max = 180.0;
         value = 0.0;
         active => switch((StrokeOrient.selectedItem == 4) + 1, 0, 1);
      };
      UIoptionMenu StrokePath {
         parent => <-.StrokeFrame;
         cmdList => {<-.LRpath, <-.UPpath, <-.RLpath, <-.DOWNpath};
         label = "Path";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 0;
         x =  4;
         y => <-.StrokeAngle.y + <-.StrokeAngle.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption LRpath {
         label = "Left-to-Right";
         set = 1;
      };
      Commands.UIoption UPpath {
         label = "Up";
      };
      Commands.UIoption RLpath {
         label = "Right-to-Left";
      };
      Commands.UIoption DOWNpath {
         label = "Down";
      };
      UIoptionMenu StrokeSpaceMode {
         parent => <-.StrokeFrame;
         cmdList => {<-.FixedSpace, <-.PropSpace};
         label = "Spacing Mode";
         alignment = 0;
         selectedItem<NEportLevels={0,3}> = 1;
         x =  4;
         y => <-.StrokePath.y + <-.StrokePath.height + 5;
         width => <-.StrokeFrame.clientWidth - 8;
      };
      Commands.UIoption FixedSpace {
         label = "Fixed";
      };
      Commands.UIoption PropSpace {
         label = "Proportional";
         set = 1;
      };
      UIslider StrokeSpacing {
         parent => <-.StrokeFrame;
         title = "Spacing";
         x = 4;
         y => <-.StrokeSpaceMode.y + <-.StrokeSpaceMode.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.0;
         max = 3.0;
         value = 0.0;
      };
      UIslider StrokeHeight {
         parent => <-.StrokeFrame;
         title = "Height";
         x = 4;
         y => <-.StrokeSpacing.y + <-.StrokeSpacing.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.01;
         max = 10.0;
         value = 1.0;
      };
      UIslider StrokeExpansion {
         parent => <-.StrokeFrame;
         title = "Expansion";
         x = 4;
         y => <-.StrokeHeight.y + <-.StrokeHeight.height + 5;
         width => UImod_panel.clientWidth - 50;
         min = 0.25;
         max = 3.0;
         value = 1.0;
      };
   };
}; // TextTitle


macro Cross2D {
	Line  set1 {
	   ncells = 2;
	   node_connect_list = {0,1,2,3};
	};
	Mesh  cross {
	   int nnodes = 4;
	   int nspace = 2;
	   coordinates {
	      float values[nvals][veclen] = {
	         {-0.5,0},{0.5,0},{0,-0.5},{0,0.5}
	      };
	   };
	   int ncell_sets = 1;
	   cell_set[ncell_sets] => {set1};
	};
	DataObjectLite obj {
        	in => cross;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => cross;
	olink out_obj => obj.obj;
}; // Cross2D

macro Cross3D {
	Line  set1 {
	   ncells = 3;
	   node_connect_list = {0,1,2,3,4,5};
	};
	Mesh  cross {
	   int nnodes = 6;
	   int nspace = 3;
	   coordinates {
	      float values[nvals][veclen] = {
	         {-0.5,0,0},{0.5,0,0},{0,-0.5,0},{0,0.5,0},{0,0,-0.5},{0,0,0.5}
	      };
	   };
	   int ncell_sets = 1;
	   cell_set[ncell_sets] => {set1};
	};
	DataObjectLite obj {
        	in => cross;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => cross;
	olink out_obj => obj.obj;
}; // Cross3D

macro Arrow1 {
	Line  set1 {
	      ncells = 3;
	      node_connect_list = {0,1,1,2,1,3};
	};
	Mesh  glyph1 {
   		int nnodes = 4;
	   	int nspace = 3;
   		coordinates {
      		float values[nvals][veclen] = {
         		{0,0,0},{1,0,0},{0.7,0.15,0},{0.7,-0.15,0}
      			};
   		};
  		int ncell_sets = 1;
   		cell_set[ncell_sets] => {set1};
	};
	DataObjectLite obj {
        	in => glyph1;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => glyph1;
	olink out_obj => obj.obj;
}; // Arrow1

macro Arrow2 {
	Quad  set1 {
	      ncells = 1;
	      node_connect_list = {0,1,2,3};
	};
	Tri set2 {
	      ncells = 1;
	      node_connect_list = {4,5,6};
	};
	Mesh  glyph2 {
   		int nnodes = 7;
		int nspace = 3;
   		coordinates {
      		float values[nvals][veclen] = {
         		{0,-0.1,0},{0.7,-0.1,0},{0.7,0.1,0},{0,0.1,0},
			{0.7,-0.17,0},{1,0,0},{0.7,0.17,0}
      			};
   		};
		int ncell_sets = 2;
		cell_set[ncell_sets] => {set1, set2 };
	};
	DataObjectLite obj {
        	in => glyph2;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => glyph2;
	olink out_obj => obj.obj;
}; // Arrow2

macro Arrow3 {
	Line set1 {
	   	ncells = 4;
	  	node_connect_list = {0,1, 1,2, 1,3, 1,4};
	};
	Mesh arrow3 {
   	      	int nnodes = 5;
	      	int nspace = 3;
   	      	coordinates {
		      float values[nvals][veclen] = {
		         {0,0,0},{1,0,0},
		         { 0.7,  0.15, 0.0},
		         { 0.7, -0.15,-0.15},
		         { 0.7, -0.15, 0.15}
	      	      };
	      	};
	      	int ncell_sets = 1;
              	cell_set[ncell_sets] => {set1};
	};
	DataObjectLite obj {
        	in => arrow3;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => arrow3;
	olink out_obj => obj.obj;
}; // Arrow3

macro Arrow4 {
        float radius<export=2> = 0.15;
        int subdiv<export=2> = 4;
	float cone_height<export=2> = 0.3;
        float height<export=2> = 1.0;

	macro cone_ui {
		ilink isubdiv => subdiv;
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select cone control panel.";
		};
		UIslider SubDiv {
        		parent => panel;
		        title = "Base subdivision";
			min = 3;
			max = 64;
			value => isubdiv;
			mode = 1;
			y = 0;
			width => <-.panel.width;
		};
	};

	macro cone {
		float ang[subdiv+1] => init_array(subdiv+1, 0, 2*PI);
		float x[subdiv+1][1] => init_array(subdiv+1, height-cone_height,
						   height-cone_height);
        	float y[subdiv+1][1] => radius*cos(ang);
        	float z[subdiv+1][1] => radius*sin(ang);
		float xyz_circle[subdiv+1][3] => combine_array(x,y,z);
		float xyz_tip[3] => {height, 0, 0};
		int conn0[subdiv+1][1] => init_array(subdiv+1, 0, 0);
		int conn1[subdiv+1][1] => init_array(subdiv+1, 1, subdiv+1);
		int c21[subdiv][1]=>conn1[1:subdiv][];
		int c22[1][1] = {1};
		int conn2[subdiv+1][1] => concat_array(c21,c22);

		int+OPort2 nxyz => subdiv+2;
		int+OPort2 ntri => subdiv+1;
		float+OPort2 xyz[nxyz][3] => concat_array(xyz_tip,xyz_circle);
		int+OPort2 connect[3*(subdiv+1)] => combine_array(conn0, conn1,
								  conn2);
	};

	macro line {
		int+OPort2 nlines = 2;
		int+OPort2 nxyz = 2;
		float xyz[2][3]=> {{0,0,0},{height,0,0}};
		int+OPort2 connect[2] => {<-.cone.nxyz,<-.cone.nxyz+1};
	};

        Line line_set {
                ncells = 1;
                node_connect_list => <-.line.connect;
        };
	Tri tri_set {
                ncells => <-.cone.ntri;
                node_connect_list => <-.cone.connect;
        };
        Mesh arrow4 {
                int nnodes =>  <-.line.nxyz + <-.cone.nxyz;
                int nspace = 3;
                coordinates {
                      values => concat_array(cone.xyz, line.xyz);
                };
                int ncell_sets = 2;
                cell_set[ncell_sets] => {line_set, tri_set};
        };

        DataObjectLite obj {
                in => arrow4;
                Obj {
                        name => name_of(<-.<-.<-);
                };
		Modes {
	    		mode = {0,GD_LINES,0,0,0};
			outline = GD_OUTLINE_OFF;
		};
        };
        olink out_fld => arrow4;
        olink out_obj => obj.obj;
}; // Arrow4

macro Diamond2D {
	Quad  set1 {
	   	ncells = 1;
	   	node_connect_list = {0,1,2,3};
	};
	Mesh  diamond {
   	      	int nnodes = 4;
	      	int nspace = 2;
   	      	coordinates {
      			float values[nvals][veclen] = {
         	   	{-0.5,0},{0,-0.5},{0.5,0},{0,0.5}
		 	};
	      	};
	      	int ncell_sets = 1;
              	cell_set[ncell_sets] => {set1};
	};
	DataObjectLite obj {
        	in => diamond;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => diamond;
	olink out_obj => obj.obj;
}; // Diamond2D

macro Diamond3D {
	Tri  set1 {
	   	ncells = 8;
	   	node_connect_list = {2,5,0, 2,1,5, 2,4,1, 2,0,4, 3,0,5, 3,5,1, 3,1,4, 3,4,0};
	};
	Mesh  diamond {
   	      	int nnodes = 6;
	      	int nspace = 3;
   	      	coordinates {
		      float values[nvals][veclen] = {
		         {-0.5,0,0},{0.5,0,0},{0,-0.5,0},{0,0.5,0},{0,0,-0.5},{0,0,0.5}
	      	      };
	      	};
	      	int ncell_sets = 1;
              	cell_set[ncell_sets] => {set1};
	};
	DataObjectLite obj {
        	in => diamond;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => diamond;
	olink out_obj => obj.obj;
}; // Diamond3D

/* defines a sphere as a single point with radius data as a GD primitive,
 * however:
 *   a) the glyph module does not pay attention to the glyph node data
 *      (radius values are ignored) so this is rendered as a point
 *   b) not all renderers support the sphere primitive (points are drawn)
 *
macro SpherePoint {
	Point set1 {
		ncells = 1;
		node_connect_list = {0};
	};
	Mesh+Node_Data+Float sphere {
		nnodes = 1;
		nspace = 3;
		coordinates {
		      values = { {0,0,0} };
		};
		nnode_data = 1;
		!node_data[0] {
		      veclen = 1;
		      id = GD_RADIUS_DATA_ID;
		      values = { {0.5} };
		};
		ncell_sets = 1;
		cell_set[ncell_sets] => {set1};
	};
	DataObjectLite obj {
        	in => sphere;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => sphere;
	olink out_obj => obj.obj;
}; // SpherePoint
 */

macro Sphere {
	int subdiv<export=2> = 8;

	macro sphere_ui {
		ilink isubdiv => subdiv;
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select sphere control panel.";
		};
		UIslider SubDiv {
        		parent => panel;
		        title = "Subdivision";
			min = 5;
			max = 50;
			value => isubdiv;
			mode = 1;
			y = 0;
			width => <-.panel.width;
		};
	};

	Field_Spher_Unif sphere {
		nspace = 3;
		ndim = 3;
		dims => {2, subdiv, subdiv};
		points = {0.0, 0.0, 0.0, 0.5, 3.14159, 6.28318};
	};

	DV.DVbounds bounds {
		in => <-.sphere;
		hull = 0;
		edges = 0;
		faces = 1;
		imin = 0;
		imax = 1;
		jmin = 0;
		jmax = 0;
		kmin = 0;
		kmax = 0;
		data = 0;
		component = 0;
		out<NEportLevels={0,3}>;
		method+notify_val+notify_inst upd_bounds = "DVbounds_update";
	};

	DataObjectLite obj {
        	in => bounds.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_obj => obj.obj;
}; // Sphere

macro FPoint1D<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	Point_Mesh   point1 {
		nspace = 1;
		coordinates {
			values+nres => {{(in.coordinates.min_vec[0]+in.coordinates.max_vec[0])/2.0}};
		};
	};
	macro probe_ui {
		ilink iobj => point1;
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select point control panel.";
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=  0;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => point1;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => point1;
	olink out_obj => obj.obj;
}; // FPoint1D

macro FPoint2D<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	Point_Mesh   point2 {
		nspace = 2;
		coordinates {
			values+nres => {{(in.coordinates.min_vec[0]+in.coordinates.max_vec[0])/2.0,
				        (in.coordinates.min_vec[1]+in.coordinates.max_vec[1])/2.0}};
		};
	};
	macro probe_ui {
		ilink iobj => point2;
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select point control panel.";
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=  0;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => point2;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => point2;
	olink out_obj => obj.obj;
}; // FPoint2D

macro FPoint3D<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	Point_Mesh   point3 {
		nspace = 3;
		coordinates {
			values+nres => {{(in.coordinates.min_vec[0]+in.coordinates.max_vec[0])/2.0,
				        (in.coordinates.min_vec[1]+in.coordinates.max_vec[1])/2.0,
				        (in.coordinates.min_vec[2]+in.coordinates.max_vec[2])/2.0}};
		};
	};
	macro probe_ui {
		ilink iobj => point3;
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select point control panel.";
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=  0;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => point3;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => point3;
	olink out_obj => obj.obj;
}; // FPoint3D

macro FLine2D<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	int dim1<export=2> = 8;

	float+nres xlate[3] => {0.0, (in.coordinates.min_vec[1]+
				in.coordinates.max_vec[1])/2, 0.0};

	Line_Mesh   line2 {
		xform {
			xlate+nres => cache(<-.<-.xlate);
		};
		dims => {dim1};
		points+nres => {in.coordinates.min_vec[0], in.coordinates.max_vec[0]};
	};

	macro probe_ui {
		ilink idim1 => dim1;
		ilink iobj => line2;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select line control panel.";
		};
		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			max = 100;
			value => idim1;
			mode = 1;
			y = 0;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=>  dim1_slider.y + dim1_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => line2;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => line2;
	olink out_obj => obj.obj;
}; // FLine2D

macro FLine3D<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	int dim1<export=2> = 8;
	float+nres xlate[3]=>{0.0,
			(in.coordinates.min_vec[1]+in.coordinates.max_vec[1])/2,
			(in.coordinates.min_vec[2]+in.coordinates.max_vec[2])/2};

	Line_Mesh   line3 {
		xform {
			xlate+nres=>cache(<-.<-.xlate);
		};
		dims => {dim1};
		points+nres => {in.coordinates.min_vec[0], in.coordinates.max_vec[0]};
	};

	macro probe_ui {
		ilink idim1 => dim1;
		ilink iobj => line3;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select line control panel.";
		};
		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			&max = 100;
			value => idim1;
			mode = 1;
			y = 0;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=>  dim1_slider.y + dim1_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => line3;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => line3;
	olink out_obj => obj.obj;
}; // FLine3D

macro FPlane<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	int dim1<export=2> = 8;
	int dim2<export=2> = 8;

	float+nres xlate[3]=>{0.0, 0.0,
			(in.coordinates.min_vec[2]+in.coordinates.max_vec[2])/2};
	Plane_Mesh   plane {
		xform {
			xlate+nres=>cache(<-.<-.xlate);
		};
		dims => {dim1, dim2};
		points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[1], 
			  in.coordinates.max_vec[0], in.coordinates.max_vec[1]};
	};

	macro probe_ui {
		ilink idim1 => dim1;
		ilink idim2 => dim2;
		ilink iobj => plane;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select plane control panel.";
		};

		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			max = 100;
			value => idim1;
			mode = 1;
			y		=  0;
			width	=> <-.panel.width;
		};
		UIslider dim2_slider {
        		parent => panel;
		        title = "y-dimension";
			min = 2;
			max = 100;
			value => idim2;
			mode = 1;
			y => <-.dim1_slider.y + <-.dim1_slider.height+4;
			width	=> <-.panel.width;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=>  dim2_slider.y + dim2_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => plane;
		Obj {
			name => name_of(<-.<-.<-);
		};
		Props {
		   jitter = -1;
                };
	};

	olink out_fld => plane;
	olink out_obj => obj.obj;
}; // FPlane

macro FBox<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	int dim1<export=2> = 8;
	int dim2<export=2> = 8;
	int dim3<export=2> = 8;

	Box_Mesh   box {
		dims => {dim1, dim2, dim3};
		points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[1], 
			  in.coordinates.min_vec[2], in.coordinates.max_vec[0],
			  in.coordinates.max_vec[1], in.coordinates.max_vec[2]};
	};

	macro probe_ui {
		ilink idim1 => dim1;
		ilink idim2 => dim2;
		ilink idim3 => dim3;
		ilink iobj => box;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select box control panel.";
		};
		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			max = 100;
			value => idim1;
			mode = 1;
			y = 0;
			width	=> <-.panel.width;
		};
		UIslider dim2_slider {
        		parent => panel;
		        title = "y-dimension";
			min = 2;
			max = 100;
			value => idim2;
			mode = 1;
			y => <-.dim1_slider.y + <-.dim1_slider.height+4;
			width	=> <-.panel.width;
		};
		UIslider dim3_slider {
        		parent => panel;
		        title = "z-dimension";
			min = 2;
			max = 100;
			value => idim3;
			mode = 1;
			y => <-.dim2_slider.y + <-.dim2_slider.height+4;
			width	=> <-.panel.width;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=>  dim3_slider.y + dim3_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => box;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => box;
	olink out_obj => obj.obj;
}; // FBox


//
// A lighter version of FBox_Planes (below) for use in other modules.
// There is no UI and no DataObjects.  There are some similarities
// between this and BoundingBox3D, but some plane cropping modules
// really want a set of six planes, not a box
//
macro FBox_Planes_Lite<NEvisible=0> {

    group+IPort2 &in {
        group coordinates {
            float min_vec[];
            float max_vec[];
        };
    };

    int dim1<export=2> = 2;
    int dim2<export=2> = 2;
    int dim3<export=2> = 2;

    //
    // By definition, Plane_Mesh is 2D, so its position in 3 space
    // must be expressed using a Xform.
    //
    Plane_Mesh plane_xy1 {
        xform {
            xlate+nres=>cache({0.0, 0.0, in.coordinates.max_vec[2]});
        };
        dims => {dim1, dim2};
        points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[1], 
                        in.coordinates.max_vec[0], in.coordinates.max_vec[1]};
    };
    Plane_Mesh plane_xy0 {
        xform {
            mat = {{-1,0,0,0},
                   {0,1,0,0},
                   {0,0,-1,0},
                   {0,0,0,1}};
            xlate+nres=>cache({in.coordinates.min_vec[0]+in.coordinates.max_vec[0], 
                               0.0, in.coordinates.min_vec[2]});
        };
        dims => {dim1, dim2};
        points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[1], 
                        in.coordinates.max_vec[0], in.coordinates.max_vec[1]};
    };
    Plane_Mesh plane_yz1 {
        xform {
            mat = {{0,0,-1,0},
                   {0,1,0,0},
                   {1,0,0,0},
                   {0,0,0,1}};
            xlate+nres=>cache({in.coordinates.max_vec[0], 0.0, 
                in.coordinates.min_vec[2]+in.coordinates.max_vec[2]});
        };
        dims => {dim3, dim2};
        points+nres => {in.coordinates.min_vec[2], in.coordinates.min_vec[1], 
                        in.coordinates.max_vec[2], in.coordinates.max_vec[1]};
    };
    Plane_Mesh plane_yz0 {
        xform {
            mat = {{0,0,1,0},
                   {0,1,0,0},
                   {-1,0,0,0},
                   {0,0,0,1}};
            xlate+nres=>cache({in.coordinates.min_vec[0], 0.0, 0.0});
        };
        dims => {dim3, dim2};
        points+nres => {in.coordinates.min_vec[2], in.coordinates.min_vec[1], 
                        in.coordinates.max_vec[2], in.coordinates.max_vec[1]};
    };
    Plane_Mesh plane_xz1 {
        xform {
            mat = {{1,0,0,0},
                   {0,0,-1,0},
                   {0,1,0,0},
                   {0,0,0,1}};
            xlate+nres=>cache({0.0, in.coordinates.max_vec[1], 
                in.coordinates.min_vec[2]+in.coordinates.max_vec[2]});
        };
        dims => {dim1, dim3};
        points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[2], 
                        in.coordinates.max_vec[0], in.coordinates.max_vec[2]};
    };
    Plane_Mesh   plane_xz0 {
        xform {
            mat = {{1,0,0,0},
                   {0,0,1,0},
                   {0,-1,0,0},
                   {0,0,0,1}};
            xlate+nres => cache({0.0, in.coordinates.min_vec[1], 0.0});
        };
        dims => {dim1, dim3};
        points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[2], 
                        in.coordinates.max_vec[0], in.coordinates.max_vec[2]};
    };

    mlink out_fld<NEportLevels={1,2}> => {
           plane_xy0, plane_xy1, plane_yz0,
           plane_yz1, plane_xz0, plane_xz1};

}; // FBox_Planes_Lite

macro FBox_Planes<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	int dim1<export=2> = 2;
	int dim2<export=2> = 2;
	int dim3<export=2> = 2;

	int+Port xform_together = 1;
	int+Port xform_mode=>switch(xform_together+1, GD_XFORM_MODE_NORMAL,
			GD_XFORM_MODE_ALT);
	group  group_xform {
		DefaultXform xform;
	};

	Plane_Mesh   plane_xy1 {
		xform {
			xlate+nres=>cache({0.0, 0.0,in.coordinates.max_vec[2]});
		};
		dims => {dim1, dim2};
		points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[1], 
			  in.coordinates.max_vec[0], in.coordinates.max_vec[1]};
	};
	Plane_Mesh   plane_xy0 {
		xform {
			mat =  {{-1,0,0,0},
       				{0,1,0,0},
      				{0,0,-1,0},
               	 		{0,0,0,1}};
			xlate+nres=>cache({in.coordinates.min_vec[0]+in.coordinates.max_vec[0], 
					0.0,in.coordinates.min_vec[2]});
		};
		dims => {dim1, dim2};
		points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[1], 
			  in.coordinates.max_vec[0], in.coordinates.max_vec[1]};
	};
	Plane_Mesh   plane_yz1 {
		xform {
			mat =  {{0,0,-1,0},
       				{0,1,0,0},
      				{1,0,0,0},
               	 		{0,0,0,1}};
			xlate+nres=>cache({in.coordinates.max_vec[0], 0.0, 
				in.coordinates.min_vec[2]+in.coordinates.max_vec[2]});
		};
		dims => {dim3, dim2};
		points+nres => {in.coordinates.min_vec[2], in.coordinates.min_vec[1], 
			  in.coordinates.max_vec[2], in.coordinates.max_vec[1]};
	};
	Plane_Mesh   plane_yz0 {
		xform {
			mat =  {{0,0,1,0},
       				{0,1,0,0},
      				{-1,0,0,0},
               	 		{0,0,0,1}};
			xlate+nres=>cache({in.coordinates.min_vec[0], 0.0, 0.0});
		};
		dims => {dim3, dim2};
		points+nres => {in.coordinates.min_vec[2], in.coordinates.min_vec[1], 
			  in.coordinates.max_vec[2], in.coordinates.max_vec[1]};
	};
	Plane_Mesh   plane_xz1 {
		xform {
			mat =  {{1,0,0,0},
       				{0,0,-1,0},
      				{0,1,0,0},
               	 		{0,0,0,1}};
			xlate+nres=>cache({0.0, in.coordinates.max_vec[1], 
				in.coordinates.min_vec[2]+in.coordinates.max_vec[2]});
		};
		dims => {dim1, dim3};
		points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[2], 
			  in.coordinates.max_vec[0], in.coordinates.max_vec[2]};
	};
	Plane_Mesh   plane_xz0 {
		xform {
			mat =  {{1,0,0,0},
       				{0,0,1,0},
      				{0,-1,0,0},
               	 		{0,0,0,1}};
			xlate+nres=>cache({0.0, in.coordinates.min_vec[1], 0.0});
		};
		dims => {dim1, dim3};
		points+nres => {in.coordinates.min_vec[0], in.coordinates.min_vec[2], 
			  in.coordinates.max_vec[0], in.coordinates.max_vec[2]};
	};

	DVconcat_xform_field DVconcat_xform_xy0 {
		in => <-.plane_xy0;
		in_xform => <-.group_xform;
	};

	DVconcat_xform_field DVconcat_xform_xy1 {
		in => <-.plane_xy1;
		in_xform => <-.group_xform;
	};

	DVconcat_xform_field DVconcat_xform_yz0 {
		in => <-.plane_yz0;
		in_xform => <-.group_xform;
	};

	DVconcat_xform_field DVconcat_xform_yz1 {
		in => <-.plane_yz1;
		in_xform => <-.group_xform;
	};

	DVconcat_xform_field DVconcat_xform_xz0 {
		in => <-.plane_xz0;
		in_xform => <-.group_xform;
	};

	DVconcat_xform_field DVconcat_xform_xz1 {
		in => <-.plane_xz1;
		in_xform => <-.group_xform;
	};

	macro box_ui {
		ilink idim1 => dim1;
		ilink idim2 => dim2;
		ilink idim3 => dim3;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select box control panel.";
		};
		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			max = 100;
			value => idim1;
			mode = 1;
			y = 0;
			width	=> <-.panel.width;
		};
		UIslider dim2_slider {
        		parent => panel;
		        title = "y-dimension";
			min = 2;
			max = 100;
			value => idim2;
			mode = 1;
			y => <-.dim1_slider.y + <-.dim1_slider.height+4;
			width	=> <-.panel.width;
		};
		UIslider dim3_slider {
        		parent => panel;
		        title = "z-dimension";
			min = 2;
			max = 100;
			value => idim3;
			mode = 1;
			y => <-.dim2_slider.y + <-.dim2_slider.height+4;
			width	=> <-.panel.width;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y	=>  <-.dim3_slider.y + <-.dim3_slider.height+8;
	    		width	=> <-.panel.width;
		};
		UItoggle together_toggle {
	    		parent => <-.panel;
	    		label = "Transform planes together";
	    		y	=>  <-.xform_toggle.y + <-.xform_toggle.height+8;
	    		width	=> <-.panel.width;
			set => <-.<-.xform_together;
		};
		XformEditor probe_edit {
			obj_in => <-.<-.group_xform;
			vis => xform_toggle.set;
		};
	};
	DataObjectLite obj_xy0 {
        	in => DVconcat_xform_xy0.out;
		Obj {
			xform_mode => <-.<-.xform_mode;
			alt_xform => <-.<-.group_xform.xform;
			name => name_of(<-.<-.<-)+ "_XY0";
		};
	};
	DataObjectLite obj_xy1 {
        	in => DVconcat_xform_xy1.out;
		Obj {
			xform_mode => <-.<-.xform_mode;
			alt_xform =>  <-.<-.group_xform.xform;
			name => name_of(<-.<-.<-)+ "_XY1";
		};
	};
	DataObjectLite obj_yz0 {
        	in => DVconcat_xform_yz0.out;
		Obj {
			xform_mode => <-.<-.xform_mode;
			alt_xform =>  <-.<-.group_xform.xform;
			name => name_of(<-.<-.<-)+ "_YZ0";
		};
	};
	DataObjectLite obj_yz1 {
        	in => DVconcat_xform_yz1.out;
		Obj {
			xform_mode => <-.<-.xform_mode;
			alt_xform =>  <-.<-.group_xform.xform;
			name => name_of(<-.<-.<-)+ "_YZ1";
		};
	};
	DataObjectLite obj_xz0 {
        	in => DVconcat_xform_xz0.out;
		Obj {
			xform_mode => <-.<-.xform_mode;
			alt_xform =>  <-.<-.group_xform.xform;
			name => name_of(<-.<-.<-)+ "_ZX0";
		};
	};
	DataObjectLite obj_xz1 {
        	in => DVconcat_xform_xz1.out;
		Obj {
			xform_mode => <-.<-.xform_mode;
			alt_xform => <-.<-.group_xform.xform;
			name => name_of(<-.<-.<-)+ "_ZX1";
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		Top.xform_mode = GD_XFORM_MODE_PARENT;
		Modes {
            		mode = {0,GD_LINES,GD_NO_SURF,0,0};
         	};
 		child_objs => {obj_xy0.obj, obj_xy1.obj, obj_yz0.obj, obj_yz1.obj, obj_xz0.obj,  obj_xz1.obj};
    	};
	mlink out_fld<NEportLevels={1,2}> => {
   		DVconcat_xform_xy0.out,DVconcat_xform_xy1.out,.DVconcat_xform_yz0.out,
   		.DVconcat_xform_yz1.out,.DVconcat_xform_xz0.out,.DVconcat_xform_xz1.out};
	olink out_obj => obj.obj;
}; // FBox_Planes

macro Block<module_stack_menu=1> {
	Mesh_Unif+IPort2 &in;

	float scale_x<export=2> = 1;
	float scale_y<export=2> = 1;
	float scale_z<export=2> = 1;

	float x0 = 0.0;
	float x1 => switch((in.dims[0] <= 1)+1, scale_x*(in.points[1][0]-in.points[0][0])/(in.dims[0]-1), scale_x);
	float y0 = 0.0;
	float y1 => switch((in.dims[1] <= 1)+1, scale_y*(in.points[1][1]-in.points[0][1])/(in.dims[1]-1), scale_y);
	float z0 = 0.0;
	float z1 => scale_z;

	Mesh+Space3 box3 {
		nnodes = 8;
		coordinates {
			values => cache({{x0,y0,z0},{x1,y0,z0},{x1,y1,z0},{x0,y1,z0},
					 {x0,y0,z1},{x1,y0,z1},{x1,y1,z1},{x0,y1,z1}});
		};
		ncell_sets = 1;
		Quad cell_set {
			ncells = 6;
			node_connect_list={0,3,2,1, 4,5,6,7, 0,4,7,3, 1,2,6,5,
					   0,1,5,4, 2,3,7,6};
		};
	};
	Mesh+Space2 box2 {
		nnodes = 4;
		coordinates {
			values => cache({{x0,z0},{x1,z0},{x1,z1},{x0,z1}});
		};
		ncell_sets = 1;
		Quad cell_set {
			ncells = 1;
			node_connect_list={0,1,2,3};
		};
	};

	Mesh box[2] => {box2,box3};
/***
	Box_Mesh   box {
		dims => {2,2,2};
		points+nres => {0,0,0,
				scale_x*(in.points[1][0]-in.points[0][0])/(in.dims[0]-1),
				scale_y*(in.points[1][1]-in.points[0][1])/(in.dims[1]-1),
				scale_z};
	};
***/
	macro probe_ui {

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select box control panel.";

		};
		UIslider scale_x_slider {
        		parent => panel;
		        title = "x-scale";
			value => scale_x;
			max = 2;
			y =0;
			width	=> <-.panel.width;
		};
		UIslider scale_y_slider {
        		parent => panel;
		        title = "y-scale";
			value => scale_y;
			max = 2;
			y => <-.scale_x_slider.y + <-.scale_x_slider.height+4;
			width	=> <-.panel.width;
		};
		UIslider scale_z_slider {
        		parent => panel;
		        title = "z-scale";
			value => scale_z;
			max = 10;
			y => <-.scale_y_slider.y + <-.scale_y_slider.height+4;
			width	=> <-.panel.width;
		};
	};

	olink out_fld => box[in.ndim-1];
}; // Block

macro FCircle2D<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	int dim<export=2> = 12;

	float+nres xlate[3] => {(in.coordinates.min_vec[0]+in.coordinates.max_vec[0])/2, 
				(in.coordinates.min_vec[1]+in.coordinates.max_vec[1])/2, 
				0.0};
	float+nres extent[2]=> {(in.coordinates.max_vec[0]-in.coordinates.min_vec[0]),
		                (in.coordinates.max_vec[1]-in.coordinates.min_vec[1])};

	float+nres rad<export=2> => 0.5*min_array(extent, 0, 0);

	Mesh_Cyl_Unif circle {
		xform {
			xlate+nres => cache(<-.<-.xlate);
		};
        	dims => {1,<-.dim};
         	ndim = 2;
         	nspace = 2;
         	points => {<-.rad, 0, <-.rad, 2*acos(-1.)};
      	};

	macro probe_ui {
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select circle control panel.";
		};

		UIslider dim_slider {
        		parent => panel;
		        title = "n-segments";
			min = 2;
			max = 100;
			value => <-.<-.dim;
			mode = 1;
			y =0;
			width	=> <-.panel.width;
		};
		UIslider rad_slider {
        		parent => panel;
		        title = "radius";
			min = 0;
			max+nres => max_array(<-.<-.extent, 0, 0);
			value => <-.<-.rad;
			y => <-.dim_slider.y + <-.dim_slider.height+4;
			width	=> <-.panel.width;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=>  rad_slider.y + rad_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => <-.<-.circle;
			vis => xform_toggle.set;
		};
	};
	DV.DVbounds DVbounds {
		in {
			xform+nonotify;
			points+req;
		} => <-.circle;
			 hull=1;
			 edges=0;
			 faces=0;
			 imin=0;
			 imax=0;
			 jmin=0;
			 jmax=0;
			 kmin=0;
			 kmax=0;
			 data=0;
			 component=0;
		method+notify_val+notify_inst upd_bounds = "DVbounds_update";
	};

	DataObject obj {
        	in => DVbounds.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => DVbounds.out;
	olink out_obj => obj.obj;
}; // FCircle2D

macro FCircle3D<module_stack_menu=1> {
	group+IPort2 &in {
		group coordinates;
	};

	int dim = 12;

	float+nres xlate[3]=>{(in.coordinates.min_vec[0]+in.coordinates.max_vec[0])/2,
			      (in.coordinates.min_vec[1]+in.coordinates.max_vec[1])/2,
			      (in.coordinates.min_vec[2]+in.coordinates.max_vec[2])/2};

	float+nres extent[2]=> {(in.coordinates.max_vec[0]-in.coordinates.min_vec[0]),
		 	    	(in.coordinates.max_vec[1]-in.coordinates.min_vec[1])};

	float+nres rad<export=2> => 0.5*min_array(extent, 0, 0);

	Mesh_Cyl_Unif circle {
		xform {
			xlate+nres => cache(<-.<-.xlate);
		};
        	dims => {1,<-.dim};
         	ndim = 2;
         	nspace = 2;
         	points => {<-.rad, 0, <-.rad, 2*acos(-1.)};
      	};

	macro probe_ui {
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select circle control panel.";
		};
		UIslider dim_slider {
        		parent => panel;
		        title = "n-segments";
			min = 2;
			max = 100;
			value => <-.<-.dim;
			mode = 1;
			y =0;
			width	=> <-.panel.width;
		};
		UIslider rad_slider {
        		parent => panel;
		        title = "radius";
			min = 0;
			max+nres => max_array(<-.<-.extent, 0, 0);
			value => <-.<-.rad;
			y => <-.dim_slider.y + <-.dim_slider.height+4;
			width	=> <-.panel.width;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y		=>  rad_slider.y + rad_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => <-.<-.circle;
			vis => xform_toggle.set;
		};
	};
	DV.DVbounds DVbounds {
		in {
			xform+nonotify;
			points+req;
		} => <-.circle;
			 hull=1;
			 edges=0;
			 faces=0;
			 imin=0;
			 imax=0;
			 jmin=0;
			 jmax=0;
			 kmin=0;
			 kmax=0;
			 data=0;
			 component=0;
		method+notify_val+notify_inst upd_bounds = "DVbounds_update";
	};

	DataObject obj {
        	in => DVbounds.out;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => DVbounds.out;
	olink out_obj => obj.obj;
}; // FCircle3D

/*************
macro Field_Probe {
	ilink in;

	FPoint1D FPoint1D {
		int vis[9] = {1,0,0,0,0,0,0,0,0};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};

	FPoint1D FPoint2D {
		int vis[9] = {0,1,0,0,0,0,0,0,0};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};

	FPoint1D FPoint3D {
		int vis[9] = {0,0,1,0,0,0,0,0,0};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};
	FLine2D FLine2D {
		int vis[9] = {0,0,0,1,0,0,0,0,0};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};

	FLine3D FLine3D {
		int vis[9] = {0,0,0,0,1,0,0,0,0};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};

	FCircle2D FCircle2D {
		int vis[9] = {0,0,0,0,0,1,0,0,0};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};

	FCircle3D FCircle3D {
		int vis[9] = {0,0,0,0,0,0,1,0,0};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};

	FPlane Fplane {
		int vis[9] = {0,0,0,0,0,0,0,1,0};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};

	FBox FBox {
		int vis[9] = {0,0,0,0,0,0,0,0,1};
		probe_ui {
			panel {
				parent => <-.<-.<-.probeUI.UIpanel;
				visible => <-.<-.vis[ <-.<-.<-.probe_ind];
			};
		};
	};

	macro &probes[] => {FPoint1D, FPoint2D, FPoint3D, FLine2D, FLine3D,
			    FCircle2D, FCircle3D, FPlane, FBox};

	int probe_ind = 0;

	macro probeUI {
		ilink in_fld => in;

		UImod_panel UIpanel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select Field Probe control panel.";
		};

		UIradioBoxLabel   UIradioBoxLabel_probes{
		        parent => <-.UIpanel;
			labels+IPort2 => {"Point1D", "Point2D", "Point3D", 
					  "Line2D", "Line3D",
				          "Circle2D", "Circle3D", 
					  "Plane", "Box"};
			&selectedItem+IPort2 => <-.<-.probe_ind;
			visible => <-.UIpanel.visible;
			title = "Probe";
		};
	};
	olink out_fld => probes[probe_ind].out_fld;
	olink out_obj => probes[probe_ind].out_obj;
}; // Field_Probe
******************/

macro Jet {
	Tri  set1 {
	   	ncells = 4;
	  	node_connect_list = { 0,1,3, 0,2,1, 0,2,3, 1,2,3 };
	};
	Mesh jet {
   	      	int nnodes = 4;
	      	int nspace = 3;
   	      	coordinates {
		      float values[nvals][veclen] = {
		         { 1.0, 0.0, 0.0},
		         { 0.0, 0.3, 0.0},
		         { 0.0, 0.0,-0.2},
		         { 0.0, 0.0, 0.2}
	      	      };
	      	};
	      	int ncell_sets = 1;
              	cell_set[ncell_sets] => {set1};
	};

	DataObject obj {
        	in => jet;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => jet;
	olink out_obj => obj.obj;
}; // Jet

/*  Simple geometries */
macro Point1D<module_stack_menu=1> {

	Point_Mesh   point1 {
		nspace = 1;
		coordinates {
			values = {{0.0}};
		};
	};
	macro point1_ui {
		ilink iobj => point1;
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select point control panel.";
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y	=  0;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => point1;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => point1;
	olink out_obj => obj.obj;
}; // Point1D

macro Point2D<module_stack_menu=1> {

	Point_Mesh   point2 {
		nspace = 2;
		coordinates {
			values = {{0,0}};
		};
	};
	macro point2_ui {
		ilink iobj => point2;
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select point control panel.";
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y	=  0;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => point2;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => point2;
	olink out_obj => obj.obj;
}; // Point2D

macro Point3D<module_stack_menu=1> {

	Point_Mesh   point3 {
		nspace = 3;
		coordinates {
			values = {{0,0,0}};
		};
	};
	macro point3_ui {
		ilink iobj => point3;
		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select point control panel.";
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y	=  0;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => point3;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => point3;
	olink out_obj => obj.obj;
}; // Point3D

macro Line2D<module_stack_menu=1> {

	int dim1<export=2> = 8;

	Line_Mesh   line2 {
		nspace = 2;
		dims => {dim1};
		points = {{0,0}, {1,0}};
	};

	macro line2_ui {
		ilink idim1 => dim1;
		ilink iobj => line2;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select line control panel.";
		};
		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			max = 100;
			value => idim1;
			mode = 1;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y	=> <-.dim1_slider.y + <-.dim1_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => line2;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => line2;
	olink out_obj => obj.obj;
}; // Line2D

macro Line3D<module_stack_menu=1> {
	int dim1<export=2> = 8;

	Line_Mesh   line3 {
		dims => {dim1};
		nspace = 3;
		points = {{0,0,0}, {1,0,0}};
	};

	macro line3_ui {
		ilink idim1 => dim1;
		ilink iobj => line3;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select line control panel.";
		};
		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			&max = 100;
			value => idim1;
			mode = 1;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y	=> <-.dim1_slider.y + <-.dim1_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => line3;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => line3;
	olink out_obj => obj.obj;
}; // Line3D

macro Plane<module_stack_menu=1> {

	int dim1<export=2> = 8;
	int dim2<export=2> = 8;

	Plane_Mesh   plane {
		dims => {dim1, dim2};
		points = {{0,0}, {1,1}};
	};

	macro plane_ui {
		ilink idim1 => dim1;
		ilink idim2 => dim2;
		ilink iobj => plane;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select plane control panel.";
		};
		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			max = 100;
			value => idim1;
			mode = 1;
			y =0;
			width	=> <-.panel.width;
		};
		UIslider dim2_slider {
        		parent => panel;
		        title = "y-dimension";
			min = 2;
			max = 100;
			value => idim2;
			mode = 1;
			y => <-.dim1_slider.y + <-.dim1_slider.height+4;
			width	=> <-.panel.width;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y	=> <-.dim2_slider.y + <-.dim2_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => plane;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => plane;
	olink out_obj => obj.obj;
}; // Plane

macro Box<module_stack_menu=1> {
	int dim1<export=2> = 8;
	int dim2<export=2> = 8;
	int dim3<export=2> = 8;

	Box_Mesh   box {
		dims => {dim1, dim2, dim3};
		points = {{0,0,0}, {1,1,1}};
	};

	macro box_ui {
		ilink idim1 => dim1;
		ilink idim2 => dim2;
		ilink idim3 => dim3;
		ilink iobj => box;

		UImod_panel panel {
			parent<NEportLevels={4,0}>;
			title => name_of(<-.<-.<-);
			message = "Select box control panel.";
		};
		UIslider dim1_slider {
        		parent => panel;
		        title = "x-dimension";
			min = 2;
			max = 100;
			value => idim1;
			mode = 1;
			y =0;
			width	=> <-.panel.width;
		};
		UIslider dim2_slider {
        		parent => panel;
		        title = "y-dimension";
			min = 2;
			max = 100;
			value => idim2;
			mode = 1;
			y => <-.dim1_slider.y + <-.dim1_slider.height+4;
			width	=> <-.panel.width;
		};
		UIslider dim3_slider {
        		parent => panel;
		        title = "z-dimension";
			min = 2;
			max = 100;
			value => idim3;
			mode = 1;
			y => <-.dim2_slider.y + <-.dim2_slider.height+4;
			width	=> <-.panel.width;
		};
		UItoggle xform_toggle {
	    		parent => <-.panel;
	    		label = "Transformation Editor";
	    		y	=> <-.dim3_slider.y + <-.dim3_slider.height+8;
	    		width	=> <-.panel.width;
		};
		XformEditor probe_edit {
			obj_in => iobj;
			vis => xform_toggle.set;
		};
	};

	DataObject obj {
        	in => box;
		Obj {
			name => name_of(<-.<-.<-);
		};
	};

	olink out_fld => box;
	olink out_obj => obj.obj;
}; // Box

macro LegendHoriz {
   GDobject_templ &obj_in<NEportLevels={2,0}> {
      DatamapTempl &dmap<NEportLevels={0,2}>;
   };
   UI.UImod_panel UImod_panel {
      parent<NEportLevels={3,0}>;
      //title = "Horizontal Legend";
      title => name_of(<-.<-);
   };
   int minIntervals = 2;
   int numIntervals = 4;
   float x_min = -0.9;
   float x_max = 0.9;
   float y_min = -0.9;
   float y_max = -0.8;
   float z_val = 0.9;

   UIfieldTypein Xmin {
      UIparent => <-.UImod_panel;
      flabel = "X Min";
      fmin = -5;
      fmax = 5;
      fval => <-.x_min;
      x = 0;
      y = 0;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein Xmax {
      UIparent => <-.UImod_panel;
      flabel = "X Max";
      fmin = -5;
      fmax = 5;
      fval => <-.x_max;
      x = 0;
      y => <-.Xmin.y + <-.Xmin.height + 5;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein Ymin {
      UIparent => <-.UImod_panel;
      flabel = "Y Min";
      fmin = -5;
      fmax = 5;
      fval => <-.y_min;
      x = 0;
      y => <-.Xmax.y + <-.Xmax.height + 5;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein Ymax {
      UIparent => <-.UImod_panel;
      flabel = "Y Max";
      fmin = -5;
      fmax = 5;
      fval => <-.y_max;
      x = 0;
      y => <-.Ymin.y + <-.Ymin.height + 5;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein Zval {
      UIparent => <-.UImod_panel;
      flabel = "Z Value";
      fval => <-.z_val;
      x = 0;
      y => <-.Ymax.y + <-.Ymax.height + 5;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein NumInt {
      UIparent => <-.UImod_panel;
      flabel = "Intervals";
      fval => <-.numIntervals;
      fmin => <-.minIntervals;
      x = 0;
      y => <-.Zval.y + <-.Zval.height + 5;
      height => field.height + 6;
      label.alignment = 0;
      field.mode = 1;
   };
   UIslider LabelsOffset {
      parent => <-.UImod_panel;
      y => <-.NumInt.y + <-.NumInt.height + 5;
      width => <-.UImod_panel.clientWidth;
      title = "Labels Offset";
      min = -1.0;
      max = 1.0;
      decimalPoints = 2;
      value => LabelsMacro.labelsOffset;
   };
   UIlabel format_label {
      parent => <-.UImod_panel;
      y => <-.LabelsOffset.y + <-.LabelsOffset.height + 8;
      width = 50;
      label = "Format";
      alignment = 0;
   };
   UItext format_text {
      parent => <-.UImod_panel;
      x = 50;
      y => <-.format_label.y;
      width = 200;
      height => UIdata.UIfonts[0].lineHeight + 8;
      text => <-.LabelsMacro.format;
   };
   UIlabel font_label {
      parent => <-.UImod_panel;
      y => <-.format_label.y + <-.format_text.height + 8;
      width = 50;
      label = "Font";
      alignment = 0;
   };
   UItext font_text {
      parent => <-.UImod_panel;
      x = 50;
      y => <-.font_label.y;
      width = 200;
      height => UIdata.UIfonts[0].lineHeight + 8;
      text = "-adobe-helvetica-medium-r-*-*-15-*-*-*-*-*-*-*";
   };
   UItoggle OutlineToggle {
      parent => <-.UImod_panel;
      y => <-.font_label.y + <-.font_text.height + 12;
      width => <-.UImod_panel.clientWidth;
      label = "Outline";
      alignment = 0;
      set = 1;
   };
   UItoggle LabelsToggle {
      parent => <-.UImod_panel;
      y => <-.OutlineToggle.y + <-.OutlineToggle.height + 4;
      width => <-.UImod_panel.clientWidth;
      label = "Labels";
      alignment = 0;
      set => LabelsMacro.obj.obj.visible;
   };
   UItoggle TicksToggle {
      parent => <-.UImod_panel;
      y => <-.LabelsToggle.y + <-.LabelsToggle.height + 4;
      width => <-.UImod_panel.clientWidth;
      label = "Ticks";
      alignment = 0;
      set => TicksMacro.Ticks.visible;
   };

   macro LegendMacro {
      float+nres dmapMin => <-.obj_in.dmap.dataMin;
      float+nres dmapMax => <-.obj_in.dmap.dataMax;
      float+nres dmapIncr => ((dmapMax - dmapMin) / 256.0);

      float arr[512] => {init_array(256,0,255), init_array(256,0,255)};
      Mesh_Unif+Node_Data+Float LegendField<NEportLevels={0,1}> {
         nnodes => prod(dims);
         dims = {256,2};
         ndim = 2;
         Data_Array+Float.node_data node_data[nnode_data] {
            values => ((arr * dmapIncr) + dmapMin);
            veclen = 1;
            nvals => nnodes;
         } = {};
         nnode_data = 1;
         nspace = 3;
         points => {
            {<-.<-.x_min,<-.<-.y_min,<-.<-.z_val},
            {<-.<-.x_max,<-.<-.y_max,<-.<-.z_val}
	 };
      };
      DefaultProps DefaultProps;
      DefaultModes DefaultModes {
	 mode => {0,0,2,0,<-.<-.OutlineToggle.set+1};
      };
      DefaultObject Legend<NEportLevels={0,2}> {
         input => LegendField;
         dmap => <-.<-.obj_in.dmap;
	 props => <-.DefaultProps;
	 modes => <-.DefaultModes;
	 name => name_of(<-.<-.<-) + "Legend";
	 xform_mode => GD_XFORM_MODE_LOCKED;
      };
   };

   macro LabelsMacro {
      float+nres dmapMin => <-.obj_in.dmap.dataMin;
      float+nres dmapMax => <-.obj_in.dmap.dataMax;
      float labelsOffset = -0.07;
      string format = "%3.2f";

      float string_values[] => init_array(<-.numIntervals, dmapMin, dmapMax);
      string string_array[] => str_format(format, string_values);
      float xvalues[<-.numIntervals][1] => init_array(<-.numIntervals, 
		<-.x_min, <-.x_max);
      float yvalues[<-.numIntervals][1] => <-.y_min + labelsOffset;
      float zvalues[<-.numIntervals][1] => <-.z_val;
      Mesh+OPort LabelField {
	 nnodes => <-.<-.numIntervals;
	 nspace = 3;
	 coordinates {
	    values => combine_array(xvalues, yvalues, zvalues);
         };
	 ncell_sets = 1;
	 Point cell_set {
	    ncells => <-.<-.<-.numIntervals;
	    node_connect_list => init_array(ncells, 0, ncells-1);
         };
      };

      TextValues TextValues {
         text_values => string_array;
         align_horiz = 1;
         align_vert = 0;
         drop_shadow = 0;
         bounds = 0;
         underline = 0;
         background = 0;
         lead_line = 0;
         radial = 0;
         do_offset = 0;
      };
      TextField &TextField => merge(TextValues, LabelField);
      DataObject obj {
         in => TextField;
         Obj {
	    name => name_of(<-.<-.<-.<-) + "Labels";
	    xform_mode => GD_XFORM_MODE_LOCKED;
         };
         Props {
            inherit = 0;
	    font => <-.<-.<-.font_text.text;
         };
      };

   };

   macro TicksMacro {
      float xvalues[<-.numIntervals][1] => init_array(<-.numIntervals, 
		<-.x_min, <-.x_max);
      float yminvalues[<-.numIntervals][1] => <-.y_min;
      float ymaxvalues[<-.numIntervals][1] => <-.y_max;
      float zvalues[<-.numIntervals][1] => <-.z_val + 0.02;

      float bottom[<-.numIntervals][3] => combine_array(xvalues, yminvalues, zvalues);
      float top[<-.numIntervals][3] => combine_array(xvalues, ymaxvalues, zvalues);
      int conn1[<-.numIntervals][1] => init_array(<-.numIntervals, 0, <-.numIntervals-1);
      int conn2[<-.numIntervals][1] => init_array(<-.numIntervals, <-.numIntervals, 2*<-.numIntervals-1);

      Mesh+OPort TickField {
	 nnodes => <-.<-.numIntervals * 2;
	 nspace = 3;
	 coordinates {
	    values => {<-.<-.bottom, <-.<-.top};
         };
	 ncell_sets = 1;
	 Line cell_set {
	    ncells => <-.<-.<-.numIntervals;
	    node_connect_list[] => combine_array(<-.<-.conn1, <-.<-.conn2);
         };
      };

      DefaultProps DefaultProps {
         jitter = 1;
      };
      DefaultObject Ticks<NEportLevels={0,2}> {
         input => TickField;
	 props => DefaultProps;
	 name => name_of(<-.<-.<-) + "Ticks";
	 xform_mode => GD_XFORM_MODE_LOCKED;
      };
   };
   GD.GroupObject GroupObject {
      child_objs => {<-.LegendMacro.Legend,<-.LabelsMacro.obj.obj,<-.TicksMacro.Ticks};
      obj<NEportLevels={1,3}> {
         name => name_of(<-.<-.<-) + "Top";
	 xform_mode => GD_XFORM_MODE_LOCKED;
      };
   };
}; // LegendHoriz


macro LegendVert {
   GDobject_templ &obj_in<NEportLevels={2,0}> {
      DatamapTempl &dmap<NEportLevels={0,2}>;
   };
   UI.UImod_panel UImod_panel {
      parent<NEportLevels={3,0}>;
      //title = "Vertical Legend";
      title => name_of(<-.<-);
   };
   int minIntervals = 2;
   int numIntervals = 4;
   float x_min = -0.8;
   float x_max = -0.7;
   float y_min = -0.9;
   float y_max = 0.9;
   float z_val = 0.9;

   UIfieldTypein Xmin {
      UIparent => <-.UImod_panel;
      flabel = "X Min";
      fmin = -5;
      fmax = 5;
      fval => <-.x_min;
      x = 0;
      y = 0;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein Xmax {
      UIparent => <-.UImod_panel;
      flabel = "X Max";
      fmin = -5;
      fmax = 5;
      fval => <-.x_max;
      x = 0;
      y => <-.Xmin.y + <-.Xmin.height + 5;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein Ymin {
      UIparent => <-.UImod_panel;
      flabel = "Y Min";
      fmin = -5;
      fmax = 5;
      fval => <-.y_min;
      x = 0;
      y => <-.Xmax.y + <-.Xmax.height + 5;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein Ymax {
      UIparent => <-.UImod_panel;
      flabel = "Y Max";
      fmin = -5;
      fmax = 5;
      fval => <-.y_max;
      x = 0;
      y => <-.Ymin.y + <-.Ymin.height + 5;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein Zval {
      UIparent => <-.UImod_panel;
      flabel = "Z Value";
      fval => <-.z_val;
      x = 0;
      y => <-.Ymax.y + <-.Ymax.height + 5;
      height => field.height + 6;
      label.alignment = 0;
   };
   UIfieldTypein NumInt {
      UIparent => <-.UImod_panel;
      flabel = "Intervals";
      fval => <-.numIntervals;
      fmin => <-.minIntervals;
      x = 0;
      y => <-.Zval.y + <-.Zval.height + 5;
      height => field.height + 6;
      label.alignment = 0;
      field.mode = 1;
   };
   UIslider LabelsOffset {
      parent => <-.UImod_panel;
      y => <-.NumInt.y + <-.NumInt.height + 5;
      width => <-.UImod_panel.clientWidth;
      title = "Labels Offset";
      min = -2.0;
      max = 1.0;
      decimalPoints = 2;
      value => LabelsMacro.labelsOffset;
   };
   UIlabel format_label {
      parent => <-.UImod_panel;
      y => <-.LabelsOffset.y + <-.LabelsOffset.height + 8;
      width = 50;
      label = "Format";
      alignment = 0;
   };
   UItext format_text {
      parent => <-.UImod_panel;
      x = 50;
      y => <-.format_label.y;
      width = 200;
      height => UIdata.UIfonts[0].lineHeight + 8;
      text => <-.LabelsMacro.format;
   };
   UIlabel font_label {
      parent => <-.UImod_panel;
      y => <-.format_label.y + <-.format_text.height + 8;
      width = 50;
      label = "Font";
      alignment = 0;
   };
   UItext font_text {
      parent => <-.UImod_panel;
      x = 50;
      y => <-.font_label.y;
      width = 200;
      height => UIdata.UIfonts[0].lineHeight + 8;
      text = "-adobe-helvetica-medium-r-*-*-15-*-*-*-*-*-*-*";
   };
   UItoggle OutlineToggle {
      parent => <-.UImod_panel;
      y => <-.font_label.y + <-.font_text.height + 12;
      width => <-.UImod_panel.clientWidth;
      label = "Outline";
      alignment = 0;
      set = 1;
   };
   UItoggle LabelsToggle {
      parent => <-.UImod_panel;
      y => <-.OutlineToggle.y + <-.OutlineToggle.height + 4;
      width => <-.UImod_panel.clientWidth;
      label = "Labels";
      alignment = 0;
      set => LabelsMacro.obj.obj.visible;
   };
   UItoggle TicksToggle {
      parent => <-.UImod_panel;
      y => <-.LabelsToggle.y + <-.LabelsToggle.height + 4;
      width => <-.UImod_panel.clientWidth;
      label = "Ticks";
      alignment = 0;
      set => TicksMacro.Ticks.visible;
   };


   macro LegendMacro {
      float+nres dmapMin => <-.obj_in.dmap.dataMin;
      float+nres dmapMax => <-.obj_in.dmap.dataMax;
      float+nres dmapIncr => ((dmapMax - dmapMin) / 256.0);

      float arr1[256][1] => init_array(256, dmapMin, (255.0 * dmapIncr) + dmapMin);
      Mesh_Unif+Node_Data+Float LegendField<NEportLevels={0,1}> {
         nnodes => prod(dims);
         dims = {2,256};
         ndim = 2;
         Data_Array+Float.node_data node_data[nnode_data] {
	    values => combine_array(arr1, arr1);
            veclen = 1;
            nvals => nnodes;
         } = {};
         nnode_data = 1;
         nspace = 3;
         points => {
            {<-.<-.x_min,<-.<-.y_min,<-.<-.z_val},
            {<-.<-.x_max,<-.<-.y_max,<-.<-.z_val}
	 };
      };
      DefaultProps DefaultProps;
      DefaultModes DefaultModes {
	 mode => {0,0,2,0,<-.<-.OutlineToggle.set+1};
      };
      DefaultObject Legend<NEportLevels={0,2}> {
         input => LegendField;
         dmap => <-.<-.obj_in.dmap;
	 props => <-.DefaultProps;
	 modes => <-.DefaultModes;
	 name => name_of(<-.<-.<-) + "Legend";
	 xform_mode => GD_XFORM_MODE_LOCKED;
      };
   };

   macro LabelsMacro {
      float+nres dmapMin => <-.obj_in.dmap.dataMin;
      float+nres dmapMax => <-.obj_in.dmap.dataMax;
      float labelsOffset = -0.03;
      string format = "%3.2f";

      float string_values[] => init_array(<-.numIntervals, dmapMin, dmapMax);
      string string_array[] => str_format(format, string_values);
      float xvalues[<-.numIntervals][1] => <-.x_min + labelsOffset;
      float yvalues[<-.numIntervals][1] => init_array(<-.numIntervals,
		<-.y_min, <-.y_max);
      float zvalues[<-.numIntervals][1] => <-.z_val;
      Mesh+OPort LabelField {
	 nnodes => <-.<-.numIntervals;
	 nspace = 3;
	 coordinates {
	    values => combine_array(xvalues, yvalues, zvalues);
         };
	 ncell_sets = 1;
	 Point cell_set {
	    ncells => <-.<-.<-.numIntervals;
	    node_connect_list => init_array(ncells, 0, ncells-1);
         };
      };

      TextValues TextValues {
         text_values => string_array;
         align_horiz = 2;
         align_vert = 2;
         drop_shadow = 0;
         bounds = 0;
         underline = 0;
         background = 0;
         lead_line = 0;
         radial = 0;
         do_offset = 0;
      };
      TextField &TextField => merge(TextValues, LabelField);
      DataObject obj {
         in => TextField;
         Obj {
            name => name_of(<-.<-.<-.<-) + "Labels";
	    xform_mode => GD_XFORM_MODE_LOCKED;
         };
         Props {
            inherit = 0;
            font => <-.<-.<-.font_text.text;
         };
      };
   };

   macro TicksMacro {
      float xminvalues[<-.numIntervals][1] => <-.x_min;
      float xmaxvalues[<-.numIntervals][1] => <-.x_max;
      float yvalues[<-.numIntervals][1] => init_array(<-.numIntervals, 
		<-.y_min, <-.y_max);
      float zvalues[<-.numIntervals][1] => <-.z_val + 0.02;

      float left[<-.numIntervals][3] => combine_array(xminvalues, yvalues, zvalues);
      float right[<-.numIntervals][3] => combine_array(xmaxvalues, yvalues, zvalues);
      int conn1[<-.numIntervals][1] => init_array(<-.numIntervals, 0, <-.numIntervals-1);
      int conn2[<-.numIntervals][1] => init_array(<-.numIntervals, <-.numIntervals, 2*<-.numIntervals-1);

      Mesh+OPort TickField {
	 nnodes => <-.<-.numIntervals * 2;
	 nspace = 3;
	 coordinates {
	    values => {<-.<-.left, <-.<-.right};
         };
	 ncell_sets = 1;
	 Line cell_set {
	    ncells => <-.<-.<-.numIntervals;
	    node_connect_list[] => combine_array(<-.<-.conn1, <-.<-.conn2);
         };
      };

      DefaultProps DefaultProps {
         jitter = 1;
      };
      DefaultObject Ticks<NEportLevels={0,2}> {
         input => TickField;
	 props => DefaultProps;
	 name => name_of(<-.<-.<-) + "Ticks";
	 xform_mode => GD_XFORM_MODE_LOCKED;
      };
   };
   GD.GroupObject GroupObject {
      child_objs => {<-.LegendMacro.Legend,<-.LabelsMacro.obj.obj,<-.TicksMacro.Ticks};
      obj<NEportLevels={1,3}> {
         name => name_of(<-.<-.<-) + "Top";
	 xform_mode => GD_XFORM_MODE_LOCKED;
      };
   };
}; // LegendVert


macro BackgroundFade {

   float depth = -0.98; // almost to back clipping plane

   group+OPort params {
      float+Port2 Upper_Left_Red = 0.0;
      float+Port2 Upper_Left_Green = 0.0;
      float+Port2 Upper_Left_Blue = 0.7;
      float+Port2 Upper_Right_Red = 0.0;
      float+Port2 Upper_Right_Green = 0.0;
      float+Port2 Upper_Right_Blue = 0.7;
      float+Port2 Lower_Left_Red = 0.6;
      float+Port2 Lower_Left_Green = 0.6;
      float+Port2 Lower_Left_Blue = 0.7;
      float+Port2 Lower_Right_Red = 0.6;
      float+Port2 Lower_Right_Green = 0.6;
      float+Port2 Lower_Right_Blue = 0.7;
   };

   macro RGB_BackgroundUI {

      params &params<NEportLevels={2,1}> => <-.params;

      UImod_panel panel {
         title = "BackgroundFade";
         width = 250;
         height = 500;
      };

      UIlabel BackgroundTitle {
         parent => <-.panel;
         y = 0;
         width => parent.width;
         alignment = "left";
         label => "Background Fade Control";
      };

      //    Upper Left RGB panel
      //------------------------------------

      UIframe ULframe {
         parent => <-.panel;
         x = 0;
         y => <-.BackgroundTitle.y + <-.BackgroundTitle.height + 10;
         width => (parent.width / 2) - 5;
         height => <-.ULBslider.y + <-.ULBslider.height + 10;
      };
      UIlabel ULtitle {
         parent => <-.ULframe;
         x = 5;
         y = 5;
         width => parent.width - 12;
         alignment = "left";
         label => "Upper Left";
      };
      UIslider ULRslider {
         parent => <-.ULframe;
         min = 0;
         max = 1.0;
         value => <-.params.Upper_Left_Red;
         x => <-.ULtitle.x;
         y => <-.ULtitle.y + <-.ULtitle.height + 5;
         width => <-.ULtitle.width;
         title = "Red";
      };
      UIslider ULGslider {
         parent => <-.ULframe;
         min = 0;
         max = 1.0;
         value => <-.params.Upper_Left_Green;
         x => <-.ULtitle.x;
         y => <-.ULRslider.y + <-.ULRslider.height + 5;
         width => <-.ULtitle.width;
         title = "Green";
      };
      UIslider ULBslider {
         parent => <-.ULframe;
         min = 0;
         max = 1.0;
         value => <-.params.Upper_Left_Blue;
         x => <-.ULtitle.x;
         y => <-.ULGslider.y + <-.ULGslider.height + 5;
         width => <-.ULtitle.width;
         title = "Blue";
      };

      //    Upper Right RGB panel
      //------------------------------------

      UIframe URframe {
         parent => <-.panel;
         x => <-.ULframe.x + <-.ULframe.width + 5;
         y => <-.ULframe.y;
         width => <-.ULframe.width;
         height => <-.ULframe.height;
      };
      UIlabel URtitle {
         parent => <-.URframe;
         x = 5;
         y = 5;
         width => parent.width - 12;
         alignment = "left";
         label => "Upper Right";
      };
      UIslider URRslider {
         parent => <-.URframe;
         min = 0;
         max = 1.0;
         value => <-.params.Upper_Right_Red;
         x => <-.URtitle.x;
         y => <-.URtitle.y + <-.URtitle.height + 5;
         width => <-.URtitle.width;
         title = "Red";
      };
      UIslider URGslider {
         parent => <-.URframe;
         min = 0;
         max = 1.0;
         value => <-.params.Upper_Right_Green;
         x => <-.URtitle.x;
         y => <-.URRslider.y + <-.URRslider.height + 5;
         width => <-.URtitle.width;
         title = "Green";
      };
      UIslider URBslider {
         parent => <-.URframe;
         min = 0;
         max = 1.0;
         value => <-.params.Upper_Right_Blue;
         x => <-.URtitle.x;
         y => <-.URGslider.y + <-.URGslider.height + 5;
         width => <-.URtitle.width;
         title = "Blue";
      };

      //    Lower Left RGB panel
      //------------------------------------

      UIframe LLframe {
         parent => <-.panel;
         x => <-.ULframe.x;
         y => <-.ULframe.y + <-.ULframe.height + 10;
         width => <-.ULframe.width;
         height => <-.ULframe.height;
      };
      UIlabel LLtitle {
         parent => <-.LLframe;
         x = 5;
         y = 5;
         width => parent.width - 12;
         alignment = "left";
         label => "Lower Left";
      };
      UIslider LLRslider {
         parent => <-.LLframe;
         min = 0;
         max = 1.0;
         value => <-.params.Lower_Left_Red;
         x => <-.LLtitle.x;
         y => <-.LLtitle.y + <-.LLtitle.height + 5;
         width => <-.LLtitle.width;
         title = "Red";
      };
      UIslider LLGslider {
         parent => <-.LLframe;
         min = 0;
         max = 1.0;
         value => <-.params.Lower_Left_Green;
         x => <-.LLtitle.x;
         y => <-.LLRslider.y + <-.LLRslider.height + 5;
         width => <-.LLtitle.width;
         title = "Green";
      };
      UIslider LLBslider {
         parent => <-.LLframe;
         min = 0;
         max = 1.0;
         value => <-.params.Lower_Left_Blue;
         x => <-.LLtitle.x;
         y => <-.LLGslider.y + <-.LLGslider.height + 5;
         width => <-.LLtitle.width;
         title = "Blue";
      };

      //    Lower Right RGB panel
      //------------------------------------

      UIframe LRframe {
         parent => <-.panel;
         x => <-.URframe.x;
         y => <-.LLframe.y;
         width => <-.ULframe.width;
         height => <-.ULframe.height;
      };
      UIlabel LRtitle {
         parent => <-.LRframe;
         x = 5;
         y = 5;
         width => parent.width - 12;
         alignment = "left";
         label => "Lower Right";
      };
      UIslider LRRslider {
         parent => <-.LRframe;
         min = 0;
         max = 1.0;
         value => <-.params.Lower_Right_Red;
         x => <-.LRtitle.x;
         y => <-.LRtitle.y + <-.LRtitle.height + 5;
         width => <-.LRtitle.width;
         title = "Red";
      };
      UIslider LRGslider {
         parent => <-.LRframe;
         min = 0;
         max = 1.0;
         value => <-.params.Lower_Right_Green;
         x => <-.LRtitle.x;
         y => <-.LRRslider.y + <-.LRRslider.height + 5;
         width => <-.LRtitle.width;
         title = "Green";
      };
      UIslider LRBslider {
         parent => <-.LRframe;
         min = 0;
         max = 1.0;
         value => <-.params.Lower_Right_Blue;
         x => <-.LRtitle.x;
         y => <-.LRGslider.y + <-.LRGslider.height + 5;
         width => <-.LRtitle.width;
         title = "Blue";
      };

   };

   // define one large quad, slightly larger than
   // view, with depth set to the back of scene

   Quad quad1 {
      ncells = 1;
      node_connect_list = {0,1,2,3};
   };

   Mesh+Node_Data+Vector+Float+Space3+OPort quad_rgb {
      nnodes = 4;

      coordinates {
         values[nvals][veclen]=> {
            {-1,-1,<-.<-.depth},
            {-1,1,<-.<-.depth},
            {1,1,<-.<-.depth},
            {1,-1,<-.<-.depth}
         };
      };

      ncell_sets = 1;
      cell_set[ncell_sets]=>{quad1};

      nnode_data = 1;
      node_data[nnode_data];

      // Use RGB coordinate values
      !node_data[0] {
         nvals => <-.nnodes;
         veclen = 3;
         values[nvals][veclen] => {
            <-.<-.params.Lower_Left_Red,  <-.<-.params.Lower_Left_Green,  <-.<-.params.Lower_Left_Blue,
            <-.<-.params.Upper_Left_Red,  <-.<-.params.Upper_Left_Green,  <-.<-.params.Upper_Left_Blue,
            <-.<-.params.Upper_Right_Red, <-.<-.params.Upper_Right_Green, <-.<-.params.Upper_Right_Blue,
            <-.<-.params.Lower_Right_Red, <-.<-.params.Lower_Right_Green, <-.<-.params.Lower_Right_Blue };
            id = 667; // float RGB 0-1 range data
         };
      };

      GDM.DataObject DataObject {
         in => <-.quad_rgb;
         Obj {
            pickable = 0;
            xform_mode = "Locked";
            name => "BackgroundFade";
         };
         Modes.mode={1,1,2,1,1}; // specify non-inherit no lighting effects
      };

      olink out_fld => quad_rgb;
      olink out_obj => DataObject.obj;

}; // BackgroundFade

}; // GEOMS
