/*
                        Copyright (c) 1998 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/gis3.v#1 $
*/

flibrary+buffered GIS_READERS<NEeditable=1,
	libdeps="FLD GIS_UTIL GIS_MODS",
	use_src_file=0,
	build_dir="gis/xp_mods",
	disabled => Templates.CONFIG.gis_disabled> {

      module GISCIAMapII<cxx_class="WorldMap",
	cxx_hdr_files="fld/Xfld.h avs/gis/latlon.h avs/gis/cia.h",
	out_hdr_file="GISCIA.hxx",
	out_src_file="GISCIA.cxx",
        compile_src=0
        > {
         string+read+req ciaDirectory<NEportLevels={2,0}> = "$XP_PATH<0>/data/Maps";
         int+read+write precision<NEportLevels={2,2}> = 3600;
         double+read+write+req westLongitude<NEportLevels={2,1}> = 185;
         double+read+write+req eastLongitude<NEportLevels={2,1}> = 315;
         double+read+write+req southLatitude<NEportLevels={2,1}> = 15;
         double+read+write+req northLatitude<NEportLevels={2,1}> = 85;
         string+req geographicFeatures<NEportLevels={2,0}> = "None";
         string+req politicalFeatures<NEportLevels={2,0}> = "None";
         string+req coastalFeatures<NEportLevels={2,0}> = "All";
         string+req riverFeatures<NEportLevels={2,0}> = "None";
         int+notify+notify_inst+req read_data<NEportLevels={2,0}>;
         Mesh+Node_Data geoPolylines<NEportLevels={0,2}> {
            Polyline cell_set[.ncell_sets];
         };
         Mesh+Node_Data polPolylines<NEportLevels={0,2}> {
            Polyline cell_set[.ncell_sets];
         };
         Mesh+Node_Data coastalPolylines<NEportLevels={0,2}> {
            Polyline cell_set[.ncell_sets];
         };
         Mesh+Node_Data riverPolylines<NEportLevels={0,2}> {
            Polyline cell_set[.ncell_sets];
         };
         cxxmethod+notify_inst+req ingest<status=1>;
      };

      module GISDEM<cxx_class="DEM_LogicalRecord",
	cxx_hdr_files="fld/Xfld.h avs/gis/demread.h",
	out_hdr_file="GISDEM.hxx",
	out_src_file="GISDEM.cxx",
        compile_src=0
	> {
         string+read+req demFile<NEportLevels={2,0}> = "data/DEM";
         int+notify+req read_data<NEportLevels={2,0}> = 0;
	 float+read+req subsample = 0.05;
	 string+write QuadName;
	 string+write Information;
	 double+read GlobalRadius<NEportLevels={2,2}> = 6378000.;
         Mesh_Struct+Dim2+Space3+Node_Data demGrid<NEportLevels={0,2}>;
         string+write status = "No File Read";
         cxxmethod+notify_inst+req ingest<status=1>;
      };

};
