/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/gmod.v#1 $
*/
flibrary+sort GMOD <
   build_dir="gmod",
   build_cmd="$(MAKE)",
   link_files="-lgmod",
   c_hdr_files="avs/gmod.h",
   out_hdr_file="uci_gmod.h",
   out_src_file="uci_gmod",
   hdr_code="int GMODbase_init (int *,char **);",
   init_code="   GMODbase_init(argc,argv);"
> {
   module timer<struct_name    = "TimerStruct",
	      struct_bitmask = "TimerBitmask"> {
      int+req+IPort2+read	TimeStep;
      int+req+IPort2+read	Active = 0;
      float+req+write+OPort2 Val = 0.01;
      float+req+read+IPort2 ValStep = 0.01;
      cmethod+notify_val	Timer_update = "TimerUpdate";
      cmethod+notify_del	Timer_del    = "TimerDel";
   };

module loop<struct_name    = "LoopStruct",
	   struct_bitmask = "LoopBitmask"> {
   int+IOparam		reset = 0;
   int+IOparam		reset_back = 0;
   int+Iparam		run = 0;
   int+Iparam		run_back = 0;
   int+Iparam		step = 0;
   int+Iparam		step_back = 0;
   int+Iparam		cycle = 0;
   int+Oparam		done = 0;
   double+Iparam	start_val;
   double+Iparam	end_val;
   double+Iparam	incr;
   double+Oparam	count;
   cmethod+notify_val	loop_update = "LoopUpdate";
   cmethod+notify_del	loop_del    = "LoopDel";
};

module instancer {
   int+IPort2+req+read	Value;
   group+nonotify+read+req+IPort2 *Group;
   int active = 1;
   // instancer's need to run before other modules at instance time
   // so that dependencies between instance methods are worked out
   // for objects that are instanced by default.
   method+notify+req+notify_inst update<weight=0> = "GMODinstancer";
};

module load_v_script {
   string+IPort2+read+req filename;
   prim+IPort2+read	  trigger;
   group+IPort2+read+nonotify *relative;
   int+read+nonotify+IPort2 active = 1;
   int+read+nonotify+IPort2 on_inst = 1;
   omethod+notify_val+notify_inst load_scr_relative = "GMODload_script";
};

module parse_v {
   string+IPort2+read+req v_commands;
   prim+IPort2+read	  trigger;
   int+read	  	  mode = 0;
   boolean+read		  sync = 0; // run synchronously if true
   int+nonotify+read	  no_errors = 0;
   boolean+read+nonotify+IPort2 active = 1;
   boolean+read+nonotify+IPort2 on_inst = 1;
   group+IPort2+read+nonotify *relative;
   omethod+notify+req+notify_inst parse_v_relative = "GMODparse_v";
};

module copy_on_change {
   prim+read+IPort2 trigger; // an alternate way to get this module to fire
   prim+Iparam input;
   prim+Oparam output;
   int+Iparam on_inst = 1;
   omethod+notify_val+notify_inst copy_on_change = "GMODcopy_on_change";
};

module print_error {
   boolean+read+IPort2 error; // 1 - print 0 - don't
   string+read+IPort2 error_source;
   string+read+IPort2 error_message;
   int+Iparam on_inst = 0;
   omethod+notify_val+notify_inst print_error  = "GMODprint_error";
};


module journal<struct_name="OMjournal",
      hdr_code="int OMjournal_init (void);",
      pre_init_code="   OMjournal_init();"
> {
   int+read start_recording;
   int+read playback;
   int+read stop;
   string+read playback_filename;
   string+read record_filename;
   int+read+write record;
   cmethod+notify_val+notify_inst journal_upd = "OMjournal_update";
   cmethod+notify_del journal_del = "OMjournal_destroy";
};

module hsv_to_rgb {
   float h<NEportLevels={0x2,0x1}>;
   float s<NEportLevels={0x2,0x1}>;
   float v<NEportLevels={0x2,0x1}>;
   float r<NEportLevels={0x1,0x2}>;
   float g<NEportLevels={0x1,0x2}>;
   float b<NEportLevels={0x1,0x2}>;
   method+notify_val+notify_inst method_src = "hsv_to_rgb_proc";
};

module rgb_to_hsv {
   float r<NEportLevels={0x2,0x1}>;
   float g<NEportLevels={0x2,0x1}>;
   float b<NEportLevels={0x2,0x1}>;
   float h<NEportLevels={0x1,0x2}>;
   float s<NEportLevels={0x1,0x2}>;
   float v<NEportLevels={0x1,0x2}>;
   method+notify_val+notify_inst method_src = "rgb_to_hsv_proc";
};

module rgb_or_hsv {
   float r<NEportLevels={0x2,0x1}>;
   float g<NEportLevels={0x2,0x1}>;
   float b<NEportLevels={0x2,0x1}>;
   float h<NEportLevels={0x2,0x1}>;
   float s<NEportLevels={0x2,0x1}>;
   float v<NEportLevels={0x2,0x1}>;
   int mode; /* if mode == 0, rgb has priority if both change */
   omethod+notify_val+notify_inst method_src = "rgb_or_hsv_proc";
};

/* groups for general string switcher module. module expects
   and array called entries with nentries and an
   element called selected that it sets to the
   most recently updated entry.
   Used to select from a list of strings the input to
   the load script module.
*/

group+OPort StringEntry<NEvisible=0> {
   int+IPort2+write active;
   string+IPort2+write item;
};

module StringList<NEvisible=0> {
   long &nentries => array_size(entries);
   StringEntry+IPort2 &entries[] {
      int active;
   };
   StringEntry+OPort2+write+nonotify &selected;
   /* 
    * Need to set the write flag and have all conn's
    * go through this object so that we end up with
    * the proper dependency.
    */
   int+Oparam active => selected.active;
   method+notify_val update = "select_entry";
};

module shell_command {
   string+IPort2+read+req command;
   int+nonotify+read active;
   int+nonotify+read on_inst;
   // output string value as well as stdout char array
   // turn this off for large buffers of data for performance
   boolean+nonotify+read output_string = 1;
   char+OPort2+write stdout[];
   string+OPort2+write stdout_string;
   //
   // no_meth_ctx allows sub-objects that are added to this object to
   // cause this guy to fire.  We need to do this since the "command"
   // string can rely on variables that are added to this object
   // after it was created to trigger this guy to run.
   //
   omethod+notify+req+notify_inst shell_comm_update<no_meth_ctx=1> = 
				"GMODshell_command";
};

// This module sets up the error dialog system
// The explicit destructor is to help fix CFS 25121.
module err_handler <use_src_file=0,
        /* declare a destructor and an class member variable. */
        cxx_members=<"
      ~GMOD_err_handler();
      int _enabled;
        ">,
        cxx_members_constr="_enabled(0)"> {
  string+OPort2+write err_message = "";
  int+OPort2+write num_lines;
  boolean+read+notify enabled = 1;
  cxxmethod+notify_inst instance<status=0>;
  cxxmethod+notify_deinst deinstance<status=0>();
};

module exit_process {
   int+read+notify+req+IPort2 do_exit;
   int+read+IPort2 status;
   omethod+req update = "GMODexit_process";
};

//
// A library of modules for compatability with older versions
// they are here since this library is global and the GMOD library
// used to be global.
//
library Compat<NEvisible=0,user_library=0> {
   GMOD.parse_v parse_v_relative;
   GMOD.parse_v parse_v_relative_no_inst {
      on_inst = 0;
   };
   GMOD.load_v_script load_scr_relative;
};

module hconnect<hconnect=1> {
   int+read direction;
   string+read offer_name;
   string+read accept_name;
   string+read accept;
   string+read offer;
   int+read skip_levels;
   int+write accepted = 0;
   int order; // order for direction = 1 objects to be inserted in the list.
   data_method+noevents default_func;
   omethod+notify_inst hconn_inst<weight=0,NEvisible=0> = "GMODhconnect_inst";
   // need separate inst/deinst methods so deps work out ok.
   omethod+notify_deinst hconn_deinst<weight=0,NEvisible=0>() = "GMODhconnect_inst";
};

module morph {
   int morph_type;
   flibrary morph_types<NEeditable=1,active_library=1>;
   group *morph_obj;
   omethod+notify_inst morph_inst<weight=0,NEvisible=0>(morph_type+notify+read)
		= "GMODmorph_inst";
   int old_index<NEvisible=0>;
};

module select_array {
   boolean+notify+read select[];
   group+notify+read *array_input[];
   group+write *array_output[];
   omethod+notify_inst update = "GMODselect_array";
};

// Formerly this was UIstr_choice
module str_choice {
   int+read nchoices => array_size(choices);
   string+Iparam choices[];

   // Export this in & out
   int+read+write+notify+Port2 selected_index;
   string+read+write+Port2 selected_string;

   omethod+notify_val+notify_inst update<interruptable=0> =
        "GMODstr_choice_update";
};

// Reverse the order of a list of groups
module group_reverse {
   group+read+notify+req+IPort2 &in_groups[];
   group+write+nonotify+OPort2  &out_groups[];

   omethod+notify_val+notify_inst update = "GMODgroup_reverse_update";
};

// E.g., triggering something off (UIradionBoxLabel.selectedItem == xx)
// generates excess activations.  Instead. hook this guy up and
// trigger off of demux.output[xx].trigger
module demux {
   int+IPort2 input;
   int+IPort2 input_max;

   group+OPort2 output[input_max] {
      int trigger;
   };

   omethod+notify_inst+req update (
      .input+read+notify+req,
      .output+write
   ) = "GMODdemux_update";
};

library GMODInternal<NEvisible=0> {
   group constrain {
     float+read+write+notify+req      min;
     float+read+write+notify+req      max;
     float+read+nonotify+req          delta = 0.01;
     cxxmethod+notify update =
     <"
	if      (min.changed(seq_num) && min >= max) max = min + delta;
	else if (max.changed(seq_num) && max <= min) min = max - delta;
	return(1);
     ">;
   };
   /*
    * Module used to maintain the correspondence between a
    * a floating point value and an integer "set" value.  The integer
    * is going to be 1 when the value is valid, and 0 when the value is
    * not valid.  If the set integer changes, we change the value and
    * vice versa
    */
   module inherit_value {
     prim+read+write+notify value;
     int+read+write+notify set;
     prim+read default_value;
     cxxmethod+notify_inst update =
     <"
	if (value.changed(seq_num)) {
	    if (value.valid_obj()) {
	       if (set) set = 0;
	    }
	    else if (!set) set = 1;
	}
	else if (set.changed(seq_num)) {
	    if (!set) {
	       value = default_value;
	    }
	    else {
	       /*
		* Clear the value of "value's" value
		*/
	       OMset_obj_val(value.obj_val(), OMnull_obj, 0);
	    }
	}
	return(1);
     ">;
   };
   module parent_value {
     prim+read+write+notify child_value;
     prim+read+notify parent_value;
     prim+read+write+notify value;
     cxxmethod+notify_inst update =
     <"
	// If the user changed the value, we always update the child value
	if (!(event_mask & OM_EVENT_INST) && value.changed(seq_num)) {
	    child_value = value;
	}
	// If the child has an explicit value, we use this for the parent
	// Otherwise, we use the parent's value.
	else if (child_value.valid_obj()) {
	    value = child_value;
	}
	else {
	    value = parent_value;
	}
	return(1);
     ">;
   };
   /*
    *  The selected_index module assigns as its output the index of the
    *  first nonzero element of its input array.
    */
   module selected_index {
      boolean+notify+read select[];
      long+write output;
      omethod+notify_inst update = "GMODselected_index";
   };

   /* keep a two-way connection between a signed value and it's
      sign and absolute value */
   module signed_value {
     int+read+write+notify sign_flag<NEportLevels={2,2}>;
     float+read+write+notify abs_value<NEportLevels={2,2}>;
     float+read+write+notify signed_val<NEportLevels={2,2}>;
     cxxmethod+notify_inst update =
     <"
	if (signed_val.changed(seq_num) &&
            signed_val.valid_obj()) {
            if (signed_val < 0.0) {
                sign_flag = 1;
                abs_value = -(float) signed_val;
            } else {
               sign_flag = 0;
               abs_value = (float) signed_val;
            }
        } else if (sign_flag.changed(seq_num) ||
                   abs_value.changed(seq_num)) {
            if (sign_flag.valid_obj() && abs_value.valid_obj()) {
                // Make sure the value is stored in the app, not the
                // UI.  This is necessary for the intended use for
                // the graph editor.
                OMset_state_mode(OM_STATE_USR);
                if (sign_flag)
                    signed_val = -(float) abs_value;
                else
                    signed_val = (float) abs_value;
            }
        }
	return(1);
     ">;
   };
};

};
