/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/axis2d.v#1 $
*/

APPS.MultiWindowApp Axis2D<NEdisplayMode="maximized",
                           NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example demonstrates the use of the Basic_Axis2D macro(which is located in the Geometries library in the Main NE page). This just creates 2 lines for the axes and uses a text_glyph macro to create annotation.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D<NEx=440.,NEy=451.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.reset_xform.out_obj,<-.<-.<-.Basic_Axis2D.out_obj};
            Xform {
               mat = {
                  0.0532801,0.,0.,0.,0.,0.0532801,0.,0.,0.,0.,0.0532801,0.,
0.,0.,0.,1.
               };
               xlate = {-3.01997,-4.50324,0.};
            };
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 243;
                        defaultY = 424;
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_Field Read_Field<NEx=396.,NEy=66.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/helens1.fld";
      };
   };
   HLM.Basic_Axis2D Basic_Axis2D<NEx=550.,NEy=220.> {
      axis {
         xform {
            mat = {
               10.,0.,0.,0.,0.,10.,0.,0.,0.,0.,10.,0.,0.,0.,0.,1.
            };
         };
      };
      probe_edit {
         GDxform_editor {
            scale = 10.;
            abs_scale = 10.;
         };
         XformEditorUI {
            trans_shell {
               x = 631;
               y = 264;
               ok = 1;
            };
         };
      };
      Axis_scale_X = 10.;
      Axis_scale_Y = 15.;
      Axis_title_X = "Helen's X";
      Axis_title_Y = "Helen's Y";
   };
   MODS.reset_xform reset_xform<NEx=396.,NEy=176.> {
      in_field => <-.Read_Field.field;
      xfm {
         xform {
            mat = {
               0.282479,0.,0.,0.,0.,0.282479,0.,0.,0.,0.,0.282479,0.,0.,
0.,0.,1.
            };
         };
      };
   };
};
