/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/axis3d.v#1 $
*/

APPS.MultiWindowApp Axis3D<NEdisplayMode="maximized",
                           NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example demonstrates the use of the Basic_Axis3D macro (which is located in the Geometries library in the Main NE page). This just creates 3 lines for the axes and uses a text_glyph macro to create annotation.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D<NEx=350.,NEy=435.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,<-.<-.<-.Basic_Axis3D.out_obj};
            Xform {
               mat = {
                  0.095041,0.0289996,-0.0845352,0.,0.0166367,0.115504,0.0583275,
0.,0.0878088,-0.0532719,0.0804468,0.,0.,0.,0.,1.
               };
               xlate = {-3.71411,-3.97038,-3.20626};
            };
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 58;
                        defaultY = 340;
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/turbine.fld";
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   HLM.Basic_Axis3D Basic_Axis3D {
      axis {
         xform {
            mat = {
               14.8,0.,0.,0.,0.,14.8,0.,0.,0.,0.,14.8,0.,0.,0.,0.,1.
            };
         };
      };
      Axis_UI {
         probe_edit {
            GDxform_editor {
               scale = 14.8;
               abs_scale = 14.80000019;
            };
            XformEditorUI {
               trans_shell {
                  x = 718;
                  y = 292;
                  ok = 1;
               };
            };
         };
      };
      Axis_scale_Y = 2.;
      Axis_scale_Z = 3.;
   };
};
