/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/bubblevz.v#1 $
*/

APPS.MultiWindowApp Bubbleviz<NEdisplayMode="maximized",
                              NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "Bubbleviz shows how the Bubbleviz macro can be used. The Bubbleviz macro is an adaption of using the glyph macro. It just uses glyph and Sphere to construct a spherical glyph at each location in the input field.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,<-.<-.<-.Bubbleviz.out_obj};
            Xform {
               mat = {
                  0.140741,0.0429438,-0.125183,0.,0.0246363,0.171042,0.0863737,
0.,0.130031,-0.0788872,0.119129,0.,0.,0.,0.,1.
               };
               xlate = {-5.54634,-3.88846,-3.96435};
            };
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 193;
                        defaultY = 362;
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/wind.fld";
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   HLM.Bubbleviz Bubbleviz {
      glyph {
         in_field => <-.<-.extract_scalar.out_fld;
         GlyphParam {
            scale = 0.89;
         };
      };
   };
   MODS.extract_scalar extract_scalar {
      in_field => <-.orthoslice.out_fld;
   };
   MODS.orthoslice orthoslice {
      in_field => <-.Read_Field.field;
   };
};
