/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/offset.v#1 $
*/

APPS.MultiWindowApp Offset <NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows how a field's coordinates can be warped/modified according to an input vector node data. Note the use of the combine_vect macro to create the 3 component vector that is used to warp the field coordinates.";
      helpfile = "examples/examples_help.htm";
   };

   HLM.Offset Offset {
      in_field => <-.combine_vect.out_fld;
      OffsetUI {
         Offset_Scale {
            value = 0.5;
         };
      };
      Factor = 0.14;
   };
   MODS.Read_UCD Read_UCD {
      read_ucd_ui {
         file_browser {
            dirMaskCache = "$XP_PATH<0>/data/ucd/*.inp";
         };
         filename = "$XP_PATH<0>/data/ucd/box.inp";
      };
   };
   MODS.combine_vect combine_vect {
      in_field => <-.Read_UCD.field;
   };
   MODS.magnitude magnitude {
      in_field => <-.Offset.out_fld;
   };
   MODS.set_minmax set_minmax {
      in_field => <-.magnitude.out_fld;
      SetMinmaxParam {
         min => 0.;
         max => 15.;
      };
   };
   MODS.external_edges external_edges {
      in_field => <-.Read_UCD.field;
   };

   GDM.Uviewer3D Uviewer3D<NEx=350.,NEy=471.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.external_edges.out_obj,<-.<-.<-.set_minmax.out_obj};
            Xform {
               mat = {
                  2.68087,0.,0.,0.,0.,2.68087,0.,0.,0.,0.,2.68087,0.,0.,0.,0.,1.
               };
               xlate = {-0.281492,-1.31913,0.128237};
               ocenter = {0.105,0.492051,-0.0478342};
               dcenter = {0.281492,1.31913,-0.128237};
               center = {0.105,0.492051,-0.0478342};
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 350;
                        defaultY = 0;
                     };
                  };
               };
            };
         };
      };
   };
};
