/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/txtglyph.v#1 $
*/

APPS.MultiWindowApp Text_Glyph<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "Text_Glyph shows how the Text_Glyph macro can be integrated into a network. It is really just a wrapper on the text_glyph macro, with the annotation text being extracted from the data values in the field.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.Text_Glyph.text_glyph.out_obj,
               <-.<-.<-.external_faces.out_obj};
            Xform {
               mat = {
                  2.,0.,0.,0.,0.,2.,0.,0.,0.,0.,2.,0.,0.,0.,0.,1.
               };
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 3;
                        defaultY = 453;
                     };
                  };
               };
            };
         };
      };
   };
   HLM.Text_Glyph Text_Glyph {
      in_field => <-.Read_UCD.field;
      Display_Data = 1;
   };
   MODS.Read_UCD Read_UCD {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/cells.inp";
      };
   };
   MODS.external_faces external_faces {
      in_field => <-.Read_UCD.field;
   };
};
