/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ip.v#1 $
*/
flibrary+global IP<
        needs_use_lic="GD",needs_edit_lic="DV",
        compile_subs=0,
        disabled => Templates.CONFIG.ip_kit_disabled> {

flibrary+global+buffered Interface {
    macro IPfldToImage {
	int				DataTypes[] = { 0, 0, 1, 2, 3, 4, 5 };
	IPbase.IPfld+Iparam		&In;
	IPbase.ip_Image_InByte+OPort2	Image {
	    xsize	=> In.dims[0];
	    ysize	=> In.dims[1];
	    data	=> <-.In.node_data[0].values;
	    data_type	=> <-.DataTypes[data_type_of(data)];
	};
    };

    IPbase.ip_Roi_conv IPimageToROI;

    macro IPfldToROI {
	IPbase.IPfld+Iparam		&In;
	IPfldToImage			Conv {
	    In => <-.In;
	};
	IPimageToROI			ROI {
	    In => <-.Conv.Image;
	    Roi<NEportLevels={0,3}>;
	};
    };

    macro IPread_AVS_Image {
	UImod_panel Panel {
	    title => name_of(<-.<-);
	    message = "Select read image control panel.";
	    parent<NEportLevels={3,0}>;
	};

        UIlabel Image_Filename {
            parent => Panel;
            y = 0;
            width => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => Panel;
            y => Image_Filename.y + Image_Filename.height + 5;
            text => FileSB.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton visible {
            parent => Panel;
            x => file_name.x + file_name.width + 5;
            y => file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };

	UIfileSB FileSB {
            GMOD.copy_on_change copy_on_change {
                trigger => <-.<-.visible.do;
                input => <-.<-.visible.do;
                output => <-.visible;
            };
	    title = "Read IMAGE Filename";
	    searchPattern = "$XP_PATH<0>/data/image/*.x";
	};

	DVread_image ReadImage {
	    filename => FileSB.filename;
	    flip = 0;
	    out {
		xform.rspace = 2;
	    };
	};

	DVextr_scalar		scalarData {
	    in => <-.ReadImage.out;
	    component = 1;
	};

	DVcomb_mesh_and_data	scalarField {
	    in_mesh => <-.ReadImage.out;
	    in_nd => <-.scalarData.out;
	};

	IPfldToImage		FldToImage {
	    In => <-.scalarField.out;
	    Image+OPort3;
	};
    };

    macro IPimageToFld {
	IPbase.ip_Image_In+IPort2	&In;
	IPbase.IPfld+Oparam		TmpField {
	    dims => { In.xsize, In.ysize };
	    points => { { 0, 0 }, { In.xsize - 1, In.ysize - 1 } };
	    !node_data[0] {
		values => In.data_ptr;
	    };
	};
	DataObjectNoTexture		dataObject {
	    in => TmpField;
	    obj+OPort3;
	    DMAP.GreyScaleDatamap Datamap<NEx=22,NEy=286> {
		dataMin => <-.MinMax.min_value;
		dataMax => <-.MinMax.max_value;
	    };
	};
    };
};

/*
 * Base types for IP user interfaces.
 */
flibrary+global+buffered IPui {
    /*
     * Base template object for all IP macros
     */
    macro IPmacro {
	UImod_panel Panel {
	};
    };

    /*
     * Basic Image in, Image out type of function. Images must be
     * same size.
     */

    /* One In */
    macro IP1i {
	IPbase.ip_Image	     &in_image<NEportLevels={2,1}>;
    };

    /* Two In */
    macro IP2i {
	IPbase.ip_Image	     &in_image1<NEportLevels={2,1}>;
	IPbase.ip_Image	     &in_image2<NEportLevels={2,1}>;
    };

    /* One In, One Out */
    macro IP1i1o {
	IPbase.ip_Image		&in_image<NEportLevels={2,1}>;
	group			work_func {
	    IPbase.ip_Image_Out		dst;
	};
	IPimageToFld		Cvt {
	    In => <-.work_func.dst;
	    TmpField+OPort3;
	    dataObject.obj<NEportLevels={0,4}>;
	};
    };

    /* One In, One Out of type Byte */
    macro IP1i1ob {
	IPbase.ip_Image		&in_image<NEportLevels={2,1}>;
	group			work_func {
	    IPbase.ip_Image_Out		dst;
	};
	IPimageToFld		Cvt {
	    In => <-.work_func.dst;
	    TmpField+OPort3;
	    dataObject.obj<NEportLevels={0,4}>;
	};
    };

    /* One In, Two Out */
    macro IP1i2o {
	IPbase.ip_Image		&in_image<NEportLevels={2,1}>;
	group			work_func {
	    IPbase.ip_Image_Out		dst1;
	    IPbase.ip_Image_Out		dst2;
	};
	IPimageToFld		Cvt1 {
	    In => <-.work_func.dst1;
	    TmpField+OPort3;
	    dataObject.obj<NEportLevels={0,4}>;
	};
	IPimageToFld		Cvt2 {
	    In => <-.work_func.dst2;
	    TmpField+OPort3;
	    dataObject.obj<NEportLevels={0,4}>;
	};
    };

    /* Two In, One Out */
    macro IP2i1o {
	IPbase.ip_Image	     &in_image1<NEportLevels={2,1}>;
	IPbase.ip_Image	     &in_image2<NEportLevels={2,1}>;
	group			work_func {
	    IPbase.ip_Image_Out		dst;
	};
	IPimageToFld	    Cvt {
	    In => <-.work_func.dst;
	    TmpField+OPort3;
	    dataObject.obj<NEportLevels={0,4}>;
	};
    };

    /* Two In, One Out, Another In */
    macro IP2i1o1i {
	IPbase.ip_Image	     &in_image1<NEportLevels={2,1}>;
	IPbase.ip_Image	     &in_image2<NEportLevels={2,1}>;
	IPbase.ip_Image	     &in_image3<NEportLevels={2,1}>;
	group			work_func {
	    IPbase.ip_Image_Out		dst;
	};
	IPimageToFld	    Cvt {
	    In => <-.work_func.dst;
	    TmpField+OPort3;
	    dataObject.obj<NEportLevels={0,4}>;
	};
    };

    /* One Roi in */
    macro IP1r {
	IPbase.ip_Roi	     &in_roi<NEportLevels={2,1}>;
    };

    /*
     * IP label and field panel
     */
    macro IPlabelField {
	ilink Parent;
	ilink Label;
        UIpanel FieldPanel {
            parent<NEportLevels={3,0}> => Parent;
            height = 70;
        };
	UIlabel String {
	    parent => FieldPanel;
	    y = 0;
	    width => <-.Parent.width / 2;
	    label => Label;
	};
	UIfield Field {
	    parent => FieldPanel;
            x => String.x + String.width;
	    y => <-.String.y;
	    width => <-.Parent.width / 2;
	    value => Value;
	};
	olink Value;
    };

    /*
     * IP label and field panel, output only
     */
    IPlabelField IPlabelFieldOutputOnly {
	Field.outputOnly = 1;
    };

    /*
     * IP label and text panel
     */
    macro IPlabelText {
	ilink Parent;
	ilink Label;
	UIpanel TextPanel {
	    parent<NEportLevels={3,0}> => Parent;
	    height = 70;
	};
	UIlabel String {
	    parent => TextPanel;
	    y = 0;
	    label => Label;
	};
	UItext Text {
	    parent => TextPanel;
	    x => String.x + String.width;
	    columns = 60;
	    text<NEportLevels={0,3}>;
	};
	olink Value;
    };

    /*
     * IP label and text panel, output only
     */
    IPlabelText IPlabelTextOutputOnly {
	Text.outputOnly = 1;
    };

    /*
     * One constant
     */
    macro IP1c {
	IPlabelField	    Const;
    };

    /*
     * One text typein
     */
    macro IP1t {
	IPlabelText	    Text;
    };

/*-------------------------------------------------------------------------*/
    /*
     * This is the Module Stack style UI for selecting the
     * type of the image.
     */
    macro IPdataTypeUI {
	ilink	    Parent;

	string	    Types[] => { "Byte", "Short", "Float" };

	int	    TypeVals[] => { 0, 1, 3 };

	label_cmd   SelTypes {
	    labels[] => Types;
	};

	UIradioBox  TypesRB {
	    parent => Parent;
	    width => <-.Parent.width;
	    selectedItem = 0;
	    cmdList => SelTypes.cmd;
	};

	int+Oparam	Type => TypeVals[TypesRB.selectedItem];
    };

    macro IPdataType {
        IPui.IPdataTypeUI TypeUI;
	};
/*-------------------------------------------------------------------------*/
    /*
     * This is the Module Stack style UI for selecting the
     * type of selection region.
     */
    macro IPselTypeUI {
	ilink	    Parent;

	IPlib.ip_Data_Names Names;
	Names.file => file_name.text;

	UIlabel file_label {
	    parent => Parent;
	    label = "Sel File";
	    y = 0;
	    width => <-.Parent.width;
	};

	UItext file_name {
	    parent => Parent;
	    y => <-.file_label.y + <-.file_label.height + 4;
	    width => <-.Parent.width;
	    text<NEportLevels={0,3}> = "$XP_PATH<0>/data/ip/sels.ip";
	};

	UIlabel name_label {
	    parent => Parent;
	    label = "Sel Name";
	    y => <-.file_name.y + <-.file_name.height + 4;
	    width => <-.Parent.width;
	};

	UIlist sel_name {
	    parent => Parent;
            strings+IPort2 => Names.names;
	    y => <-.name_label.y + <-.name_label.height + 4;
	    width => <-.Parent.width;
	    selectedItem = 0;
	};

	/* here for compat with older UI */
	string	    Files[] => { "$XP_PATH<0>/data/ip/sels.ip/cross3x3",
				 "$XP_PATH<0>/data/ip/sels.ip/cross5x5",
				 "$XP_PATH<0>/data/ip/sels.ip/rect3x3",
				 "$XP_PATH<0>/data/ip/sels.ip/rect5x5" };

	label_cmd   SelFiles {
	    labels[] => { "Cross 3x3",	"Cross 5x5",
			  "Rectangle 3x3", "Rectangle 5x5" };
	};

	UIradioBox  FilesRB {
	    parent => Parent;
	    selectedItem = 0;
	    cmdList => SelFiles.cmd;
	    y => <-.sel_name.y + <-.sel_name.height + 4;
	    width => <-.Parent.width;
	    visible = 0;
	};

	string+Oparam &FileName => Names.file + "/" + sel_name.selectedText;
    };

    macro IPsel {
	IPui.IPselTypeUI SelUI;
	IPbase.ip_Sel Sel;
    };

/*-------------------------------------------------------------------------*/
    /*
     * This is the Module Stack style UI for selecting the
     * type of kernel.
     */
    macro IPkernelTypeUI {
	ilink	    Parent;

	IPlib.ip_Data_Names Names;
	Names.file => file_name.text;

	UIlabel file_label {
	    parent => Parent;
	    label = "Kernal File";
	    y = 0;
	    width => <-.Parent.width;
	};

	UItext file_name {
	    parent => Parent;
	    y => <-.file_label.y + <-.file_label.height + 4;
	    width => <-.Parent.width;
	    text<NEportLevels={0,3}> = "$XP_PATH<0>/data/ip/kernels.ip";
	    outputOnly = 1;
	};

	UIlabel name_label {
	    parent => Parent;
	    label = "Kernal Name";
	    y => <-.file_name.y + <-.file_name.height + 4;
	    width => <-.Parent.width;
	};

	UIlist kernel_name {
	    parent => Parent;
            strings+IPort2 => Names.names;
	    y => <-.name_label.y + <-.name_label.height + 4;
	    width => <-.Parent.width;
	    selectedItem = 0;
	    selectedText = "";
	};

	string+Oparam &Name => Names.file + "/" + kernel_name.selectedText;
    };

    macro IPkernel {
	IPui.IPkernelTypeUI KernelUI;
        IPbase.ip_Kernel Kernel;
    };
/*-------------------------------------------------------------------------*/

    /*
     * Composite IPmacros
     */
    IPmacro+IP1i	IPmacro1i;
    IPmacro+IP2i	IPmacro2i;
    IPmacro+IP1i1o	IPmacro1i1o;
    IPmacro+IP1i1ob	IPmacro1i1ob;
    IPmacro+IP1i2o	IPmacro1i2o;
    IPmacro+IP1i1o+IP1c IPmacro1i1o1c {
	Panel.rowColumnBehavior = 1;
	group work_func {   /* fake work_func, to auto connect the constant */
	    int Const;
	};
	Const {
	    Parent => Panel;
	    Field {
		min = -255;
		max = 255;
		mode = 1;
	    };
	    Value => work_func.Const;
	};
    };

    IPmacro+IP1i1o+IP1t IPmacro1i1o1t {
	Text.Parent => Panel;
    };

    IPmacro1i1o+IPsel IPmacro1i1oSel {
	SelUI.Parent => Panel;
	Sel.FileName => SelUI.FileName;
    };

    IPmacro1i1o1t+IPkernel IPmacro1i1o1tKernel {
	KernelUI.Parent => Panel;
	Kernel.FileName => Text.Text.text;
    };

    IPmacro1i1o+IPdataType IPmacro1i1oType {
	TypeUI.Parent => Panel;
    };

    IP1i+IP1r		IP1i1r;
    IP1i1o+IP1r		IP1i1o1r;
    IP2i1o+IP1r		IP2i1o1r;
    IPmacro1i+IP1r	IPmacro1i1r;
    IPmacro2i+IP1r	IPmacro2i1r;
    IPmacro1i1o+IP1r	IPmacro1i1o1r;
    IPmacro1i1ob+IP1r	IPmacro1i1ob1r;
    IPmacro1i1o1c+IP1r  IPmacro1i1o1c1r;
    IPmacro1i1o1t+IP1r  IPmacro1i1o1t1r;
    IPmacro1i1oSel+IP1r IPmacro1i1oSel1r;
    IPmacro1i1o1tKernel+IP1r IPmacro1i1o1tKernel1r;
    IPmacro1i1oType+IP1r IPmacro1i1oType1r;

};

flibrary+global+sort+buffered Macros {
    IPui.IPmacro IPvariance {
	Panel {
	    title => name_of(<-.<-);
	    message = "Variance statistics for IP image.";
	};
	Panel.rowColumnBehavior = 1;

	IPui.IPlabelFieldOutputOnly NPix {
	    Parent => Panel;
	    Label = "Pixels";
	    Value => work_func.npix;
	};
	IPui.IPlabelFieldOutputOnly Mean {
	    Parent => Panel;
	    Label = "Mean";
	    Value => work_func.mean;
	};
	IPui.IPlabelFieldOutputOnly Var {
	    Parent => Panel;
	    Label = "Variance";
	    Value => work_func.var;
	};

	IPfunc.ip_variance work_func {
	    src<NEportLevels={3,0}>;
	    roi<NEportLevels={3,0}>;
	};
    };

    IPui.IPmacro IPextrema {
	Panel {
	    title => name_of(<-.<-);
	    message = "Extrema statistics for IP image.";
	};
	Panel.rowColumnBehavior = 1;

	IPui.IPlabelFieldOutputOnly Max {
	    Parent => Panel;
	    Label = "Max";
	    Value => work_func.max;
	};
	IPui.IPlabelFieldOutputOnly Min {
	    Parent => Panel;
	    Label = "Min";
	    Value => work_func.min;
	};

	IPfunc.ip_extrema work_func {
	    src<NEportLevels={3,0}>;
	    roi<NEportLevels={3,0}>;
	};
    };

    IPui.IPmacro2i IPcompare {
	Panel {
	    title => name_of(<-.<-);
	    message = "Compare two images.";
	};

	string results[] => { "No Differences Found",
			      "Pixel Types Differ",
			      "Image Sizes Differ",
			      "Number of Bands Differ",
			      "Pixel Values Differ" };

	UItext ResultString {
	    parent => Panel;
	    width => <-.Panel.width;
	    outputOnly = 1;
	    text => results[work_func.res];
	};
        IPui.IPlabelFieldOutputOnly Diffs {
            Parent => Panel;
            Label = "Difference Count";
            Value => work_func.diffs;
	    Field.mode = 1;
        };

	IPfunc.ip_compare	     work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	};
    };

    IPui.IPmacro1i IPread_line {
	Panel {
	    title => name_of(<-.<-);
	    message = "Read image data along a line.";
	};

	IPui.IPlabelField y2UI {
	    Parent => Panel;
	    Label = "y2";
	    Field {
		mode = 1;
	    };
	    Value => work_func.y2;
	};

	y2UI x2UI {
	    Label = "x2";
	    Value => work_func.x2;
	};

	y2UI y1UI {
	    Label = "y1";
	    Value => work_func.y1;
	};

	y1UI x1UI {
	    Label = "x1";
	    Value => work_func.x1;
	};

	IPfunc.ip_read_line work_func {
	    src => in_image;
	    buf<NEportLevels={0,3}>;
	    npixels<NEportLevels={0,3}>;
	};
    };

#ifdef USING_CONTOURS
    IPui.IPmacro1i1o IPcontour {
	Panel {
	    title => name_of(<-.<-);
	    message = "Draw iso-level contours on an image.";
	};
	Panel.rowColumnBehavior = 1;

	IPui.IPlabelField NLevels {
	    Parent => Panel;
	    Label = "Contours";
	    Field {
		mode = 1;
		min = 1;
		max = 5;
	    };
	    Value = 1;
	};
	IPui.IPlabelField Values {
	    Parent => Panel;
	    Label = "Value";
	    Field {
		mode = 1;
	    };
	    Value => work_func.levels[CurLevel.value-1];
	};

	UIslider                CurLevel {
	    parent => Panel;
	    width => <-.Panel.width;
	    mode = 1;
	    min = 1;
	    max => work_func.nlevels;
	    value = 1;
	    title = "Current Level";
	};

	IPfunc.ip_contour	     work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    nlevels => NLevels.NLevelsField.value;
	    levels[] = { 0 };
	};
    };
#endif

    IPui.IPmacro1i1ob1r IPthreshold {
	Panel {
	    title => name_of(<-.<-);
	    message = "Image threshold operator.";
	};
	UIslider                  LowUI {
	    parent => Panel;
	    width => <-.Panel.width;
	    min = 0;
	    max = 255;
	    value = 0;
	    title = "Low Value";
	};
	LowUI           HighUI {
	    y => LowUI.y + LowUI.height;
	    value = 255;
	    title = "High Value";
	};
	UItoggle InvUI {
	    parent => <-.Panel;
	    width => <-.Panel.width;
	    y => HighUI.y + HighUI.height + 6;
	    label = "Invert";
	    set = 0;
	};

	IPfunc.ip_threshold      work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    lo => LowUI.value;
	    hi => HighUI.value;
	    inv => InvUI.set;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1r IPlinremap {
	Panel {
	    title => name_of(<-.<-);
	    message = "Linearly remap an image.";
	};
	UIslider                  ConstUI {
	    parent => Panel;
	    width => <-.Panel.width;
	    min = -255;
	    max = 255;
	    value = 0;
	    title = "Constant";
	};
	ConstUI           MultUI {
	    y => ConstUI.y + ConstUI.height;
	    value = 1;
	    title = "Multiplier";
	};

	IPfunc.ip_linremap      work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    con => ConstUI.value;
	    mul => MultUI.value;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1r IPhistogram {
	Panel {
	    title => name_of(<-.<-);
	    message = "Construct image histogram.";
	};

	UIslider                  HighUI {
	    parent => Panel;
	    y => <-.BinsUI.y + <-.BinsUI.height + 60;
	    width => <-.Panel.width;
	    min = 0;
	    max = 255;
	    value => work_func.high;
//	    value = 255;
	    title = "Upper Limit";
	};

	HighUI			  LowUI {
	    y => <-.BinsUI.y + <-.BinsUI.height;
	    value => work_func.low;
//	    value = 0;
	    title = "Lower Limit";
	};

	UIslider                  BinsUI {
	    parent => Panel;
	    width => <-.Panel.width;
	    min = 1;
	    max = 256;
	    value => work_func.nbins;
	    title = "Number of Bins";
	};

	IPfunc.ip_histogram      work_func {
	    src => in_image;
	    bins<NEportLevels={0,3}>;
//	    nbins<NEportLevels={0,3}> => BinsUI.value;
	    nbins<NEportLevels={0,3}>;
//	    low => LowUI.value;
//	    high => HighUI.value;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1r IPedge {
	Panel {
	    title => name_of(<-.<-);
	    message = "Edge enhancement.";
	};
	label_cmd MethOpts {
	    labels[] => { "Prewitt", "Roberts", "Compass", "Frei Chan",
			  "Marr Hildreth", "Nevatia Babu", "Robinson 3",
			  "Robinson 5", "Macleod", "Argyle", "Kirsh",
			  "Boxcar", "Sobel", "Derivative of Gaussian",
			  "Weighted Line", "Unweighted Line" };
	};

	int &width_visible[] => { 0, 0, 0, 0,
				  1, 0, 0,
				  0, 1, 1, 0,
				  1, 0, 1,
				  0, 0 };
	int &height_visible[] => { 0, 0, 0, 0,
				   0, 0, 0,
				   0, 1, 1, 0,
				   1, 0, 1,
				   0, 0 };

	UIradioBox              MethodsRB {
	    parent => Panel;
	    selectedItem = 12;
	    cmdList => MethOpts.cmd;
	    y = 0;
	    width => <-.Panel.width;
	};
	UIslider                  WidthUI {
	    parent => Panel;
	    y => <-.MethodsRB.y + <-.MethodsRB.height + 5;
	    width => <-.Panel.width;
	    visible => width_visible[MethodsRB.selectedItem];
	    min = 0.1;
	    max = 10.0;
	    value = 3.0;
	    title = "Filter Width";
	};
	WidthUI                 HeightUI {
	    y => <-.WidthUI.y + <-.WidthUI.height;
	    visible => height_visible[MethodsRB.selectedItem];
	    title = "Filter Height";
	};

	IPfunc.ip_edge   work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    alg => MethodsRB.selectedItem + 1;
	    hwidth => WidthUI.value;
	    vwidth => HeightUI.value;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1oSel1r IPerode {
	Panel {
	    title => name_of(<-.<-);
	    message = "Erode image using structuring element";
	};

	/* here for compat with older UI */
	GMOD.parse_v parse_v {
	    v_commands = "SelUI.Files[FilesRB.selectedItem] = SelUI.sel_name.selectedItem;";
	    trigger => <-.SelUI.sel_name.selectedText;
	    on_inst = 0;
	    relative => <-;
	};

	IPfunc.ip_erode  work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    sel => Sel;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1oSel1r IPdilate {
	Panel {
	    title => name_of(<-.<-);
	    message = "Dilate image using structuring element";
	};

	/* here for compat with older UI */
	GMOD.parse_v parse_v {
	    v_commands = "SelUI.Files[FilesRB.selectedItem] = SelUI.sel_name.selectedItem;";
	    trigger => <-.SelUI.sel_name.selectedText;
	    on_inst = 0;
	    relative => <-;
	};

	IPfunc.ip_dilate work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    sel => Sel;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1oSel1r IPmedian {
	Panel {
	    title => name_of(<-.<-);
	    message = "Median filter an image";
	};

	/* here for compat with older UI */
	GMOD.parse_v parse_v {
	    v_commands = "SelUI.Files[FilesRB.selectedItem] = SelUI.sel_name.selectedItem;";
	    trigger => <-.SelUI.sel_name.selectedText;
	    on_inst = 0;
	    relative => <-;
	};

	IPfunc.ip_median  work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    sel => Sel;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1tKernel1r IPconvolve {
	Panel {
	    title => name_of(<-.<-);
	    message = "Convolve image using specified kernel";
	};

	/* for compat with older UI... */
	Text.Label = "Kernel Name";
	Text.TextPanel.y = 200;
	Text.TextPanel.visible = 0;
	Kernel.FileName => "$XP_PATH<0>/data/ip/kernels.ip/" + Text.Text.text;
	GMOD.parse_v parse_v {
	    v_commands = "Text.Text.text = KernelUI.kernel_name.selectedText;";
	    trigger => <-.KernelUI.kernel_name.selectedText;
	    on_inst = 0;
	    relative => <-;
	};

	IPfunc.ip_convolve work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    kernel => Kernel;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1c1r IPand_const {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform logical and with scalar operation on an IP image.";
	};

	Const.Label = "And Constant";

	IPfunc.ip_and_const     work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1c1r IPor_const {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform logical or with scalar operation on an IP image.";
	};

	Const.Label = "Or Constant";

	IPfunc.ip_or_const	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1c1r IPxor_const {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform logical or with scalar operation on an IP image.";
	};

	Const.Label = "Xor Constant";

	IPfunc.ip_xor_const	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1c1r IPmin_const {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform min with scalar operation on an IP image.";
	};

	Const.Label = "Min Constant";

	IPfunc.ip_min_const	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1c1r IPmax_const {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform max with scalar operation on an IP image.";
	};

	Const.Label = "Max Constant";

	IPfunc.ip_max_const	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1c1r IPmul_const {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform multiply with scalar operation on an IP image.";
	};

	Const.Label = "Mul Constant";

	IPfunc.ip_mul_const	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o1c1r IPadd_const {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform add with scalar operation on an IP image.";
	};

	Const.Label = "Add Constant";

	IPfunc.ip_add_const	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPadd {
	IPfunc.ip_add	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPsubtract {
	IPfunc.ip_subtract	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPmultiply {
	IPfunc.ip_multiply	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPdivide {
	IPfunc.ip_divide	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPand {
	IPfunc.ip_and	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPnand {
	IPfunc.ip_nand	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPnor {
	IPfunc.ip_nor	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPnot {
	IPfunc.ip_not	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPabs {
	IPfunc.ip_abs	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPor {
	IPfunc.ip_or	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPxor {
	IPfunc.ip_xor	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	};
    };

    IPui.IP2i1o1r IPmin {
	IPfunc.ip_min	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1r IPmax {
	IPfunc.ip_max	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP2i1o1i IPblend {
	IPfunc.ip_blend	    work_func {
	    src1 => in_image1;
	    src2 => in_image2;
	    dst<NEportLevels={0,3}>;
	    src3 => in_image3;
	};
    };

    IPui.IPmacro1i1o IPreflect {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform a reflection/rotation of an IP image.";
	};
	label_cmd               MethOpts {
	    labels[] => { "Horizontal", "Vertical", "Main Diagonal",
			  "Anti Diagonal", "Rotate 90", "Rotate 180",
			  "Rotate 270" };
	};
	UIradioBox              MethodsRB {
	    parent => Panel;
	    width => <-.Panel.width;
	    selectedItem = 0;
	    cmdList => MethOpts.cmd;
	};

	int &Widths[]  => { in_image.xsize, in_image.xsize, in_image.ysize,
			    in_image.ysize, in_image.ysize, in_image.xsize,
			    in_image.ysize };
	int &Heights[] => { in_image.ysize, in_image.ysize, in_image.xsize,
			    in_image.xsize, in_image.xsize, in_image.ysize,
			    in_image.xsize };
	IPbase.ip_Image	out_image<NEportLevels={0,2}> {
	    xsize => Widths[MethodsRB.selectedItem];
	    ysize => Heights[MethodsRB.selectedItem];
	};
	IPfunc.ip_reflect	work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    dst.xsize => Widths[MethodsRB.selectedItem];
	    dst.ysize => Heights[MethodsRB.selectedItem];
	    dir_code => MethodsRB.selectedItem;
	};
    };

    IPui.IPmacro1i1o IProtate {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform an arbitrary rotation of an IP image.";
	};
	label_cmd               MethOpts {
	    labels[] => { "Nearest Neighbor", "Bilinear", "Bicubic" };
	};
	UIradioBox              MethodsRB {
	    parent => Panel;
	    y = 0;
	    width => <-.Panel.width;
	    selectedItem = 0;
	    cmdList => MethOpts.cmd;
	};
	UIdial		    AngleDial {
	    parent => Panel;
	    y => <-.MethodsRB.y + <-.MethodsRB.height + 5;
	    width => <-.Panel.width / 2;
	    min = -180;
	    max = 180;
	    value = 0;
	    title = "Rotation Angle";
	};

	IPfunc.ip_rotate	work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    angle => -AngleDial.value * 3.1415926535 / 180;
	    int_code => MethodsRB.selectedItem + 1;
	};
    };

    IPui.IPmacro1i1o1r IPshift {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform shift bits operation on an IP image.";
	};

	UIslider	Const {
	    parent => Panel;
	    width => <-.Panel.width;
	    mode = 1;
	    min = -7;
	    max =  7;
	    value = 0;
	    title = "Shift NBits";
	};

	IPfunc.ip_shift	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    bits => Const.value;
	    roi => in_roi;
	};
    };

    IPui.IPmacro1i1o IPzoom {
	Panel {
	    title => name_of(<-.<-);
	    message = "Perform an arbitrary scaling of an IP image.";
	};
	label_cmd               MethOpts {
	    labels[] => { "Nearest Neighbor", "Bilinear", "Bicubic",
	                  "Adaptive" };
	};
	UIradioBox              MethodsRB {
	    parent => Panel;
	    selectedItem = 0;
	    cmdList => MethOpts.cmd;
	    width => <-.Panel.width;
	};
	macro		    Sliders {
	    UIpanel 	    SliderPanel {
		parent => Panel;
		width => <-.<-.Panel.width;
		y => MethodsRB.y + MethodsRB.height + 10;
		rowColumnBehavior = 1;
		height = 300;
	    };
	    UIslider	    x {
		parent => SliderPanel;
		width => <-.<-.Panel.width;
		min = 0;
		max => in_image.xsize - 1;
		title = "X Offset";
		value = 0;
	    };
	    x		    y {
		max => in_image.ysize - 1;
		title = "Y Offset";
	    };
	    UIslider	    ScaleX {
		parent => SliderPanel;
		width => <-.<-.Panel.width;
		min = 0.01;
		max = 10;
		title = "X Scale";
		value = 1;
	    };
	    ScaleX		    ScaleY {
		title = "Y Scale";
	    };
	};

	IPfunc.ip_zoom	work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    x => Sliders.x.value;
	    y => Sliders.y.value;
	    ScaleX => Sliders.ScaleX.value;
	    ScaleY => Sliders.ScaleY.value;
	    int_code => MethodsRB.selectedItem + 1;
	};
    };

    IPui.IPmacro1i1oType1r IPcopy {
	Panel {
	    title => name_of(<-.<-);
	    message = "Copy an image with implicit data type conversion";
	};

	IPfunc.ip_copy		    work_func {
	    DstType => <-.TypeUI.Type;
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o IPfft {
	IPfunc.ip_fft	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	};
    };

    IPui.IP1i1o IPifft {
	IPfunc.ip_ifft	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	};
    };

    IPui.IPmacro1i2o IPfft_display {
	Panel {
	    title => name_of(<-.<-);
	    message = "Calculate magnitude and phase of a packed fft.";
	};
	UItoggle LogUI {
	    parent => <-.Panel;
	    label = "Compute Log";
	    set = 1;
	};
	IPfunc.ip_fft_display	work_func {
	    src => in_image;
	    dst1<NEportLevels={0,3}>;
	    dst2<NEportLevels={0,3}>;
	    log => <-.LogUI.set;
	};
    };

    IPui.IP1i1o1r IPflog {
	IPfunc.ip_flog	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPflog10 {
	IPfunc.ip_flog10	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPfsqrt {
	IPfunc.ip_fsqrt	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPfexp {
	IPfunc.ip_fexp	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPfrecip {
	IPfunc.ip_frecip	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPfcos {
	IPfunc.ip_fcos	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPfsin {
	IPfunc.ip_fsin	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };

    IPui.IP1i1o1r IPfatan {
	IPfunc.ip_fatan	    work_func {
	    src => in_image;
	    dst<NEportLevels={0,3}>;
	    roi => in_roi;
	};
    };
};

flibrary+global+sort+buffered LoopMacros {

    macro IPloopVol {
       Mesh_Unif+Node_Data+Dim3 &inField<NEportLevels={2,1},NEx=187,NEy=22>;
       int slice<NEy=143,NEx=33,NEportLevels={1,1}> => .loop.count;
       Mesh_Unif+Node_Data outField<NEy=319,NEportLevels={0,1},NEx=22> {
	  nnodes => prod(.dims);
	  dims+nres => {inField.dims[0],
	     inField.dims[1],inField.dims[2]};
	  ndim+nres => inField.ndim;
	  nspace = 3;
	  points => {
	     0,0,0,(inField.dims[0] - 1),(inField.dims[1] - 1),
	     (inField.dims[2] - 1)
	  };
       };
       DV.DVset_slice_data DVset_slice_data<NEx=176,NEy=363> {
	  inField<NEportLevels={2,2}> => <-.outField;
	  slice => <-.slice;
       };
       GMOD.loop loop<NEx=22,NEy=77,NEdisplayMode="NEclosed"> {
	  start_val = 0;
	  end_val => (inField.dims[2] - 1);
	  incr = 1;
	  run<NEdisplayMode="NEopened">;
	  done = 1;
       };
       DV.DVorthoslice_unif DVorthoslice_unif<NEx=176,NEy=198,NEdisplayMode="NEclosed"> {
	  in => <-.inField;
	  axis<NEdisplayMode="NEclosed"> = 2;
	  plane => <-.slice;
       };
       DV.DVswitch DVswitch<NEx=341,NEy=418> {
	  in => {<-.inField,
	     <-.DVset_slice_data.inField};
	  index => <-.loop.done;
	  out<NEportLevels={1,3}>;
       };
       Interface.IPfldToImage IPfldToImage<NEx=407,NEy=253> {
	  In => <-.DVorthoslice_unif.out;
       };
    };

    macro IPloopVolRoi {
       Mesh_Unif+Node_Data+Dim3 &inField<NEportLevels={2,1},NEx=187,NEy=22>;
       Mesh_Unif+Node_Data+Dim3 &inROI<NEportLevels={2,1},NEx=385,NEy=22>;
       int slice<NEy=143,NEx=33,NEportLevels={1,1}> => .loop.count;
       Mesh_Unif+Node_Data outField<NEy=319,NEportLevels={0,1},NEx=22> {
	  nnodes => prod(.dims);
	  dims+nres => {inField.dims[0],
	     inField.dims[1],inField.dims[2]};
	  ndim+nres => inField.ndim;
	  nspace = 3;
	  points => {
	     0,0,0,(inField.dims[0] - 1),(inField.dims[1] - 1),
	     (inField.dims[2] - 1)
	  };
       };
       DV.DVset_slice_data DVset_slice_data<NEx=176,NEy=363> {
	  inField<NEportLevels={2,2}> => <-.outField;
	  slice => <-.slice;
       };
       GMOD.loop loop<NEx=22,NEy=77,NEdisplayMode="NEclosed"> {
	  start_val = 0;
	  end_val => (inField.dims[2] - 1);
	  incr = 1;
	  run<NEdisplayMode="NEopened">;
	  done = 1;
       };
       DV.DVorthoslice_unif DVorthoslice_unif<NEx=176,NEy=198,NEdisplayMode="NEclosed"> {
	  in => <-.inField;
	  axis<NEdisplayMode="NEclosed"> = 2;
	  plane => <-.slice;
       };
       DV.DVswitch DVswitch<NEx=341,NEy=418> {
	  in => {<-.inField,
	     <-.DVset_slice_data.inField};
	  index => <-.loop.done;
	  out<NEportLevels={1,3}>;
       };
       DV.DVorthoslice_unif DVorthoslice_unif#1<NEx=385,NEy=198,NEdisplayMode="NEclosed"> {
	  in => <-.inROI;
	  axis<NEdisplayMode="NEclosed"> = 2;
	  plane => <-.slice;
       };
       Interface.IPfldToImage IPfldToImage<NEx=407,NEy=264> {
	  In => <-.DVorthoslice_unif.out;
       };
       Interface.IPfldToROI IPfldToROI<NEx=550,NEy=264> {
	  In => <-.DVorthoslice_unif#1.out;
	  Conv<NEdisplayMode="NEclosed"> {
	  };
       };
    };

    macro IPloopVolVolRoi {
       Mesh_Unif+Node_Data+Dim3 &inField<NEportLevels={2,1},NEx=275,NEy=22>;
       Mesh_Unif+Node_Data+Dim3 &inField1<NEportLevels={2,1},NEx=440,NEy=22>;
       Mesh_Unif+Node_Data+Dim3 &inROI<NEportLevels={2,1},NEx=605,NEy=22>;
       int slice<NEy=132,NEx=22,NEportLevels={1,1}> => .loop.count;
       Mesh_Unif+Node_Data outField<NEy=297,NEportLevels={0,1},NEx=22> {
	  nnodes => prod(.dims);
	  dims+nres => {inField.dims[0],
	     inField.dims[1],inField.dims[2]};
	  ndim+nres => inField.ndim;
	  nspace = 3;
	  points => {
	     0,0,0,(inField.dims[0] - 1),(inField.dims[1] - 1),
	     (inField.dims[2] - 1)
	  };
       };
       DV.DVset_slice_data DVset_slice_data<NEx=187,NEy=363> {
	  inField<NEportLevels={2,2}> => <-.outField;
	  slice => <-.slice;
       };
       GMOD.loop loop<NEx=22,NEy=66,NEdisplayMode="NEclosed"> {
	  start_val = 0;
	  end_val => (inField.dims[2] - 1);
	  incr = 1;
	  run<NEdisplayMode="NEopened">;
	  done = 1;
       };
       DV.DVorthoslice_unif DVorthoslice_unif<NEx=275,NEy=165,NEdisplayMode="NEclosed"> {
	  in => <-.inField;
	  axis<NEdisplayMode="NEclosed"> = 2;
	  plane => <-.slice;
       };
       DV.DVswitch DVswitch<NEx=308,NEy=407> {
	  in => {
	     <-.inField,<-.DVset_slice_data.inField};
	  index => <-.loop.done;
	  out<NEportLevels={1,3}>;
       };
       DV.DVorthoslice_unif DVorthoslice_unif#1<NEx=440,NEy=165,NEdisplayMode="NEclosed"> {
	  axis<NEdisplayMode="NEclosed"> = 2;
	  plane => <-.slice;
	  in => <-.inField1;
       };
       DV.DVorthoslice_unif DVorthoslice_unif#2<NEx=605,NEy=165,NEdisplayMode="NEclosed"> {
	  in => <-.inROI;
	  axis<NEdisplayMode="NEclosed"> = 2;
	  plane => <-.slice;
       };
       Interface.IPfldToImage IPfldToImage<NEx=385,NEy=253> {
	  In => <-.DVorthoslice_unif.out;
       };
       Interface.IPfldToImage IPfldToImage#1<NEx=528,NEy=253> {
	  In => <-.DVorthoslice_unif#1.out;
       };
       Interface.IPfldToROI IPfldToROI<NEx=671,NEy=253> {
	  In => <-.DVorthoslice_unif#2.out;
	  Conv<NEdisplayMode="NEclosed"> {
	  };
       };
    };

};

flibrary+global+sort+buffered LoopModules {

    IPloopVolVolRoi IPaddVol {
       DVset_slice_data {
	  sliceField => <-.IPadd.Cvt.TmpField;
       };
       IPadd IPadd<NEx=495,NEy=319> {
	  in_image1 => <-.IPfldToImage.Image;
	  in_image2 => <-.IPfldToImage#1.Image;
	  in_roi => <-.IPfldToROI.ROI.Roi;
       };
    };

    IPloopVolRoi IPconvolveVol {
       loop {
	  run<NEdisplayMode="NEclosed"> => <-.IPconvolve.UItoggle.set;
       };
       DVset_slice_data {
	  sliceField => <-.IPconvolve.Cvt.TmpField;
       };
       IPconvolve IPconvolve<NEx=473,NEy=319,NEdisplayMode="NEclosed"> {
	  Panel<NEdisplayMode="NEclosed"> {
	     title<NEdisplayMode="NEclosed"> => name_of(<-.<-.<-);
	  };
	  in_image => <-.IPfldToImage.Image;
	  in_roi => <-.IPfldToROI.ROI.Roi;
	  Controls.UItoggle UItoggle<NEx=187,NEy=231,NEdisplayMode="NEclosed"> {
	     parent => <-.Panel;
	     label<NEdisplayMode="NEclosed"> = "Run";
	     set<NEportLevels={0,3}>;
	     x = 0;
	     y = 40;
	  };
       };
    };

    IPloopVolVolRoi IPdivideVol {
       DVset_slice_data {
	  sliceField => <-.IPdivide.Cvt.TmpField;
       };
       IPdivide IPdivide<NEx=484,NEy=308> {
	  in_image1 => <-.IPfldToImage.Image;
	  in_image2 => <-.IPfldToImage#1.Image;
	  in_roi => <-.IPfldToROI.ROI.Roi;
       };
    };

    IPloopVolVolRoi IPmultiplyVol {
       DVset_slice_data {
	  sliceField => <-.IPmultiply.Cvt.TmpField;
       };
       IPmultiply IPmultiply<NEx=495,NEy=319> {
	  in_image1 => <-.IPfldToImage.Image;
	  in_image2 => <-.IPfldToImage#1.Image;
	  in_roi => <-.IPfldToROI.ROI.Roi;
       };
    };

    IPloopVolVolRoi IPsubVol {
       DVset_slice_data {
	  sliceField => <-.IPsubtract.Cvt.TmpField;
       };
       IPsubtract IPsubtract<NEx=495,NEy=319> {
	  in_image1 => <-.IPfldToImage.Image;
	  in_image2 => <-.IPfldToImage#1.Image;
	  in_roi => <-.IPfldToROI.ROI.Roi;
       };
    };

    IPloopVolRoi IPadd_constVol {
       DVset_slice_data {
	  sliceField => <-.IPadd_const.Cvt.TmpField;
       };
       IPadd_const IPadd_const<NEx=473,NEy=319,NEdisplayMode="NEclosed"> {
	  in_image => <-.IPfldToImage.Image;
	  in_roi => <-.IPfldToROI.ROI.Roi;
	  Controls.UItoggle UItoggle<NEx=209,NEy=231,NEdisplayMode="NEclosed"> {
	     parent => <-.Panel;
	     label<NEdisplayMode="NEclosed"> = "Run";
	     set<NEportLevels={0,3}>;
	     x = 0;
	     y = 40;
	  };
	  Panel<NEdisplayMode="NEclosed"> {
	     title<NEdisplayMode="NEclosed"> => name_of(<-.<-.<-);
	  };
       };
       loop {
	  run<NEdisplayMode="NEclosed"> => <-.IPadd_const.UItoggle.set;
       };
    };

    IPloopVolRoi IPmul_constVol {
       DVset_slice_data {
	  sliceField => <-.IPmul_const.Cvt.TmpField;
       };
       IPmul_const IPmul_const<NEx=462,NEy=319,NEdisplayMode="NEclosed"> {
	  in_image => <-.IPfldToImage.Image;
	  in_roi => <-.IPfldToROI.ROI.Roi;
	  Controls.UItoggle UItoggle<NEx=209,NEy=231,NEdisplayMode="NEclosed"> {
	     parent => <-.Panel;
	     label<NEdisplayMode="NEclosed"> = "Run";
	     set<NEportLevels={0,3}>;
	     x = 0;
	     y = 40;
	  };
	  Panel<NEdisplayMode="NEclosed"> {
	     title<NEdisplayMode="NEclosed"> => name_of(<-.<-.<-);
	  };
       };
       loop {
	  run<NEdisplayMode="NEclosed"> => <-.IPmul_const.UItoggle.set;
       };
    };

    IPloopVol IPthresholdVol {
       loop {
	  run<NEdisplayMode="NEclosed"> => <-.IPthreshold.UItoggle.set;
       };
       DVset_slice_data {
	  sliceField => <-.IPthreshold.Cvt.TmpField;
       };
       IPthreshold IPthreshold<NEx=407,NEy=297,NEdisplayMode="NEclosed"> {
	  in_image => <-.IPfldToImage.Image;
	  Controls.UItoggle UItoggle<NEx=187,NEy=187,NEdisplayMode="NEclosed"> {
	     parent => <-.Panel;
	     label<NEdisplayMode="NEclosed"> = "Run";
	     set<NEportLevels={0,3}>;
	     x = 0;
	     y = 195;
	  };
	  Panel<NEdisplayMode="NEclosed"> {
	     title<NEdisplayMode="NEclosed"> => name_of(<-.<-.<-);
	  };
       };
    };

};


};
