/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ip_examp/convolve.v#1 $
*/

APPS.MultiWindowApp IPconvolve<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

UIsummaryPanel Summary_Panel {
   demo_text ="This example convolves an input image with a specified kernel, producing the filtered output.";
   helpfile = "examples/examples_help.htm";
};

MODS.Readers.Read_Image Read_Image<NEx=572.,NEy=22.> {
   read_image_ui {
      filename = "$XP_PATH<0>/data/image/mandrill.x";
   };
};
MODS.Filters.extract_scalar extract_scalar<NEx=594.,NEy=88.> {
   in_field => <-.Read_Image.field;
   ExtractScalarParam {
      component = 3;
   };
};
Interface.IPfldToImage IPfldToImage<NEx=561.,NEy=176.> {
   In => <-.extract_scalar.out_fld;
};
IP.Macros.IPthreshold IPthreshold<NEx=660.,NEy=264.> {
   in_image => <-.IPfldToImage.Image;
   LowUI {
      y = 84;
   };
   HighUI {
      y = 24;
   };
   InvUI {
      y = 0;
   };
};
Interface.IPfldToROI IPfldToROI<NEx=594.,NEy=330.> {
   In => IPthreshold.Cvt.TmpField;
};
IP.Macros.IPconvolve IPconvolve<NEx=506.,NEy=396.> {
   in_image => <-.IPfldToImage.Image;
   Text {
      Text {
         y = 24;
	 width = 798;
	 text = "arg_0.5h";
      };
      TextPanel {
	 y = 0;
      };
   };
   in_roi => <-.IPfldToROI.ROI.Roi;
};

GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
   Scene {
      Top {
         child_objs => {IPconvolve.Cvt.dataObject.obj};
      };
   };
};

};
