/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ip_examp/linremap.v#1 $
*/

APPS.MultiWindowApp IPlinremap<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

UIsummaryPanel Summary_Panel {
   demo_text ="This example shows you how you can manipulate pixel values for a channel of interest. In this case you have the capability of dynamically altering the range according user selection.\n\nA constant value is added to the input ip_Image pixels, followed by multiplying by the Multiplier value, and finally clamping (in the case of byte and short images).";
   helpfile = "examples/examples_help.htm";
   UItext.rows = 10;
};

MODS.Readers.Read_Image Read_Image<NEx=517.,NEy=22.> {
   read_image_ui {
      filename = "$XP_PATH<0>/data/image/mandrill.x";
   };
};
MODS.Filters.extract_scalar extract_scalar<NEx=550.,NEy=88.> {
   in_field => <-.Read_Image.field;
   ExtractScalarParam {
      component = 1;
   };
};
Interface.IPfldToImage IPfldToImage<NEx=550.,NEy=143.> {
   In => <-.extract_scalar.out_fld;
};
IP.Macros.IPthreshold IPthreshold<NEx=616.,NEy=198.> {
   in_image => <-.IPfldToImage.Image;
   LowUI {
      y = 84;
   };
   HighUI {
      y = 24;
   };
   InvUI {
      y = 0;
   };
};
Interface.IPfldToROI IPfldToROI<NEx=649.,NEy=253.> {
   In => <-.IPthreshold.Cvt.TmpField;
};
IP.Macros.IPlinremap IPlinremap<NEx=561.,NEy=319.> {
   in_image => <-.IPfldToImage.Image;
   in_roi => <-.IPfldToROI.ROI.Roi;
   ConstUI {
      y = 60;
      value = -79.61;
   };
   MultUI {
      y = 0;
      value = 3.59;
   };
};
GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
   Scene {
      Top {
         child_objs => {
            IPlinremap.Cvt.dataObject.obj};
      };
   };
};

};
