//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/mods_arr.v#1 $
//
flibrary MODS_ARR<needs_use_lic="GD",needs_edit_lic="DV",
	      compile_subs=0> {

library+sort+buffered Array_Filters {

MODS.downsize downsize_ARR {
	imlink in_field<NEy=99,NEx=55>;
	DVdownsize[array_size(in_field)] {
		in => in_field[index_of(DVdownsize)];
	};
	DownsizeUI {
		ilink in_fld<NEy=110,NEx=66> => in_field[0];
	};
	DataObjects objs<NEy=264,NEx=165> {
		in_fields => DVdownsize.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=374> => DVdownsize.out;
};

MODS.crop crop_ARR {
	imlink in_field<NEy=110,NEx=88>;
	CropParam {
		min+nres => init_array(in_field[0].ndim,0,0);
		max+nres => in_field[0].dims-1;
	};
	DVcrop[array_size(in_field)] {
		in => in_field[index_of(DVcrop)];
	};
	CropUI {
		ilink in_fld<NEy=121,NEx=66> => in_field[0];
	};
	DataObjects objs<NEy=275,NEx=253> {
		in_fields => DVcrop.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=451> => DVcrop.out;
};

MODS.extract_component extract_component_ARR {
	imlink in_field;
	DVextract_comp[array_size(in_field)] {
		in =>in_field[index_of(DVextract_comp)];
	};
	ExtrCompUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVextract_comp.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVextract_comp.out;
};

MODS.extract_cell_component extract_cell_component_ARR {
	imlink in_field;
	DVextr_cell_comp[array_size(in_field)] {
		in =>in_field[index_of(DVextr_cell_comp)];
	};
	ExtrCompUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVextr_cell_comp.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVextr_cell_comp.out;
};

MODS.extract_scalar extract_scalar_ARR {
	imlink in_field;
	ExtractScalar[array_size(in_field)] {
		in_fld => in_field[index_of(ExtractScalar)];
	};
	ExtractScalarUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => ExtractScalar.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => ExtractScalar.out_fld;
};

MODS.combine_vect combine_vect_ARR {
	imlink in_field<NEy=77,NEx=88>;
	CombineVect[array_size(in_field)] {
		in_fld => in_field[index_of(CombineVect)];
	};
	CombVectUI {
		ilink in_fld<NEy=143,NEx=44> => in_field[0];
	};
	DataObjects objs<NEy=231,NEx=242> {
		in_fields => CombineVect.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=231,NEx=429>  => CombineVect.out_fld;
};

MODS.threshold threshold_ARR {
	imlink in_field;
	ThreshParam {
		min_value+nres => cache(in_field[0].node_data[check_vector].min_vec[check_comp]);
		max_value+nres => cache(in_field[0].node_data[check_vector].max_vec[check_comp]);
	};
	Threshold[array_size(in_field)] {
		in_fld => in_field[index_of(Threshold)];
	};
	ThresholdUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => Threshold.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => Threshold.out_fld;
};

MODS.threshold_cell threshold_cell_ARR {
	imlink in_field;
	ThreshParam {
		min_value+nres => cache(in_field[0].cell_set[0].cell_data[check_vector].min);
		max_value+nres => cache(in_field[0].cell_set[0].cell_data[check_vector].max);
	};
	DVthreshold_cell[array_size(in_field)] {
		in =>in_field[index_of(DVthreshold_cell)];
	};
	ThresholdUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVthreshold_cell.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVthreshold_cell.out;
};

MODS.clamp clamp_ARR {
	imlink in_field<NEy=99,NEx=66>;
	ClampParam {
		min_value+nres => cache(in_field[0].node_data[vector].min_vec[component]);
		max_value+nres => cache(in_field[0].node_data[vector].max_vec[component]);
	};
	Clamp[array_size(in_field)] {
		in_fld => in_field[index_of(Clamp)];
	};
	ClampUI {
		ilink in_fld<NEy=143,NEx=66> => in_field[0];
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => Clamp.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => Clamp.out_fld;
};

MODS.set_xform set_xform_ARR {
	imlink in_field1;
	DVset_xform[array_size(in_field1)] {
		in => in_field1[index_of(DVset_xform)];
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => DVset_xform.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => DVset_xform.out;
};

MODS.xform_to_plane xform_to_plane_ARR {
	imlink in_field;
	DVxform_to_plane[array_size(in_field)] {
		in =>in_field[index_of(DVxform_to_plane)];
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => DVxform_to_plane.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => DVxform_to_plane.out;
};

MODS.reset_xform reset_xform_ARR {
	imlink in_field;
	DVset_xform[array_size(in_field)] {
		in =>in_field[index_of(DVset_xform)];
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => DVset_xform.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => DVset_xform.out;
};

MODS.set_null set_null_ARR {
	imlink in_field;
	DVset_null[array_size(in_field)] {
		in =>in_field[index_of(DVset_null)];
	};
	DVcomb_mesh_and_data[array_size(in_field)] {
		in_mesh => in_field[index_of(DVcomb_mesh_and_data)];
		in_nd =>  DVset_null[index_of(DVcomb_mesh_and_data)].out;
	};
	SetNullUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVcomb_mesh_and_data.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVcomb_mesh_and_data.out;
};

MODS.cell_to_node cell_to_node_ARR {
	imlink in_field;
	DVcell_to_node[array_size(in_field)] {
		in =>in_field[index_of(DVcell_to_node)];
	};
	CellToNodeUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVcell_to_node.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVcell_to_node.out;
};

MODS.select_cells select_cells_ARR {
	imlink in_field;
	DVselect_cells[array_size(in_field)] {
		in =>in_field[index_of(DVselect_cells)];
	};
	SelectCellsUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVselect_cells.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVselect_cells.out;
};

MODS.gradient gradient_ARR {
	imlink in_field;
	DVgrad[array_size(in_field)] {
		in =>in_field[index_of(DVgrad)];
	};
	GradUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVgrad.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVgrad.out;
};

MODS.curl curl_ARR {
	imlink in_field<NEy=88,NEx=132>;
	DVcurl[array_size(in_field)] {
		in =>in_field[index_of(DVcurl)];
	};
	CurlUI<NEy=154,NEx=154> {
		ilink in_fld<NEy=121,NEx=44> => in_field[0];
	};
	DataObjects objs<NEy=253,NEx=242> {
		in_fields => DVcurl.out;
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=231,NEx=451> => DVcurl.out;
};

MODS.divergence divergence_ARR {
	imlink in_field<NEy=88,NEx=88>;
	DVdivrg[array_size(in_field)] {
		in =>in_field[index_of(DVdivrg)];
	};
	DivUI<NEy=143,NEx=154> {
		ilink in_fld<NEy=121,NEx=66> => in_field[0];
	};
	DataObjects objs<NEy=242,NEx=231> {
		in_fields => DVdivrg.out;
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=418> => DVdivrg.out;
};

MODS.mirror mirror_ARR {
	imlink in_field;
	DVmirror[array_size(in_field)] {
		in =>in_field[index_of(DVmirror)];
	};
	MirrorUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVmirror.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVmirror.out;
};

MODS.scale scale_ARR {
	imlink in_field;
	DVscale[array_size(in_field)] {
		in =>in_field[index_of(DVscale)];
	};
	ScaleUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVscale.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};

	mlink+OPort2 out_fld => DVscale.out;
};

MODS.magnitude magnitude_ARR {
	imlink in_field;
	DVmagnitude[array_size(in_field)] {
		in =>in_field[index_of(DVmagnitude)];
	};
	MagUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVmagnitude.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVmagnitude.out;
};

MODS.combine_comp combine_comp_ARR {
	imlink in_field1<NEy=55,NEx=88>;
	imlink in_field2<NEy=132,NEx=77>;
	DVcomb_comp[array_size(in_field1)] {
		nd1 => in_field1[index_of(DVcomb_comp)];
		nd2 => in_field2[index_of(DVcomb_comp)];
	};
	DVcomb_mesh_and_data[array_size(in_field1)] {
		in_mesh => in_field1[index_of(DVcomb_mesh_and_data)];
		in_nd => DVcomb_comp[index_of(DVcomb_mesh_and_data)].out;
	};
	CombCompUI<NEy=176,NEx=143> {
		ilink in_fld1<NEy=143,NEx=77> => in_field1[0];
		ilink in_fld2<NEy=99,NEx=165> => in_field2[0];
	};
	DataObjects objs<NEy=286,NEx=220> {
		in_fields => DVcomb_mesh_and_data.out;
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=286,NEx=396> => DVcomb_mesh_and_data.out;
};

MODS.project_axis project_axis_ARR {
	imlink in_field;
	DVproject[array_size(in_field)] {
		in =>in_field[index_of(DVproject)];
	};
	DVextract_mesh[array_size(in_field)] {
		in => <-.DVproject[index_of(DVextract_mesh)].out;
	};
	DataObjects objs {
		in_fields => DVextract_mesh.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVextract_mesh.out;
};

MODS.project_plane project_plane_ARR {
	imlink in_field;
	DVproject_to_plane[array_size(in_field)] {
		in =>in_field[index_of(DVproject_to_plane)];
	};
	DVextract_mesh[array_size(in_field)] {
		in => <-.DVproject_to_plane[index_of(DVextract_mesh)].out;
	};
	DataObjects objs {
		in_fields => DVextract_mesh.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVextract_mesh.out;
};

MODS.reset_extent reset_extent_ARR {
	imlink in_field;
	DVreset_extent[array_size(in_field)] {
		in =>in_field[index_of(DVreset_extent)];
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => DVreset_extent.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => DVreset_extent.out;
};

MODS.reset_minmax reset_minmax_ARR {
	imlink in_field;
	DVreset_minmax[array_size(in_field)] {
		in =>in_field[index_of(DVreset_minmax)];
	};
	DVcomb_mesh_and_data[array_size(in_field)] {
		in_mesh => in_field[index_of(DVcomb_mesh_and_data)];
		in_nd =>  DVreset_minmax[index_of(DVcomb_mesh_and_data)].out;
	};
	ResetMinmaxUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => DVcomb_mesh_and_data.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => DVcomb_mesh_and_data.out;
};

MODS.reset_minmax_cell reset_minmax_cell_ARR {
	imlink in_field;
	DVreset_minmax_cell[array_size(in_field)] {
		in =>in_field[index_of(DVreset_minmax)];
	};
	ResetMinmaxUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => DVreset_minmax_cell.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => DVreset_minmax_cell.out;
};

MODS.set_minmax set_minmax_ARR {
	imlink in_field;
	SetMinmaxParam {
		min+nres => cache(in_field[0].node_data[comp].min);
		max+nres => cache(in_field[0].node_data[comp].max);
	};

	DVset_minmax[array_size(in_field)] {
		in =>in_field[index_of(DVset_minmax)];
	};
	DVcomb_mesh_and_data[array_size(in_field)] {
		in_mesh => in_field[index_of(DVcomb_mesh_and_data)];
		in_nd =>  DVset_minmax[index_of(DVcomb_mesh_and_data)].out;
	};
	SetMinMaxUI {
		ilink in_fld => in_field[0];
		reset_minmax.v_commands =
			"param.min => cache(in_field[0].node_data[comp].min);
			 param.max => cache(in_field[0].node_data[comp].max);";
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => DVcomb_mesh_and_data.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => DVcomb_mesh_and_data.out;
};

MODS.set_minmax_cell set_minmax_cell_ARR {
	imlink in_field;
	SetMinmaxParam {
		min+nres => cache(in_field[0].cell_set[0].cell_data[comp].min);
		max+nres => cache(in_field[0].cell_set[0].cell_data[comp].max);
	};
	DVset_minmax_cell[array_size(in_field)] {
		in =>in_field[index_of(DVset_minmax_cell)];
	};
	SetMinMaxUI {
		ilink in_fld => in_field[0];
		reset_minmax.v_commands =
			"param.min => cache(in_field[0].cell_set[0].cell_data[comp].min);
			 param.max => cache(in_field[0].cell_set[0].cell_data[comp].max);";
	};
	DataObjects objs<NEy=253,NEx=176> {
		in_fields => DVset_minmax_cell.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld<NEy=242,NEx=396> => DVset_minmax_cell.out;
};

};

library+sort+buffered Array_Mappers {

MODS.surf_plot surf_plot_ARR {
	imlink in_field;
	SurfPlotParam {
		nspace+nres => min_array({<-.in_field[0].nspace, 
				3-(<-.in_field[0].node_data[component].veclen)}, 0, 0);
	};
	DVsurf_plot[array_size(in_field)] {
		in =>in_field[index_of(DVsurf_plot)];
	};
	SurfPlotUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVsurf_plot.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVsurf_plot.out;
};

MODS.offset offset_ARR {
	imlink in_field;
	DVoffset[array_size(in_field)] {
		in =>in_field[index_of(DVoffset)];
	};
	OffsetUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
	in_fields => DVoffset.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVoffset.out;
};

MODS.orthoslice orthoslice_ARR {
	imlink in_field;
	OrthoSliceParam {
		plane+nres => in_field[0].dims[axis]/2;
	};
	DVorthoslice[array_size(in_field)] {
		in =>in_field[index_of(DVorthoslice)];
	};
	OrthoSliceUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVorthoslice.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVorthoslice.out;
};

MODS.scat_to_unif scat_to_unif_ARR {
	imlink in_field;
	Scat2UnifParam {
		min_xyz => in_field[0].coordinates.min_vec[0:rndim-1];
		max_xyz => in_field[0].coordinates.max_vec[0:rndim-1];
		null_value=>in_field[0].node_data[component].max+1;
	};
	Scat2Unif[array_size(in_field)] {
		in_fld => in_field[index_of(Scat2Unif)];
	};
	Scat2UnifUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => Scat2Unif.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => Scat2Unif.out_fld;
};

MODS.bounds bounds_ARR {
	imlink in_field;
	DVbounds[array_size(in_field)] {
		in =>in_field[index_of(DVbounds)];
	};
	BoundsUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVbounds.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
		dos.Modes.mode = {0,1,3,0,0};	/* set lines, gouraud mode */
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVbounds.out;

};

MODS.scat_to_tri scat_to_tri_ARR {
	imlink in_field;
	DVscat_to_tet[array_size(in_field)] {
		in =>in_field[index_of(DVscat_to_tet)];
	};
	DataObjects objs {
		in_fields => DVscat_to_tet.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVscat_to_tet.out;
};

MODS.edges edges_ARR {
	imlink in_field;
	DVedges[array_size(in_field)] {
		in => <-.in_field[index_of(DVedges)];
	};
	DataObjects objs {
		in_fields => DVedges.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVedges.out;
};

MODS.external_faces external_faces_ARR {
	imlink in_field;
	External_Faces[array_size(in_field)] {
		in_field => <-.in_field[index_of(External_Faces)];
	};
	DataObjects objs {
		in_fields => External_Faces.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => External_Faces.out_fld;
};

MODS.external_edges external_edges_ARR {
	imlink in_field;
	External_Edges[array_size(in_field)] {
		in_field => <-.in_field[index_of(External_Edges)];
	};
	DataObjects objs {
		in_fields => External_Edges.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => External_Edges.out_fld;
};

MODS.cut cut_ARR {
	imlink in_field;
	Cut[array_size(in_field)] {
		in_fld => in_field[index_of(Cut)];
	};
	DVnode_data_labels {
		in => in_field[0];
	};
	DVcell_data_labels {
		in => in_field[0];
	};
	CutUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => Cut.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => Cut.out_fld;
};

MODS.crop_box crop_box_ARR {
	imlink in_field;
	FBox_Planes {
		in => <-.in_field[0];
	};
	DVplane_crop[array_size(in_field)] {
		in => in_field[index_of(DVplane_crop)];
	};
	CropUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVplane_crop.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVplane_crop.out;
};

MODS.cut_plane cut_plane_ARR {
	imlink in_field;
	xlate=>{0.0, 0.0,
			(in_field[0].coordinates.min_vec[2]+in_field[0].coordinates.max_vec[2])/2};
	plane {
		points+nres => {in_field[0].coordinates.min_vec[0], in_field[0].coordinates.min_vec[1], 
			  in_field[0].coordinates.max_vec[0], in_field[0].coordinates.max_vec[1]};
	};
	Cut[array_size(in_field)] {
		in_fld => in_field[index_of(Cut)];
	};
	DVnode_data_labels {
		in => in_field[0];
	};
	DVcell_data_labels {
		in => in_field[0];
	};
	CutUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => Cut.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject cut_obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => Cut.out_fld;
};

MODS.glyph glyph_ARR {
	imlink in_field;
	DVglyph[array_size(in_field)] {
		in =>in_field[index_of(DVglyph)];
	};
	GlyphUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVglyph.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVglyph.out;
};

MODS.geo_glyph geo_glyph_ARR {
	imlink in_field;
	DVglyph[array_size(in_field)] {
		in =>in_field[index_of(DVglyph)];
	};
	GlyphUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVglyph.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVglyph.out;
};

MODS.interp_data interp_data_ARR {
	imlink in_field;
	DVinterpolate_data[array_size(in_field)] {
		in =>in_field[index_of(DVinterpolate_data)];
	};
	InterpUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVinterpolate_data.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 2;
		Top.alt_xform+nres => <-.<-.in_probe.xform;
	};
	mlink+OPort2 out_fld => DVinterpolate_data.out;
};

MODS.interp_cell_data interp_cell_data_ARR {
	imlink in_field;
	DVinterpolate_cell_data[array_size(in_field)] {
		in =>in_field[index_of(DVinterpolate_cell_data)];
	};
	InterpUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVinterpolate_cell_data.out;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
		dos.Obj.xform_mode = 1;
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 2;
		Top.alt_xform+nres => <-.<-.in_probe.xform;
	};
	mlink+OPort2 out_fld => DVinterpolate_cell_data.out;
};

MODS.isosurface isosurface_ARR {
	imlink in_field;
	IsoParam {
		iso_level =>  cache((in_field[0].node_data[iso_component].min +
		             in_field[0].node_data[iso_component].max) / 2);
	};
	Iso[array_size(in_field)] {
		in_fld => in_field[index_of(Iso)];
	};

	node_minmax_arr min_max {
		in_field => <-.in_field;
		component => <-.IsoParam.iso_component;
	};

	DVnode_data_labels {
		in => in_field[0];
	};
	DVcell_data_labels {
		in => in_field[0];
	};
	IsoUI {
		ilink in_fld => in_field[0];

		UIiso_level {
			min => <-.<-.min_max.min;
			max => <-.<-.min_max.max;
		};

	};
	DataObjects objs {
		in_fields => Iso.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => Iso.out_fld;
};

MODS.isosurface_trace isosurface_trace_ARR {
	imlink in_field;
	IsoSurfTrace[array_size(in_field)] {
		in_fld => in_field[index_of(IsoSurfTrace)];
	};
	IsoTraceUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields =>IsoSurfTrace.out_fld;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => IsoSurfTrace.out_fld;
};

MODS.isoline isoline_ARR {
	imlink in_field;
	IsoParam {
		level_min+nres =>  cache(0.7*in_field[0].node_data[contour_comp].min+
			    0.3*in_field[0].node_data[contour_comp].max);
		level_max+nres =>  cache(0.3*in_field[0].node_data[contour_comp].min+
			    0.7*in_field[0].node_data[contour_comp].max);
	};
	DVisoline[array_size(in_field)] {
		in =>in_field[index_of(DVisoline)];
	};

	node_minmax_arr min_max {
		in_field => <-.in_field;
		component => <-.IsoParam.contour_comp;
	};

	IsoLineUI {
		ilink in_fld => in_field[0];
		iso_level_min {
			min => <-.<-.min_max.min;
			max => <-.<-.min_max.max;
		};
		iso_level_max {
			min => <-.<-.min_max.min;
			max => <-.<-.min_max.max;
		};

	};
	DataObjects objs {
		in_fields => DVisoline.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
		dos.Modes.mode = {0,1,0,0,0};	/* set lines mode on */
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVisoline.out;
};

MODS.isoline_trace isoline_trace_ARR {
	imlink in_field;
	DVisoline_trace[array_size(in_field)] {
		in =>in_field[index_of(DVisoline_trace)];
	};
	IsoLineUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVisoline_trace.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
		dos.Modes.mode = {0,1,0,0,0};	/* set lines mode on */
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVisoline_trace.out;
};

MODS.solid_contour solid_contour_ARR {
	imlink in_field;
	ContourParam {
		level_min+nres =>  cache(0.8*in_field[0].node_data[contour_comp].min+
			    0.2*in_field[0].node_data[contour_comp].max);
		level_max+nres =>  cache(0.2*in_field[0].node_data[contour_comp].min+
			    0.8*in_field[0].node_data[contour_comp].max);
	};
	DVsolid_contour[array_size(in_field)] {
		in =>in_field[index_of(DVsolid_contour)];
	};

	node_minmax_arr min_max {
		in_field => <-.in_field;
		component => <-.ContourParam.contour_comp;
	};

	SolidContourdUI {
		ilink in_fld => in_field[0];

		iso_level_min {
			min => <-.<-.min_max.min;
			max => <-.<-.min_max.max;
		};
		iso_level_max {
			min => <-.<-.min_max.min;
			max => <-.<-.min_max.max;
		};

	};
	DataObjects objs {
		in_fields => DVsolid_contour.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	DataObjects obj_lines {
		in_fields => DVsolid_contour.out_line;
		dos {
			Modes.mode = {0,GD_LINES,0,0,0};	/* set lines mode on */
			Props.jitter = 1;
			Obj {
				name+nres => name_of(<-.<-.<-.<-) + "_lines" + index_of(dos);
				xform_mode = GD_XFORM_MODE_PARENT;
			};
		};
	};
	GroupObject obj_line {
		Top.name => name_of(<-.<-.<-) + "_lines";
		child_objs => obj_lines.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVsolid_contour.out;
	mlink+OPort2 out_fld_line => DVsolid_contour.out_line;
};

MODS.contour contour_ARR {
	imlink in_field;
	ContourParam {
		level_min+nres =>  cache(0.6*in_field[0].node_data[contour_comp].min+
			    0.4*in_field[0].node_data[contour_comp].max);
		level_max+nres =>  cache(0.4*in_field[0].node_data[contour_comp].min+
			    0.6*in_field[0].node_data[contour_comp].max);
	};
	DVcontour[array_size(in_field)] {
		in =>in_field[index_of(DVcontour)];
	};

	node_minmax_arr min_max {
		in_field => <-.in_field;
		component => <-.ContourParam.contour_comp;
	};

	ContourUI {
		ilink in_fld => in_field[0];

		min_level {
			min => <-.<-.min_max.min;
			max => <-.<-.min_max.max;
		};
		max_level {
			min => <-.<-.min_max.min;
			max => <-.<-.min_max.max;
		};

	};
	DataObjects objs {
		in_fields => DVcontour.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};

	mlink+OPort2 out_fld => DVcontour.out;
};

MODS.isovolume isovolume_ARR {
	imlink in_field;
	IsoVolParam {
		iso_level+nres => cache((in_field[0].node_data[iso_component].min + 
		             in_field[0].node_data[iso_component].max) / 2);
	};
	DVcut[array_size(in_field)] {
		in =>in_field[index_of(DVcut)];
	};
	DVnode_data_labels {
		in => in_field[0];
	};
	DVcell_data_labels {
		in => in_field[0];
	};

	node_minmax_arr min_max {
		in_field => <-.in_field;
		component => <-.IsoVolParam.iso_component;
	};

	IsoVolUI {
		ilink in_fld => in_field[0];

		cut_level {
			min => <-.<-.min_max.min;
			max => <-.<-.min_max.max;
		};

	};
	DataObjects objs {
		in_fields => DVcut.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVcut.out;
};

MODS.plane_crop plane_crop_ARR {
	imlink in_field;
	DVplane_crop[array_size(in_field)] {
		in =>in_field[index_of(DVplane_crop)];
	};
	PlaneCropUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVplane_crop.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 1;
	};
	mlink+OPort2 out_fld => DVplane_crop.out;
};

MODS.slice slice_ARR {
	imlink in_field;
	DVslice[array_size(in_field)] {
		in =>in_field[index_of(DVslice)];
	};
	DVnode_data_labels {
		in => in_field[0];
	};
	DVcell_data_labels {
		in => in_field[0];
	};
	SliceUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVslice.out;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
		dos.Obj.xform_mode = 1;
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 2;
		Top.alt_xform+nres => <-.<-.in_plane.xform;
	};
	mlink+OPort2 out_fld => DVslice.out;
};

MODS.slice_plane slice_plane_ARR {
	imlink in_field;
	xlate=>{0.0, 0.0,
			(in_field[0].coordinates.min_vec[2]+in_field[0].coordinates.max_vec[2])/2};
	plane {
		points+nres => {in_field[0].coordinates.min_vec[0], in_field[0].coordinates.min_vec[1], 
			  in_field[0].coordinates.max_vec[0], in_field[0].coordinates.max_vec[1]};
	};
	DVslice[array_size(in_field)] {
		in =>in_field[index_of(DVslice)];
	};
	DVnode_data_labels {
		in => in_field[0];
	};
	DVcell_data_labels {
		in => in_field[0];
	};
	SliceUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVslice.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject slice_obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 2;
		Top.alt_xform+nres => <-.<-.plane.xform;
	};
	mlink+OPort2 out_fld => DVslice.out;
};

MODS.streamlines streamlines_ARR {
	imlink in_field;
	DVstream[array_size(in_field)] {
		in =>in_field[index_of(DVstream)];
	};
	DVmagnitude[array_size(in_field)] {
		in => DVstream[index_of(DVmagnitude)].out;
	};
	StreamUI {
		ilink in_fld => in_field[0];
	};
	DVswitch[array_size(in_field)] {
		in => {DVstream[index_of(DVswitch)].out,  
			DVmagnitude[index_of(DVswitch)].out};
	};
	DataObjects objs {
		in_fields => DVswitch.out;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
		dos.Obj.xform_mode = 1;
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 2;
		Top.alt_xform+nres => <-.<-.in_probe.xform;
	};
	mlink+OPort2 out_fld => DVswitch.out;
};

MODS.advector advector_ARR {
	imlink in_field;
	Advect[array_size(in_field)] {
		in_fld => in_field[index_of(Advect)];
	};
	AdvectUI {
		ilink in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => Advect.out_fld;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
		dos.Obj.type = 1;
		dos.Obj.xform_mode = 1;
	};
	DataObjects objs1 {
		in_fields => Advect.out_fld1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
		dos.Obj.xform_mode = 1;
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
		Top.xform_mode = 2;
		Top.alt_xform+nres => <-.<-.in_probe.xform;
	};
	GroupObject obj1 {
		Top.name => name_of(<-.<-.<-)+"_streamline";
		child_objs => objs1.dos.obj;
		Top.xform_mode = 2;
		Top.alt_xform+nres => <-.<-.in_probe.xform;
	};
	mlink+OPort2 out_fld => Advect.out_fld;
};

MODS.thresh_null thresh_null_ARR {
	imlink in_field;
	DVthresh_null[array_size(in_field)] {
		in =>in_field[index_of(DVthresh_null)];
	};
	ThreshNullUI {
		link in_fld => in_field[0];
	};
	DataObjects objs {
		in_fields => DVthresh_null.out;
		dos.Obj.xform_mode = 1;
		dos {
			Obj {
				name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			};
		};
	};
	GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		Top.xform_mode = 1;
		child_objs => objs.dos.obj;
	};
	mlink+OPort2 out_fld => DVthresh_null.out;
};

};

library+sort+buffered Multi_Block {
   MODS.mblock_to_fields mblock_to_fields
   MODS.fields_to_mblock fields_to_mblock;
   MODS.stream_multi_block stream_multi_block;
   MODS.advect_multi_block advect_multi_block;
};

};
