/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ne_libs.v#1 $
*/

flibrary NELIBS <
   compile_subs = 0,
   NEvisible    = 0
> {

//
// Simplified Start page oriented towards new users
//
flibrary NE_START<user_library=0>  {
   flibrary Data_Import<user_library=0,NEdisplayMode="open"> {
      WIZARD.data_import_wizard ImportWizard;
      MODS.Read_Field Read_Field;
      MODS.Read_UCD   Read_UCD;
      MODS.Read_Image Read_Image;
#ifdef NETCDF_KIT
      NETCDF.Read_Field  Rd_netCDF_Fld;
#endif
#ifdef HDF5_KIT
      HDF5.Rd_HDF5_Field Rd_HDF5_Field;
#endif  
      MODS.Read_Text_Columns    Rd_Text_Columns;
      MODS.Read_Text_Grid       Rd_Text_Grid;
      MODS.Read_Text_Sequence   Rd_Text_Sequence;
      MODS.Read_Binary_Sequence Rd_Bin_Sequence;
      MODS.Read_DXF             Read_DXF;
   };

   flibrary Visualization<user_library=0,NEdisplayMode="open"> {
      WIZARD.data_visualization_wizard VizWizard;
      // Geoms
      GEOMS.Axis2D axis_2d;
      GEOMS.Axis3D axis_3d;
      // Filters
      MODS.clamp clamp;
      MODS.crop crop;
      MODS.data_math data_math;
      MODS.downsize downsize;
      MODS.extract_component extract_component;
      MODS.set_null set_null;
      MODS.threshold threshold;
      // Mappers
      MODS.bounds bounds;
      MODS.city_plot city_plot_2d;
      MODS.edges edges;
      MODS.isosurface isosurface;
      MODS.isoline isoline;
      MODS.isovolume isovolume;
      MODS.orthoslice orthoslice;
      MODS.ribbons_plot ribbons_plot_2d;
      MODS.surf_plot surf_plot_2d;
#ifdef VX_KIT
      MODS.volume_render volume_render;
#endif
   };

   flibrary+buffered View_Export<user_library=0,NEdisplayMode="open"> {
      HLM.OutputImage OutputImage;
#ifdef VPS_RENDERER
      GDM.Viewers.OutputVPS OutputVPS;
#endif
#ifdef VRML_RENDERER
      GDM.Viewers.OutputVRML OutputVRML;
#endif
#ifdef ANIM_KIT
      ANIM_MODS.image_capture OutputMovie;
#endif
#ifdef NETCDF_KIT
      NETCDF.Write_Field Wr_netCDF_Fld;
#endif
   };

   flibrary+buffered Examples<user_library=0,NEdisplayMode="open"> {
      // Data Import Examples
#ifdef NETCDF_KIT
      DV_EXAMP.NetCDF_SnowCover   rd_netCDF;
#endif
      DV_EXAMP.Text_Grid          rd_text_grid;
#ifdef AG_KIT
      DV_EXAMP.Text_Columns       rd_text_columns;
#endif
      DV_EXAMP.Text_Sequence      rd_text_sequence;
      DV_EXAMP.Bin_Sequence_Synth rd_bin_sequence;
      // Visualization Examples
#ifdef HDF5_KIT
      DV_EXAMP.City_Plot  city_plot;
#endif
      DV_EXAMP.Clamp      clamp;
      DV_EXAMP.Crop       crop;
      DV_EXAMP.Downsize   downsize;
      DV_EXAMP.Isoline    isoline;
      DV_EXAMP.Isosurface isosurface;
      DV_EXAMP.Isovolume  isovolume;
      DV_EXAMP.Orthoslice orthoslice;
      DV_EXAMP.Null_Data  set_null;
#ifdef HDF5_KIT
      DV_EXAMP.Ribbon_Plot ribbon_plot;
#endif
      DV_EXAMP.Surf_plot  surface_plot;
      DV_EXAMP.Threshold  threshold;
#ifdef VX_KIT
      DV_EXAMP.VolumeRendTransparent volume_render;
#endif
      // View Export Examples
      HLM_EXAMP.OutputImage  outputImage;
#ifdef VPS_RENDERER
      GD_EXAMP.VPS1          outputVPS;
#endif
#ifdef VRML_RENDERER
      GD_EXAMP.VRML_Anchor_1 outputVRML;
#endif
   };

   // Icons will not show up if it is buffered
   flibrary Demonstrations<user_library=0,NEdisplayMode="open"> {
      DEMOS.Apps.Solar_System Solar_System;
#ifdef HDF5_KIT
      DEMOS.Apps.Climate      Climate;
#endif
      DEMOS.Apps.FlightPath   FlightPath;
      DEMOS.Apps.Image2Volume Image2Volume;
#ifdef VX_KIT
      DEMOS.Apps.VolumeShells VolumeShells;
#endif
   };
};

// Left column on the Main page

flibrary+buffered NE_DATA_IO<user_library=0> {
#ifdef ACKIT
#define INCLUDE_READ_GEOM	1
#endif
#ifdef AC_KIT_V1
#define INCLUDE_READ_GEOM	1
#endif

   MODS.Read_Field Read_Field;
   MODS.Read_UCD   Read_UCD;
   MODS.Read_Image Read_Image;
#ifdef HDF5_KIT
   HDF5.Rd_HDF5_Field Rd_HDF5_Field;
#endif
#ifdef NETCDF_KIT
   NETCDF.Read_Field  Rd_netCDF_Fld;
#endif
   MODS.Read_Text_Columns    Rd_Txt_Columns;
   MODS.Read_Text_Grid       Rd_Txt_Grid;
   MODS.Read_Text_Sequence   Rd_Txt_Sequence;
   MODS.Read_Binary_Sequence Rd_Bin_Sequence;
   MODS.Read_DXF             Read_DXF;
   MODS.Read_Polygon         Read_Polygon;
   MODS.Read_Triangle        Read_Triangle;
   MODS.Read_Img2Vol Read_Img2Vol;
   MODS.Read_Volume  Read_Volume;
   CFD.Read_PLOT3D Read_PLOT3D;
   CFD.Read_CGNS   Read_CGNS;
#ifdef INCLUDE_READ_GEOM
   MODS.Read_Geom Read_Geom;
   MODS.Read_Geoms Read_Geoms;
#endif

   MODS.Print_Field Print_Field;
   MODS.Write_Image Write_Image;
#ifdef HDF5_KIT
   HDF5.Wr_HDF5_Field Wr_HDF5_Field;
#endif
#ifdef NETCDF_KIT
   NETCDF.Write_Field Wr_netCDF_Fld;
#endif

   MODS.Loop Loop;

#ifdef ANIM_KIT
   ANIM_MODS.animator animator;
   ANIM_MODS.image_capture image_capture;
   ANIM_MODS.geom_capture geom_capture;
   ANIM_MODS.geom_replay geom_replay;
#endif

   CMAP_EDTR.ColorMapEditor ColormapEditor;
#ifdef VIZ_EXPRESS
#else
   DATAS.colormap colormap;
#endif

#ifdef READ_URL
   W3C.Read_URL Read_URL;
#ifdef INCLUDE_READ_GEOM
   W3C.ReadWebGeom ReadWebGeom;
#endif
   W3C.ReadWebField ReadWebField;
#endif

#ifdef GIS_KIT
   GIS_UI.GISWorldDataBank GISWorldDataBank;
   GIS_UI.GISDigitalElevation GISDigitalElevation;
#endif

#ifdef NETCDF_KIT
   NETCDF.Read_Object Rd_netCDF_Obj;
   NETCDF.Write_Object Wr_netCDF_Obj;
#endif
};

flibrary NE_UI {
    library Containers <NEdisplayMode="open",user_library=0> {
	 UIapp             UIapp;
	 UIshell           UIshell;
	 UIpanel           UIpanel;
	 UIframe           UIframe;
	 UImod_panel	   UImod_panel;
	 UIscrolledWindow  UIscrolledWindow;
	 UItemplateDialog  UItemplateDialog;
	 UImod_panel	   UImod_panel;
	 UIrenderView	   UIrenderView;
    };

    library Menu_Bar <NEdisplayMode="open",user_library=0> {
	 UIcmdList         UIcmdList;
	 UIradioList	   UIradioList;
	 UIcmd             UIcmd;
	 UIoption          UIoption;
#ifndef MSDOS
	 UIhelpCmdList     UIhelpCmdList;
#endif
	 UImenuSeparator   UImenuSeparator;
    };

    library+sort Widgets <NEdisplayMode="open",user_library=0> {
	 UIlabel           UIlabel;
	 UItext            UItext;
	 UIbutton          UIbutton;
	 UItoggle          UItoggle;
	 UIdial            UIdial;
	 UIslider          UIslider;
	 UIfield           UIfield;
	 UIlist            UIlist;
	 UImultiList	   UImultiList;
	 UIoptionMenu	   UIoptionMenu;
    };

    library Option_Boxes <NEdisplayMode="open",user_library=0> {
	 UIoptionBox       UIoptionBox;
	 UIradioBox        UIradioBox;
	 UIradioBoxLabel   UIradioBoxLabel;
	 UIoption          UIoption;
	 UIradioBoxLabel   UIradioBoxLabel;
	 UIoptionBoxLabel  UIoptionBoxLabel;
    };

    library+sort Dialogs <NEdisplayMode="open",user_library=0> {
	UIerrorDialog     UIerrorDialog;
	UIfileDialog      UIfileDialog;
	UIdirectoryDialog UIdirectoryDialog;
	UIinfoDialog      UIinfoDialog;
	UImessageDialog   UImessageDialog;
	UImultiSelDialog  UImultiSelDialog;
      	UIpromptDialog    UIpromptDialog;
	UIquestionDialog  UIquestionDialog;
	UIselectionDialog UIselectionDialog;
	UIwarningDialog   UIwarningDialog;
	UIworkingDialog   UIworkingDialog;
    };

    // Components_ differentiates this from VIEW.Components to workaround
    // name resolve bug
    library+sort Components_ <NEdisplayMode="open",user_library=0> {
        UIfontCursor      UIfontCursor;
	UIpixmapCursor    UIpixmapCursor;
    };
    NElink Interactors<NEdisplayMode="open"> => UI.Interactors;

};

flibrary NE_GD {
    library+buffered Objects <NEdisplayMode="open",user_library=0> {
        library+buffered Primitives <user_library=0> {
	    GD.DefaultObject 		DefaultObject;
	    GDIF.DefaultModes 		DefaultModes;
	    GDIF.GDpick_info		DefaultPickInfo;
	    GDIF.DefaultProps 		DefaultProps;
	    GD.DefaultTexture 		DefaultTexture;
	    GDIF.DefaultXform 		DefaultXform;
        };
	GD.DataObject			DataObject;
	GD.DataObjectNoTexture		DataObjectNoTexture;
	GD.DataObjectLite		DataObjectLite;
	GD.AltObject			AltObject;
	GD.GroupObject			GroupObject;
    };

    library+buffered Views <NEdisplayMode="open",user_library=0> {
        library+buffered Primitives <user_library=0> {
	    GD.DefaultView 		DefaultView;
	    GD.DefaultCamera2D 		DefaultCamera2D;
	    GD.DefaultCamera3D 		DefaultCamera3D;
	    GDIF.DefaultLight 		DefaultLight;
	    GDIF.DefaultLightOn 	DefaultLightOn;
	    GDIF.DefaultLightInfo 	DefaultLightInfo;
	    GDIF.DefaultPickCtrl 	DefaultPickCtrl;
#ifdef PRT_RENDERER
	    GD.DefaultPrtOutput		DefaultPrtOutput;
#endif
	    GD.DefaultFieldOutput	DefaultFieldOutput;
        };
        NElink Palettes = PAL;
        library+buffered Scenes<user_library=0> {
	    GDM.Mscene		Mscene;
	    GDM.Mscene3D	Mscene3D;
	    GDM.Mscene2D	Mscene2D;
	    GDM.Iscene		Iscene;
	    GDM.Iscene3D	Iscene3D;
	    GDM.Iscene2D	Iscene2D;
	    GDM.Uscene		Uscene;
	    GDM.Uscene3D	Uscene3D;
	    GDM.Uscene2D	Uscene2D;
            GDM.Uview_link	Uview_link;
        };
    };

    library+buffered Editors <NEdisplayMode="open",user_library=0> {
        library+buffered Primitives <user_library=0> {
	    GD.Editors.GDcamera_edit	GDcamera_edit;
	    GD.Editors.GDlight_edit	GDlight_edit;
	    GD.Editors.GDlinfo_edit	GDlinfo_edit;
	    GD.Editors.GDmodes_edit	GDmodes_edit;
	    GD.Editors.GDobj_edit	GDobj_edit;
	    GD.Editors.GDobj_sel	GDobj_sel;
	    GD.Editors.GDprops_edit	GDprops_edit;
	    GD.Editors.GDtexture_edit	GDtexture_edit;
	    GD.Editors.GDtrack_edit	GDtrack_edit;
	    GD.Editors.GDview_edit	GDview_edit;
	    GD.Editors.GDview_selector	GDview_selector;
	    GD.Editors.GDxform_edit	GDxform_edit;
        };
	NElink UI_Editors = GDM.UI_Editors;
    };

    library+buffered Interactivity<NEdisplayMode="open",user_library=0> {
        library+buffered Primitives <user_library=0> {
	    GD.Interactivity.GDdraw2d_cursor	GDdraw2d_cursor;
	    GD.Interactivity.GDedit_mesh	GDedit_mesh;
	    GD.Interactivity.GDmap2d_ss		GDmap2d_ss;
	    GD.Interactivity.GDroi2d_click	GDroi2d_click;
	    GD.Interactivity.GDroi2d_cont	GDroi2d_cont;
	    GD.Interactivity.GDvector2raster	GDvector2raster;
        };
	NElink UI_Interactivity = GDM.Interactivity;
    };

    library+buffered User_Interface<NEdisplayMode="open",user_library=0> {
	UI.Shells.UIshell		UIshell;
	UI.Panels.UIpanel		UIpanel;
	UI.Panels.UIframe		UIframe;
	UI.Panels.UIrenderView		UIrenderView;
	UI.Interactors.UIonePoint	UIonePoint;
	UI.Interactors.UItwoPoint	UItwoPoint;
	UI.Interactors.UImouseEvents	UImouseEvents;
	VIEW.Components.ViewUI		ViewUI;
    };

    library+sort Full_Library {
	NElink				GDIF = <-.<-.<-.GDIF;
	NElink				REN  = <-.<-.<-.REN;
	NElink				PAL  = <-.<-.<-.PAL;
	NElink				GD   = <-.<-.<-.GD;
	NElink				VIEW = <-.<-.<-.VIEW;
    };
};

#ifdef AG_KIT
flibrary NE_AG<NEdisplayMode="open",user_library=0> {
    NElink	Basic<NEdisplayMode="open"> = AG.Basic;
    NElink	Axes<NEdisplayMode="open"> = AG.Axes;
    NElink	Graphing<NEdisplayMode="open"> = AG.Graphing;
    NElink	Contouring<NEdisplayMode="open"> = AG.Contouring;
    NElink	Graph_Macros<NEdisplayMode="open">  = Templates.AGHLM;
    NElink	Full_Library = AG;
};
#endif

flibrary NE_DV {
    flibrary Field_Schema <NEdisplayMode="open",user_library=0> {
	library Data_Schema<user_library=0> {
	    Data			Data;
	    Node_Data			Node_Data;
	    Node_Data_Byte		Node_Data_Byte;
	    Node_Data_Int		Node_Data_Int;
	    Node_Data_Float		Node_Data_Float;
	    Cell_Data			Cell_Data;
	    Cell_Data_Poly		Cell_Data_Poly;
	    Cell_Data_Set		Cell_Data_Set;
	    Cell_Data_Set_Poly		Cell_Data_Set_Poly;
	    Time_Node_Data		Time_Node_Data;
	    Time_Node_Data_Byte		Time_Node_Data_Byte;
	    Time_Node_Data_Int		Time_Node_Data_Int;
	    Time_Node_Data_Float	Time_Node_Data_Float;
	    Time_Cell_Data		Time_Cell_Data;
	    Time_Cell_Data_Poly		Time_Cell_Data_Poly;
	    Time_Cell_Data_Set		Time_Cell_Data_Set;
	    Time_Cell_Data_Set_Poly	Time_Cell_Data_Set_Poly;
	};

	library Mesh_Schema<user_library=0> {

	    Xform			Xform;

	    library Grid_Schema<user_library=0> {
		Grid			Grid;
		Grid_Struct    		Grid_Struct;
		Grid_Unif		Grid_Unif;
		Grid_Rect		Grid_Rect;
		Grid_Cyl_Rect		Grid_Cyl_Rect;
		Grid_Cyl_Unif		Grid_Cyl_Unif;
		Grid_Spher_Rect		Grid_Spher_Rect;
		Grid_Spher_Unif		Grid_Spher_Unif;
		Time_Grid		Time_Grid;
		Time_Grid_Struct	Time_Grid_Struct;
	    };

	    library Cells_Schema<user_library=0> {
		Cells			Cells;
		Cell_Set		Cell_Set;

		Point			Point;
		Line			Line;
		Line2			Line2;
		Polyline		Polyline;
		Tri			Tri;
		Tri2			Tri2;
		Polytri			Polytri;
		Quad			Quad;
		Quad2			Quad2;
		Tet			Tet;
		Tet2			Tet2;
		Hex			Hex;
		Hex2			Hex2;
		Pyr			Pyr;
		Pyr2			Pyr2;
		Prism			Prism;
		Prism2			Prism2;
	    };

	    Mesh			Mesh;
	    Mesh_Struct			Mesh_Struct;
	    Mesh_Unif			Mesh_Unif;
	    Mesh_Rect			Mesh_Rect;
	    Mesh_Cyl_Unif		Mesh_Cyl_Unif;
	    Mesh_Cyl_Rect		Mesh_Cyl_Rect;
	    Mesh_Spher_Unif		Mesh_Spher_Unif;
	    Mesh_Spher_Rect		Mesh_Spher_Rect;
	    Time_Mesh			Time_Mesh;
	    Time_Mesh_Struct		Time_Mesh_Struct;
	};

	Field				Field;
	Field_Struct			Field_Struct;
	Field_Unif			Field_Unif;
	Field_Rect			Field_Rect;
	Field_Cyl_Unif			Field_Cyl_Unif;
	Field_Cyl_Rect			Field_Cyl_Rect;
	Field_Spher_Unif		Field_Spher_Unif;
	Field_Spher_Rect		Field_Spher_Rect;

	library Field_Modifiers<user_library=0> {
	    Space1			Space1;
	    Space2			Space2;
	    Space3			Space3;
	    Scalar			Scalar;
	    Vector			Vector;
	    Dim0			Dim0;
	    Dim1			Dim1;
	    Dim2			Dim2;
	    Dim3			Dim3;
	    Byte			Byte;
	    Int				Int;
	    Float			Float;
	};
    };

    NElink Primitives     <NEdisplayMode="open">  = DV;
    NElink Macros         <NEdisplayMode="open">  = DV_MACROS;
    NElink Viz_Macros     <NEdisplayMode="open">  = HLM;
    NElink Geometries     <NEdisplayMode="open">  = NE_GEOMS;

    flibrary Misc <NEdisplayMode="open",user_library=0> {
#ifdef NETCDF_KIT
        NElink NetCDF_Macros  => Templates.NETCDF.NC_Macros;
        NElink NetCDF_Modules => Templates.NETCDF.NC_Modules;
#endif
#ifdef GIS_KIT
        NElink GIS_Macros     => Templates.GIS_UI;
        NElink GIS_Modules    => Templates.GIS;
#endif
#ifdef REDUCT_KIT
        flibrary+buffered Reduction<user_library=0> {
            RDCT.surface_reduction surface_reduction;
            RDCT.data_surface_reduction data_surface_reduction;
        };
#endif
    };

}; // NE_DV

library NE_IP {
    NElink Converters     <NEdisplayMode="open">  = IP.Interface;
    NElink Modules        <NEdisplayMode="open">  = IP.Macros;
    NElink User_Interface <NEdisplayMode="open">  = IP.IPui;
    NElink Base_Types     <NEdisplayMode="open">  = IP_PKG.IPbase;
    NElink Base_Functions <NEdisplayMode="open">  = IP_PKG.IPfunc;

    library+sort Full_Library <NEdisplayMode="closed"> {
	NElink				IP = <-.<-.<-.IP;
	NElink				IP_PKG = <-.<-.<-.IP_PKG;
    };
};

#ifdef ACKIT

library NE_AC {
    NElink Data_Input	<NEdisplayMode="open"> = AC_KIT.Data_Input;
    NElink Filters	<NEdisplayMode="open"> = AC_KIT.Filters;
    NElink Mappers	<NEdisplayMode="open"> = AC_KIT.Mappers;
    NElink Data_Output	<NEdisplayMode="open"> = AC_KIT.Data_Output;
    NElink Converters	<NEdisplayMode="open"> = ACVT;

    library+sort Full_Library <NEdisplayMode="closed"> {
	NElink				ACMOD = <-.<-.<-.AC_KIT;
	NElink				ACVT = <-.<-.<-.ACVT;
    };
};

#endif // ACKIT

#ifdef AC_KIT_V1

library NE_AC {
//    NElink Data_Input	<NEdisplayMode="open"> = ACU.ACU_Data_Input;
//    NElink Filters	<NEdisplayMode="open"> = ACU.ACU_Filters;
//    NElink Mappers	<NEdisplayMode="open"> = ACU.ACU_Mappers;
//    NElink Data_Output	<NEdisplayMode="open"> = ACU.ACU_Data_Output;
    NElink Converters	<NEdisplayMode="open"> = ACVT;

//    library+sort Full_Library <NEdisplayMode="closed"> {
//	NElink				ACMOD = <-.<-.<-.ACMOD;
//	NElink				ACVT = <-.<-.<-.ACVT;
//	NElink				ACU = <-.<-.<-.ACU;
//    };
};

#endif // AC_KIT_V1

  /*******************************************************************

     miscellaneous modules in accessories

  *******************************************************************/

flibrary GD_Modules<user_library=0> {
  GDM.Uscene Uscene;
  GDM.Uscene3D Uscene3D;
  GDM.Uscene2D Uscene2D;
  GDM.Uview_link Uview_link;

  /* Need to use the GDM versions or save/restore won't work */
  GDM.DataObject DataObject;
  GDM.DataObjectLite DataObjectLite;
  GDM.GroupObject GroupObject;
  GDM.DefaultObject DefaultObject;

  DefaultXform DefaultXform;
  DefaultModes DefaultModes;
  DefaultProps DefaultProps;

  GDM.GDobject_templ GDobject_templ;
  GDM.GDxform_edit GDxform_edit;
  GDM.GDmap2d_ss GDmap2d_ss;
  GDM.GDpick_process GDpick_process;
  GDM.GDtrack_edit GDtrack_edit;

  DATAS.colormap colormap;
};

// Library of AG high-level macros that VIZ users can access
flibrary+sort+buffered NE_GRAPHS_HLM<user_library=0> {
#ifdef AG_KIT
   AGHLM.XYAxis XYAxis;
   AGHLM.Graph Graph;
   AGHLM.GraphLegend GraphLegend;
   AGHLM.GraphViewport GraphViewport;
   AGHLM.GraphWorld GraphWorld;
   AGHLM.PolarGraph PolarGraph;
   AGHLM.PolarAxis PolarAxis;
   AGHLM.PolarWorld PolarWorld;
   AGHLM.General_Graph General_Graph;
   AGHLM.General_PolarGraph General_PolarGraph;
   AGHLM.extract_column extract_column;
   AG.Macros.AGGraphFieldObj AGGraphFieldObj;
   AG.Macros.AGContourFieldObj AGContourFieldObj;
#endif
};

flibrary NE_UTILITY<user_library=0> {
   NElink General => Templates.GMOD;
   NElink File_Access => Templates.FILE;
   NElink Viz_Macros => Templates.HLM;
#ifdef REDUCT_KIT
   flibrary+buffered Reduction<user_library=0> {
      RDCT.surface_reduction surface_reduction;
      RDCT.data_surface_reduction data_surface_reduction;
   };
#endif
#ifdef GIS_KIT
   NElink GIS  => Templates.GIS_UI;
#endif
};

// Main page Filters
// This is now shared for both DEV and VIZ
flibrary+sort+buffered NE_FILTERS<user_library=0> {
   MODS.combine_rgb combine_rgb;
   MODS.coordinate_math coordinate_math;
   MODS.data_math data_math;
   MODS.cell_data_math cell_data_math;
   MODS.downsize downsize;
   MODS.crop crop;
   MODS.extract_component extract_component;
   MODS.extract_mesh extract_mesh;
   MODS.extract_cell_component extract_cell_component;
   MODS.extract_scalar extract_scalar;
   MODS.combine_vect combine_vect;
   MODS.threshold threshold;
   MODS.threshold_cell threshold_cell;
   MODS.clamp clamp;
   MODS.clamp_cell clamp_cell;
   MODS.least_squares least_squares;
   MODS.filter_1d filter_1d;
   MODS.set_xform set_xform;
   MODS.reset_xform reset_xform;
   MODS.set_null set_null;
   MODS.cell_to_node cell_to_node;
   MODS.select_cells select_cells;
   MODS.gradient gradient;
   MODS.curl curl;
   MODS.divergence divergence;
   MODS.xform_to_plane xform_to_plane;
   MODS.mirror mirror;
   MODS.scale scale;
   MODS.magnitude magnitude;
   MODS.combine_comp combine_comp;
   MODS.explode_materials explode_materials;
   MODS.explode_fields explode_fields;
   MODS.mblock_to_fields mblock_to_fields;
   MODS.fields_to_mblock fields_to_mblock;
   MODS.rotate rotate;
   MODS.replicate_field replicate_field;
   MODS.project_axis project_axis;
   MODS.project_plane project_plane;
   MODS.reset_extent reset_extent;
   MODS.reset_minmax reset_minmax;
   MODS.reset_minmax_cell reset_minmax_cell;
   MODS.set_minmax set_minmax;
   MODS.set_minmax_cell set_minmax_cell;
   MODS.set_global_extent set_global_extent;
   MODS.set_global_minmax set_global_minmax;
   MODS.set_global_minmax_cell set_global_minmax_cell;
   MODS.extract_time_step extract_time_step;
   MODS.interp_time_step interp_time_step;
#ifdef GIS_KIT
   MODS.GISMapTransform GISMapTransform;
#endif
};

// Main page Mappers
// This is now shared for both DEV and VIZ
flibrary+sort+buffered NE_MAPPERS<user_library=0> {
   MODS.surf_plot surf_plot;
   MODS.surf_optimize surf_optimize;
   MODS.ribbons_plot ribbons_plot;
   MODS.table_to_uniform_field table_to_uniform_field;
   MODS.table_to_scatter_field table_to_scatter_field;
   MODS.texture_mesh texture_mesh;
#ifdef GIS_KIT
   MODS.texture_sphere texture_sphere;
#endif
   MODS.offset offset;
   MODS.orthoslice orthoslice;
   MODS.scat_to_unif scat_to_unif;
   MODS.scat_bin scat_bin;
   MODS.bounds bounds;
   MODS.scat_to_tri scat_to_tri;
   MODS.edges edges;
   MODS.external_faces external_faces;
   MODS.external_edges external_edges;
   MODS.volume_integr volume_integr;
   MODS.cut cut;
   MODS.cut_plane cut_plane;
   MODS.glyph glyph;
   MODS.geo_glyph geo_glyph;
   MODS.text_glyph text_glyph;
   MODS.city_plot city_plot;
   MODS.cylinder_plot_unif cylinder_plot_unif;
   MODS.shrink_cells shrink_cells;
   MODS.cell_centers cell_centers;
   MODS.extrude_cells extrude_cells;
   MODS.interp_data interp_data;
   MODS.interp_data_to_unif interp_data_to_unif;
   MODS.interp_cell_data interp_cell_data;
   MODS.probe probe;
   MODS.probe_cell probe_cell;
   MODS.iso_probe iso_probe;
   MODS.draw_line draw_line;
   MODS.isosurface isosurface;
   MODS.isosurface_nest isosurface_nest;
   MODS.isosurface_trace isosurface_trace;
   MODS.isoline isoline;
   MODS.isoline_trace isoline_trace;
   MODS.solid_contour solid_contour;
   MODS.contour contour;
   MODS.contour_texture contour_texture;
   MODS.isovolume isovolume;
   MODS.plane_crop plane_crop;
   MODS.crop_box crop_box;
   MODS.crop_orthobox crop_orthobox;
   MODS.slice slice;
   MODS.slice_plane slice_plane;
   MODS.slice_orthoplane slice_orthoplane;
   MODS.adjust_slice_spacing adjust_slice_spacing;
   MODS.streamlines streamlines;
   MODS.stream_multi_block stream_multi_block;
   MODS.advector advector;
   MODS.advect_multi_block advect_multi_block;
   MODS.thresh_null thresh_null;
   MODS.thresh_null_cells thresh_null_cells;
   MODS.excavate_brick3D excavate_brick3D;
   MODS.cut_texture3D cut_texture3D;
   MODS.slice_texture3D slice_texture3D;
   MODS.slice_texture2D slice_texture2D;
   MODS.interp_texture3D interp_texture3D;
   MODS.roi_to_surface roi_to_surface;
   MODS.copy_ROI copy_ROI;
   MODS.display_vol_ROI display_vol_ROI;
   MODS.vect2rast_vol vect2rast_vol;
   MODS.tile_ROIs tile_ROIs;
   MODS.tile_volume tile_volume;
   MODS.tile_volume_ROIs tile_volume_ROIs;
   MODS.volume_render volume_render;
#ifdef OGL_RENDERER
   DV_OGL.illuminated_lines illuminated_lines;
#endif
   // Using lower case just so it won't be listed first
   SEGM_EDTR.SegmentationEditor segmentation_editor;
};

// This is now shared for both DEV and VIZ
flibrary+sort+buffered NE_GEOMS<user_library=0> {
   GEOMS.Axis2D Axis2D;
   GEOMS.Axis3D Axis3D;
   GEOMS.Axis_Glyph2D Axis_Glyph2D;
   GEOMS.Axis_Glyph3D Axis_Glyph3D;
   GEOMS.BoundingBox2D BoundingBox2D;
   GEOMS.BoundingBox3D BoundingBox3D;
   GEOMS.TextString TextString;
   GEOMS.TextString3D TextString3D;
   GEOMS.TextTitle TextTitle;
   GEOMS.Cross2D Cross2D;
   GEOMS.Cross3D Cross3D;
   GEOMS.Arrow1 Arrow1;
   GEOMS.Arrow2 Arrow2;
   GEOMS.Arrow3 Arrow3;
   GEOMS.Arrow4 Arrow4;
   GEOMS.Diamond2D Diamond2D;
   GEOMS.Diamond3D Diamond3D;
   GEOMS.Sphere Sphere;
   GEOMS.FPoint1D FPoint1D;
   GEOMS.FPoint2D FPoint2D;
   GEOMS.FPoint3D FPoint3D;
   GEOMS.FLine2D FLine2D;
   GEOMS.FLine3D FLine3D;
   GEOMS.FPlane FPlane;
   GEOMS.FBox FBox;
   GEOMS.FBox_Planes FBox_Planes;
   //GEOMS.Block Block;
   GEOMS.FCircle2D FCircle2D;
   GEOMS.FCircle3D FCircle3D;
   GEOMS.Jet Jet;
   GEOMS.Point1D Point1D;
   GEOMS.Point2D Point2D;
   GEOMS.Point3D Point3D;
   GEOMS.Line2D Line2D;
   GEOMS.Line3D Line3D;
   GEOMS.Plane Plane;
   GEOMS.Box Box;
   GEOMS.LegendHoriz LegendHoriz;
   GEOMS.LegendVert LegendVert;
   GEOMS.BackgroundFade BackgroundFade;

   HLM.Basic_Axis2D Basic_Axis2D;
   HLM.Basic_Axis3D Basic_Axis3D;
};


// Viewers column on the main page
flibrary+buffered NE_VIEWERS<user_library=0> {
   GDM.Viewers.Uviewer3D Uviewer3D;
   GDM.Viewers.Uviewer2D Uviewer2D;
   GDM.Viewers.Uviewer Uviewer;
   GDM.Viewers.DisplayImage ImageView;	// A specialized image viewer
#ifdef VPS_RENDERER
   GDM.Viewers.OutputVPS OutputVPS;
#endif
#ifdef VRML_RENDERER
   GDM.Viewers.OutputVRML OutputVRML;
#endif
   HLM.OutputImage OutputImage;
   GDM.Viewers.OutputField OutputField;
   GDM.Viewers.OutputFile OutputFile;
};

/* -------------------------------------------------------------------------
 * The following are for the "VXP Main" and associated libraries: it would be
   better to share these with those in Main, etc (there are only a few
   differences bracketed by VXP_EXCLUDE), or at least include the standard
   libs and then somehow exclude the things we don't want...
 */

// DV ("Visualization") page for VXP
flibrary NE_DV_VXP {
   NElink Field_Schema    <NEdisplayMode="open">
                     => Templates.NELIBS.NE_DV.Field_Schema;
   // VXP gets a subset of the full DV library
   NElink Primitives      <NEdisplayMode="open">  = Templates.DVM;
   NElink Viz_Macros      <NEdisplayMode="open">  = Templates.HLM;
   NElink Geometries      <NEdisplayMode="open">  = NE_GEOMS;

   flibrary Misc <NEdisplayMode="open",user_library=0> {
#ifdef NETCDF_KIT
      NElink NetCDF_Macros  => Templates.NETCDF.NC_Macros;
      NElink NetCDF_Modules => Templates.NETCDF.NC_Modules;
#endif
#ifdef GIS_KIT
      NElink GIS_Macros     => Templates.GIS_UI;
      NElink GIS_Modules    => Templates.GIS;
#endif
#ifdef REDUCT_KIT
      flibrary+buffered Reduction<user_library=0> {
         RDCT.surface_reduction surface_reduction;
         RDCT.data_surface_reduction data_surface_reduction;
      };
#endif
   };
};


/* -----------------------  End of VXP library stuff  ---------------------- */

}; // End of flibrary NELIBS -- Don't add any objects after this line
