//
//                      Copyright (c) 1995 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/v/ne_prefs.v#1 $
//
//  ne_prefs.v - User preferences for the Network Editor.
//
//---------------------------------------------------------------------//
//
// The NEpreferences object contains user preferences for the Network
// Editor.  It is read once during initialization of the NE.
//
// On the Unix version, each subobject of NEpreferences corresponds to
// an X resource.  If you specify an equivalent X resource, it will be
// used instead of the NEpreferences subobject.  For example, if your
// ~/.Xdefaults file contains the line:
//
//      Express*bevelThickness:  3
//
// the value of bevelThickness will be 3, regardless of the value
// specified in this file.
//
// NOTES ON COLOR DEFINITIONS:
//
// Some colors are specified in this file.  Others are determined by
// X resources (on Unix) or current desktop colors (on Windows).
//
// Colors specified in this file must be in the form "#rrggbb", where
// rr, gg, and bb are the RGB components of the color, expressed in
// hexadecimal notation.  (Example: yellow = "#ffff00")
//
// On Unix, the colors used for unselected objects are determined by
// the "background", "foreground", "topShadowColor", and "bottomShadowColor"
// resources.
//
// On both Unix and Windows, the bevel and text colors for highlighted
// objects depend on the actual highlight background colors.
//
// On Windows, the correspondence between desktop colors and NE colors
// is as follows:
//
// Screen Element Color |  Used for
//----------------------+--------------------------------------------------
// Button Face          |  Background of unselected objects and inside of
//                      |  open groups and macros
// Button Text          |  Text in unselected objects
// Button Highlight     |  Top bevel for unselected and selected objects
// Button Shadow        |  Bottom bevel for unselected and selected objects
// Highlight            |  Background of selected objects
// Highlighted Text     |  Text in selected objects
// Window Background    |  Background of typeins
// 
flibrary+global NE_PREFERENCES <
   locked=1,
   NEvisible=0
> {

group NEpreferences {

    // bevelThickness: The thickness (in pixels) of the beveled edges
    // of objects in the NE.

    int  bevelThickness = 2;

    // highlightUnderPointer: Indicates if an object's name string should
    // be highlighted when the object is under the mouse pointer.  (This
    // is currently unimplemented on the Windows version).

#ifdef MSDOS
    int  highlightUnderPointer = 0;
#else
    int  highlightUnderPointer = 1;
#endif

    // selectedObjectColor: The highlight color for a selected object.
    // (Not used on Windows; see notes above).

    string  selectedObjectColor = "#4080f0";

    // connectingLineColor: The color of the line that appears during a
    // connection operation that indicates the two objects that would be
    // connected if the mouse button was released.

    string  connectingLineColor = "#ffffff";

    // connectingObjectColor and disconnectingObjectColor:  The highlight
    // color, displayed during a connection operation, indicating that an
    // object is a candidate for connection or disconnection.

    string  connectingObjectColor = "#00ff00";
    string  disconnectingObjectColor = "#308030";

    // dropSiteColor: The highlight color used to indicate that an object
    // is the current drop target during a drag-and-drop operation.

    string  dropSiteColor = "#ff40a0";

    // mergeSiteColor: The highlight color used to indicate that an object
    // is the current drop target during a merge operation.

    string  mergeSiteColor = "#ffa040";

    // executingObjectColor and selectedExecutingObjectColor:  The highlight
    // color for an unselected or selected executing object.

    string  executingObjectColor = "#606060";
    string  selectedExecutingObjectColor = "#0040a0";

    // subwindowBackground: The background color of an open group,
    // macro, or typein.

    string  subwindowBackground = "#808080";

    // Font attributes for text items inside the main NE window, not
    // including the menu bar, status bar, or popup menus.
    //
    // NOTE: A font height of 0 causes the locale's default font height
    //       be used.

    string  fontFamily = "default";
    string  fontSlant  = "regular";
#ifdef MSDOS
    string  fontWeight = "medium";
#else
    string  fontWeight = "bold";
#endif
    int     textHeight = 0;

    // Font attributes for NE typein widgets.

    string  typeinFontFamily = "courier";
    string  typeinFontSlant  = "regular";
    string  typeinFontWeight = "medium";
    int     typeinTextHeight = 0;

    // loadedObjectsReplace: Indicates if objects loaded into the NE
    // using the Object->Load Objects... pulldown command replace existing
    // objects with matching names.  The default is false, which causes
    // matching objects to be renamed uniquely.

    int     loadedObjectsReplace = 0;


    int     auto_arrange = 1;
};

};

//---------------------------------------------------------------------//
//                         End of ne_prefs.v                           //
//---------------------------------------------------------------------//

