// PST
// clamp.v
// James S Perrin (MVC)
// Time-stamp: <Thursday 08/07/04 11:19:25 james>

// reset min/max commented out due to execution order issues

flibrary Clamp {
   group ClampParam {
      int+Port2 comp;
      int+Port2 below;
      int+Port2 above;
      double+Port2 min;
      double+Port2 max;
      int+Port2 reset_minmax;
   };

   PST.MODS.pModule pClamp<use_src_file=0> {
      ClampParam+IPort2 &param;
      int comp => .param.comp;
      int below => .param.below;
      int above => .param.above;
      double min => .param.min;
      double max => .param.max;
      Node_Data+IPort2 &in;
      Node_Data+OPort2 out;      
      cxxmethod+req clamp (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // clamp params
	 in+read+req+notify,
	 comp+read+req+notify,
	 below+read+req+notify,
	 above+read+req+notify,
	 min+read+req+notify,
	 max+read+req+notify,
	 out+write
      );      
   };

   PST.UI.pMacroUI pClampUI {
      ClampParam+IPort2 &param;
      Node_Data+IPort2 &in;
      DVnode_data_labels DVnode_data_labels {
	 in => <-.in;
      };
      UIradioBoxLabel UIcompRadioBox {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 title = "Data component";
	 labels => <-.DVnode_data_labels.labels;
	 selectedItem => <-.param.comp;
      };
      UItoggle UIbelowToggle {
	 x = 2;
	 y => <-.UIcompRadioBox.y + <-.UIcompRadioBox.height +4;
	 parent => <-.parent;
	 width => parent.clientWidth -4;
	 label = "Clamp below";
	 set => <-.param.below;
      };
      UIslider UIminSlider {
	 x = 2;
	 y => <-.UIbelowToggle.y + <-.UIbelowToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min+nres => cache(<-.in.node_data[<-.param.comp].min);
	 max+nres => cache(<-.in.node_data[<-.param.comp].max);
	 mode = "real";
	 title = "Below value";
	 value => <-.param.min;
      };
      UItoggle UIaboveToggle {
	 x = 2;
	 y => <-.UIminSlider.y + <-.UIminSlider.height +4;
	 parent => <-.parent;
	 width => parent.clientWidth -4;
	 label = "Clamp above";
	 set => <-.param.above;
      };
      UIslider UImaxSlider {
	 x = 2;
	 y => <-.UIaboveToggle.y + <-.UIaboveToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min+nres => cache(<-.in.node_data[<-.param.comp].min);
	 max+nres => cache(<-.in.node_data[<-.param.comp].max);
	 mode = "real";
	 title = "Above value";
	 value => <-.param.max;
      };
//        UItoggle UIresetminmaxToggle {
//  	 x = 2;
//  	 y => <-.UImaxSlider.y + <-.UImaxSlider.height +4;
//  	 parent => <-.parent;
//  	 width => .parent.clientWidth -4;
//  	 label = "Reset Min/Max";
//  	 set => <-.param.reset_minmax;
//        };
   };

   PST.MACS.pMacro p_clamp {
      ilink in_field;
      ClampParam+OPort param {
	 comp = 0;
	 below = 1;
	 above = 0;
	 min+nres => cache(<-.in_field.node_data[.comp].min);
	 max+nres => cache(<-.in_field.node_data[.comp].max);
	 reset_minmax = 0;
      };
      pClampUI pClampUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pClamp pClamp {
	 in => <-.in_field;
	 in_tags => <-.in_tags;
	 param => <-.param;
	 schema => <-.schema;
	 prev_schema => <-.in_schema;
      };
      PST.MODS.combine_mesh_data_tags out_combine_mesh_data_tags {
	 trigger => <-.pClamp.done;
         mesh_tags => <-.in_tags;
         in_mesh => <-.in_field;
         nd_tags => <-.pClamp.out_tags;
         in_nd => <-.pClamp.out;
         schema => <-.schema;
      };
//        DV.DVset_minmax DVset_minmax {
//  	 in => <-.out_combine_mesh_data_tags.out;
//  	 comp = 0;
//    	 min+nres => switch(<-.param.reset_minmax*<-.param.below+1,
//  	 <-.in_field.node_data[<-.param.comp].min, <-.param.min);
//  	 max+nres => switch(<-.param.reset_minmax*<-.param.above+1,
//  	 <-.in_field.node_data[<-.param.comp].max, <-.param.max);
//        };
//        PST.MODS.touch_tags touch_tags {
//  	 tags => <-.out_combine_mesh_data_tags.out_tags;
//  	 trigger => is_valid(<-.DVset_minmax.out);
//        };
      out_tags => .out_combine_mesh_data_tags.out_tags;
      thru_tags => .pClamp.thru_tags;
      olink out_field => .out_combine_mesh_data_tags.out;
   };
};
