// PST
// p_downsize_struct.v
// James S Perrin (MVC)
// Time-stamp: <Monday 05/07/04 17:44:46 james>

flibrary Downsize_Struct {
   group DownsizeStructParam {
      int+Port2 factorX;
      int+Port2 factorY;
      int+Port2 factorZ;
   };

   PST.MODS.pModule pDownsizeStruct<use_src_file=0> {
      DownsizeStructParam+IPort2 &param;
      int factorX => .param.factorX;
      int factorY => .param.factorY;
      int factorZ => .param.factorZ;
      Mesh_Struct+Node_Data+IPort2 &in;
      Mesh_Struct+Node_Data+OPort2 out;      
      cxxmethod+req downsize (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // downsize params
	 in+read+req+notify,
	 factorX+read+req+notify,
	 factorY+read+req+notify,
	 factorZ+read+req+notify,
	 out+write
      );      
   };

   PST.UI.pMacroUI pDownsizeStructUI {
      DownsizeStructParam+IPort2 &param;
      Mesh_Struct+Node_Data+IPort2 &in;
      UIslider UIfactorXSlider {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 1;
	 max = 8;
	 mode = "integer";
	 title = "X Downsize factor";
	 value => <-.param.factorX;
      };
      UIslider UIfactorYSlider {
	 x = 2;
	 y => <-.UIfactorXSlider.y + <-.UIfactorXSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 1;
	 max = 8;
	 mode = "integer";
	 title = "Y Downsize factor";
	 value => <-.param.factorY;
      };
      UIslider UIfactorZSlider {
	 x = 2;
	 y => <-.UIfactorYSlider.y + <-.UIfactorYSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 1;
	 max = 8;
	 mode = "integer";
	 title = "Z Downsize factor";
	 value => <-.param.factorZ;
      };
   };

   PST.MACS.pMacro p_downsize_struct {
      ilink in_field;
      DownsizeStructParam+OPort param {
	 factorX = 4;
	 factorY = 4;
	 factorZ = 4;	 
      };
      pDownsizeStructUI pDownsizeStructUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pDownsizeStruct pDownsizeStruct {
	 in => <-.in_field;
	 in_tags => <-.in_tags;
	 param => <-.param;
	 schema => <-.schema;
	 prev_schema => <-.in_schema;
      };
      
      out_tags => .pDownsizeStruct.out_tags;
      thru_tags => .pDownsizeStruct.thru_tags;
      olink out_field => .pDownsizeStruct.out;
   };
};
