// PST
// p_magnitude.v
// James S Perrin (MVC)
// Time-stamp: <Thursday 08/07/04 11:22:18 james>

flibrary Magnitude {
   group MagnitudeParam {
      int comp;
   };

   PST.MODS.pModule pMagnitude<use_src_file=0> {
      MagnitudeParam+IPort2 &param;
      int comp => .param.comp;
      Node_Data+IPort2 &in;
      Node_Data+OPort2 out;      
      cxxmethod+req magnitude (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // magnitude params
	 in+read+req+notify,
	 comp+read+req+notify,
	 out+write
      );
   };
   
   PST.UI.pMacroUI pMagnitudeUI {
      MagnitudeParam+IPort2 &param;
      Node_Data+IPort2 &in;
      DVnode_data_labels DVnode_data_labels {
	 in => <-.in;
      };
      UIradioBoxLabel UIcompRadioBox {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 title = "Data component";
	 labels => <-.DVnode_data_labels.labels;
	 selectedItem => <-.param.comp;
      };
   };

   PST.MACS.pMacro p_magnitude {
      ilink in_field;
      MagnitudeParam+OPort param {
	 comp = 0;
      };
      pMagnitudeUI pMagnitudeUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pMagnitude pMagnitude {
	 in => <-.in_field;
	 param => <-.param;
	 schema => <-.schema;
	 in_tags => <-.in_tags;
	 prev_schema => <-.in_schema;
      };
      PST.MODS.combine_mesh_data_tags out_combine_mesh_data_tags {
	 trigger => <-.pMagnitude.done;
         mesh_tags => <-.in_tags;
         in_mesh => <-.in_field;
         nd_tags => <-.pMagnitude.out_tags;
         in_nd => <-.pMagnitude.out;
         schema => <-.schema;
      };
      out_tags => .out_combine_mesh_data_tags.out_tags;
      thru_tags => .pMagnitude.thru_tags;
      olink out_field => .out_combine_mesh_data_tags.out;
   };
};
