// PST
// p_threshold.v
// James S Perrin (MVC)
// Time-stamp: <Thursday 08/07/04 16:48:35 james>

flibrary Threshold {
   group ThresholdParam {
      int+Port2 comp;
      int+Port2 below;
      int+Port2 above;
      double+Port2 min;
      double+Port2 max;
      double+Port2 null;
      int+Port2 reset_minmax;
   };

   PST.MODS.pModule pThreshold<use_src_file=0> {
      ThresholdParam+IPort2 &param;
      int comp => .param.comp;
      int below => .param.below;
      int above => .param.above;
      double min => .param.min;
      double max => .param.max;
      double null => .param.null;
      Node_Data+IPort2 &in;
      Node_Data+OPort2 out;      
      cxxmethod+req threshold (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // threshold params
	 in+read+req+notify,
	 comp+read+req+notify,
	 below+read+req+notify,
	 above+read+req+notify,
	 min+read+req+notify,
	 max+read+req+notify,
	 null+read+req+notify,
	 out+write
      );      
   };

   PST.UI.pMacroUI pThresholdUI {
      ThresholdParam+IPort2 &param;
      Node_Data+IPort2 &in;
      DVnode_data_labels DVnode_data_labels {
	 in => <-.in;
      };
      UIradioBoxLabel UIcompRadioBox {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 title = "Data component";
	 labels => <-.DVnode_data_labels.labels;
	 selectedItem => <-.param.comp;
      };
      UItoggle UIbelowToggle {
	 x = 2;
	 y => <-.UIcompRadioBox.y + <-.UIcompRadioBox.height +4;
	 parent => <-.parent;
	 width => parent.clientWidth -4;
	 label = "Threshold below";
	 set => <-.param.below;
      };
      UIslider UIminSlider {
	 x = 2;
	 y => <-.UIbelowToggle.y + <-.UIbelowToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 mode = "real";
	 title = "Below value";
	 min+nres => cache(<-.in.node_data[<-.param.comp].min);
	 max+nres => cache(<-.in.node_data[<-.param.comp].max);
	 value => <-.param.min;
      };
      UItoggle UIaboveToggle {
	 x = 2;
	 y => <-.UIminSlider.y + <-.UIminSlider.height +4;
	 parent => <-.parent;
	 width => parent.clientWidth -4;
	 label = "Threshold above";
	 set => <-.param.above;
      };
      UIslider UImaxSlider {
	 x = 2;
	 y => <-.UIaboveToggle.y + <-.UIaboveToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 mode = "real";
	 title = "Above value";
	 min+nres => cache(<-.in.node_data[<-.param.comp].min);
	 max+nres => cache(<-.in.node_data[<-.param.comp].max);
	 value => <-.param.max;
      };
      UIlabel UInullLabel {
	 x = 2;
	 y => <-.UImaxSlider.y + <-.UImaxSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth/2 -4;
	 label = "Null value";
      };
      UIfield UInullField {
	 x => .parent.clientWidth/2 +2;
	 y => <-.UInullLabel.y;
	 parent => <-.parent;
	 width => .parent.clientWidth/2 -4;
	 nullString = "";
	 value => <-.param.null;
      };
   };

   PST.MACS.pMacro p_threshold {
      ilink in_field;
      ThresholdParam+OPort param {
	 comp = 0;
	 below = 1;
	 above = 0;
	 min+nres => cache(<-.in_field.node_data[.comp].min);
	 max+nres => cache(<-.in_field.node_data[.comp].max);
	 null = 0;
	 reset_minmax = 0;
      };
      pThresholdUI pThresholdUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pThreshold pThreshold {
	 in => <-.in_field;
	 in_tags => <-.in_tags;
	 param => <-.param;
	 schema => <-.schema;
	 prev_schema => <-.in_schema;
      };
      PST.MODS.combine_mesh_data_tags out_combine_mesh_data_tags {
	 trigger => <-.pThreshold.done;
         mesh_tags => <-.in_tags;
         in_mesh => <-.in_field;
         nd_tags => <-.pThreshold.out_tags;
         in_nd => <-.pThreshold.out;
         schema => <-.schema;
      };
      out_tags => .out_combine_mesh_data_tags.out_tags;
      thru_tags => .pThreshold.thru_tags;
      olink out_field => .out_combine_mesh_data_tags.out;
   };
};
