// PST
// pst_data.v
// James S Perrin (MVC)
// Time-stamp: <Wednesday 11/08/04 10:42:46 james>

flibrary DATA {
   // **** pType ****
   // pretty colours
   atts pType<NEnumColors=3,NEcolor0=0x0000ff,NEcolor1=0x0000ff,NEcolor2=0x0000ff>;
   
   // **** pTags ****
   // information about a pData object what, where, when and how!
   // this represents all the pTags concerned with a piece of data
   // an individual pTag (c struct) is passed to nodes 
   group+pType pTags<NEcolor0=0xff00ff, export_cxx=1> {
      ptr handle;
   };
   
   // **** pSchema ****
   // information about a pModule object what, where, when and how!
   // the C++ class for pSchema has the following members:
   // int GetActionsPre(int &nActions, int *actions, int data_changed);
   // int GetActionsPost(int &nActions, int *actions);
   // int comm; - the communication group to be used by the pModule
   module+pType pSchema<use_src_file=0, NEcolor0=0x00ffff, cxx_members="
      int GetModuleActions(int &nActions, int *actions);
      int GetInputActions(int tag_master, int input_changed, int &nActions, int *actions);
      int GetSendActions(PST_comp_info &compInfo, int seq_num, int &nActions, int *actions);
      int GetRecvActions(PST_comp_info &compInfo, int &nActions, int *actions);
      int DoneModuleActions();
      int DoneInputActions();
      int DoneSendActions();
      int DoneRecvActions();
      int domainsFlushed;",
      cxx_members_constr="domainsFlushed(0)"
      > {
      // REQUESTED BEHAVIOUR
      // user configurable parameters
      int xp_in<val_state=1>; // use Express as the source of input data rather than pTag
      int xp_out_user<val_state=1>; // user requests Express output
      int npstnodes; // number of processing elements to use
      int pstnodes[];
      // resolved parameters
      int xp_out_next<val_state=1>; // next pModule requests Express output

      // ACTUAL BEHAVIOUR
      // default parameters
      int xp_out<val_state=1>; // create normal Express output ie recompose data
      int max_npstnodes; // max number of processing elements to use
      int decomp_dim; // 1D or 2D decomposition
      int domain_boundary; // overlap of data domains 

      // INTERNAL BEHAVIOUR
      int+nonotify xp_in_prev<NEvisible=0> = 0; // store old value of xp_in
      int+nonotify nPSTNodesChanged<NEvisible=0>;
      int+nonotify PSTNodesChanged<NEvisible=0>;
      // temp? when parameters change that requires a module to re-execute its
      // method this value is non-zero. This is set by the resolve_schema
      // method of pModule. Overriden if data changed
      int+nonotify action_control<NEvisible=0> = 0;
      // value to set by a module once its all the inputs are valid
      int+nonotify upandrunning<NEvisible=0> = 0;
      // MPI specific
      int+nonotify comm_module<NEvisible=0> => Templates.PST_CONFIG.MPI_COMM_NULL+0;
      int+nonotify comm_nodes<NEvisible=0> => Templates.PST_CONFIG.MPI_COMM_NULL+0;
      int+nonotify no_resolve<NEvisible=0> = 0; // disable schema resolution

      cxxmethod+req pstnodes_changed<weight=-20> (
	 npstnodes+req+notify,
	 pstnodes+req+notify,
	 nPSTNodesChanged+write,
	 PSTNodesChanged+write
      );
   };

   // **** pSchema_default ****
   // default values
   pSchema pSchema_default {
      xp_out_user = 0; 
      xp_out_next = 0;
      xp_out = 0; 
      xp_in = 1; // if a pModules is previous this gets set to zero
      npstnodes => max_npstnodes +0; // +0 causes connection break on being set
      pstnodes => init_array(npstnodes,0,npstnodes-1);
      max_npstnodes => Templates.PST_CONFIG.max_npstnodes;
      decomp_dim = 1;
      domain_boundary = 0;
   };
   
};
