// PST
// pst_macs.v
// James S Perrin & Paul G Lever (MVC)
// Time-stamp: <Friday 20/08/04 17:29:12 james>

flibrary MACS {
   library Base {
      // **** pMacroBase ****
      // base macro for all pMacro templates contains stuff they all need
      macro pMacroBase {
	 PST.DATA.pSchema_default+OPort schema;
      };
      
      // **** pMacroImport ****
      // base macro for all pModuleImports contains stuff they all need
      pMacroBase pMacroImport {
	 schema {
	    xp_out => xp_out_user;
	 };
	 olink out_schema => .schema;
	 olink out_tags;
      };

      // **** pMacroExport ****
      // base macro for all pModuleExports contains stuff they all need
      pMacroBase pMacroExport {
	 ilink in_schema;
	 ilink in_tags;
	 olink thru_tags;
      };

      // **** pMacro ****
      // base macro for all pModules contains stuff they all need
      pMacroBase pMacro {
	 ilink in_schema;
	 ilink in_tags;
	 olink out_schema => .schema;
	 olink out_tags;
	 olink thru_tags;
      };
   };

   library Utility {
      macro PST_Control {
	 PST.UI.PSTControlUI PSTControlUI;
	 PST.MODS.pst_control pst_control {
	    log => <-.PSTControlUI.profile;
	    stop => <-.PSTControlUI.stop;
	 };
      };
      
      macro Examine_Tags {
	 ilink tags;
	 PST.MODS.examine_tags examine_tags {
	    trigger => <-.ExamineTagsUI.trigger;
	    tags => <-.tags;
	 };
	 PST.UI.ExamineTagsUI ExamineTagsUI {
	    tags_info => <-.examine_tags.tags_info;
	 };
      };
	 
      macro Domain_Bounds {
	 ilink in_tags;
	 ilink in;
	 PST.MODS.domain_bounds domain_bounds {
	    in_tags => <-.in_tags;
	    in => <-.in;
	 };
	 MODS.set_xform set_xform {
	    in_field1 => <-.domain_bounds.out;
	    in_field2 => <-.in;
	    obj {
	       Obj {
		  name => name_of(<-.<-.<-.<-);
	       };
	       Props {
		  jitter = 2;
		  inherit = 0;
	       };
	    };
	 };
	 olink out => set_xform.out_obj;
      };
      
      macro p_reset_xform {
	 ilink in_tags;
	 ilink in;
	 MODS.reset_xform reset_xform {
            in_field => <-.in;
	 };
	 PST.MODS.touch_tags touch_tags {
            tags => <-.in_tags;
            trigger => is_valid(<-.reset_xform.out_field);
	 };
	 olink out_tags => .touch_tags.tags;
	 olink out => reset_xform.out_fld;
      };

      /* reset the minmax of in node_data to in2 node_data */
      /* this macro makes the changes "in place" */
      macro p_reset_minmax {
	 ilink in_tags;
	 Node_Data &in<NEportLevels={2,1}>;
	 Node_Data &in2<NEportLevels={2,1}>;
	 int comp = 0;
	 int comp2 = 0;
	 macro UI {
	    UImod_panel parent {
	       title => name_of(<-.<-.<-);
	    };
	    DVnode_data_labels DVnode_data_labels {
	       in => <-.<-.in;
	    };
	    UIradioBoxLabel UIcompRadioBox {
	       x = 2;
	       y = 4;
	       parent => <-.parent;
	       width => .parent.clientWidth -4;
	       title = "Data component whose min/max to reset";
	       labels => <-.DVnode_data_labels.labels;
	       selectedItem => <-.<-.comp;
	    };
	    DVnode_data_labels DVnode_data_labels2 {
	       in => <-.<-.in2;
	    };
	    UIradioBoxLabel UIcompRadioBox2 {
	       x = 2;
	       y => <-.UIcompRadioBox.y + <-.UIcompRadioBox.height+4;
	       parent => <-.parent;
	       width => .parent.clientWidth -4;
	       title = "Data component whose min/max to use";
	       labels => <-.DVnode_data_labels2.labels;
	       selectedItem => <-.<-.comp2;
	    };
	 };
	 GMOD.copy_on_change set_min {
	    trigger => <-.in.node_data[comp].min;
	    input+nres => <-.in2.node_data[comp2].min;
	    output+nres => <-.in.node_data[comp].min;
	 };
	 GMOD.copy_on_change set_max {
	    trigger => <-.in.node_data[comp].max;
	    input+nres => <-.in2.node_data[comp2].max;
	    output+nres => <-.in.node_data[comp].max;
	 };
	 PST.MODS.touch_tags_minmax touch_tags_minmax {
            tags => <-.in_tags;
	    trigger => 1;
	    comp = <-.comp;
	    comp_type = 2;
	    min => <-.set_min.output;
	    max => <-.set_max.output;
	 };
	 olink out_tags => .touch_tags_minmax.tags;
	 olink out => .in;
      };

      macro p_set_minmax {
	 ilink in_tags;
	 Node_Data &in<NEportLevels={2,1}>;
	 int comp = 0;
	 double+nres min => cache(.in.node_data[comp].min);
	 double+nres max => cache(.in.node_data[comp].max);
	 macro UI {
	    UImod_panel parent {
	       title => name_of(<-.<-.<-);
	    };
	    DVnode_data_labels DVnode_data_labels {
	       in => <-.<-.in;
	    };
	    UIradioBoxLabel UIcompRadioBox {
	       x = 2;
	       y = 4;
	       parent => <-.parent;
	       width => .parent.clientWidth -4;
	       title = "Data component to set";
	       labels => <-.DVnode_data_labels.labels;
	       selectedItem => <-.<-.comp;
	    };
	    UIlabel UIminLabel {
	       x = 2;
	       y => <-.UIcompRadioBox.y + <-.UIcompRadioBox.height +4;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "Min value";
	    };
	    UIfield UIUIminField {
	       x => .parent.clientWidth/2 +2;
	       y => <-.UIminLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       value => <-.<-.min;
	    };
	    UIlabel UImaxLabel {
	       x = 2;
	       y => <-.UIUIminField.y + <-.UIUIminField.height +4;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "Max value";
	    };
	    UIfield UIUImaxField {
	       x => .parent.clientWidth/2 +2;
	       y => <-.UImaxLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       value => <-.<-.max;
	    };
	 };
	 GMOD.copy_on_change set_min {
	    trigger => <-.in.node_data[comp].min;
	    input => <-.min;
	    output+nres => <-.in.node_data[comp].min;
	    on_inst = 0;
	 };
	 GMOD.copy_on_change set_max {
	    trigger => <-.in.node_data[comp].max;
	    input => <-.max;
	    output+nres => <-.in.node_data[comp].ax;
	    on_inst = 0;
	 };
	 PST.MODS.touch_tags_minmax touch_tags_minmax {
            tags => <-.in_tags;
	    trigger => 1;
	    comp = <-.comp;
	    comp_type = 2;
	    min => <-.set_min.output;
	    max => <-.set_max.output;
	 };
	 olink out_tags => .touch_tags_minmax.tags;
	 olink out => .in;
      };
      
      macro p_set_null {
	 ilink in_tags;
	 Node_Data &in<NEportLevels={2,1}>;
	 int comp = 0;
	 int+nres null_flag => cache(.in.node_data[comp].null_flag);
	 double+nres null_value => cache(.in.node_data[comp].null_value);
	 macro UI {
	    UImod_panel parent {
	       title => name_of(<-.<-.<-);
	    };
	    DVnode_data_labels DVnode_data_labels {
	       in => <-.<-.in;
	    };
	    UIradioBoxLabel UIcompRadioBox {
	       x = 2;
	       y = 4;
	       parent => <-.parent;
	       width => .parent.clientWidth -4;
	       title = "Data component to set";
	       labels => <-.DVnode_data_labels.labels;
	       selectedItem => <-.<-.comp;
	    };
	    UItoggle UInullFlagToggle {
	       x = 2;
	       y => <-.UIcompRadioBox.y + <-.UIcompRadioBox.height +4;
	       parent => <-.parent;
	       width => .parent.clientWidth -4;
	       label = "Null flag set";
	       set => <-.<-.null_flag;
	    };
	    UIlabel UInullValueLabel {
	       x = 2;
	       y => <-.UInullFlagToggle.y + <-.UInullFlagToggle.height +4;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "Null value";
	    };
	    UIfield UIUInullValueField {
	       x => .parent.clientWidth/2 +2;
	       y => <-.UInullValueLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       value => <-.<-.null_value;
	    };
	 };
	 GMOD.copy_on_change set_null_flag {
	    trigger => <-.in.node_data[comp].null_flag;
	    input => <-.null_flag;
	    output+nres => <-.in.node_data[comp].null_flag;
	    on_inst = 0;
	 };
	 GMOD.copy_on_change set_null_value {
	    trigger => <-.in.node_data[comp].null_value;
	    input => <-.null_value;
	    output+nres => <-.in.node_data[comp].null_value;
	    on_inst = 0;
	 };
	 PST.MODS.touch_tags_null touch_tags_null {
            tags => <-.in_tags;
	    comp => <-.comp;
	    comp_type = 2;
	    trigger = 1;
	    null_flag => <-.set_null_flag.output;
	    null_value => <-.set_null_value.output;
	 };
	 olink out_tags => .touch_tags_null.tags;
	 olink out => .in;
 
      };
   };

};
