// PST
// pst_mods.v
// James S Perrin (MVC)
// Time-stamp: <Friday 20/08/04 16:15:09 james>

flibrary MODS {
   library Base<cxx_name=""> {
      // **** pModuleBase ****
      // base module for all PST parallel module Templates
      // NOT to be used itself
      module pModuleBase<use_src_file=0,
	 cxx_members="
	 PST_pTag *sendTags, *recvTags;
	 PST_pDomain *sendDomains, *recvDomains;
	 MPI_Datatype pTag_mpi, pDomain_mpi, pError_mpi;
	 int npstnodes;
	 int *pstnodes;
	 int prev_npstnodes;
	 int *prev_pstnodes;
	 int ncomps_in;
	 int ncomps_out;
	 int no_flush;
	 int error_flag;
	 int error_node;
	 long long moduleid;
	 PST_comp_pTags_set_link *thru_tags_list;
	 static PST_comp_info PST_comp_info_null;
	 // **** p_module_base.cxx *****
	 virtual int CheckIfValidInput(OMobj_id in_id, PST_DATA_pTags &_in_tags, int valid_input, int ignore_npstnodes=0);
	 int CheckIfInputChanged(OMobj_id in_id, PST_DATA_pTags &_thru_tags, int ncomps_in);
	 int CheckIfTagsController(OMobj_id in_id, PST_DATA_pTags &_in_tags);
	 int CheckIfTagsReady(OMobj_id in_id, PST_DATA_pTags &_in_tags, int comp_type_mask);
	 int CheckIfUseInputOrTags(PST_DATA_pTags &_in_tags, PST_comp_info &compInfo);
	 int RetNComps(OMobj_id in_id);
	 int GetCoordsComp(OMobj_id in_id, int *comp);
	 int GetNodeDataComp(OMobj_id in_id, int nd_comp, int *comp);
	 int GetCellSetComp(OMobj_id in_id, int cs_comp, int *comp);
	 int GetCellDataComp(OMobj_id in_id, int cs_comp, int cd_comp, int *comp);
	 int GetInputDims(OMobj_id in_id, int *ndims, xp_long *dims);
	 int GetCompDistributed(PST_DATA_pTags &_tags, int comp_in, int *distributed);
	 int GetCompDistributed(PST_DATA_pTags &_in_tags, PST_DATA_pTags &_thru_tags, int comp_in, PST_comp_info &compInfo);
	 int GetDecomposition(int ndims, xp_long *dims, xp_long **st, xp_long **en);
	 int ProcessModuleActions();
	 int ProcessInputActions(OMobj_id in_id, PST_DATA_pTags &_in_tags, PST_DATA_pTags &_thru_tags, int tag_master, int comp_type_mask);
	 int ActionChangeCommCustom(int cust_npstnodes, int *cust_pstnodes);
	 int ActionChangeComm();
	 int ActionFlushDomainCache(PST_DATA_pTags &_thru_tags, PST_comp_info &compInfo=PST_comp_info_null);
	 int ActionReinitModule();
	 int ActionReinitThruTags(PST_DATA_pTags &_thru_tags, PST_DATA_pTags &_in_tags, OMobj_id in_id, int ncomps_in);
	 int ActionNotifyThruTags(PST_DATA_pTags &_thru_tags);
	 int ActionUpdateThruTags(PST_DATA_pTags &_thru_tags, int comp_in, PST_comp_info &compInfo);
	 int CheckNodesForErrors();
	 int Finish();
	 ~PST_MODS_pModuleBase();
	 // **** p_module_base_send.cxx ****
	 int SendInit();
	 int ActionCreateSendTagsFromInput(PST_comp_info &compInfo,
	                                   int veclen, int type, int ndims, xp_long *dims, double min, double max,
                                           int null_flag, double null_value,
	                                   xp_long *st, xp_long *en, OMobj_id in_id, OMobj_id out_id);
	 int ActionCreateSendTagsFromInTags(PST_DATA_pTags &_in_tags, int comp_in, PST_comp_info &compInfo, OMobj_id out_id);
	 int ActionCreateDomains(PST_comp_info &compInfo, unsigned char *data);
	 int ActionSendTags();
	 int ActionSendDomains();
	 int RunCEMethod(int ce_method, int nblocks, int *nelems, int *types, char **blocks);
	 // **** p_module_base_recv.cxx ****
	 int RecvInit();
	 int OutTagsInit(PST_DATA_pTags &_out_tags, OMobj_id out_id, int ncomps_out);
	 int ActionRecvTags();
	 int ActionCreateOutTags(PST_DATA_pTags &_out_tags, int comp_out);
	 int ActionRecvRecompData(unsigned char *data);
	 int ActionRequestData(PST_DATA_pTags &_out_tags, OMobj_id out_id, int comp_out, unsigned char *data);
	 int GetCompSizes(int *nnodes, int *veclen);
	 int GetCompDims(int *ndims, xp_long *dims);
	 int GetCompType(int *type);
	 int GetCompMinMax(double *min, double *max);
	 int GetCompNullParams(int *null_flag, double *null_value);
	 "
	 > {
	 PST.DATA.pSchema+IPort2 &schema;
	 int+OPort2+write done; // trigger for use mainly by filters
	 cxxmethod+notify_inst Inst<weight=-30>;
      };

      // **** pModule ****
      // The template module for all PST parallel filter, mapper etc modules
      // i.e.  any module that have an input and an output
      pModuleBase pModule<use_src_file=0, cxx_members="
	 ~PST_MODS_pModule();
	 int CheckIfValidInput(OMobj_id in_id, PST_DATA_pTags &_in_tags, int valid_input, int ignore_npstnodes=0);
	 "> {
	 PST.DATA.pTags+IPort2 &in_tags;
	 PST.DATA.pSchema+IPort2 &prev_schema {
	    xp_in+nonotify;
	    xp_out+nonotify;
	    xp_out_user+nonotify;
	    xp_out+nonotify;
	 };
	 PST.DATA.pTags+OPort2 out_tags;
	 PST.DATA.pTags+OPort2 thru_tags {
	    int+opt is_thru_tag = 1;
	 };
	 // **** resolve schema ****
	 // use this_schema and compare with prev_schema
	 // update prev_schema say if recompostion is required to meet this_schema
	 // requirements. Or update this_schema if prev_exceeds min requirements
	 // This methods needs to run before any other so that schema are resolved
	 // before being used
	 cxxmethod+req+notify_inst resolve_schema<weight=-10> (
	    schema+req+read+notify,
	    prev_schema+read+notify,
	    in_tags.is_thru_tag+read+notify
	 );
      };
      
      // **** pModuleImport ****
      // The template module for all PST parallel modules that import data
      // i.e.  any module that have only have an output so could be used for
      // readers and simulation computations
      pModuleBase pModuleImport<export_cxx=1, use_src_file=0, cxx_members="~PST_MODS_pModuleImport();\n"> {
	 PST.DATA.pTags+OPort2 out_tags;
      };

      // **** pModuleExport ****
      // The template module for all PST parallel modules that import data
      // i.e.  any module that have only have an input so could be used for
      // writers
      pModuleBase pModuleExport<use_src_file=0, cxx_members="
	 ~PST_MODS_pModuleExport();
	 int CheckIfValidInput(OMobj_id in_id, PST_DATA_pTags &_in_tags, int valid_input, int ignore_npstnodes=0);
	 "> {
	 PST.DATA.pTags+IPort2 &in_tags;
	 PST.DATA.pSchema+IPort2 &prev_schema {
	    xp_in+nonotify;
	    xp_out+nonotify;
	    xp_out_user+nonotify;
	    xp_out+nonotify;
	 };
	 PST.DATA.pTags+OPort2 thru_tags {
	    int+opt is_thru_tag = 1;
	 };
	 // **** resolve schema ****
	 // use this_schema and compare with prev_schema
	 // update prev_schema say if recompostion is required to meet this_schema
	 // requirements. Or update this_schema if prev_exceeds min requirements
	 // This methods needs to run before any other so that schema are resolved
	 // before being used
	 cxxmethod+req+notify_inst resolve_schema<weight=-10> (
	    schema+req+read+notify,
	    prev_schema+read+notify,
	    in_tags.is_thru_tag+read+notify
	 );
      };

      // **** combine_mesh_data_tags ****
      // replacement for combine_mesh_node_data, combines tags as well as mesh & node_data
      // but will recompose mesh &/| node_data if required by the schema
      pModuleBase combine_mesh_data_tags<use_src_file=0> {
	 int+IPort2 trigger;
	 PST.DATA.pTags+IPort2 &mesh_tags;
	 Mesh+IPort2 &in_mesh;
	 PST.DATA.pTags+IPort2 &nd_tags;
	 Node_Data+IPort2 &in_nd;
	 PST.DATA.pTags+OPort2 out_tags;
	 Mesh+Node_Data+OPort2 &out => merge(in_nd, in_mesh, "GDdraw_polyh", "GDpick_polyh"); 
	 int+OPort2 done;
	 int mode; // for exapansion
	 // update MUST run after a filter so that the filter will
	 // catched the xp_out for ITS output data
	 cxxmethod+req update<weight=1> (
	    trigger+req+notify,
	    schema.xp_out+req+read+write,
	    in_mesh+req+read+write,
	    mesh_tags+read+write,
	    in_nd+req+read+write,
	    nd_tags+read+write,
	    mode+read+notify,
	    out+write,
	    out_tags+write,
	    done+write
	 );
      };

      // **** touch_tags ****      
      // update seq_num on tags, required as tags must have seq_num >=
      // that of the associated field to be considered valid. Modules
      // such as set_null which only change meta data modify the
      // seq_num however making the tags invalid
      module touch_tags<use_src_file=0> {
	 PST.DATA.pTags+Port2 &tags;
	 int+IPort2 trigger;
	 int+OPort2 done;
	 cxxmethod+req update<weight=1> (
	    tags+req+read+write,
	    trigger+req+notify,
	    done+write
	 );
      };
      
      // **** touch_tags_null ****
      // same as touch_tags but also update a comps null info
      module touch_tags_minmax<use_src_file=0> {
	 PST.DATA.pTags+Port2 &tags;
	 int+IPort2 trigger;
	 int+IPort2 comp_type; // coords, node_data or cell_data
	 int+IPort2 comp;
	 double+IPort2 min;
	 double+IPort2 max;
	 int+OPort2 done;
	 cxxmethod+req update<weight=1> (
	    tags+req+read+write,
	    trigger+req+notify,
	    comp_type+req+read+notify,
	    comp+req+read+notify,
	    min+req+read+notify,
	    max+req+read+notify,
	    done+write
	 );
      };
      
      // **** touch_tags_minmax ****      
      // same as touch_tags but also update a comps minmax info
      module touch_tags_null<use_src_file=0> {
	 PST.DATA.pTags+Port2 &tags;
	 int+IPort2 trigger;
	 int+IPort2 comp_type; // coords, node_data or cell_data
	 int+IPort2 comp;
	 int+IPort2 null_flag;
	 double+IPort2 null_value;
	 int+OPort2 done;
	 cxxmethod+req update<weight=1> (
	    tags+req+read+write,
	    comp_type+req+read+notify,
	    comp+req+read+notify,
	    null_flag+req+read+notify,
	    null_value+req+read+notify,
	    trigger+req+notify,
	    done+write
	 );
      };

   };
   
   library Utility<cxx_name=""> {

      module pst_control<use_src_file=0> {
	 int+IPort2 stop;
	 int+IPort2 log;
	 cxxmethod+req stoppst (
	    stop+read+req+notify
	 );
	 cxxmethod+req+notify_inst logmode (
	    log+read+req+notify
	 ); 
      };   

      module domain_bounds<use_src_file=0> {
	 PST.DATA.pTags+IPort2 &in_tags;
	 Mesh_Struct+Node_Data+IPort2 &in;
	 int+IPort2 taggedAs1D = 0; // soon unnecessary
	 Mesh+Node_Data+OPort2 out;
	 cxxmethod+req update (
	    in_tags+req+read+notify,
	    in+req+read+notify,
	    taggedAs1D+read+notify,
	    out+write
	 );
      };
      
      module get_colour_from_dmap<use_src_file=0> {
	 DMAP.DatamapTempl+IPort2 &dmap<export_cxx=1>;
	 prim+IPort2 value;
	 float+OPort2 a;
	 float+OPort2 r;
	 float+OPort2 g;
	 float+OPort2 b;
	 float+OPort2 colour[3] => {r,g,b};
	 cxxmethod+req update (
	    dmap+read+notify+req,
	    value+read+notify+req,
	    a+write,
	    r+write,
	    g+write,
	    b+write
	 );
      };

      module examine_tags<use_src_file=0> {
	 PST.DATA.pTags+IPort2 &tags;
	 int+IPort2 trigger<export_cxx=0>;
	 group+OPort2 tags_info {
	    string name;
	    int ncomps; // # of components
	    int ndomains; // equiv to npstnodes in associated schema
	    int decomp_dim;
	    int fieldid;
	    group comps[ncomps] {
	       int distributed; /* 0 = local, 1 = remote */
	       int composed; /* 0 = remote, 1 = local */
	       int moduleid; // the module that performed this decompostion
	       int fieldid; // the field from which it was distributed  (pass thrus can skip fields)
	       int compid; // the comp from which it was distributed
	       int comp_type; /*  0 = coords, 1 = node_data, 2 = cell_set (conn_list),see pst_defs.h */
	       int coord_type; /* 0 = struct, 1 = implicit unif, 2 = implicit rect, 3 = unstruct */
	       int ndomains => <-.ndomains;
	       int veclen;
	       int domain_boundary;
	       enum type {
		  choices = {"char","byte","short","int","float","double"};
	       };  // data type
	       int domain_st[ndomains];
	       int domain_en[ndomains];
	       int locations[ndomains]; // where the data is
	    };
	 };
	 cxxmethod+req update (
	    trigger+notify,
	    tags+req+read+notify,
	    tags_info+write
	 );
      };

   };
};
