/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ren_prt.v#1 $
*/

$include ../include/avs/gd_def.h

   /* These are the definitions of the functions that will
      be invoked to do view level device dependent processing
      for the print renderer.
   */
   group prt_view_funcs<NEvisible=1> {
      int renderer = GD_PRT_RENDERER;
      func+virtual view_available = "GDprt_view_available";
      func+virtual view_create = "GDprt_view_create";
      func+virtual view_clear = "GDprt_view_clear";
      func+virtual view_transp_pass = "GDsw_view_transp_pass";
      func+virtual view_accel = "GDsw_view_accel";
      func+virtual view_accel2d = "GDprt_view_accel2d";
      func+virtual view_image_pass = "GDprt_view_image_pass";
      func+virtual view_swap1 = "GDprt_view_swap1";
      func+virtual view_swap2 = "GDprt_view_swap2";
      func+virtual view_refresh = "GDprt_view_refresh";
      func+virtual view_delete = "GDprt_view_delete";
      func+virtual view_resize = "GDprt_view_resize";
      func+virtual view_get_buffers = "GDsw_view_get_buffers";
      func+virtual view_set_video_mode = "GDsw_view_set_video_mode";
      func+virtual view_set_left_eye = "GDsw_view_set_left_eye";
      func+virtual view_set_right_eye = "GDsw_view_set_right_eye";
      func+virtual view_get_image = "GDsw_view_get_image";
      func+virtual view_put_image = "GDsw_view_put_image";
   };

   /* These are the definitions of the functions that will
      be invoked to do the state level device dependent
      processing by the print renderer.
   */
   group prt_state_funcs<NEvisible=1> {
      int renderer = GD_PRT_RENDERER;
      func+virtual state_create = "GDsw_state_create";
      func+virtual state_delete = "GDsw_state_delete";
      func+virtual state_init = "GDsw_state_init";
      func+virtual state_concat_obj_matrix = "GDstate_concat_obj_matrix";
      func+virtual state_set_backface_cull = "GDstate_set_backface_cull";
      func+virtual state_set_backface_cull = "GDstate_set_backface_cull";
      func+virtual state_set_vox_interp = "GDstate_set_vox_interp";
      func+virtual state_set_ray_algo = "GDstate_set_ray_algo";
      func+virtual state_set_ray_norm = "GDstate_set_ray_norm";
      func+virtual state_set_blend_mode = "GDstate_set_blend_mode";
      func+virtual state_set_fat_ray = "GDstate_set_fat_ray";
      func+virtual state_set_camera_attrs = "GDsw_set_camera_attrs";
      func+virtual state_set_color = "GDstate_set_color";
      func+virtual state_set_highlight_colors = "GDstate_set_highlight_colors";
      func+virtual state_set_draw_mode = "GDstate_set_draw_mode";
      func+virtual state_set_font = "GDstate_set_font";
      func+virtual state_set_line_width = "GDstate_set_line_width";
      func+virtual state_set_line_style = "GDstate_set_line_style";
      func+virtual state_set_dir_pt_size = "GDstate_set_dir_pt_size";
      func+virtual state_set_jitter = "GDstate_set_jitter";
      func+virtual state_set_cmap = "GDstate_set_cmap";
      func+virtual state_set_depth_cue = "GDstate_set_depth_cue";
      func+virtual state_set_lights = "GDsw_set_lights";
      func+virtual state_set_material = "GDstate_set_material";
      func+virtual state_set_mode = "GDstate_set_mode";
      func+virtual state_set_mode_normals = "GDstate_set_mode_normals";
      func+virtual state_set_mode_outline = "GDstate_set_mode_outline";
      func+virtual state_set_obj_matrix = "GDstate_set_obj_matrix";
      func+virtual state_set_specular_color = "GDstate_set_specular_color";
      func+virtual state_set_texture = "GDstate_set_texture";
      func+virtual state_set_transparency = "GDstate_set_transparency";
      func+virtual state_update_matrix = "GDstate_update_matrix";
      func+virtual state_set_drawable = "GDstate_set_drawable";
      func+virtual state_set_viewport = "GDstate_set_viewport";
      func+virtual state_set_stereo_attrs = "GDstate_set_stereo_attrs";
   };

   /* These are the definitions of the functions that will
      be invoked to do primitive level device dependent processing
      for the print renderer.
   */
   group prt_prim_funcs<NEvisible=1> {
      int renderer = GD_PRT_RENDERER;
      func+virtual prim_3d_points = "GDsw_points";
      func+virtual prim_3d_lines = "GDsw_lines";
      func+virtual prim_3d_polyline = "GDsw_polyline";
      func+virtual prim_3d_polytri = "GDsw_polytri";
      func+virtual prim_3d_spheres = "GDsw_spheres";
#ifdef VX_KIT
      func+virtual prim_3d_volume = "GDsw_volume";
#endif
      func+virtual prim_3d_text = "GDprt_text";

      func+virtual prim_2d_points = "GDprt_2d_points";
      func+virtual prim_2d_lines = "GDprt_2d_lines";
      func+virtual prim_2d_polyline = "GDprt_2d_polyline";
      func+virtual prim_2d_polytri = "GDprt_2d_polytri";
      func+virtual prim_2d_polygons = "GDprt_2d_polygons";
      func+virtual prim_2d_image = "GDprt_image";
      func+virtual prim_2d_image_tiled = "GDprt_image_tiled";
      func+virtual prim_2d_text = "GDprt_2d_text";
   };

   /* These are the definitions of the functions that will
      be invoked to do device dependent geom data manipulation
      for the print renderer.
   */
   group prt_geom_funcs<NEvisible=1> {
      int renderer = GD_PRT_RENDERER;
      func+virtual geom_init = "GDsw_geom_init";
      func+virtual geom_build = "GDsw_geom_build";
      func+virtual geom_free = "GDsw_geom_free";
   };

