/*
			Copyright (c) 2004 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/segm_edtr.v#1 $
*/

flibrary SEGM_EDTR
<
  build_dir   = "segm_edtr",
  build_cmd   = "$(MAKE)",
  cxx_hdr_files = "fld/Xfld.h avs/gd.h drawmask.h seggrow.h",
  cxx_name     = "SegmentationEditor",
  libdeps      = "GD DV FLD",
  link_files   = "-lsegm",
  out_src_file = "seg_gen.cxx",
  out_hdr_file = "seg_gen.h",
  use_src_file = 0,
  needs_edit_lic = "GD", needs_use_lic  = "DV"
>
{

library+buffered Modules
{
    enum DrawMaskCommands {
        choices => {
            "Draw Point",
            "Draw Line",
            "Close Line",
            "Fill Area",
            "New Area",
            "Invert Mask",
            "Clear Mask",
            "Grow Region 2D",
            "Grow Region 3D",
            "Threshold",
            "Save 3D Mask",            
            "Load 3D Mask",
            "Clear 3D Mask"
        };
    };

    enum DrawMaskPens {
        choices => {
            "Draw",
            "Erase"
        };
    };

    enum ApplyMaskCommands {
        choices => {
            "Add Mask",
            "Apply Mask"
        };
    };

    enum ApplyRegionCommands {
        choices => {
            "Add to Mask",
            "Replace Mask"
        };
    };

    group+OPort SegmentationEditorParams {
        int+Port axis;
        int+Port slice;
        long+Port dims[];
        int+Port clear_volume;
        int+Port clear_mask3D;
        int+Port edit_entity;
        int+Port reg_incr;
        double+Port reg_delta;
        int+Port reg_trig;
        double+Port thr_min;
        double+Port thr_max;
        int+Port thr_trig;
        int+Port thr_comp;
        string+Port label;
        string+Port filename;
        string+Port entities[];
        string+Port readentities[];
        int+Port selentities[];
        int+Port outentities[];
        int+Port edit_selentities[];
        int+Port combine_entity;
        int+Port delete_entity;
        int+Port allow_read;
        int+Port start_read;
        int+Port start_write;
        DrawMaskCommands+Port drawcommand;
        DrawMaskPens+Port pen;
        ApplyMaskCommands+Port applycommand;
        ApplyRegionCommands+Port applyregcommand;
        int+Port width;
        int+Port value;
        int+Port value_nd;
    };

    module DrawMask <
        cxx_members="    private:\n        int setup_environment(DrawMaskStruct * dmstr);\n        int init_environment(int command);\n">
    {
        DrawMaskCommands+IPort2 command = "Draw Point";
        DrawMaskPens+IPort2 pen = "Draw";
        ApplyRegionCommands+Port regcmd;

        int+IPort2 width = 0;

        int slice;
        int axis;
        int x;
        int y;
        double thr_min;
        double thr_max;
        int thr_trig;
        int thr_comp;
        double reg_delta;
        double reg_incr;
        int reg_trig;
        int state;
        int+IPort2 value;

        // The export properties are simply to reduce the
        // amount of generated C++ code.
        GDobject_templ+IPort2 &obj<export=0>;
        GDview_templ+IPort2 &view<export=0>;

        GDcamera_templ &camera<export=0> => .view.picked_camera;
        ptr    local_ptr<NEvisible=0>;

        Mesh_Unif+Node_Data+Port2 &mask;
        Node_Data+IPort2 &in_slice;

        cxxmethod+notify_inst OnInstance (
            .local_ptr+write
        );

        cxxmethod+notify_deinst OnDeinstance (
            .local_ptr+read+write
        );

        cxxmethod+req OnDraw (
            .x+read,
            .y+read,
            .thr_min+read,
            .thr_max+read,
            .thr_trig+read+write+notify,
            .thr_comp+read,
            .reg_trig+notify,
            .reg_delta+read+notify,
            .reg_incr+read+notify,
            .regcmd+read,
            .in_slice+read,
            .slice+read,
            .axis+read,
            .state+read+notify+req,
            .camera+read,
            .obj+read+req,
            .view+read+req,
            .value+read,
            .command+read+write+notify+req,
            .pen+read+write+notify+req,
            .seed_point+read,
            .width+read,
            .nconn+write,
            .conn+write,
            .npoints+write,
            .points+read+write,
            .local_ptr+read,
            .mask+read+write,
            .draw+write
        );

        int+OPort2 draw;
        int+OPort2 npoints;
        float+OPort2 points[npoints][2];
        int+OPort2 seed_point[3];
    };

    module GrowRegion
    {
        long+IPort2 dims[];
        Node_Data+IPort2 &in;
        int+IPort2 seed[];
        int+IPort2 combine_and_or[];
        double+IPort2 delta[];
        int+IPort2 use_diagonals;
        int+IPort2 set_null_value;
        int+IPort2 and_precedence;
        int+IPort2 invert_region;
        int+IPort2 out_val;
        string+IPort2 out_label;
        int incremental[];
        int trigger=1;

        Node_Data+OPort2 out;

        cxxmethod+notify_inst+req update (
            .trigger+read+req,
            .dims+read+req,
            .in+read+req,
            .seed+read+notify+req,
            .combine_and_or+read+notify+req,
            .delta+read+notify+req,
            .use_diagonals+read+notify+req,
            .incremental+read+notify+req,
            .out_val+read+req,
            .out_label+read+req,
            .set_null_value+read+notify+req,
            .and_precedence+read+notify+req,
            .invert_region+read+notify+req,
            .out+write
        );
    };

    module SegmentationEditorCore <
        cxx_members="    private:\n        int Mask_2D_from_3D();\n">
    {
        int+IPort2 axis;
        int+IPort2 slice;
        int+IPort2 value;
        int+IPort2 use_value;
        int+IPort2 draw;
        int+IPort2 clear;
        int+IPort2 clearMask;
        int+IPort2 clearMask3D;
        int+IPort2 clearEntity;
        int+IPort2 entityList[];
        int+IPort2 outEntities[];
        int+IPort2 combineEntity;
        int+OPort2 value_nd;
        double reg_delta;
        double reg_incr;
        int grow_region_3D;
        int seed[];
        string+IPort2 label;
        ApplyMaskCommands+IPort2 command = "Apply Mask";
        ApplyRegionCommands+IPort2 regcmd = "Add to Mask";

        Mesh_Unif+Node_Data+IPort2 &in_field;
        Mesh_Unif+Node_Data+Port2 &mask;
        Mesh_Unif+Node_Data+Port2 &mask3D;
        Node_Data+IPort2 & region2D;
        Node_Data+IPort2 & region3D;

        Mesh_Unif+Node_Data+Port2 &out;

        cxxmethod+notify_inst OnInstance (
            in_field+read+notify,
            clear+read+write+notify,
            clearMask+read+write+notify,
            clearMask3D+read+write+notify,
            mask+read+write,
            mask3D+read+write,
            axis+read,
            out+read+write
        );

        cxxmethod+req OnClear (
            entityList+read+write,
            clearEntity+read+write+notify,
            combineEntity+read+write+notify,
            value+read+write,
            label+write,
            value_nd+write,
            outEntities+read+write,
//            clearMask+read+write+notify,
            clearMask3D+read+write+notify,
//            mask+read+write+req,
            mask3D+read+write+req
//            out+read+write+req,
//            axis+read,
//            slice+read,
//            command+read+req
        );

        cxxmethod+req OnChange (
            in_field+read+write,
            stop+read+write,
            axis+read+notify+req,
            slice+read+notify+req,
            grow_region_3D+read,
            value+read+notify,
            value_nd+write,
            draw+read+notify,
            use_value+read+notify,
            region2D+read+notify,
            region3D+read+notify,
            mask+read+write+req,
            mask3D+read+notify+write+req,
            seed+read+notify,
            reg_delta+read+notify,
            reg_incr+read+notify,
            command+read+notify+req,
            regcmd+read+notify+req,
            label+read+write,
            out+read+write
        );
    };

}; // Modules

library+buffered Macros <compile_subs=0>
{
    // Copy of the one in FLD_MAP, but without the DataObject
    group polyline_mesh {
        float+IPort2 &coord[][];
        long+IPort2 &connect[];

        long coord_dims[] => array_dims(coord);

        int error => (array_size(coord) >0) &&
                     (array_size(coord_dims) != 2);
        GMOD.print_error print_error {
            error => <-.error;
            error_source = "polyline_mesh";
            error_message = "Invalid mesh: coordinates should be 2d array [nnodes][nspace]";
            on_inst = 1;
        };

        Mesh+OPort2  out {
            nnodes => switch(!error,<-.coord_dims[1]);
            nspace => switch(!error,<-.coord_dims[0]);
            coordinates.values => switch(!error,<-.<-.coord);
            ncell_sets = 1;
            Polyline cell_set {
                npolys => switch(!error,array_size(<-.<-.connect)/2);
                poly_connect_list => switch(!error,<-.<-.connect);
            };
        };
    };

    macro bounds_dual {
        // 3D field
        ilink in_field3<export_all=1>;
        // 2D field
        ilink in_field2<export_all=1>;
        DV_Param_bounds BoundsParam<export_all=2> {
            hull=1;
            edges=0;
            faces=0;
            imin=0;
            imax=0;
            jmin=0;
            jmax=0;
            kmin=0;
            kmax=0;
            data=0;
            component=0;
        };
        DVbounds DVbounds3 {
            DV_Param_bounds+IPort2 &param => BoundsParam;
            in => in_field3;
            hull => param.hull;
            edges => param.edges;
            faces => param.faces;
            imin => param.imin;
            imax => param.imax;
            jmin => param.jmin;
            jmax => param.jmax;
            kmin => param.kmin;
            kmax => param.kmax;
            data => param.data;
            component => param.component;
        };
        DVbounds DVbounds2 {
            DV_Param_bounds+IPort2 &param => BoundsParam;
            in => in_field2;
            hull => param.hull;
            edges => param.edges;
            faces => param.faces;
            imin => param.imin;
            imax => param.imax;
            jmin => param.jmin;
            jmax => param.jmax;
            kmin => param.kmin;
            kmax => param.kmax;
            data => param.data;
            component => param.component;
        };
        macro map_2d_to_3d {
            Mesh+Space2+IPort2 &bounds2d => DVbounds2.out;
            // Map 2d coords to 3d coords.  Everything else in this macro is
            // just to generate a output field using these coordinates.
            DV.DVxform_coord DVxform_coord {
                in => <-.bounds2d;
                comp = { 0, 1, 2 };
                coord_nspace = 3;
            };
            SEGM_EDTR.polyline_mesh polyline_mesh {
                coord   => <-.DVxform_coord.coord;
                connect => <-.bounds2d.cell_set[0].poly_connect_list;
            };
            // Assuming no node data ....
            olink out_mesh => polyline_mesh.out;
        };
        FAST_ARR.DVcombine_sets_ARR DVcombine_sets {
            in => { DVbounds3.out, map_2d_to_3d.out_mesh };
        };
        DataObjectNoTexture obj {
            in => DVcombine_sets.out;
            Modes {
                /* set lines, gouraud mode */
                mode = {0, GD_LINES, GD_SURF_GOURAUD, 0, 0};
            };
            Obj {
                name => name_of(<-.<-.<-);
                xform_mode = GD_XFORM_MODE_PARENT;
            };
        };
        olink out_fld<export_all=2> => DVcombine_sets.out;
        olink out_obj => obj.obj;
    }; // bounds

    macro mask_display {
        // 3D field
        ilink in_field;
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        DV.DVextract_comp DVextract_comp {
            in => <-.in_field;
            component => <-.params.value_nd;
        };
        DVM.DVorthoslice_unif DVorthoslice {
            in+nres => <-.DVextract_comp.out;
            &axis  => <-.params.axis;
            &plane => <-.params.slice;
        };
        DataObjectNoTexture orthosliceObj {
            in => DVorthoslice.out;
            Datamap {
                dataMin+nres => min_array(<-.<-.in_field.node_data.min);
                dataMax+nres => max_array(<-.<-.in_field.node_data.max);
            };
            Obj {
                name => name_of(<-.<-.<-);
                xform_mode = GD_XFORM_MODE_PARENT;
            };
        };
        bounds_dual bounds_dual {
            in_field3 => <-.in_field;
            in_field2 => <-.DVorthoslice.out;
        };
        DV.DVthresh_null DVthresh_null {
            in => <-.DVextract_comp.out;
            thresh_component => 0;
        };
        DataObjectNoTexture thresh_nullObj {
            in => DVthresh_null.out;
            Datamap {
                dataMin+nres => min_array(<-.<-.in_field.node_data.min);
                dataMax+nres => max_array(<-.<-.in_field.node_data.max);
            };
            Obj {
                name => name_of(<-.<-.<-);
                xform_mode = GD_XFORM_MODE_PARENT;
            };
        };
        GroupObject mask3Dobj {
            child_objs => {
                <-.bounds_dual.out_obj,
                <-.thresh_nullObj.obj,
                <-.orthosliceObj.obj
            };
        };
        olink out_fld => bounds_dual.out_fld;
        olink obj => mask3Dobj.obj;
    };

    macro mask2D_display {
        // 3D field
        ilink in_field;
        DVbounds DVbounds {
            in => in_field;
            hull=1;
            edges=0;
            faces=0;
            imin=0;
            imax=0;
            jmin=0;
            jmax=0;
            kmin=0;
            kmax=0;
            data=0;
            component=0;
        };
        DataObjectNoTexture BoundsObject {
            in => <-.DVbounds.out;
            Obj {
                name => name_of(<-.<-.<-);
                xform_mode = GD_XFORM_MODE_PARENT;
            };
        };
        DataObjectNoTexture DataObject {
            in => <-.in_field;
            Datamap {
                dataMin+nres => min_array(<-.<-.in_field.node_data.min);
                dataMax+nres => max_array(<-.<-.in_field.node_data.max);
            };
            Obj {
                name => name_of(<-.<-.<-);
                xform_mode = GD_XFORM_MODE_PARENT;
            };
        };
        GroupObject mask2Dobj {
            child_objs => {
                <-.BoundsObject.obj,
                <-.DataObject.obj
            };
        };
        olink obj => mask2Dobj.obj;
    };

    macro out_display {
        ilink in_field;
        ilink mask3D;
        ilink parent;
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        GMOD.instancer inst_addmask {
            Value => (<-.params.applycommand==0);
            Group => out_add_mask;
        };
        macro out_add_mask {
            int selected[] => params.outentities;
            ilink parent => <-.parent;
            ilink in => <-.mask3D;
            ilink params => <-.params;
            UIoptionBoxLabel UIoptionBoxLabel {
                parent => <-.parent;
                labels => <-.params.entities;
                selectedItems => <-.<-.params.outentities;
                title=>"Output Segments";
                UIoptionBox {
                    cmdList {
                        set => 1;
                    };
                };
            };
            macro create_objs[array_size(selected)] {
                DV.DVextract_comp DVextract_comp {
                    in => <-.<-.in;
                    component+nres => <-.<-.selected[index_of(create_objs)];
                };
                DV.DVthresh_null DVthresh_null {
                    in => <-.DVextract_comp.out;
                    thresh_component => 0;
                };
                DataObjectNoTexture thresh_nullObj {
                    in => DVthresh_null.out;
                    Datamap {
                        dataMin+nres => min_array(<-.<-.<-.in.node_data.min);
                        dataMax+nres => max_array(<-.<-.<-.in.node_data.max);
                    };
                    Obj {
                        name => name_of(<-.<-.<-);
                        xform_mode = GD_XFORM_MODE_PARENT;
                    };
                };
                DVM.DVorthoslice_unif DVorthoslice {
                    in+nres => <-.DVextract_comp.out;
                    &axis  => <-.<-.params.axis;
                    &plane => <-.<-.params.slice;
                };
                DataObjectNoTexture orthosliceObj {
                    in => DVorthoslice.out;
                    Datamap {
                        dataMin+nres => min_array(<-.<-.<-.in.node_data.min);
                        dataMax+nres => max_array(<-.<-.<-.in.node_data.max);
                    };
                    Obj {
                        name => name_of(<-.<-.<-);
                        xform_mode = GD_XFORM_MODE_PARENT;
                    };
                };
                GroupObject out_obj {
                    child_objs+nres => { thresh_nullObj.obj, orthosliceObj.obj };
                };
                olink obj=>out_obj.obj;
            };
            GroupObject out_obj {
                child_objs+nres => create_objs.obj;
            };
            olink obj => out_obj.obj;
        };
        GMOD.instancer inst_applymask {
            Value => (<-.params.applycommand==1);
            Group => out_apply_mask;
        };
        macro out_apply_mask {
            ilink in_field => <-.in_field;
            DV.DVthresh_null DVthresh_null {
                in => <-.in_field;
                thresh_component => 0;
            };
            DataObjectNoTexture thresh_nullObj {
                in => DVthresh_null.out;
                Obj {
                    name => name_of(<-.<-.<-);
                    xform_mode = GD_XFORM_MODE_PARENT;
                };
            };
            olink obj => thresh_nullObj.obj;
        };
        DVM.DVorthoslice_unif DVorthoslice {
            in => <-.in_field;
            &axis  => <-.params.axis;
            &plane => <-.params.slice;
        };
        DataObjectNoTexture orthosliceObj {
            in => DVorthoslice.out;
            Obj {
                name => name_of(<-.<-.<-);
                xform_mode = GD_XFORM_MODE_PARENT;
            };
        };
        bounds_dual bounds_dual {
            in_field3 => <-.in_field;
            in_field2 => <-.DVorthoslice.out;
        };
        GroupObject out_obj {
            child_objs+nres => {
                switch((<-.params.applycommand+1),
                        <-.out_add_mask.obj, <-.out_apply_mask.obj),
                switch((<-.params.applycommand),
                        orthosliceObj.obj), <-.bounds_dual.out_obj
            };
        };
        olink obj => out_obj.obj;
    };

    macro AddMultitpleNodeData {
        Mesh+Node_Data+IPort2 &in;
        Node_Data+IPort2 &data {
            nnodes => <-.in.nnodes;
        };
        Node_Data+OPort tmp_data[in.nnode_data+data.nnode_data] {
            nnode_data=1;
            nnodes => <-.in.nnodes;
            &node_data => switch ((index_of(tmp_data)<(<-.in.nnode_data))+1,
                                   <-.data.node_data[index_of(tmp_data)-<-.in.nnode_data],
                                   <-.in.node_data[index_of(tmp_data)]);
        };
        FLD_MAP.combine_node_datas combine_node_datas {
            in => <-.tmp_data;
        };
        FLD_MAP.combine_mesh_data combine_mesh_data {
            in_mesh => <-.in;
            in_nd => combine_node_datas.out;
        };
        olink out => combine_mesh_data.out;
        olink obj => combine_mesh_data.obj;
    };

    macro ReadHDF5Mask {
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;

        Mesh_Struct+IPort2 &in;

        HDF5.H5list_vars list_vars {
            filename => <-.params.filename;
            nodeVars => <-.params.readentities;
        };
        // Make sure the size of the mask in the HDF5 file
        // matches the size of the input field.
        long dimsdiff[] => in.dims-list_vars.dims;
        long min => min_array(dimsdiff);
        long max => max_array(dimsdiff);
        GMOD.copy_on_change copy_on_change {
            input => ((<-.min == 0) && (<-.max == 0));
            output => <-.params.allow_read;
        };
        HDF5.H5read_field read_field {
            filename+nonotify => <-.params.filename;
            nodeVars => <-.params.selentities;

            int+read+req trigger<NEportLevels={2,0}> => <-.params.start_read;
            // Make sure it triggers on, uh, trigger
            omethod+notify_val+notify_inst update<status=1> =
                "HDF5read_field_update";

            copyIntoExisting = 1;
            outFld => <-.in;
        };
    };

    UIradioBoxLabel UIsegeditRadioBoxLabel {
        height => ((.UIradioBox.y + .UIradioBox.height) + 10);
        UIframe UIpanel {
            parent => <-.parent;
            x => <-.x;
            y => <-.y;
            width => <-.width;
            height => <-.height;
        };
        UIlabel {
            x = 2;
            y = 2;
            width => (<-.UIpanel.width - 4);
            color {
                foregroundColor = "white";
                backgroundColor = "blue";
            };
        };
    };

    UIsegeditRadioBoxLabel RegionGrowUI {
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        Node_Data+IPort2 &in;
        string label;
        UIframe UIpanel {
            parent => <-.parent;
            visible => <-.visible;
            x => <-.x;
            y => <-.y;
            width => <-.width;
            height => <-.height;
        };
        UIlabel {
            label => <-.label;
        };
        UIslider delta {
            parent => <-.UIpanel;
            width => parent.clientWidth/2;
            y =>  <-.UIlabel.y + <-.UIlabel.height;
            value => <-.params.reg_delta;
            min => cache((in.node_data[<-.params.thr_comp].min_vec[0]));
            max => cache((in.node_data[<-.params.thr_comp].max_vec[0]));
        };
        UItoggle incremental {
            parent => <-.UIpanel;
            width => parent.clientWidth/2-40;
            x => parent.clientWidth/2 + 20;
            y => <-.delta.y + ((<-.delta.height - height)/2);
            set => <-.params.reg_incr;
        };
        UIradioBox {
            orientation = "horizontal";
            y => <-.delta.y + <-.delta.height;
            x => 5;
#ifdef MSDOS
            height => 4 + UIdata.UIfonts[0].lineHeight;
#else
            height => UIdata.UIfonts[0].lineHeight;
#endif
            itemWidth => width/2-20;
        };
    };

    UIsegeditRadioBoxLabel ThresholdUI {
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        Node_Data+IPort2 &in;
        string label;
        UIframe UIpanel {
            parent => <-.parent;
            visible => <-.visible;
            x => <-.x;
            y => <-.y;
            width => <-.width;
            height => <-.height;
        };
        UIlabel {
            label => <-.label;
        };
        UIslider minimum {
            parent => <-.UIpanel;
            width => parent.clientWidth;
            y =>  <-.UIlabel.y + <-.UIlabel.height;
            value => <-.params.thr_min;
            min => cache((in.node_data[<-.params.thr_comp].min_vec[0])-.1);
            max => cache((in.node_data[<-.params.thr_comp].max_vec[0])+.1);
        };
        UIslider maximum {
            parent => <-.UIpanel;
            width => parent.clientWidth;
            y =>  <-.minimum.y + <-.minimum.height;
            value => <-.params.thr_max;
            min => cache((in.node_data[<-.params.thr_comp].min_vec[0])-.1);
            max => cache((in.node_data[<-.params.thr_comp].max_vec[0])+.1);
        };
        UIradioBox {
            orientation = "horizontal";
            y => <-.maximum.y + <-.maximum.height;
#ifdef MSDOS
            height => 4 + UIdata.UIfonts[0].lineHeight;
#else
            height => UIdata.UIfonts[0].lineHeight;
#endif
            itemWidth => width/2;
        };
    };

    macro Store_Mask_UI {
        ilink parent;
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        int+IPort2 visible;
        int x;
        int y;
        int width;
        int height=> ((save.y + save.height) + 10);
        string label;
        UIframe UIframe {
            parent => <-.parent;
            visible => <-.visible;
            x => <-.x;
            y => <-.y;
            width => <-.width;
            height => <-.height;
        };
        UIlabel title {
            x = 2;
            y = 2;
            parent => <-.UIframe;
            width => parent.width - 4;
            label => <-.label;
            color {
                foregroundColor = "white";
                backgroundColor = "blue";
            };
        };
        UItext filename {
            parent => <-.UIframe;
            y => <-.title.y + <-.title.height + 10;
            width => 2*parent.clientWidth/3;
            text => <-.params.filename;
        };
        UIbutton browse {
            parent => <-.UIframe;
            y => <-.filename.y;
            height => <-.filename.height;
            x => <-.filename.x + <-.filename.width;
            width => parent.clientWidth/3;
            label => "Browse...";
        };
        UIfileSB file_browser {
            visible => <-.browse.do;
            title => "Store 3D Mask";
            filename => <-.params.filename;
            searchPattern => "$XP_PATH<0>/*.h5";
        };
        UIbutton save {
            parent => <-.UIframe;
            label => "Write";
            width => parent.clientWidth;
            height = 30;
            y => <-.filename.y + <-.filename.height + 10;
            do => <-.params.start_write; 
        };
    };

    macro Read_Mask_UI {
        ilink parent;
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        int+IPort2 visible;
        int x;
        int y;
        int width;
        int height=> read.y + read.height + 10;
        string label;
        UIframe UIframe {
            parent => <-.parent;
            visible => <-.visible;
            x => <-.x;
            y => <-.y;
            width => <-.width;
            height => <-.height;
        };
        UIlabel title {
            x = 2;
            y = 2;
            parent => <-.UIframe;
            width => parent.width - 4;
            label => <-.label;
            color {
                foregroundColor = "white";
                backgroundColor = "blue";
            };
        };
        UItext filename {
            parent => <-.UIframe;
            y => <-.title.y + <-.title.height + 10;
            width => parent.clientWidth/2;
            text => <-.params.filename;
        };
        UIbutton browse {
            parent => <-.UIframe;
            y => <-.filename.y + <-.filename.height + 10;
            height => <-.filename.height;
            width => parent.clientWidth/2;
            label => "Browse...";
        };
        UIfileSB file_browser {
            visible => <-.browse.do;
            title => "Load 3D Mask";
            filename => <-.params.filename;
            searchPattern => "$XP_PATH<0>/*.h5";
        };
        UIbutton read {
            parent => <-.UIframe;
            label => "Read";
            active => <-.params.allow_read;
            width => parent.clientWidth/2;
            height = 30;
            y => <-.browse.y + <-.browse.height+10;
            do => <-.params.start_read; 
        };        
        UIframe entities {
            parent => <-.UIframe;
            y => <-.filename.y;
            x => (parent.clientWidth / 2);
            width => (parent.clientWidth / 2);
            height => ((<-.read.y + <-.read.height) - .y);
        };
        UIlabel entity {
            parent => <-.entities;
            label => "Read Entities";
            width => parent.clientWidth;
        };
        UIscrolledWindow UIscrolledWindow {
            parent => <-.entities;
            y = 24;
            width => parent.clientWidth;
            height => (parent.clientHeight - .y);
            virtualHeight => <-.UIoptionBox.height;
        };
        label_cmd label_cmd {
            labels => <-.params.readentities;
        };
        UIoptionBox UIoptionBox {
            parent => <-.UIscrolledWindow;
            cmdList => <-.label_cmd.cmd;
            selectedItems => <-.params.selentities;
        };
    };

    macro Edit_Entity_UI {
        ilink parent;
        ilink in;
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        int+IPort2 visible;
        int x;
        int y;
        int width;
        int height => close.y + close.height + 10;
        string label;
        UIframe UIframe {
            parent => <-.parent;
            visible => <-.visible;
            x => <-.x;
            y => <-.y;
            width => <-.width;
            height => <-.height;
        };
        UIlabel title {
            x = 2;
            y = 2;
            parent => <-.UIframe;
            width => parent.width - 4;
            label => <-.label;
            color {
                foregroundColor = "white";
                backgroundColor = "blue";
            };
        };
        UIbutton combine {
            parent => <-.UIframe;
            x => parent.clientWidth/2;
            y => <-.UIscrolledWindow.y;
            height = 30;
            width => parent.clientWidth/2;
            label => "Combine";
            do => <-.params.combine_entity;
        };
        UIbutton delete {
            parent => <-.UIframe;
            x => <-.combine.x;
            y => <-.combine.y + <-.combine.height + 5;
            height = 30;
            width => parent.clientWidth/2;
            do => <-.params.delete_entity;
            label => "Delete";
        };
        UIbutton close {
            parent => <-.UIframe;
            label => "Close Frame";
            width => parent.clientWidth/2;
            height = 30;
            y => <-.delete.y + <-.delete.height+15;
            x => <-.combine.x;
        };        
        GMOD.parse_v close_frame {
            trigger => <-.close.do;
            v_commands => "visible=0;";        
            relative => <-;        
        };
        UIscrolledWindow UIscrolledWindow {
            parent => <-.UIframe;
            y => <-.title.y + <-.title.height + 10;
            width => parent.clientWidth/2;
            height => <-.close.y + <-.close.height - y;
            virtualHeight+nres => (<-.UIoptionBox.height + 10);
        };
        label_cmd label_cmd {
            labels => <-.params.entities;
        };
        UIoptionBox UIoptionBox {
            x = 0;
            y = 0;
            active = 1;
            parent => <-.UIscrolledWindow;
            cmdList => <-.label_cmd.cmd;
            selectedItems => <-.params.edit_selentities;
            width => parent.clientWidth;
#ifndef MSDOS
            itemWidth+nres => parent.virtualWidth;
#endif
       };
    };

    macro SegmentationEditorUI {
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        Node_Data+IPort2 &in;
        Node_Data+IPort2 &mask3D;
        UImod_panel UImod_panel {
            title => name_of(<-.<-.<-,1);
            width => (parent.clientWidth - 10);
        };
        UIslider axis {
            parent => <-.UImod_panel;
            value => <-.params.axis;
            y = 0;
            min = 0.;
            max => switch((array_size(<-.params.dims)!=0)+1,0,array_size(<-.params.dims)-1);
            width => parent.clientWidth;
            mode = "integer";
        };
        UIslider plane {
            parent => <-.UImod_panel;
            value => <-.params.slice;
            active =>array_size(<-.params.dims)!=0;
            y => <-.axis.y + <-.axis.height + 10;
            max => <-.params.dims[<-.params.axis]-1;
            min = 0.;
            width => parent.clientWidth;
            mode = "integer";
        };

        GMOD.demux demux {
           input => <-.params.drawcommand;
           // Needs to match size of DrawMaskCommands
           input_max = 13;
        };

        UIsegeditRadioBoxLabel Draw_Mask {
            parent => <-.UImod_panel;
            labels => params.drawcommand.choices;
            width => (parent.clientWidth / 2);
            y => <-.plane.y + <-.plane.height + 10;
            selectedItem => <-.params.drawcommand;
            int bottom => ((.UIradioBox.y + .UIradioBox.height) + 10);
            int height => <-.FixedUIBottom - y;
            // This runs too often
            GMOD.parse_v clear_volume {
                // trigger+nres => label_cmd.cmd[12].do;
                // trigger => (selectedItem == 12);
                trigger+nres => <-.<-.demux.output[12].trigger;
                v_commands => "params.clear_volume=1;";        
                relative => <-;        
            };
        };
        macro value_box {
            ilink parent => <-.UImod_panel;
            int x => parent.clientWidth/2;
            int y => <-.Apply_Mask.y + <-.Apply_Mask.height;
            int height => <-.FixedUIBottom - y;
	    int bottom => clear.bottom + 10;
	    int width => parent.clientWidth/2;
            UIframe UIframe {
                parent => <-.parent;
                x => <-.x;
                y => <-.y;
                width => <-.width;
                height => <-.height;
            };
            UIslider value {
                parent => <-.UIframe;
                value => <-.<-.params.value;
                y => 0;
                min = 1;
                width => parent.clientWidth;
                mode = "integer";
            };
            UItext label {
                parent => <-.UIframe;
                y => <-.value.y + <-.value.height + 5;
                width => parent.clientWidth;
                text => <-.<-.params.label;
            };
            UIbutton clear {
                parent => <-.UIframe;
                do => <-.<-.params.edit_entity;
                label => "Edit Entities";
                y => <-.label.y + <-.label.height + 5;
                height = 30;
                width => parent.clientWidth;
		int bottom => .height + .y;
            };
        };
        UIsegeditRadioBoxLabel Pen {
            parent => <-.UImod_panel;
            labels => params.pen.choices;
            width => parent.clientWidth / 2;
            height => ((.penwidth.y + .penwidth.height) + 4);
            y => <-.Draw_Mask.y;
            x => parent.clientWidth / 2;
            selectedItem => <-.params.pen;
            UIslider penwidth {
                parent => <-.UIpanel;
                value => <-.<-.params.width;
                y => <-.UIradioBox.y + <-.UIradioBox.height + 2;
                max = 20;
                min = 0;
                title = "width";
                width => parent.clientWidth;
                mode = "integer";
            };
            UIradioBox {
                orientation = "horizontal";
#ifdef MSDOS
                height => 4 + UIdata.UIfonts[0].lineHeight;
#else
                height => UIdata.UIfonts[0].lineHeight;
#endif
                itemWidth => <-.width/2-10;
            };
        };
        UIsegeditRadioBoxLabel Apply_Mask {
            parent => <-.UImod_panel;
            labels => params.applycommand.choices;
            width => parent.clientWidth / 2;
            x => parent.clientWidth / 2;
            y => <-.Pen.y + <-.Pen.height;
            selectedItem => <-.params.applycommand;
        };
        int ValueBoxBottom => .value_box.y + .value_box.bottom;
        int DrawMaskBottom => .Draw_Mask.y + .Draw_Mask.bottom;
        int FixedUIBottom => switch( (ValueBoxBottom < DrawMaskBottom)+1,
                                          ValueBoxBottom, DrawMaskBottom );	
        Edit_Entity_UI Edit_Entity_UI {
            in => <-.mask3D;
            parent => UImod_panel;
            params => <-.params;
            visible => params.edit_entity;
            y => <-.FixedUIBottom;
            int width => parent.clientWidth;
            label => "Edit Entities";
        };
        int edit_y => switch((Edit_Entity_UI.visible+1),0,Edit_Entity_UI.height);
        RegionGrowUI RegionGrow2D {
            in => <-.in;
            params => <-.params;
            labels => params.applyregcommand.choices;
            parent => <-.UImod_panel;
            visible => (<-.params.drawcommand == 7);
            label => <-.params.drawcommand;
            selectedItem => <-.params.applyregcommand;
            y => <-.FixedUIBottom + <-.edit_y;
            int width => parent.clientWidth;
            height => ((.UIbutton.y + .UIbutton.height) + 10);
            UIbutton UIbutton {
                parent => <-.UIpanel;
                height => 30;
                y => <-.UIradioBox.y + <-.UIradioBox.height + 10;
                x => 5;
                do => <-.params.reg_trig;
                width => <-.parent.clientWidth-(2*.x);
                label => "Run with Previous Seed Point";
            };
        };
        RegionGrowUI RegionGrow3D {
            in => <-.in;
            params => <-.params;
            labels => params.applyregcommand.choices;
            parent => <-.UImod_panel;
            visible => (<-.params.drawcommand == 8);
            label => <-.params.drawcommand;
            selectedItem => <-.params.applyregcommand;
            y => <-.FixedUIBottom + <-.edit_y;
            int    width => parent.clientWidth;
        };
        ThresholdUI ThresholdUI {
            in => <-.in;
            params => <-.params;
            labels => params.applyregcommand.choices;
            parent => <-.UImod_panel;
            visible => (<-.params.drawcommand == 9);
            label => <-.params.drawcommand;
            selectedItem => <-.params.applyregcommand;
            int    y => <-.FixedUIBottom + <-.edit_y;
            height => ((.UIbutton.y + .UIbutton.height) + 10);
            int    width => parent.clientWidth;
            UIbutton UIbutton {
                parent => <-.UIpanel;
                height => 30;
                y => <-.UIradioBox.y + <-.UIradioBox.height + 10;
                x => 5;
                do => <-.params.thr_trig;
                width => <-.parent.clientWidth-(2*.x);
                label => "Run Threshold";
            };
        };
        Store_Mask_UI Store_Mask_UI {
            params => <-.params;
            parent => <-.UImod_panel;
            label => "Save 3D Mask";
            visible => (<-.params.drawcommand == 10);
            int y => <-.FixedUIBottom + <-.edit_y;
            int width => parent.clientWidth;
        };
        Read_Mask_UI Read_Mask_UI {
            params => <-.params;
            parent => <-.UImod_panel;
            label => "Load 3D Mask";
            visible => (<-.params.drawcommand == 11);
            int y => <-.FixedUIBottom + <-.edit_y;
            int width => parent.clientWidth;
        };
    };

    macro SegmentationEditorFunc {
        ilink View;
        SEGM_EDTR.SegmentationEditorParams+IPort2 &params;
        Mesh_Unif+Node_Data& in;
        Mesh_Unif+Node_Data+OPort out;
        Mesh_Unif+Node_Data+OPort2 mask3D;

        DVM.DVorthoslice_unif orthoslice {
            in => <-.in;
            &axis => <-.params.axis;
            &plane => <-.params.slice;
        };
        
        DV.DVnode_data_labels DVnode_data_labels {
            in => <-.mask3D;
            labels => <-.params.entities;
        };

        Mesh_Unif+Node_Data+IPort &slice => .orthoslice.out;

        MODS.reset_xform reset_xform {
            in_field => <-.orthoslice.out;
            obj {
                Obj {
                    xform_mode = "Parent";
                };
            };
        };
        Mesh_Unif+Node_Data+OPort mask {
            dims => <-.slice.dims;
            ndim => <-.slice.ndim;
            nspace => <-.slice.nspace;
            nnode_data = 1;
            node_data = {
                {
                    veclen=1,,,,,,,,
                }
            };
            points => <-.slice.points;
        };

        SEGM_EDTR.DrawMask DrawMask {
            view => <-.View;
            x+nres => view.two_point.x;
            y+nres => view.two_point.y;
            in_slice => <-.slice;
            slice => <-.params.slice;
            axis => <-.params.axis;
            state+nres => view.two_point.state;
            obj => <-.reset_xform.out_obj;
            value => <-.params.value;
            mask => <-.mask;
            width => <-.params.width;
            command => <-.params.drawcommand;
            pen => <-.params.pen;
            thr_min => <-.params.thr_min;
            thr_max => <-.params.thr_max;
            thr_comp => <-.params.thr_comp;
            thr_trig => <-.params.thr_trig;
            reg_delta => <-.params.reg_delta;
            reg_incr => <-.params.reg_incr;
            reg_trig => <-.params.reg_trig;
            regcmd => <-.params.applyregcommand;
        };
        GDM.DataObject DataObject {
            in => <-.mask;
            Datamap {
                currentColorModel = 1;
                DatamapValue = {
                    {
                    v2=1.,
                    },
                };
            };
            Modes {
                normals = "None";
            };
            Props {
                material = {0.3, 0.7, 0.4, 12.};
                inherit = 0;
                trans = 0.5;
            };
            Obj {
                xform_mode = "Parent";
            };
        };
        GDM.GroupObject GroupObject {
            child_objs => {
                <-.reset_xform.out_obj,
                <-.DataObject.obj
            };
        };
        SEGM_EDTR.SegmentationEditorCore SegmentationEditorCore {
            axis => <-.params.axis;
            slice => <-.params.slice;
            value => <-.params.value;
            value_nd => <-.params.value_nd;
            draw => <-.DrawMask.draw;
            clear => <-.params.clear_volume;
            clearMask3D => <-.params.clear_mask3D;
            command => <-.params.applycommand;
            regcmd=> <-.params.applyregcommand;
            entityList => <-.params.edit_selentities;
            combineEntity => <-.params.combine_entity;
            clearEntity => <-.params.delete_entity;
            outEntities => <-.params.outentities;
            in_field => <-.in;
            mask => <-.mask;
            mask3D => <-.mask3D;
            seed => <-.DrawMask.seed_point;
            reg_delta => <-.params.reg_delta;
            reg_incr => <-.params.reg_incr;
            grow_region_3D => (<-.params.drawcommand==8);
            label => <-.params.label;
            out => <-.out;
        };
        olink mask_obj => GroupObject.obj;
        AddMultitpleNodeData AddMultitpleNodeData {
            in => <-.in;
            data => <-.mask3D;
        };
        DVM.DVswitch DVswitch {
            in => {<-.AddMultitpleNodeData.out,<-.out};
            index => <-.params.applycommand;
        };
        olink volume => DVswitch.out;

        HDF5.H5write_field write_field {
            filename+nonotify => <-.params.filename;
            compress = 1;
            inFld+nonotify => <-.mask3D;
            int+read+req trigger => <-.params.start_write;
            omethod+notify_val+notify_inst update<status=1> = "HDF5write_field_update";
        };

        ReadHDF5Mask ReadHDF5Mask {
            in     => <-.mask3D;
            params => <-.params;
        };
/*
        SEGM_EDTR.GrowRegion GrowRegion3D {
            dims => in.dims;
            in => <-.in;
            seed => <-.DrawMask.seed_point;
            combine_and_or = {1};
            delta => {<-.params.reg_delta};
            use_diagonals = 0;
            set_null_value = 1;
            and_precedence = 1;
            invert_region = 0;
            out_val => <-.params.value;
            out_label => <-.params.label;
            trigger => (<-.params.drawcommand == 8);
            incremental => {<-.params.reg_incr};
        };
*/
    };

    macro SegmentationEditor {
        Mesh_Unif+Node_Data+IPort2 &in;
        ilink View;
        SEGM_EDTR.SegmentationEditorParams params {
            dims => <-.in.dims;
            value => dims[slice]/2;
            slice = 0;
            applycommand = "Apply Mask";
            pen = "Draw";
            width = 10;
            clear_volume = 0;
            applyregcommand = "Add to Mask";
            clear_mask3D = 0;
            reg_delta = 30;
            edit_entity = 0;
            reg_incr = 0;
            value_nd = 0;
            thr_min => cache(in.node_data[thr_comp].min_vec[0]);
            thr_max => cache(in.node_data[thr_comp].max_vec[0]);
            thr_comp=0;
            thr_trig=0;
            reg_trig=1;
            allow_read=0;
            start_read=0;
         };
        SegmentationEditorUI SegmentationEditorUI {
            in => <-.in;
            mask3D => <-.SegmentationEditorFunc.mask3D;
            params => <-.params;
        };
        SegmentationEditorFunc SegmentationEditorFunc {
            params => <-.params;
            in => <-.in;
            View => <-.View;
        };
        mask_display mask_display {
            params => <-.params;
            in_field => <-.SegmentationEditorFunc.mask3D;
        };
        mask2D_display mask2D_display {
            in_field => <-.SegmentationEditorFunc.mask;
        };
        out_display out_display {
            out_add_mask {
                parent => UIframe;
                int reg2_y => switch((<-.<-.SegmentationEditorUI.RegionGrow2D.visible+1),0,<-.<-.SegmentationEditorUI.RegionGrow2D.height);
                int reg3_y => switch((<-.<-.SegmentationEditorUI.RegionGrow3D.visible+1),0,<-.<-.SegmentationEditorUI.RegionGrow3D.height);
                int thr_y => switch((<-.<-.SegmentationEditorUI.ThresholdUI.visible+1),0,<-.<-.SegmentationEditorUI.ThresholdUI.height);
                int load_y => switch((<-.<-.SegmentationEditorUI.Read_Mask_UI.visible+1),0,<-.<-.SegmentationEditorUI.Read_Mask_UI.height);
                int save_y => switch((<-.<-.SegmentationEditorUI.Store_Mask_UI.visible+1),0,<-.<-.SegmentationEditorUI.Store_Mask_UI.height);
                int edit_y => <-.<-.SegmentationEditorUI.edit_y;
                UIframe UIframe {
                    y => <-.<-.<-.SegmentationEditorUI.Draw_Mask.y + <-.<-.<-.SegmentationEditorUI.Draw_Mask.height + <-.reg2_y + <-.reg3_y + <-.thr_y + <-.load_y + <-.save_y + <-.edit_y;
                    parent => <-.<-.<-.SegmentationEditorUI.UImod_panel;
                    width=>parent.clientWidth;
                    height => <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 8;
                };

            };
            ilink in_field=> <-.SegmentationEditorFunc.volume;
            ilink mask3D => <-.SegmentationEditorFunc.mask3D;
            params => <-.params;
        };
        olink out =>  SegmentationEditorFunc.volume;
        olink obj =>  out_display.obj;
        olink mask_obj => SegmentationEditorFunc.mask_obj;
        olink mask3D_obj => mask_display.obj;
        olink mask2D_obj => mask2D_display.obj;
    };


}; // Macros

}; // SEGM_EDTR
