/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/simp_add.v#1 $
*/	
/******************************************************************************/
/* AdderApp adds two numbers from dials and displays the result in a dial     */
/******************************************************************************/
macro AdderApp {
   Shells.UIshell UIshell<NEx=10,NEy=10> {
      title 	= "Simple Adder Application";
      x 	= 16;
      y 	= 128;
      width	= 500;
      height	= 200;
   };


   /*
    * Define a dial as source_1.  This contains lots of specific 
    * subobject settings.
    */
   UIdial dial_source_1<NEx=296,NEy=197> {
      x 	=> 20;
      y 	=  20;
      width 	=> (<-.UIshell.clientWidth - 80) / 3;
      height 	=> <-.UIshell.clientHeight - 40;
      parent	=> UIshell;
      mode 	= 1;
      immediateMode = 1;
      title 	= "source_1";
      valuePerRev = 100;
      numTicks 	= 40;
      value 	= 0.0;
   };

   /* 
    * Use the dial defined above as a template for the remaining two
    * dials.  Only the particular subobjects that change need to be
    * explicitly set.
    */
   dial_source_1 dial_source_2<NEx=461,NEy=197> {
      x 	=> dial_source_1.x + dial_source_1.width + 20;
      mode 	= 1;
      title 	= "source_2";
   };

   dial_source_1 dial_result<NEx=626,NEy=197> {
      x 	=> dial_source_2.x + dial_source_2.width + 20;
      value<NEportLevels={2,0}> => add_num.res;
      mode 	= 1;
      title 	= "result";
   };

   /*
    * This is a simple module that adds two numbers and sets a result
    */
   USER.add_num add_num<NEx=461,NEy=307> {
      src_1 	=> dial_source_1.value;
      src_2 	=> dial_source_2.value;
   };
};
