/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/templ.v#1 $
*/

/* Get the defines for the Graphics Display Kit
   renderers that we are to use.
*/
$include ../include/$MACHINE/gd_ren.h
$include ../include/$MACHINE/config.h

#ifdef ACKIT
#define AC_DEFINED
#endif

#ifdef AC_KIT_V1
#define AC_DEFINED
#endif

// The 'user_class' property indicates that we derive from this object
// when we make copies
library Templates<user_class=1>
{
   "std" STD;
   "stdmac" STDMAC;
   "config.v" CONFIG;

// For the DEC Alpha Unix platform, the C++ templates must be generated in the
// same object file. Some templates have a dependency on the AG kit and need to
// be configured in or out with the kit. The following V code switches the proper
// object file in  the link line for the AG kit option.

#ifdef xp_alpha
   flibrary DEC_UNIX_TEMPLATES<
#ifdef AG_KIT
	link_files="$(AGCXXTEMPL) -lag -lagx -lcxxut"
#else
	link_files="$(CXXUTLTEMPL) -lcxxut"
#endif
   >;
#endif // xp_alpha

   // For IRIX 5.2 (SGI), C++ templates are not linked correctly if any shared
   // libraries appear on the link line prior to any libraries that use C++
   // templates.  Therefore, the following flibraries are used in order to
   // ensure that all shared libraries are placed at the end of the link line.

#ifdef ORACLE_KIT
   flibrary LIBORACLE < link_files="$(ORACLE_LINK)",
			disabled => (Templates.CONFIG.db_kit_disabled |
				    Templates.CONFIG.db_oracle_disabled)>;
#endif

#ifdef OGL_RENDERER
   flibrary LIBGL <
      NEvisible=0,
      disabled => Templates.CONFIG.gd_gl_disabled,
#ifdef MSDOS
      link_files="$(WINLIBS)"
#else
      link_files="$(LINK_SHARED_FLAG) $(OGL_LIBS_PATH) -lGLU -lGL $(MAYBE_LINK_SHARED_FLAG) $(WINLIBS)"
#endif
   >;
#endif

// IAC/MPU: Definition of LIBMPU has been moved further down so it
//          occurs after the FLD definition. (MPE 5.1.2)
   
#ifdef VRML_RENDERER
   flibrary LIBVRML <
      NEvisible=0,
      disabled => Templates.CONFIG.gd_vrml_disabled,
      link_files="-lgdvrm -lcxxut"
   >;
#endif

#ifdef VPS_RENDERER
   flibrary LIBVPS <
      NEvisible=0,
      disabled => Templates.CONFIG.gd_vps_disabled,
      link_files="-lgdvps -lcxxut"
   >;
#endif

#ifdef GIS_KIT
   flibrary GIS_UTIL <
      NEvisible=0,
      link_files="-lgis_util",
      build_cmd="$(MAKE)",
      disabled => Templates.CONFIG.gis_disabled,
      build_dir="gis/util"
   >;
   flibrary GIS_MODS <
      NEvisible=0,
      link_files="-lgis_mods",
      build_cmd="$(MAKE)",
      disabled => Templates.CONFIG.gis_disabled,
      build_dir="gis/xp_mods",
      libdeps="GIS_UTIL"
   >;
#endif // GIS_KIT

   flibrary WTOOL <
      build_dir="wtool",
      build_cmd="$(MAKE)",
#ifndef NO_DL_LOAD
      in_dll=1,
#endif
      link_files="-lwtool $(WINLIBS)"
   >;
   "wt_objs.v" WT_OBJS;

   "ui_glob.v" UI_GLOBAL;

   "ne_glob.v" NE_GLOBAL;
   "ne_prefs.v" NE_PREFERENCES;
   // Use ascii to prevent dependency problem with fonts.v files
   "gdif" GDIF;
   "fld" FLD;
   "fldf" FLDF;

// build express.dll *after* all of it's members (see the list in
// the build_dir\nt.mak below) are built and *before* any dynamic loaded
// library references to the express.lib import library...
#ifdef MSDOS
   flibrary EXPRESS_DLL <
      build_dir="xp_dll",
      build_cmd="$(MAKE)"
   >;
#endif

   "ren" REN;
   "fld_meth" DV_FLD;
   "gmod" GMOD;
   "file" FILE;
   "pal" PAL;
   "ip_pkg" IP_PKG;
#ifdef WWW_KIT
   "www" WEB;
#endif
#ifdef ANIM_KIT
   "anim" ANIM;
   "anim_m" ANIM_MACROS;
   "anim_ui" ANIM_MODS;
#endif
#ifdef NETCDF_KIT
   "netcdf" NETCDF;
#endif
#ifdef HDF5_KIT
   "hdf5" HDF5;
#endif
#ifdef REDUCT_KIT
   "reduct" RDCT;
#endif
#ifdef GIS_KIT
   "gis1" GIS;
   "gis3" GIS_READERS;
#endif
   "dv" DV;
   "dvm" DVM;
   "dv_macro" DV_MACROS;
#ifdef READ_URL
   "w3c" W3C;
#endif
   "cgen.v" CGEN;
   "dmap" DMAP;
   "cmap_edtr" CMAP_EDTR;
   "dmap_ex" DATAMAPS;
   "UI" UI;
   "ui_macro" UI_MACROS;
   "au"	AU;

   "segm_edtr" SEGM_EDTR;

#ifdef AC_KIT_V1
   flibrary+global ACMOD <
      build_dir="compat",
      build_cmd="$(MAKE)",
      libfile="compat.v",
      disabled => Templates.CONFIG.ac_kit_disabled
//      disabled => Templates.CONFIG.ac_kit_disabled,
//      hdr_code="int AVSinit_std_modules (void);
//		int ACinit (int *, char **);
//		int ACinit_types (int *, char **);",
//      pre_init_code="   AVSinit_std_modules(); ACinit_types(argc,argv);",
//      init_code="   ACinit(argc,argv);",
//      link_files="-lacmod -lac -lgeom -lutil -lrf"
//      link_files="-lac -lgeom -lutil -lrf"
   >;
//   // this is an example of how to integrate user AVS modules into your
//   // express executable
//   flibrary+global ACUSRMOD <
//      disabled => Templates.CONFIG.ac_kit_disabled,
//      // the function name AVSinit_user_modules can be anything but
//      // should contain the code that AVSinit_modules used to... it can
//      // even be called AVSinit_modules but only one per process....
//      hdr_code="int AVSinit_user_modules (void);",
//      pre_init_code="   AVSinit_user_modules();",
//      link_files="-lusers -lac -lgeom -lutil"
//      link_files="-lac -lgeom -lutil"
//   >;
#endif // AC_KIT_V1

#ifdef ACKIT
   // AVS5 compatibility kit (see also compat2.v, included below)
   flibrary AC_KIT <
      build_dir="ackit",
      disabled => Templates.CONFIG.ac_kit_disabled,
      build_cmd="$(MAKE)",
      libfile="compat.v",
      hdr_code="void ACinit (int *argc, char **argv);",
      pre_init_code=
           "   ACinit(argc, argv);",
      link_files="-lackit -ldmap -ldbxx -lgeom -lutil",
      need_objs="UI",	// AC creates UI objects dynamically
      compile_subs=0
   >;
   // Utilities for AVS5 compatibility kit
   flibrary AC_UTIL <
      disabled => Templates.CONFIG.ac_kit_disabled,
      build_dir="ackit",
      // build_cmd="$(MAKE)", (AC_KIT does the building)
      libfile="acutil.v",
      // need this so that NE will define the AC_KIT libraries as well
      libdeps="AC_KIT"
   >;
#endif // ACKIT

#ifdef SW_RENDERER
#ifdef VX_KIT
   flibrary+global+sort VX <
      NEvisible=0,
      build_dir="gd/sw/vxbx",
      build_cmd="$(MAKE)",
      hdr_code="int GDgd_init_vx (void);",
      init_code="   GDgd_init_vx();",
      link_files="-lvxbx"
   >;
#endif
#endif

   "gd" GD;

#ifdef SW_RENDERER
   flibrary+global+sort GDSW <
      NEvisible=0,
      build_dir="gd/sw",
      build_cmd="$(MAKE)",
      disabled => Templates.CONFIG.gd_sw_disabled,
      needs_edit_lic="GD",
      libfile="ren_sw",
      indexed=0, // virtual data inside
      hdr_code="int GDgd_init_sw (void);",
      init_code="   GDgd_init_sw();",
      compile_subs=0,
#ifdef VX_KIT
      libdeps="VX",
#endif
      link_files="-lgdsw"
   >;

#ifdef OGL_RENDERER
   flibrary+global+sort GDOGL <
      NEvisible=0,
      build_dir="gd/ogl",
      build_cmd="$(MAKE)",
      libfile="ren_ogl",
      indexed=0, // virtual data inside
      disabled => Templates.CONFIG.gd_gl_disabled,
      compile_subs=0,
      hdr_code="int GDgd_init_gl (void);",
      init_code="   GDgd_init_gl();",
      link_files="-lgdogl",
      libdeps="LIBGL"
   >;
   // DV type modules/macros that have an OGL dependency
   // due to custom render methods.
   "dv_ogl" DV_OGL;
#endif

// IAC/MPU: added flibrary for GD MPU renderer
#ifdef MPU_RENDERER
   flibrary+global+sort GDMPU <
      NEvisible=1,
      build_dir="gd/mpu",
      build_cmd="$(MAKE)",
      libfile="ren_mpu",
      indexed=0, // virtual data inside
      disabled => Templates.CONFIG.gd_mpu_disabled,
      compile_subs=0,
      hdr_code="int GDgd_init_mpu PTARGS((void));",
      init_code="   GDgd_init_mpu();",
#ifdef MSDOS
      // Need to use XP_PATH0 so that projects pick up these libs.
      link_files="-lgdmpu $(XP_PATH0)/lib/$(MACHINE)/liblic.lib $(XP_PATH0)/lib/$(MACHINE)/NtQuerySemaphore.lib $(WINLIBS)", 
#else
#ifdef xp_sg6
      link_files="-lgdmpu -lmpk -ltrackdAPI_CC -lCio -lgen -lpthread",
#else
#ifdef xp_sgN32
      link_files="-lgdmpu -lmpk -ltrackdAPI_CC -lCio -lgen -lpthread",
#else
#ifdef xp_linux_ia64
      link_files="-lgdmpu -lmpk -ltrackdAPI_CC -lpthread",
#else
#ifdef xp_linux
      link_files="-lgdmpu -lpthread -lXi",
#else
#ifdef xp_s8
      link_files="-lgdmpu -lpthread -lXi",
#else
#ifdef xp_s8_64
      link_files="-lgdmpu -lpthread -lXi",
#endif // s8_64
#endif // s8
#endif // linux
#endif // linux_ia64
#endif // sgN32
#endif // sg6
#endif // MSDOS
      libdeps="LIBMPU"
   >;
#endif

// HP-UX only
#ifdef PEX_RENDERER
   flibrary+global+sort GDPEX <
      NEvisible=0,
      build_dir="gd/pex",
      build_cmd="$(MAKE)",
      disabled => Templates.CONFIG.gd_pex_disabled,
      indexed=0, // virtual data inside
      libfile="ren_pex",
      compile_subs=0,
      hdr_code="int GDgd_init_pex (void);",
      init_code="   GDgd_init_pex();",
      link_files="-lgdpex $(PEX_LIBS) $(WINLIBS)"
   >;
#endif

// Solaris only (removed in Solaris 8)
#ifdef XGL_RENDERER
   flibrary+global+sort GDXGL<
      NEvisible=0,
      build_dir="gd/xgl",
      build_cmd="$(MAKE)",
      disabled => Templates.CONFIG.gd_xgl_disabled,
      indexed=0, // virtual data inside
      libfile="ren_xgl",
      compile_subs=0,
      hdr_code="int GDgd_init_xgl (void);",
      init_code="   GDgd_init_xgl();",
      link_files="-lgdxgl"
   >;
#endif

// Solaris only
#ifdef XIL_RENDERER
   flibrary+global+sort GDXIL<
      NEvisible=0,
      build_dir="gd/xil",
      build_cmd="$(MAKE)",
      disabled => Templates.CONFIG.gd_xil_disabled,
      indexed=0, // virtual data inside
      compile_subs=0,
      libfile="ren_xil",
      hdr_code="int GDgd_init_xil (void);",
      init_code="   GDgd_init_xil();",
      link_files="-lgdxil"
   >;
#endif

#ifdef VRML_RENDERER
   flibrary+global+sort GDVRML <
      NEvisible=0,
      build_dir="gd/vrml",
      build_cmd="$(MAKE)",
      libfile="ren_vrml",
      indexed=0, // virtual data inside
      disabled => Templates.CONFIG.gd_vrml_disabled,
      compile_subs=0,
      hdr_code="int GDgd_init_vrml (void);",
      init_code="   GDgd_init_vrml();",
      link_files="-lgdvrm",
      libdeps="LIBVRML",
      dictionary="vrml.dct"
   >;
#endif

#ifdef VPS_RENDERER
   flibrary+global+sort GDVPS <
      build_dir="gd/vps",
      build_cmd="$(MAKE)",
      libfile="ren_vps",
      indexed=0, // virtual data inside
      disabled => Templates.CONFIG.gd_vps_disabled,
      compile_subs=0,
      hdr_code="int GDgd_init_vps (void);",
      init_code="   GDgd_init_vps();",
      link_files="-lgdvps",
      libdeps="LIBVPS"
   >;
#endif

#ifdef INVENTOR
   flibrary+global INV <
      NEvisible=0,
      build_dir="inventor",
      build_cmd="$(MAKE)",
      libfile="inventor",
      hdr_code="int inventor_init (void);",
      init_code="   inventor_init();",
      link_files="-linventor -lInventor -lInventorXt $(WINLIBS)"
   >;
#endif

#ifdef AG_KIT

#ifndef MSDOS
   flibrary AGXLIB<
       build_dir="agx",
       build_cmd="$(MAKE)",
       need_f=1, // needs FORTRAN libraries
       link_files="-lagx",
       disabled => Templates.CONFIG.ag_kit_disabled
   >;
#endif	// MSDOS

   "ag" AG;

#endif	// AG_KIT

/* On MSDOS the print renderer does not have a dependency
   on the AG kit.
*/
#ifdef MSDOS
#ifdef PRT_RENDERER
#define PRT_DEFINED
#endif
#else
#ifdef AG_KIT
#ifdef PRT_RENDERER
#define PRT_DEFINED
#endif
#endif
#endif

// May only be enabled when the AG_KIT is because of dependency
#ifdef PRT_DEFINED
   flibrary+global+sort GDPRT <
      NEvisible=0,
      build_dir="gd/prt",
      build_cmd="$(MAKE)",
      libfile="ren_prt",
      indexed=0,
      hdr_code="int GDgd_init_prt (void);",
      init_code="   GDgd_init_prt();",
      libdeps="AG",
      link_files="-lgdprt -lgdsw",
#ifdef MSDOS
      disabled => Templates.CONFIG.gd_prt_disabled,
#else
      disabled => Templates.CONFIG.gd_prt_disabled |
		  Templates.CONFIG.ag_kit_disabled,
#endif
      compile_subs=0
   >;
#endif // PRT_DEFINED


#ifdef AC_DEFINED // either ACKIT or AC_KIT_V1
   "acvt" ACVT;
#endif // AC_DEFINED

#ifdef DB_KIT

   flibrary DBIL <
      locked=1,
      build_dir="dbil",
      build_cmd="$(MAKE)",
      link_files="-ldbil",
      disabled=> Templates.CONFIG.db_kit_disabled,
      libdeps = "RDB_ORACLE RDB_ODBC",
      needs_edit_lic="DB"
   >;

   "db" DB;

#ifdef ORACLE_KIT
   flibrary RDB_ORACLE  <
      link_files="-ldborc",
      build_cmd="$(MAKE)",
      disabled => Templates.CONFIG.db_oracle_disabled |
		  Templates.CONFIG.db_kit_disabled,
      build_dir="dbil/oracle",
      hdr_code="int DBoracle_init (void);",
      init_code="   DBoracle_init();",
      libdeps="LIBORACLE",
      needs_edit_lic="DB"
   >;
#endif

#ifdef ODBC_KIT
   flibrary RDB_ODBC  <
      link_files="-lodbc $(ODBC_LINK)",
      build_cmd="$(MAKE)",
	disabled => Templates.CONFIG.db_odbc_disabled |
		  Templates.CONFIG.db_kit_disabled,
      build_dir="dbil/odbc",
      hdr_code="int DBodbc_init (void);",
      init_code="   DBodbc_init();",
      needs_edit_lic="DB"
   >;
#endif

#endif // DB_KIT

   "user" USER;
#ifdef AC_KIT_V1
   //flibrary ACU<libfile="ACUmods",compile_subs=0,
   //		disabled => Templates.CONFIG.ac_kit_disabled>;
#endif
   "view" VIEW;

   "vizxp/vui" VUI;
   "vizxp/hlm" HLM;
#ifdef AG_KIT
   "vizxp/aghlm" AGHLM;
#endif

   "gdm" GDM;

   "ip" IP;
   "geoms" GEOMS;
   "fld_data" DATAS;
   "fld_map" FLD_MAP;

   "modules" MODS;

   "cfd" CFD;

   "mods_arr" MODS_ARR;
   "fast_arr" FAST_ARR;
#ifdef GIS_KIT
   "gis2" GIS_UI;
#endif

   "wizard" WIZARD;

   // Parallel Support Toolkit (PST)   
#ifdef PST_KIT  
   // Global variables for PST
   group PST_CONFIG {
      int status; // 0 PST not/failed to initialize, 1 PST initialized and running
      int max_npstnodes;
      string pstnode_names[max_npstnodes];
      int pTag_mpi<NEvisible=0>;
      int pDomain_mpi<NEvisible=0>;
      int pError_mpi<NEvisible=0>;
      int MPI_COMM_WORLD<NEvisible=0>;
      int MPI_COMM_NULL<NEvisible=0>;
      int MPE_start<NEvisible=0>;
      int MPE_end<NEvisible=0>;
   };
   "pst.v" PST; // All of PST exists in here
   "pst_dev.v" PST_DEV; // NE link targets for NE PST menu
   "pst_user.v" PST_USER; // NE link targets for NE PST menu
   //   "pst_workspace.v" PST_WORKSPACE; // Editable library space for user developed module;
#endif

//
// Examples and Demonstrations
//

   "examples" EXAMPLES;
   "dv_examp" DV_EXAMP;
   "gd_examp" GD_EXAMP;
   "ip_examp" IP_EXAMP;
#ifdef AG_KIT
   "ag_examp" AG_EXAMP;
   "aghlm_ex" AGHLM_EXAMP;
#endif
   "hlm_ex" HLM_EXAMP;

   "../demos/v/demos" DEMOS;

   flibrary WORKSPACE_XP<NEeditable=1>;
   flibrary WORKSPACE_1<NEeditable=1>;
   flibrary WORKSPACE_2<NEeditable=1>;
   flibrary WORKSPACE_3<NEeditable=1>;
   flibrary WORKSPACE_4<NEeditable=1>;
#ifdef ACKIT
   flibrary AC_EXTRA<libfile="compat2">;
#endif // ACKIT

// IAC/MPU: added flibrary for MPU
#ifdef MPU_RENDERER

   flibrary LIBMPU <
      NEvisible=1,
      disabled => Templates.CONFIG.gd_mpu_disabled,
#ifdef MSDOS
      link_files="-lwand $(WINLIBS)",
#else
      link_files="$(LINK_SHARED_FLAG) $(OGL_LIBS_PATH) -lGLU -lGL $(MAYBE_LINK_SHARED_FLAG) -lwand",
#endif
      build_cmd="$(MAKE)",
      build_dir="wand",
      libdeps="GD FLD"
   >
   {
      "../wand/wand.v" WANDLIB;
   };
#endif

//-----------------------------------------------------------------------//
// Network Editor
//-----------------------------------------------------------------------//
   "app" APPS;
   "ne_libs.v" NELIBS; // can't use binary V since it has ifdef's
   "ne" NE;
   "ne_macro" NE_MACROS;
   "ne_obj" NE_OBJ;

#ifdef OLE_KIT
   flibrary+sort OLE <
      build_dir="ole",
      build_cmd="$(MAKE)",
      need_cxx=1,
      libfile="ole",
      hdr_code="void OLEinit (int *argc, char *argv[]);",
      init_code="   OLEinit(argc, argv);",
      link_files="-lole"
   >;
#endif

#ifdef INCLUDE_MicroAVS
#ifdef MAVS_KIT
   "MicroAVS" MicroAVS;
#endif
#endif
};
