/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
        $Id: //depot/express/fcs70/v/ui_macro.v#1 $
*/
flibrary+global UI_MACROS <
   compile_subs=0
> {
macro UIsliderUnbnd {
  ilink UIparent;
  ilink stitle;
  ilink sval;
  ilink smin;
  ilink smax;

  UIpanel panel {
    parent => UIparent;
    width = 275;
    height = 100;
  };
  UIlabel min_label {
    parent => panel;
    x = 0;
    y = 90;
    label = "Min";
  };
  UIfield min_field {
    parent => panel;
    x = 50;
    y = 80;
    width = 75;
    min = -100000;
    value => smin;
  };
  UIlabel max_label {
    parent => panel;
    x = 150;
    y = 90;
    label = "Max";
  };
  UIfield max_field {
    x = 200;
    y = 80;
    width = 75;
    parent => panel;
    max = 100000;
    value => smax;
  };
  UIslider slider {
    parent => panel;
    width = 250;
    height = 65;
    min => min_field.value;
    max => max_field.value;
    value => sval;
    title => stitle;
  };
};

macro UItextTypein {
    ilink       UIparent;
    ilink       slabel;
    ilink       stext;

    UIpanel panel {
        parent => UIparent;
	width	=  200;
	height	=> <-.text.height;
    };
    UIlabel text_label {
        parent => panel;
        label => slabel;
	alignment = 2;
        x	=  0;
        y	=> (<-.text.height - .height) / 2;
	width	=  50;
    };
    UItext text {
        parent => panel;
        &text => stext;
        x	=  60;
	y	=  0;
	width	=> <-.panel.width - 60;
    };
};

macro UIfieldTypein {
    ilink       UIparent;
    ilink       flabel;
    ilink       fval;
    ilink       fmin;
    ilink       fmax;

    UIpanel panel {
        parent	=> UIparent;
	width	=  250;
	height	=> <-.field.height;
	x => <-.x;
	y => <-.y;
	width => <-.width;
	height => <-.height;
    };
    UIlabel label {
        parent => panel;
        label => flabel;
        y	=> (<-.field.height - .height) / 2;
	width	=> <-.panel.width / 2;
    };
    UIfield field {
        parent => panel;
        min => fmin;
        max => fmax;
        value => fval;
	x	=> <-.panel.width / 2;
	y	=  0;
	width	=> <-.panel.width / 2;
    };
    int+IPort2+OPort2 x;
    int+IPort2+OPort2 y;
    int+IPort2+OPort2 width = 200;
    int+IPort2+OPort2 height = 40;
};

/* This macro provides a panel that contains
   a frame with the label "on" the frame. This
   is a nice looking combination that actually
   exists in Windows. We have to kludge it in 
   Motif.
*/
macro UIlabeledPanel {
    ilink UIparent<NEx=70,NEy=50>;

    UIpanel panel<NEx=175,NEy=120> {
        parent => UIparent;
	height = 100;
    };
    UIframe frame<NEx=175,NEy=175> {
	parent => panel;
	x = 5;
	y = 20;
	width => panel.width - 10;
	height => panel.height - 25;
    };
    UIlabel label<NEx=365,NEy=175> {
       parent => panel;
       x => frame.x + 20;
       y => frame.y - 10;
       label => name_of(<-.<-,1);
    };
    /* This panel will take the size of it's 
       parent - the frame. In order to have
       children of the frame and not overlap
       the label we put on the frame, we need to
       add another panel as a child of the panel
       immediately inside the frame - this one
       with row column behavior so its children
       will be placed automatically.
    */
    UIpanel framepanel<NEx=175,NEy=230> {
        parent => frame;
	rowColumnBehavior = 0;
    };
    UIpanel childpanel<NEportLevels={0,2},NEx=175,NEy=285> {
        parent => framepanel;
	x = 5;
	y = 15;
	width => framepanel.width - 10;
        height => framepanel.height - 20;
	rowColumnBehavior = 1;
    };
};

macro UIoptionBoxLabel {
    ilink parent;
    imlink labels;

    string title	=> name_of(<-,1);
    int	visible		=  1;

    int	selectedItems[];
    int	max;

    label_cmd label_cmd {
	labels		=> <-.labels;
	int+read+nonotify+opt inItem[] => <-.selectedItems;
	int+write+nonotify+opt outItem[];
    };

    int x	=  0;		// input
    int y	=  0;		// input
    int width	=  200;
    int height	=> .UIoptionBox.y + .UIoptionBox.height;
    UIpanel UIpanel {
	parent		=> <-.parent;
        x		=> <-.x;
        y		=> <-.y;
	width		=> <-.width;
	height		=> <-.height;
    };
    UIlabel UIlabel {
	parent		=> <-.UIpanel;
	label		=> <-.title;
	alignment	=  1;
	y		=  0;
	width		=> <-.UIpanel.width;
    };
    UIoptionBox UIoptionBox {
	parent		=> <-.UIpanel;
	max		=> <-.max;
	cmdList		=> <-.label_cmd.cmd;
	selectedItems	=> <-.label_cmd.outItem;
	visible		=> <-.visible;
	y		=> <-.UIlabel.y + UIlabel.height + 4;
	width		=> <-.UIpanel.width;
    };
};

macro UIradioBoxLabel {
    ilink		parent;
    imlink		labels;

    int+IPort2		selectedItem;
    string+nres+IPort2	selectedString=>labels[selectedItem];

    string title	=> name_of(<-,1);
    int    visible	=  1;
    int	   active  = 1;

    // these need to be visible at top level for AVS5 compat
    // as well as for general uniformity
    int x	=  0;		// input
    int y	=  0;		// input
    int width	=  200;
    int height	=> .UIradioBox.y + .UIradioBox.height;

    label_cmd label_cmd {
	labels		=> <-.labels;
	cmd.active	=> <-.<-.active;
	inItem => <-.selectedItem;
    };
    UIpanel UIpanel {
	parent		=> <-.parent;
        x		=> <-.x;
        y		=> <-.y;
	width		=> <-.width;
	height		=> <-.height;
    };
    UIlabel UIlabel {
	parent		=> <-.UIpanel;
	label		=> <-.title;
	alignment	=  1;
	y		=  0;
	width		=> <-.UIpanel.width;
	active 		=> <-.active;
    };
    UIradioBox UIradioBox {
	parent		=> <-.UIpanel;
	cmdList		=> <-.label_cmd.cmd;
	&selectedItem	=> <-.label_cmd.outItem;
	&visible	=> <-.visible;
	y		=> <-.UIlabel.y + <-.UIlabel.height + 4;
	width		=> <-.UIpanel.width;
    };

/***
    UIstr_choice UIstr_choice {
	choices		=> <-.labels;
	selected_index	=> <-.label_cmd.outItem;
	selected_string	=> <-.selectedString;
    };
***/

};

macro AVS5radioBoxLabel {
    ilink		parent;
    imlink		labels;

    int+IPort2		selectedItem;
    string+nres+IPort2	selectedString;

    string title	=> name_of(<-,1);
    int    visible	=  1;
    int	   active  = 1;

    // these need to be visible at top level for AVS5 compat
    // as well as for general uniformity
    int x	=  0;		// input
    int y	=  0;		// input
    int width	=  200;
    int height	=> .UIradioBox.y + .UIradioBox.height;

    label_cmd label_cmd {
	labels		=> <-.labels;
	cmd.active	=> <-.<-.active;
	inItem => <-.selectedItem;
    };
    UIpanel UIpanel {
	parent		=> <-.parent;
        x		=> <-.x;
        y		=> <-.y;
	width		=> <-.width;
	height		=> <-.height;
    };
    UIradioBox UIradioBox {
	parent		=> <-.UIpanel;
	cmdList		=> <-.label_cmd.cmd;
	&selectedItem	=> <-.label_cmd.outItem;
	&visible	=> <-.visible;
	y		=> 0;
	width		=> <-.UIpanel.width;
	message         => <-.title;
    };

    GMOD.str_choice str_choice {
	choices		=> <-.labels;
	selected_index	=> <-.label_cmd.outItem;
	selected_string	=> <-.selectedString;
    };

};

macro UIlabeledText {
	 UIcontainer+IPort2 &parent;
	 string+IPort2 label;
	 string+IPort2 text;
	 int+IPort2 active;
	 int+IPort2 x;
         int+IPort2 y;
	 int+IPort2 label_width;
	 int+IPort2 width;
	 int+IPort2 updateMode;

	 UIlabel UIlabel {
	    parent => <-.parent;
	    label => <-.label;
	    x => <-.x;
	    y => <-.y + 5;
	    width => <-.label_width;
	    alignment=2;
	    active => <-.active;
	 };
	 UItext UItext {
	    parent => <-.parent;
	    x => <-.label_width + 5;
	    y => <-.y;
	    width => <-.width - x;
	    height = 33;
	    text => <-.text;
            multiLine=0;
	    active => <-.active;
	    updateMode => <-.updateMode;
	 };
	 int+OPort2 height=>UItext.height;
};

macro UIheaderText {
	 UIcontainer+IPort2 &parent;
	 string+IPort2 label;
	 string+IPort2 text;
	 string+IPort2 header;
	 int+IPort2 active;
	 int+IPort2 x;
         int+IPort2 y;
	 int+IPort2 label_width;
	 int+IPort2 width;
	 int+IPort2 updateMode;

	 UIlabel UIlabel_header {
	    parent => <-.parent;
	    label => <-.header;
	    x => <-.x;
	    y => <-.y;
	    width => <-.width;
	    alignment=0;
	    active => <-.active;
	 };
	 UIlabel UIlabel {
	    parent => <-.parent;
	    label => <-.label;
	    x => <-.x;
	    y => <-.UItext.y + 5;
	    width => <-.label_width;
	    alignment=2;
	    active => <-.active;
	 };
	 UItext UItext {
	    parent => <-.parent;
	    x => <-.label_width + 5;
	    y => <-.y + <-.UIlabel_header.height;
	    width => <-.width - x;
	    height = 33;
	    text => <-.text;
            multiLine=0;
	    active => <-.active;
	    updateMode => <-.updateMode;
	 };
	 int+OPort2 height=> UItext.y + UItext.height - y;
};


macro UIlabeledField {
	 UIcontainer+IPort2 &parent;
	 string+IPort2 label;
	 int+IPort2 value;
	 int+IPort2 active;
	 int+IPort2 x;
         int+IPort2 y;
	 int+IPort2 label_width;
	 int+IPort2 width;
	 int+IPort2 updateMode;

	 UIlabel UIlabel {
	    parent => <-.parent;
	    label => <-.label;
	    x => <-.x;
	    y => <-.y + 5;
	    width => <-.label_width;
	    alignment=2;
	    active => <-.active;
	 };
	 UIfield UIfield {
	    parent => <-.parent;
	    x => <-.label_width + 5;
	    y => <-.y;
	    width => <-.width - x;
	    height = 33;
	    value => <-.value;
	    mode = 1;
	    active => <-.active;
	    updateMode => <-.updateMode;
	 };
	 int+OPort2 height=>UIfield.height;
};

macro UIheaderField {
	 UIcontainer+IPort2 &parent;
	 string+IPort2 label;
	 string+IPort2 header;
	 int+IPort2 value;
	 int+IPort2 active;
	 int+IPort2 x;
         int+IPort2 y;
	 int+IPort2 label_width;
	 int+IPort2 width;
	 int+IPort2 updateMode;

	 UIlabel UIlabel_header {
	    parent => <-.parent;
	    label => <-.header;
	    x => <-.x;
	    y => <-.y;
	    width => <-.width;
	    alignment=0;
	    active => <-.active;
	 };

	 UIlabel UIlabel {
	    parent => <-.parent;
	    label => <-.label;
	    x => <-.x;
	    y => <-.UIfield.y + 5;
	    width => <-.label_width;
	    alignment=2;
	    active => <-.active;
	 };
	 UIfield UIfield {
	    parent => <-.parent;
	    x => <-.label_width + 5;
	    y => <-.y + <-.UIlabel_header.height;
	    width => <-.width - x;
	    height = 33;
	    value => <-.value;
	    mode = 1;
	    active => <-.active;
	    updateMode => <-.updateMode;
	 };
	 int+OPort2 height=> UIfield.y + UIfield.height - y;
};

// The UIoptionMenuLabel macro is not supported yet.  It is used by the
// Read_Column_File, Table_to_Scatter_Field, and Table_to_Uniform_Field
// modules.

macro UIoptionMenuLabel {
    ilink	parent;
    imlink	labels;
    int+IPort2	selectedItem;
    string	title	=> name_of(<-,1);
    int		visible	=  1;
    int		active;

    int		x	= 0;		// input
    int		y	= 0;		// input
    int		width	= 200;
    int		height	= 30;

    int		labelWidth = 50;

    label_cmd label_cmd {
	labels => <-.labels;
	inItem => <-.selectedItem;
    };
    int selectedArray[];

    GMOD.parse_v parse_v {
       	v_commands = "selectedArray=init_array(array_size(labels),0,0);
		      int temp=>selectedArray[selectedItem];
		      temp = 1;";
	no_errors = 1;
       	imlink+nres trigger => {<-.selectedItem, <-.labels};
       	on_inst = 1;
       	relative => <-.<-;
    };

    UIoptionMenu UIoptionMenu {
	parent		=> <-.parent;
	label		=> <-.title;
	cmdList		=> <-.label_cmd.cmd;
	&selectedItem	=> <-.label_cmd.outItem;
	&visible	=> <-.visible;
	&active		=> <-.active;
	x 		=> <-.x;
	y		=> <-.y;
	width		=> <-.width;
	height		=> <-.height;
    };
};

// UIerror_display
macro UIerrorDisplay {
    ilink	parent;
    string+IPort2+read message = "";
    string+write current_messages = "";
    string+write message_log = "";
    int current_messages_nl = 5;
    int message_nl = 5; // number of newlines in message
    int message_log_nl = 5; // total number of lines
    string	title	=> name_of(<-,1);

    int		x	= 100;
    int		y	= 100;
    int		width	= 500;
    int		height	= 300;

    // virtualHeight gets reset if we set this too small..
    int win_height => max_array({height,current_messages_nl * 15});

    UItemplateDialog top {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
      title  => <-.title;
      visible = 0;
      autoUnmanage = 0;
      cancelLabelString = "Close";
      okLabelString = "Clear";
      update<status=0>;
      inst<status=0>;
    };
    UIbutton show_log {
      parent => top;
      label = "Show Log";
      update<status=0>;
    };
    UIbutton show_current_msg {
      parent => top;
      label = "Current Msg";
      update<status=0>;
    };
    UIpanel panel {
      parent => top;
      x      => 0;
      y      => 0;
      width  => top.clientWidth-1;
      height => top.clientHeight-1;
      update<status=0>;
    };
    UIlabel title_label {
      label  => <-.title;
      parent => panel;
      x = 0;
      y = 0;
      width  => panel.width;
      update<status=0>;
    };
    UIframe frame {
      parent => panel;
      x      = 0;
      y      => title_label.y + title_label.height + 4;
      width  => panel.clientWidth;
      height => panel.clientHeight - y;
      update<status=0>;
    };
    UIscrolledWindow scrollwin {
      parent => frame;
      width  => frame.clientWidth;
      height => frame.clientHeight;
      virtualWidth+nres = 1000;
      virtualHeight+nres => win_height;
      resizeMode = 1;	// don't move the virtual size
      update<status=0>;
    };
    UItext text {
      parent => scrollwin;
      width => scrollwin.virtualWidth;
      height => scrollwin.virtualHeight;
      text   => <-.current_messages;
      outputOnly = 1;
      multiLine = 1;
      int wordWrap = 1;	// Never have a error message truncated.
      update<status=0>;
    };
    GMOD.parse_v do_clear {
       	v_commands = <"
                      current_messages = "";
		      current_messages_nl = 0;
		      ">;
       	trigger => <-.top.ok;
       	on_inst = 0;
       	relative => <-.<-;
        parse_v_relative<status=0>;
    };
    GMOD.parse_v do_close {
       	v_commands = <"
                      current_messages = "";
		      current_messages_nl = 0;
                      top.visible = 0;
		      ">;
       	trigger => <-.top.cancel;
       	on_inst = 0;
       	relative => <-.<-;
        parse_v_relative<status=0>;
    };
    GMOD.parse_v do_open {
       	v_commands = <"
		      message_log = message_log + message;
		      message_log_nl = message_log_nl + message_nl;
		      current_messages = current_messages + message;
		      current_messages_nl = current_messages_nl + message_nl;
                      top.visible = 1;
		      ">;
       	trigger => <-.message;
       	on_inst = 0;
       	relative => <-.<-;
        parse_v_relative<status=0>;
    };
    GMOD.parse_v do_curmsg {
       	v_commands = <"
                      current_messages = message;
		      current_messages_nl = message_nl;
		      ">;
       	trigger => <-.show_current_msg.do;
       	on_inst = 0;
       	relative => <-.<-;
        parse_v_relative<status=0>;
    };
    GMOD.parse_v do_show_log {
       	v_commands = <"
                      current_messages = message_log;
		      current_messages_nl = message_log_nl;
		      ">;
       	trigger => <-.show_log.do;
       	on_inst = 0;
       	relative => <-.<-;
        parse_v_relative<status=0>;
    };
};

UImod_register ModuleStack<locked=0> {
    macro ModuleStackUI <ui_global_class=1,NEvisible=0> {
	UIcmdList Modules<NEy=55,NEx=110,list_class="Modules"> {
	    radioBehavior = 1;
	};
	UIcmd Control<NEy=55,NEx=110>;
	UIcmdList Controls<NEy=185,NEx=110>{
	    cmdList     => {Control};
	};
	UIcmdList MainMenu<NEy=110,NEx=110> {
	    cmdList	=> { Modules, Controls };
	};
	UIshell mod_shell<NEy=165,NEx=110> {
	    title	=> name_of(<-.<-.<-);
	    visible	=  1;
	    x		=  0;
	    y		=  0;
	    width	=> UIdata.UIdisplays[0].width / 4;
	    height	=> UIdata.UIdisplays[0].height * 5 / 6;
	    menu	=> MainMenu;
	};
	UIscrolledWindow mod_scroll {
	    x = 0;
	    y = 0;
	    parent	=> <-.mod_shell;
	    scrollBars	=  1;
	    width	=> <-.mod_shell.clientWidth;
	    height	=> <-.mod_shell.clientHeight;
	    virtualWidth => .width * 5;
	    virtualHeight=> .height * 5;
	};
	UIpanel mod_panel<NEy=220,NEx=110,widget_class="widget"> {
	    parent	=> <-.mod_scroll;
	    y		=  0;
	    width	=> <-.mod_scroll.virtualWidth;
	    height	=> <-.mod_scroll.virtualHeight;
	};
	UIshell control_shell<NEx=22,NEy=44>{
	    visible	=> Control.do;
	    width	=  250;
	    height	=  150;
	};
	UIslider status<NEx=275,NEy=264> {
	    parent	=> <-.control_shell;
	    value	=> Scheduler.percent_done;
	    x		=  4;
	    y		=  4;
	    width	=> <-.control_shell.clientWidth - 8;
	    height	=  32;
	    update<status=0>;
	};
	UItoggle control_toggle<NEx=627,NEy=264> {
	    parent	=> <-.control_shell;
	    label	=  "disable";
	    set		=> Scheduler.disable;
	    x		=  4;
	    y		=> <-.status.y + <-.status.height + 4;
	    width	=> <-.control_shell.clientWidth - 8;
	};
	UIlabel method<NEx=77,NEy=275> {
	    parent	=> <-.control_shell;
	    label	=> Scheduler.current_mod;
	    x		=  4;
	    y		=> <-.control_toggle.y + <-.control_toggle.height + 4;
	    width	=> <-.control_shell.clientWidth - 8;
	    update<status=0>;
	};
	UIdynamic_toggle UIdynamic_toggle<NEx=429,NEy=264> {
	    parent	=> <-.control_shell;
	    label	=  "interrupt";
	    set		=> Scheduler.interrupt;
	    x		=  4;
	    y		=> <-.method.y + <-.method.height + 4;
	    width	=> <-.control_shell.clientWidth - 8;
	};
	olink parent<NEy=286,NEx=231> => mod_panel;
    };
};


/* The UIfileBrowser macro consists of a UIpanel containing a UIlabel,
 * a UItext, and a UIbutton. The file dialog is set to popup each time
 * the macro is instanced. The button will popup the file dialog
 * asynch of instancing the macro. 
 */

macro UIfileBrowser {

   UIfileDialog UIfileDialog<NEportLevels={0,1}> {
      visible => <-.copy_on_change.output;
      ok = 1;
   };

   macro File_Browser_Panel<NEportLevels={0,1}> {
      UIbutton Browse {
         parent => <-.UIpanel;
         height = 32;
         label => "Browse...";
         y = 0;
         x<NEportLevels={2,0}> => (<-.File_Name_Str.x + <-.File_Name_Str.width);
         width = 76;
         active<NEportLevels={2,1}>;
         do<NEportLevels={0,3}>;
      };
      UIpanel UIpanel<NEx=506.,NEy=55.> {
         parent => <-.parent;
         y = 0;
	 x = 0;
         width<NEportLevels={2,0}> => <-.width;
         height<NEportLevels={1,0}> = 32;
      };
      UIlabel File_Name_Label {
         parent => <-.UIpanel;
         height => 32;
         label<NEportLevels={4,0}> => "File Name:";
         y = 0;
         width<NEportLevels={0,2}> = 70;
      };
      link parent<NEportLevels={3,1}>;
      link width<NEportLevels={3,1}>;
      UItext File_Name_Str {
         parent => <-.UIpanel;
         text<NEportLevels={3,3}> => <-.<-.UIfileDialog.filename;
         y = 0;
         x<NEportLevels={2,0}> => <-.File_Name_Label.width;
         width<NEportLevels={0,2}> => ((<-.UIpanel.clientWidth - <-.File_Name_Label.width) - <-.Browse.width);
         height = 32;
         showLastPosition = 1;
      };
   };
   GMOD.instancer instancer {
      Value => <-.visibility;
      Group => <-.File_Browser_Panel;
   };
   GMOD.copy_on_change copy_on_change {
      trigger => <-.File_Browser_Panel.Browse.do;
      input => <-.visibility;
      output = 0;
   };
   int visibility<NEportLevels={2,1}>;
   link file_name<NEportLevels={1,2}> => File_Browser_Panel.File_Name_Str.text;
};


macro UIsummaryPanel {

   string demo_name => name_of(<-.<-);
   string demo_text => str_format("The %s demo shows how you use %s",
                                   demo_name, demo_name);
   // HTML helpfile triggered by the Help button.
   string helpfile;

   UImod_panel Summary;

   UIlabel UIlabel {
      parent => <-.Summary;
      label => str_format("AVS/Express %s Example", demo_name);
      y = 0;
      height => (2 * UIdata.UIfonts[0].lineHeight);
      width  => parent.clientWidth;
      fontAttributes {
         weight = "bold";
      };
   };

   UItext UItext {
      parent => <-.Summary;
      y => UIlabel.height + 5;
      width => parent.clientWidth;
      // height = 180;
      color {
         backgroundColor = "#aaaabb";
      };
      fontAttributes {
         weight = "bold";
      };
      text => demo_text;
#ifdef MSDOS
      rows = 9;
#else
      rows = 11;
#endif
      multiLine = 1;
      outputOnly = 1;
      updateMode = 0;
   };

   macro UIbuttonHtml {	  
      link parent<NEportLevels={2,1}> => <-.Summary;
      UIbutton Help {
         parent => <-.parent;
         x => ((parent.clientWidth / 2) - width / 2);
         y => <-.<-.UItext.y + <-.<-.UItext.height + 10;
         active => is_valid(<-.UIlaunchBrowser.filename);
      };
      UIlaunchBrowser UIlaunchBrowser {
         trigger => <-.Help.do;         
         filename => <-.<-.helpfile;
         use_helppath = 1;
      };
   };

   UIbutton Exit_Example {
      parent => <-.Summary;	 
      x => <-.UIbuttonHtml.Help.x;
      y => <-.UIbuttonHtml.Help.y + <-.UIbuttonHtml.Help.height + 10;
   };

   GMOD.parse_v parse_v {
      v_commands => str_format("- %s;", demo_name);
      trigger => <-.Exit_Example.do;
      on_inst = 0;
      relative => <-.<-.<-.<-;	// parent of the application
   };

}; // UIsummaryPanel

};
