/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ui_samp.v#1 $
*/

/*******************************************************************************
 *
 *  Display the Control Widgets
 *
 ******************************************************************************/
macro UIApp<NEy=20,NEx=20> {
    /* Create an application */

    /* Create the menu of commands to pop up dialogs */

    UIoption doButtons <NEy=180, NEx=50> {
        label = "Buttons";
        message = "Show Button Widget Samples";
    };

    UIoption doValuators <NEy=220, NEx=50> {
        label = "Valuators";
        message = "Show Valuator Widget Samples";
    };

    UIoption doOptions <NEy=260, NEx=50> {
        label = "Options";
        message = "Show Option Wiget Samples";
    };

    UIoption doText <NEy=300, NEx=50> {
        label = "Text";
        message = "Show Text Widget Samples";
    };

    UIoption doLists <NEy =340, NEx=50> {
    	label = "Lists";
	message = "Show List Widget Samples";
    };

    UIcmd doFSB <NEy=420, NEx=50> {
        label = "File Selection Box...";
        message = "Pop up a File Selection Box dialog";
    };

    UIcmd doMsgBox <NEy=460, NEx=50> {
        label = "Message Box...";
        message = "Pop up a Message Box dialog";
    };

    UIcmd doPromptBox <NEy=500, NEx=50> {
        label = "Prompt Box...";
        message = "Pop up a Prompt Box dialog";
    };

    UIcmd doSelBox <NEy=540, NEx=50> {
        label = "Selection Box...";
        message = "Pop up a Selection Box dialog";
    };

    UIcmd doMulSelBox <NEy=580, NEx=50> {
        label = "MultiSelection Box...";
        message = "Pop up a MultiSelection Box dialog";
    };

    UIcmdList uiDialogs <NEy=340, NEy=50> {
        label = "Dialogs";
        cmdList => { doMsgBox, doPromptBox, doSelBox, doMulSelBox, doFSB };
    };

    UImenuSeparator separator1<NEy=380, NEx=50>;

    UIcmdList uiSamples <NEy=140, NEx=40> {
        label = "UI Samples";
        cmdList => { doButtons, doValuators, doOptions, doText, doLists, separator1, uiDialogs };
	radioBehavior = 1;
    };

    UIoption doToggle<NEy=60, NEx=365> {
    	label = "Toggle";
	message = "This is a Toggle item";
    };

    UImenuSeparator sep1<NEy=100, NEx=365>;

    UIoption radio1<NEy=140, NEx=365> {
    	label = "Radio1";
	message = "Select Item 1";
    };

    UIoption radio2<NEy=180, NEx=365> {
    	label = "Radio2";
	message = "Select Item 2";
    };

    UIoption radio3<NEy=220, NEx=365> {
    	label = "Radio3";
	message = "Select Item 3";
    };

    UIcmdList subRadio<NEy=260, NEx=365> {
    	label = "Radio Items";
	radioBehavior = 1;
  	cmdList => { radio1, radio2, radio3 };
    };

    UImenuSeparator sep2<NEy=300, NEx=365>;

    UIcmd doDisabled<NEy=340, NEx=365> {
        label = "Disabled";
	message = "Disabled Item";
	active = 0;
    };

    UIcmdList menuSamples<NEy=20, NEx=365> {
        label = "Menu Samples";
	cmdList => { doToggle, sep1, subRadio, sep2, doDisabled };

    };

    UIcmdList mainMenu <NEy=100, NEx=50> {
        cmdList => { uiSamples, menuSamples };
    };

    UIapp UIsamplerApp <NEy=20,NEx=20> {
        title = "UI Sampler Application";
        x = 100;
        y = 100;
        width = 400;
        height = 300;
        menu => mainMenu;
    };

    /***************************************************************************
     *  Buttons
     **************************************************************************/
    macro Buttons <NEx=220, NEy=180> {

    	UIpanel btns <NEy=100, NEx=200> {
	    x = 4;
	    y = 4;
    	    width => UIsamplerApp.clientWidth - 8;
	    height => UIsamplerApp.clientHeight - 8;

            parent<NEportLevels={3,0}> => UIsamplerApp;
	    visible => doButtons.set;
            rowColumnBehavior = 1;
    	};

    	UIlabel label#1 <NEy=250,NEx=220> {
            label = "UIbutton";
            parent => btns;
    	};

    	UIbutton button#1 <NEy=300,NEx=220> {
            parent => btns;
            label = "button 1";
        };

    	UIbutton button#2 <NEy=350,NEx=220> {
            parent => btns;
            label = "button 2";
    	};

    	UIbutton button#3 <NEy=400,NEx=220> {
		    width = 50;
			height = 50;
            parent => btns;
            label = "button 3";
	    labelPixmap.filename = "$XP_PATH<0>/runtime/pixmaps/copy.xbm";
	    labelPixmap.fileType = "x_bitmap";
    	};

    	/***********************************************************************
     	* Toggle
     	***********************************************************************/

    	UIpanel tglPanel <NEy=475,NEx=200> {
    	    x = 0;
	    y = 120;
            width => btns.width;
	    height => btns.height;
            parent => btns;
            rowColumnBehavior = 1;
    	};

    	UIlabel label#8 <NEy=525,NEx=220> {
            label = "UItoggle";
            parent => tglPanel;
    	};

    	UItoggle toggle#1<NEy=575,NEx=220> {
            parent => tglPanel;
            label = "toggle 1";
    	};

    	UItoggle toggle#2<NEy=625,NEx=220> {
            parent => tglPanel;
            label = "toggle 2";
    	};

       	UItoggle toggle#3<NEy=675,NEx=220> {
            parent => tglPanel;
            label = "toggle 3";
    	};

    }; /* Buttons macro */

    /*------------------------------------------------------------------------*/
    /*------------------------------------------------------------------------*/

    /* *************************************************************************
     *  Valuators
     **************************************************************************/
    macro Valuators <NEy=220, NEx=220> {

    	UIpanel valPanel <NEy=100, NEx=350>  {
	    x = 4;
	    y = 4;
    	    width => UIsamplerApp.clientWidth - 8;
	    height => UIsamplerApp.clientHeight - 8;
            parent<NEportLevels={3,0}> => UIsamplerApp;
	    visible => doValuators.set;
	    rowColumnBehavior = 1;
    	};

    	/***********************************************************************
     	*  Dials
     	***********************************************************************/
    	UIpanel dialPanel <NEy=200,NEx=350> {
    	    x = 0;
	    y = 0;
	    width => valPanel.width / 2;
	    height = 200;
            parent => valPanel;
	    rowColumnBehavior = 1;
    	};

    	UIdial UIdial<NEy=300,NEx=370> {
           parent => dialPanel;
       	};

    	/***********************************************************************
     	*  Field
     	***********************************************************************/
    	UIpanel fldPanel <NEy=375,NEx=350> {
    	    x => valPanel.width /2;
	    y = 0;
	    width => valPanel.width / 2;
	    height = 100;
            parent => valPanel;
	    rowColumnBehavior = 1;
      	};

    	UIlabel label#3 <NEy=425,NEx=370> {
            label = "UIfield";
            parent => fldPanel;
    	};

    	UIfield field<NEy=475,NEx=370> {
            parent => fldPanel;
            value => UIdial.value;
    	};

    	/***********************************************************************
     	* Slider
     	***********************************************************************/
    	UIpanel sliderPanel <NEy=550,NEx=350> {
    	    x => valPanel.width / 2;
	    y = 100;
	    width => valPanel.width / 2;
	    height = 100;
            parent => valPanel;
	    rowColumnBehavior = 1;
    	};

    	UIlabel label#6 <NEy=600,NEx=370> {
            label = "UIslider";
            parent => sliderPanel;
        };

    	UIslider slider<NEy=650,NEx=370> {
    	    width => sliderPanel.width;
            parent => sliderPanel;
            value => UIdial.value;
     	};
     }; /* Valuators macro */

    /*------------------------------------------------------------------------*/
    /*------------------------------------------------------------------------*/

    /***************************************************************************
     *  Options
     **************************************************************************/
     macro Options <NEy=260, NEx=220> {

	UIpanel optPanel {
	    x = 4;
	    y = 4;
	    width => UIsamplerApp.clientWidth - 8;
	    height => UIsamplerApp.clientHeight - 8;
	    parent<NEportLevels={3,0}> => UIsamplerApp;
	    visible => doOptions.set;
	};

    	/***********************************************************************
     	*  Option Box
     	***********************************************************************/

    	UIlabel label#4 <NEy=250,NEx=520> {
            label = "UIoptionBox";
            parent => optPanel;
    	};

	UIframe optionFrame {
	    x = 0;
	    y => UIdata.UIfonts[0].lineHeight;
	    width = 100;
	    height => <-.optionBox.height + 8;
	    parent => optPanel;
	};

    	UIoption option#1<NEy=350,NEx=540> {
            label = "Option 1";
    	};

    	UIoption option#2<NEy=400,NEx=540> {
            label = "Option 2";
    	};

    	UIoption option#3<NEy=450,NEx=540> {
            label = "Option 3";
    	};

    	UIoptionBox optionBox<NEy=300,NEx=520> {
            parent => optionFrame;
            cmdList => {option#1,option#2,option#3};
	    selectedItems[] = {0, 2};
    	};

    	/***********************************************************************
     	* Radio Box 
     	***********************************************************************/

    	UIlabel label#5 <NEy=575,NEx=520> {
	    x = 0;
	    y = 100;
            label = "UIradioBox";
            parent => optPanel;
    	};

	UIframe radioFrame {
	    x = 0;
	    y => 100 + UIdata.UIfonts[0].lineHeight;
	    width = 100;
	    height => <-.radioBox.height +8;
	    parent => optPanel;
	};

    	UIoption option#4<NEy=625,NEx=540> {
            label = "Option 4";
    	};

    	UIoption option#5<NEy=675,NEx=540> {
            label = "Option 5";
    	};

    	UIoption option#6<NEy=725,NEx=540> {
            label = "Option 6";
    	};

    	UIradioBox radioBox<NEy=775,NEx=520> {
            parent => radioFrame;
            cmdList => {option#4,option#5,option#6};
	    selectedItem = 0;
    	};
    }; /* Options Macro */

    /*------------------------------------------------------------------------*/
    /*------------------------------------------------------------------------*/

    /***************************************************************************
     * Text 
     **************************************************************************/
     macro Text <NEy=300, NEx=220> {

	UIpanel textPanel<NEy=60, NEx=650> {
	    x = 4;
	    y = 4;
	    width => UIsamplerApp.clientWidth - 8;
	    height => UIsamplerApp.clientHeight - 8;
	    parent<NEportLevels={3,0}> =>  UIsamplerApp;
	    visible => doText.set;
	};

	UIframe textFrame {
	    width => textPanel.width;
	    height => textPanel.height;
	    parent => textPanel;
	    shadowType = 0;
	};

    	UIlabel label#7 <NEy=250,NEx=670> {
	   x = 4;
	   y = 0;
           label = "UItext";
           parent => textFrame;
    	};

    	UItext text<NEy=300,NEx=670> {
	   x = 4;
	   //y => UIdata.UIfonts[0].lineHeight;
	   y => <-.label#7.y + <-.label#7.height + 2;
	   height => UIdata.UIfonts[0].lineHeight + 4;
           columns = 12;
           parent => textFrame;
	   text = "Sample Text";
    	};

	UIlabel labelMulti<NEy=340, NEx=670> {
	    x = 4;
	    y = 60;
	    label = "MultiLine Text";
	    parent => textFrame;
	};

	UItext textMulti<NEy=380, NEx=670> {
	    x = 4;
	    y => UIdata.UIfonts[0].lineHeight + 60;
	    width = 100;
	    height => (UIdata.UIfonts[0].lineHeight * 4) + 4;
	    parent => textFrame;
	    multiLine = 1;
	    text = "This is a\nsample of\nmulti-line\ntext";
	};

    }; /* Text macro */


    macro Lists <NEy=340, NEx=220> {

	UIpanel listPanel<NEx=11,NEy=11> {
	    x = 4;
	    y = 4;
	    width => UIsamplerApp.clientWidth - 8;
	    height => UIsamplerApp.clientHeight - 8;
	    parent<NEportLevels={3,0}> => UIsamplerApp;
	    visible => doLists.set;
	};

	UIframe listFrame<NEx=165,NEy=55> {
   	    parent => listPanel;
   	    width => listPanel.width;
   	    height => listPanel.height;
   	    shadowType = 0;
	};

#ifdef MSDOS
	UIcomboBox UIcomboBox<NEx=308,NEy=121> {
   	    parent => <-.listFrame;
   	    x = 4;
   	    y => UIdata.UIfonts[0].lineHeight;
   	    width = 150;
	    selectedItem = 0;
	    strings[4] = { "Item1", "Item2", "Item3", "Item4" };
	};
	UIlabel UIlabel<NEx=308,NEy=88> {
   	    parent => <-.listFrame;
   	    label = "Combo Box";
   	    x = 4;
	};
#else
	UIlabel UIlabel<NEx=308,NEy=88> {
   	    parent => <-.listFrame;
   	    label = "Option Menu";
   	    x = 4;
	};
	Commands.UIoption UIoption<NEx=660,NEy=143> {
		label = "Item1";
	};
	Commands.UIoption UIoption#1<NEx=660,NEy=99> {
		label = "Item2";
	};
	Commands.UIoption UIoption#2<NEx=660,NEy=55> {
		label = "Item3";
	};
	Commands.UIoption UIoption#3<NEx=660,NEy=11> {
		label = "Item4";
	};
	UIoptionMenu OptionMenu<NEx=682,NEy=220> {
		parent => <-.listFrame;
		cmdList => {<-.UIoption,
		<-.UIoption#1,<-.UIoption#2,<-.UIoption#3};
		x = 4;
		selectedItem = 0;
	};

#endif

	UIlabel ListLabel<NEx=308,NEy=154> {
   	    parent => <-.listFrame;
   	    label = "List";
   	    x = 4;
   	    y = 50;
	};

	UIlist UIlist<NEx=308,NEy=187,NEwidth=198,NEheight=220> {
   	    parent => <-.listFrame;
   	    height => 6 * UIdata.UIfonts[0].lineHeight;
   	    x = 4;
   	    y => <-.ListLabel.y + <-.ListLabel.height;
   	    width = 150;
	    selectedItem = 0;
	    strings[6] = { "Item1", "Item2", "Item3", "Item4", "Item5", "Item6" };
	};

	UIlabel MultiListLabel<NEx=500,NEy=154> {
   	    parent => <-.listFrame;
   	    label = "MultiList";
   	    x => UImultiList.x;
   	    y => ListLabel.y;
	};

	UImultiList UImultiList<NEx=500,NEy=187,NEwidth=198,NEheight=220> {
   	    parent => <-.listFrame;
   	    height => 6 * UIdata.UIfonts[0].lineHeight;
   	    x => <-.UIlist.x + <-.UIlist.width + 10;
   	    y => <-.MultiListLabel.y + <-.MultiListLabel.height;
   	    width = 150;
	    strings[6] = { "Item1", "Item2", "Item3", "Item4", "Item5", "Item6" };
	};


    };
    /*------------------------------------------------------------------------*/
    /*------------------------------------------------------------------------*/

    /***************************************************************************
     * Dialogs 
     **************************************************************************/

    UImessageBox mbDialog <NEy = 420, NEx=300> {
        title = "Modal Message Dialog";
        parent => UIsamplerApp;
        type = "information";
        message = "This is a message. You must select a button to continue.";
        visible => doMsgBox.do;
        isModal = 1;
    };

    UIpromptBox pbDialog <NEy = 460, NEx=300> {
        title = "Prompt Dialog";
        prompt = "This is a prompt. Enter some text:";
        visible => doPromptBox.do;
    };

    UIselectionBox sbDialog <NEy = 500, NEx=300> {
        title = "Selection Dialog";
        visible => doSelBox.do;
        prompt = "Pick some fruit:";
        strings => { "apples", "oranges", "bananas" };
    };

    UImultiSelBox msbDialog <NEy = 540, NEx=300> {
        title = "Multi Selection Dialog";
        visible => doMulSelBox.do;
        prompt = "Pick some fruit:";
        strings => { "apples", "oranges", "bananas", 
                     "cherries", "strawberries" };
    };

    UIfileSB fsbDialog <NEy=380, NEx=300> {
        title = "File Selection Dialog";
        parent => UIsamplerApp;
        visible => doFSB.do;
    };
};
