/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/view.v#2 $
*/

/***********************************************************************/
/* Defines for icon positions                                          */
/***********************************************************************/
flibrary+global VIEW<needs_edit_lic="GD",compile_subs=0> {

#define X1 22
#define X2 187
#define X3 352
#define X4 517
#define X5 682
#define X6 847

#define Y1 22
#define Y2 88
#define Y3 154
#define Y4 220
#define Y5 286
#define Y6 352
#define Y7 418

#define YI  Y1
#define YO  Y7

library Compat<NEvisible=0,user_library=0> {
   GD.DataObject DataObject;
   GD.GroupObject GroupObject;
   GD.DataObjects DataObjects;
};

/***********************************************************************/
/* Graphics display ocomponents                                        */
/***********************************************************************/

/* Stick all macro modules with UI components in their own library */
library+global+sort+buffered Components {

   /*****************************/
   /* Color Popup Macro Module */
   /*****************************/
   macro ColorPopup {
      /* inputs */
      ilink name;
      ilink vis;
      ilink red;
      ilink green;
      ilink blue;

      GMOD.instancer ColorInst {
	 Group => <-.ColorUI;
	 Value+nres => <-.vis;
      };
      macro ColorUI<instanced=0> {

	 UItemplateDialog color_shell {
	    title+IPort2 = "Color Editor";
	    width	= 225;
#ifdef MSDOS
	    height	= 210;
#else
	    height	= 265;
#endif
	    visible => vis;
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel color_panel {
	    parent => color_shell;
	    x = 5;
	    y = 5;
	    width => <-.color_shell.clientWidth - 10;
	    height => <-.color_shell.clientHeight - 10;
	 };
	 UIlabel color_label {
	    parent => color_panel;
	    label => name;
	    alignment = 1;
	    x	= 4;
	    y	= 4;
	    width	=> <-.color_panel.clientWidth - 8;
	 };
	 UIslider color_red_slider {
	    parent => color_panel;
	    title = "Red";
	    min = 0;
	    max = 1;
	    value => red;
	    x	=  4;
	    y	=> <-.color_label.y + <-.color_label.height + 4;
	    width	=> <-.color_panel.clientWidth - 8;
	 };
	 color_red_slider color_green_slider {
	    title	=  "Green";
	    value	=> green;
	    y	=> <-.color_red_slider.y + <-.color_red_slider.height + 4;
	 };
	 color_red_slider color_blue_slider {
	    title	=  "Blue";
	    value	=> blue;
	    y	=> <-.color_green_slider.y + <-.color_green_slider.height + 4;
	 };
      };
   };

   /*******************************/
   /* Material Popup Macro Module */
   /*******************************/
   macro MaterialPopup {
      /* inputs */
      ilink name;
      ilink vis;
      ilink ambient;
      ilink diffuse;
      ilink spec;
      ilink spec_exp;
      ilink trans;

      GMOD.instancer MaterialInst {
	 Group => <-.MaterialUI;
	 Value+nres => <-.vis;
      };
      macro MaterialUI<instanced=0> {

	 UItemplateDialog mat_shell {
	    title+IPort2 => name;
	    width = 225;
#ifdef MSDOS
	    height = 280;
#else
	    height = 400;
#endif
	    visible => vis;
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel mat_panel {
	    parent => mat_shell;
	    x = 5;
	    y = 5;
	    width => <-.mat_shell.clientWidth - 10;
	    height => <-.mat_shell.clientHeight - 10;
	 };

	 UIlabel mat_label {
	    parent => mat_panel;
	    label => name;
	    alignment = 1;
	    x	= 4;
	    y	= 4;
	    width	=> <-.mat_panel.clientWidth - 8;
	 };
	 UIslider mat_amb_slider {
	    parent => mat_panel;
	    title = "Ambient";
	    min = 0;
	    max = 1;
	    value => ambient;
	    x	=  4;
	    y	=> <-.mat_label.y + <-.mat_label.height + 4;
	    width	=> <-.mat_panel.clientWidth - 8;
	 };
	 mat_amb_slider mat_diff_slider {
	    title = "Diffuse";
	    value => diffuse;
	    y	=> <-.mat_amb_slider.y + <-.mat_amb_slider.height + 4;
	 };
	 mat_amb_slider mat_spec_slider {
	    title = "Specular";
	    value => spec;
	    y	=> <-.mat_diff_slider.y + <-.mat_diff_slider.height + 4;
	 };
	 mat_amb_slider mat_specexp_slider {
	    title = "Specular Exponent";
	    min = 1;
	    max = 100;
	    value => spec_exp;
	    y	=> <-.mat_spec_slider.y + <-.mat_spec_slider.height + 4;
	 };
	 mat_amb_slider mat_trans_slider {
	    title = "Transparency";
	    value => trans;
	    y	=> <-.mat_specexp_slider.y + <-.mat_specexp_slider.height + 4;
	 };
      };
   };

   /*************************************/
   /* Geom Attribute Popup Macro Module */
   /*************************************/
   macro GeomAttribPopup {
      /* inputs */
      ilink name;
      ilink vis;
      ilink dir_pt_size;
      ilink subdiv;
      ilink cull;
      ilink jitter;

      GMOD.instancer GeomAttrInst {
	 Group => <-.GeomAttrUI;
	 Value+nres => <-.vis;
      };
      macro GeomAttrUI<instanced=0> {

	 UItemplateDialog geom_shell {
	    title => name;
	    visible => vis;
	    width	=  250;
#ifdef MSDOS
	    height = 310;
#else
	    height = 400;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel geom_panel {
	    parent => geom_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.geom_shell.clientWidth - 8;
	    height	=> <-.geom_shell.clientHeight - 8;
	 };
	 UIlabel geom_label {
	    parent => geom_panel;
	    label => name;
	    alignment = 1;
	    y	=  0;
	    width	=> <-.geom_panel.width;
	 };
	 UIslider geom_dir_pt {
	    parent => geom_panel;
	    title = "Glyph Size";
	    max = 5.0;
	    value => dir_pt_size;
	    x	=  0;
	    y	=> <-.geom_label.y + <-.geom_label.height + 4;
	    width	=> <-.geom_panel.width;

	 };
	 UIslider geom_subdiv {
	    parent => geom_panel;
	    title = "Subdivision";
	    mode = 1;
            min = 1;
	    max = 20;
	    value => subdiv;
	    x	=  0;
	    y	=> <-.geom_dir_pt.y + <-.geom_dir_pt.height + 4;
	    width	=> <-.geom_panel.width;
	 };
	 UIframe geom_cull_frame {
	    parent => geom_panel;
	    y	=> <-.geom_subdiv.y + <-.geom_subdiv.height + 4;
	    width	=> <-.geom_panel.width;
	    height	=> <-.geom_cull_rb.y + <-.geom_cull_rb.height + 6;
	 };
	 UIlabel geom_cull_label {
	    parent => geom_cull_frame;
	    label = "Cull Mode";
	    alignment = 1;
	    x = 4;
	    y	=  0;
	    width	=> <-.geom_cull_frame.clientWidth - 8;
	 };
	 UIoption geom_cull_none {
	    label = "None";
	    message = "No face cull or normal flip.";
	 };
	 UIoption geom_cull_back {
	    label = "Cull Back";
	    message = "Cull back faces.";
	 };
	 UIoption geom_cull_front {
	    label = "Cull Front";
	    message = "Cull front faces.";
	 };
	 UIoption geom_cull_flip {
	    label = "Flip Normals";
	    message = "Flip normals";
	 };
	 UIradioBox geom_cull_rb {
	    parent => geom_cull_frame;
	    cmdList => { geom_cull_none,  geom_cull_back, 
			 geom_cull_front, geom_cull_flip };
	    selectedItem => cull;
	    x	=  4;
	    y	=> <-.geom_cull_label.y + <-.geom_cull_label.height + 4;
	    width	=> <-.geom_cull_frame.clientWidth - 8;
	 };
         UIslider geom_jitter {
            parent => geom_panel;
            title  = "Jitter Level";
            mode   =  1;
            min    = -5;
            max    =  5;
            value  => jitter;
            x      =  0;
            y      => <-.geom_cull_frame.y + <-.geom_cull_frame.height + 4;
            width  => <-.geom_panel.width;
         };
      };
   };

   /*************************************/
   /* Vol Attribute Popup Macro Module */
   /*************************************/
   macro VolAttribPopup {
      /* inputs */
      ilink name;
      ilink vis;
      ilink vox_interp;
      ilink ray_algo;
      ilink ray_norm;
      ilink fat_ray;

      GMOD.instancer VolAttrInst {
	 Group => <-.VolAttrUI;
	 Value+nres => <-.vis;
      };
      macro VolAttrUI<instanced=0> {

	 UItemplateDialog vol_shell {
	    title => name;
	    visible => vis;
	    width	=  250;
#ifdef MSDOS
	    height = 360;
#else
	    height = 435;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel vol_panel {
	    parent => vol_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.vol_shell.clientWidth - 8;
	    height	=> <-.vol_shell.clientHeight - 8;
	 };
	 UIlabel vol_label {
	    parent => vol_panel;
	    label => name;
	    alignment = 1;
	    y	=  0;
	    width	=> <-.vol_panel.width;
	 };
	 UIframe vox_interp_frame {
	    parent => vol_panel;
	    y	=> <-.vol_label.y + <-.vol_label.height + 4;
	    width	=> <-.vol_panel.width;
	    height	=> <-.vox_interp_rb.y + <-.vox_interp_rb.height + 6;
	 };
	 UIlabel vox_interp_label {
	    parent => vox_interp_frame;
	    label = "Voxel Interpolation";
	    alignment = 1;
	    x = 4;
	    y = 0;
	    width	=> <-.vox_interp_frame.clientWidth - 8;
	 };
	 UIoption vox_interp_point {
	    label = "Point";
	    message = "Point sampled voxels.";
	 };
	 UIoption vox_interp_trilinear {
	    label = "Trilinear";
	    message = "Trilinear voxel interpolation.";
	 };
         /*
	 UIoption vox_interp_tricubic {
	    label = "Tricubic";
	    message = "Tricubic voxel interpolation.";
	 };
         */
	 UIradioBox vox_interp_rb {
	    parent => vox_interp_frame;
	    cmdList => { vox_interp_point, vox_interp_trilinear
                         /* ,vox_interp_tricubic */ };
	    selectedItem => vox_interp;
	    x	=  4;
	    y	=> <-.vox_interp_label.y + <-.vox_interp_label.height + 4;
	    width => <-.vox_interp_frame.clientWidth - 8;
	 };

         UIframe ray_algo_frame {
            parent => vol_panel;
            y   => <-.vox_interp_frame.y + <-.vox_interp_frame.height + 4;
            width       => <-.vol_panel.width;
            height      => <-.ray_algo_rb.y + <-.ray_algo_rb.height + 6;
         };
         UIlabel ray_algo_label {
            parent => ray_algo_frame;
            label = "Ray Tracer Algorithm";
            alignment = 1;
            x = 4;
            y = 0;
            width       => <-.ray_algo_frame.clientWidth - 8;
         };
         UIoption ray_algo_direct {
            label = "Direct Compositing";
            message = "Direct compositing of voxel colors";
         };
         UIoption ray_algo_average {
            label = "Average Value";
            message = "Average voxel value along ray.";
         };
         UIoption ray_algo_maxvalue {
            label = "Maximum Value";
            message = "Maximum value encountered by the ray.";
         };
         UIoption ray_algo_distmax {
            label = "Distance to Maximum";
            message = "Distance to maximum value along ray.";
         };
         UIoption ray_algo_sfp {
            label = "SFP";
            message = "Simulated Fluorescence Process.";
         };
         UIradioBox ray_algo_rb {
            parent => ray_algo_frame;
            cmdList => { ray_algo_direct, ray_algo_average,
                         ray_algo_maxvalue, ray_algo_distmax,
			 ray_algo_sfp };
            selectedItem => ray_algo;
            x   =  4;
            y   => <-.ray_algo_label.y + <-.ray_algo_label.height + 4;
            width => <-.ray_algo_frame.clientWidth - 8;
         };

         UIframe ray_norm_frame {
            parent => vol_panel;
            y   => <-.ray_algo_frame.y + <-.ray_algo_frame.height + 4;
            width       => <-.vol_panel.width;
            height      => <-.ray_norm_rb.y + <-.ray_norm_rb.height + 6;
         };
         UIlabel ray_norm_label {
            parent => ray_norm_frame;
            label = "Ray Distance Normalization";
            alignment = 1;
            x = 4;
            y = 0;
            width => <-.ray_norm_frame.clientWidth - 8;
         };
         UIoption ray_norm_global {
            label = "Global";
            message = "Scale to volume extents.";
         };
         UIoption ray_norm_view {
            label = "View";
            message = "Scale to min/max of this projection.";
         };
         UIoption ray_norm_ray {
            label = "Ray";
            message = "Scale to min/max of each ray.";
         };
         UIradioBox ray_norm_rb {
            parent => ray_norm_frame;
            cmdList => { ray_norm_global, ray_norm_view, ray_norm_ray };
            selectedItem => ray_norm;
            x   =  4;
            y   => <-.ray_norm_label.y + <-.ray_norm_label.height + 4;
            width => <-.ray_norm_frame.clientWidth - 8;
         };

         UIframe fat_ray_frame {
            parent => vol_panel;
            y     => <-.ray_norm_frame.y + <-.ray_norm_frame.height + 4;
            width       => <-.vol_panel.width;
            height      => <-.fat_ray_toggle.height + 6;
         };
         UItoggle fat_ray_toggle {
            parent => fat_ray_frame;
            label = "Fat ray";
            message = "Use an accelerated 4x4 block ray.";
            &set => fat_ray;
            x = 4;
            y = 0;
            width => <-.fat_ray_frame.clientWidth - 8;
         };
      };
   };

   /*************************************/
   /* Line Attribute Popup Macro Module */
   /*************************************/
   macro LineAttribPopup {
      /* inputs */
      ilink name;
      ilink vis;
      ilink draw_mode;
      ilink line_width;
      ilink line_style;
      ilink line_aa;

      GMOD.instancer LineAttrInst {
	 Group => <-.LineAttrUI;
	 Value+nres => <-.vis;
      };
      macro LineAttrUI<instanced=0> {

	 UItemplateDialog line_attrib_shell {
	    title => name;
	    visible => vis;
	    width = 225;
#ifdef MSDOS
	    height = 310;
#else
	    height = 385;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel line_attrib_panel {
	    parent => line_attrib_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.line_attrib_shell.clientWidth - 8;
	    height	=> <-.line_attrib_shell.clientHeight - 8;
	 };
	 UIlabel line_attrib_label {
	    parent => line_attrib_panel;
	    label => name;
	    alignment = 1;
	    y		=  0;
	    width	=> <-.line_attrib_panel.width;
	 };

	 UIframe line_draw_frame {
	    parent => line_attrib_panel;
	    y		=> <-.line_attrib_label.y+<-.line_attrib_label.height+4;
	    width	=> <-.line_attrib_panel.width;
	    height	=> <-.line_draw_rb.y + <-.line_draw_rb.height + 6;
	 };
	 UIlabel line_draw_label {
	    parent => line_draw_frame;
	    label = "Drawing Mode";
	    alignment = 1;
	    x		=  4;
	    y		=  0;
	    width	=> <-.line_draw_frame.clientWidth - 8;
	 };
	 UIoption line_draw_copy {
	    label = "Copy";
	    message = "Draw line in copy mode.";
	 };
	 UIoption line_draw_xor {
	    label = "Xor";
	    message = "Draw line in xor mode.";
	 };
	 UIradioBox line_draw_rb {
	    parent => line_draw_frame;
	    cmdList => { line_draw_copy, line_draw_xor};
	    selectedItem => draw_mode;
	    x		=  4;
	    y		=> <-.line_draw_label.y + <-.line_draw_label.height + 4;
	    width	=> <-.line_draw_frame.clientWidth - 8;
	 };

	 UItoggle line_aa_toggle {
	    parent => line_attrib_panel;
	    label = "Anti-aliasing";
	    message = "Switch line anti-aliasing mode on/off.";
	    &set => line_aa;
	    y		=> <-.line_draw_frame.y + <-.line_draw_frame.height + 4;
	    width	=> <-.line_attrib_panel.width;
	 };

	 UIslider line_attrib_width {
	    parent => line_attrib_panel;
	    title = "Line Width";
	    mode = 1;
	    max = 25;
	    value => line_width;
	    y		=> <-.line_aa_toggle.y + <-.line_aa_toggle.height + 4;
	    width	=> <-.line_attrib_panel.width;
	 };

	 UIframe line_style_frame {
	    parent => line_attrib_panel;
	    y		=> <-.line_attrib_width.y+<-.line_attrib_width.height+4;
	    width	=> <-.line_attrib_panel.width;
	    height	=> <-.line_style_rb.y + <-.line_style_rb.height + 6;
	 };
	 UIlabel line_style_label {
	    parent => line_style_frame;
	    label = "Line Style";
	    alignment = 1;
	    x		=  4;
	    y		=  0;
	    width	=> <-.line_style_frame.clientWidth - 8;
	 };
	 UIoption line_style_solid {
	    label = "Solid";
	    message = "Display solid line style";
	 };
	 UIoption line_style_dash {
	    label = "Dashed";
	    message = "Display dashed line style";
	 };
	 UIoption line_style_dot {
	    label = "Dotted";
	    message = "Display dotted line style";
	 };
	 UIoption line_style_dashdot {
	    label = "DashDot";
	    message = "Display dash-dot line style";
	 };
	 UIradioBox line_style_rb {
	    parent => line_style_frame;
	    cmdList => { line_style_solid, line_style_dash, 
			 line_style_dot,   line_style_dashdot };
	    selectedItem => line_style;
	    x		=  4;
	    y		=> <-.line_style_label.y + <-.line_style_label.height+4;
	    width	=> <-.line_style_frame.clientWidth - 8;
	 };
      };
   };

   /***********************************/
   /* Lights Attributes Popup Macro  */
   /***********************************/
   macro LightAttribPopup {
      ilink vis;
      ilink att1;
      ilink att2;
      ilink concen;
      ilink angle;

      GMOD.instancer LightAttrInst {
	 Group => <-.LightAttrUI;
	 Value+nres => <-.vis;
      };
      macro LightAttrUI<instanced=0> {

	 UItemplateDialog attrib_shell {
	    title = "Light Attributes Editor";
	    visible => vis;
	    width	= 225;
#ifdef MSDOS
	    height	= 240;
#else
	    height	= 325;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel attrib_panel {
	    parent => attrib_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.attrib_shell.clientWidth - 8;
	    height	=> <-.attrib_shell.clientHeight - 8;
	 };
	 UIlabel attrib_label {
	    parent => attrib_panel;
	    label = "Light Attributes";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.attrib_panel.width;
	 };
	 UIslider attrib_att1_slider {
	    parent => attrib_panel;
	    title = "Attenuation 1";
	    min = 1.0;
	    max = 10.0;
	    value => att1;
	    y	=> <-.attrib_label.y + <-.attrib_label.height + 4;
	    width	=> <-.attrib_panel.width;
	 };
	 attrib_att1_slider attrib_att2_slider {
	    title = "Attenuation 2";
	    min = 0.0;
	    max = 10.0;
	    value => att2;
	    y	=> <-.attrib_att1_slider.y + <-.attrib_att1_slider.height + 4;
	 };
	 attrib_att1_slider attrib_concen_slider {
	    title = "Concentration";
	    min = 0.0;
	    max = 50.0;
	    decimalPoints = 1;
	    value => concen;
	    y	=> <-.attrib_att2_slider.y + <-.attrib_att2_slider.height + 4;
	 };
	 attrib_att1_slider attrib_angle_slider {
	    title = "Spread Angle";
	    max = 180;
	    decimalPoints = 1;
	    value => angle;
	    y	=> <-.attrib_concen_slider.y + <-.attrib_concen_slider.height + 4;
	 };
      };
   };

   /********************************/
   /* Depth Cue Popup Macro Module */
   /********************************/
   macro DepthCuePopup {
      ilink vis;
      ilink enable;
      ilink front;
      ilink back;
      ilink scale;

      GMOD.instancer DepthCueInst {
	 Group => <-.DepthCueUI;
	 Value+nres => <-.vis;
      };
      macro DepthCueUI<instanced=0> {

	 UItemplateDialog depth_cue_shell {
	    title+IPort2 = "Depth Cue Editor";
	    visible => vis;
	    width	=  225;
#ifdef MSDOS
	    height	=  230;
#else
	    height	=  295;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel depth_cue_panel {
	    parent => depth_cue_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.depth_cue_shell.clientWidth - 8;
	    height	=> <-.depth_cue_shell.clientHeight - 8;
	 };
	 UIlabel depth_cue_label {
	    parent => depth_cue_panel;
	    label = "Depth Cue Editor";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.depth_cue_panel.width;
	 };
	 /* depth cue enable toggle */
	 UItoggle depth_cue_toggle {
	    parent => depth_cue_panel;
	    label = "Depth Cue";
	    message = "Enable depth cueing.";
	    Boolean+IPort2 &set => enable;
	    y	=> <-.depth_cue_label.y + <-.depth_cue_label.height + 4;
	 };
	 UIslider depth_front_slider {
	    parent => depth_cue_panel;
	    title = "Depth Front";
	    max = 20.0;
	    value => front;
	    y	=> <-.depth_cue_toggle.y + <-.depth_cue_toggle.height + 4;
	    width	=> <-.depth_cue_panel.width;
	 };
	 depth_front_slider depth_back_slider {
	    title = "Depth Back";
	    value => back;
	    y	=> <-.depth_front_slider.y + <-.depth_front_slider.height + 4;
	 };
	 depth_front_slider depth_scale_slider {
	    title = "Depth Scale";
	    max = 1.0;
	    value => scale;
	    y	=> <-.depth_back_slider.y + <-.depth_back_slider.height + 4;
	 };
      };
   };

   /*****************************************/
   /* Surface Conversion Popup Macro Module */
   /*****************************************/
   macro SurfConvPopup {
      /* inputs */
      ilink name;
      ilink vis;
      ilink surf_conv;
      ilink chunk;
      ilink surf_chunk;
      ilink line_chunk;
      ilink tmap_method;
      ilink tri_subdiv_type;
      ilink tri_subdiv_aval;
      ilink tri_subdiv_fval;

      GMOD.instancer SurfConvInst {
	 Group => <-.SurfConvUI;
	 Value+nres => <-.vis;
      };
      macro SurfConvUI<instanced=0> {

	 UItemplateDialog surf_shell {
	    title+IPort2 => name;
	    visible => vis;
	    width	= 225;
#ifdef MSDOS
	    height	= 240;
#else
#ifdef XGL_RENDERER
	    height	= 510;
#else
	    height	= 260;
#endif
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };

	 UIpanel surf_panel {
	    parent => surf_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.surf_shell.clientWidth - 8;
	    height	=> <-.surf_shell.clientHeight - 8;
	 };
	 UIlabel surf_label {
	    parent => surf_panel;
	    label = "Surface Conversion";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.surf_panel.width;
	 };
	 UIframe conv_frame {
	    parent => surf_panel;
	    y	=> <-.surf_label.y + <-.surf_label.height + 4;
	    width	=> <-.surf_panel.width;
	    height	=> <-.surfconv_rb.y + <-.surfconv_rb.height + 6;
	 };
	 UIlabel conv_label {
	    parent => conv_frame;
	    label = "Conversion Type";
	    alignment = 0;
	    x	=  4;
	    y	=  0;
	    width	=> <-.surf_frame.clientWidth - 8;
	 };
	 UIoption surfconv_simple {
	    label = "Simple";
	    message = "Simple surface conversion.";
	 };
	 UIoption surfconv_optimal {
	    label = "Optimal";
	    message = "Optimal surface conversion.";
	 };
	 UIradioBox surfconv_rb {
	    parent => conv_frame;
	    cmdList => { surfconv_simple, surfconv_optimal };
	    selectedItem => surf_conv;
	    x	=  4;
	    y	=> <-.surf_label.y + <-.surf_label.height + 4;
	    width	=> <-.conv_frame.clientWidth - 8;
	 };
	 UItoggle surfconv_chunk {
	    parent => surf_panel;
	    label = "Chunking";
	    message = "Enable/Disable surface conversion chunking";
	    &set => chunk;
	    y	=> <-.conv_frame.y + <-.conv_frame.height + 4;
	 };
	 UIfieldTypein surfchunk_size {
	    UIparent => surf_panel;
	    flabel = "Surface Chunk";
	    fval => surf_chunk;
	    fmin = 100;
	    fmax = 100000;
	    field.width = 75;
	    field.mode = 1;
	    label.alignment = 0;
	    label.alignment = 0;
	    x		=  0;
	    y		=> <-.surfconv_chunk.y+<-.surfconv_chunk.height+4;
	    width	=> <-.surf_panel.width;
	    height	=> field.height;
	 };
	 UIfieldTypein linechunk_size {
	    UIparent => surf_panel;
	    flabel = "Line Chunk";
	    fval => line_chunk;
	    fmin = 100;
	    fmax = 100000;
	    field.width = 75;
	    field.mode = 1;
	    label.alignment = 0;
	    x		=  0;
	    y		=> <-.surfchunk_size.y + <-.surfchunk_size.height + 4;
	    width	=> <-.surf_panel.width;
	    height	=> field.height;
	 };

#ifdef XGL_RENDERER
	 UIframe tmap_method_frame {
	    parent => surf_panel;
	    y	=> <-.linechunk_size.y + <-.linechunk_size.height + 10;
	    width	=> <-.surf_panel.width;
	    height	=> <-.tmap_method_rb.y + <-.tmap_method_rb.height + 6;
	 };
	 UIlabel tmap_method_label {
	    parent => tmap_method_frame;
	    label = "Texture Mapping Method";
	    alignment = 0;
	    x	=  4;
	    y	=  0;
	    width	=> <-.tmap_method_frame.clientWidth - 8;
	 };
	 UIoption tmap_method_normal {
	    label = "Normal";
	    message = "Normal Texture Mapping.";
	 };
	 UIoption tmap_method_VLTM {
	    label = "VLTM";
	    message = "Vertex Level Texture Mapping.";
	 };
	 UIradioBox tmap_method_rb {
	    parent => tmap_method_frame;
	    cmdList => { tmap_method_normal, tmap_method_VLTM };
	    selectedItem => tmap_method;
	    x	=  4;
	    y	=> <-.tmap_method_label.y + <-.tmap_method_label.height + 4;
	    width	=> <-.tmap_method_frame.clientWidth - 8;
	 };

	 UIframe tri_subdiv_frame {
	    parent => surf_panel;
	    y	=> <-.tmap_method_rb.y + <-.<-.tmap_method_rb.height + 6;
	    width	=> <-.surf_panel.width;
	    height	=> <-.tri_subdiv_rb.y + <-.tri_subdiv_rb.height + 6;
	 };
	 UIlabel tri_subdiv_label {
	    parent => tri_subdiv_frame;
	    label = "Triangle Subdivision";
	    alignment = 0;
	    x	=  4;
	    y	=  0;
	    width	=> <-.tri_subdiv_frame.clientWidth - 8;
	 };
	 UIoption tri_subdiv_adaptive {
	    label = "Adaptive";
	    message = "Adaptive Subdivision.";
	 };
	 UIoption tri_subdiv_fixed {
	    label = "Fixed";
	    message = "Fixed Subdivision.";
	 };
	 UIradioBox tri_subdiv_rb {
	    parent => tri_subdiv_frame;
	    cmdList => { tri_subdiv_adaptive, tri_subdiv_fixed };
	    selectedItem => tri_subdiv_type;
	    x	=  4;
	    y	=> <-.tri_subdiv_label.y + <-.tri_subdiv_label.height + 4;
	    width	=> <-.tri_subdiv_frame.clientWidth - 8;
	 };
	 UIfieldTypein tri_subdiv_adaptive_val {
	    UIparent => surf_panel;
	    flabel = "Adaptive Value";
	    fval => tri_subdiv_aval;
	    fmin = 1;
	    fmax = 100;
	    field.width = 75;
	    field.mode = 1;
	    panel.y => <-.<-.tri_subdiv_frame.y + <-.<-.tri_subdiv_frame.height + 4;
	    label.alignment = 0;
	 };
	 UIfieldTypein tri_subdiv_fixed_val {
	    UIparent => surf_panel;
	    flabel = "Fixed Value";
	    fval => tri_subdiv_fval;
	    fmin = 1;
	    fmax = 1000;
	    field.width = 75;
	    field.mode = 1;
	    panel.y => <-.<-.tri_subdiv_adaptive_val.y + <-.<-.tri_subdiv_adaptive_val.height + 4;
	    label.alignment = 0;
	 };
#endif
      };
   };

   /***************************************/
   /* Image Attributes Popup Macro Module */
   /***************************************/
   macro ImageAttrPopup {
      /* inputs */
      ilink name;
      ilink vis;
      ilink dith_tech;
      ilink interp_type;
      ilink missing_val;
      ilink missing_red;
      ilink missing_green;
      ilink missing_blue;

      GMOD.instancer ImageAttrInst {
	 Group => <-.ImageAttrUI;
	 Value+nres => <-.vis;
      };
      macro ImageAttrUI<instanced=0> {

	 UItemplateDialog image_shell {
	    title+IPort2 => name;
	    visible => vis;
	    width	= 225;
#ifdef MSDOS
	    height	= 280;
#else
#ifdef XIL_RENDERER
            height      = 380;
#else
	    height	= 340;
#endif
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel image_panel {
	    parent => image_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.image_shell.clientWidth - 8;
	    height	=> <-.image_shell.clientHeight - 8;
	 };
	 UIlabel image_label {
	    parent => image_panel;
	    label => name;
	    alignment = 1;
	    y	=  0;
	    width	=> <-.image_panel.width;
	 };

	 UIframe dith_frame {
	    parent => image_panel;
	    y	=> <-.image_label.y + <-.image_label.height + 4;
	    width	=> <-.image_panel.width;
	    height	=> <-.dith_rb.y + <-.dith_rb.height + 6;
	 };
	 UIlabel dith_label {
	    parent => dith_frame;
	    label = "Dither Technique";
	    alignment = 0;
	    x	=  4;
	    y	=  0;
	    width	=> <-.dith_frame.clientWidth - 8;
	 };
	 UIoption dith_cube {
	    label = "Cube";
	    message = "Dither using color cube.";
	 };
	 UIoption dith_ramp {
	    label = "Ramp";
	    message = "Dither using ramp.";
	 };
	 UIradioBox dith_rb {
	    parent => dith_frame;
	    cmdList => { dith_cube, dith_ramp };
	    selectedItem => dith_tech;
	    x	=  4;
	    y	=> <-.dith_label.y + <-.dith_label.height + 4;
	    width	=> <-.dith_frame.clientWidth - 8;
	 };

	 UIframe interp_frame {
	    parent => image_panel;
	    y	=> <-.dith_frame.y + <-.dith_frame.height + 4;
	    width	=> <-.image_panel.width;
	    height	=> <-.interp_rb.y + <-.interp_rb.height + 6;
	 };
	 UIlabel interp_label {
	    parent => interp_frame;
	    label = "Interpolation Type";
	    alignment = 0;
	    x	=  4;
	    y	=  0;
	    width	=> <-.interp_frame.clientWidth - 8;
	 };
	 UIoption interp_point {
	    label = "Point";
	    message = "Point interpolation.";
	 };
	 UIoption interp_bilinear {
	    label = "Bilinear";
	    message = "Bilinear interpolation.";
	 };
#ifdef XIL_RENDERER
	 UIoption interp_bicubic {
	    label = "Bicubic";
	    message = "Bicubic interpolation.";
	 };
#endif
	 UIoption interp_flat {
	    label = "Flat";
	    message = "Flat interpolation.";
	 };
	 UIoption interp_smooth {
	    label = "Smooth";
	    message = "Smooth interpolation.";
	 };

	 UIoption interp_point_image {
	    label = "Point/Image";
	    message = "Point interpolation, image extent.";
	 };
	 UIoption interp_bilinear_image {
	    label = "Bilinear/Image";
	    message = "Bilinear interpolation, image extent.";
	 };
#ifdef XIL_RENDERER
	 UIoption interp_bicubic_image {
	    label = "Bicubic/Image";
	    message = "Bicubic interpolation, image extent.";
	 };
#endif

	 UIradioBox interp_rb {
	    parent => interp_frame;
#ifndef XIL_RENDERER
	    cmdList => { interp_point, interp_bilinear, interp_flat, interp_smooth, interp_point_image, interp_bilinear_image };
#else
	    cmdList => { interp_point, interp_bilinear, interp_bicubic, interp_flat, interp_smooth, interp_point_image, interp_bilinear_image };
#endif
	    selectedItem => interp_type;
	    x	=  4;
	    y	=> <-.interp_label.y + <-.interp_label.height + 4;
	    width	=> <-.interp_frame.clientWidth - 8;
	 };

	 UIslider miss_val {
	    parent => image_panel;
	    title = "Missing Scalar Value";
	    min = 0;
	    max = 255;
	    value => missing_val;
	    y	=> <-.interp_frame.y + <-.interp_frame.height + 4;
	    width	=> <-.image_panel.width;
	 };
	 UIbutton miss_rgb {
	    parent => image_panel;
	    label = "Missing RGB...";
	    message = "Edit missing RGB color value";
	    y	=> <-.miss_val.y + <-.miss_val.height + 4;
	    width	=> <-.image_panel.width;
	 };

	 ColorPopup MissingRGB {
	    name = "Missing RGB Color Editor";
	    vis => miss_rgb.do;
	    red => missing_red;
	    green => missing_green;
	    blue => missing_blue;
	 };
      };
   };

   /**************************************************/
   /* Alternate Object Attributes Popup Macro Module */
   /**************************************************/
   macro AltObjAttrPopup {
      /* inputs */
      GDobject_templ &altobj;
      ilink name;
      ilink vis;

      GMOD.instancer AltObjAttrInst {
	 Group => <-.AltObjAttrUI;
	 Value+nres => <-.vis;
      };
      macro AltObjAttrUI<instanced=0> {

	 UItemplateDialog altobj_shell {
	    title+IPort2 => name;
	    visible => vis;
	    width = 225;
#ifdef MSDOS
	    height = 175;
#else
	    height = 190;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel altobj_panel {
	    parent => altobj_shell;
	    x =  4;
	    y =  4;
	    width => <-.altobj_shell.clientWidth - 8;
	    height => <-.altobj_shell.clientHeight - 8;
	 };
	 UIlabel altobj_label {
	    parent => altobj_panel;
	    label => name;
	    alignment = 1;
	    y =  0;
	    width => <-.altobj_panel.clientWidth;
	 };
	 UItoggle altobj_vis {
	    parent => altobj_panel;
	    label = "Visible";
	    message = "Enable/Disable alternate object visibility";
	    &set => altobj.visible;
	    y => <-.altobj_label.y + <-.altobj_label.height + 4;
	    width => <-.altobj_panel.clientWidth;
	 };

	 UIframe altobj_frame {
	    parent => altobj_panel;
	    y => <-.altobj_vis.y + <-.altobj_vis.height + 4;
	    width => <-.altobj_panel.clientWidth;
	    height => <-.altobj_space_rb.y + <-.altobj_space_rb.height + 6;
	 };
	 UIlabel altobj_space_label {
	    parent => altobj_frame;
	    label = "Render Space";
	    alignment = 0;
	    x = 4;
	    y = 0;
	    width => <-.altobj_frame.clientWidth - 8;
	 };
	 UIoption space_match {
	    label = "Match Camera";
	    message = "Match render space of the camera.";
	 };
	 UIoption space_force {
	    label = "Force 2D";
	    message = "Force use of 2D primitives.";
	 };
	 UIradioBox altobj_space_rb {
	    parent => altobj_frame;
	    cmdList => { space_match, space_force };
	    selectedItem => altobj.space;
	    x =  4;
	    y => <-.altobj_space_label.y + <-.altobj_space_label.height + 4;
	    width => <-.altobj_frame.clientWidth - 8;
	 };
      };
   };

};		/* end of library Components */

library+global+sort+buffered UI_Editors {

   /*****************************/
   /* Object Editor Macro Module */
   /*****************************/
   macro ObjectEditor {
      /* inputs */
      GDcamera_templ &camera_in<NEportLevels={2,1}>;
      GDobject_templ &obj_in<NEportLevels={2,1}>;
      ilink vis;

      GDobj_edit obj_edit {
         shell_vis => vis;
	 camera => camera_in;
         object => obj_in;
      };

      GMOD.instancer ObjectEditorInst {
	 Group => <-.ObjectEditorUI;
	 Value+nres => <-.vis;
      };
      macro ObjectEditorUI<instanced=0> {

	 UItemplateDialog obj_shell {
	    title = "Object Editor";
	    visible => vis;
	    width	= 225;
	    height	= 440;
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel objedit_panel {
	    parent => obj_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.obj_shell.clientWidth - 8;
	    height	=> <-.obj_shell.clientHeight - 8;
	 };
	 UIlabel objedit_label {
	    parent => objedit_panel;
	    label = "Object Editor";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.objedit_panel.width;
	 };
	 UItoggle objedit_vis {
	    parent => objedit_panel;
	    label = "Visible";
	    message = "Enable/Disable object visibility";
	    &set => obj_edit.visible;
	    y	=> <-.objedit_label.y + <-.objedit_label.height + 4;
	    width	=> <-.objedit_panel.width;
	 };
	 objedit_vis objedit_pick {
	    label = "Pickable";
	    message = "Enable/Disable object pickability";
	    &set => obj_edit.pickable;
	    y	=> <-.objedit_vis.y + <-.objedit_vis.height + 4;
	 };
	 objedit_vis objedit_cache {
	    label = "Cached";
	    message = "Enable/Disable object caching";
	    &set => obj_edit.cached;
	    y	=> <-.objedit_pick.y + <-.objedit_pick.height + 4;
	 };
	 objedit_vis objedit_type {
	    label = "Dynamic";
	    message = "Static/Dynamic object";
	    &set => obj_edit.type;
	    y	=> <-.objedit_cache.y + <-.objedit_cache.height + 4;
	 };
	 objedit_type objedit_usealt {
	    label = "Enable Alternate Object";
	    message = "Enable/disable alternate object";
	    &set => obj_edit.use_altobj;
	    y	=> <-.objedit_type.y + <-.objedit_type.height + 4;
	 };

	 UIframe objmode_frame {
	    parent => objedit_panel;
	    y => <-.objedit_usealt.y + <-.objedit_usealt.height + 4;
	    width => <-.objedit_panel.width;
	    height => <-.obj_mode_rb.y + <-.obj_mode_rb.height + 6;
	 };
	 UIlabel objmode_label {
	    parent => objmode_frame;
	    label = "Transform Mode";
	    alignment = 0;
	    x =  4;
	    y =  0;
	    width => <-.objmode_frame.clientWidth - 8;
	 };
	 UIoption mode_normal {
	    label = "Normal";
	    message = "Normal transform mode.";
	 };
	 UIoption mode_parent {
	    label = "Parent";
	    message = "Parent transform mode.";
	 };
	 UIoption mode_alt {
	    label = "Alternate";
	    message = "Alternate transform mode.";
	 };
	 UIradioBox obj_mode_rb {
	    parent => objmode_frame;
	    cmdList => { mode_normal, mode_parent, mode_alt };
	    selectedItem => obj_edit.xform_mode;
	    x =  4;
	    y => <-.objmode_label.y + <-.objmode_label.height + 4;
	    width => <-.objmode_frame.clientWidth - 8;
	 };

	 UIbutton objedit_surf {
	    parent => objedit_panel;
	    label = "Surface Conversion...";
	    message = "Edit surface conversion properties.";
	    y => <-.objmode_frame.y + <-.objmode_frame.height + 4;
	    width => <-.objedit_panel.width;
	 };
	 UIbutton objedit_image {
	    parent => objedit_panel;
	    label = "Image Attributes...";
	    message = "Edit object image attributes.";
	    y => <-.objedit_surf.y + <-.objedit_surf.height + 4;
	    width => <-.objedit_panel.width;
	 };
	 UIbutton objedit_alt {
	    parent => objedit_panel;
	    label = "Alternate Object Attributes...";
	    message = "Edit alternate object attributes.";
	    y => <-.objedit_image.y + <-.objedit_image.height + 4;
	    width => <-.objedit_panel.width;
	 };

	 UIpanel obj_panel {
	    parent => objedit_panel;
	    y => <-.objedit_alt.y + <-.objedit_alt.height + 4;
	    width => <-.objedit_panel.width;
	    height => <-.objedit_reset.y + <-.objedit_reset.height;
	 };
	 UIbutton objedit_reset {
	    parent => obj_panel;
	    label = "Reset";
	    &do => obj_edit.reset;
	    y	=  0;
	    width	=  60;
	 };
	 UIbutton objedit_norm {
	    parent => obj_panel;
	    label = "Normalize";
	    &do => obj_edit.normalize;
	    x	=  65;
	    y	=  0;
	    width	=  75;
	 };
	 UIbutton objedit_center {
	    parent => obj_panel;
	    label = "Center";
	    &do => obj_edit.center;
	    x	=  145;
	    y	=  0;
	    width	=  60;
	 };

	 /* popup surf conversion editor */
	 SurfConvPopup SurfConv {
	    name = "Surface Conversion Editor";
	    vis => objedit_surf.do;
	    surf_conv => obj_edit.surf_conv;
	    chunk => obj_edit.chunk;
	    surf_chunk => obj_edit.surf_chunk;
	    line_chunk => obj_edit.line_chunk;
	    tmap_method => obj_edit.tmap_method;
	    tri_subdiv_type => obj_edit.tri_subdiv_type;
	    tri_subdiv_aval => obj_edit.tri_subdiv_aval;
	    tri_subdiv_fval => obj_edit.tri_subdiv_fval;
	 };

	 /* popup image attributes editor */
	 ImageAttrPopup AttrImage {
	    name = "Image Attributes";
	    vis => objedit_image.do;
	    dith_tech => obj_edit.dith_tech;
	    interp_type => obj_edit.interp_type;
	    missing_val => obj_edit.missing_val;
	    missing_red => obj_edit.missing_red;
	    missing_green => obj_edit.missing_green;
	    missing_blue => obj_edit.missing_blue;
	 };

	 /* popup alternate object attributes editor */
         AltObjAttrPopup AltObjPopup {
            altobj+nres => obj_in.altobj;
	    name = "Alternate Object Attributes";
	    vis => objedit_alt.do;
	 };

      };
   };

   /*****************************/
   /* Xform Editor Macro Module */
   /*****************************/
   macro XformEditor {
      /* inputs */
      group+IMPort &obj_in {
	 GDxform_templ+OPort2 &xform;
      };
      ilink vis;

      int label_width = 65;

      GDxform_edit GDxform_editor {
	 int+IPort2 &shell_vis => vis;
	 scale = 1.0;
	 absolute = 1;
	 xform+nres => obj_in.xform;
      };

      GMOD.instancer XformEditorInst {
	 Group => <-.XformEditorUI;
	 Value+nres => <-.vis;
      };
      macro XformEditorUI<instanced=0> {

	 UItemplateDialog trans_shell {
	    title = "Transformation Editor";
	    visible => vis;
	    width = 475;
#ifdef MSDOS
	    height = 355;
#else
	    height = 460;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel trans_panel {
	    parent => trans_shell;
	    x		=  4;
	    y		=  4;
	    width	=> <-.trans_shell.clientWidth - 8;
	    height	=> <-.trans_shell.clientHeight - 8;
	 };
	 UIlabel trans_label {
	    parent => trans_panel;
	    label = "Transformation Editor";
	    alignment = 1;
	    y		=  0;
	    width	=> <-.trans_panel.width;
	 };
	 UIslider trans_xrot {
	    parent => trans_panel;
	    title = "X Rotation";
	    min = -180;
	    max = 180;
	    value => GDxform_editor.x_rot;
	    y		=> <-.trans_label.y + <-.trans_label.height + 4;
	    width	=> <-.trans_panel.width - 100;
	 };
	 UIfield trans_xrot_field {
	    parent => trans_panel;
	    min = -180;
	    max = 180;
	    value => <-.trans_xrot.value;
	    x		=> <-.trans_xrot.width + 10;
#ifndef MSDOS
	    y		=> <-.trans_xrot.y + 15;
#else
	    y		=> <-.trans_xrot.y + 1;
#endif
	    width	=  75;
	 };
	 trans_xrot trans_yrot {
	    title = "Y Rotation";
	    value => GDxform_editor.y_rot;
	    y		=> <-.trans_xrot.y + <-.trans_xrot.height + 4;
	 };
	 UIfield trans_yrot_field {
	    parent => trans_panel;
	    min = -180;
	    max = 180;
	    value => <-.trans_yrot.value;
	    x		=> <-.trans_yrot.width + 10;
#ifndef MSDOS
	    y		=> <-.trans_yrot.y + 15;
#else
	    y		=> <-.trans_yrot.y + 1;
#endif
	    width	=  75;
	 };
	 trans_xrot trans_zrot {
	    title = "Z Rotation";
	    value => GDxform_editor.z_rot;
	    y		=> <-.trans_yrot.y + <-.trans_yrot.height + 4;
	 };
	 UIfield trans_zrot_field {
	    parent => trans_panel;
	    min = -180;
	    max = 180;
	    value => <-.trans_zrot.value;
	    x		=> <-.trans_zrot.width + 10;
#ifndef MSDOS
	    y		=> <-.trans_zrot.y + 15;
#else
	    y		=> <-.trans_zrot.y + 1;
#endif
	    width	=  75;
	 };
	 UIslider trans_scale {
	    parent => trans_panel;
	    title = "Scale";
	    max = 64.0;
	    value => GDxform_editor.scale;
	    y		=> <-.trans_zrot.y + <-.trans_zrot.height + 4;
	    width	=> <-.trans_panel.width - 100;
	 };
	 UIfield trans_scale_field {
	    parent => trans_panel;
	    min = -180;
	    max = 180;
	    value => <-.trans_scale.value;
	    x		=> <-.trans_scale.width + 10;
#ifndef MSDOS
	    y		=> <-.trans_scale.y + 15;
#else
	    y		=> <-.trans_scale.y + 1;
#endif
	    width	=  75;
	 };

	 UIpanel xyztrans_panel {
	    parent => trans_panel;
	    y		=> <-.trans_scale.y + <-.trans_scale.height + 4;
	    width	=> <-.trans_panel.width;
	    height	=> <-.trans_xtrans.height;
	 };
	 UIlabel trans_xtrans_lab {
	    parent => xyztrans_panel;
	    label = "X Tran";
	    y		=> (<-.trans_xtrans.height - .height) / 2;
	    width	=> label_width;
	    alignment = 0;
	 };
	 UIfield trans_xtrans {
	    parent => xyztrans_panel;
	    value => GDxform_editor.x_trans;
	    x		=> <-.trans_xtrans_lab.x + <-.trans_xtrans_lab.width +5;
	    y		=  0;
	    width	=  75;
	 };
	 trans_xtrans_lab trans_ytrans_lab {
	    label = "Y Tran";
	    x		=> <-.trans_xtrans.x + <-.trans_xtrans.width + 5;
	 };
	 trans_xtrans trans_ytrans {
	    value => GDxform_editor.y_trans;
	    x		=> <-.trans_ytrans_lab.x + <-.trans_ytrans_lab.width +5;
	 };
	 trans_xtrans_lab trans_ztrans_lab {
	    label = "Z Tran";
	    x		=> <-.trans_ytrans.x + <-.trans_ytrans.width + 5;
	 };
	 trans_xtrans trans_ztrans {
	    value => GDxform_editor.z_trans;
	    x		=> <-.trans_ztrans_lab.x + <-.trans_ztrans_lab.width +5;
	 };

	 UIpanel xyzcent_panel {
	    parent => trans_panel;
	    y		=> <-.xyztrans_panel.y + <-.xyztrans_panel.height + 4;
	    width	=> <-.trans_panel.width;
	    height	=> <-.trans_xcent.height;
	 };
	 UIlabel trans_xcent_lab {
	    parent => xyzcent_panel;
	    label = "X Cent";
	    alignment = 0;
	    y		=> (<-.trans_xcent.height - .height) / 2;
	    width	=> label_width;
	 };
	 UIfield trans_xcent {
	    parent => xyzcent_panel;
	    value => GDxform_editor.x_cent;
	    x		=> <-.trans_xcent_lab.x + <-.trans_xcent_lab.width + 5;
	    y		=  0;
	    width	=  75;
	 };
	 trans_xcent_lab trans_ycent_lab {
	    label = "Y Cent";
	    x		=> <-.trans_xcent.x + <-.trans_xcent.width + 5;
	 };
	 trans_xcent trans_ycent {
	    value => GDxform_editor.y_cent;
	    x		=> <-.trans_ycent_lab.x + <-.trans_ycent_lab.width + 5;
	 };
	 trans_xcent_lab trans_zcent_lab {
	    label = "Z Cent";
	    x		=> <-.trans_ycent.x + <-.trans_ycent.width + 5;
	 };
	 trans_xcent trans_zcent {
	    value => GDxform_editor.z_cent;
	    x		=> <-.trans_zcent_lab.x + <-.trans_zcent_lab.width + 5;
	 };

	 UItoggle trans_abs {
	    parent => trans_panel;
	    label = "Absolute";
	    message = "Select absolute or relative transformation edit mode.";
	    &set => GDxform_editor.absolute;
	    y		=> <-.xyzcent_panel.y + <-.xyzcent_panel.height + 4;
	    width	=> <-.trans_panel.width;
	 };
	 UIbutton trans_reset {
	    parent => trans_panel;
	    label = "Reset";
	    &do => GDxform_editor.reset;
	    y		=> <-.trans_abs.y + <-.trans_abs.height + 4;
	    width	=> <-.trans_panel.width;
	  };
      };
   };

   /*****************************/
   /* Modes Editor Macro Module */
   /*****************************/
   macro ModesEditor {
      /* inputs */
      GDobject_templ+IMPort &obj_in {
	 GDmodes_templ+OPort2 &modes;
      };
      ilink vis;

      DV.DVswitch DVswitch {
	 in => {<-.obj_in.modes, <-.obj_in.altobj.modes};
         index = 0;
      };
      GDmodes_edit GDmodes_editor {
	 shell_vis => vis;
         modes => DVswitch.out;
      };

      GMOD.instancer ModesEditorInst {
	 Group => <-.ModesEditorUI;
	 Value+nres => <-.vis;
      };
      macro ModesEditorUI<instanced=0> {

	 UItemplateDialog modes_shell {
	    title = "Modes Editor";
	    visible => vis;
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	    width	= 425;
#ifdef MSDOS
#ifdef OGL_RENDERER
	    height	= 480;
#else
	    height	= 440;
#endif
#else
#ifdef OGL_RENDERER
            height      = 615;
#else
	    height      = 545;
#endif
#endif
	 };
	 UIpanel modes_panel {
	    parent => modes_shell;
	    x		=  4;
	    y		=  4;
	    width	=> <-.modes_shell.clientWidth - 8;
	    height	=> <-.modes_shell.clientHeight - 8;
	 };
	 UIlabel modes_label {
	    parent => modes_panel;
	    label = "Modes Editor";
	    alignment = 1;
	    y		=  0;
	    width	=> <-.modes_panel.width;
	 };

         UItoggle modes_edit {
            parent => modes_panel;
            label = "Edit Alternate Modes";
            message = "Edit alternate object modes.";
            &set => <-.<-.DVswitch.index;
            x = 4;
	    y => <-.modes_label.y + <-.modes_label.height + 4;
	    width => <-.modes_panel.clientWidth - 8;
         };

	 /* modes points editor */
	 UIframe point_frame {
	    parent => modes_panel;
	    x		=  0;
	    y		=> <-.modes_edit.y + <-.modes_edit.height + 10;
	    width	=> (<-.modes_panel.clientWidth - 10) / 2;
	    height	=> <-.point_rb.y + <-.point_rb.height + 6;
	 };
	 UIlabel point_label {
	    parent => point_frame;
	    label = "Points";
	    alignment = 1;
	    y		=  0;
	    width	=> <-.point_frame.clientWidth;
	 };
	 UIoption point_inherit {
	    label = "Inherit";
	    message = "Inherit points mode.";
	 };
	 UIoption point_none {
	    label = "None";
	    message = "No points displayed.";
	 };
	 UIoption point_pixel {
	    label = "Pixel";
	    message = "Points displayed.";
	 };
#ifdef OGL_RENDERER
	   UIoption point_directed {
	      label = "Directed Line";
	      message = "Directed lines displayed.";
	   };
	   UIoption point_arrow {
	      label = "Directed Arrow";
	      message = "Directed arrow displayed.";
	   };
	   UIoption point_cone {
	      label = "Directed Cone";
	      message = "Directed cone displayed.";
	   };
	   UIoption point_cross {
	      label = "Tangent Cross";
	      message = "Tangent cross displayed.";
	   };
#else
	   UIoption point_directed {
	      label = "Directed";
	      message = "Directed points displayed.";
	   };
#endif
	 UIradioBox point_rb {
	    parent => point_frame;
#ifdef OGL_RENDERER
	      cmdList => { point_inherit, point_none, point_pixel, point_directed,
			   point_arrow, point_cone, point_cross };
#else
	      cmdList => { point_inherit, point_none, point_pixel,
			   point_directed };
#endif
	    selectedItem => GDmodes_editor.points;
	    y		=> <-.point_label.y + <-.point_label.height + 4;
	    width	=> <-.point_frame.clientWidth;
	 };

	 /* modes lines editor */
	 UIframe line_frame {
	    parent => modes_panel;
	    x	=  0;
	    y	=> <-.point_frame.y + <-.point_frame.height + 10;
	    width	=> (<-.modes_panel.clientWidth - 10) / 2;
	    height	=> <-.line_rb.y + <-.line_rb.height + 6;
	 };
	 UIlabel line_label {
	    parent => line_frame;
	    label = "Lines";
	    alignment = 1;
	    y		=  0;
	    width	=> <-.line_frame.clientWidth;
	 };
	 UIoption line_inherit {
	    label = "Inherit";
	    message = "Inherit lines mode.";
	 };
	 UIoption line_none {
	    label = "None";
	    message = "No lines displayed.";
	 };
	 UIoption line_reg {
	    label = "Regular";
	    message = "Lines displayed.";
	 };
#ifdef OGL_RENDERER
	 UIoption line_tube {
	    label = "Tube";
	    message = "Tube lines displayed.";
	 };
	 UIoption line_directed {
	    label = "Arrow";
	    message = "Arrows displayed.";
	 };
	 UIoption line_ribbon {
	    label = "Ribbon";
	    message = "Ribbons displayed.";
	 };
#endif
	 UIradioBox line_rb {
	    parent => line_frame;
#ifdef OGL_RENDERER
	    cmdList => { line_inherit, line_none, line_reg, 
			 line_tube, line_directed, line_ribbon };
#else
	    cmdList => { line_inherit, line_none, line_reg };
#endif
	    selectedItem => GDmodes_editor.lines;
	    y		=> <-.line_label.y + <-.line_label.height + 4;
	    width	=> <-.line_frame.clientWidth;
	 };

	 /* modes surface editor */
	 UIframe surf_frame {
	    parent => modes_panel;
	    x		=> <-.point_frame.x + <-.point_frame.width + 10;
	    y		=> <-.modes_edit.y + <-.modes_edit.height + 10;
	    width	=> (<-.modes_panel.clientWidth - 10) / 2;
	    height	=> <-.surf_rb.y + <-.surf_rb.height + 6;
	 };
	 UIlabel surf_label {
	    parent => surf_frame;
	    label = "Surface";
	    alignment = 1;
	    y		=  0;
	    width	=> <-.surf_frame.clientWidth;
	 };
	 UIoption surf_inherit {
	     label = "Inherit";
	     message = "Inherit surface mode.";
	 };
	 UIoption surf_none {
	     label = "None";
	     message = "No surface displayed.";
	 };
	 UIoption surf_nolight {
	    label = "No Light";
	    message = "No lighting on surface.";
	 };
	 UIoption surf_flat {
	    label = "Flat";
	    message = "Flat shaded surface.";
	 };
	 UIoption surf_gouraud {
	    label = "Gouraud";
	    message = "Gouraud shaded surface.";
	 };
	 UIoption surf_back {
	    label = "Background";
	    message = "";
	 };
	 UIradioBox surf_rb {
	    parent => surf_frame;
	    cmdList => { surf_inherit, surf_none, surf_nolight, surf_flat,
			 surf_gouraud, surf_back };
	    selectedItem => GDmodes_editor.surf;
	    y		=> <-.surf_label.y + <-.surf_label.height + 4;
	    width	=> <-.surf_frame.clientWidth;
	 };

	 /* modes vol editor */
	 UIframe vol_frame {
	    parent => modes_panel;
	    x      => <-.point_frame.x + <-.point_frame.width + 10;
	    y      => <-.surf_frame.y + <-.surf_frame.height + 10;
	    width  => (<-.modes_panel.clientWidth - 10) / 2;
	    height => <-.vol_rb.y + <-.vol_rb.height + 6;
	 };
	 UIlabel vol_label {
	    parent => vol_frame;
	    label = "Volume";
	    alignment = 1;
	    y      =  0;
	    width  => <-.vol_frame.clientWidth;
	 };
	 UIoption vol_inherit {
	    label = "Inherit";
	    message = "Inherit volume mode.";
	 };
	 UIoption vol_none {
	    label = "None";
	    message = "No volumes displayed.";
	 };
	 UIoption vol_btf {
	    label = "BTF";
	    message = "BTF volume rendering displayed.";
	 };
	 UIoption vol_ray {
	    label = "Ray tracer";
	    message = "Ray tracing volume rendering displayed.";
	 };
	 UIradioBox vol_rb {
	    parent => vol_frame;
	    cmdList => { vol_inherit, vol_none, vol_btf, vol_ray };
	    selectedItem => GDmodes_editor.volume;
	    y      => <-.vol_label.y + <-.vol_label.height + 4;
	    width  => <-.vol_frame.clientWidth;
	 };

	 /* modes bounds editor */

	 UIframe bnd_frame {
	    parent => modes_panel;
	    x      => <-.point_frame.x + <-.point_frame.width + 10;
	    y      => <-.surf_frame.y + <-.surf_frame.height +
		      <-.vol_frame.height + 20;
	    width  => (<-.modes_panel.clientWidth - 10) / 2;
	    height => <-.bnd_rb.y + <-.bnd_rb.height + 6;
	 };
	 UIlabel bnd_label {
	    parent => bnd_frame;
	    label = "Bounds";
	    alignment = 1;
	    y      =  0;
	    width  => <-.bnd_frame.clientWidth;
	 };
	 UIoption bnd_inherit {
	    label = "Inherit";
	    message = "Inherit bounds mode.";
	 };
	 UIoption bnd_none {
	    label = "None";
	    message = "No bounds displayed.";
	 };
	 UIoption bnd_extents {
	    label = "Extents";
	    message = "Bounding extents displayed.";
	 };
	 UIradioBox bnd_rb {
	    parent => bnd_frame;
	    cmdList => { bnd_inherit, bnd_none, bnd_extents };
	    selectedItem => GDmodes_editor.bounds;
	    y      => <-.bnd_label.y + <-.bnd_label.height + 4;
	    width  => <-.bnd_frame.clientWidth;
	 };

         /* normals modes editor */
         UIframe norm_frame {
            parent => modes_panel;
            x   = 0;
            y   => <-.line_frame.y + <-.line_frame.height + 10;
            width       => (<-.modes_panel.clientWidth - 10) / 2;
            height      => <-.norm_rb.y + <-.norm_rb.height + 6;
         };
 	 UIlabel norm_label {
 	    parent => norm_frame;
 	    label = "Normals";
 	    alignment   = 1;
 	    y		= 0;
 	    width	=> <-.norm_frame.clientWidth;
 	 };
         UIoption norm_inherit {
            label = "Inherit";
            message = "Inherit normals mode.";
         };
         UIoption norm_none {
            label = "None";
            message = "No vertex normals are generated, use default facet normals.";
         };
         UIoption norm_vertex {
            label = "Vertex";
            message = "Vertex normals are generated.";
         };
         UIradioBox norm_rb {
            parent => norm_frame;
            cmdList => { norm_inherit, norm_none, norm_vertex };
            selectedItem => GDmodes_editor.normals;
            y           => <-.norm_label.y + <-.norm_label.height + 4;
            width       => <-.norm_frame.clientWidth;
         };
      };
   };

   /*****************************/
   /* Props Editor Macro Module */
   /*****************************/
   macro PropsEditor {
      /* inputs */
      GDobject_templ+IMPort &obj_in {
	 GDprops_templ+OPort2 &props;
      };
      ilink vis;

      DV.DVswitch DVswitch {
	 in => {<-.obj_in.props, <-.obj_in.altobj.props};
         index = 0;
      };
      GDprops_edit GDprops_editor {
	 shell_vis => vis;
         props => DVswitch.out;
      };

      GMOD.instancer PropsEditorInst {
	 Group => <-.PropsEditorUI;
	 Value+nres => <-.vis;
      };
      macro PropsEditorUI<instanced=0> {

	 UItemplateDialog props_shell {
	    title = "Properties Editor";
	    visible => vis;
	    width	=  225;
#ifdef MSDOS
	    height	=  390;
#else
	    height	=  380;  /* 330; */
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel props_panel {
	    parent => props_shell;
	    x = 4;
	    y = 4;
	    width => <-.props_shell.clientWidth - 8;
	    height => <-.props_shell.clientHeight - 8;
	 };
	 UIlabel props_label {
	    parent => props_panel;
	    label = "Properties Editor";
	    alignment = 1;
	    y = 0;
	    width => <-.props_panel.clientWidth;
	 };

         UItoggle props_edit {
            parent => props_panel;
            label = "Edit Alternate Properties";
            message = "Edit alternate object properties.";
            &set => <-.<-.DVswitch.index;
            x = 4;
	    y => <-.props_label.y + <-.props_label.height + 4;
	    width => <-.props_panel.clientWidth - 8;
         };
	 UIbutton props_prim_col {
	    parent => props_panel;
	    label = "Primary Color...";
	    message = "Edit properties primary color.";
	    x = 4;
	    y	=> <-.props_edit.y + <-.props_edit.height + 4;
	    width => <-.props_panel.clientWidth - 8;
	 };
	 props_prim_col props_hi_col1 {
	    label = "Highlight Color 1...";
	    message = "Edit properties highlight color 1.";
	    y	=> <-.props_prim_col.y + <-.props_prim_col.height + 4;
	 };
	 props_prim_col props_hi_col2 {
	    label = "Highlight Color 2...";
	    message = "Edit properties highlight color 2.";
	    y	=> <-.props_hi_col1.y + <-.props_hi_col1.height + 4;
	 };
	 props_prim_col props_mat {
	    label = "Material...";
	    message = "Edit properties material.";
	    y	=> <-.props_hi_col2.y + <-.props_hi_col2.height + 4;
	 };
	 props_prim_col props_spec_col {
	    label = "Specular Color...";
	    message = "Edit properties specular color.";
	    y	=> <-.props_mat.y + <-.props_mat.height + 4;
	 };
	 props_prim_col props_line_attrib {
	    label = "Line Attributes...";
	    message = "Edit properties line attributes.";
	    y	=> <-.props_spec_col.y + <-.props_spec_col.height + 4;
	 };
	 props_prim_col props_geom_attrib {
	    label = "Geometry Attributes...";
	    message = "Edit properties geometry attributes.";
	    y	=> <-.props_line_attrib.y + <-.props_line_attrib.height + 4;
	 };
	 props_prim_col props_vol_attrib {
	    label = "Volume Attributes...";
	    message = "Edit properties volume attributes.";
	    y	=> <-.props_geom_attrib.y + <-.props_geom_attrib.height + 4;
	 };
	 UItoggle props_inherit {
	    parent => props_panel;
	    label = "Inherit";
	    &set => GDprops_editor.inherit;
	    x =  4;
	    y => <-.props_vol_attrib.y + <-.props_vol_attrib.height + 4;
	    width => <-.props_panel.clientWidth - 8;
	 };
	 props_prim_col props_reset {
	    label = "Reset";
	    &do => GDprops_editor.reset;
	    y => <-.props_inherit.y + <-.props_inherit.height + 4;
	 };

	 /* popup primary color editor */
	 ColorPopup PropsPrimCol {
	    name = "Primary Color Editor";
	    vis => props_prim_col.do;
	    red => GDprops_editor.red;
	    green => GDprops_editor.green;
	    blue => GDprops_editor.blue;
	 };
	 /* popup highlight color 1 editor */
	 ColorPopup PropsHiCol1 {
	    name = "Highlight Color 1 Editor";
	    vis => props_hi_col1.do;
	    red => GDprops_editor.hi1_red;
	    green => GDprops_editor.hi1_green;
	    blue => GDprops_editor.hi1_blue;
	 };
	 /* popup highlight color 2 editor */
	 ColorPopup PropsHiCol2 {
	    name = "Highlight Color 2 Editor";
	    vis => props_hi_col2.do;
	    red => GDprops_editor.hi2_red;
	    green => GDprops_editor.hi2_green;
	    blue => GDprops_editor.hi2_blue;
	 };
	 /* popup material editor */
	 MaterialPopup PropsMaterial {
	    name = "Material Editor";
	    vis => props_mat.do;
	    ambient => GDprops_editor.ambient;
	    diffuse => GDprops_editor.diffuse;
	    spec => GDprops_editor.specular;
	    spec_exp => GDprops_editor.spec_exp;
	    trans => GDprops_editor.trans;
	 };
	 /* specular highlight color editor */
	 ColorPopup PropsSpecCol {
	    name = "Specular Color Editor";
	    vis => props_spec_col.do;
	    red => GDprops_editor.spec_red;
	    green => GDprops_editor.spec_green;
	    blue => GDprops_editor.spec_blue;
	 };
	 /* popup line attribute editor */
	 LineAttribPopup PropsLineAttrib {
	    name = "Line Attributes Editor";
	    vis => props_line_attrib.do;
	    draw_mode => GDprops_editor.draw_mode;
	    line_width => GDprops_editor.line_width;
	    line_style => GDprops_editor.line_style;
	    line_aa => GDprops_editor.line_aa;
	 };
	 /* popup geometry attribute editor */
	 GeomAttribPopup PropsGeomAttrib {
	    name = "Geometry Attributes Editor";
	    vis => props_geom_attrib.do;
	    dir_pt_size => GDprops_editor.dir_pt_size;
	    subdiv => GDprops_editor.subdiv;
	    cull => GDprops_editor.cull;
            jitter => GDprops_editor.jitter;
	 };
	 /* popup volume attribute editor */
	 VolAttribPopup PropsVolAttrib {
	    name = "Volume Attributes Editor";
	    vis => props_vol_attrib.do;
	    vox_interp => GDprops_editor.voxel_interp;
	    ray_algo =>   GDprops_editor.ray_algo;
	    ray_norm =>   GDprops_editor.ray_norm;
	    fat_ray =>    GDprops_editor.fat_ray;
	 };
      };
   };

   /*****************************/
   /* Texture Editor Macro Module */
   /*****************************/
   macro TextureEditor {
      /* inputs */
      GDobject_templ+IMPort &obj_in {
	 GDtexture_templ+OPort2 &texture;
      };
      ilink vis;

      GDtexture_edit GDtexture_edit {
         shell_vis => vis;
         texture => obj_in.texture;
      };

      GMOD.instancer TextureEditorInst {
	 Group => <-.TextureEditorUI;
	 Value+nres => <-.vis;
      };
      macro TextureEditorUI<instanced=0> {

	 UItemplateDialog texture_shell {
	    title = "Texture Editor";
	    visible => vis;
	    width	= 225;
#ifdef MSDOS
	    height	= 390;
#else
	    height = 490;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel texture_panel {
	    parent => texture_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.texture_shell.clientWidth - 8;
	    height	=> <-.texture_shell.clientHeight - 8;
	 };
	 UIlabel texture_label {
	    parent => texture_panel;
	    label = "Texture Editor";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.texture_panel.width;
	 };

	 UIframe text_filt_frame {
	    parent => texture_panel;
	    y	=> <-.texture_label.y + <-.texture_label.height + 4;
	    width	=> <-.texture_panel.width;
	    height => <-.text_filter.y + <-.text_filter.height + 6;
	 };
	 UIlabel text_filt_label {
	    parent => text_filt_frame;
	    label = "Filter";
	    alignment = 0;
	    y	=  0;
	    width	=> <-.texture_filt_frame.clientWidth;
	 };
	 UIoption text_point {
	    label = "Point";
	    message = "Point filtering.";
	 };
	 UIoption text_bilinear {
	    label = "Bilinear";
	    message = "Bilinear filtering.";
	 };
	 UIoption text_trilinear {
	    label = "Trilinear";
	    message = "Trilinear filtering.";
	 };
	 UIradioBox text_filter {
	    parent => text_filt_frame;
	    cmdList => { text_point, text_bilinear, text_trilinear };
	    selectedItem => GDtexture_edit.filter;
	    y	=> <-.text_filt_label.y + <-.text_filt_label.height + 4;
	    width	=> <-.text_filt_frame.clientWidth;
	 };

	 UIframe text_tile_frame {
	    parent => texture_panel;
	    y	=> <-.text_filt_frame.y + <-.text_filt_frame.height + 4;
	    width	=> <-.texture_panel.width;
	    height => <-.text_tile.y + <-.text_tile.height + 6;
	 };
	 UIlabel text_tile_label {
	    parent => text_tile_frame;
	    label = "Tile";
	    alignment = 0;
	    y	=  0;
	    width	=> <-.texture_tile_frame.clientWidth;
	 };
	 UIoption text_clamp {
	    label = "Clamp";
	 };
	 UIoption text_wrap {
	    label = "Wrap";
	 };
	 UIoption text_boundary {
	    label = "Boundary";
	 };
	 UIradioBox text_tile {
	    parent => text_tile_frame;
	    cmdList => { text_clamp, text_wrap, text_boundary };
	    selectedItem => GDtexture_edit.tile;
	    y	=> <-.text_tile_label.y + <-.text_tile_label.height + 4;
	    width	=> <-.text_tile_frame.clientWidth;
	 };

	 UIframe text_alpha_frame {
	    parent => texture_panel;
	    y	=> <-.text_tile_frame.y + <-.text_tile_frame.height + 4;
	    width	=> <-.texture_panel.width;
	    height => <-.text_alpha.y + <-.text_alpha.height + 6;
	 };
	 UIlabel text_alpha_label {
	    parent => text_alpha_frame;
	    label = "Alpha";
	    alignment = 0;
	    y	=  0;
	    width	=> <-.texture_alpha_frame.clientWidth;
	 };
	 UIoption text_replace {
	    label = "Replace";
	 };
	 UIoption text_modulate {
	    label = "Modulate";
	 };
	 UIoption text_decal {
	    label = "Decal";
	 };
	 UIradioBox text_alpha {
	    parent => text_alpha_frame;
	    cmdList => { text_replace, text_modulate, text_decal };
	    selectedItem => GDtexture_edit.alpha;
	    y	=> <-.text_alpha_label.y + <-.text_alpha_label.height + 4;
	    width	=> <-.text_alpha_frame.clientWidth;
	 };

	 UIframe text_type_frame {
	    parent => texture_panel;
	    y	=> <-.text_alpha_frame.y + <-.text_alpha_frame.height + 4;
	    width	=> <-.texture_panel.width;
	    height => <-.text_type.y + <-.text_type.height + 6;
	 };
	 UIlabel text_type_label {
	    parent => text_type_frame;
	    label = "Type";
	    alignment = 0;
	    y	=  0;
	    width	=> <-.texture_type_frame.clientWidth;
	 };
	 UIoption text_unfiltered {
	    label = "Unfiltered";
	    message = "Unfiltered texture map.";
	 };
	 UIoption text_mipmap {
	    label = "MipMap";
	    message = "MipMapped texture map.";
	 };
	 UIradioBox text_type{
	    parent => text_type_frame;
	    cmdList => { text_unfiltered, text_mipmap };
	    selectedItem => GDtexture_edit.type;
	    y	=> <-.text_type_label.y + <-.text_type_label.height + 4;
	    width	=> <-.text_type_frame.clientWidth;
	 };
      };
   };


   /**************************************/
   /* Simple Datamap Editor Macro Module */
   /**************************************/
   macro DatamapEditor {
      GDview_templ &view_in<NEportLevels={2,0}>;
      GDobject_templ &obj_in<NEportLevels={2,0}> {
         DatamapTempl &dmap<NEportLevels={0,2}>;
      };
      ilink vis;

      macro Read_Colormap {
         file map_file<NEportLevels={0,1}> {
            name+nres<NEportLevels={3,0}> => 
		<-.<-.DatamapEditorUI.shell_menu.UIfileDialog.filename;
         };
	 int off => file_skip_lines(map_file,0,1);
         float Colormap<NEportLevels={1,2},NEx=275.,NEy=352.>[256][4] => file_array_ascii
		(map_file, off, 4, {1,1,1,1});
      };

      DMAP.DatamapEdit DatamapEdit {
	 dmap_in => <-.obj_in.dmap;
	 dmapLibrary => Templates.DATAMAPS;
	 curDmapName => <-.DatamapEditorUI.shell_menu.UIselectionDialog.selectedItem;
	 controlPointModel = 0;
	 controlPointData => <-.Read_Colormap.Colormap;
	 addRange => <-.DatamapEditorUI.AddRangeButton.do;
	 deleteRange => <-.DatamapEditorUI.DeleteRangeButton.do;
	 curRange => <-.DatamapEditorUI.curRange;
      };

      GMOD.instancer DatamapEditorInst {
	 Group => <-.DatamapEditorUI;
	 Value+nres => <-.vis;
      };
      macro DatamapEditorUI<instanced=0> {
	 DatamapTempl+IPort2 &dmapIn => <-.obj_in.dmap;

	 /*
	 int curRange = 0;
	 */
	 int curRange => switch((dmapIn.numRanges == 1) + 1, 
		CurRangeSlider.value, 0);
	 int curCP = 0;
	 DMAP.DataRange &prevRangePtr => dmapIn.ranges[curRange-1];
	 DMAP.DataRange &curRangePtr => dmapIn.ranges[curRange];
	 DMAP.DataRange &nextRangePtr => dmapIn.ranges[curRange+1];
	 DMAP.DatamapValue &curCPptr => dmapIn.ranges[curRange].controlPoints[curCP];
	 DMAP.DatamapValue &nextCPptr => dmapIn.ranges[curRange].controlPoints[curCP+1];

	 GD.DefaultObject DefaultObject {
	    input => <-.LegendVert.out_fld;
	    dmap => <-.dmapIn;
	    dith_tech => <-.<-.obj_in.dith_tech;
	 };
	 GD.DefaultCamera2D DefaultCamera2D {
	    objects => {<-.DefaultObject};
	 };
	 PAL.PALvirt PALvirt {
	    vclass => <-.<-.view_in.virtpal.vclass;
	    vid => <-.<-.view_in.virtpal.vid;
	    share = 1;
	    gamma => <-.<-.view_in.virtpal.gamma;
	    cube_size => <-.<-.view_in.virtpal.cube_size;
	 };
	 GD.DefaultView DefaultView {
	    handle => <-.View_Frame.UIrenderView.handle;
	    virtpal => PALvirt;
	    cameras => {<-.DefaultCamera2D};
	    aspect = 0;
	 };

         macro shell_menu {
            UIcmdList+OPort2 MenuBar {
               cmdList => {<-.File};
            };
            UIcmdList File {
               cmdList => {<-.ReadDatamap,<-.ReadAVS5};
            };
            UIcmd ReadDatamap {
               label<NEdisplayMode="open"> = "Read Datamap...";
            };
            UIcmd ReadAVS5 {
               label = "Read AVS5 Colormap...";
            };
            UIfileDialog UIfileDialog {
               visible => <-.ReadAVS5.do;
               title = "Read AVS5 Colormap Filename";
               filename<NEportLevels={0,3}>;
               searchPattern = "/usr/avs/data/colormap/*.cmap";
            };
            UIselectionDialog UIselectionDialog {
               visible => <-.ReadDatamap.do;
               title = "Read Datamap Name";
               selectedItem<NEportLevels={0,3}>;
               strings<NEportLevels={3,0}> => <-.<-.<-.DatamapEdit.dmapNames;
            };
         };

	 UIshell shell {
	    title = "Datamap Editor";
	    visible => vis;
	    width =  550;
	    height = 600;
#ifdef MSDOS
	    height =  520;
#endif
	    menu => <-.shell_menu.MenuBar;
	 };
	 Panels.UIpanel UIpanel {
	    parent => <-.shell;
	    x = 4;
	    y = 4;
	    width => <-.shell.clientWidth - 8;
	    height => <-.shell.clientHeight - 8;
	 };

	 macro View_Frame {
	    Panels.UIframe UIframe {
	       parent<NEportLevels={3,0}> => <-.<-.UIpanel;
	       x =  0;
	       y =  0;
	       width = 100;
	       height => <-.<-.UIpanel.height;
	    };
	    UIlabel MaxDataField {
	       parent => <-.UIframe;
	       label+nres<NEportLevels={2,2}> => str_format("%5.2f", <-.<-.dmapIn.dataMax);
	       x =  4;
	       y =  0;
	       width => <-.UIframe.clientWidth - 8;
	       alignment = 1;
	    };
	    Panels.UIrenderView UIrenderView {
	       parent => <-.UIframe;
	       x =  4;
	       y => <-.MaxDataField.y + <-.MaxDataField.height;
	       width => <-.UIframe.clientWidth - 8;
	       height => <-.UIframe.clientHeight -
			 2 * <-.MinDataField.height - 16;
	    };
	    UIlabel MinDataField {
	       parent => <-.UIframe;
	       label+nres<NEportLevels={2,2}> => str_format("%5.2f", <-.<-.dmapIn.dataMin);
	       x =  4;
	       y => <-.UIframe.clientHeight - .height - 12;
	       width => <-.UIframe.clientWidth - 8;
	       alignment = 1;
	    };
	 };

	 /* Panel to hold highest level controls. */
	 Panels.UIpanel UIpanel#1 {
	    parent => <-.UIpanel;
	    x = 108;
	    y = 0;
	    width => (<-.UIpanel.width - 116) / 2;
	    height => <-.UIpanel.height;
	 };
	 macro Edit_Frame {
	    Panels.UIframe UIframe {
	       parent<NEportLevels={3,0}> => <-.<-.UIpanel#1;
	       x = 0;
	       y = 0;
	       width => <-.<-.UIpanel#1.width;
	       height => <-.UIradioBox.y + <-.UIradioBox.height + 8;
	    };
	    UIlabel UIlabel {
	       parent => <-.UIframe;
	       label = "Edit Selection";
	       alignment = 1;
	       y =  0;
	       width => <-.UIframe.clientWidth;
	    };
	    Commands.UIoption UIoption {
	       label = "Color";
	       set = 1;
	    };
	    Commands.UIoption UIoption#1 {
	       label = "Alpha";
	       set = 0;
	    };
	    Commands.UIoption UIoption#2 {
	       label = "Range";
	       set = 0;
	    };
	    UIradioBox UIradioBox {
	       parent => <-.UIframe;
	       cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2};
	       selectedItem+nres;
	       y => <-.UIlabel.y + <-.UIlabel.height + 4;
	       width => <-.UIframe.clientWidth;
	    };
	 };
	 macro ColorModel_Frame {
	       Panels.UIframe UIframe {
	       parent<NEportLevels={3,0}> => <-.<-.UIpanel#1;
	       x =  0;
	       y => <-.<-.Edit_Frame.UIframe.y + <-.<-.Edit_Frame.UIframe.height + 4;
	       width => <-.<-.UIpanel#1.width;
	       height => <-.UIradioBox.y + <-.UIradioBox.height + 8;
	    };
	    UIlabel UIlabel {
	       parent => <-.UIframe;
	       label = "Color Model";
	       alignment = 1;
	       y =  0;
	       width => <-.UIframe.clientWidth;
	    };
	    Commands.UIoption UIoption {
	       label+nres => <-.<-.dmapIn.HSVcolorModel.model;
	    };
	    Commands.UIoption UIoption#1 {
	       label+nres => <-.<-.dmapIn.RGBcolorModel.model;
	    };
	    UIradioBox UIradioBox {
	       parent => <-.UIframe;
	       cmdList => {<-.UIoption,<-.UIoption#1};
	       selectedItem+nres => <-.<-.dmapIn.currentColorModel;
	       y => <-.UIlabel.y + <-.UIlabel.height + 4;
	       width => <-.UIframe.clientWidth;
	    };
	 };
	 UItoggle ImmediateToggle {
	    parent => <-.UIpanel#1;
	    label = "Immediate";
	    x =  0;
	    y => <-.ColorModel_Frame.UIframe.y + <-.ColorModel_Frame.UIframe.height + 4;
	    width => <-.UIpanel#1.width;
	 };
	 UIbutton AddRangeButton {
	    parent => <-.UIpanel#1;
	    label = "Add Range";
	    x = 0;
	    y => <-.ImmediateToggle.y + <-.ImmediateToggle.height + 4;
	    width => <-.UIpanel#1.width;
	    active+nres => <-.dmapIn.editable;
	 };
	 UIbutton DeleteRangeButton {
	    parent => <-.UIpanel#1;
	    label = "Delete Range";
	    x = 0;
	    y => <-.AddRangeButton.y + <-.AddRangeButton.height + 4;
	    width => <-.UIpanel#1.width;
	    active+nres => <-.dmapIn.editable;
	 };
	 UIslider CurRangeSlider {
	    int+nres val_array[2] => {1, <-.dmapIn.numRanges-1};
	    parent => <-.UIpanel#1;
	    x =  0;
	    y => <-.DeleteRangeButton.y + <-.DeleteRangeButton.height;
	    width => <-.UIpanel#1.width;
	    height = 76;
	    min = 0;
	    max+nres => max_array(val_array);
	    /*
	    value+nres<NEportLevels={2,2}> => <-.curRange;
	    */
	    value = 0;
	    mode = 1;
	    title = "Current Range";
	    visible => min_array(val_array);
	 };
	 UIslider CurCPSlider {
	    int+nres val_array[2] => {1, <-.curRangePtr.numControlPoints-2};
	    parent => <-.UIpanel#1;
	    x =  0;
	    y => <-.CurRangeSlider.y + <-.CurRangeSlider.height;
	    width => <-.UIpanel#1.width;
	    height = 76;
	    min = 0;
	    max+nres => max_array(val_array);
	    value+nres<NEportLevels={2,2}> => <-.curCP;
	    mode = 1;
	    title = "Current Control Point";
	    visible => min_array(val_array);
	 };

         GMOD.instancer Panel2Inst {
	    Group => <-.Panel#2_Macro;
	    Value+nres => Edit_Frame.UIoption.set;
         };
	 /* Panel to hold color (HSV or RGB) related info. */
	 macro Panel#2_Macro {
	    Panels.UIpanel UIpanel#2 {
	       parent => <-.<-.UIpanel;
	       x => <-.<-.UIpanel#1.x + <-.<-.UIpanel#1.width + 8;
	       y = 0;
	       width => (<-.<-.UIpanel.width - 116) / 2;
	       height => <-.<-.UIpanel.height;
	       visible => <-.<-.Edit_Frame.UIoption.set;
	    };
	    macro ColorRangeModel_Frame {
	       Panels.UIframe UIframe {
		  parent<NEportLevels={3,0}> => <-.<-.UIpanel#2;
		  x = 0;
		  y = 0;
		  width => <-.<-.UIpanel#2.width;
		  height => <-.UIradioBox.y + <-.UIradioBox.height + 8;
	       };
	       UIlabel UIlabel {
		  parent => <-.UIframe;
		  label = "Color Range Model";
		  alignment = 1;
		  y =  0;
		  width => <-.UIframe.clientWidth;
	       };
	       Commands.UIoption UIoption {
		  label+nres => "Linear";
	       };
	       Commands.UIoption UIoption#1 {
		  label+nres => "Step";
	       };
	       UIradioBox UIradioBox {
		  parent => <-.UIframe;
		  cmdList => {<-.UIoption,<-.UIoption#1};
		  selectedItem+nres => <-.<-.<-.curRangePtr.selectColorRange;
		  y => <-.UIlabel.y + <-.UIlabel.height + 4;
		  width => <-.UIframe.clientWidth;
	       };
	    };
	    macro V2_Frame {
	       UIframe UIframe {
		  parent<NEportLevels={3,0}> => <-.<-.UIpanel#2;
		  x =  0;
		  y => <-.<-.ColorRangeModel_Frame.UIframe.y +
		       <-.<-.ColorRangeModel_Frame.UIframe.height + 4;
		  width => <-.<-.UIpanel#2.width;
		  height => <-.UIslider#1.y + <-.UIslider#1.height + 4;
	       };
	       UIlabel UIlabel {
		  parent => <-.UIframe;
		  label+nres => <-.<-.<-.dmapIn.colorModel.v2Label;
		  alignment =  1;
		  y =  0;
		  width => <-.UIframe.clientWidth;
	       };
	       UIslider UIslider {
		  parent => <-.UIframe;
		  value+nres<NEportLevels={2,2}> => <-.<-.<-.curCPptr.v2;
		  active => <-.<-.<-.curRangePtr.minActive;
		  immediateMode+nres => <-.<-.<-.ImmediateToggle.set;
		  max = 1;
		  title = "Min";
		  x =  4;
		  y => <-.UIlabel.y + <-.UIlabel.height;
		  width => <-.UIframe.clientWidth - 8;
	       };
	       UIslider UIslider#1 {
		  parent => <-.UIframe;
		  value+nres<NEportLevels={2,2}> => <-.<-.<-.nextCPptr.v2;
		  active => <-.<-.<-.curRangePtr.maxActive;
		  immediateMode+nres => <-.<-.<-.ImmediateToggle.set;
		  max = 1;
		  title = "Max";
		  x =  4;
		  y => <-.UIslider.y + <-.UIslider.height;
		  width => <-.UIframe.clientWidth - 8;
	       };
	    };
	    V2_Frame V3_Frame {
	       UIframe.y => <-.<-.V2_Frame.UIframe.y + <-.<-.V2_Frame.UIframe.height+4;
	       UIlabel.label => <-.<-.<-.dmapIn.colorModel.v3Label;
	       UIslider.value => <-.<-.<-.curCPptr.v3;
	       UIslider.active => <-.<-.<-.curRangePtr.minActive;
	       UIslider#1.value => <-.<-.<-.nextCPptr.v3;
	       UIslider#1.active => <-.<-.<-.curRangePtr.maxActive;
	    };
	    V2_Frame V4_Frame {
	       UIframe.y => <-.<-.V3_Frame.UIframe.y + <-.<-.V3_Frame.UIframe.height+4;
	       UIlabel.label => <-.<-.<-.dmapIn.colorModel.v4Label;
	       UIslider.value => <-.<-.<-.curCPptr.v4;
	       UIslider.active => <-.<-.<-.curRangePtr.minActive;
	       UIslider#1.value => <-.<-.<-.nextCPptr.v4;
	       UIslider#1.active => <-.<-.<-.curRangePtr.maxActive;
	    };
	 };

         GMOD.instancer Panel3Inst {
	    Group => <-.Panel#3_Macro;
	    Value+nres => Edit_Frame.UIoption#1.set;
         };
	 /* Panel to hold alpha related info. */
	 macro Panel#3_Macro {
	    Panels.UIpanel UIpanel#3 {
	       parent => <-.<-.UIpanel;
	       x => <-.<-.UIpanel#1.x + <-.<-.UIpanel#1.width + 8;
	       y = 0;
	       width => (<-.<-.UIpanel.width - 116) / 2;
	       height => <-.<-.UIpanel.height;
	       visible => <-.<-.Edit_Frame.UIoption#1.set;
	    };
	    macro AlphaRangeModel_Frame {
	       Panels.UIframe UIframe {
		  parent<NEportLevels={3,0}> => <-.<-.UIpanel#3;
		  x =  0;
		  y =  0;
		  width => <-.<-.UIpanel#3.width;
		  height => <-.UIradioBox.y + <-.UIradioBox.height + 8;
	       };
	       UIlabel UIlabel {
		  parent => <-.UIframe;
		  label = "Alpha Range Model";
		  alignment = 1;
		  y =  0;
		  width => <-.UIframe.clientWidth;
	       };
	       Commands.UIoption UIoption {
		  label+nres => "Linear";
	       };
	       Commands.UIoption UIoption#1 {
		  label+nres => "Step";
	       };
	       UIradioBox UIradioBox {
		  parent => <-.UIframe;
		  cmdList => {<-.UIoption,<-.UIoption#1};
		  selectedItem+nres => <-.<-.<-.curRangePtr.selectAlphaRange;
		  y => <-.UIlabel.y + <-.UIlabel.height + 4;
		  width => <-.UIframe.clientWidth;
	       };
	    };
	    Panel#2_Macro.V2_Frame V1_Frame {
	       UIframe.parent => <-.<-.UIpanel#3;
	       UIframe.y => <-.<-.AlphaRangeModel_Frame.UIframe.y +
			    <-.<-.AlphaRangeModel_Frame.UIframe.height + 4;
	       UIframe.width => <-.<-.UIpanel#3.width;
	       UIlabel.label => <-.<-.<-.dmapIn.colorModel.v1Label;
	       UIslider.value => <-.<-.<-.curCPptr.v1;
	       UIslider.active = 1;
	       UIslider#1.visible+nres => 1 - <-.<-.<-.curRangePtr.selectAlphaRange;
	       UIslider#1.value => <-.<-.<-.nextCPptr.v1;
	       UIslider#1.active = 1;
	    };
	 };

         GMOD.instancer Panel4Inst {
	    Group => <-.Panel#4_Macro;
	    Value+nres => Edit_Frame.UIoption#2.set;
         };
	 /* Panel to hold range related info. */
	 macro Panel#4_Macro {
	    Panels.UIpanel UIpanel#4 {
	       parent => <-.<-.UIpanel;
	       x => <-.<-.UIpanel#1.x + <-.<-.UIpanel#1.width + 8;
	       y = 0;
	       width => (<-.<-.UIpanel.width - 116) / 2;
	       height => <-.<-.UIpanel.height;
	       visible => <-.<-.Edit_Frame.UIoption#2.set;
	    };
	    macro Range_Size_Frame {
	       UIlabel UIlabel {
		  parent+IPort3 => <-.<-.UIpanel#4;
		  label = "Range Size";
		  alignment = 1;
		  x = 0;
		  y =  5;
		  width = 100;
		  alignment = 0;
	       };
	       UIfield UIfield {
		  parent => <-.<-.UIpanel#4;
		  min = 0;
		  max = 1024;
		  value+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.size;
		  active => <-.<-.<-.curRangePtr.sizeActive;
		  mode = 1;
		  x = 110;
		  y = 0;
		  width = 75;
	       };
	    };
	    UItoggle RangeValuesToggle {
	       parent => <-.UIpanel#4;
	       label = "Range Values";
	       set+nres => <-.<-.curRangePtr.selectValues;
#ifndef MSDOS
	       y => <-.Range_Size_Frame.UIlabel.y + <-.Range_Size_Frame.UIlabel.height + 4;
#else
	       y => <-.Range_Size_Frame.UIfield.y + <-.Range_Size_Frame.UIfield.height + 4;
#endif
	       width => <-.UIpanel#4.width;
	    };
	    macro Range_Value_Frame {
	       Panels.UIframe UIframe {
		  parent<NEportLevels={3,0}> => <-.<-.UIpanel#4;
		  x = 0;
		  y => <-.<-.RangeValuesToggle.y + <-.<-.RangeValuesToggle.height + 4;
		  width => <-.<-.UIpanel#4.width;
		  height => <-.MaxRangeSlider.y + <-.MaxRangeSlider.height + 4;
	       };
	       UIslider MinRangeSlider {
		  parent => <-.UIframe;
		  min+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.DataMinValue;
		  max+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.DataMaxValue;
		  value+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.UIMinValue;
		  immediateMode+nres => <-.<-.<-.ImmediateToggle.set;
		  title = "Min Range Value";
		  x = 4;
		  y = 0;
		  width => <-.UIframe.clientWidth - 8;
#ifndef MSDOS
		  height = 65;
#endif
	       };
	       UIslider MaxRangeSlider {
		  parent => <-.UIframe;
		  min+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.DataMinValue;
		  max+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.DataMaxValue;
		  value+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.UIMaxValue;
		  immediateMode+nres => <-.<-.<-.ImmediateToggle.set;
		  title = "Max Range Value";
		  x =  4;
		  y => <-.MinRangeSlider.y + <-.MinRangeSlider.height + 4;
		  width => <-.UIframe.clientWidth - 8;
#ifndef MSDOS
		  height = 65;
#endif
	       };
	    };
	    macro Range_Data_Frame {
	       float minVal => switch((curRange > 0) + 1, 
		  dmapIn.dataMin,
		  prevRangePtr.DataMaxValue);

	       float maxVal => switch((curRange != (dmapIn.numRanges - 1)) + 1,
		  dmapIn.dataMax,
		  nextRangePtr.DataMinValue);

	       Panels.UIframe UIframe {
		  parent<NEportLevels={3,0}> => <-.<-.UIpanel#4;
		  x = 0;
		  y => <-.<-.Range_Value_Frame.UIframe.y + <-.<-.Range_Value_Frame.UIframe.height + 4;
		  width => <-.<-.UIpanel#4.width;
		  height => <-.MaxRangeSlider.y + <-.MaxRangeSlider.height + 12;
	       };
	       UIslider MinRangeSlider {
		  parent => <-.UIframe;
		  min+nres<NEportLevels={2,2}> => <-.minVal;
		  max+nres<NEportLevels={2,2}> => <-.maxVal;
		  value+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.DataMinValue;
		  immediateMode+nres => <-.<-.<-.ImmediateToggle.set;
		  title = "Min Data Value";
		  x = 4;
		  y = 0;
		  width => <-.UIframe.clientWidth - 8;
#ifndef MSDOS
		  height = 65;
#endif
	       };
	       UIslider MaxRangeSlider {
		  parent => <-.UIframe;
		  min+nres<NEportLevels={2,2}> => <-.minVal;
		  max+nres<NEportLevels={2,2}> => <-.maxVal;
		  value+nres<NEportLevels={2,2}> => <-.<-.<-.curRangePtr.DataMaxValue;
		  immediateMode+nres => <-.<-.<-.ImmediateToggle.set;
		  title = "Max Data Value";
		  x =  4;
		  y => <-.MinRangeSlider.y + <-.MinRangeSlider.height + 4;
		  width => <-.UIframe.clientWidth - 8;
#ifndef MSDOS
		  height = 65;
#endif
	       };
	    };
	 };

	 macro LegendVert {
	    DatamapTempl &dmapPtr<NEportLevels={2,1}> => <-.<-.obj_in.dmap;
	    float+nres dataMin => dmapPtr.dataMin;
	    float+nres dataMax => dmapPtr.dataMax;
	    float+nres dataIncr => ((dataMax - dataMin) / 256);
	    float arr[512] = {
	       0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,
	       14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,
	       26,27,27,28,28,29,29,30,30,31,31,32,32,33,33,34,34,35,35,36,36,37,37,38,
	       38,39,39,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48,49,49,50,
	       50,51,51,52,52,53,53,54,54,55,55,56,56,57,57,58,58,59,59,60,60,61,61,62,
	       62,63,63,64,64,65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72,73,73,74,
	       74,75,75,76,76,77,77,78,78,79,79,80,80,81,81,82,82,83,83,84,84,85,85,86,
	       86,87,87,88,88,89,89,90,90,91,91,92,92,93,93,94,94,95,95,96,96,97,97,98,
	       98,99,99,100,100,101,101,102,102,103,103,104,104,105,105,106,106,107,107,
	       108,108,109,109,110,110,111,111,112,112,113,113,114,114,115,115,116,116,
	       117,117,118,118,119,119,120,120,121,121,122,122,123,123,124,124,125,125,
	       126,126,127,127,128,128,129,129,130,130,131,131,132,132,133,133,134,134,
	       135,135,136,136,137,137,138,138,139,139,140,140,141,141,142,142,143,143,
	       144,144,145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152,
	       153,153,154,154,155,155,156,156,157,157,158,158,159,159,160,160,161,161,
	       162,162,163,163,164,164,165,165,166,166,167,167,168,168,169,169,170,170,
	       171,171,172,172,173,173,174,174,175,175,176,176,177,177,178,178,179,179,
	       180,180,181,181,182,182,183,183,184,184,185,185,186,186,187,187,188,188,
	       189,189,190,190,191,191,192,192,193,193,194,194,195,195,196,196,197,197,
	       198,198,199,199,200,200,201,201,202,202,203,203,204,204,205,205,206,206,
	       207,207,208,208,209,209,210,210,211,211,212,212,213,213,214,214,215,215,
	       216,216,217,217,218,218,219,219,220,220,221,221,222,222,223,223,224,224,
	       225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232,233,233,
	       234,234,235,235,236,236,237,237,238,238,239,239,240,240,241,241,242,242,
	       243,243,244,244,245,245,246,246,247,247,248,248,249,249,250,250,251,251,
	       252,252,253,253,254,254,255,255
	    };
	    Mesh_Unif+Node_Data+Float glyph {
	       dims = {0x2,0x100};
	       ndim = 2;
	       Data_Array+Float.node_data node_data[nnode_data] {
		  values => ((arr * dataIncr) + dataMin);
		  veclen = 1;
		  nvals => nnodes;
	       };
	       nnode_data = 1;
	       nspace = 2;
	       points = {-5,-5,5,5};
	    };
	    olink out_fld => glyph;
	 };
      };
   };


   /******************************************/
   /* Standalone Datamap Editor Macro Module */
   /*   Use this editor to edit datamaps     */
   /*   directly.			     */
   /******************************************/
   macro StandAloneDatamapEditor {
      int int<NEportLevels=1> = 1;
      DefaultObject DefaultObject {
         dmap<NEportLevels={0x3,0x0}>;
      };
      DatamapEditor DatamapEditor {
         obj_in => <-.DefaultObject;
         vis => <-.int;
	 DatamapEditorUI {
	    /* Get rid of references to input view and
	       simply define the defaults here.
            */
	    PALvirt {
	       vclass = 2;
	       vid =;
	       gamma = ;
	       cube_size = 6;
	    };
	 };
      };
   };

   /*****************************/
   /* Track Editor Macro Module */
   /*****************************/
   macro TrackEditor {
      /* inputs */
      GDview_templ &view_in<NEportLevels={2,1}>;
      GDcamera_templ &camera_in<NEportLevels={2,1}>;
      GDobject_templ &obj_in<NEportLevels={2,1}>;
      ilink track_rv;
      ilink vis;
      ilink track_select;

      /* Gestures to be used on the middle mouse button:
         entry 0 is for rotate
         entry 1 is for scale
         entry 2 is for xy translate
      */
#ifndef MSDOS
      string start_events[3] = {"<Btn2Down>", "Shift<Btn2Down>", "Control<Btn2Down>"};
      string run_events[3] = {"<Btn2Motion>", "Shift<Btn2Motion>", "Control<Btn2Motion>"};
      string stop_events[3] = {"<Btn2Up>", "Shift<Btn2Up>", "Control<Btn2Up>"};
#else
      string start_events[3] = {"<BtnMDown>", "Shift<BtnMDown>", "Control<BtnMDown>"};
      string run_events[3] = {"<BtnMMotion>", "Shift<BtnMMotion>", "Control<BtnMMotion>"};
      string stop_events[3] = {"<BtnMUp>", "Shift<BtnMUp>", "Control<BtnMUp>"};
#endif

      GMOD.instancer TrackEditorInst {
	 Group => <-.TrackEditorUI;
	 Value+nres => <-.vis;
      };
      macro TrackEditorUI<instanced=0> {

	 UItemplateDialog inter_shell {
	    title = "Interactor Editor";
	    visible => vis;
	    width = 275;
#ifdef MSDOS
	    height = 325;
#else
	    height = 390;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel inter_panel {
	    parent => inter_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.inter_shell.clientWidth - 8;
	    height	=> <-.inter_shell.clientHeight - 8;
	 };
	 UIlabel inter_label {
	    parent => inter_panel;
	    label = "Interactor Editor";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.inter_panel.width;
	 };
	 UIframe rot_frame {
	    parent => inter_panel;
	    x =  0;
	    y => inter_label.y + inter_label.height + 10;
	    width => <-.inter_panel.width;
	    height => <-.rot_rb.y + <-.rot_rb.height + 6;
	 };
	 UIlabel rot_label {
	    parent => rot_frame;
	    label = "Rotate Mode";
	    alignment = 0;
	    x = 4;
	    y = 0;
	    width => <-.rot_frame.clientWidth - 8;
	 };
	 UIoption rot_arb {
	    label = "Arbitrary";
	    message = "Allow aribtrary rotation.";
	 };
	 UIoption rot_xy {
	    label = "XY";
	    message = "Constain rotation to the nearest of the XY axes.";
	 };
	 UIoption rot_z {
	    label = "Z";
	    message = "Constrain rotation to the Z axis.";
	 };
	 UIradioBox rot_rb {
	    parent => rot_frame;
	    cmdList => { rot_arb,  rot_xy, rot_z };
	    x =  4;
	    y => <-.rot_label.y + <-.rot_label.height + 4;
	    width => <-.rot_frame.clientWidth - 8;
	    selectedItem => TrackAll.rot_mode;
	 };
	 UItoggle scale_mode {
	    parent => inter_panel;
	    label = "Non-Uniform Scaling";
	    message = "Uniform or non-uniform scaling";
	    set => TrackAll.scale_mode;
	    x =  0;
	    y => <-.rot_frame.y + <-.rot_frame.height + 4;
	    width => <-.inter_panel.clientWidth;
	    set => TrackAll.scale_mode;
	 };
	 UIframe xlate_frame {
	    parent => inter_panel;
	    x =  0;
	    y => scale_mode.y + scale_mode.height + 10;
	    width => <-.inter_panel.width;
	    height => <-.xlate_rb.y + <-.xlate_rb.height + 6;
	 };
	 UIlabel xlate_label {
	    parent => xlate_frame;
	    label = "XY Translate Mode";
	    alignment = 0;
	    x = 4;
	    y = 0;
	    width => <-.xlate_frame.clientWidth - 8;
	 };
	 UIoption xlate_arb {
	    label = "Arbitrary";
	    message = "Allow aribtrary translation.";
	 };
	 UIoption xlate_x {
	    label = "X";
	    message = "Constain translation to the X axis.";
	 };
	 UIoption xlate_y {
	    label = "Y";
	    message = "Constain translation to the Y axis.";
	 };
	 UIoption xlate_xy {
	    label = "XY";
	    message = "Constrain translation to the closest of the XY axes.";
	 };
	 UIradioBox xlate_rb {
	    parent => xlate_frame;
	    cmdList => { xlate_arb,  xlate_x, xlate_y, xlate_xy };
	    x =  4;
	    y => <-.xlate_label.y + <-.xlate_label.height + 4;
	    width => <-.xlate_frame.clientWidth - 8;
	    selectedItem => TrackAll.xlate_mode;
	 };
	 UItoggle space_mode {
	    parent => inter_panel;
	    label = "Global Space";
	    message = "Edit in global or local object space.";
	    x = 0;
	    y => <-.xlate_frame.y + <-.xlate_frame.height + 4;
	    width => <-.inter_panel.clientWidth;
	    set => TrackAll.space;
	 };

      };

      UItwoPoint InterAll {
	 view => track_rv;
#ifndef MSDOS
	 startEvent = "<Btn1Down>";
	 runEvent = "<Btn1Motion>";
	 stopEvent = "<Btn1Up>";
#else
	 startEvent = "<BtnLDown>";
	 runEvent = "<BtnLMotion>";
	 stopEvent = "<BtnLUp>";
#endif
      };
      GDtrack_edit TrackAll {
	 view+IPort2 => view_in;
	 camera+IPort2 => camera_in;
	 obj+IPort2 => obj_in;
	 x => InterAll.x;
	 y => InterAll.y;
	 event => InterAll.state;
	 time => InterAll.time;
	 mode => track_select;
      };
      UItwoPoint InterRotate {
	 view+IPort2 => track_rv;
	 startEvent => start_events[0];
	 runEvent => run_events[0];
	 stopEvent => stop_events[0];
      };
      GDtrack_edit TrackRotate {
	 view+IPort2 => view_in;
	 camera+IPort2 => camera_in;
	 obj+IPort2 => obj_in;
	 x => InterRotate.x;
	 y => InterRotate.y;
	 event => InterRotate.state;
	 time => InterRotate.time;
	 mode = 0;
	 rot_mode => TrackAll.rot_mode;
	 space => TrackAll.space;
      };
      UItwoPoint InterScale {
	 view+IPort2 => track_rv;
	 startEvent => start_events[1];
	 runEvent => run_events[1];
	 stopEvent => stop_events[1];
      };
      GDtrack_edit TrackScale {
	 view+IPort2 => view_in;
	 camera+IPort2 => camera_in;
	 obj+IPort2 => obj_in;
	 x => InterScale.x;
	 y => InterScale.y;
	 event => InterScale.state;
	 time => InterScale.time;
	 mode = 1;
	 scale_mode => TrackAll.scale_mode;
	 space => TrackAll.space;
      };
      UItwoPoint InterXlate_XY {
         view+IPort2 => track_rv;
         startEvent => start_events[2];
         runEvent => run_events[2];
         stopEvent => stop_events[2];
      };
      GDtrack_edit TrackXlate_XY {
         view+IPort2 => view_in;
         camera+IPort2 => camera_in;
         obj+IPort2 => obj_in;
         x => InterXlate_XY.x;
         y => InterXlate_XY.y;
         event => InterXlate_XY.state;
         time => InterXlate_XY.time;
         mode = 2;
	 xlate_mode => TrackAll.xlate_mode;
	 space => TrackAll.space;
      };
   };

   /*****************************/
   /* View Editor Macro Module */
   /*****************************/
   macro ViewEditor {
      /* inputs */
      GDview_templ &view_in<NEportLevels={2,1}>;
      ilink vis;

      /* A table that has either 0 or 1 in it for
	 each renderer. This value is attached to 
	 UIcmd.active for each renderer so it will
	 be greyed out if it is not available.
      */
      int ren_active[] => {
#ifdef SW_RENDERER
      1,
#else
      0,
#endif
#ifdef IGL_RENDERER
      1,
#else
#ifdef OGL_RENDERER
      1,
#else
      0,
#endif
#endif
#ifdef XGL_RENDERER
      1,
#else
      0,
#endif
#ifdef PEX_RENDERER
      1,
#else
      0,
#endif
// IAC/MPU: added commas to XIL entry - MPU is now last in list.
#ifdef XIL_RENDERER
      1,
#else
      0,
#endif
// IAC/MPU: added following entry to ren_active
#ifdef MPU_RENDERER
      1
#else
      0
#endif
      };

      GDview_edit view_edit {
         shell_vis => vis;
         view => view_in;
      };

      GMOD.instancer ViewEditorInst {
	 Group => <-.ViewEditorUI;
	 Value+nres => <-.vis;
      };
      macro ViewEditorUI<instanced=0> {

	 UItemplateDialog viewedit_shell {
	    title = "View Editor";
	    visible => vis;
	    width = 225;
	    height = 520;
#ifdef MSDOS
	    height = 410;
#endif
#ifdef XGL_RENDERER
	    height = 555;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel viewedit_panel {
	    parent => viewedit_shell;
	    x = 5;
	    y = 5;
	    width => <-.viewedit_shell.clientWidth - 10;
	    height => <-.viewedit_shell.clientHeight - 10;
	 };
	 UIlabel viewedit_label {
	    parent => viewedit_panel;
	    label = "View Editor";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.viewedit_panel.clientWidth;
	 };

	 UIframe viewedit_frame {
	    parent => viewedit_panel;
	    x = 0;
	    y => <-.viewedit_label.y + <-.viewedit_label.height + 4;
	    width => viewedit_panel.width;
	    height => <-.viewedit_ren_rb.y + <-.viewedit_ren_rb.height + 6;
	 };
	 UIlabel viewedit_ren_label {
	    parent => viewedit_frame;
	    label = "Renderer";
	    alignment = 0;
	    y = 0;
	    width => <-.viewedit_frame.clientWidth;
	 };
	 UIoption viewedit_sw {
	    label = "Software";
	    active => ren_active[0];
	    message = "Use software renderer.";
	 };
	 UIoption viewedit_gl {
	    label = "OpenGL";
	    active => ren_active[1];
	    message = "Use GL renderer.";
	 };
	 UIoption viewedit_xgl {
	    label = "XGL";
	    active => ren_active[2];
	    message = "Use XGL renderer.";
	 };
	 UIoption viewedit_pex {
	    label = "PEX";
	    active => ren_active[3];
	    message = "Use PEX renderer.";
	 };
	 UIoption viewedit_xil {
	    label = "XIL";
	    active => ren_active[4];
	    message = "Use XIL renderer.";
	 };
	 // IAC/MPU: added UIoption for MPU renderer
	 UIoption viewedit_mpu {
	    label = "MPU";
	    active => ren_active[5];
	    message = "Use OpenGL Multipipe renderer.";
	 };
	 UIradioBox viewedit_ren_rb {
	    parent => viewedit_frame;
	    cmdList => { viewedit_sw, viewedit_gl, viewedit_xgl, viewedit_pex, viewedit_xil, viewedit_mpu };
	    selectedItem => view_edit.renderer;
	    y => <-.viewedit_ren_label.y + <-.viewedit_ren_label.height + 4;
	    width => <-.viewedit_frame.clientWidth;
	 };

	 UIbutton viewedit_color {
	    parent => viewedit_panel;
	    label = "Background Color...";
	    message = "Edit view background color.";
	    y => <-.viewedit_frame.y + <-.viewedit_frame.height + 4;
	    width => viewedit_panel.width;
	 };

	 UIframe viewbuffer_frame {
	    parent => viewedit_panel;
	    y => <-.viewedit_color.y + <-.viewedit_color.height + 4;
	    width => viewedit_panel.width;
	    height => <-.viewbuffer_rb.y + <-.viewbuffer_rb.height + 6;
	 };
	 UIlabel viewbuffer_label {
	    parent => viewbuffer_frame;
	    label = "Buffer Mode";
	    alignment = 0;
	    y =  0;
	    width => <-.viewbuffer_frame.clientWidth;
	 };
	 UIoption viewbuffer_single {
	    label = "Single";
	    message = "Do single buffering.";
	 };
	 UIoption viewbuffer_double_mbx {
#ifdef MSDOS
	    label = "Double";
	    message = "Do double buffering.";
#else
	    label = "Double MBX";
	    message = "Do double buffering using mbx.";
#endif
	 };

	 /* Leave the option here even for MSDOS but don't
	    put it in the radio box. This allows test scripts
	    to work ok on MSDOS as well as UNIX.
	 */
	 UIoption viewbuffer_double_pix {
	    label = "Double Pixmap";
	    message = "Do double buffering using pixmap.";
	 };
	 UIradioBox viewbuffer_rb {
	    parent => viewbuffer_frame;
#ifdef MSDOS
	    cmdList => { viewbuffer_single, viewbuffer_double_mbx };
#else
	    cmdList => { viewbuffer_single, viewbuffer_double_mbx, viewbuffer_double_pix };
#endif
	    selectedItem => view_edit.buffer;
	    y =  0;
	    y => <-.viewbuffer_label.y + <-.viewbuffer_label.height + 4;
	    width => <-.viewbuffer_frame.clientWidth;
	 };

	 UItoggle viewaccel_mode {
	    parent => viewedit_panel;
	    label = "Accelerate";
	    message = "Enable/Disable view acceleration mode";
	    &set => view_edit.accel;
	    y => <-.viewbuffer_frame.y + <-.viewbuffer_frame.height + 4;
	 };

	 UItoggle viewedit_timer {
	    parent => viewedit_panel;
	    label = "Timer";
	    message = "Enable/Disable view timer.";
	    &set => view_edit.timer;
	    y => <-.viewaccel_mode.y + <-.viewaccel_mode.height + 4;
	    width => viewedit_panel.width;
	 };
	 UItoggle viewedit_mode {
	    parent => viewedit_panel;
	    label = "Auto-Update";
	    message = "Enable/Disable view auto-update";
	    &set => view_edit.mode;
	    y => <-.viewedit_timer.y + <-.viewedit_timer.height + 4;
	    width => viewedit_panel.width;
	 };
	 UItoggle viewedit_out {
	    parent => viewedit_panel;
	    label = "Output Enabled";
	    message = "Enable/Disable framebuffer and Z buffer output.";
	    &set => view_edit.output_enabled;
	    y => <-.viewedit_mode.y + <-.viewedit_mode.height + 4;
	    width => viewedit_panel.width;
	 };
#ifdef XGL_RENDERER
	 UItoggle viewedit_pcache {
	    parent => viewedit_panel;
	    label = "Use Pcache";
	    message = "Enable/Disable view pcaching";
	    &set => view_edit.pcache;
	    y => <-.viewedit_out.y + <-.viewedit_out.height + 4;
	    width => viewedit_panel.width;
	 };
#endif
	 UIbutton viewedit_ref {
	    parent => viewedit_panel;
	    label = "Refresh";
	    &do => view_edit.refresh;
#ifdef XGL_RENDERER
	    y => <-.viewedit_pcache.y + <-.viewedit_pcache.height + 4;
#else
	    y => <-.viewedit_out.y + <-.viewedit_out.height + 4;
#endif
	    width => viewedit_panel.width;
	 };
	 /* popup background color editor */
	 ColorPopup ViewBackCol {
	    name = "View Background Color Editor";
	    vis => viewedit_color.do;
	    red => view_edit.red;
	    green => view_edit.green;
	    blue => view_edit.blue;
	 };
      };
   };

   /********************************/
   /* Object Selector Macro Module */
   /********************************/
   macro ObjectSelector {
      /* inputs */
      GDview_templ &view_in<NEportLevels={2,1}>;
      ilink vis;

      GDobj_sel obj_selector {
         view => view_in;
      };

      GMOD.instancer ObjectSelectorInst {
	 Group => <-.ObjectSelectorUI;
	 Value+nres => <-.vis;
      };
      macro ObjectSelectorUI<instanced=0> {

	 UIselectionBox curobj_sel {
	    title = "Object Selector";
	    visible+IPort2 => vis;
	    strings+IPort2 => obj_selector.strings;
	    &text+IPort2 => obj_selector.curobj_name;
	 };
      };

      olink cur_obj => obj_selector.cur_obj;
   };

   /**********************************/
   /* Light Info Editor Macro Module */
   /**********************************/
   macro LightInfoEditor {
      GDview_templ+IMPort &view_in {
	 GDlight_info_templ+OPort2 &light_info;
      };
      ilink vis;

      GDlinfo_edit GDlinfo_editor {
	 shell_vis => vis;
	 cur_light = 0;
	 light_info => view_in.light_info;
      };
      GDlight_edit GDlight_editor {
	 shell_vis => vis;
         light => GDlinfo_editor.sel_light;
      };


      GMOD.instancer LightInfoEditorInst {
	 Group => <-.LightInfoEditorUI;
	 Value+nres => <-.vis;
      };
      macro LightInfoEditorUI<instanced=0> {

	 UItemplateDialog light_info_shell {
	    title = "Light Info Editor";
	    visible => vis;
	    width	=  225;
#ifdef MSDOS
	    height	=  415;
#else
	    height	=  470;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel light_info_panel {
	    parent => light_info_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.light_info_shell.clientWidth - 8;
	    height	=> <-.light_info_shell.clientHeight - 8;
	 };
	 UIlabel light_info_label {
	    parent => light_info_panel;
	    label = "Lights Information Editor";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.light_info_panel.width;
	 };
	 UItoggle show_state {
	    parent => light_info_panel;
	    y	=> <-.light_info_label.y + <-.light_info_label.height + 4;
	    label = "Show Lights On/Off";
	    message = "Enable/Disable display of light source representation.";
	    &set => GDlinfo_editor.show;
	 };

	 /* ambient light editor */
	 UIframe amb_panel_frame {
	    parent => light_info_panel;
	    y	=> <-.show_state.y + <-.show_state.height + 4;
	    width	=> <-.light_info_panel.width;
	    height	=> <-.amb_color.y + <-.amb_color.height + 10;
	   };
	 UItoggle amb_state {
	    parent => amb_panel_frame;
	    label = "Ambient Light On/Off";
	    message = "Enable/Disable ambient light source.";
	    &set => GDlinfo_editor.amb_onoff;
	    x	=  4;
	    y	=  4;
	    width	=> <-.amb_panel_frame.clientWidth - 8;
	 };
	 UIbutton amb_color {
	    parent => amb_panel_frame;
	    label = "Ambient Light Color...";
	    message = "Edit ambient light color.";
	    x	=  4;
	    y	=> <-.amb_state.y + <-.amb_state.height + 4;
	    width	=> <-.amb_panel_frame.clientWidth - 8;
	 };

	 UIslider cur_light_slider {
	    parent => light_info_panel;
	    title = "Current Light";
	    horizontal = 1;
	    /* I'd like to tie this to nlights.value - How do I
	       do that ??? */
	    /*max = light_info_in.nlights;*/
	    max = 3;
	    mode = 1;
	    value => GDlinfo_editor.cur_light;
	    y	=> <-.amb_panel_frame.y + <-.amb_panel_frame.height + 4;
	    width	=> <-.light_info_panel.width;
	 };

	 /* panel for editing current light source */
	 UIframe light_edit_panel_frame {
	    parent => light_info_panel;
	    x	=  0;
	    y	=> cur_light_slider.y + cur_light_slider.height + 10;
	    width	=> <-.light_info_panel.width;
	    height	=> <-.light_transform.y + <-.light_transform.height + 14;
	 };
	 UIpanel light_edit_panel {
	    parent => light_edit_panel_frame;
	    x	=  4;
	    y	=  4;
	    width	=> <-.light_edit_panel_frame.clientWidth - 8;
	    height	=> <-.light_edit_panel_frame.clientHeight - 8;
	 };
	 UItoggle light_state {
	    parent => light_edit_panel;
	    label = "Light On/Off";
	    message = "Enable/Disable light source.";
	    &set => GDlight_editor.state;
	    y	=  0;
	    width	=> <-.light_edit_panel.width;
	 };
	 UIoption light_dir {
	    label = "Directional";
	    message = "Directional light.";
	 };
	 UIoption light_point {
	    label = "Point";
	    message = "Point light.";
	 };
	 UIoption light_spot {
	    label = "Spot";
	    message = "Spot light.";
	 };
	 UIoption light_bidir {
	    label = "Bi-Directional";
	    message = "Bi-Directional light.";
	 };
	 UIradioBox light_type_rb {
	    parent => light_edit_panel;
	    cmdList => { light_dir, light_point, light_spot, light_bidir };
	    selectedItem => GDlight_editor.type;
	    y	=> <-.light_state.y + <-.light_state.height + 4;
	    width	=> <-.light_edit_panel.width;
	 };
	 UIbutton light_color {
	    parent => light_edit_panel;
	    label = "Light Color...";
	    message = "Edit light color.";
	    y	=> <-.light_type_rb.y + <-.light_type_rb.height + 4;
	    width	=> <-.light_edit_panel.width;
	 };
	 UIbutton light_info {
	    parent => light_edit_panel;
	    label = "Light Attributes...";
	    message = "Edit light attributes.";
	    y	=> <-.light_color.y + <-.light_color.height + 4;
	    width	=> <-.light_edit_panel.width;
	 };
	 UIbutton light_transform {
	    parent => light_edit_panel;
	    label = "Light Transform...";
	    message = "Edit light transformation.";
	    y	=> <-.light_info.y + <-.light_info.height + 4;
	    width	=> <-.light_edit_panel.width;
	 };

	 /* popup ambient color editor */
	 ColorPopup ColorPopup_1 {
	    name = "Ambient Color Editor";
	    vis => amb_color.do;
	    red => GDlinfo_editor.amb_red;
	    green => GDlinfo_editor.amb_green;
	    blue => GDlinfo_editor.amb_blue;
	 };
	 /* popup light color editor */
	 ColorPopup ColorPopup_2 {
	    name = "Light Color Editor";
	    vis => light_color.do;
	    red => GDlight_editor.red;
	    green => GDlight_editor.green;
	    blue => GDlight_editor.blue;
	 };
	 /* popup light info editor */
	 LightAttribPopup LightAttribPopup_1 {
	    vis => light_info.do;
	    att1 => GDlight_editor.att1;
	    att2 => GDlight_editor.att2;
	    concen => GDlight_editor.concen;
	    angle => GDlight_editor.angle;
	 };
	 XformEditor XformEditor_1 {
	    obj_in => GDlinfo_editor.sel_light;
	    vis => light_transform.do;
	 };
      };
   };

   /******************************/
   /* Camera Editor Macro Module */
   /******************************/
   macro CameraEditor {
      GDview_templ+IMPort &view_in {
	 GDcamera_templ+OPort2 &picked_camera;
      };
      ilink vis;

      GDcamera_edit GDcamera_edit {
	 shell_vis => vis;
	 camera => view_in.picked_camera;
      };

      int label_width = 75;
      int field_width = 75;

      GMOD.instancer CameraEditorInst {
	 Group => <-.CameraEditorUI;
	 Value+nres => <-.vis;
      };
      macro CameraEditorUI<instanced=0> {

	 UItemplateDialog camera_shell {
	    title = "Camera Editor";
	    visible => vis;
	    width	= 575;
#ifdef MSDOS
	    height	= 540;
#else
	    height	= 580;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel camera_panel {
	    parent => camera_shell;
	    x	=  4;
	    y	=  4;
	    width	=> <-.camera_shell.clientWidth - 8;
	    height	=> <-.camera_shell.clientHeight - 8;
	 };
	 UIlabel camera_label {
	    parent => camera_panel;
	    label = "Camera Editor";
	    alignment = 1;
	    y	=  0;
	    width	=> <-.camera_panel.width;
	 };

	 macro from_x {
	    UIlabel lab {
	       parent => camera_panel;
	       label = "From X";
	       alignment = 0;
	       y		=> <-.<-.camera_label.y + <-.<-.camera_label.height+20;
	       width	=> label_width;
	    };
	    UIfield field {
	       parent => camera_panel;
	       value => GDcamera_edit.from_x;
	       x		=> <-.lab.x + <-.lab.width + 25;
	       y		=> <-.lab.y - 5;
	       width	=> field_width;
	    };
	 };

	 from_x from_y {
	    lab.label = "From Y";
	    lab.x	=> <-.<-.from_x.field.x + <-.<-.from_x.field.width + 10;
	    field.value => GDcamera_edit.from_y;
	 };

	 from_x from_z {
	    lab.label = "From Z";
	    lab.x	=> <-.<-.from_y.field.x + <-.<-.from_y.field.width + 10;
	    field.value => GDcamera_edit.from_z;
	 };

	 from_x up_x {
	    lab.label = "Up X";
	    lab.y	=> <-.<-.from_x.field.y + <-.<-.from_x.field.height + 10;
	    field.value => GDcamera_edit.up_x;
	 };

	 up_x up_y {
	    lab.label = "Up Y";
	    lab.x	=> <-.<-.up_x.field.x + <-.<-.up_x.field.width + 10;
	    field.value => GDcamera_edit.up_y;
	 };

	 up_x up_z {
	    lab.label = "Up Z";
	    lab.x	=> <-.<-.up_y.field.x + <-.<-.up_y.field.width + 10;
	    field.value => GDcamera_edit.up_z;
	 };

	 from_x at_x {
	    lab.label = "At X";
	    lab.y	=> <-.<-.up_x.field.y + <-.<-.up_x.field.height + 10;
	    field.value => GDcamera_edit.at_x;
	 };

	 at_x at_y {
	    lab.label = "At Y";
	    lab.x	=> <-.<-.at_x.field.x + <-.<-.at_x.field.width + 10;
	    field.value => GDcamera_edit.at_y;
	 };

	 at_x at_z {
	    lab.label = "At Z";
	    lab.x	=> <-.<-.at_y.field.x + <-.<-.at_y.field.width + 10;
	    field.value => GDcamera_edit.at_z;
	 };

	 /* camera scale typein */
	 UIlabel scale_lab {
	    parent => camera_panel;
	    label = "Camera Scale";
	    alignment = 0;
	    y	=> <-.at_x.field.y + <-.at_x.field.height + 15;
	    width	=  125;
	 };
	 UIfield scale_field {
	    parent => camera_panel;
	    value => GDcamera_edit.scale;
	    x	=> <-.scale_lab.x + <-.scale_lab.width + 25;
	    y	=> <-.at_x.field.y + <-.at_x.field.height + 10;
	    width	=> field_width;
	 };
	 UIbutton camera_orient {
	    parent => camera_panel;
	    label = "Camera Orientation...";
	    message = "Edit camera orientation.";
	    x	=> <-.scale_field.x + <-.scale_field.width + 10;
	    y	=> <-.scale_field.y;
	    height	=> <-.scale_field.height;
	    width	=  300;
	 };

	 UIlabel wsize_lab {
	    parent => camera_panel;
	    label = "Window Size";
	    alignment = 0;
	    y	=> <-.scale_field.y + <-.scale_field.height + 15;
	    width	=  125;
	 };
	 UIfield wsize_field {
	    parent => camera_panel;
	    value => GDcamera_edit.wsize;
	    x	=> <-.wsize_lab.x + <-.wsize_lab.width + 25;
	    y	=> <-.scale_field.y + <-.scale_field.height + 10;
	    width	=> field_width;
	 };
	 UIlabel fov_lab {
	    parent => camera_panel;
	    label = "Field of View";
	    alignment = 0;
	    x	=> <-.wsize_field.x + <-.wsize_field.width + 10;
	    y	=> <-.wsize_lab.y;
	    width	=  125;
	 };
	 UIfield fov_field {
	    parent => camera_panel;
	    value => GDcamera_edit.fov;
	    x	=> <-.fov_lab.x + <-.fov_lab.width + 25;
	    y	=> <-.wsize_field.y;
	    width	=> field_width;
	 };

	 UItoggle hither_toggle {
	    parent => camera_panel;
	    label = "Clipping";
	    message = "Enable front/back clipping.";
	    &set => GDcamera_edit.hither;
	    y	=> <-.wsize_field.y + <-.wsize_field.height + 15;
	    width	=  100;
	 };
	 UIlabel front_clip_lab {
	    parent => camera_panel;
	    alignment = 0;
	    label = "Front Clip";
	    x	=> <-.hither_toggle.x + <-.hither_toggle.width + 10;
	    y	=> <-.hither_toggle.y;
	    width	=  100;
	 };
	 UIfield front_clip_field {
	    parent => camera_panel;
	    value => GDcamera_edit.front;
	    x	=> <-.front_clip_lab.x + <-.front_clip_lab.width + 25;
	    y	=> <-.wsize_field.y + <-.wsize_field.height + 10;
	    width	=> field_width;
	 };
	 UIlabel back_clip_lab {
	    parent => camera_panel;
	    alignment = 0;
	    label = "Back Clip";
	    x	=> <-.front_clip_field.x + <-.front_clip_field.width + 10;
	    y	=> <-.front_clip_lab.y;
	    width	=  100;
	 };
	 UIfield back_clip_field {
	    parent => camera_panel;
	    value => GDcamera_edit.back;
	    x	=> <-.back_clip_lab.x + <-.back_clip_lab.width + 25;
	    y	=> <-.front_clip_field.y;
	    width	=> field_width;
	 };

	 UItoggle perspec_toggle {
	    parent => camera_panel;
	    label = "Perspective";
	    message = "Select perspective or parallel projection mode.";
	    &set => GDcamera_edit.perspec;
	    y	=> <-.front_clip_field.y + <-.front_clip_field.height + 10;
	    width	=  125;
	 };
	 UIbutton depth_cue {
	    parent => camera_panel;
	    label = "Depth Cueing...";
	    message = "Edit depth cue parameters.";
	    x	=> <-.perspec_toggle.x + <-.perspec_toggle.width + 10;
	    y	=> <-.front_clip_field.y + <-.front_clip_field.height + 10;
	    width	=  150;
	 };

	 UIframe extents_frame {
	    parent => camera_panel;
	    x	= 4;
	    y	=> <-.depth_cue.y + <-.depth_cue.height + 10;
	    width	=  250;
	    height	=> <-.extents.y + <-.extents.height + 6;
	 };
	 UIlabel extents_lab {
	    parent => extents_frame;
	    label = "Extents";
	    alignment = 0;
	    x = 4;
	    y = 0;
	    width => <-.extents_frame.clientWidth - 8;
	 };
	 UIoption compute {
	    label = "Compute";
	    message = "Compute extents when normalizing.";
	 };
	 UIoption window {
	    label = "Window";
	    message = "Use window when normalizing.";
	 };
	 UIradioBox extents {
	    parent => extents_frame;
	    cmdList => { compute, window };
	    selectedItem => GDcamera_edit.extents;
	    x = 4;
	    y => extents_lab.y + extents_lab.height + 6;
	    width	=> <-.extents_frame.clientWidth - 8;
	 };

	 UIframe mapping_frame {
	    parent => camera_panel;
	    x	=> <-.extents_frame.x + <-.extents_frame.width + 20;
	    y	=> <-.extents_frame.y;
	    width	=  250;
	    height	=> <-.mapping.y + <-.mapping.height + 6;
	 };
	 UIlabel mapping_lab {
	    parent => mapping_frame;
	    label = "Mapping";
	    alignment = 0;
	    x = 4;
	    y = 0;
	    width => <-.mapping_frame.clientWidth - 8;
	 };
	 UIoption world {
	    label = "World";
	    message = "Normalize to world coordinates.";
	 };
	 UIoption pixels {
	    label = "Pixels";
	    message = "Normalize to pixels.";
	 };
	 UIradioBox mapping {
	    parent => mapping_frame;
	    cmdList => { world, pixels };
	    selectedItem => GDcamera_edit.mapping;
	    x = 4;
	    y => mapping_lab.y + mapping_lab.height + 6;
	    width	=> <-.mapping_frame.clientWidth - 8;
	 };

	 UIframe auto_frame {
	    parent => camera_panel;
	    x	= 4;
	    y	=> <-.extents_frame.y + <-.extents_frame.height + 10;
	    width	=  250;
	    height	=> <-.auto_rb.y + <-.auto_rb.height + 6;
	 };
	 UIlabel auto_lab {
	    parent => auto_frame;
	    label = "Auto-Normalize";
	    alignment = 0;
	    x = 4;
	    y = 0;
	    width => <-.auto_frame.clientWidth - 8;
	 };
	 UIoption auto_no {
	    label = "None ";
	    message = "No auto-normalization.";
	 };
	 UIoption auto_data {
	    label = "Data Change";
	    message = "Auto-Normalize on data change..";
	 };
	 UIoption auto_attach {
	    label = "Object Attach";
	    message = "Auto-normalize on object attach.";
	 };
	 UIoption auto_both {
	    label = "Data or Object";
	    message = "Auto-normalize on data change and object attach.";
	 };
	 UIradioBox auto_rb {
	    parent => auto_frame;
	    cmdList => { auto_no, auto_data, auto_attach, auto_both };
	    selectedItem => GDcamera_edit.auto_norm;
	    x = 4;
	    y => auto_lab.y + auto_lab.height + 6;
	    width	=> <-.auto_frame.clientWidth - 8;
	 };

	 UItoggle ip_toggle {
	    parent => camera_panel;
	    label = "Image Pass";
	    message = "Enable/Disable separate 2D rendering pass for images..";
	    &set => GDcamera_edit.image_pass;
	    x	=> <-.auto_frame.x + <-.auto_frame.width + 25;
	    y	=> <-.mapping_frame.y + <-.mapping_frame.height + 10;
	    width	=  125;
	 };

	 UItoggle pick_toggle {
	    parent => camera_panel;
	    label = "Pickable";
	    message = "Enable/Disable camera pickability.";
	    &set => GDcamera_edit.pickable;
	    x	=> <-.auto_frame.x + <-.auto_frame.width + 25;
	    y	=> <-.ip_toggle.y + <-.ip_toggle.height + 10;
	    width	=  125;
	 };

	 /* depth cue parameters editor */
	 DepthCuePopup DepthCuePopup_1 {
	    vis => depth_cue.do;
	    enable => GDcamera_edit.depth_cue;
	    front => GDcamera_edit.depth_front;
	    back => GDcamera_edit.depth_back;
	    scale => GDcamera_edit.depth_scale;
	 };
	 XformEditor XformEditor_1 {
	    obj_in => view_in.picked_camera;
	    vis => camera_orient.do;
	 };
      };
   };

   /******************************/
   /* Output Editor Macro Module */
   /******************************/
   macro OutputEditor {
      /* inputs */
      GDview_templ+IMPort &view_in {
	 GDoutput_templ+OPort2 &output;
      };
      ilink vis;

      GMOD.instancer OutputEditorInst {
	 Group => <-.OutputEditorUI;
	 Value+nres => <-.vis;
      };
      macro OutputEditorUI<instanced=0> {

	 UItemplateDialog out_shell {
	    title = "Output Editor";
	    visible => vis;
	    width = 225;
#ifdef MSDOS
	    height = 350;
#else
	    height = 425;
#endif
	    okButton = 1;
	    okLabelString = "Close";
	    cancelButton = 0;
	 };
	 UIpanel outedit_panel {
	    parent => out_shell;
	    x = 4;
	    y = 4;
	    width => <-.out_shell.clientWidth - 8;
	    height => <-.out_shell.clientHeight - 8;
	 };
	 UIlabel outedit_label {
	    parent => outedit_panel;
	    label = "Output Editor";
	    alignment = 1;
	    y = 0;
	    width => <-.outedit_panel.width;
	 };
	 UItoggle outedit_flip {
	    parent => outedit_panel;
	    label = "Flip";
	    message = "Flip output frame buffer and Z buffer.";
	    y => <-.outedit_label.y + <-.outedit_label.height + 4;
	    width => <-.outedit_panel.width;
	    set+nres => <-.<-.view_in.output.flip;
	 };

	 UIframe outedit_fb {
	    parent => outedit_panel;
	    y => <-.outedit_flip.y + <-.outedit_flip.height + 4;
	    width => <-.outedit_panel.width;
	    height => <-.fb_type_rb.y + <-.fb_type_rb.height + 6;
	 };
	 UIlabel fb_type {
	    parent => outedit_fb;
	    label = "Frame Buffer Type";
	    alignment = 0;
	    x = 4;
	    y = 0;
	    width => <-.outedit_fb.clientWidth - 8;
	 };
	 UIoption fb_none {
	    label = "None";
	    message = "No frame buffer output.";
	 };
	 UIoption fb_argb {
	    label = "ARGB";
	    message = "ARGB frame buffer format.";
	 };
	 UIoption fb_rgba {
	    label = "RGBA";
	    message = "RGBA frame buffer format.";
	    active => switch(<-.<-.view_in.renderer + 1, 0,1,0,0,0);
	 };
	 UIoption fb_abgr {
	    label = "ABGR";
	    message = "ABGR frame buffer format.";
	    active => switch(<-.<-.view_in.renderer + 1, 0,0,1,0,1);
	 };
	 UIradioBox fb_type_rb {
	    parent => outedit_fb ;
	    cmdList => { fb_none, fb_argb, fb_rgba, fb_abgr };
	    selectedItem+nres => <-.<-.view_in.output.buffers.fb_type;
	    x =  4;
	    y => <-.fb_type.y + <-.fb_type.height + 4;
	    width => <-.outedit_fb.clientWidth - 8;
	 };

	 UIframe outedit_zb {
	    parent => outedit_panel;
	    y => <-.outedit_fb.y + <-.outedit_fb.height + 4;
	    width => <-.outedit_panel.width;
	    height => <-.zb_type_rb.y + <-.zb_type_rb.height + 6;
	 };
	 UIlabel zb_type {
	    parent => outedit_zb;
	    label = "Z Buffer Type";
	    alignment = 0;
	    x = 4;
	    y = 0;
	    width => <-.outedit_zb.clientWidth - 8;
	 };
	 UIoption zb_none {
	    label = "None";
	    message = "No Z buffer output.";
	 };
	 UIoption zb_short {
	    label = "Short";
	    message = "Short Z buffer format.";
	    active => switch(<-.<-.view_in.renderer + 1, 1,0,0,0,0);
	 };
	 UIoption zb_float_1 {
	    label = "Float 1 Near";
	    message = "Float Z buffer format - 1 near user.";
	    active => switch(<-.<-.view_in.renderer + 1, 1,1,1,0,1);
	 };
	 UIoption zb_float_0 {
	    label = "Float 0 Near";
	    message = "Float Z buffer format - 0 near user.";
	    active => switch(<-.<-.view_in.renderer + 1, 0,1,0,0,0);
	 };
	 UIoption zb_int {
	    label = "Int";
	    message = "Int Z buffer format.";
	    active => switch(<-.<-.view_in.renderer + 1, 0,0,1,0,1);
	 };
	 UIradioBox zb_type_rb {
	    parent => outedit_zb ;
	    cmdList => { zb_none, zb_short, zb_float_1, zb_float_0, zb_int };
	    selectedItem+nres => <-.<-.view_in.output.buffers.zb_type;
	    x =  4;
	    y => <-.zb_type.y + <-.zb_type.height + 4;
	    width => <-.outedit_zb.clientWidth - 8;
	 };

	 UIbutton outedit_clear {
	    parent => outedit_panel;
	    label = "Clear Output";
	    message = "Clears output frame buffer and Z buffer.";
	    y => <-.outedit_zb.y + <-.outedit_zb.height + 4;
	    width => <-.outedit_panel.width;
	    do+nres => <-.<-.view_in.output.clear;
	 };
      };
   };

};		/* end of library UI_Editors */

library+global+sort+buffered UI_Interactivity {

   macro ContinuousSketch<module_stack_menu=1,
			  NEhelp=0> {
      ilink rv<NEcolor0=0x00ff00>;
      GDview_templ &view<NEportLevels={2,1}>;

      UImod_panel UImod_panel {
	 title = "Continuous Sketch";
	 message = "Select continuous sketch control panel.";
	 height	=> <-.UIpanel.y + <-.UIpanel.height;
      };

      UIframe option_frame {
	 parent => UImod_panel;
	 y	=  0;
	 width	=> <-.UImod_panel.width;
	 height => <-.option_rb.y + <-.option_rb.height + 6;
      };
      UIoption option_pt {
         label = "Point";
         message = "Draw point.";
      };
      UIoption option_line {
         label = "Line";
         message = "Draw line.";
      };
      UIoption option_box {
         label = "Box";
         message = "Draw box.";
      };
      UIoption option_polyl {
         label = "Polyline";
         message = "Draw polyline.";
      };
      UIoption option_polyg {
         label = "Polygon";
         message = "Draw polygon.";
      };
      UIradioBox option_rb {
	 parent => option_frame;
         cmdList => { option_pt, option_line, option_box, option_polyl, option_polyg };
	 selectedItem => GDroi2d_cont.option;
	 y	=  0;
	 width	=> <-.option_frame.clientWidth;
      };

      UIframe draw_frame {
	 parent => UImod_panel;
	 y	=>  <-.option_frame.y + <-.option_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.draw_rb.y + <-.draw_rb.height + 6;
      };
      UIoption draw_copy {
         label = "Copy";
         message = "Draw in copy mode.";
      };
      UIoption draw_xor {
         label = "Xor";
         message = "Draw in XOR mode.";
      };
      UIradioBox draw_rb {
	 parent => draw_frame;
         cmdList => { draw_copy, draw_xor };
	 selectedItem => GDroi2d_cont.draw_mode;
	 y	=  0;
	 width	=> <-.draw_frame.clientWidth;
      };

      UItoggle draw_immed {
         parent => UImod_panel;
         label = "Immediate";
         set => GDroi2d_cont.immed;
	 y	=> <-.draw_frame.y + <-.draw_frame.height + 4;
	 width	=> <-.UImod_panel.width;
      };
      UIframe bldcol_frame {
	 parent => UImod_panel;
	 y	=> <-.draw_immed.y + <-.draw_immed.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.bldcol_blue.y + <-.bldcol_blue.height + 6;
      };
      UIslider bldcol_red {
         parent => bldcol_frame;
	 title = "Build Red";
         max = 1;
         value => GDroi2d_cont.red;
	 y	=  0;
	 width	=> <-.bldcol_frame.clientWidth;
      };
      bldcol_red bldcol_green {
	 title = "Build Green";
         value => GDroi2d_cont.green;
	 y	=> <-.bldcol_red.y + <-.bldcol_red.height + 4;
      };
      bldcol_red bldcol_blue {
	 title = "Build Blue";
         value => GDroi2d_cont.blue;
	 y	=> <-.bldcol_green.y + <-.bldcol_green.height + 4;
      };

      UIframe buf_frame {
	 parent => UImod_panel;
	 y	=> <-.bldcol_frame.y + <-.bldcol_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.buf_done.y + <-.buf_done.height + 6;
      };
      UItoggle buf_mode {
         parent => buf_frame;
         label = "Append Buffer";
         message = "Enable/Disable append mode.";
         &set => GDroi2d_cont.mode;
	 y	=  0;
	 width	=> <-.buf_frame.clientWidth + 6;
      };
      UIbutton buf_clear {
         parent => buf_frame;
         label = "Clear Buffer";
         &do => GDroi2d_cont.clear;
	 y	=> <-.buf_mode.y + <-.buf_mode.height + 4;
	 width	=> <-.buf_frame.clientWidth;
      };
      UIbutton buf_done {
         parent => buf_frame;
         label = "Done";
         &do => GDroi2d_cont.done;
	 y	=> <-.buf_clear.y + <-.buf_clear.height + 4;
	 width	=> <-.buf_frame.clientWidth;
      };

      UIframe mapcol_frame {
	 parent => UImod_panel;
	 y	=> <-.buf_frame.y + <-.buf_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.mapcol_blue.y + <-.mapcol_blue.height + 6;
      };
      UIslider mapcol_red {
         parent => mapcol_frame;
	 title = "Map Red";
         max = 1;
         value => GDmap2d_ss.red;
	 y	=  0;
	 width	=> <-.mapcol_frame.clientWidth;
      };
      mapcol_red mapcol_green {
	 title = "Map Green";
         value => GDmap2d_ss.green;
	 y	=> <-.mapcol_red.y + <-.mapcol_red.height + 4;
      };
      mapcol_red mapcol_blue {
	 title = "Map Blue";
         value => GDmap2d_ss.blue;
	 y	=> <-.mapcol_green.y + <-.mapcol_green.height + 4;
      };

      UIframe map_frame {
	 parent => UImod_panel;
	 y	=> <-.mapcol_frame.y + <-.mapcol_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.map_clear.y + <-.map_clear.height + 6;
      };
      UItoggle map_color {
         parent => map_frame;
         label = "Use Map Color";
         message = "Enable/Disable use of map color.";
         &set => GDmap2d_ss.color;
	 y	=  0;
	 width	=> <-.map_frame.clientWidth;
      };
      UItoggle map_mode {
         parent => map_frame;
         label = "Append Field";
         message = "Enable/Disable append field mode.";
         &set => GDmap2d_ss.mode;
	 y	=> <-.map_color.y + <-.map_color.height + 4;
	 width	=> <-.map_frame.clientWidth;
      };
      UIbutton map_clear {
         parent => map_frame;
         label = "Clear Field";
         &do => GDmap2d_ss.clear;
	 y	=> <-.map_mode.y + <-.map_mode.height + 4;
	 width	=> <-.map_frame.clientWidth;
      };

      UIpanel UIpanel {
         parent => UImod_panel;
	 y	=> <-.map_frame.y + <-.map_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.UItext.y + <-.UItext.height + 6;
      };
      UIlabel UIlabel {
         parent => UIpanel;
         label = "Name";
	 y	=> (<-.UItext.height - .height) / 2;
	 width	=  50;
      };
      UItext UItext {
         parent => UIpanel;
         text => GDmap2d_ss.name;
	 x	=> <-.UIlabel.x + <-.UIlabel.width + 5;
	 y	=  0;
	 width	=> <-.UIpanel.width - .x;
      };

      UItwoPoint UItwoPoint {
         view+IPort2 => rv;
#ifndef MSDOS
         startEvent = "<Btn3Down>";
         runEvent = "<Btn3Motion>";
         stopEvent = "<Btn3Up>";
#else
         startEvent = "<BtnRDown>";
         runEvent = "<BtnRMotion>";
         stopEvent = "<BtnRUp>";
#endif
      };
      GDroi2d_cont GDroi2d_cont {
         view_in => view;
         x => UItwoPoint.x;
         y => UItwoPoint.y;
         state => UItwoPoint.state;
	 redraw => view.trigger;
      };
      GDmap2d_ss GDmap2d_ss {
	 view_in => view;
	 cam_in => view.picked_camera;
	 obj_in+IPort3;
	 in_buf => GDroi2d_cont.out_buf;
	 out_mesh+OPort3;
      };
      GD.DataObject DataObject {
	 in => GDmap2d_ss.out_mesh;
	 obj+OPort3 {
	    name => name_of(<-.<-.<-);
         };
      };
   };

   macro ClickSketch <module_stack_menu=1, NEhelp=0> {
      ilink rv<NEcolor0=0x00ff00>;
      GDview_templ &view<NEportLevels={2,1}>;

      UImod_panel UImod_panel {
	 title = "Click Sketch";
	 message = "Select click sketch control panel.";
	 height	=> <-.UIpanel.y + <-.UIpanel.height;
      };

      UIframe option_frame {
	 parent => UImod_panel;
	 y	=  0;
	 width	=> <-.UImod_panel.width;
	 height => <-.option_rb.y + <-.option_rb.height + 6;
      };
      UIoption option_pt {
         label = "Point";
         message = "Draw point.";
      };
      UIoption option_line {
         label = "Line";
         message = "Draw line.";
      };
      UIoption option_box {
         label = "Box";
         message = "Draw box.";
      };
      UIoption option_polyl {
         label = "Polyline";
         message = "Draw polyline.";
      };
      UIoption option_polyg {
         label = "Polygon";
         message = "Draw polygon.";
      };
      UIradioBox option_rb {
	 parent => option_frame;
         cmdList => { option_pt, option_line, option_box, option_polyl, option_polyg};
	 selectedItem => GDroi2d_click.option;
	 y	=  0;
	 width	=> <-.option_frame.clientWidth;
      };

      UItoggle draw_immed {
         parent => UImod_panel;
         label = "Immediate";
         set => GDroi2d_click.immed;
	 y	=> <-.option_frame.y + <-.option_frame.height + 4;
	 width	=> <-.UImod_panel.width;
      };
      UIframe bldcol_frame {
	 parent => UImod_panel;
	 y	=> <-.draw_immed.y + <-.draw_immed.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.bldcol_blue.y + <-.bldcol_blue.height + 6;
      };
      UIslider bldcol_red {
         parent => bldcol_frame;
	 title = "Build Red";
         max = 1;
         value => GDroi2d_click.red;
	 y	=  0;
	 width	=> <-.bldcol_frame.clientWidth;
      };
      bldcol_red bldcol_green {
	 title = "Build Green";
         value => GDroi2d_click.green;
	 y	=> <-.bldcol_red.y + <-.bldcol_red.height + 4;
      };
      bldcol_red bldcol_blue {
	 title = "Build Blue";
         value => GDroi2d_click.blue;
	 y	=> <-.bldcol_green.y + <-.bldcol_green.height + 4;
      };

      UIframe buf_frame {
	 parent => UImod_panel;
	 y	=> <-.bldcol_frame.y + <-.bldcol_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.buf_done.y + <-.buf_done.height + 6;
      };
      UItoggle buf_mode {
         parent => buf_frame;
         label = "Append Buffer";
         message = "Enable/Disable append mode.";
         &set => GDroi2d_click.mode;
	 y	=  0;
	 width	=> <-.buf_frame.clientWidth + 6;
      };
      UIbutton buf_clear {
         parent => buf_frame;
         label = "Clear Buffer";
         &do => GDroi2d_click.clear;
	 y	=> <-.buf_mode.y + <-.buf_mode.height + 4;
	 width	=> <-.buf_frame.clientWidth;
      };
      UIbutton buf_done {
         parent => buf_frame;
         label = "Done";
         &do => GDroi2d_click.done;
	 y	=> <-.buf_clear.y + <-.buf_clear.height + 4;
	 width	=> <-.buf_frame.clientWidth;
      };

      UIframe mapcol_frame {
	 parent => UImod_panel;
	 y	=> <-.buf_frame.y + <-.buf_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.mapcol_blue.y + <-.mapcol_blue.height + 6;
      };
      UIslider mapcol_red {
         parent => mapcol_frame;
	 title = "Map Red";
         max = 1;
         value => GDmap2d_ss.red;
	 y	=  0;
	 width	=> <-.mapcol_frame.clientWidth;
      };
      mapcol_red mapcol_green {
	 title = "Map Green";
         value => GDmap2d_ss.green;
	 y	=> <-.mapcol_red.y + <-.mapcol_red.height + 4;
      };
      mapcol_red mapcol_blue {
	 title = "Map Blue";
         value => GDmap2d_ss.blue;
	 y	=> <-.mapcol_green.y + <-.mapcol_green.height + 4;
      };

      UIframe map_frame {
	 parent => UImod_panel;
	 y	=> <-.mapcol_frame.y + <-.mapcol_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.map_clear.y + <-.map_clear.height + 6;
      };
      UItoggle map_color {
         parent => map_frame;
         label = "Use Map Color";
         message = "Enable/Disable use of map color.";
         &set => GDmap2d_ss.color;
	 y	=  0;
	 width	=> <-.map_frame.clientWidth;
      };
      UItoggle map_mode {
         parent => map_frame;
         label = "Append Field";
         message = "Enable/Disable append field mode.";
         &set => GDmap2d_ss.mode;
	 y	=> <-.map_color.y + <-.map_color.height + 4;
	 width	=> <-.map_frame.clientWidth;
      };
      UIbutton map_clear {
         parent => map_frame;
         label = "Clear Field";
         &do => GDmap2d_ss.clear;
	 y	=> <-.map_mode.y + <-.map_mode.height + 4;
	 width	=> <-.map_frame.clientWidth;
      };

      UIpanel UIpanel {
         parent => UImod_panel;
	 y	=> <-.map_frame.y + <-.map_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.UItext.y + <-.UItext.height + 6;
      };
      UIlabel UIlabel {
         parent => UIpanel;
         label = "Name";
	 y	=> (<-.UItext.height - .height) / 2;
	 width	=  50;
      };
      UItext UItext {
         parent => UIpanel;
         text => GDmap2d_ss.name;
	 x	=> <-.UIlabel.x + <-.UIlabel.width + 5;
	 y	=  0;
	 width	=> <-.UIpanel.width - .x;
      };

      UIonePoint AddPoint {
         view+IPort2 => rv;
#ifndef MSDOS
         runEvent = "<Btn3Down>";
#else
         runEvent = "<BtnRDown>";
#endif
      };
      UIonePoint ErasePoint {
         view+IPort2 => rv;
#ifndef MSDOS
         runEvent = "Shift<Btn3Down>";
#else
         runEvent = "Shift<BtnRDown>";
#endif
      };
      UIonePoint ClosePoint {
         view+IPort2 => rv;
#ifndef MSDOS
         runEvent = "Control<Btn3Down>";
#else
         runEvent = "Control<BtnRDown>";
#endif
      };
      GDroi2d_click GDroi2d_click {
         view_in => view;
         add => AddPoint.state;
         erase => ErasePoint.state;
         close => ClosePoint.state;
	 redraw => view.trigger;
         x => AddPoint.x;
         y => AddPoint.y;
      };
      GDmap2d_ss GDmap2d_ss {
	 view_in => view;
	 cam_in => view.picked_camera;
	 obj_in+IPort3;
	 in_buf => GDroi2d_click.out_buf;
	 out_mesh+OPort3;
      };
      GD.DataObject DataObject {
	 in => GDmap2d_ss.out_mesh;
	 obj+OPort3 {
	    name => name_of(<-.<-.<-);
	 };
      };
   };

   macro DrawCursor2D <NEhelp=0> {
      ilink rv<NEcolor0=0x00ff00>;
      GDview_templ &view<NEportLevels={2,1}>;

      UImod_panel UImod_panel {
	 title = "Draw Cursor 2D";
	 message = "Select draw cursor 2D control panel.";
	 height	=> <-.draw_pt_label.y + <-.draw_pt_label.height + 10;
      };
      UItoggle draw_immed {
         parent => UImod_panel;
         label = "Immediate";
         message = "Enable/Disable immediate mode.";
         set => GDdraw2d_cursor.immed;
	 y = 0;
	 width=> <-.UImod_panel.width;
      };
      UItoggle draw_cursor {
         parent => UImod_panel;
         label = "Cross";
         message = "Enable/Disable full-screen cross-hair cursor";
         set => GDdraw2d_cursor.mode;
	 y => <-.draw_immed.y + <-.draw_immed.height + 4;
	 width=> <-.UImod_panel.width;
      };
      UIlabel draw_size_label {
	 parent => UImod_panel;
	 label = "Cross Size";
	 alignment = 0;
	 y => <-.draw_cursor.y + <-.draw_cursor.height + 4;
	 width = 75;
      };
      UIfield draw_size {
	 parent => UImod_panel;
	 min = 5;
         max = 1024;
	 value => <-.GDdraw2d_cursor.size;
	 x => <-.draw_size_label.width + 10;
	 y => <-.draw_size_label.y;
	 width = 75;
	 mode = 1;
      };
      UIslider draw_thick {
         parent => UImod_panel;
	 title = "Cursor Thickness";
	 min = 0;
         max = 10;
         value => GDdraw2d_cursor.thickness;
	 y => <-.draw_size.y + <-.draw_size.height + 4;
	 width=> <-.UImod_panel.width;
	 mode = 1;
      };
      UIslider draw_red {
         parent => UImod_panel;
	 title = "Red";
         max = 1;
         value => GDdraw2d_cursor.red;
	 y => <-.draw_thick.y + <-.draw_thick.height + 4;
	 width=> <-.UImod_panel.width;
      };
      draw_red draw_green {
	 title = "Green";
         value => GDdraw2d_cursor.green;
	 y => <-.draw_red.y + <-.draw_red.height + 4;
      };
      draw_green draw_blue {
	 title = "Blue";
         value => GDdraw2d_cursor.blue;
	 y => <-.draw_green.y + <-.draw_green.height + 4;
      };

      UIlabel draw_pt_label {
	 parent => UImod_panel;
	 label = "XY";
	 alignment = 0;
	 y => <-.draw_blue.y + <-.draw_blue.height + 4;
	 width = 50;
      };
      float xvalue => GDdraw2d_cursor.out_mesh.coordinates.values[0][0];
      float yvalue => GDdraw2d_cursor.out_mesh.coordinates.values[0][1];
      /* If UIlabel.label is unresolved, the instance name will be used */
      UIlabel Undefined {
	 parent => UImod_panel;
         label => str_format("%5.2f", xvalue) + ", " + str_format("%5.2f", yvalue);
	 x => <-.draw_pt_label.x + <-.draw_pt_label.width + 5;
	 y => <-.draw_blue.y + <-.draw_blue.height + 4;
	 width = 200;
	 alignment = 0;
      };

      UItwoPoint UItwoPoint {
         view+IPort2 => rv;
#ifndef MSDOS
         startEvent = "<Btn3Down>";
         runEvent = "<Btn3Motion>";
         stopEvent = "<Btn3Up>";
#else
         startEvent = "<BtnRDown>";
         runEvent = "<BtnRMotion>";
         stopEvent = "<BtnRUp>";
#endif
      };
      GDdraw2d_cursor GDdraw2d_cursor {
         view_in => view;
	 cam_in => view.picked_camera;
	 obj_in+IPort3;
         x => UItwoPoint.x;
         y => UItwoPoint.y;
         state => UItwoPoint.state;
	 out_mesh+OPort3;
      };
   };

   macro DrawLine2D <NEhelp=0> {
      ilink rv<NEcolor0=0x00ff00>;
      GDview_templ &view<NEportLevels={2,1}>;

      UImod_panel UImod_panel {
	 title = "Draw Line 2D";
	 message = "Select draw line 2d control panel.";
	 height	=> <-.draw_end_label.y + <-.draw_end_label.height;
      };

      UIframe draw_frame {
	 parent => UImod_panel;
	 y	=  0;
	 width	=> <-.UImod_panel.width;
	 height	=> <-.draw_rb.height + 6;
      };
      UIoption draw_copy {
         label = "Copy";
         message = "Draw in copy mode.";
      };
      UIoption draw_xor {
         label = "Xor";
         message = "Draw in XOR mode.";
      };
      UIradioBox draw_rb {
	 parent => draw_frame;
         cmdList => { draw_copy, draw_xor};
	 selectedItem => GDroi2d_cont.draw_mode;
	 y	=  0;
	 width	=> <-.draw_frame.clientWidth;
      };
      UItoggle draw_immed {
         parent => UImod_panel;
         label = "Immediate";
         set => GDroi2d_cont.immed;
	 y	=> <-.draw_frame.y + <-.draw_frame.height + 4;
	 width	=> <-.UImod_panel.width;
      };
      UIbutton draw_measure {
         parent => UImod_panel;
         label = "Measure";
         &do => GDroi2d_cont.done;
	 y	=> <-.draw_immed.y + <-.draw_immed.height + 4;
	 width	=> <-.UImod_panel.width;
      };

      UIlabel draw_start_label {
	 parent => UImod_panel;
	 label = "XY Start";
	 alignment = 0;
	 y => <-.draw_measure.y + <-.draw_measure.height + 4;
	 width = 75;
      };
      float xsvalue => GDmap2d_ss.out_mesh.coordinates.values[0][0];
      float ysvalue => GDmap2d_ss.out_mesh.coordinates.values[0][1];
      /* If UIlabel.label is unresolved, the instane name will be used */
      UIlabel XY_Start {
	 parent => UImod_panel;
         label => str_format("%5.2f", xsvalue) + ", " + str_format("%5.2f", ysvalue);
	 x => <-.draw_start_label.x + <-.draw_start_label.width + 5;
	 y => <-.draw_measure.y + <-.draw_measure.height + 4;
	 width = 200;
	 alignment = 0;
      };

      UIlabel draw_end_label {
	 parent => UImod_panel;
	 label = "XY End";
	 alignment = 0;
	 y => <-.draw_start_label.y + <-.draw_start_label.height + 4;
	 width = 75;
      };
      float xevalue => GDmap2d_ss.out_mesh.coordinates.values[1][0];
      float yevalue => GDmap2d_ss.out_mesh.coordinates.values[1][1];
      /* If UIlabel.label is unresolved, the instance name will be used */
      UIlabel XY_End {
	 parent => UImod_panel;
         label => str_format("%5.2f", xevalue) + ", " + str_format("%5.2f", yevalue);
	 x => <-.draw_end_label.x + <-.draw_end_label.width + 5;
	 y => <-.draw_start_label.y + <-.draw_start_label.height + 4;
	 width = 200;
	 alignment = 0;
      };

      UItwoPoint UItwoPoint {
         view+IPort2 => rv;
#ifndef MSDOS
         startEvent = "<Btn3Down>";
         runEvent = "<Btn3Motion>";
         stopEvent = "<Btn3Up>";
#else
         startEvent = "<BtnRDown>";
         runEvent = "<BtnRMotion>";
         stopEvent = "<BtnRUp>";
#endif
      };
      GDroi2d_cont GDroi2d_cont {
         view_in => view;
         x => UItwoPoint.x;
         y => UItwoPoint.y;
         state => UItwoPoint.state;
	 redraw => view.trigger;
         mode = 0;
	 immed = 1;
         option = 1;
      };
      GDmap2d_ss GDmap2d_ss {
	 view_in => view;
	 cam_in => view.picked_camera;
	 obj_in+IPort3;
	 in_buf => GDroi2d_cont.out_buf;
	 out_mesh+OPort3;
      };
   };

   macro EditMesh <NEhelp=0> {
      UItwoPoint &UItwoPoint<NEportLevels={2,1}>;
      GDview_templ &view<NEportLevels={2,1}>;

      UImod_panel UImod_panel {
	 title = "Edit Mesh";
	 message = "Select edit mesh control panel.";
	 height	=> <-.done_button.y + <-.done_button.height;
      };

      UIframe mode_frame {
	 parent => UImod_panel;
	 y	=  0;
	 width	=> <-.UImod_panel.width;
	 height	=> <-.mode_rb.height + 6;
      };
      UIoption mode_point {
         label = "Point";
         message = "Edit point.";
      };
      UIoption mode_prim {
         label = "Primitive";
         message = "Edit primitive.";
      };
      UIoption mode_cell {
         label = "Cell";
         message = "Edit cell.";
      };
      UIradioBox mode_rb {
	 parent => mode_frame;
         cmdList => { mode_point, mode_prim, mode_cell };
	 selectedItem => GDedit_mesh.mode;
	 y	=  0;
	 width	=> <-.mode_frame.clientWidth;
      };

      UIframe draw_frame {
	 parent => UImod_panel;
	 y	=>  <-.mode_frame.y + <-.mode_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.draw_rb.y + <-.draw_rb.height + 6;
      };
      UIoption draw_copy {
         label = "Copy";
         message = "Draw in copy mode.";
      };
      UIoption draw_xor {
         label = "Xor";
         message = "Draw in XOR mode.";
      };
      UIradioBox draw_rb {
	 parent => draw_frame;
         cmdList => { draw_copy, draw_xor };
	 selectedItem => GDedit_mesh.draw_mode;
	 y	=  0;
	 width	=> <-.draw_frame.clientWidth;
      };

      UIframe hicol_frame {
	 parent => UImod_panel;
	 y	=> <-.draw_frame.y + <-.draw_frame.height + 4;
	 width	=> <-.UImod_panel.width;
	 height => <-.hicol_blue.y + <-.hicol_blue.height + 6;
      };
      UIslider hicol_red {
         parent => hicol_frame;
	 title = "Highlight Red";
         max = 1;
         value => GDedit_mesh.red;
	 y	=  0;
	 width	=> <-.hicol_frame.clientWidth;
      };
      hicol_red hicol_green {
	 title = "Highlight Green";
         value => GDedit_mesh.green;
	 y	=> <-.hicol_red.y + <-.hicol_red.height + 4;
      };
      hicol_red hicol_blue {
	 title = "Highlight Blue";
         value => GDedit_mesh.blue;
	 y	=> <-.hicol_green.y + <-.hicol_green.height + 4;
      };

      UIbutton remove_button {
         parent => UImod_panel;
         label = "Delete";
         message = "Delete point/primitive/cell.";
         &do=> GDedit_mesh.remove;
	 y	=> <-.hicol_frame.y + <-.hicol_frame.height + 4;
	 width	=> <-.UImod_panel.width;
      };

      UItoggle immed_toggle {
         parent => UImod_panel;
         label = "Immediate";
         message = "Delayed or immediate update.";
         &set => GDedit_mesh.immed;
	 y	=> <-.remove_button.y + <-.remove_button.height + 4;
	 width	=> <-.UImod_panel.width;
      };

      UIbutton done_button {
         parent => UImod_panel;
         label = "Done";
         &do => GDedit_mesh.done;
	 y	=> <-.immed_toggle.y + <-.immed_toggle.height + 4;
	 width	=> <-.UImod_panel.width;
      };

      GDedit_mesh GDedit_mesh {
         view_in => view;
	 cam_in => view.picked_camera;
         picked_obj => view.picked_obj;
         x => UItwoPoint.x;
         y => UItwoPoint.y;
         state => UItwoPoint.state;
      };
   };

   macro Vector2Raster <NEhelp=0> {
      ilink in_field;
      GDobject_templ &object<NEportLevels={2,1}>;

      UImod_panel UImod_panel {
	 title = "Vector2Raster";
	 message = "Select vector to raster control panel.";
	 height	=> <-.UIpanel.y + <-.UIpanel.height;
      };

      UItoggle inside_toggle {
         parent => UImod_panel;
         label = "Inside";
         message = "Inside/Outside regions.";
         &set => GDvector2raster.inside;
	 y	=  0;
	 width	=> <-.UImod_panel.width;
      };

      UIpanel UIpanel {
         parent => UImod_panel;
	 y	=> <-.inside_toggle.y + <-.inside_toggle.height + 4;
	 width = 250;
      };
      UIlabel UIlabel {
         parent => UIpanel;
         label = "Name";
	 y	=> (<-.UItext.height - .height) / 2;
	 width	=  50;
	 alignment = 0;
      };
      UItext UItext {
         parent => UIpanel;
         text => GDvector2raster.name;
	 x	=  55;
	 y	=  0;
	 width	=> <-.UImod_panel.width - .x;
      };

      GDvector2raster GDvector2raster {
	 input => in_field;
	 obj_in => object;
	 output+OPort3;
      };
      GD.DataObject DataObject {
	 in => GDvector2raster.output;
	 obj+OPort3 {
	    name => name_of(<-.<-.<-);
         };
      };
   };

};		/* end of library UI_Interactivity */

Components {	/* continuation of Components library */

   /*************************************************/
   /* Define some macro modules that are useful for */
   /* creating custom views                         */
   /*************************************************/

   /* Macro modules that define UI commands to be put
      on a menu bar in a view. The different command lists
      are aoociated with editor macros that follow a
      similar naming convention.
   */

   /* Macro that defines a list containing commands that
      can be tied to the visibility of the various view 
      editors in the View3DEditors macro.
   */
   macro ViewCmdList {
      UIcmd ViewCmd {
         label = "&View...";
         message = "Display view editor";
      };
      UIcmd ObjSelectCmd {
         label = "Object &Selector...";
         message = "Display object selector";
      };
      UIcmd LightsCmd {
         label = "&Lights...";
         message = "Display lights editor";
      };
      UIcmd CameraCmd {
         label = "&Camera...";
         message = "Display camera editor";
      };
      UIcmd InterCmd {
         label = "&Interactor...";
         message = "Display interactor editor";
      };
      UIcmd OutputCmd {
         label = "&Output...";
         message = "Display output editor";
      };
      UIcmdList ViewEditors<NEx=X2,NEy=Y4> {
	 label =  "&ViewEditors";
	 cmdList => { ViewCmd, ObjSelectCmd, LightsCmd, CameraCmd, InterCmd, OutputCmd };
      };
      olink cmdList<NEx=X3,NEy=Y4> => ViewEditors;
      olink cmds<NEx=X1,NEy=YO> => ViewEditors.cmdList;
   };

   /* Macro that defines a list containing commands that
      can be tied to the visibility of the various view 
      editors in the View2DEditors macro.
   */
   macro View2DCmdList {
      UIcmd ViewCmd {
         label = "&View...";
         message = "Display view editor";
      };
      UIcmd ObjSelectCmd {
         label = "Object &Selector...";
         message = "Display object selector";
      };
      UIcmd CameraCmd {
         label = "&Camera...";
         message = "Display camera editor";
      };
      UIcmd InterCmd {
         label = "&Interactor...";
         message = "Display interactor editor";
      };
      UIcmd OutputCmd {
         label = "&Output...";
         message = "Display output editor";
      };
      UIcmdList ViewEditors<NEx=X2,NEy=Y4> {
	 label =  "&ViewEditors";
	 cmdList => { ViewCmd, ObjSelectCmd, CameraCmd, InterCmd, OutputCmd };
      };
      olink cmdList<NEx=X3,NEy=Y4> => ViewEditors;
      olink cmds<NEx=X1,NEy=YO> => ViewEditors.cmdList;
   };

   /* Macro that defines a list containing commands that
      can be tied to the visibility of the various object 
      editors in the ObjectEditors macro.
   */
   macro ObjCmdList {
      UIcmd ObjCmd {
         label = "&Object...";
         message = "Display object editor";
      };
      UIcmd XformCmd {
         label = "&Xform...";
         message = "Display transformation editor";
      };
      UIcmd PropsCmd {
         label = "&Props...";
         message = "Display properties editor";
      };
      UIcmd ModesCmd {
         label = "&Modes...";
         message = "Display modes editor";
      };
      UIcmd TextureCmd {
         label = "&Texture...";
         message = "Display texture editor";
      };
      UIcmd DatamapCmd {
         label = "&Datamap...";
         message = "Display datamap editor";
      };
      UIcmdList ObjEditors<NEx=X2,NEy=Y4> {
	 label = "&ObjEditors";
	 cmdList => { ObjCmd, XformCmd, PropsCmd, ModesCmd, TextureCmd, DatamapCmd };
      };
      olink cmdList<NEx=X3,NEy=Y4> => ObjEditors;
      olink cmds<NEx=X1,NEy=YO> => ObjEditors.cmdList;
   };

   /* Macro that defines a list containing commands that
      can be tied to the visibility of the various object 
      editors in the Object2DEditors macro.
   */
   macro Obj2DCmdList {
      UIcmd ObjCmd {
         label = "&Object...";
         message = "Display object editor";
      };
      UIcmd XformCmd {
         label = "&Xform...";
         message = "Display transformation editor";
      };
      UIcmd PropsCmd {
         label = "&Props...";
         message = "Display properties editor";
      };
      UIcmd ModesCmd {
         label = "&Modes...";
         message = "Display modes editor";
      };
      UIcmd DatamapCmd {
         label = "&Datamap...";
         message = "Display datamap editor";
      };
      UIcmdList ObjEditors<NEx=X2,NEy=Y4> {
	 label = "&ObjEditors";
	 cmdList => { ObjCmd, XformCmd, PropsCmd, ModesCmd, DatamapCmd };
      };
      olink cmdList<NEx=X3,NEy=Y4> => ObjEditors;
      olink cmds<NEx=X1,NEy=YO> => ObjEditors.cmdList;
   };

   /* Macro that defines a list containing commands that
      can be tied to the visibility of the various 
      editors in the SimpleEditors macro.
   */
   macro SimpleCmdList {
      UIcmd ViewCmd<NEy=55,NEx=55> {
         label = "&View...";
         message = "Display view editor";
      };
      UIcmd ObjSelectCmd<NEy=99,NEx=55> {
         label = "Object &Selector...";
         message = "Display object selector";
      };
      UIcmd ObjCmd<NEy=143,NEx=55> {
         label = "&Object...";
         message = "Display object editor";
      };
      UIcmdList Editors<NEy=209,NEx=176> {
	 label = "&Editors";
	 cmdList+Port2 => { ViewCmd, ObjSelectCmd, ObjCmd };
      };

      olink cmdList<NEy=209,NEx=330> => Editors;
      olink cmds<NEy=264,NEx=385> => Editors.cmdList;
   };

   /* Macro Modules that define groups of editors for 
      views, objects and basic editing.
   */
   macro ViewEditors {
      GDview_templ &edit_view<NEportLevels={2,1},NEx=X1,NEy=Y2>;
      ilink edit_rv<NEx=X2,NEy=YI>;
      imlink vis_list<NEx=X3,NEy=YI>;
      ilink selected<NEx=X4,NEy=YI>;

      ViewEditor ViewEditor<NEx=X3,NEy=Y3> {
         view_in => edit_view;
         vis+nres => vis_list[0].do;
      };
      ObjectSelector ObjectSelector<NEx=X3,NEy=Y4> {
         view_in => edit_view;
         vis+nres => vis_list[1].do;
      };
      LightInfoEditor LightInfoEditor<NEx=X3,NEy=Y5> {
         view_in => edit_view;
         vis+nres => vis_list[2].do;
      };
      CameraEditor CameraEditor<NEx=X3,NEy=Y6> {
         view_in => edit_view;
         vis+nres => vis_list[3].do;
      };
      TrackEditor TrackEditor<NEx=352,NEy=418> {
         view_in => edit_view;
	 camera_in => edit_view.picked_camera;
         obj_in => ObjectSelector.cur_obj;
         track_rv => edit_rv;
         vis+nres => vis_list[4].do;
	 track_select => selected;
      };
      OutputEditor OutputEditor {
         view_in => edit_view;
         vis+nres => vis_list[5].do;
      };
      olink cur_obj<NEx=X1,NEy=YO> => ObjectSelector.cur_obj;
   };

   /* Macro Modules that define groups of editors for 
      views, objects and basic editing.
   */
   macro View2DEditors {
      GDview_templ &edit_view<NEportLevels={2,1},NEx=X1,NEy=Y2>;
      ilink edit_rv<NEx=X2,NEy=YI>;
      imlink vis_list<NEx=X3,NEy=YI>;
      ilink selected<NEx=X4,NEy=YI>;

      ViewEditor ViewEditor<NEx=X3,NEy=Y3> {
         view_in => edit_view;
         vis+nres => vis_list[0].do;
      };
      ObjectSelector ObjectSelector<NEx=X3,NEy=Y4> {
         view_in => edit_view;
         vis+nres => vis_list[1].do;
      };
      CameraEditor CameraEditor<NEx=X3,NEy=Y6> {
         view_in => edit_view;
         vis+nres => vis_list[2].do;
      };
      TrackEditor TrackEditor<NEx=X3,NEy=Y7> {
         view_in => edit_view;
	 camera_in => edit_view.picked_camera;
         obj_in => ObjectSelector.cur_obj;
         track_rv => edit_rv;
         vis+nres => vis_list[3].do;
	 track_select => selected;
      };
      OutputEditor OutputEditor {
         view_in => edit_view;
         vis+nres => vis_list[4].do;
      };
      olink cur_obj<NEx=X1,NEy=YO> => ObjectSelector.cur_obj;
   };

   macro ObjectEditors {
      GDview_templ &edit_view<NEportLevels={2,1},NEx=X1,NEy=Y3>;
      GDobject_templ &edit_obj<NEportLevels={2,1},NEx=X2,NEy=Y2>;
      imlink vis_list<NEx=X4,NEy=YI>;

      ObjectEditor ObjectEditor<NEx=X1,NEy=Y5> {
	 camera_in => edit_view.picked_camera;
         obj_in => edit_obj;
	 vis+nres => vis_list[0].do;
      };
      XformEditor XformEditor<NEx=X2,NEy=Y5> {
	 obj_in => edit_obj;
	 vis+nres => vis_list[1].do;
      };
      PropsEditor PropsEditor<NEx=X3,NEy=Y5> {
	 obj_in => edit_obj;
	 vis+nres => vis_list[2].do;
      };
      ModesEditor ModesEditor<NEx=X4,NEy=Y5> {
	 obj_in => edit_obj;
	 vis+nres => vis_list[3].do;
      };
      TextureEditor TextureEditor<NEx=X5,NEy=Y5> {
	 obj_in => edit_obj;
	 vis+nres => vis_list[4].do;
      };
      DatamapEditor DatamapEditor<NEx=X3,NEy=Y6> {
	 view_in => edit_view;
	 obj_in => edit_obj;
	 vis+nres => vis_list[5].do;
      };
   };

   macro Object2DEditors {
      GDview_templ &edit_view<NEportLevels={2,1},NEx=X1,NEy=Y3>;
      GDobject_templ &edit_obj<NEportLevels={2,1},NEx=X2,NEy=Y2>;
      imlink vis_list<NEx=X4,NEy=YI>;

      ObjectEditor ObjectEditor<NEx=X1,NEy=Y5> {
	 camera_in => edit_view.picked_camera;
         obj_in => edit_obj;
	 vis+nres => vis_list[0].do;
      };
      XformEditor XformEditor<NEx=X2,NEy=Y5> {
	 obj_in => edit_obj;
	 vis+nres => vis_list[1].do;
      };
      PropsEditor PropsEditor<NEx=X3,NEy=Y5> {
	 obj_in => edit_obj;
	 vis+nres => vis_list[2].do;
      };
      ModesEditor ModesEditor<NEx=X4,NEy=Y5> {
	 obj_in => edit_obj;
	 vis+nres => vis_list[3].do;
      };
      DatamapEditor DatamapEditor<NEx=X3,NEy=Y6> {
	 view_in => edit_view;
	 obj_in => edit_obj;
	 vis+nres => vis_list[4].do;
      };
   };

   macro SimpleEditors {
      GDview_templ &edit_view<NEportLevels={2,1},NEy=Y2,NEx=X1>;
      ilink edit_rv<NEy=YI,NEx=X2>;
      imlink vis_list<NEy=YI,NEx=X3>;
      ilink selected<NEx=X4,NEy=YI>;

      ViewEditor ViewEditor<NEy=Y3,NEx=X2> {
         view_in => edit_view;
         vis+nres => vis_list[0].do;
      };
      ObjectSelector ObjectSelector<NEy=Y3,NEx=X3> {
         view_in => edit_view;
         vis+nres => vis_list[1].do;
      };
      VIEW.ObjectEditor ObjectEditor<NEy=Y4,NEx=X2> {
	 camera_in => edit_view.picked_camera;
         obj_in => ObjectSelector.cur_obj;
	 vis+nres => vis_list[2].do;
      };
      TrackEditor TrackEditor<NEy=Y4,NEx=X4> {
         view_in => edit_view;
	 camera_in => edit_view.picked_camera;
         obj_in => ObjectSelector.cur_obj;
         track_rv => edit_rv;
         vis = 0;
	 track_select => selected;
      };

      olink cur_obj<NEy=YO,NEx=X1> => ObjectSelector.cur_obj;
   };

   macro ViewUI {
      ilink name<NEx=X1,NEy=YI>;
      imlink cmd_list<NEx=X2,NEy=YI>;
      string+IPort2 &cur_obj_name<NEx=X3,NEy=YI>;

      /* main menu - empty list by default */
      UIcmdList MainMenu<NEx=X3,NEy=Y3> {
	 cmdList => cmd_list;
      };
      UIshell Shell<NEx=X1,NEy=Y4> {
	 title+IPort2 => name;
	 menu => MainMenu;
#ifndef MSDOS
	 width = 550;
	 height = 550;
#else
	 width = 558;
	 height = 565;
#endif
#ifdef FOO
	 width => 550 * UIdata.UIdisplays[0].scaleX;
	 height => 550 * UIdata.UIdisplays[0].scaleY;
#endif
      };
      UIpanel Panel<NEx=X2,NEy=Y4> {
	 parent => Shell;
	 width => <-.Shell.clientWidth;
	 height => <-.Shell.clientHeight;
#ifdef X_FILES_IMPLEMENTED
	 pixmap.filename = "bkg.x";
#endif
      };
      UIrenderView RenderView<NEx=X3,NEy=Y4> {
	 parent => Panel;
	 x = 25;
	 y = 25;
	 width => <-.Panel.width - 50;
	 height => <-.Panel.height - 60;
#ifdef FOO
	 x => 25 * UIdata.UIdisplays[0].scaleX;
	 y => 25 * UIdata.UIdisplays[0].scaleY;
	 width => <-.Panel.width - (50 * UIdata.UIdisplays[0].scaleX);
	 height => <-.Panel.height - (50 * UIdata.UIdisplays[0].scaleY);
#endif
	 handle+OPort2;
      };
      UIlabel UIlabel<NEx=517,NEy=220> {
         parent => Panel;
         label => <-.cur_obj_name;
         x = 25;
         y => ((<-.RenderView.y + <-.RenderView.height) + 5);
	 width => <-.RenderView.width - <-.ModalMenu.width - 5;
         alignment = 0;
      };
      Commands.UIoption UIoption<NEx=660,NEy=143> {
         label = "Rotate";
      };
      Commands.UIoption UIoption#1<NEx=660,NEy=99> {
         label = "Scale";
      };
      Commands.UIoption UIoption#2<NEx=660,NEy=55> {
         label = "Translate";
      };
      Commands.UIoption UIoption#3<NEx=660,NEy=11> {
         label = "Z Translate";
      };
      UIoptionMenu ModalMenu<NEx=682,NEy=220> {
         parent => <-.Panel;
         cmdList => {<-.UIoption,
            <-.UIoption#1,<-.UIoption#2,<-.UIoption#3};
         x => (<-.Panel.width - 200);
         y => ((<-.RenderView.y + <-.RenderView.height) + 5);
         label = "Left Button";
         selectedItem = 0;
      };
      olink shell<NEx=X1,NEy=YO> => Shell;
      olink panel<NEx=X2,NEy=YO> => Panel;
      olink rv<NEx=X3,NEy=YO> => RenderView;
      olink handle<NEx=X4,NEy=YO> => RenderView.handle;
      olink selected<NEx=X5,NEy=YO> => ModalMenu.selectedItem;
   };

   /* macro for use in embedding 3D views into a parent widget */
   macro View3D {
      UIrenderView &render_view<NEportLevels={2,1},NEx=X2,NEy=YI> {
	 UIwinHandle+OPort2 handle;
      };
      imlink objs<NEx=X1,NEy=YI>;

      /* interactor for picking */
      UItwoPoint InterPick<NEy=Y4,NEx=X3> {
	 view => render_view;
#ifndef MSDOS
	 startEvent = "Control<Btn1Down>";
	 runEvent = "Control<Btn1Motion>";
	 stopEvent = "Control<Btn1Up>";
#else
	 startEvent = "Control<BtnLDown>";
	 runEvent = "Control<BtnLMotion>";
	 stopEvent = "Control<BtnLUp>";
#endif
      };

      DefaultXform LightXform1<NEx=X2,NEy=Y2>;
      DefaultLightOn Light1<NEx=X2,NEy=Y3> {
	 xform => LightXform1;
      };
      DefaultXform LightXform2<NEx=X3,NEy=Y2>;
      DefaultLight Light2<NEx=X3,NEy=Y3> {
	 xform => LightXform2;
      };
      DefaultXform LightXform3<NEx=X4,NEy=Y2>;
      DefaultLight Light3<NEx=X4,NEy=Y3> {
	 xform => LightXform3;
      };
      DefaultXform LightXform4<NEx=X5,NEy=Y2>;
      DefaultLight Light4<NEx=X5,NEy=Y3> {
	 xform => LightXform4;
      };
      DefaultLightInfo+OPort LightInfo<NEx=X2,NEy=Y4> {
	 lights => { Light1, Light2, Light3, Light4 };
      };
      DefaultPickCtrl+OPort PickCtrl<NEy=275,NEx=X3> {
         x => InterPick.x;
         y => InterPick.y;
         event => InterPick.state;
	 on_start = 1;
      };
      GroupObject Top3D<NEx=X1,NEy=Y2> {
	 child_objs => objs;
	 Top {
	    name => name_of(<-.<-);
         };
      };
      DefaultXform CameraXform<NEx=X1,NEy=Y3> {
	 xlate = {0.0, 0.0, -12.0};
      };
      DefaultCamera3D+OPort Camera<NEx=X1,NEy=Y4> {
	 xform => CameraXform;
         objects => { Top3D.obj };
      };
      BestVirtPal VirtPal<NEx=X1,NEy=275>;
      DefaultView View<NEy=319,NEx=176> {
         handle => render_view.handle;
	 virtpal => VirtPal;
	 light_info => LightInfo;
         pick_ctrl => PickCtrl;
         cameras => { Camera };
	 renderer => Templates.CONFIG.gd_default_renderer + 0;
      };
      olink view<NEx=X1,NEy=YO> => View;
      olink picked_camera<NEx=X2,NEy=YO> => View.picked_camera;
      olink picked_obj<NEx=X3,NEy=YO> => View.picked_obj;
      olink two_point<NEx=X4,NEy=YO> => InterPick;
   };

   /* macro for use in embedding 2D views into a parent widget */
   macro View2D {
      UIrenderView &render_view<NEportLevels={2,1},NEx=X2,NEy=YI> {
	 UIwinHandle+OPort2 handle;
      };
      imlink objs<NEx=X1,NEy=YI>;

      /* interactor for picking */
      UItwoPoint InterPick<NEy=Y4,NEx=X3> {
         view => render_view;
#ifndef MSDOS
	 startEvent = "Control<Btn1Down>";
	 runEvent = "Control<Btn1Motion>";
	 stopEvent = "Control<Btn1Up>";
#else
	 startEvent = "Control<BtnLDown>";
	 runEvent = "Control<BtnLMotion>";
	 stopEvent = "Control<BtnLUp>";
#endif
      };

      DefaultPickCtrl+OPort PickCtrl<NEy=275,NEx=X3> {
         x => InterPick.x;
         y => InterPick.y;
         event => InterPick.state;
	 on_start = 1;
      };
      GroupObject Top2D<NEy=Y2,NEx=X1> {
	 child_objs => objs;
	 Top {
	    name => name_of(<-.<-);
         };
      };
      DefaultXform CameraXform<NEy=Y3,NEx=X1> {
	 xlate = {0.0, 0.0, -12.0};
      };
      DefaultCamera2D+OPort Camera<NEy=Y4,NEx=X1> {
	 xform => CameraXform;
         objects => { Top2D.obj };
      };
      BestVirtPal VirtPal<NEx=X1,NEy=275>;
      DefaultView View<NEy=319,NEx=176> {
         handle => render_view.handle;
	 virtpal => VirtPal;
         cameras => { Camera };
         pick_ctrl => PickCtrl;
      };
      olink view<NEx=X1,NEy=YO> => View;
      olink picked_camera<NEx=X2,NEy=YO> => View.picked_camera;
      olink picked_obj<NEx=X3,NEy=YO> => View.picked_obj;
      olink two_point<NEx=X4,NEy=YO> => InterPick;
   };

   /* macro for use in embedding combined views into a parent widget */
   macro View {
      UIrenderView &render_view<NEportLevels={2,1},NEx=X3,NEy=YI> {
	 UIwinHandle+OPort2 handle;
      };
      imlink objs_3d<NEx=X1,NEy=YI>;
      imlink objs_2d<NEx=X2,NEy=YI>;

      /* interactor for picking */
      UItwoPoint InterPick<NEy=Y4,NEx=X4> {
         view => render_view;
#ifndef MSDOS
	 startEvent = "Control<Btn1Down>";
	 runEvent = "Control<Btn1Motion>";
	 stopEvent = "Control<Btn1Up>";
#else
	 startEvent = "Control<BtnLDown>";
	 runEvent = "Control<BtnLMotion>";
	 stopEvent = "Control<BtnLUp>";
#endif
      };

      DefaultXform LightXform1<NEx=X3,NEy=Y2>;
      DefaultLightOn Light1<NEx=X3,NEy=Y3> {
	 xform => LightXform1;
      };
      DefaultXform LightXform2<NEx=X4,NEy=Y2>;
      DefaultLight Light2<NEx=X4,NEy=Y3> {
	 xform => LightXform2;
      };
      DefaultXform LightXform3<NEx=X5,NEy=Y2>;
      DefaultLight Light3<NEx=X5,NEy=Y3> {
	 xform => LightXform3;
      };
      DefaultXform LightXform4<NEx=X6,NEy=Y2>;
      DefaultLight Light4<NEx=X6,NEy=Y3> {
	 xform => LightXform4;
      };
      DefaultLightInfo+OPort LightInfo<NEx=X3,NEy=Y4> {
	 lights => { Light1, Light2, Light3, Light4 };
      };
      DefaultPickCtrl+OPort PickCtrl<NEy=275,NEx=X4> {
         x => InterPick.x;
         y => InterPick.y;
         event => InterPick.state;
	 on_start = 1;
      };
      GroupObject Top3D<NEy=Y2,NEx=X1> {
	 child_objs => objs_3d;
	 Top {
	    name => name_of(<-.<-);
         };
      };
      GroupObject Top2D<NEy=Y2,NEx=X2> {
	 child_objs => objs_2d;
	 Top {
	    name => name_of(<-.<-);
         };
      };
      DefaultXform Camera3DXform<NEy=Y3,NEx=X1> {
	 xlate = {0.0, 0.0, -12.0};
      };
      DefaultCamera3D+OPort Camera3D<NEy=Y4,NEx=X1> {
	 xform => Camera3DXform;
         objects => { Top3D.obj };
      };
      DefaultXform Camera2DXform<NEy=Y3,NEx=X2> {
	 xlate = {0.0, 0.0, -12.0};
      };
      DefaultCamera2D+OPort Camera2D<NEy=Y4,NEx=X2> {
	 xform => Camera2DXform;
         objects => { Top2D.obj };
      };
      BestVirtPal VirtPal<NEx=X1,NEy=275>;
      DefaultView View<NEy=319,NEx=176> {
         handle => render_view.handle;
	 virtpal => VirtPal;
         cameras => { Camera3D, Camera2D };
	 light_info => LightInfo;
         pick_ctrl => PickCtrl;
      };
      olink view<NEx=X1,NEy=YO> => View;
      olink picked_camera<NEx=X2,NEy=YO> => View.picked_camera;
      olink picked_obj<NEx=X3,NEy=YO> => View.picked_obj;
      olink two_point<NEx=X4,NEy=YO> => InterPick;
   };

   macro Simple3DView {
      UIrenderView UIrenderView<NEy=88,NEx=330> {
         parent<NEportLevels={3,0}>;
      };
      GroupObject GroupObject<NEx=473,NEy=154> {
         child_objs<NEportLevels={3,1}>;
      };
      DefaultLight DefaultLight<NEx=165,NEy=154> {
         type = 3;
         state = 1;
      };
      DefaultLightInfo DefaultLightInfo<NEx=165,NEy=220> {
         lights => {DefaultLight};
      };
      DefaultCamera3D DefaultCamera3D<NEx=462,NEy=209> {
         objects => {GroupObject.obj};
      };
      BestVirtPal VirtPal;
      DefaultView DefaultView<NEy=275,NEx=330> {
         handle => UIrenderView.handle;
	 virtpal => VirtPal;
         light_info => DefaultLightInfo;
         cameras => {DefaultCamera3D};
      };
   };

   /* macro for use in embedding 3D views into an external parent 
      widget */
   macro ExternalView3D {
      UIwindow ExternalWindow<NEx=X2,NEy=YI> {
	 UIwinHandle+OPort2 handle;
      };
      imlink objs<NEx=X1,NEy=YI>;

      /* interactor for picking */
      UItwoPoint InterPick<NEy=Y4,NEx=X3> {
	 view => ExternalWindow;
#ifndef MSDOS
	 startEvent = "Control<Btn1Down>";
	 runEvent = "Control<Btn1Motion>";
	 stopEvent = "Control<Btn1Up>";
#else
	 startEvent = "Control<BtnLDown>";
	 runEvent = "Control<BtnLMotion>";
	 stopEvent = "Control<BtnLUp>";
#endif
      };

      DefaultXform LightXform1<NEx=X2,NEy=Y2>;
      DefaultLightOn Light1<NEx=X2,NEy=Y3> {
	 xform => LightXform1;
      };
      DefaultXform LightXform2<NEx=X3,NEy=Y2>;
      DefaultLight Light2<NEx=X3,NEy=Y3> {
	 xform => LightXform2;
      };
      DefaultXform LightXform3<NEx=X4,NEy=Y2>;
      DefaultLight Light3<NEx=X4,NEy=Y3> {
	 xform => LightXform3;
      };
      DefaultXform LightXform4<NEx=X5,NEy=Y2>;
      DefaultLight Light4<NEx=X5,NEy=Y3> {
	 xform => LightXform4;
      };
      DefaultLightInfo+OPort LightInfo<NEx=X2,NEy=Y4> {
	 lights => { Light1, Light2, Light3, Light4 };
      };
      DefaultPickCtrl+OPort PickCtrl<NEy=275,NEx=X3> {
         x => InterPick.x;
         y => InterPick.y;
         event => InterPick.state;
	 on_start = 1;
      };
      GroupObject Top3D<NEx=X1,NEy=Y2> {
	 child_objs => objs;
	 Top {
	    name => name_of(<-.<-);
         };
      };
      DefaultXform CameraXform<NEx=X1,NEy=Y3> {
	 xlate = {0.0, 0.0, -12.0};
      };
      DefaultCamera3D+OPort Camera<NEx=X1,NEy=Y4> {
	 xform => CameraXform;
         objects => { Top3D.obj };
      };
      BestVirtPal VirtPal<NEx=X1,NEy=275>;
      DefaultView View<NEy=319,NEx=176> {
         handle => ExternalWindow.handle;
	 virtpal => VirtPal;
	 light_info => LightInfo;
         pick_ctrl => PickCtrl;
         cameras => { Camera };
	 renderer => Templates.CONFIG.gd_default_renderer + 0;
      };
      /* outputs - view and current object  */
      olink view<NEx=X1,NEy=YO> => View;
      olink picked_camera<NEx=X2,NEy=YO> => View.picked_camera;
      olink picked_obj<NEx=X3,NEy=YO> => View.picked_obj;
   };

   /* macro for use in embedding 2D views into an external parent 
      widget */
   macro ExternalView2D {
      UIwindow ExternalWindow<NEx=X2,NEy=YI> {
	 UIwinHandle+OPort2 handle;
      };
      imlink objs<NEx=X1,NEy=YI>;

      /* interactor for picking */
      UItwoPoint InterPick<NEy=Y4,NEx=X3> {
         view => ExternalWindow;
#ifndef MSDOS
	 startEvent = "Control<Btn1Down>";
	 runEvent = "Control<Btn1Motion>";
	 stopEvent = "Control<Btn1Up>";
#else
	 startEvent = "Control<BtnLDown>";
	 runEvent = "Control<BtnLMotion>";
	 stopEvent = "Control<BtnLUp>";
#endif
      };

      DefaultPickCtrl+OPort PickCtrl<NEy=275,NEx=X3> {
         x => InterPick.x;
         y => InterPick.y;
         event => InterPick.state;
	 on_start = 1;
      };
      GroupObject Top2D<NEy=Y2,NEx=X1> {
	 child_objs => objs;
	 Top {
	    name => name_of(<-.<-);
         };
      };
      DefaultXform CameraXform<NEy=Y3,NEx=X1> {
	 xlate = {0.0, 0.0, -12.0};
      };
      DefaultCamera2D+OPort Camera<NEy=Y4,NEx=X1> {
	 xform => CameraXform;
         objects => { Top2D.obj };
      };
      BestVirtPal VirtPal<NEx=X1,NEy=275>;
      DefaultView View<NEy=319,NEx=176> {
         handle => ExternalWindow.handle;
	 virtpal => VirtPal;
         cameras => { Camera };
         pick_ctrl => PickCtrl;
      };
      /* outputs - view and current object  */
      olink view<NEx=X1,NEy=YO> => View;
      olink picked_camera<NEx=X2,NEy=YO> => View.picked_camera;
      olink picked_obj<NEx=X3,NEy=YO> => View.picked_obj;
   };

};	/* end of library Components */

/* Expose the View macros outside of any library
   for easy user access.
*/

/***********************************************************************/
/* Built-in Viewers                                                    */
/***********************************************************************/
library+global+buffered Viewers {
/* 3D View with a full user interface */
macro Viewer3D<NEsmallPixmapName="viewer.bmx"> {
   imlink objs_in<NEx=X1,NEy=YI>;
   GDview_buffers &in_buffers<NEx=X2,NEy=YI,NEportLevels={2,1}>;

   /* view & object command lists for main main */
   ViewCmdList ViewCmdList<NEx=X3,NEy=Y2>;
   ObjCmdList ObjCmdList<NEx=X4,NEy=Y2>;

   /* macro that contains the app, mw, main menu, panel & render view */
   ViewUI ViewUI<NEx=X2,NEy=Y3> {
      name = "View";
      cmd_list => { ViewCmdList.cmdList, ObjCmdList.cmdList };
      cur_obj_name => <-.ViewEditors.ObjectSelector.obj_selector.curobj_name;
   };
   View3D View3D<NEx=X5,NEy=Y4> {
      render_view => ViewUI.rv;
      objs => objs_in;
      DefaultFieldOutput DefaultFieldOutput<NEx=520,NEy=275> {
	 buffers<NEportLevels={0,4}>;
      };
      View {
	 output => <-.DefaultFieldOutput;
	 buffers<NEportLevels={3,0}> => <-.<-.in_buffers;
      };
   };

   ViewEditors ViewEditors<NEx=X3,NEy=Y5> {
      edit_view => View3D.view;
      edit_rv => ViewUI.rv;
      vis_list => ViewCmdList.cmds;
      selected => ViewUI.selected;
   };
   ObjectEditors ObjectEditors<NEx=X4,NEy=Y5> {
      edit_view => View3D.view;
      edit_obj => ViewEditors.cur_obj;
      vis_list => ObjCmdList.cmds;
   };

   olink rv           <NEx=X1,NEy=YO> => ViewUI.rv;
   olink two_point    <NEx=X2,NEy=YO> => View3D.two_point;
   olink view         <NEx=X3,NEy=YO> => View3D.view;
   olink picked_camera<NEx=X4,NEy=YO> => View3D.picked_camera;
   olink picked_obj   <NEx=X5,NEy=YO> => View3D.picked_obj;
   olink cur_obj      <NEx=X6,NEy=YO> => ViewEditors.cur_obj;
};

/* 3D View with a limited user interface */
macro SimpleViewer3D<NEsmallPixmapName="viewer.bmx"> {
   imlink objs_in<NEx=X1,NEy=YI>;

   SimpleCmdList SimpleCmdList<NEx=X3,NEy=Y2>;

   /* macro that contains the app, mw, main menu, panel & render view */
   ViewUI ViewUI<NEx=X2,NEy=Y3> {
      name = "View";
      cmd_list => { SimpleCmdList.cmdList };
      cur_obj_name => <-.SimpleEditors.ObjectSelector.obj_selector.curobj_name;
   };
   View3D View3D<NEx=X5,NEy=Y4> {
      render_view => ViewUI.rv;
      objs => objs_in;
   };

   SimpleEditors SimpleEditors<NEx=X3,NEy=Y5> {
      edit_view => View3D.view;
      edit_rv => ViewUI.rv;
      vis_list => SimpleCmdList.cmds;
      selected => ViewUI.selected;
   };

   olink rv           <NEx=X1,NEy=YO> => ViewUI.rv;
   olink two_point    <NEx=X2,NEy=YO> => View3D.two_point;
   olink view         <NEx=X3,NEy=YO> => View3D.view;
   olink picked_camera<NEx=X4,NEy=YO> => View3D.picked_camera;
   olink picked_obj   <NEx=X5,NEy=YO> => View3D.picked_obj;
   olink cur_obj      <NEx=X6,NEy=YO> => SimpleEditors.cur_obj;
};


/* 2D View with a full user interface */
macro Viewer2D<NEsmallPixmapName="viewer.bmx"> {
   imlink objs_in<NEx=X1,NEy=YI>;
   GDview_buffers &in_buffers<NEx=X2,NEy=YI,NEportLevels={2,1}>;

   /* view & object command lists for main main */
   View2DCmdList View2DCmdList<NEx=X3,NEy=Y2>;
   Obj2DCmdList Obj2DCmdList<NEx=X4,NEy=Y2>;

   /* macro that contains the app, mw, main menu, panel & render view */
   ViewUI ViewUI<NEx=X2,NEy=Y3> {
      name = "View";
      cmd_list => { View2DCmdList.cmdList, Obj2DCmdList.cmdList };
      cur_obj_name => <-.View2DEditors.ObjectSelector.obj_selector.curobj_name;
      /* set the default interaction to translate for 2D view. */
      ModalMenu {
	 selectedItem = 2;
      };
   };
   View2D View2D<NEx=X5,NEy=Y4> {
      render_view => ViewUI.rv;
      objs => objs_in;
      DefaultFieldOutput DefaultFieldOutput<NEx=520,NEy=275> {
	 buffers<NEportLevels={0,4}>;
      };
      View {
	 output => <-.DefaultFieldOutput;
	 buffers<NEportLevels={3,0}> => <-.<-.in_buffers;
      };
   };

   View2DEditors View2DEditors<NEx=X3,NEy=Y5> {
      edit_view => View2D.view;
      edit_rv => ViewUI.rv;
      vis_list => View2DCmdList.cmds;
      selected => ViewUI.selected;
   };
   Object2DEditors Object2DEditors<NEx=X4,NEy=Y5> {
      edit_view => View2D.view;
      edit_obj => View2DEditors.cur_obj;
      vis_list => Obj2DCmdList.cmds;
   };

   olink rv           <NEx=X1,NEy=YO> => ViewUI.rv;
   olink two_point    <NEx=X2,NEy=YO> => View2D.two_point;
   olink view         <NEx=X3,NEy=YO> => View2D.view;
   olink picked_camera<NEx=X4,NEy=YO> => View2D.picked_camera;
   olink picked_obj   <NEx=X5,NEy=YO> => View2D.picked_obj;
   olink cur_obj      <NEx=X6,NEy=YO> => View2DEditors.cur_obj;
};

/* 2D View with a limited user interface */
macro SimpleViewer2D<NEsmallPixmapName="viewer.bmx"> {
   imlink objs_in<NEx=X1,NEy=YI>;

   SimpleCmdList SimpleCmdList<NEx=X3,NEy=Y2>;

   /* macro that contains the app, mw, main menu, panel & render view */
   ViewUI ViewUI<NEx=X2,NEy=Y3> {
      name = "View";
      cmd_list => { SimpleCmdList.cmdList };
      cur_obj_name => <-.SimpleEditors.ObjectSelector.obj_selector.curobj_name;
      /* set the default interaction to translate for 2D view. */
      ModalMenu {
	 selectedItem = 2;
      };
   };
   View2D View2D<NEx=X5,NEy=Y4> {
      render_view => ViewUI.rv;
      objs => objs_in;
   };

   SimpleEditors SimpleEditors<NEx=X3,NEy=Y5> {
      edit_view => View2D.view;
      edit_rv => ViewUI.rv;
      vis_list => SimpleCmdList.cmds;
      selected => ViewUI.selected;
   };

   olink rv           <NEx=X1,NEy=YO> => ViewUI.rv;
   olink two_point    <NEx=X2,NEy=YO> => View2D.two_point;
   olink view         <NEx=X3,NEy=YO> => View2D.view;
   olink picked_camera<NEx=X4,NEy=YO> => View2D.picked_camera;
   olink picked_obj   <NEx=X5,NEy=YO> => View2D.picked_obj;
   olink cur_obj      <NEx=X6,NEy=YO> => SimpleEditors.cur_obj;
};

/* View with a full user interface */
macro Viewer<NEsmallPixmapName="viewer.bmx"> {
   imlink objs_3d_in<NEx=X1,NEy=YI>;
   imlink objs_2d_in<NEx=X2,NEy=YI>;
   GDview_buffers &in_buffers<NEx=X3,NEy=YI,NEportLevels={2,1}>;

   /* view & object command lists for main main */
   ViewCmdList ViewCmdList<NEx=X3,NEy=Y2>;
   ObjCmdList ObjCmdList<NEx=X4,NEy=Y2>;

   /* macro that contains the app, mw, main menu, panel & render view */
   ViewUI ViewUI<NEx=X2,NEy=Y3> {
      name = "View";
      cmd_list => { ViewCmdList.cmdList, ObjCmdList.cmdList };
      cur_obj_name => <-.ViewEditors.ObjectSelector.obj_selector.curobj_name;
   };
   View View<NEx=X5,NEy=Y4> {
      render_view => ViewUI.rv;
      objs_3d => objs_3d_in;
      objs_2d => objs_2d_in;
      DefaultFieldOutput DefaultFieldOutput<NEx=520,NEy=275> {
	 buffers<NEportLevels={0,4}>;
      };
      View {
	 output => <-.DefaultFieldOutput;
	 buffers<NEportLevels={3,0}> => <-.<-.in_buffers;
      };
   };

   ViewEditors ViewEditors<NEx=X3,NEy=Y5> {
      edit_view => View.view;
      edit_rv => ViewUI.rv;
      vis_list => ViewCmdList.cmds;
      selected => ViewUI.selected;
   };
   ObjectEditors ObjectEditors<NEx=X4,NEy=Y5> {
      edit_view => View.view;
      edit_obj => ViewEditors.cur_obj;
      vis_list => ObjCmdList.cmds;
   };

   olink rv           <NEx=X1,NEy=YO> => ViewUI.rv;
   olink two_point    <NEx=X2,NEy=YO> => View.two_point;
   olink view         <NEx=X3,NEy=YO> => View.view;
   olink picked_camera<NEx=X4,NEy=YO> => View.picked_camera;
   olink picked_obj   <NEx=X5,NEy=YO> => View.picked_obj;
   olink cur_obj      <NEx=X6,NEy=YO> => ViewEditors.cur_obj;
};

/* Combined view with a limited user interface */
macro SimpleViewer<NEsmallPixmapName="viewer.bmx"> {
   imlink objs_3d_in<NEx=X1,NEy=YI>;
   imlink objs_2d_in<NEx=X2,NEy=YI>;

   SimpleCmdList SimpleCmdList<NEx=X3,NEy=Y2>;

   /* macro that contains the app, mw, main menu, panel & render view */
   ViewUI ViewUI<NEx=X2,NEy=Y3> {
      name = "View";
      cmd_list => { SimpleCmdList.cmdList };
      cur_obj_name => <-.SimpleEditors.ObjectSelector.obj_selector.curobj_name;
   };
   View View<NEx=X5,NEy=Y4> {
      render_view => ViewUI.rv;
      objs_3d => objs_3d_in;
      objs_2d => objs_2d_in;
   };

   SimpleEditors SimpleEditors<NEx=X3,NEy=Y5> {
      edit_view => View.view;
      edit_rv => ViewUI.rv;
      vis_list => SimpleCmdList.cmds;
      selected => ViewUI.selected;
   };

   olink rv           <NEx=X1,NEy=YO> => ViewUI.rv;
   olink two_point    <NEx=X2,NEy=YO> => View.two_point;
   olink view         <NEx=X3,NEy=YO> => View.view;
   olink picked_camera<NEx=X4,NEy=YO> => View.picked_camera;
   olink picked_obj   <NEx=X5,NEy=YO> => View.picked_obj;
   olink cur_obj      <NEx=X6,NEy=YO> => SimpleEditors.cur_obj;
};

#ifdef PRT_RENDERER
macro PrintViewer<NEx=264,NEy=429,NEsmallPixmapName="viewer.bmx",
		  disabled => (Templates.CONFIG.gd_prt_disabled |
			      Templates.CONFIG.ag_kit_disabled)> {
   UIrenderView &fromRenderView<NEx=33,NEy=297,NEportLevels={2,1}> {
      width+opt<NEportLevels={0,2}>;
      height+opt<NEportLevels={0,2}>;
   };
   float fromWidth<NEportLevels={1,0},NEx=33,NEy=352> => .fromRenderView.width;
   float fromHeight<NEportLevels={1,0},NEx=33,NEy=385> => .fromRenderView.height;
   GDview_templ &view_in<NEportLevels={2,1},NEx=33,NEy=55>;
   UImod_panel Dialog<NEx=220,NEy=11> {
      height<NEdisplayMode="open"> = 400;
      title = "Print Viewer";
   };
#ifdef MSDOS
   UIprintDialog printDialog<NEx=220,NEy=11>{
       visible => SetupButton.do;
       colors => <-.Output.color;
       orientation => <-.Output.orientation;
       size => <-.Output.size;
   };
#endif
   UIrenderView HCRenderView<NEx=198,NEy=121> {
      parent => <-.fromRenderView.parent;
      x = 0;
      y = 0;
#ifdef MSDOS
      width<NEportLevels={2,0}> = 500;
      height<NEportLevels={2,0}> = 500;
#else
      width<NEportLevels={2,0}> = 10;
      height<NEportLevels={2,0}> = 10;
#endif
      visible = 0;
   };
   DefaultPrtOutput Output<NEx=33,NEy=462,NEwidth=176,NEheight=220> {
      fromRatio => (<-.fromWidth / <-.fromHeight);
      fromWidth => <-.fromWidth;
      fromHeight => <-.fromHeight;
#ifdef MSDOS
      devMode => <-.printDialog.devMode;
      devNames => <-.printDialog.devNames;
#endif
   };
   BestVirtPal VirtPal<NEx=33,NEy=121> {
      vclass => view_in.virtpal.vclass;
      vid => view_in.virtpal.vid;
      cube_size => view_in.virtpal.cube_size;
   };

   group backgroundColors<NEx=33,NEy=242>[3] {
       float color[3];
   } = {{color={1,1,1}},
        {color={0,0,0}},
        {color=>view_in.back_col}};
   DefaultView View<NEy=198,NEx=33> {
      renderer = GD_PRT_RENDERER;
#ifdef MSDOS
      refresh<NEportLevels={2,2}> => <-.PrintButton.do;
#else
      refresh<NEportLevels={2,2}> => <-.Create_File.do;
#endif
      mode = 0;
      back_col => backgroundColors[BackgroundMenu.selectedItem].color;
      light_info => view_in.light_info;
      handle => <-.HCRenderView.handle;
      virtpal => <-.VirtPal;
      output => <-.Output;
      output_enabled = 1;
      cameras => view_in.cameras;
      buffer = 0;
   };
#ifdef MSDOS
   UIlabel Title<NEx=539,NEy=14> {
     parent 	=> <-.Dialog;
     label 	= "Print Viewer";
     alignment 	= 1;
     y 		= 0;
     width	=> <-.Dialog.width;
   };
   UIframeShadowOut ResFrame<NEx=539,NEy=44,NEportLevels={0,1}> {
     parent => <-.Dialog;
     y		=> <-.Title.y + <-.Title.height + 4;
     width	=> <-.Dialog.width;
     height	=> ResYField.y + ResYField.height + 8;
   };
   UIlabel ResXLabel<NEx=539,NEy=74>{
     parent	=> ResFrame;
     label	= "X Resolution:";
     y		= 0;
   };
   UIfield ResXField<NEx=539,NEy=104> {
     parent	=> ResFrame;
     y		=> ResXLabel.y + ResXLabel.height;
     decimalPoints = 0;
     value	=> <-.HCRenderView.width;
   };
   UIlabel ResYLabel<NEx=539,NEy=134> {
     parent	=> ResFrame;
     label	= "Y Resolution:";
     y		=> ResXField.y + ResXField.height;
   };
   UIfield ResYField<NEx=539,NEy=164> {
     parent	=> ResFrame;
     y		=> ResYLabel.y + ResYLabel.height;
     decimalPoints = 0;
     value	=> <-.HCRenderView.height;
   };
   UIbutton SetupButton<NEx=539,NEy=194> {
     parent	=> <-.Dialog;
     label	=> "Print Setup";
     y 		=> ResFrame.y + ResFrame.height + 8;
     width	=> ResFrame.width;
   };
   UIoption White<NEx=539,NEy=231>;
   UIoption Black<NEx=693,NEy=231>;
   UIoption Keep<NEx=693,NEy=264>;
   UIoptionMenu BackgroundMenu<NEx=385,NEy=231,NEwidth=209,NEheight=286> {
      y => SetupButton.y + SetupButton.height + 12;
      height = 30;
      parent => <-.Dialog;
      label = "Background";
      cmdList => {<-.White,<-.Black,<-.Keep};
      selectedItem<NEportLevels={2,2}> => <-.Output.backgroundType;
   };

   UIbutton PrintButton<NEx=539,NEy=194> {
     parent	=> <-.Dialog;
     label	=> "Print";
     y 		=> BackgroundMenu.y + BackgroundMenu.height + 8;
     width	=> ResFrame.width;
   };

#else
   UIlabel Title<NEx=385,NEy=11> {
      y = 0;
      width => <-.Dialog.width;
      parent => <-.Dialog;
      label = "Print Viewer Dialog";
      alignment = 1;
   };
   UIoption PostScript<NEx=539,NEy=55> {
      label = "PostScript";
   };
   UIoption ColorPostScript<NEx=693,NEy=55> {
      label = "Color PostScript";
   };
   UIoption PostScript_2<NEx=539,NEy=88> {
      label = "PostScript Lev 2";
   };
   UIoption CGMBinary<NEx=693,NEy=88> {
      label = "CGM Binary";
   };
   UIoption CGMClearText<NEx=539,NEy=121> {
      label = "CGM Clear Text";
   };
   UIoption CGMCharacter<NEx=693,NEy=121> {
      label = "CGM Character";
   };
   UIoptionMenu FormatMenu<NEx=385,NEy=55> {
      y => ((<-.Title.y + <-.Title.height) + 4);
      height = 30;
      parent => <-.Dialog;
      label = "Format";
      cmdList => {
         <-.PostScript,<-.ColorPostScript,<-.PostScript_2,
         <-.CGMBinary,<-.CGMClearText,<-.CGMCharacter
      };
      selectedItem<NEportLevels={2,2}> => <-.Output.format;
   };
   UIoption LandScape<NEx=539,NEy=198> {
      label = "Landscape";
   };
   UIoption Portrait<NEx=693,NEy=198> {
      label = "Portrait";
   };
   UIoptionMenu OrientationMenu<NEx=385,NEy=198,NEwidth=209,NEheight=286> {
      y => ((<-.FormatMenu.y + <-.FormatMenu.height) + 4);
      height = 30;
      parent => <-.Dialog;
      label = "Orientation";
      cmdList => {<-.LandScape,
         <-.Portrait};
      selectedItem<NEportLevels={2,2}> => <-.Output.orientation;
   };
   UIoption White<NEx=539,NEy=231>;
   UIoption Black<NEx=693,NEy=231>;
   UIoption Keep<NEx=693,NEy=264>;
   UIoptionMenu BackgroundMenu<NEx=385,NEy=231,NEwidth=209,NEheight=286> {
      y => ((<-.OrientationMenu.y + <-.OrientationMenu.height) + 4);
      height = 30;
      parent => <-.Dialog;
      label = "Background";
      cmdList => {<-.White,<-.Black,<-.Keep};
      selectedItem<NEportLevels={2,2}> => <-.Output.backgroundType;
   };
   UIoption User_EPS<NEx=539,NEy=308> {
      label = "User (EPS)";
   };
   UIoption A<NEx=693,NEy=308> {
      label = "A (Letter)";
   };
   UIoption B<NEx=539,NEy=341> {
      label = "B";
   };
   UIoption A4<NEx=693,NEy=341> {
      label = "A4";
   };
   UIoption A3<NEx=539,NEy=374> {
      label = "A3";
   };
   UIoption A0 {
      label = "A0";
   };
   UIoptionMenu SizeMenu<NEx=385,NEy=308> {
      y => ((<-.BackgroundMenu.y + <-.BackgroundMenu.height) + 4);
      height = 30;
      parent => <-.Dialog;
      label = "Size";
      cmdList => {
         <-.User_EPS,<-.A,<-.B,<-.A4,<-.A3,<-.A0
      };
      selectedItem<NEportLevels={2,2}> => <-.Output.size;
   };
   UIlabel WidthMM<NEx=385,NEy=429> {
      y => ((<-.SizeMenu.y + <-.SizeMenu.height) + 4);
      width = 80;
      height => <-.WidthValue.height;
      active<NEportLevels={2,0}> => <-.User_EPS.set;
      parent => <-.Dialog;
   };
   UIfield WidthValue<NEx=539,NEy=429> {
      y => <-.WidthMM.y;
      width => (<-.Dialog.width - 84);
      active<NEportLevels={2,0}> => <-.User_EPS.set;
      parent => <-.Dialog;
      min = 10;
      value => <-.Output.widthMM;
      x => (WidthMM.x + WidthMM.width);
   };
   UIlabel HeightMM<NEx=385,NEy=473> {
      y => ((<-.WidthMM.y + <-.WidthMM.height) + 4);
      width = 80;
      height => <-.WidthValue.height;
      active<NEportLevels={2,0}> => <-.User_EPS.set;
      parent => <-.Dialog;
   };
   UIfield HeightValue<NEx=539,NEy=473> {
      y => <-.HeightMM.y;
      width => (<-.Dialog.width - 84);
      active<NEportLevels={2,0}> => <-.User_EPS.set;
      parent => <-.Dialog;
      min = 10;
      value => <-.Output.heightMM;
      x => (HeightMM.x + HeightMM.width);
   };
   UIslider ResolutionSlider<NEx=385,NEy=517> {
      y => (HeightMM.y + HeightMM.height);
      width => <-.Dialog.width;
      parent => <-.Dialog;
      min = 100;
      max = 2000;
      value<NEportLevels={2,2}> => <-.Output.resolution;
      decimalPoints = 1;
      title = "3D Horizontal Resolution";
   };
   UIlabel File<NEx=385,NEy=572> {
      y => ((<-.ResolutionSlider.y + <-.ResolutionSlider.height) + 4);
      width = 32;
      height => <-.FileText.height;
      parent => <-.Dialog;
   };
   UItext FileText<NEx=539,NEy=572> {
      y => <-.File.y;
      width => (((<-.Dialog.width - 36) - <-.OpenFileDialog.width) - 4);
      parent => <-.Dialog;
      text<NEportLevels={2,0}> => <-.Output.file;
      x => (File.x + File.width);
      updateMode = 2;
   };
   UIbutton OpenFileDialog<NEx=693,NEy=572> {
      x => (<-.Dialog.width - .width);
      width = 32;
      y => <-.File.y;
      height => <-.FileText.height;
      parent => <-.Dialog;
      label = "...";
   };
   StandardDialogs.UIfileDialog UIfileDialog<NEx=693,NEy=616> {
      visible => <-.OpenFileDialog.do;
      title = "Print Output File Dialog";
      filename<NEportLevels={2,2}> => <-.Output.file;
   };
   UIbutton Create_File<NEx=385,NEy=616> {
      y => ((<-.File.y + <-.File.height) + 4);
      width => <-.Dialog.width;
      parent => <-.Dialog;
      label = "Create Print File";
   };
#endif
};
#endif

macro OutputField <NEhelp=0> {
   UIrenderView &render_view<NEportLevels={2,1}>;
   GDview_templ &view_in<NEportLevels={2,1}>;

   /* User Interface widgets that will appear on
      the Module Stack.
   */
   UImod_panel UImod_panel {
      title => name_of(<-.<-);
      height => <-. UIbutton.y + UIbutton.height + 5;
   };
   UIslider UIslider {
      parent => <-.UImod_panel;
      y = 5;
      value = 500;
      max = 4096;
      mode = 1;
      title = "Width";
   };
   UIslider UIslider#1 {
      parent => <-.UImod_panel;
      y => <-.UIslider.y + <-.UIslider.height + 5;
      value = 500;
      max = 4096;
      mode = 1;
      title = "Height";
   };
   UItoggle UItoggle {
      parent => <-.UImod_panel;
      y => <-.UIslider#1.y + <-.UIslider#1.height + 5;
      label = "Flip";
      set => Output.flip;
   };
   UItoggle UItoggle#1 {
      parent => <-.UImod_panel;
      y => <-.UItoggle.y + <-.UItoggle.height + 5;
      label = "Dynamic";
      set => View.mode;
   };
   UIbutton UIbutton {
      parent => <-.UImod_panel;
      y => <-.UItoggle#1.y + <-.UItoggle#1.height + 5;
      label = "Output";
      do => View.refresh;
   };

   UIrenderView UIrenderView {
      parent => <-.render_view.parent;
      x = 0;
      y = 0;
      width => UIslider.value;
      height => UIslider#1.value;
      visible = 0;
   };

   /* For output we don't want to gamma correct and
      we want to make sure we get all the colors we
      can so we want a private colormap.
   */
   BestVirtPal VirtPal {
      vclass => view_in.virtpal.vclass;
      vid => view_in.virtpal.vid;
      share = 0;
      cube_size => view_in.virtpal.cube_size;
      gamma = 1.0;
   };
   DefaultFieldOutput Output<export_all=3> {
      type<NEvisible=0>;
      output<NEportLevels={0,3}>;
   };
   DefaultView View {
      /* Setup in the output viewer with
	 manual update mode so we won't try
	 to output every time the view refreshes.
	 Make sure we are also in the software
	 renderer.
      */
      mode = 0;
      renderer = GD_SWX_RENDERER;
      back_col => view_in.back_col;
      blend_mode => view_in.blend_mode;
      handle => UIrenderView.handle;
      virtpal => VirtPal;
      light_info => view_in.light_info;
      output => Output;
      output_enabled = 1;
      cameras => view_in.cameras;
   };
   GD.DataObject DataObject {
      in => Output.output;
      obj+OPort3;
   };
};

macro OutputFile <NEhelp=0> {
   UIrenderView &render_view<NEportLevels={2,1}>;
   GDview_templ &view_in<NEportLevels={2,1}>;

   /* User Interface widgets that will appear on
      the Module Stack.
   */
   UImod_panel UImod_panel {
      title => name_of(<-.<-);
      height => <-.UIbutton#1.y + <-.UIbutton#1.height + 5;
   };
   UIbutton UIbutton {
      parent => <-.UImod_panel;
      y = 5;
      label = "Filename...";
   };
   UIslider UIslider {
      parent => <-.UImod_panel;
      y => <-.UIbutton.y + <-.UIbutton.height + 5;
      value = 500;
      max = 4096;
      mode = 1;
      title = "Width";
   };
   UIslider UIslider#1 {
      parent => <-.UImod_panel;
      y => <-.UIslider.y + <-.UIslider.height + 5;
      value = 500;
      max = 4096;
      mode = 1;
      title = "Height";
   };
   UItoggle UItoggle {
      parent => <-.UImod_panel;
      y => <-.UIslider#1.y + <-.UIslider#1.height + 5;
      label = "Flip";
      set => <-.Output.flip;
   };
   UItoggle UItoggle#1 {
      parent => <-.UImod_panel;
      y => <-.UItoggle.y + <-.UItoggle.height + 5;
      label = "Dynamic";
      set => <-.View.mode;
   };
   UIbutton UIbutton#1 {
      parent => <-.UImod_panel;
      y => <-.UItoggle#1.y + <-.UItoggle#1.height + 5;
      label = "Output";
      do => <-.View.refresh;
   };
   UIfileSB UIfileSB {
      parent =>  <-.UImod_panel;
      title = "Output Filename";
      visible => UIbutton.do;
      filename => <-.Output.filename;
      searchPattern = "";
   };

   UIrenderView UIrenderView {
      parent => <-.render_view.parent;
      x = 0;
      y = 0;
      width => UIslider.value;
      height => UIslider#1.value;
      visible = 0;
   };

   /* For output we don't want to gamma correct and
      we want to make sure we get all the colors we
      can so we want a private colormap.
   */
   BestVirtPal VirtPal {
      vclass => view_in.virtpal.vclass;
      vid => view_in.virtpal.vid;
      share = 0;
      cube_size => view_in.virtpal.cube_size;
      gamma = 1.0;
   };
   DefaultFileOutput Output<export_all=3> {
      type<NEvisible=0>;
   };
   DefaultView View {
      /* Setup in the output viewer with
	 manual update mode so we won't try
	 to output every time the view refreshes.
	 Make sure we are also in the software
	 renderer.
      */
      mode = 0;
      renderer = GD_SWX_RENDERER;
      back_col => view_in.back_col;
      blend_mode => view_in.blend_mode;
      handle => UIrenderView.handle;
      virtpal => VirtPal;
      light_info => view_in.light_info;
      output => Output;
      output_enabled = 1;
      cameras => view_in.cameras;
   };
};

#ifdef VRML_RENDERER
macro OutputVRML<disabled => Templates.CONFIG.gd_vrml_disabled>
{
   GDview_templ &view_in <NEx=55,NEy=44,NEportLevels={2,1}>;

   UIrenderView+nres &render_view <NEx=253,NEy=44> => view_in.render_view;

   // Note that used to be vmrlUI
   macro vrmlUI <NEx=66,NEy=231> {

   UImod_panel vrmlModPanel {
      parent <NEportLevels={3,0}>;
      title => name_of(<-.<-.<-);
      width  = 250;
      height = 600;
   };

   VUI.VUIFileSelector vrmlFile {
      title        =  "VRML File";
      parent       => <-.vrmlModPanel;
      x            =  4;
      y            =  4;
      width        => <-.vrmlModPanel.width - 8;
      filetype     =  "wrl";
      file <NEportLevels={3,0}> => <-.<-.vrmlOutput.file;
      fileText.updateMode = 2;
   };

   VUI.VUIRadioBox vrmlRB {
      label        =  "Protocol";
      parent       => <-.vrmlModPanel;
      x            => <-.vrmlFile.x;
      y+nres       => <-.vrmlFile.y + <-.vrmlFile.height + 4;
      width        => <-.vrmlFile.width;
      options      => { "VRML 1", "VRML 2" };
      selectedItem <NEportLevels={3,0}> => <-.<-.vrmlOutput.protocol;
   };

   VUI.VUIField vrmlFloatP {
      label        =  "Float Precision";
      parent       => <-.vrmlModPanel;
      x            => <-.vrmlRB.x;
      y+nres       => <-.vrmlRB.y + <-.vrmlRB.height + 4;
      width        => <-.vrmlRB.width + 1;
      min          = 1;
      max          = 8;
      mode         = 1;
      value <NEportLevels={3,0}> => <-.<-.vrmlOutput.floatPrec;
   };

   VUI.VUIField vrmlColorP {
      label        =  "Color Precision";
      parent       => <-.vrmlModPanel;
      x            => <-.vrmlFloatP.x;
      y+nres       => <-.vrmlFloatP.y + <-.vrmlFloatP.height + 4;
      width        => <-.vrmlFloatP.width - 1;
      min          = 1;
      max          = 8;
      mode         = 1;
      value <NEportLevels={3,0}> => <-.<-.vrmlOutput.colorPrec;
   };

   VUI.VUIToggle vrmlIndent {
      label        =  "Indent format";
      parent       => <-.vrmlModPanel;
      x            => <-.vrmlColorP.x;
      y+nres       => <-.vrmlColorP.y + <-.vrmlColorP.height + 4;
      width        => <-.vrmlColorP.width;
      set <NEportLevels={3,0}> => <-.<-.vrmlOutput.indent;
   };

   VUI.VUIToggle vrmlNormals {
      label        =  "Suppress Normals";
      parent       => <-.vrmlModPanel;
      x            => <-.vrmlIndent.x;
      y+nres       => <-.vrmlIndent.y + <-.vrmlIndent.height + 4;
      width        => <-.vrmlIndent.width;
      set <NEportLevels={3,0}> => <-.<-.vrmlOutput.suppressNormals;
   };

   VUI.VUIToggle vrmlDynamic {
      label        =  "Dynamic";
      parent       => <-.vrmlModPanel;
      x            => <-.vrmlNormals.x;
      y+nres       => <-.vrmlNormals.y + <-.vrmlNormals.height + 4;
      width        => <-.vrmlNormals.width;
      set <NEportLevels={3,0}> => <-.<-.vrmlView.mode;
   };

   UIbutton refreshButton {
      label        =  "Write VRML";
      parent       => <-.vrmlModPanel;
      x            => <-.vrmlDynamic.x;
      y+nres       => <-.vrmlDynamic.y + <-.vrmlDynamic.height + 4;
      width        => <-.vrmlDynamic.width;
      visible      => 1 - <-.vrmlDynamic.set;  // manual only
   };

   // this needs to force the view to VRML
   // since the GD sometimes defaults to SW !

   // Cannot use #defines in parse v in a runtime
   int vrml_renderer_number = GD_VRML_RENDERER;

   GMOD.parse_v doVRML {
      v_commands =
         "$push
            vrmlView.renderer = vrmlUI.vrml_renderer_number;
          $pop
          vrmlView.refresh = 1;";
      on_inst  = 0;
      trigger  => <-.refreshButton.do;
      relative => <-.<-;
   };

   }; // vrmlUI

   UIrenderView vrmlRV <NEx=330,NEy=99>{
      parent  => <-.render_view.parent;
      x       =  0;
      y       =  0;
      width   => <-.render_view.width;
      height  => <-.render_view.height;
      visible =  0;
   };

   BestVirtPal vrmlPal <NEx=451,NEy=143> {
      vclass    => view_in.virtpal.vclass;
      vid       => view_in.virtpal.vid;
      share     = 0;
      cube_size => view_in.virtpal.cube_size;
      gamma     = 1.0;
   };

   DefaultVrmlOutput vrmlOutput <NEx=66,NEy=143,export_all=3> {
      file      <NEportLevels={0,2}>;
      protocol  <NEportLevels={0,2}>;
      floatPrec <NEportLevels={0,2}>;
      colorPrec <NEportLevels={0,2}>;
      indent    <NEportLevels={0,2}>;
      suppressNormals<NEportLevels={0,2}> = 0;
      xformPrec => floatPrec;
      width     => <-.render_view.width;
      height    => <-.render_view.height;
   };

   DefaultView vrmlView <NEx=264,NEy=264> {
      mode           =  0;
      renderer       =  GD_VRML_RENDERER;
      handle         => <-.vrmlRV.handle;
      virtpal        => vrmlPal;
      back_col       => view_in.back_col;
      light_info     => view_in.light_info;
      cameras        => view_in.cameras;
      output         => vrmlOutput;
      output_enabled = 0;     // doesn't generate color or z buffers
      mode <NEportLevels={0,2}>;
   };
};
#endif

#ifdef VPS_RENDERER
macro OutputVPS <disabled => Templates.CONFIG.gd_vps_disabled>
{
   GDview_templ &view_in <NEx=55,NEy=44,NEportLevels={2,1}>;

   UIrenderView+nres &render_view <NEx=253,NEy=44> => view_in.render_view;

   DefaultVpsOutput vpsOutput <NEx=66,NEy=143,export_all=3> {
      // floatPrec <NEportLevels={0,2}>;
      // colorPrec <NEportLevels={0,2}>;
      // xformPrec => floatPrec;
      file        <NEportLevels={0,2}>;
      format      <NEportLevels={0,2}>;
      orientation <NEportLevels={0,2}>;
      backMode    <NEportLevels={0,2}>;
      size        <NEportLevels={0,2}>;
      widthMM     <NEportLevels={0,2}>;
      heightMM    <NEportLevels={0,2}>;
   };

   macro vpsUI <NEx=66,NEy=231> {

   UImod_panel vpsModPanel {
      parent <NEportLevels={3,0}>;
      title => name_of(<-.<-.<-);
      width  = 270;
      height = 1000;
   };

   VUI.VUIFileSelector vpsFile {
      title        =  "PS File";
      parent       => <-.vpsModPanel;
      x            =  4;
      y            =  4;
      width        => <-.vpsModPanel.width - 8;
      filetype     =  "ps";
      file <NEportLevels={3,0}> => <-.<-.vpsOutput.file;
      fileText.updateMode = 2;
   };

   VUI.VUIToggle vpsDynamic {
      label        =  "Dynamic";
      parent       => <-.vpsModPanel;
      x            => <-.vpsFile.x;
      y+nres       => <-.vpsFile.y + <-.vpsFile.height + 4;
      width        => <-.vpsFile.width;
      set <NEportLevels={3,0}> => <-.<-.vpsView.mode;
   };

   UIbutton vpsRefresh {
      label        =  "Write PostScript";
      parent       => <-.vpsModPanel;
      x            => <-.vpsDynamic.x;
      y+nres       => <-.vpsDynamic.y + <-.vpsDynamic.height + 4;
      width        => <-.vpsDynamic.width;
      visible      => 1 - <-.vpsDynamic.set;  // manual only
   };

   VUI.VUIOptionMenuLabel vpsColor {
      label        =  "Color Mode";
      parent       => <-.vpsModPanel;
      x            => <-.vpsRefresh.x;
      y+nres       => <-.vpsRefresh.y + <-.vpsRefresh.height + 8;
      width        => <-.vpsRefresh.width;
      options      => { "Color", "Greyscale" };
      selectedItem <NEportLevels={3,0}> => <-.<-.vpsOutput.format;
   };

   VUI.VUIOptionMenuLabel vpsBgmode {
      label        =  "Background Mode";
      parent       => <-.vpsModPanel;
      x            => <-.vpsColor.x;
      y+nres       => <-.vpsColor.y + <-.vpsColor.height;
      width        => <-.vpsColor.width;
      options      => { "White", "Black", "Keep" };
      selectedItem <NEportLevels={3,0}> => <-.<-.vpsOutput.backMode;
   };

   VUI.VUIOptionMenuLabel vpsOrient {
      label        =  "Orientation";
      parent       => <-.vpsModPanel;
      x            => <-.vpsBgmode.x;
      y+nres       => <-.vpsBgmode.y + <-.vpsBgmode.height;
      width        => <-.vpsBgmode.width;
      options      => { "Landscape", "Portrait" };
      selectedItem <NEportLevels={3,0}> => <-.<-.vpsOutput.orientation;
   };

   VUI.VUIOptionMenuLabel vpsSize {
      label        =  "Size";
      parent       => <-.vpsModPanel;
      x            => <-.vpsOrient.x;
      y+nres       => <-.vpsOrient.y + <-.vpsOrient.height;
      width        => <-.vpsOrient.width;
      options      => { "EPS (user)", "A (letter)", "B", "A4", "A3", "A0" };
      selectedItem <NEportLevels={3,0}> => <-.<-.vpsOutput.size;
   };

   boolean EPS[5] = { 1, 0, 0, 0, 0 };

   VUI.VUIField vpsWidthMM {
      label        =  "Width (mm)";
      parent       => <-.vpsModPanel;
      x            => <-.vpsSize.x;
      y+nres       => <-.vpsSize.y + <-.vpsSize.height + 2;
      width        => <-.vpsSize.width;
      min          =  1;
      mode         =  2;
      value <NEportLevels={3,0}> => <-.<-.vpsOutput.widthMM;
      visible      => <-.EPS[<-.vpsSize.selectedItem];
   };

   VUI.VUIField vpsHeightMM {
      label        =  "Height (mm)";
      parent       => <-.vpsModPanel;
      x            => <-.vpsWidthMM.x;
      y+nres       => <-.vpsWidthMM.y + <-.vpsWidthMM.height + 4;
      width        => <-.vpsWidthMM.width;
      min          =  1;
      mode         =  2;
      value <NEportLevels={3,0}> => <-.<-.vpsOutput.heightMM;
      visible      => <-.EPS[<-.vpsSize.selectedItem];
   };

   VUI.VUIField vpsMarginMM {
      label        =  "Margin (mm)";
      parent       => <-.vpsModPanel;
      x            => <-.vpsHeightMM.x;
      y+nres       => <-.vpsHeightMM.y + <-.vpsHeightMM.height + 4;
      width        => <-.vpsHeightMM.width;
      min          =  1.0;
      mode         =  2;
      value <NEportLevels={3,0}> => <-.<-.vpsOutput.marginMM;
   };

   VUI.VUIOptionMenuLabel vpsCSub {
      label        =  "Color Subdivision";
      parent       => <-.vpsModPanel;
      x            => <-.vpsMarginMM.x;
      y+nres       => <-.vpsMarginMM.y + <-.vpsMarginMM.height + 6;
      width        => <-.vpsMarginMM.width;
      options      => { "None (flat)", "Precompute ", "Postcompute" };
      selectedItem <NEportLevels={3,0}> => <-.<-.vpsOutput.colorSub;
   };

   boolean Sub[3] = { 0, 1, 1 };

   VUI.VUIField vpsCTol {
      label        =  "Color Tolerance";
      parent       => <-.vpsModPanel;
      x            => <-.vpsCSub.x;
      y+nres       => <-.vpsCSub.y + <-.vpsCSub.height;
      width        => <-.vpsCSub.width;
      min          =  0.0;
      mode         =  2;
      value <NEportLevels={3,0}> => <-.<-.vpsOutput.colorTol;
      visible      => <-.Sub[<-.vpsCSub.selectedItem];
   };

   VUI.VUIOptionMenuLabel vpsDepthSort {
      label        =  "Depth Sort Algorithm";
      parent       => <-.vpsModPanel;
      x            => <-.vpsCTol.x;
      y+nres       => <-.vpsCTol.y + <-.vpsCTol.height + 6;
      width        => <-.vpsCTol.width;
      options      => { "Default", "NNS" };
      selectedItem <NEportLevels={3,0}> => <-.<-.vpsOutput.depthSort;
   };

   VUI.VUIOptionMenuLabel vpsGMode {
      label        =  "Gamma Correction";
      parent       => <-.vpsModPanel;
      x            => <-.vpsDepthSort.x;
      y+nres       => <-.vpsDepthSort.y + <-.vpsDepthSort.height + 2;
      width        => <-.vpsDepthSort.width;
      options      => { "None", "Precompute ", "Postcompute" };
      selectedItem <NEportLevels={3,0}> => <-.<-.vpsOutput.gammaMode;
   };

   boolean Gam[3] = { 0, 1, 1 };

   VUI.VUIField vpsGamma {
      label        =  "Gamma Exponent";
      parent       => <-.vpsModPanel;
      x            => <-.vpsGMode.x;
      y+nres       => <-.vpsGMode.y + <-.vpsGMode.height + 2;
      width        => <-.vpsGMode.width;
      min          =  0.0;
      mode         =  2;
      value <NEportLevels={3,0}> => <-.<-.vpsOutput.gamma;
      visible      => <-.Gam[<-.vpsGMode.selectedItem];
   };

   VUI.VUILabel vpsPrec {
      label        =  "Numerical Precision";
      parent       => <-.vpsModPanel;
      x            => <-.vpsGamma.x;
      y+nres       => <-.vpsGamma.y + <-.vpsGamma.height + 12;
      width        => <-.vpsGamma.width;
   };

   VUI.VUIField vpsFloatP {
      label        =  "Float Precision";
      parent       => <-.vpsModPanel;
      x            => <-.vpsPrec.x;
      y+nres       => <-.vpsPrec.y + <-.vpsPrec.height + 4;
      width        => <-.vpsPrec.width;
      min          = 1;
      max          = 8;
      mode         = 1;
      value <NEportLevels={3,0}> => <-.<-.vpsOutput.floatPrec;
   };

   VUI.VUIField vpsColorP {
      label        =  "Color Precision";
      parent       => <-.vpsModPanel;
      x            => <-.vpsFloatP.x;
      y+nres       => <-.vpsFloatP.y + <-.vpsFloatP.height + 4;
      width        => <-.vpsFloatP.width;
      min          = 1;
      max          = 8;
      mode         = 1;
      value <NEportLevels={3,0}> => <-.<-.vpsOutput.colorPrec;
   };

   VUISlider vpsAlphaThreshold {
      parent       => <-.vpsModPanel;
      title        =  "Alpha Threshold";
      x            => <-.vpsColorP.x;
      y+nres       => <-.vpsColorP.y + <-.vpsColorP.height + 4;
      width        => <-.vpsColorP.width;
      min          =  0.0;
      max          =  1.0;
      mode         =  2;
      value <NEportLevels={3,0}>=> <-.<-.vpsOutput.alphaThreshold;
   };


   // this needs to force the view to VPS
   // since the GD sometimes defaults to SW !

   // Cannot use #defines in parse v in a runtime
   int vps_renderer_number = GD_VPS_RENDERER;

   GMOD.parse_v doVPS {
      v_commands =
         "$push
            vpsView.renderer = vpsUI.vps_renderer_number;
          $pop
          vpsView.refresh = 1;";
      on_inst  = 0;
      trigger  => <-.vpsRefresh.do;
      relative => <-.<-;
   };

   }; // vpsUI

   UIrenderView vpsRV <NEx=330,NEy=99>{
      parent  => <-.render_view.parent;
      x       =  0;
      y       =  0;
      width   => <-.render_view.width;
      height  => <-.render_view.height;
      visible =  0;
   };

   BestVirtPal vpsPal <NEx=451,NEy=143> {
      vclass    => view_in.virtpal.vclass;
      vid       => view_in.virtpal.vid;
      share     = 0;
      cube_size => view_in.virtpal.cube_size;
      gamma     = 1.0;
   };

   DefaultView vpsView <NEx=264,NEy=264> {
      mode           =  0;
      renderer       =  GD_VPS_RENDERER;
      handle         => <-.vpsRV.handle;
      virtpal        => <-.vpsPal;
      back_col       => <-.view_in.back_col;
      light_info     => <-.view_in.light_info;
      cameras        => <-.view_in.cameras;
      aspect         => <-.view_in.aspect;
      output         => <-.vpsOutput;
      output_enabled = 0;
      mode <NEportLevels={0,2}>;
   };
};
#endif

 module DisplayImage {
   Display_Image dpy_img;

   macro UI {
      ilink iscale => dpy_img.image_scale;
      ilink iwidth => dpy_img.max_width;
      ilink iheight => dpy_img.max_height;

   UImod_panel panel {
      parent<NEportLevels={4,0}>;
      title => name_of(<-.<-.<-);
         message = "Select DisplayImage control panel.";
      };
      VUISlider Scale {
         parent => panel;
         title = "Image Scale";
         min = 1;
         max = 16;
         value => iscale;
         mode = 1;
         y = 0;
         width => <-.panel.width;
      };
      VUISlider MaxWidth {
         parent => panel;
         title = "Maximum Width";
         min = 32;
         max = 4096;
         value => iwidth;
         mode = 1;
         y => Scale.y + Scale.height + 6;
         width => <-.panel.width;
      };
      VUISlider MaxHeight {
         parent => panel;
         title = "Maximum Height";
         min = 32;
         max = 4096;
         value => iheight;
         mode = 1;
         y => MaxWidth.y + MaxWidth.height + 6;
         width => <-.panel.width;
      };
   };

   UIshell shell {
#ifdef MSDOS
      width => dpy_img.shell_width <+> 10;
      height => dpy_img.shell_height <+> 28;
#else
      width => dpy_img.shell_width;
      height => dpy_img.shell_height;
#endif
      title => name_of(<-.<-);
      showStatusBar = 0;
   };

   UIscrolledWindow window {
      parent => shell;
#ifdef MSDOS
      width => parent.clientWidth;
      height => parent.clientHeight;
	  virtualWidth =>dpy_img.view_width;
	  virtualHeight => dpy_img.view_height;
#else
	  width => parent.width;
      height => parent.height;
#endif
   };
   UIrenderView renderView {
      parent => window;
      width => dpy_img.view_width;
      height => dpy_img.view_height;
   };

   DataObject dataObject {
      in => dpy_img.in;
      Obj;
   };
   DefaultCamera2D camera {
      objects => {dataObject.obj};
      auto_norm = "Data and Object";
      norm_scale => dpy_img.image_scale;
   };
   BestVirtPal virtpal;
   DefaultView view {
      cameras => {camera};
      handle => renderView.handle;
      virtpal => <-.virtpal;
      aspect = "Biggest";
      trigger = 1;
   };
};

};

/***********************************************************************/
/* Compatibility Viewers				               */
/***********************************************************************/
#define FullView3D Viewer3D
#define FullView2D Viewer2D
#define FullView Viewer
#define BasicView3D SimpleViewer3D
#define BasicView2D SimpleViewer2D
#define BasicView SimpleViewer

#define BasicCmdList SimpleCmdList
#define BasicEditors SimpleEditors

/***********************************************************************/
/* External Viewers                                                    */
/***********************************************************************/

#ifdef INVENTOR

group Inventor<NEsmallPixmapName="viewer.bmx"> {
    /* array of objects to render */
    int &nobjs => array_size(objects);
    GDobject_templ+IPort2 &objects[];

    ptr+nonotify+nosave local_ptr;

    method+notify_inst create = "InventorCreate";
    method+notify_val update = "InventorUpdate";
    method+notify_del delete = "InventorDelete";

#ifdef INVENTOR_OUT
    olink view<NEy=308,NEx=363> => View.view;
    olink picked_camera => View.picked_camera;
    olink picked_obj<NEy=341,NEx=407> => View.picked_obj;
    olink cur_obj<NEy=374,NEx=451> => ViewEditors.cur_obj;
#endif
};

#endif

/* 
 * If we leave these around, we run the risk of screwing up users since
 * these definitions are global...
 */
#undef X1
#undef X2
#undef X3
#undef X4
#undef X5
#undef X6
#undef Y1
#undef Y2
#undef Y3
#undef Y4
#undef Y5
#undef Y6
#undef Y7

#undef YI
#undef YO

};
