/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/w3c.v#1 $
*/

#ifdef READ_URL

// Now totally misnamed because we've switched to the cURL library

flibrary+sort W3C <
#ifdef NO_DL_LOAD
   link_files="-lxpw3c",
#else
   dyn_libs="libxpw3c",
#endif
   build_cmd="$(MAKE)",
   disabled => Templates.CONFIG.w3c_disabled,
   build_dir="webclnt"
>
{
$include ../include/$MACHINE/config.h

module W3Cget_URL <
// include in xpw3c lib now for ease of dynamic loading
//      src_file="geturl.c",
//      c_src_files="geturl.c"
      build_dir="url"
   >
   {
      omethod+notify_inst+req getContents(URL+read+notify+req,LocalFile+read+notify,OutputFile+write,status+write) = "geturl";
      string+Iparam URL<NEportLevels={2,0}>;
      string+Oparam LocalFile<NEportLevels={2,0}> = "/tmp/xp_url.out";
      string+Oparam OutputFile<NEportLevels={0,2}>;
      string+Oparam status<NEportLevels={0,2}>;
      int+Oparam    captured = 0;
   };


macro Read_URL<NEx=407.,NEy=33.> {
   W3C.W3Cget_URL W3Cget_URL{
      URL => <-.URL.text;
      LocalFile => <-.OutFile.text;
      OutputFile<NEportLevels={0,3}>;
      status = "No Status";
   };
   UI.UImod_panel panel<NEx=346.,NEy=23.> {
      width = 300;
      title => name_of(<-.<-);
   };
   UI.UIpanel UIpanel<NEx=346.,NEy=98.> {
      parent => <-.panel;
      y = 0;
      width = 270;
      height = 410;
   };
   UI.UItext URL<NEx=13.,NEy=173.> {
      parent => <-.UIpanel;
      y = 40;
      width = 270;
   };
   UI.UIlabel UIlabel<NEx=179.,NEy=173.> {
      parent => <-.UIpanel;
      height => 16;
      label => "Enter Uniform Resource Locator (URL):";
      y = 10;
      width=> parent.width;
      alignment = "left";
   };
   UI.UItext OutFile<NEx=346.,NEy=323.> {
      parent => <-.UIpanel;
      text<NEportLevels={2,2}> => <-.UIfileDialog.filename;
      y = 140;
      width => (parent.width * 0.6);
   };
   UI.UIbutton Browse<NEx=345.,NEy=173.> {
      parent => <-.UIpanel;
      label => "Browse...";
      y = 143;
      x => <-.OutFile.width + 20;
      width = 70;
   };
   UI.UIlabel UIlabel#1<NEx=511.,NEy=173.> {
      parent => <-.UIpanel;
      height => 16;
      label => "Enter cache file name (optional):";
      y = 110;
      width=> parent.width;
      alignment = "left";
   };
   UI.UIfileDialog UIfileDialog<NEx=346.,NEy=248.> {
      visible => <-.Browse.do;
      filename = "/tmp/xp_out.dat";
      ok = 1;
   };
   UI.UItext Status {
      parent => <-.UIpanel;
      text<NEportLevels={2,2},NEdisplayMode="open"> => <-.W3Cget_URL.status;
      y = 240;
      width => parent.width;
      outputOnly = 1;
   };
   UI.UIlabel UIlabel#2<NEx=677.,NEy=173.> {
      parent => <-.UIpanel;
      label => "Status From URL Reader:";
      y<NEdisplayMode="open"> = 210;
      width=> parent.width;
      alignment = "left";
   };
  };

macro ReadWebField<NEx=451.,NEy=22.> {
   macro read_field_ui {
      UI.UImod_panel panel {
         parent<NEportLevels={3,0}>;
         message = "Select read field control panel.";
         width = 275;
         title => name_of(<-.<-.<-);
      };
      UI.UItoggle portable_toggle {
         y = 300;
         width => <-.panel.width;
         parent => <-.panel;
         label => "Portable (XDR)";
         set => <-.portable;
      };
      UI.UItoggle swap_toggle {
         y => ((<-.portable_toggle.height + <-.portable_toggle.y) + 4);
         width => <-.panel.width;
         visible => min_array(.vis_arr);
         parent => <-.panel;
         label => "Swap Bytes";
         set => <-.swap;
         int vis_arr[2] => {
            (<-.portable_toggle.set ^ 1),1};
      };
      UI.UItoggle flip_toggle {
         y => ((<-.swap_toggle.height + <-.swap_toggle.y) + 4);
         width => <-.panel.width;
         parent => <-.panel;
         label => "Flip Image";
         set => <-.flip;
      };
      int portable<export=3> = 1;
      int swap<export=3> = 0;
      int flip<export=3> = 0;
      W3C.W3Cget_URL W3Cget_URL { // This should not be buried inside the UI.
         URL => <-.URL.text;
         LocalFile => <-.OutFile.text;
         OutputFile<NEportLevels={0,3}>;
         status = "No Status";
      };
      UI.UItext URL {
         parent => <-.panel;
         y = 40;
         width = 270;
         text = "";
      };
      UI.UIlabel UIlabel {
         parent => <-.panel;
         height => 16;
         label => "Enter Uniform Resource Locator (URL):";
         y = 10;
         width => parent.width;
         alignment = "left";
      };
      UI.UItext OutFile {
         parent => <-.panel;
         text<NEportLevels={2,2}> => <-.UIfileDialog.filename;
         y = 140;
         width => parent.width * 0.6;
      };
      UI.UIbutton Browse {
         parent => <-.panel;
         label => "Browse...";
         y = 143;
         x => <-.OutFile.width + 20;
         width = 70;
      };
      UI.UIlabel UIlabel#1 {
         parent => <-.panel;
         height => 16;
         label => "Enter cache file name (optional):";
         y = 110;
         width => parent.width;
         alignment = "left";
      };
      UI.UIfileDialog UIfileDialog {
         visible => <-.Browse.do;
         filename = "/tmp/xp_out.dat";
         ok = 1;
         parent => <-.panel;
      };
      UI.UItext Status {
         parent => <-.panel;
         text<NEportLevels={2,2},NEdisplayMode="open"> => <-.W3Cget_URL.status;
         y = 240;
         width = 270;
         outputOnly = 1;
      };
      UI.UIlabel UIlabel#2 {
         parent => <-.panel;
         label => "Status From URL Reader:";
         y = 210;
         width => parent.width;
         alignment = "left";
      };
   };
   DV.DVread_field DVread_field {
      filename => <-.read_field_ui.W3Cget_URL.OutputFile;
      portable => <-.read_field_ui.portable;
      swap => <-.read_field_ui.swap;
      flip => <-.read_field_ui.flip;
      Mesh_Unif+Node_Data Output_Field;
   };

   olink field<export_all=2> => DVread_field.out;

   GD.DataObject DataObject {
      in => <-.DVread_field.out;
      obj<NEportLevels={1,3}>;
   };

   //olink out_obj => DataObject.obj;
};

#ifdef ACKIT
#define INCLUDE_READ_GEOM	1
#endif
#ifdef AC_KIT_V1
#define INCLUDE_READ_GEOM	1
#endif

#ifdef INCLUDE_READ_GEOM
macro ReadWebGeom<NEx=198.,NEy=22.> {
   W3C.Read_URL Read_URL<NEx=110.> {
      panel.title => name_of(<-.<-.<-);
      URL {
         text = "";
      };
   };
   ACVT.ACread_geom ACread_geom<NEx=440.,NEy=77.> {
      array_flag = 0;
      filename => <-.Read_URL.W3Cget_URL.OutputFile;
   };

   olink field<export_all=2> => ACread_geom.out_field;

   GD.DataObject DataObject {
      in => <-.ACread_geom.out_field;
      Obj {
         name<NEportLevels={3,0}> => <-.<-.ACread_geom.name;
      };
      obj<NEportLevels={1,3}>;
   };

   //olink geom =>  DataObject.obj;
};
#endif

};

#endif

