flibrary MPUEventAPIMacs <cxx_name=""> {

  // module library link
  // NElink _mods = LIBMPU.WANDLIB.MPUEventAPIMods;

  // (1) Button Matrix Management
  
  macro button_matrix {

    link parent<NEportLevels={2,1}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom &geom<NEportLevels={2,1}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_wh &size<NEportLevels={2,1}>;

    LIBMPU.WANDLIB.MPUEventAPIMods.ui_scheme &scheme<NEportLevels={2,1}>;
    
    int nbuttons<NEportLevels={2,1}>;
    int set_state<NEportLevels={2,1}>;
    int mode<NEportLevels={2,1}>;
    int out_state<NEportLevels={2,1}>;
    
    // ui and module
    
    LIBMPU.WANDLIB.MPUEventAPIMods.bm_manager manager {
      nbuttons => <-.nbuttons;
      set_to_state => <-.set_state;
      mode => <-.mode;
      state_value => <-.out_state;
    };

    LIBMPU.WANDLIB.MPUEventAPIMods.ButtonMatrixPanel matrix_ui {
      parent => <-.parent;
      geom => <-.geom;
      size => <-.size;
      scheme => <-.scheme;
      nbuttons => <-.nbuttons;
      do_arr => <-.manager.do_array;
      state_arr => <-.manager.state_array;
    };
  };

  // (2) Mapping Shell Management

  macro frame_unit {
    link parent<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom &panel_geom<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_scheme &scheme<NEportLevels={2,0}>;

    UIframe frame<NEportLevels={0,2}> {
      parent => <-.parent;
      x => <-.panel_geom.x;
      y => <-.panel_geom.y;
      width => <-.panel_geom.w;
      height => <-.panel_geom.h;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };
  };

  macro text_unit {
    string &text_entry<NEportLevels={2,1}>;

    link parent<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom &panel_geom<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_scheme &scheme<NEportLevels={2,0}>;

    UIpanel panel {
      parent => <-.parent;
      x => <-.panel_geom.x;
      y => <-.panel_geom.y;
      width => <-.panel_geom.w;
      height => <-.panel_geom.h;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    UIlabel label {
      parent => <-.panel;
      x = 2;
      y = 0;
      width => (parent.width - 4);
      label => name_of(<-.<-);
      color {
	foregroundColor => <-.<-.scheme.label_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.label_scheme.backgroundColor;
      };
    };
      
    UItext text {
      parent => <-.panel;
      x = 2;
      y => <-.label.height;
      width => (parent.width - 4);
      height = 35;
      text => <-.text_entry;
      color {
	foregroundColor => <-.<-.scheme.entry_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.entry_scheme.backgroundColor;
      };
      updateMode = 1 | 4; // on enter and mouse exit
    };
  };
  
  macro field_unit {
    prim &field_entry<NEportLevels={2,1}>;

    link parent<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom &panel_geom<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_scheme &scheme<NEportLevels={2,0}>;

    UIpanel panel {
      parent => <-.parent;
      x => <-.panel_geom.x;
      y => <-.panel_geom.y;
      width => <-.panel_geom.w;
      height => <-.panel_geom.h;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    UIlabel label {
      parent => <-.panel;
      x = 2;
      y = 0;
      width => (parent.width - 4);
      label => name_of(<-.<-);
      color {
	foregroundColor => <-.<-.scheme.label_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.label_scheme.backgroundColor;
      };
    };
      
    UIfield field {
      parent => <-.panel;
      x = 2;
      y => <-.label.height;
      width => (parent.width - 4);
      height = 35;
      value => <-.field_entry;
      color {
	foregroundColor => <-.<-.scheme.entry_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.entry_scheme.backgroundColor;
      };
      updateMode = 1 | 4; // on enter and mouse exit
    };
  };
  
  macro menu_unit {
    int num_entries<NEportLevels={2,1}>;
    string &menu_entries<NEportLevels={2,1}>[num_entries];
    int selected_entry<NEportLevels={2,1}>;
    
    link parent<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom &panel_geom<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_scheme &scheme<NEportLevels={2,0}>;

    UIpanel panel {
      parent => <-.parent;
      x => <-.panel_geom.x;
      y => <-.panel_geom.y;
      width => <-.panel_geom.w;
      height => <-.panel_geom.h;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    UIlabel label {
      parent => <-.panel;
      x = 2;
      y = 0;
      width => (parent.width - 4);
      label => name_of(<-.<-);
      color {
	foregroundColor => <-.<-.scheme.label_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.label_scheme.backgroundColor;
      };
    };

    UIoption options[num_entries] {
      label => menu_entries[index_of(<-.options)];
    };
      
    UIoptionMenu menu {
      parent => <-.panel;
      x = 2;
      y => <-.label.height;
      width => (parent.width - 4);
      cmdList => <-.options;
      selectedItem => <-.selected_entry;
      label = "";		// Must be empty
      color {
	foregroundColor => <-.<-.scheme.pulldown_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.pulldown_scheme.backgroundColor;
      };
    };
  };
  
  macro matrix_unit {
    int nbuttons<NEportLevels={2,0}>;
    int set_state<NEportLevels={2,0}>;
    int mode<NEportLevels={2,0}>;
    int out_state<NEportLevels={2,0}>;
    
    link parent<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom &panel_geom<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_wh &button_wh<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_scheme &scheme<NEportLevels={2,0}>;

    UIpanel panel {
      parent => <-.parent;
      x => <-.panel_geom.x;
      y => <-.panel_geom.y;
      width => <-.panel_geom.w;
      height => <-.panel_geom.h;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    UIlabel label {
      parent => <-.panel;
      x = 2;
      y = 0;
      width => (parent.width - 4);
      label => name_of(<-.<-);
      color {
	foregroundColor => <-.<-.scheme.label_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.label_scheme.backgroundColor;
      };
    };
      
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom matrix_geom {
      x = 0;
      y => <-.label.height;
      w => <-.panel_geom.w;
      h => (<-.panel_geom.h - <-.label.height);
    };

    button_matrix matrix {
      parent => <-.panel;
      geom => <-.matrix_geom;
      size => <-.button_wh;
      scheme => <-.scheme;
      nbuttons => <-.nbuttons;
      set_state => <-.set_state;
      mode => <-.mode;
      out_state => <-.out_state;
    };
  };

  macro param_unit {
    int num_params<NEportLevels={2,1}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.MPUev_handler_param params<NEportLevels={2,1}>[num_params];
    int num_cols<NEportLevels={2,1}>;
    int frame_height<NEportLevels={2,1}>;

    link parent<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom &panel_geom<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.ui_scheme &scheme<NEportLevels={2,0}>;

    UIpanel panel {
      parent => <-.parent;
      x => <-.panel_geom.x;
      y => <-.panel_geom.y;
      width => <-.panel_geom.w;
      height => <-.panel_geom.h;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    UIscrolledWindow scroll_win {
      parent => <-.panel;
      x = 0;
      y = 0;
      width => parent.clientWidth;
      height => parent.clientHeight;
	  virtualWidth=>clientWidth;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    int num_rows => (num_params / num_cols) + 1;
    int win_scrollbar_width = 31;
      
    UIpanel win_panel {
      parent => <-.scroll_win;
      x = 0;
      y = 0;
      width => (parent.width - win_scrollbar_width);
      int h => (<-.num_rows * (<-.frame_height+<-.yord_offset));
      height => switch( is_valid(.h)+1, <-.frame_height, .h );
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    int yord_offset = 2;
    int col_width => (win_panel.clientWidth / num_cols);

    int xord[num_cols] => init_array( num_cols,0,((num_cols-1)*col_width) );
    int yord[num_rows] => init_array( num_rows,0,((num_rows-1)*(frame_height+yord_offset)) );

    UIframe frames[.num_params] {
      parent => <-.win_panel;
      x => <-.xord[ index_of(frames) % <-.num_cols ];
      y => <-.yord[ index_of(frames) / <-.num_cols ];
      width => <-.col_width;
      height => <-.frame_height;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    UIlabel labels[.num_params] {
      parent => <-.frames[index_of(labels)];
      x = 2;
      y = 2;
      width => (parent.width - 4);
      color {
	foregroundColor => <-.<-.scheme.label_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.label_scheme.backgroundColor;
      };
      label => <-.params[index_of(labels)].name;
    };

    UIfield fields[.num_params] {
      parent => <-.frames[index_of(fields)];
      x = 2;
      y => (<-.labels[index_of(fields)].height + <-.labels[index_of(fields)].y);
      width => (parent.width - 8);
      height = 35;
      color {
	foregroundColor => <-.<-.scheme.entry_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.entry_scheme.backgroundColor;
      };
      decimalPoints = 6;
      mode => <-.params[index_of(fields)].type;
      value => <-.params[index_of(fields)].value;
      updateMode = 1 | 4; // on enter and mouse exit
    };
  };
  
  macro manage_mapping_shell_ui {
    LIBMPU.WANDLIB.MPUEventAPIMods.MPUev_manager &ev_manager<NEportLevels={2,0}>;
    LIBMPU.WANDLIB.MPUEventAPIMods.mms_params &mmsp<NEportLevels={2,0}>;

    LIBMPU.WANDLIB.MPUEventAPIMods.ui_wh button_wh {
      w = 25;
      h = 25;
    };

    LIBMPU.WANDLIB.MPUEventAPIMods.ui_scheme scheme {
      panel_scheme {
	foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	 backgroundColor = "gray";
#endif
      };

      heading_scheme {
#ifdef MSDOS
	foregroundColor = "white";
	 backgroundColor = "gray";
#else
	 foregroundColor = "blue";
	 backgroundColor = "gray";
#endif
      };

      label_scheme {
	foregroundColor = "blue";
	backgroundColor = "white";
      };

      matrix_scheme[2] = {
	 {
#ifdef MSDOS
	 backgroundColor = "light gray",
#else
	 backgroundColor = "gray",
#endif 
	 foregroundColor = "black"
	 },
	{backgroundColor = "blue",foregroundColor = "white"}
      };

      entry_scheme {
	 foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "white";
#else
	 backgroundColor = "gray";
#endif
      };

      pulldown_scheme {
#ifdef MSDOS
	 foregroundColor = "black";
	 backgroundColor = "light grey";
#else
	 foregroundColor = "black";
	 backgroundColor = "gray";
#endif
      };

      button_scheme {
	foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	 backgroundColor = "gray";
#endif
      };
    };
    
    UIshell shell;

    LIBMPU.WANDLIB.MPUEventAPIMods.ui_wh column_wh {
      w => <-.shell.clientWidth / 4;
      h = 100;
    };

    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom row0_column[4] {
      x => <-.column_wh.w * index_of(row0_column);
      y = 30;
      w => <-.column_wh.w;
      h = 80;
    };

    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom row1_column[4] {
      x => <-.column_wh.w * index_of(row1_column);
      y = 30;
      w => <-.column_wh.w;
      h = 120;
    };

    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom row2 {
      x = 0;
      y = 30;
      w => <-.shell.clientWidth;
      h = 160;			// Increased from 80
    };

    LIBMPU.WANDLIB.MPUEventAPIMods.ui_geom row3 {
      x = 0;
      y = 30;
      w => <-.shell.clientWidth;
      h = 80;
    };

    // row0

    UIframe row0_frame {
      parent => <-.shell;
      x = 0;
      y = 0;
      width => .parent.clientWidth;
      height = 110;
    };

    UIlabel row0_title {
      parent => <-.row0_frame;
      x = 2;
      y = 0;
      width => parent.clientWidth;
      height = 30;
      color {
	foregroundColor => <-.<-.scheme.heading_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.heading_scheme.backgroundColor;
      };
      alignment = "left";
      label = "Mapping Parameters:";
    };

    text_unit Name {
      text_entry => <-.mmsp.map_name;
      parent => <-.row0_frame;
      panel_geom => <-.row0_column[0];
      scheme => <-.scheme;
    };

    menu_unit Handler {
      num_entries => <-.mmsp.map_num_handlers;
      menu_entries => <-.mmsp.map_handler_options;
      selected_entry => <-.mmsp.map_handler;
      parent => <-.row0_frame;
      panel_geom => <-.row0_column[1];
      scheme => <-.scheme;
    };
    
    menu_unit Handler_Mode {
      num_entries => <-.mmsp.map_num_modes;
      menu_entries => <-.mmsp.map_mode_options;
      selected_entry => <-.mmsp.map_handler_mode;
      parent => <-.row0_frame;
      panel_geom => <-.row0_column[2];
      scheme => <-.scheme;
    };
    
    field_unit Valuator_Scale {
      field_entry => <-.mmsp.map_val_scale;
      parent => <-.row0_frame;
      panel_geom => <-.row0_column[3];
      scheme => <-.scheme;
    };
      
    // row1
    
    UIframe row1_frame {
      parent => <-.shell;
      x = 0;
      y = 110;
      width => .parent.clientWidth;
      height = 120;
    };

    UIlabel row1_title {
      parent => <-.row1_frame;
      x = 2;
      y = 0;
      width => parent.clientWidth;
      height = 30;
      color {
	foregroundColor => <-.<-.scheme.heading_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.heading_scheme.backgroundColor;
      };
      alignment = "left";
      label = "Physical Device Mappings:";
    };
      
    matrix_unit Down {
      nbuttons => <-.mmsp.nbuttons;
      set_state => <-.mmsp.map_set_down_state;
      mode = 2;
      out_state => <-.mmsp.map_down_state;
      parent => <-.row1_frame;
      panel_geom => <-.row1_column[0];
      button_wh => <-.button_wh;
      scheme => <-.scheme;
    };

    matrix_unit Motion {
      nbuttons => <-.mmsp.nbuttons;
      set_state => <-.mmsp.map_set_motion_state;
      mode = 2;
      out_state => <-.mmsp.map_motion_state;
      parent => <-.row1_frame;
      panel_geom => <-.row1_column[1];
      button_wh => <-.button_wh;
      scheme => <-.scheme;
    };

    matrix_unit Up {
      nbuttons => <-.mmsp.nbuttons;
      set_state => <-.mmsp.map_set_up_state;
      mode = 2;
      out_state => <-.mmsp.map_up_state;
      parent => <-.row1_frame;
      panel_geom => <-.row1_column[2];
      button_wh => <-.button_wh;
      scheme => <-.scheme;
    };

    matrix_unit Valuator {
      nbuttons => <-.mmsp.map_val_nbuttons;
      set_state => <-.mmsp.map_set_val_state;
      mode => <-.mmsp.map_val_mode;
      out_state => <-.mmsp.map_val_state;
      parent => <-.row1_frame;
      panel_geom => <-.row1_column[3];
      button_wh => <-.button_wh;
      scheme => <-.scheme;
      label {
	x = 26;
	width => (parent.width - 28);
	label => switch( mode+1, "Valuator", "_", "Simulated Valuator" );
      };
      UIbutton toggle {
	parent => <-.panel;
	x = 2;
	y = 0;
	width = 24;
	height = 24;
	label = "S";
	 message = "Toggle between valuators and simulated valuators (buttons)";
	color {
	  foregroundColor => <-.<-.label.color.foregroundColor;
	  backgroundColor => <-.<-.label.color.backgroundColor;
	};
      };
      int val_mode_toggle => toggle.do;
      int val_mode => <-.mmsp.map_val_mode;
      GMOD.parse_v set_val_mode {
	relative => <-;
	trigger => <-.val_mode_toggle;
	v_commands = "val_mode = (2 - val_mode);";
      };
    };

    // row2

    UIframe row2_frame {
      parent => <-.shell;
      x = 0;
      y = 230;
      width => .parent.clientWidth;
      height = 200;		// Increaed from 115
    };

    UIlabel row2_title {
      parent => <-.row2_frame;
      x = 2;
      y = 0;
      width => parent.clientWidth;
      height = 30;
      color {
	foregroundColor => <-.<-.scheme.heading_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.heading_scheme.backgroundColor;
      };
      alignment = "left";
      label = "Selected Handler Parameters:";
    };

    param_unit Params {
      num_params => <-.mmsp.map_num_params;
      params => <-.mmsp.map_params;
      num_cols = 4;
      frame_height = 80;
      parent => <-.row2_frame;
      panel_geom => <-.row2;
      scheme => <-.scheme;
    };

    // row3

    UIframe row3_frame {
      parent => <-.shell;
      x = 0;
      y = 430;			// Increased from 345
      width => .parent.clientWidth;
      height = 90;		// Increased from 80
    };

    UIlabel row3_title {
      parent => <-.row3_frame;
      x = 2;
      y = 0;
      width => parent.clientWidth;
      height = 30;
      color {
	foregroundColor => <-.<-.scheme.heading_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.heading_scheme.backgroundColor;
      };
      alignment = "left";
      label = "Actions:";
    };

    UIbutton action_submit {
      parent => <-.row3_frame;
      x = 15;
      y = 30;
      width = 120;
      height = 30;
      label = "Submit";
       message = "Apply new settings";
       color {
	foregroundColor => <-.<-.scheme.button_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.button_scheme.backgroundColor;
      };
      do => <-.mmsp.action_submit;
      active => strlen( <-.mmsp.map_name );
    };

    UIbutton action_reset {
      parent => <-.row3_frame;
      x = 150;
      y = 30;
      width = 120;
      height = 30;
      label = "Reset";
       message = "Reset all items to initial values";
      color {
	foregroundColor => <-.<-.scheme.button_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.button_scheme.backgroundColor;
      };
      do => <-.mmsp.action_reset;
    };

    UIbutton action_recall {
      parent => <-.row3_frame;
      x = 285;
      y = 30;
      width = 120;
      height = 30;
      label = "Recall";
      visible = 0; // recall not available this release
      color {
	foregroundColor => <-.<-.scheme.button_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.button_scheme.backgroundColor;
      };
      do => <-.mmsp.action_recall;
    };

    UIbutton action_close {
      parent => <-.row3_frame;
      x = 285; //420 if recall present;
      y = 30;
      width = 120;
      height = 30;
      label = "Close Window";
      message = "Close window (changes since last Submit will be lost)";
      color {
	foregroundColor => <-.<-.scheme.button_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.button_scheme.backgroundColor;
      };
      do => !<-.shell.visible;
    };

  };
  
  macro manage_mapping_shell {

    int edit_mode<NEportLevels={2,1}>;
    int edit_mapping_index<NEportLevels={2,1}>;
    
    link ev_manager<NEportLevels={2,1}>;

    LIBMPU.WANDLIB.MPUEventAPIMods.mms_params &mmsp<NEportLevels={2,0}>;
    
    LIBMPU.WANDLIB.MPUEventAPIMods.mms_manager manager {
      edit_mode => <-.edit_mode;
      edit_mapping_index => <-.edit_mapping_index;

      ev_manager => <-.ev_manager;

      mmsp => <-.mmsp;
    };

    LIBMPU.WANDLIB.MPUEventAPIMods.MPUev_mapping &edit_mapping<NEportLevels={1,2}> => .manager.edit_mapping;
    int submit_mapping<NEportLevels={1,2}> => .manager.submit_mapping;

  };

  macro mapping_editor {

    link ev_manager<NEportLevels={2,1}>;
    int edit_mode<NEportLevels={2,1}> = 0;
    int edit_mapping_index<NEportLevels={2,1}> = 0;
    int allow_visibility<NEportLevels={2,1}> = 0;
    int show_editor<NEportLevels={2,1}> = 0;
    
    int visible => (.show_editor * .allow_visibility);
    int shell_visibility = 0;
    GMOD.parse_v set_visibility {
      relative => <-;
      trigger => <-.visible;
      no_errors = 1;
      v_commands = "shell_visibility = visible;";
    };
    
    LIBMPU.WANDLIB.MPUEventAPIMods.mms_params mmsp;
    
    manage_mapping_shell_ui ui {
      shell {
	width = 700;
	height = 540;		// Increased from 480
	visible => <-.<-.shell_visibility;
      };
      mmsp => <-.mmsp;
      ev_manager => <-.ev_manager;
    };

    manage_mapping_shell manager {
      ev_manager => <-.ev_manager;
      mmsp => <-.mmsp;
      edit_mode => <-.edit_mode;
      edit_mapping_index => <-.edit_mapping_index;
    };

    link out_mapping<NEportLevels={1,2}> => .manager.edit_mapping;
    link out_go_submit<NEportLevels={1,2}> => .manager.submit_mapping;
  };

  mapping_editor+nosave submit_editor {
    ev_manager <NEx=77.,NEy=341.>;
    edit_mode <NEx=110.,NEy=297.> = 0;
    edit_mapping_index <NEx=143.,NEy=253.>;
    show_editor <NEx=176.,NEy=110.>;
    GMOD.copy_on_change copy_on_change<NEx=308.,NEy=154.> {
      trigger => <-.shell_visibility;
      input => <-.show_editor;
    };
    int reset_on_show<NEportLevels={1,1},NEx=484.,NEy=11.>
        => .copy_on_change.output;
    mmsp<NEx=176.,NEy=66.> {
      action_reset => <-.reset_on_show;
    };
    ui <NEx=330.,NEy=385.> {
      shell {
	title = "Submit New Mapping";
      };
    };
    manager <NEx=506.,NEy=385.>;
  };
  
  mapping_editor+nosave edit_editor {
    ev_manager <NEx=77.,NEy=341.>;
    edit_mode <NEx=110.,NEy=297.> = 1;
    edit_mapping_index <NEx=143.,NEy=253.>;
    show_editor <NEx=176.,NEy=110.>;
    mmsp <NEx=176.,NEy=66.>;
    ui <NEx=330.,NEy=385.> {
      shell {
	title = "Edit Mapping";
      };
    };
    manager <NEx=506.,NEy=385.>;
  };

  // (3) Configuration Management

  // MPE Module Panel - basic controls + manager shell launcher

  macro ui_ev_modpanel {

    int allow_visibility<NEportLevels={2,1}>;
    
    UImod_panel ev_modpanel {
      title = "MPE Event Manager";
    };

    UItoggle show_manager_shell {
      width = 400;
      label = "Toggle Event Manager Window";
      parent => <-.ev_modpanel;
      active => <-.allow_visibility;
    };

    int visibility => (allow_visibility * show_manager_shell.set);
    int ui_ev_manager_shell_visible<NEportLevels={0,2}>;

    GMOD.parse_v set_visibility {
      relative => <-;
      no_errors = 1;
      trigger => <-.visibility;
      v_commands = "ui_ev_manager_shell_visible = visibility;";
    };
  };

  // MPE Event Manager

  macro ui_ev_manager {

    LIBMPU.WANDLIB.MPUEventAPIMods.MPUev_manager &ev_man<NEportLevels={2,0}>;

    LIBMPU.WANDLIB.MPUEventAPIMods.MPUev_config submit_config<NEportLevels={0,2}>;
    int go_submit_config<NEportLevels={0,2}>;

    int num_configs => ev_man.num_configs;
    LIBMPU.WANDLIB.MPUEventAPIMods.MPUev_config &active_config => ev_man.configs[ev_man.active_config_index];
//    int selected_config_id<NEportLevels={1,2}> => ev_man.configs[SelectConfig.menu_config.selectedItem].id;
    int selected_config_id<NEportLevels={1,2}> => ev_man.configs[SelectConfig.config_menu_params.out_selected_entry].id;
    // individual mapping ids for actions
    int action_id<NEportLevels={0,2}>[.active_config.num_mappings] => active_config.mapping_ids.id;

    // activation toggle outputs
    int activation_do<NEportLevels={0,2}>[.active_config.num_mappings];
    int activation_set<NEportLevels={0,2}>[.active_config.num_mappings] => ActiveConfig.Activation.mapping_toggle.set;

    // deletion toggle outputs
    int deletion_set<NEportLevels={0,2}>[.active_config.num_mappings] => ActiveConfig.Selection.mapping_toggle.set;
    
    int show_manager_shell<NEportLevels={2,1}> = 0;

    int show_submit_mapping_shell<NEportLevels={1,2}> =0;

    int show_edit_mapping_shell<NEportLevels={1,2}> = 0;
    int edit_which_mapping_id<NEportLevels={1,2}> => ActiveConfig.Parameters.which_mapping;
    
    int go_delete_mappings<NEportLevels={1,2}>;
    int go_delete_config<NEportLevels={1,2}>;
    int go_load_settings<NEportLevels={1,2}>;
    int go_save_settings<NEportLevels={1,2}>;
    string filename_load_settings<NEportLevels={1,2}>;
    string filename_save_settings<NEportLevels={1,2}>;
    
    UIshell manager_shell {
      width = 748;
      height = 540;
      title = "MPE Event Manager";
      visible => <-.show_manager_shell;
    };
        
    link parent<NEportLevels={1,0}> => manager_shell;

    group SelectConfig {
      link group_parent<NEportLevels={1,1}> => <-.parent;
      
      UIpanel panel_row0 {
	parent => <-.group_parent;
	x = 0;
	y = 0;
	width => .parent.clientWidth;
	height = 60;
      };
      
      UIframe frame_row0 {
	x = 0;
	y = 0;
	parent => <-.panel_row0;
	width => .parent.clientWidth;
	height => .parent.clientHeight;
      };

      link parent => .frame_row0;
    
      UIlabel row0_title {
	parent => <-.parent;
	x = 2;
	y = 0;
	width => parent.clientWidth;
	color {
#ifdef MSDOS
	   foregroundColor = "white";
	   backgroundColor = "gray";
#else
	   foregroundColor = "blue";
	   backgroundColor = "gray";
#endif
	};
	alignment = "left";
	label = "Available Configurations:";
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.menu_params config_menu_params {
	set_selected_entry => <-.<-.ev_man.active_config_index;
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.menu_manager config_menu_manager {
	ev_manager => <-.<-.ev_man;
	num_entries => <-.<-.num_configs;
	params => <-.config_menu_params;
      };
      
      UIoption option_config[.config_menu_params.num_entries] {
	label => <-.config_menu_params.entries[index_of(<-.option_config)];
      };

      UIlabel labelSelConfig {
	parent => <-.parent;
	x = 2;
	y => <-.row0_title.height;
	width = 170;
	color {
	  foregroundColor = "blue";
	  backgroundColor = "white";
	};
	int is_config => min_array( {1,config_menu_params.num_entries} );
	label => switch( is_config+1, "None", "Select Configuration" );
      };
    
      UIoptionMenu menu_config {
	x => (<-.labelSelConfig.x + <-.labelSelConfig.width);
	y => <-.row0_title.height;
	parent => <-.parent;
	cmdList => <-.option_config;
//	selectedItem => ev_man.active_config_index;
	selectedItem => <-.config_menu_params.menu_selected_entry;
	color {
	  foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	  backgroundColor = "gray";
#endif
	};
	label = "";
	active => <-.config_menu_params.num_entries;
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.nUIbutton delete_config {
	parent => <-.parent;
	x => (<-.menu_config.x + <-.menu_config.width);
	y => <-.row0_title.height;
	width = 140;
	height = 30;
	visible => num_configs;
	color {
	  foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	  backgroundColor = "gray";
#endif
	};
	label = "Delete Configuration";
	message = "Delete the Active Configuration";
	active => num_configs;
	do => <-.<-.go_delete_config;
      };
    };

    group SubmitConfig {

      link group_parent<NEportLevels={1,1}> => <-.parent;

      UIpanel panel_row1 {
	parent => <-.group_parent;
	x = 0;
	y = 60;
	width => .parent.clientWidth;
	height = 65;
      };
      
      UIframe frame_row1 {
	x = 0;
	y = 0;
	parent => <-.panel_row1;
	width => .parent.clientWidth;
	height => .parent.clientHeight;
      };

      link parent => .frame_row1;
    
      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel row1_title {
	parent => <-.parent;
	x = 2;
	y = 0;
	width => .parent.clientWidth;
	color {
#ifdef MSDOS
	   foregroundColor = "white";
	   backgroundColor = "gray";
#else
	   foregroundColor = "blue";
	   backgroundColor = "gray";
#endif
	};
	alignment = "left";
	label = "New Configuration:";
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel labelName {
	parent => <-.parent;
	x = 2;
#ifdef MSDOS
	 y => <-.row1_title.by;
#else
	 y => (<-.row1_title.by + 6);
#endif
	width = 170;
	alignment = "center";
	label => "Name";
	color {
	  foregroundColor = "blue";
	  backgroundColor = "white";
	};
      };

      UItext subcfg_name_text {
	parent => <-.parent;
	x = 172;
	y => <-.row1_title.by;
	width = 200;
	height = 35;
	text => <-.<-.submit_config.name;
	color {
#ifdef MSDOS
	 backgroundColor = "white";
#else
	  backgroundColor = "gray";
#endif
	  foregroundColor = "black";
	};
	updateMode = 1 | 4; // on enter and mouse exit
      };

      UIbutton action_submit {
	parent => <-.parent;
	x = 372;
	y => <-.row1_title.by;
	height = 30;
	active => switch( is_valid(<-.subcfg_name_text.text)+1, 0, strlen( <-.subcfg_name_text.text ) );
	color {
	  foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	  backgroundColor = "gray";
#endif
	};
	label = "Submit";
	do => <-.<-.go_submit_config;
      };
    };

    group ActiveConfig {
     link group_parent<NEportLevels={1,1}> => <-.parent;
      
      UIpanel panel_row2 {
	parent => <-.group_parent;
	x = 0;
	y = 125;
	width => .parent.clientWidth;
	height = 300;
	//active => num_configs;
	visible => num_configs;
      };
      
      UIframe frame_row2 {
	x = 0;
	y = 0;
	parent => <-.panel_row2;
	width => .parent.clientWidth;
	height => .parent.clientHeight;
      };

      link parent => .frame_row2;
    
      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel row2_title {
	parent => <-.parent;
	x = 2;
	y = 0;
	width => .parent.clientWidth;
	color {
#ifdef MSDOS
	   foregroundColor = "white";
	   backgroundColor = "gray";
#else
	   foregroundColor = "blue";
	   backgroundColor = "gray";
#endif
	};
	alignment = "left";
	string ac_name => <-.<-.active_config.name;
	int is_ac => min_array( {1,num_configs} );
	string display_name => switch( is_ac+1, "No Configurations", ac_name );
	label => str_format( "Active Configuration (%s) Mappings:", display_name );
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel labelSel {
	parent => <-.parent;
	x = 4;
	y => <-.row2_title.by;
	width = (22 - 4);
	alignment = "center";
	label => "X";
	color {
	  foregroundColor = "blue";
	  backgroundColor = "white";
	};
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel labelActive {
	parent => <-.parent;
	x => (<-.labelSel.rx + 4);
	y => <-.row2_title.by;
	width = (22 - 4);
	alignment = "center";
	label => "A";
	color {
	  foregroundColor = "blue";
	  backgroundColor = "white";
	};
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel labelName {
	parent => <-.parent;
	x => (<-.labelActive.rx + 4);
	y => <-.row2_title.by;
	width = (150 - 4);
	alignment = "center";
	label => "Name";
	color {
	  foregroundColor = "blue";
	  backgroundColor = "white";
	};
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel labelHandler {
	parent => <-.parent;
	x => (<-.labelName.rx + 4);
	y => <-.row2_title.by;
	width = (150 - 4);

	alignment = "center";
	label => "Handler";
	color {
	   foregroundColor = "blue";
	   backgroundColor = "white";
	};
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel labelMode {
	parent => <-.parent;
	x => (<-.labelHandler.rx + 4);
	y => <-.row2_title.by;
	width = (150 - 4);
	alignment = "center";
	label => "Mode";
	color {
	  foregroundColor = "blue";
	  backgroundColor = "white";
	};
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel labelParameters {
	parent => <-.parent;
	x => (<-.labelMode.rx + 4);
	y => <-.row2_title.by;
	width = (22 - 4);
	alignment = "center";
	label => "P";
	color {
	  foregroundColor = "blue";
	  backgroundColor = "white";
	};
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel labelDetails {
	parent => <-.parent;
	x => (<-.labelParameters.rx + 4);
	y => <-.row2_title.by;
	width = (200 - 4);
	alignment = "center";
	label => "Device Details";
	color {
	  foregroundColor = "blue";
	  backgroundColor = "white";
	};
      };
      
      int win_scrollbar_width = 31;
      
      UIscrolledWindow active_map_win {
	parent => <-.parent;
	x = 0;
	y => <-.labelSel.by;
	width => .parent.clientWidth;
	height => (.parent.clientHeight - <-.row2_title.height - <-.labelSel.height);
	virtualWidth=>parent.clientWidth;
	virtualHeight=><-.all_height;
	
      };

      int num_mappings => <-.active_config.num_mappings;
      int row_height = 28;
      int all_height => switch( is_valid(.num_mappings)+1, 100, .num_mappings * .row_height );

      LIBMPU.WANDLIB.MPUEventAPIMods.ui_info sel_col_placement {
	x = 0;
	y = 0;
	width = 22;
	height => <-.all_height;
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.ui_info active_col_placement {
	x = 22;
	y = 0;
	width = 22;
	height => <-.all_height;
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.ui_info name_col_placement {
	x = 44;
	y = 0;
	width = 150;
	height => <-.all_height;
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.ui_info handler_col_placement {
	x = 194;
	y = 0;
	width = 150;
	height => <-.all_height;
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.ui_info mode_col_placement {
	x = 344;
	y = 0;
	width = 150;
	height => <-.all_height;
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.ui_info parameters_col_placement {
	x = 494;
	y = 0;
	width = 22;
	height => <-.all_height;
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.ui_info details_col_placement {
#ifdef MSDOS
	 x = 514;
	 width = 200;
#else
	 x = 516;
	 width = 198;
#endif
	y = 0;
	height => <-.all_height;
      };
      
      UIpanel active_map_win_panel {
	parent => <-.active_map_win;
	x = 0;
	y = 0;
	width => (.parent.width - <-.win_scrollbar_width);
	height => switch( is_valid(<-.all_height)+1, 24, <-.all_height );
      };

      group Selection {

	link parent => <-.active_map_win_panel;

	LIBMPU.WANDLIB.MPUEventAPIMods.ui_info &placement => <-.sel_col_placement;
	int num_mappings<NEportLevels={2,0}> => <-.num_mappings;
	int row_height<NEportLevels={2,0}> => <-.row_height;
	
	UIpanel panelSel {
	  parent => <-.parent;
	  x => <-.placement.x;
	  y => <-.placement.y;
	  width => <-.placement.width;
	  height => <-.placement.height;
	  color {
	    foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	  };
	};

	int map_togsel[.num_mappings];

	GMOD.parse_v reset_map_togsel {
	  trigger => <-.<-.<-.ev_man.active_config_index;
	  relative => <-.<-;
	  v_commands = "map_togsel = init_array(num_mappings,0,0);";
	  no_errors = 1;
	};
	
	UItoggle mapping_toggle[.num_mappings] {
	  parent => <-.panelSel;
	  x = 0;
	  y => (<-.row_height * index_of(mapping_toggle));
	  width = 22;
	  label = "";
	  set => <-.map_togsel[index_of(mapping_toggle)];
	};

      };

      group Activation {

	link parent => <-.active_map_win_panel;

	LIBMPU.WANDLIB.MPUEventAPIMods.ui_info &placement => <-.active_col_placement;
	int num_mappings<NEportLevels={2,0}> => <-.num_mappings;
	int row_height<NEportLevels={2,0}> => <-.row_height;
	
	UIpanel panelActive {
	  parent => <-.parent;
	  x => <-.placement.x;
	  y => <-.placement.y;
	  width => <-.placement.width;
	  height => <-.placement.height;
	  color {
	    foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	  };
	};

	UItoggle mapping_toggle[.num_mappings] {
	  parent => <-.panelActive;
	  int ind => index_of(mapping_toggle);
	  x = 0;
	  y => (<-.row_height * ind);
	  width = 22;
	  label = "";
	  set => <-.<-.<-.ev_man.mappings[<-.<-.<-.active_config.mapping_ids[ind].index].active;
	  do => <-.<-.<-.activation_do[ind];
	};
      };

      group Name {

	link parent => <-.active_map_win_panel;

	LIBMPU.WANDLIB.MPUEventAPIMods.ui_info &placement => <-.name_col_placement;
	int num_mappings<NEportLevels={2,0}> => <-.num_mappings;
	int row_height<NEportLevels={2,0}> => <-.row_height;
	
	UIpanel panelName {
	  parent => <-.parent;
	  x => <-.placement.x;
	  y => <-.placement.y;
	  width => <-.placement.width;
	  height => <-.placement.height;
	  color {
	    foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	  };
	};

	UIlabel mapping_names[active_config.num_mappings] {
	  parent => <-.panelName;
	  x = 2;
	  y => (<-.row_height * index_of(<-.mapping_names));
	  width => (.parent.width - 4);
	  label => <-.<-.<-.ev_man.mappings[(<-.<-.<-.active_config.mapping_ids[index_of(<-.mapping_names)].index )].name;
	  color {
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	     foregroundColor = "black";
	  };
	};

      };
	
      group Handler {

	link parent => <-.active_map_win_panel;

	LIBMPU.WANDLIB.MPUEventAPIMods.ui_info &placement => <-.handler_col_placement;
	int num_mappings<NEportLevels={2,0}> => <-.num_mappings;
	int row_height<NEportLevels={2,0}> => <-.row_height;
	
	UIpanel panelHandler {
	  parent => <-.parent;
	  x => <-.placement.x;
	  y => <-.placement.y;
	  width => <-.placement.width;
	  height => <-.placement.height;
	   color {
	     foregroundColor = "black";
#ifdef MSDOS
	     backgroundColor = "light gray";
#else
	     backgroundColor = "gray";
#endif
	  };
	};

	UIlabel mapping_hdl_names[active_config.num_mappings] {
	  parent => <-.panelHandler;
	  x = 2;
	  y => (<-.row_height * index_of(<-.mapping_hdl_names));
	  width => (parent.width - 4);
	  label => <-.<-.<-.ev_man.handlers[(<-.<-.<-.ev_man.mappings[(<-.<-.<-.active_config.mapping_ids[index_of(<-.mapping_hdl_names)].index)].handler_index)].name;
	  color {
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	     foregroundColor = "black";
	  };
	};

      };
	
      group Mode {

	link parent => <-.active_map_win_panel;

	LIBMPU.WANDLIB.MPUEventAPIMods.ui_info &placement => <-.mode_col_placement;
	int num_mappings<NEportLevels={2,0}> => <-.num_mappings;
	int row_height<NEportLevels={2,0}> => <-.row_height;
	
	UIpanel panelMode {
	  parent => <-.parent;
	  x => <-.placement.x;
	  y => <-.placement.y;
	  width => <-.placement.width;
	  height => <-.placement.height;
	  color {
	    foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	  };
	};

	UIlabel mapping_hdl_modes[<-.<-.active_config.num_mappings] {
	  parent => <-.panelMode;
	  x = 2;
	  y => (<-.row_height * index_of(<-.mapping_hdl_modes));
	  width => (.parent.width - 4);
	  int hdl_index => (<-.<-.<-.ev_man.mappings[(<-.<-.<-.active_config.mapping_ids[index_of(<-.mapping_hdl_modes)].index)].handler_index);
	  int hdl_mode => <-.<-.<-.ev_man.mappings[(<-.<-.<-.active_config.mapping_ids[index_of(<-.mapping_hdl_modes)].index)].handler_mode;
	  
	  label => str_format( "%d: %s", <-.<-.<-.ev_man.handlers[hdl_index].modes[hdl_mode].id, <-.<-.<-.ev_man.handlers[hdl_index].modes[hdl_mode].name);
	  
	  color {
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	     foregroundColor = "black";
	  };
	};
	
      };

      group Parameters {
	link parent => <-.active_map_win_panel;

	LIBMPU.WANDLIB.MPUEventAPIMods.ui_info &placement => <-.parameters_col_placement;
	int num_mappings<NEportLevels={2,0}> => <-.num_mappings;
	int row_height<NEportLevels={2,0}> => <-.row_height;
	
	UIpanel panelParameters {
	  parent => <-.parent;
	  x => <-.placement.x;
	  y => <-.placement.y;
	  width => <-.placement.width;
	  height => <-.placement.height;
	  color {
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	     backgroundColor = "gray";
#endif
	    foregroundColor = "black";
	  };
	};

	int do_array[.num_mappings];
	int is_do => sum(do_array);

	GMOD.parse_v reset_do_array {
	  relative => <-;
	  trigger => <-.num_mappings;
	  on_inst = 1;
	  no_errors = 1;
	  v_commands = "do_array = init_array(.num_mappings,0,0);";
	};
	
	int do = 0;
	
	UIbutton param_editor_launch[.num_mappings] {
	  parent => <-.panelParameters;
	  int ind => index_of(param_editor_launch);
	  x = 0;
	  y => (<-.row_height * ind);
	  width = 22;
	  label = "...";
	  message = "Edit this mapping";
	  do => <-.do_array[ind];
	  int val => (.do * (ind+1));
	};

	int launch_val_array[.num_mappings] => param_editor_launch.val;
	int launch_val = 0;
	int which_val = 0;
	
	int show_edit_mapping_shell => <-.<-.show_edit_mapping_shell;
	int which_mapping => <-.<-.active_config.mapping_ids[which_val].index;

	GMOD.parse_v launch_param_edit {
	  relative => <-;
	  trigger => <-.is_do;
	  on_inst = 0;
	  active => switch( is_valid(<-.is_do)+1, 0, 1 );
	  no_errors = 1;
	  v_commands = "launch_val_array => param_editor_launch.val; launch_val => (max_array( launch_val_array ) -1); which_val = launch_val; show_edit_mapping_shell = is_do; do_array = init_array( .num_mappings,0,0 );";
	};
      };
      
      group Details {
	link parent => <-.active_map_win_panel;

	LIBMPU.WANDLIB.MPUEventAPIMods.ui_info &placement => <-.details_col_placement;
	int num_mappings<NEportLevels={2,0}> => <-.num_mappings;
	int row_height<NEportLevels={2,0}> => <-.row_height;
	
	UIpanel panelDetails {
	  parent => <-.parent;
	  x => <-.placement.x;
	  y => <-.placement.y;
	  width => <-.placement.width;
	  height => <-.placement.height;
	  color {
	    foregroundColor = "black";
#ifdef MSDOS
	     backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	  };
	};

	UIlabel mapping_details[active_config.num_mappings] {
	  parent => <-.panelDetails;
	  x = 2;
	  y => (<-.row_height * index_of(<-.mapping_details));
	  width => (parent.width - 4);
	  label => <-.<-.<-.ev_man.mappings[<-.<-.<-.active_config.mapping_ids[index_of(<-.mapping_details)].index].detail;
	  color {
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	    backgroundColor = "gray";
#endif
	     foregroundColor = "black";
	  };
	};

      };
    };

    group Actions {
      
      link group_parent<NEportLevels={1,1}> => <-.parent;
      
      UIpanel panel_row3 {
	parent => <-.group_parent;
	x = 0;
	y = 425;
	width => .parent.clientWidth;
	height = 95;		// Decreased from 300
      };
      
      UIframe frame_row3 {
	x = 0;
	y = 0;
	parent => <-.panel_row3;
	width => .parent.clientWidth;
	height => .parent.clientHeight;
      };

      link parent => .frame_row3;
    
      LIBMPU.WANDLIB.MPUEventAPIMods.nUIlabel row3_title {
	parent => <-.parent;
	x = 2;
	y = 0;
	width => .parent.clientWidth;
	color {
#ifdef MSDOS
	   foregroundColor = "white";
	   backgroundColor = "gray";
#else
	   foregroundColor = "blue";
	   backgroundColor = "gray";
#endif
	};
	alignment = "left";
	label = "Actions:";
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.nUIbutton show_submit_mapping_shell {
	parent => <-.parent;
	x = 22;
	y = 30;
	width = 140;
	height = 30;
	color {
	  foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	  backgroundColor = "gray";
#endif
	};
	label = "New Mapping";
	message = "Create new mappings in Active Configuration";
	active => num_configs;
	do => <-.<-.show_submit_mapping_shell;
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.nUIbutton delete_mappings {
	parent => <-.parent;
	x => (22 + <-.show_submit_mapping_shell.rx);
	y = 30;
	width = 140;
	height = 30;
	color {
	  foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	  backgroundColor = "gray";
#endif
	};
	label = "Delete Mappings";
	message = "Delete selected (X toggle) mappings from Active Configuration";
	active => num_configs;
	do => <-.<-.go_delete_mappings;
      };

      LIBMPU.WANDLIB.MPUEventAPIMods.nUIbutton load_settings {
	parent => <-.parent;
	x => (22 + <-.delete_mappings.rx);
	y = 30;
	width = 140;
	height = 30;
	color {
	  foregroundColor = "black";
#ifdef MSDOS
	   backgroundColor = "light gray";
#else
	   backgroundColor = "gray";
#endif
	};
	label = "Load Settings";
	message = "Load configurations from file";
      };

      UIfileDialog load_dialog {
	title = "Load Event Settings";
	visible => <-.load_settings.do;
	filename => <-.<-.filename_load_settings;
	searchPattern = "*.evm";
	ok => <-.<-.go_load_settings;
      };
      
      LIBMPU.WANDLIB.MPUEventAPIMods.nUIbutton save_settings {
	parent => <-.parent;
	x => (22 + <-.load_settings.rx);
	y = 30;
	width = 140;
	height = 30;
	active => num_configs;
	color {
	  foregroundColor = "black";
#ifdef MSDOS
	 backgroundColor = "light gray";
#else
	  backgroundColor = "gray";
#endif
	};
	label = "Save Settings";
	message = "Save all configurations to file";
      };

      UIfileDialog save_dialog {
	title = "Save Event Settings";
	visible => <-.save_settings.do;
	filename => <-.<-.filename_save_settings;
	searchPattern = "*.evm";
	ok => <-.<-.go_save_settings;
	confirmFileWrite = 1;
      };
    };
  };
};
