#define MPE_TEST_BUTTONS 1

flibrary+global+sort MPUEventAPIMods<cxx_name="",
                                     build_dir="wand/ev_api",
#ifdef MSDOS
                                     link_files="-lwand",
#else
                                     dyn_libs="libwand",
#endif
				     use_src_file=0,
				     cxx_hdr_files="wand/fmp_comm/fmpc_gen.hxx",
				     out_hdr_file="evapi_gen.hxx",
                                     out_src_file="evapi_gen.cxx"> {

  // MPU Event API Code

  // Principle components
  // 1. Button Matrix Management
  // 2. Mapping Shell Management
  // 3. Configuration Management

  // (1) Button Matrix Management

  group ui_geom {
    int x;
    int y;
    int w;
    int h;
  };

  group ui_wh {
    int w;
    int h;
  };

  UIbutton nUIstate_button {
    int state;
  };

  group ui_scheme {
    UIcolor panel_scheme;
    UIcolor label_scheme;
    UIcolor heading_scheme;
    UIcolor button_scheme;
    UIcolor entry_scheme;
    UIcolor pulldown_scheme;
    UIcolor matrix_scheme[];
  };
  
  module bm_manager {

    // inputs	      
    int nbuttons<NEportLevels={2,0}>;
    int set_to_state<NEportLevels={2,0}>;
    int mode<NEportLevels={2,0}>;
    
    // inputs and outputs
    int do_array<NEportLevels={0,2}>[nbuttons];
    int state_array<NEportLevels={0,2}>[nbuttons];

    // outputs
    int state_value<NEportLevels={2,0}>;

    cxxmethod+notify_inst manager (
      nbuttons+read+notify+req,
      set_to_state+read+notify+req,
      mode+read+notify+req,
      do_array+read+notify+req+write,
      state_array+read+notify+req+write,
      state_value+write
    );
  };

  macro ButtonMatrixPanel {

    link parent<NEportLevels={2,1}>;
    ui_geom &geom<NEportLevels={2,0}>;
    ui_wh &size<NEportLevels={2,0}>;
    
    int nbuttons<NEportLevels={2,0}>;

    ui_scheme &scheme<NEportLevels={2,0}>;
    
    UIpanel panel<NEportLevels={0,2}> {
      parent => <-.parent;
      x => <-.geom.x;
      y => <-.geom.y;
      width => <-.geom.w;
      height => <-.geom.h;
      color {
	foregroundColor => <-.<-.scheme.panel_scheme.foregroundColor;
	backgroundColor => <-.<-.scheme.panel_scheme.backgroundColor;
      };
    };

    // auto-arrange calculations
    int n_in_x => (.panel.clientWidth / .size.w);
    int nx => min_array( {.n_in_x,.nbuttons} );
    int ny => ((.nbuttons / .n_in_x) + 1);

    int xord[.nx] => init_array( .nx, 0, ((.nx-1)*.size.w) );
    int yord[.ny] => init_array( .ny, 0, ((.ny-1)*.size.h) );

    // button do array and button state array

    int &do_arr<NEportLevels={2,1}>[nbuttons];
    int &state_arr<NEportLevels={2,1}>[nbuttons];

    // multi-state buttons
    nUIstate_button btn[nbuttons] {
      parent => <-.panel;
	
      do => <-.do_arr[index_of(btn)];
      int state => <-.state_arr[index_of(btn)];
	
      color {
	&foregroundColor => <-.<-.scheme.matrix_scheme[<-.state].foregroundColor;
	&backgroundColor => <-.<-.scheme.matrix_scheme[<-.state].backgroundColor;
      };
	
      x => <-.xord[ index_of(btn) % <-.nx ];
      y => <-.yord[ index_of(btn) / <-.nx ];

      width => <-.size.w;
      height => <-.size.h;
      
      label => str_format( "%d", (index_of(btn)+1) );
    };
  };

  // (2) Manage Mapping Shell   
  
  group MPUev_mask {
    int down;
    int up;
    int motion;
    int valuators;
    float valuator_scale;
  };

  group MPUev_handler_mode {
    int id;
    string name;
  };

  group MPUev_handler_param {
    int id;
    string name;
    int type;
    prim value;
  };
  
  group MPUev_handler {
    int id;
    string name;
    int num_modes;
    MPUev_handler_mode modes[num_modes];
    int num_params;
    MPUev_handler_param params[num_params];
  };

  group MPUev_mapping {
    int id;
    string name;
    int handler_id;
    int handler_index;
    int handler_mode;
    MPUev_mask required;
    MPUev_mask invalid;
    int handler_num_params;
    MPUev_handler_param params[handler_num_params];
    int active;
    string detail;
  };

  group MPUev_mapping_id {
    int id;
    int index;
  };
  
  group MPUev_config {
    int id;
    string name;
    int num_mappings;
    MPUev_mapping_id mapping_ids[num_mappings];
  };

  group MPUev_manager {
    int num_buttons;
    int num_valuators;
    
    int num_handlers;
    int num_mappings;
    int num_configs;
    MPUev_handler handlers[num_handlers];
    MPUev_mapping mappings[num_mappings];
    MPUev_config configs[num_configs];
    int active_config_id;
    int active_config_index;
  };

  group mms_params<NEportLevels={0,1}> {

    int nbuttons<NEportLevels={0,2}>;
    int nvaluators<NEportLevels={0,2}>;
    
    string map_name<NEportLevels={2,2}>;
    int map_handler<NEportLevels={2,2}>;
    int map_handler_mode<NEportLevels={2,2}>;

    int map_num_handlers<NEportLevels={0,2}>;
    string map_handler_options<NEportLevels={0,2}>[map_num_handlers];
    int map_num_modes<NEportLevels={0,2}>;
    string map_mode_options<NEportLevels={0,2}>[map_num_modes];

    float map_val_scale<NEportLevels={2,2}>;
    
    int map_down_state<NEportLevels={2,2}>;
    int map_motion_state<NEportLevels={2,2}>;
    int map_up_state<NEportLevels={2,2}>;
    int map_val_nbuttons<NEportLevels={2,2}>;
    int map_val_mode<NEportLevels={2,2}>;
    int map_val_state<NEportLevels={2,2}>;

    int map_set_down_state<NEportLevels={2,2}>;
    int map_set_motion_state<NEportLevels={2,2}>;
    int map_set_up_state<NEportLevels={2,2}>;
    int map_set_val_state<NEportLevels={2,2}>;

    int map_num_params<NEportLevels={0,2}>;
    MPUev_handler_param map_params<NEportLevels={0,2}>[map_num_params];
    
    int action_submit<NEportLevels={2,2}>;
    int action_reset<NEportLevels={2,2}>;
    int action_recall<NEportLevels={2,2}>;
    int recall_mapping_index<NEportLevels={2,2}>;
  };

  group menu_params {
    int set_selected_entry<NEportLevels={2,0}>;

    int num_entries<NEportLevels={0,2}>;
    string entries<NEportLevels={0,2}>[.num_entries];
    int menu_selected_entry<NEportLevels={0,2}>;
    int out_selected_entry<NEportLevels={0,2}>;
  };
	
  module menu_manager {

    // inputs

    MPUev_manager &ev_manager<NEportLevels={2,0}>;
    int num_entries<NEportLevels={2,0}>;

    // execution control
    int no_update;
    
    // parameter block i/o
    menu_params &params<NEportLevels={2,0}>;

    // method
    cxxmethod update(
      ev_manager+read+notify+req,
      num_configs+read+notify+req,
      params+read+notify+req+write
    );
  };
  
  module mms_manager {

    // inputs

    MPUev_manager &ev_manager<NEportLevels={2,0}>;
    int edit_mode<NEportLevels={2,0}>;
    int edit_mapping_index<NEportLevels={2,0}>;

    // parameter block i/o
    mms_params &mmsp<NEportLevels={2,0}>;

    // monitor
    int num_buttons => ev_manager.num_buttons;
    int num_valuators => ev_manager.num_valuators;
    
    // outputs
    MPUev_mapping+nosave edit_mapping<NEportLevels={0,2}>;
    int submit_mapping<NEportLevels={0,2}>;

    // method
    cxxmethod+notify_inst update(
      ev_manager+read+notify+req,
      edit_mode+read+notify+req,
      edit_mapping_index+read+notify+req,
      mmsp+read+notify+req+write,
      edit_mapping+write,
      submit_mapping+write
    );
  };
  
  // (3) Configuration Management

  // Modified UI components

  UIlabel nUIlabel {
    int rx => switch( is_valid(.width)+1, 1, .x + .width );
    int by => switch( is_valid(.height)+1, 1, .y + .height );
  };
  
  UIbutton nUIbutton {
    int rx => switch( is_valid(.width)+1, 1, .x + .width );
    int by => switch( is_valid(.height)+1, 1, .y + .height );
  };
  
  // ui component parameter block

  group ui_info {
    int x;
    int y;
    int width;
    int height;
  };

};

