flibrary+global+sort FMPcommMods <
   cxx_name="",
   build_dir="wand/fmp_comm",
#ifdef MSDOS
   link_files="-lwand",
#else
   dyn_libs="libwand",
#endif
   use_src_file=0,
   out_hdr_file="fmpc_gen.hxx",
   out_src_file="fmpc_gen.cxx",
   cxx_hdr_files="fld/Xfld.h avs/gd.h",
   libdeps="GD FLD"
   > {

  // parameter group

  group FMPCparams <NEportLevels={0,1}> {
    float z_translate<NEportLevels={2,2}>;
    //EVinfo &ev_manager_info<NEportLevels={2,2}>;
    WANDLIB.MPUEventAPIMods.MPUev_manager+nosave
        &ev_info<NEportLevels={2,2}>;
  };
				 
  // reference version of param group

  FMPCparams &FMPCparams_ref <NEportLevels={1,1}> {
    float z_translate<NEportLevels={0,2}>;
    //EVinfo &ev_manager_info<NEportLevels={0,2}>;
    WANDLIB.MPUEventAPIMods.MPUev_manager+nosave
        &ev_info<NEportLevels={0,2}>;
  };
  
  // Wand parameter group
  group FMPCwand <NEportLevels={0,1}> {
     int num_buttons<NEportLevels={2,2}>;
     int num_valuators<NEportLevels={2,2}>;  
     float pos_x<NEportLevels={0,2}>;
     float pos_y<NEportLevels={0,2}>;
     float pos_z<NEportLevels={0,2}>;
     float rot_x<NEportLevels={0,2}>;
     float rot_y<NEportLevels={0,2}>;
     float rot_z<NEportLevels={0,2}>;
     float scale<NEportLevels={0,2}>;
     int   rnc<NEportLevels={0,2}>;
     int+nosave   vrm_state<NEportLevels={0,2}>;
     group buttons<NEportLevels={2,2}>[num_buttons]{int val;};
     group valuators<NEportLevels={2,2}>[num_valuators]{float val;};
     group+nosave single_click<NEportLevels={2,2}>[num_buttons]{int val;};
     group+nosave double_click<NEportLevels={2,2}>[num_buttons]{int val;};
	  
  };
  
  // Wand parameter group reference version
  group &FMPCwand_ref <NEportLevels={1,1}> {
     int num_buttons<NEportLevels={0,2}>;
     int num_valuators<NEportLevels={0,2}>;  
     float pos_x<NEportLevels={0,2}>;
     float pos_y<NEportLevels={0,2}>;
     float pos_z<NEportLevels={0,2}>;
     float rot_x<NEportLevels={0,2}>;
     float rot_y<NEportLevels={0,2}>;
     float rot_z<NEportLevels={0,2}>;
     float scale<NEportLevels={0,2}>;
     int   rnc<NEportLevels={0,2}>;
     int   vrm_state<NEportLevels={0,2}>;
     group buttons<NEportLevels={0,2}>[num_buttons]{int val;};
     group valuators<NEportLevels={0,2}>[num_valuators]{float val;};
     group single_click<NEportLevels={0,2}>[num_buttons]{int val;};
     group double_click<NEportLevels={0,2}>[num_buttons]{int val;};
  };

  // New mapping parameter group

  WANDLIB.MPUEventAPIMods.MPUev_mapping FMPCnmap <NEportLevels={0,1}>;
  FMPCnmap &FMPCnmap_ref<NEportLevels={1,1}>;
  
  // New config parameter group

  WANDLIB.MPUEventAPIMods.MPUev_config FMPCncfg <NEportLevels={0,1}>;
  FMPCncfg &FMPCncfg_ref<NEportLevels={1,1}>;
  
  // Modules
  // -------
  // GD items have export_cxx=0 to prevent GD classes being defined in
  // our gen file. This would cause problems for users deriving projects
  // from MPE.

  // Select an object's xform (normal, alt, parent) depending on xform_mode
  module MPExform_select {
     int ignore_xform_mode = 0; // 1 means just get object's normal xform
     GDobject_templ *obj<export_cxx=0,NEportLevels={2,0}>;
     GDxform_templ &xform<export_cxx=0,NEportLevels={0,2}>;

     cxxmethod+notify_inst update(
	ignore_xform_mode+read+notify,
	obj+read+notify+req,
	obj.xform_mode+notify,
	xform+write
     );
  };

  // Main module to process EV Manager UI and communicate with MPU threads
  module FMPCcore<
     cxx_members="void *fp_ptr; int cfg_i; int map_i; char *tmp_fn; int tmp_load; int first_mpu;\n",
     cxx_members_constr="tmp_fn(0), tmp_load(0), first_mpu(1)"> {
    GDview_templ &view_in <export_cxx=0,NEportLevels={2,2}>;
    FMPCparams_ref &params<NEportLevels={2,0}>;
    FMPCwand wand<NEportLevels={0,2}>;

    FMPCnmap_ref &n_mapping<NEportLevels={2,0}>;
    int n_mapping_submit<NEportLevels={2,0}>;

    FMPCncfg_ref &n_config<NEportLevels={2,0}>;
    int n_config_submit<NEportLevels={2,0}>;

    FMPCnmap_ref &e_mapping<NEportLevels={2,0}>;
    int e_mapping_submit<NEportLevels={2,0}>;

    int selected_config_id<NEportLevels={2,0}>;

    // individual mapping id's for mapping actions
    int &action_map_id<NEportLevels={2,0}>[];

    // activation toggle set and do arrays
    int &activation_do<NEportLevels={2,0}>[];
    int &activation_set<NEportLevels={2,0}>[];

    // deletion toggle set array and trigger
    int &deletion_set<NEportLevels={2,0}>[];
    int go_delete_mappings<NEportLevels={2,0}>;
    
    // active config deletion
    int go_delete_active_config<NEportLevels={2,0}>;

    // load and save entire settings
    int &go_load_settings<NEportLevels={2,0}>;
    string &filename_load_settings<NEportLevels={2,0}>;
    int &go_save_settings<NEportLevels={2,0}>;
    string &filename_save_settings<NEportLevels={2,0}>;
    
    // full ui refresh trigger
    int refresh_update = 0;
    int in_update = 0;

    // FMP core management
    int renderer => .view_in.renderer;
    ptr local_ptr => .view_in.local_ptr;
    ptr mpu_module_api;

    // User interface control
    int allow_visibility<NEportLevels={0,2}>;
    int use_user_def<NEportLevels={2,0}>;
    int user_num_buttons<NEportLevels={2,0}>;
    int user_num_valuators<NEportLevels={2,0}>;

    // KGT Extras
    int   filter_valuators<NEportLevels={2,0}>;
    float filter<NEportLevels={2,0}>;
    int	  scale_filtered<NEportLevels={2,0}>;
    string m_to_d<NEportLevels={2,0}>;
    
    // method to update the attached ev_info group
    
    cxxmethod+notify_inst update(
      renderer+read+notify+req,
      params+read+notify+req,
      use_user_def+read,
      user_num_buttons+read,
      user_num_valuators+read,
      filter_valuators+read+notify,
      filter+read+notify,
      scale_filtered+read+notify,
      m_to_d+read+notify,
      local_ptr+read+notify+req,
      refresh_update+read+notify+req,
      wand+write,
      mpu_module_api+write,
      allow_visibility+write
    );

    cxxmethod+notify_deinst destroy();
    
    cxxmethod submit_mapping(
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      n_mapping+read+req,
      n_mapping_submit+read+notify+req+write,
      refresh_update+write
    );

    cxxmethod edit_mapping(
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      e_mapping+read+req,
      e_mapping_submit+read+notify+req+write,
      refresh_update+write
    );

    cxxmethod delete_mappings(
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      deletion_set+read+req,
      go_delete_mappings+read+notify+req,
      action_map_id+read+req,
      refresh_update+write
    );

    cxxmethod delete_active_config(
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      go_delete_active_config+read+notify+req,
      refresh_update+write
    );

    cxxmethod submit_config(
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      n_config+read+notify+req,
      n_config_submit+read+notify+req+write,
      refresh_update+write
    );

    cxxmethod select_config(
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      selected_config_id+read+notify+req,
      refresh_update+write
    );

    cxxmethod config_activation (
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      activation_do+read+notify+req,
      activation_set+read+notify+req,
      action_map_id+read+notify+req,
      refresh_update+write
    );

    cxxmethod load_settings(
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      go_load_settings+read+notify+req,
      filename_load_settings+read+req,
      refresh_update+write
    );

    cxxmethod save_settings(
      renderer+read+notify+req,
      local_ptr+read+notify+req,
      fp_ptr+write,
      go_save_settings+read+notify+req,
      filename_save_settings+read+req,
      refresh_update+write
    );
  };
};
