/****************************************************************************
 *                                                                          *
 * msdl2vrml is intended to be a filter program which parses an MSDL file   *
 * (using the yacc & lex parser) and spits out valid VRML. All the          *
 * conversion code is contained within the file filter.c.                   *
 * This program was written at the Computer Graphics Unit, University of    *
 * Manchester, and has been released into the public domain. This is not a  *
 * supported product, and the CGU cannot guarantee to provide any help with *
 * its use. However, as we use this code ourselves, we are interested in    *
 * feedback, which should be directed to cgu-info@mcc.ac.uk                 *
 *                                                                          *
 * Version 0.1a    - Written by Sheena Bryden                               *
 *                                                                          *
 ****************************************************************************/

#include <stdio.h>
#include <sysexits.h>

#ifdef __cplusplus
#include <stdlib.h>
#endif
 
#include "msdl_types.h" 
#include "msdl_macros.h"
#include "msdl_protos.h"
#include "filter.c"
extern void yyerror(char *errmess);

main(int argc, char *argv[])
{
  FILE *instream,
       *outstream;
  char *usage = "usage: %s <infile>\n",
       *progname = argv[0];
  char *opencommand;
  char input_pipe[200];

  if ( argc != 2 ) /* must supply input and output file names */ {
    fprintf( stderr, usage, progname );
    exit( EX_USAGE );

  } else {
    
    /* open the input file for reading using the cpp preprocessor */
    sprintf( input_pipe, "/lib/cpp -P %s\n", argv[1]);
    
    instream = popen( input_pipe, "r" ); /* open the input file for reading
					    using the cpp preprocessor */

    if ( instream == NULL ) {
      fprintf( stderr, "could not open file %s\n", argv[1]);
      exit(0);
    }
    
    msdl( instream );     /* pass the file to the parser */
    
    pclose( instream );   /* close the input file  */
    /* FINISH THIS!          close the output file */
    
    msdl_init();          /* re-initialise the parser */
  }
}



















