#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
 
#include "avskhoros.h"
#include "proto.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/
int vadd_desc()
{

	int in_port, out_port, param;
	extern int vadd_compute();

	AVSset_module_name("vadd", MODULE_FILTER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input1", "field 2D", REQUIRED);
	in_port = AVScreate_input_port("input2", "field 2D", REQUIRED);
	in_port = AVScreate_input_port("mask", "field 2D", OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("output", "field 2D");

	AVSset_compute_proc(vadd_compute);

	return(1);
}
 
int vsub_desc()
{

        int in_port, out_port, param;
        extern int vsub_compute();

        AVSset_module_name("vsub", MODULE_FILTER);

        /* Input Port Specifications               */
        in_port = AVScreate_input_port("input1", "field 2D", REQUIRED);
        in_port = AVScreate_input_port("input2", "field 2D", REQUIRED);
        in_port = AVScreate_input_port("mask", "field 2D", OPTIONAL);

        /* Output Port Specifications              */
        out_port = AVScreate_output_port("output", "field 2D");

        AVSset_compute_proc(vsub_compute);

        return(1);
}

int vmul_desc()
{

   int in_port, out_port, param;
   extern int vmul_compute();

   AVSset_module_name("vmul", MODULE_FILTER);

   /* Input Port Specifications               */
   in_port = AVScreate_input_port("input1", "field 2D", REQUIRED);
   in_port = AVScreate_input_port("input2", "field 2D", REQUIRED);
   in_port = AVScreate_input_port("mask", "field 2D", OPTIONAL);

   param = AVSadd_parameter("Arithmetic","choice","Scalar","Scalar|Complex","|");

   /* Output Port Specifications              */
   out_port = AVScreate_output_port("output", "field 2D");

   AVSset_compute_proc(vmul_compute);

        return(1);
}

int vdiv_desc()
{

   int in_port, out_port, param;
   extern int vdiv_compute();

   AVSset_module_name("vdiv", MODULE_FILTER);

   /* Input Port Specifications               */
   in_port = AVScreate_input_port("input1", "field 2D", REQUIRED);
   in_port = AVScreate_input_port("input2", "field 2D", REQUIRED);
   in_port = AVScreate_input_port("mask", "field 2D", OPTIONAL);

   param = AVSadd_parameter("Arithmetic","choice","Scalar","Scalar|Complex","|");

   /* Output Port Specifications              */
   out_port = AVScreate_output_port("output", "field 2D");

   AVSset_compute_proc(vdiv_compute);

   return(1);
}

int vabsdiff_desc()
{

        int in_port, out_port, param;
        extern int vabsdiff_compute();

        AVSset_module_name("vabsdiff", MODULE_FILTER);

        /* Input Port Specifications               */
        in_port = AVScreate_input_port("input1", "field 2D", REQUIRED);
        in_port = AVScreate_input_port("input2", "field 2D", REQUIRED);
        in_port = AVScreate_input_port("mask", "field 2D", OPTIONAL);

        /* Output Port Specifications              */
        out_port = AVScreate_output_port("output", "field 2D");

        AVSset_compute_proc(vabsdiff_compute);

        return(1);
}

int vblend_desc()
{

   int in_port, out_port, param;
   extern int vblend_compute();

   AVSset_module_name("vblend", MODULE_FILTER);

   /* Input Port Specifications               */
   in_port = AVScreate_input_port("input1", "field 2D", REQUIRED);
   in_port = AVScreate_input_port("input2", "field 2D", REQUIRED);
   in_port = AVScreate_input_port("mask", "field 2D", OPTIONAL);

   param = AVSadd_parameter("Use Mask","boolean",0,0,1);
   param = AVSadd_float_parameter("Blend Ratio",0.5,0.0,1.0);

   /* Output Port Specifications              */
   out_port = AVScreate_output_port("output", "field 2D");

   AVSset_compute_proc(vblend_compute);

   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/
int vadd_compute( input1, input2, mask,output )
	AVSfield *input1;
	AVSfield *input2;
	AVSfield *mask;
	AVSfield **output;
{
	struct xvimage *i1,*i2,*m,o;
	int use,value;
	
	COMPARE_IMAGE(input1,input2)

	if ((i1=(struct xvimage *)field_to_viff(input1))==NULL) return (0);
	if ((i2=(struct xvimage *)field_to_viff(input2))==NULL) return (0);

	if (mask)
   	{ 
	   if ((m=(struct xvimage *)field_to_viff(mask))==NULL) return (0);
	   use=1;
	} else use=0;
	
	value=(int)lvadd(i1,i2,m,use);

	if (((*output)=(AVSfield *)viff_to_field(i1))==NULL) return (0);

	return(value);
}
 
int vsub_compute( input1, input2, mask, output)
        AVSfield *input1;
        AVSfield *input2;
	AVSfield *mask;
        AVSfield **output;
{
        struct xvimage *i1,*i2,*m,o;
        int use,value;

	COMPARE_IMAGE(input1,input2)

        if ((i1=(struct xvimage *)field_to_viff(input1))==NULL) return (0);
        if ((i2=(struct xvimage *)field_to_viff(input2))==NULL) return (0);

        if (mask)
        {
           if ((m=(struct xvimage *)field_to_viff(mask))==NULL) return (0);
           use=1;
        } else use=0;

        value=(int)lvsub(i1,i2,m,use);

        if (((*output)=(AVSfield *)viff_to_field(i1))==NULL) return (0);

        return(value);
}

int vmul_compute( input1, input2, mask, output, which)
        AVSfield *input1;
        AVSfield *input2;
	AVSfield *mask;
        AVSfield **output;
	int which;
{
        struct xvimage *i1,*i2,*m,o;
        int use,value;

	COMPARE_IMAGE(input1,input2)
	
        if ((i1=(struct xvimage *)field_to_viff(input1))==NULL) return (0);
        if ((i2=(struct xvimage *)field_to_viff(input2))==NULL) return (0);

        if (mask)
        {
           if ((m=(struct xvimage *)field_to_viff(mask))==NULL) return (0);
           use=1;
        } else use=0;

        value=(int)lvmul(i1,i2,m,use,which);

        if (((*output)=(AVSfield *)viff_to_field(i1))==NULL) return (0);

        return(value);
}

int vdiv_compute( input1, input2, mask, output, which)
        AVSfield *input1;
        AVSfield *input2;
	AVSfield *mask;
        AVSfield **output;
	int which;
{
        struct xvimage *i1,*i2,*m,o;
        int use,value;

	COMPARE_IMAGE(input1,input2)

        if ((i1=(struct xvimage *)field_to_viff(input1))==NULL) return (0);
        if ((i2=(struct xvimage *)field_to_viff(input2))==NULL) return (0);

        if (mask)
        {
           if ((m=(struct xvimage *)field_to_viff(mask))==NULL) return (0);
           use=1;
        } else use=0;

        value=(int)lvdiv(i1,i2,m,use,which);

        if (((*output)=(AVSfield *)viff_to_field(i1))==NULL) return (0);

        return(value);
}

int vabsdiff_compute( input1, input2, mask, output)
        AVSfield *input1;
        AVSfield *input2;
	AVSfield *mask;
        AVSfield **output;
{
        struct xvimage *i1,*i2,*m,o;
        int use,value;

	COMPARE_IMAGE(input1,input2)

        if ((i1=(struct xvimage *)field_to_viff(input1))==NULL) return (0);
        if ((i2=(struct xvimage *)field_to_viff(input2))==NULL) return (0);

        if (mask)
        {
           if ((m=(struct xvimage *)field_to_viff(mask))==NULL) return (0);
           use=1;
        } else use=0;

        value=(int)lvabsdiff(i1,i2,m,use);

        if (((*output)=(AVSfield *)viff_to_field(i1))==NULL) return (0);

        return(value);
}

float x;

int vblend_compute( input1, input2, mask, output, use, blend)
        AVSfield *input1;
        AVSfield *input2;
	AVSfield *mask;
        AVSfield **output;
	int use;
	float *blend;
{
   struct xvimage *i1,*i2,*m,*images[2];
   int value;
   char *program="vblend";
   float b;

   if ((i1=(struct xvimage *)field_to_viff(input1))==NULL) return (0);
   if ((i2=(struct xvimage *)field_to_viff(input2))==NULL) return (0);

   if (mask)
   {
      if ((m=(struct xvimage *)field_to_viff(mask))==NULL) return (0);
   } 
   else use=0;

   images[0]=i1;
   images[1]=i2;

   (void) proper_num_images(program,i1,1,TRUE); 
   (void) match_num_images(program,i1,i2,TRUE); 
   
   (void) proper_num_bands(program,i1,1,TRUE); 
   (void) match_num_bands(program,i1,i2,TRUE); 
   
   (void) proper_map_enable(program,i1,VFF_MAP_OPTIONAL,TRUE); 
   (void) match_map_enable(program,i1,i2,TRUE); 
   
   (void) matchsize(program,i1,i2,TRUE);

   if (mask)            /* check input mask image */
   {
      if (m->data_storage_type != VFF_TYP_FLOAT)
      {
         /* If mask image not FLOAT, then convert it to FLOAT */
         if (!lvconvert(m, 5, 0, 1, 0.0, 1.0))
         {
            (void) fprintf(stderr,"ERROR: lvconvert failed\n");
            return(0);
         }
      }
      if (m->row_size != i1->row_size ||
          m->col_size != i1->col_size)
      {
         fprintf(stderr,"vblend: blend mask must have same number of rows and cols as input images\n");
         return(0);
      }
   }

   			/*  Call lvcast to upconvert data types */
   if (! lvcast(images, 2, -1) )
   {
      (void) fprintf(stderr, "ERROR: images could not be cast to the same type\n");
      return(0);
   }

   x= *blend;

   value=(int)lvblend(i1,i2,m,use);

   if (((*output)=(AVSfield *)viff_to_field(i1))==NULL) return (0);

   return(value);
}

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	vadd_desc,
	vsub_desc,
	vmul_desc,
	vdiv_desc,
	vabsdiff_desc,
	vblend_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
