#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"
#include "feature.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vfractal_desc ()
{
   int in_port, out_port, param;
   extern int vfractal_compute();

   AVSset_module_name("vfractal",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("region size","integer",1,1,15);
   AVSadd_parameter("window size","integer",1,1,512);
   AVSadd_parameter("step size","integer",1,1,512);

   AVSset_compute_proc(vfractal_compute);
   return(1);
}

int vpml_desc ()
{
   int in_port, out_port, param;
   extern int vpml_compute();

   AVSset_module_name("vpml",MODULE_FILTER);

   AVScreate_input_port("Input Image      ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image     ","field 2D");
   AVScreate_output_port("Output FD Image  ","field 2D");
   ADD_FILE;
   AVSadd_parameter("lower window","integer",3,3,10000);
   AVSadd_parameter("upper window","integer",5,5,10000);
   AVSadd_parameter("step size","integer",2,2,10000);
   AVSadd_parameter("moment range","integer",3,3,1000);

   AVSset_compute_proc(vpml_compute);
   return(1);
}

int vpolygon_desc ()
{
   int in_port, out_port, param;
   extern int vpolygon_compute();

   AVSset_module_name("vpolygon",MODULE_FILTER);

   AVScreate_input_port("Input Edge Image","field 2D",REQUIRED);
   AVScreate_output_port("Output Vector Image","field 2D");
   AVScreate_output_port("Output Polygons Image","field 2D");
   AVSadd_float_parameter("elim percent",0.1,0.0,1.0);
   AVSadd_float_parameter("approx error",0.6,0.0,2.0);
   AVSadd_parameter("min seg len","integer",2,2,10);

   AVSset_compute_proc(vpolygon_compute);
   return(1);
}

int vrmatch_desc ()
{
   int in_port, out_port, param;
   extern int vrmatch_compute();

   AVSset_module_name("vrmatch",MODULE_FILTER);

   AVScreate_input_port("First Input  Image","field 2D",REQUIRED);
   AVScreate_input_port("Second Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(vrmatch_compute);
   return(1);
}

int vshape_desc ()
{
   int in_port, out_port, param;
   extern int vshape_compute();

   AVSset_module_name("vshape",MODULE_FILTER);

   AVScreate_input_port("Clust/Label Image","field 2D",OPTIONAL);
   AVScreate_input_port("Grey Level  Image","field 2D",OPTIONAL);
   AVScreate_output_port("Axis Image    ","field 2D");
   AVScreate_output_port("Outline Image ","field 2D");
   AVScreate_output_port("VIFF File     ","field 2D");
   ADD_FILE;
   AVSadd_parameter("smoments","choice","standard moments","standard moments,not necessary",",");
   AVSadd_parameter("cmoments","choice","central moments","central moments,not necessary",",");
   AVSadd_parameter("imoments","choice","invariant moments","invariant moments,not necessary",",");
   AVSadd_parameter("axis","choice","X&Y moments","X&Y moments,principal axis",",");
   AVSadd_parameter("ocolor","choice","white","white,region number",",");

   AVSset_compute_proc(vshape_compute);
   return(1);
}

int vspatial_desc ()
{
   int in_port, out_port, param;
   extern int vspatial_compute();

   AVSset_module_name("vspatial",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("width","integer",1,1,512);
   AVSadd_parameter("height","integer",1,1,512);
   AVSadd_parameter("Mean","boolean",0,0,1);
   AVSadd_parameter("Variance","boolean",0,0,1);
   AVSadd_parameter("Contrast","boolean",0,0,1);
   AVSadd_parameter("Ang. 2nd Moment","boolean",0,0,1);
   AVSadd_parameter("Entropy","boolean",0,0,1);
   AVSadd_parameter("Dispersion","boolean",0,0,1);

   AVSset_compute_proc(vspatial_compute);
   return(1);
}

int vstereo_desc ()
{
   int in_port, out_port, param;
   extern int vstereo_compute();

   AVSset_module_name("vstereo",MODULE_FILTER);

   AVScreate_input_port("Input  Matched Image","field 2D",REQUIRED);
   AVScreate_output_port("Output  Depth  Image","field 2D");
   AVSadd_float_parameter("Focal Length",0.000000,30.0,100.0);
   AVSadd_float_parameter("Image Length",0.000000,10.0,30.0);
   AVSadd_float_parameter("Image Height",0.000000,10.0,30.0);
   AVSadd_float_parameter("Camera Disp",0.000000,10.0,30.0);
   AVSadd_float_parameter("Max Dist",0.000000,10.0,30.0);

   AVSset_compute_proc(vstereo_compute);
   return(1);
}

int vtexture_desc ()
{
   int in_port, out_port, param;
   extern int vtexture_compute();

   AVSset_module_name("vtexture",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("kernel","choice","L5L5","L5L5 L5E5 L5S5 L5W5 L5R5 E5L5 E5E5 E5S5 E5W5 E5R5 S5L5 S5E5 S5S5 S5W5 S5R5 W5L5 W5E5 W5S5 W5W5 W5R5 R5L5 R5E5 R5S5 R5W5 R5R5"," ");

   AVSset_compute_proc(vtexture_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vfractal_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvfractal(ki1,param1,param2,param3);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vpml_compute (	AVSfield *i1,AVSfield **o1,AVSfield **o2,
			char *fname,int lw,int uw,int wss,int rm)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
 
   FILE *fp;

   FILE_OPEN(fp,fname);

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvpml(ki1,ko1,ko2,fp,lw,uw,wss,rm);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
 
   FILE_CLOSE(fp,fname);

   return (value);
}
 
int vpolygon_compute (AVSfield *i1,AVSfield **o1,AVSfield **o2,float *param1,float *param2,int param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvpolygon(ki1,&ko2,(double)(*param1),(double)(*param2),param3);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
 
   return (value);
}
 
int vrmatch_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvrmatch(ki1,ki2,&ko1);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vshape_compute (	AVSfield *i1,AVSfield *i2,
			AVSfield **o1, AVSfield **o2,AVSfield **o3,
			char *fname,char *sm,char *cm,char *im,char *axis,char *oc)
{
   int value;
   int iim;
   int im_type;
   char *inputname;
   FILE *pdev;
   struct xvimage *inim;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

/* for lack of anything better, set default image type to i1, cluster obj */
   if (i1) im_type=0;
   else im_type=1;

/* again, i1 is default */
   if (i1) inim=ki1;
   else inim=ki2;
   
   value=(int)lvshape(	im_type,
			inim,
			AVSchoice_number("axis"),
			AVSchoice_number("ocolor"),
			1,
			&ko1,
			1,
			&ko2,
			1,
			&ko3,
			1,
			inputname,
			pdev,
			AVSchoice_number("smoments"),
			AVSchoice_number("cmoments"),
			AVSchoice_number("imoments"));
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
   if (((*o3)=(AVSfield *)viff_to_field(ko3))==NULL) return (0);
 
   return (value);
}
 
int vspatial_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3,int param4,int param5,int param6,int param7,int param8)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvspatial(ki1,param1,param2,param3,param4,param5,param6,param7,param8);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vstereo_compute (AVSfield *i1,AVSfield **o1,float *fl,float *il,float *ih,float *cd,float *md)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvstereo(ki1,ko1,*fl,*il,*ih,*cd,*md);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vtexture_compute (AVSfield *i1,AVSfield **o1,char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvtexture(ki1,
			KERNEL==0 ? 1 : 0,
			KERNEL==1 ? 1 : 0,
			KERNEL==2 ? 1 : 0,
			KERNEL==3 ? 1 : 0,
			KERNEL==4 ? 1 : 0,
			KERNEL==5 ? 1 : 0,
			KERNEL==6 ? 1 : 0,
			KERNEL==7 ? 1 : 0,
			KERNEL==8 ? 1 : 0,
			KERNEL==9 ? 1 : 0,
			KERNEL==10 ? 1 : 0,
			KERNEL==11 ? 1 : 0,
			KERNEL==12 ? 1 : 0,
			KERNEL==13 ? 1 : 0,
			KERNEL==14 ? 1 : 0,
			KERNEL==15 ? 1 : 0,
			KERNEL==16 ? 1 : 0,
			KERNEL==17 ? 1 : 0,
			KERNEL==18 ? 1 : 0,
			KERNEL==19 ? 1 : 0,
			KERNEL==20 ? 1 : 0,
			KERNEL==21 ? 1 : 0,
			KERNEL==22 ? 1 : 0,
			KERNEL==23 ? 1 : 0,
			KERNEL==24 ? 1 : 0 );
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vfractal_desc,
   vpml_desc,
   vpolygon_desc,
   vrmatch_desc,
   vshape_desc,
   vspatial_desc,
   vstereo_desc,
   vtexture_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

