 /*
  * Khoros: $Id: lvmarr.c,v 1.3 1992/03/20 23:06:37 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmarr.c,v 1.3 1992/03/20 23:06:37 dkhoros Exp $";
#endif

 /*
  * $Log: lvmarr.c,v $
 * Revision 1.3  1992/03/20  23:06:37  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmarr.c
 >>>>
 >>>>      Program Name: vmarr
 >>>>
 >>>> Date Last Updated: Tue Dec 10 15:35:21 1991 
 >>>>
 >>>>          Routines: lvmarr - the library call for vmarr
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmarr - library call for vmarr
*
* Purpose:
*    
*    Create a Marr type edge detection filter kernel.
*    
*    

* Input:
*    
*    image          pointer to VIFF structure containing image data to
*                   be processed.
*    
*    rows           number of rows in kernel.
*    
*    cols           number of columns in kernel.
*    
*    var            the variance of the Gaussian
*    
*    

* Output:
*    
*    image          pointer to VIFF structure  containing  image  data
*                   after processing.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Richard Krukar, John Rasure, Robert Estes
*    
*    John Rasure, Marcelo Teran, Ramiro Jordan, Tom Sauer 7/12/89
*                   changed the Laplacian of a Gaussian operator.  The
*                   new  operator  was taken from IEEE Transactions on
*                   Pattern Analysis and Machine Intelligence, Vol  11
*                   No. 4, April 1989.
*    
*    Jeremy Worley 7/02/90
*                   minor modifications to code so that it conforms to
*                   Khoros  conventions.   Added error check on kernel
*                   dimensions.  No functional changes.
*    
*    Robert Estes 4/25/90
*                   changed the code to implement a true LoG.
*    
*    

****************************************************************/


/* -library_def */
int
lvmarr ( image, rows, cols, var)
struct xvimage **image;
double var;
int rows, cols;
/* -library_def_end */

/* -library_code */
{
        char *program = "lvmarr";

        int i,j,x_cent,y_cent;
        double r2;
        float  *fptr;

        struct xvimage *kern, *createimage();

/*
** a little error checking here, please...
*/

        if(rows<=0 || cols<=0){
           fprintf(stderr,"%s:  Kernel dimension must be greater than 0\n",
                   program);
           return(0);
        }

/*
** thanks..
*/

        kern = createimage((unsigned long) rows, /* number of rows */
                        (unsigned long) cols,    /* number of columns */
                        (unsigned long)
                        VFF_TYP_FLOAT,           /* data_storage_type */
                        (unsigned long) 1,       /* num_of_images */
                        (unsigned long) 1,       /* num_data_bands */
                        "created by vmarr",      /* comment */
                        (unsigned long) 0,       /* map_row_size */
                        (unsigned long) 0,       /* map_col_size */
                        (unsigned long)
                        VFF_MS_NONE,             /* map_scheme */
                        (unsigned long)
                        VFF_MAPTYP_NONE,         /* map_storage_type */
                        (unsigned long)
                        VFF_LOC_IMPLICIT,        /* location_type */
                        (unsigned long) 0);      /* location_dim */

        if (kern == NULL)
        {
           (void)fprintf(stderr,"%s: Unable to allocate new image!\n",program);
           *image = NULL;
           return(0);
        }

        if (var == 0.0)
        {
            (void)fprintf(stderr,"%s: variance can not equal zero!\n",program);
            return(0);
        }

/* get the center point of the mask  */
        x_cent = cols/2;
        y_cent = rows/2;

        fptr = (float *) kern->imagedata;

/* crank out the kernel */
        for (i = 0; i < rows; i++)
        {
           for (j = 0; j < cols; j++)
           {
                 r2 = (double)((i-y_cent)*(i-y_cent)+(j-x_cent)*(j-x_cent));
                 *fptr++ =
                 (float)((0.5*r2/var-1.0)*exp(-r2/(2.0*var))/(XV_PI*var*var));

            }
        }

        *image = kern;
        return(1);
}
/* -library_code_end */
